/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997,98 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#if HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#if defined STDC_HEADERS || defined _LIBC
# include <stdlib.h>
# if defined HAVE_STRING_H
#  include <string.h>
# else
#  include <strings.h>
# endif
#endif
#if defined HAVE_UNISTD_H || defined _LIBC
# include <unistd.h>
#endif

#include "server.h"
#include "proto.h"		/* for k4 defaults */
#include "sm.h"			/* for storage manager defaults */
#include "dbfunc.h"
#include "read_configuration.h"

/* ----------------------------------------------------------------------
   GENERAL CONFIG READ FUNCTION
   ---------------------------------------------------------------------- */
int
read_configuration (char *name)
{
  FILE *stream;
  char tmp[FILENAME_MAX], buffer[1024], *token;
  int inscope = false;
  
  if (name) {
    sprintf (tmp, "%s", name);
  }
  else {
    sprintf (tmp, "%s", configpath);
  }
  stream = fopen (tmp, "r");
  
  if (!stream)
    GOERR (_("config file"));
  
  while (!feof (stream)) {
    
    if (fgets (buffer, 1023, stream) == NULL) {
      if (feof (stream))
	goto eofhd;
      else
	GOERR (_("config file"));
    }
    
    if (!inscope) {
      token = strtok (buffer, " (\n");
      if (token) {
	if (strcasecmp (token, "begin") == 0) {
	  token = strtok (NULL, " )\r\t\n");
	  if ((token) 
	      && ((strcasecmp (token, "server") == 0) 
		  || (strcasecmp (token, "global") == 0))) {
	    inscope = true;
	  }
	  /*	  else 
	    dm_seterr (DMEKEYWORD);*/
	}
      }
    }
    else {
      token = strtok (buffer, ": \n");

      if (token) {
	
	if (strcmp (token, "k4-path") == 0) {
	  GET_STRING (token, default_lisp_path);
	}
	else if (strcmp (token, "tmpdir") == 0) {
	  GET_STRING (token, tmppath);
	}
	else if (strcmp (token, "basedir") == 0) {
	  GET_STRING (token, kaengurubase);
	}
	
	else if (strcmp (token, "forcesync") == 0) {
	  forcesync = GET_BOOLEAN (token, true);
	}
	else if (strcmp (token, "pedantic-forcesync") == 0) {
#if defined HAVE_FDATASYNC
	   pedanticforcesync = GET_BOOLEAN (token, true);
#else
	   forcesync = GET_BOOLEAN (token, true);
#endif
	}
	else if (strcmp (token, "forceindex") == 0) {
	  forceindex = GET_BOOLEAN (token, false);
	}

	else if (strcmp (token, "timeout") == 0) {
	  timeoutval = GET_CONST (token, 1, 86400); /* max. 1 Tag timeout */
	}
	else if (strcmp (token, "min-blob-size") == 0) {
	  blob_limit = GET_CONST (token, 1, 1 << 31);
	}

	else if (strcmp (token, "maxheapsize") == 0) {
	  maxheapsize = GET_CONST (token, 1, 1 << 31);
	}
	else if (strcmp (token, "hashpagesize") == 0) {
	  hashpagesize = GET_CONST (token, 1, maxheapsize);
	}
	else if (strcmp (token, "defaultheapsize") == 0) {
	  defaultheapsize = GET_CONST (token, heappagesize, maxheapsize);
	}

	else if (strcmp (token, "maxoblistsize") == 0) {
	  maxoblistsize = GET_CONST (token, 1, maxoblistsize);
	}
	else if (strcmp (token, "oblistpagesize") == 0) {
	  oblistpagesize = GET_CONST (token, 1, 1 << 31);
	}
	else if (strcmp (token, "defaultoblistsize") == 0) {
	  defaultoblistsize = GET_CONST (token, oblistpagesize,
					 maxoblistsize);
	}
	
	else if (strcmp (token, "maxstrlistsize") == 0) {
	  maxstrlistsize = GET_CONST (token, 1, 1 << 31);
	}
	else if (strcmp (token, "strlistpagesize") == 0) {
	  strlistpagesize = GET_CONST (token, 1, maxstrlistsize);
	}
	else if (strcmp (token, "defaultstrlistsize") == 0) {
	  defaultstrlistsize = GET_CONST (token, strlistpagesize,
					  maxstrlistsize);
	}

	else if (strcmp (token, "stackpagesize") == 0) {
	  stackpagesize = GET_CONST (token, 1, 1 << 31);
	}
	else if (strcmp (token, "defaultstacksize") == 0) {
	  defaultstacksize = GET_CONST (token, 1, 1 << 31);
	}

	else if (strcmp (token, "minfreecell") == 0) {
	  minfreecell = GET_CONST (token, 1, 1 << 31);
	}
	else if (strcmp (token, "minfreeobj") == 0) {
	  minfreeobj = GET_CONST (token, 1, 1 << 31);
	}
	else if (strcmp (token, "minfreestr") == 0) {
	  minfreestr = GET_CONST (token, 1, 1 << 31);
	}
	else if (strcmp (token, "trace-requests") == 0) {
	  trace = GET_BOOLEAN (token, true);
	}
	else if (strcmp (token, "cache-outdate-rate") == 0) {
	  class_outdate_period = GET_CONST (token, 0, 10000);
	}
	else if (strcmp (token, "refresh-cache-rate") == 0) {
	  class_check_period = GET_CONST (token, 0, 10000);
	}
	else if (strcasecmp (token, "end") == 0) {
	  inscope = false;
	}
	else {
	  if (*token == '#') {}	/* comment */
	}
      }
    }
  }
  
eofhd:
  if (inscope) {
    PRINTERR (_("warning! unexpected eof in config file\n"));
  }
  if (fclose (stream) != 0)
    GOERR (_("config file"));
  return 1;
  
errhd:
  PRINTERR (errstr);
  return -1;
}

