/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997,98 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#if HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#if defined STDC_HEADERS || defined _LIBC
# include <stdlib.h>
#endif
#if defined HAVE_UNISTD_H || defined _LIBC
# include <unistd.h>
#endif
#include <ctype.h>

#include "proto.h"
#include "hc.h"

static char s_charq[] = "char?";
static char a_charq[] = "*";
Atom
f_charq (Atom list)
{
  if (TYP(CAR(list)) == CHAR_P)
    return TRUE;
  return FALSE;
}

static char s_char_equal[] = "char=?";
static char a_char_equal[] = "cc";
Atom
f_char_equal (Atom list)
{
  if (CHARV(CAR(list)) == CHARV(CAR(CDR(list))))
    return TRUE;
  return FALSE;
}

static char s_char_less[] = "char<?";
static char a_char_less[] = "cc";
Atom
f_char_less (Atom list)
{
  if (CHARV(CAR(list)) < CHARV(CAR(CDR(list))))
    return TRUE;
  return FALSE;
}

static char s_char_great[] = "char>?";
static char a_char_great[] = "cc";
Atom
f_char_great (Atom list)
{
  if (CHARV(CAR(list)) > CHARV(CAR(CDR(list))))
    return TRUE;
  return FALSE;
}

static char s_char_lesseq[] = "char<=?";
static char a_char_lesseq[] = "cc";
Atom
f_char_lesseq (Atom list)
{
  if (CHARV(CAR(list)) <= CHARV(CAR(CDR(list))))
    return TRUE;
  return FALSE;
}

static char s_char_greateq[] = "char>=?";
static char a_char_greateq[] = "cc";
Atom
f_char_greateq (Atom list)
{
  if (CHARV(CAR(list)) >= CHARV(CAR(CDR(list))))
    return TRUE;
  return FALSE;
}


static char s_char_upc[] = "char-upcase";
static char a_char_upc[] = "c";
Atom
f_char_upc (Atom list)
{
  return ACHAR(toupper(CHARV(CAR(list))));
}

static char s_char_downc[] = "char-downcase";
static char a_char_downc[] = "c";
Atom
f_char_downc (Atom list)
{
  return ACHAR(tolower(CHARV(CAR(list))));
}

static char s_char_alphaq[] = "char-alphabetic?";
static char a_char_alphaq[] = "c";
Atom
f_char_alphaq (Atom list)
{
  return (isalpha(CHARV(CAR(list))) ? TRUE : FALSE);
}

static char s_char_numq[] = "char-numeric?";
static char a_char_numq[] = "c";
Atom
f_char_numq (Atom list)
{
  return (isdigit(CHARV(CAR(list))) ? TRUE : FALSE);
}

static char s_char_alnumq[] = "char-alphanumeric?";
static char a_char_alnumq[] = "c";
Atom
f_char_alnumq (Atom list)
{
  return (isalnum(CHARV(CAR(list))) ? TRUE : FALSE);
}

static char s_char_spaceq[] = "char-whitespace?";
static char a_char_spaceq[] = "c";
Atom
f_char_spaceq (Atom list)
{
  return (isspace(CHARV(CAR(list))) ? TRUE : FALSE);
}

static char s_char_upperq[] = "char-upper-case?";
static char a_char_upperq[] = "c";
Atom
f_char_upperq (Atom list)
{
  return (isupper(CHARV(CAR(list))) ? TRUE : FALSE);
}

static char s_char_lowerq[] = "char-lower-case?";
static char a_char_lowerq[] = "c";
Atom
f_char_lowerq (Atom list)
{
  return (islower(CHARV(CAR(list))) ? TRUE : FALSE);
}

static char s_char2int[] = "char->integer";
static char a_char2int[] = "c";
Atom
f_char2int (Atom list)
{
  return NEWINT(CHARV(CAR(list)));
}

static char s_int2char[] = "integer->char";
static char a_int2char[] = "n";
Atom
f_int2char (Atom list)
{
  return ACHAR(numv(CAR(list)));
}


void
init_chars ()
{
  Functiontable functbl[] = {
    {s_charq, h_CHARQ, a_charq, f_charq},
    {s_char_equal, h_CHAR_EQUAL, a_char_equal, f_char_equal},
    {s_char_less, h_CHAR_LESS, a_char_less, f_char_less},
    {s_char_great, h_CHAR_GREAT, a_char_great, f_char_great},
    {s_char_lesseq, h_CHAR_LESSEQ, a_char_lesseq, f_char_lesseq},
    {s_char_greateq, h_CHAR_GREATEQ, a_char_greateq, f_char_greateq},
    {s_char_upc, h_CHAR_UPC, a_char_upc, f_char_upc},
    {s_char_downc, h_CHAR_DOWNC, a_char_downc, f_char_downc},
    {s_char_alphaq, h_CHAR_ALPHAQ, a_char_alphaq, f_char_alphaq},
    {s_char_numq, h_CHAR_NUMQ, a_char_numq, f_char_numq},
    {s_char_alnumq, h_CHAR_ALNUMQ, a_char_alnumq, f_char_alnumq},
    {s_char_spaceq, h_CHAR_SPACEQ, a_char_spaceq, f_char_spaceq},
    {s_char_upperq, h_CHAR_UPPERQ, a_char_upperq, f_char_upperq},
    {s_char_lowerq, h_CHAR_LOWERQ, a_char_lowerq, f_char_lowerq},
    {s_char2int, h_CHAR2INT, a_char2int, f_char2int},
    {s_int2char, h_INT2CHAR, a_int2char, f_int2char},

    {NULL, -1, NULL, NULL}
  };
  Functiontable *ft = functbl;
  int i;
  
  for (i = 0; (ft+i)->fname != NULL ; i++)
    make_fset ((ft+i)->fname, (ft+i)->hashcode, (ft+i)->args, (ft+i)->fnc);
}

