/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997,98 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#if HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#if defined STDC_HEADERS || defined _LIBC
# include <stdlib.h>
#endif
#if defined HAVE_UNISTD_H || defined _LIBC 
# include <unistd.h>
#endif
#include <ctype.h>

#include "proto.h"
#include "hc.h"
#include "sm.h"
#include "lock.h"
#include "dbfunc.h"

/*
  db-vacuum FID KILL-DELETED-OBJECTS
*/
static char s_db_vacuum[] = "db-vacuum";
static char a_db_vacuum[] = "nb";
Atom
f_db_vacuum (Atom list)
{
  int retval;

  if (!database.status)
    SETERR (0, _("database not opened"));
  if ((!database.asowner) 
      && (clientuid != U_ROOT))
    SETERR (0, _("permission for vacuum denied"));
  
  retval = lock_database (&database, lock_LOCKED);
  if (retval < 0)
    SETERR (0, _("can't lock database for vacuum")); /* some error! */
  if (retval == 0)		/* permission denied! */
    SETERR (0, _("vacuum database: permission denied"));
  
  if (vacuum (&database, BOOLV(CADR(list)), numv(CAR(list))) < 0)
    JMPERR();
  
  /* gebe die restriktiven Rechte wieder auf */
  lock_database (&database, lock_SHARED);
  
  return UNSPECIFIED;
}

static char s_db_reindex[] = "db-reindex";
static char a_db_reindex[] = "nb";
Atom
f_db_reindex (Atom list)
{
  return UNSPECIFIED;
}

void
init_admin ()
{
  Functiontable functbl[] = {
    {s_db_vacuum, h_DB_VACUUM, a_db_vacuum, f_db_vacuum},
    {s_db_reindex, h_DB_REINDEX, a_db_reindex, f_db_reindex},
    {NULL, -1, NULL, NULL}
  };
  Functiontable *ft = functbl;
  int i;
  
  for (i = 0; (ft+i)->fname != NULL ; i++)
    make_fset ((ft+i)->fname, (ft+i)->hashcode, (ft+i)->args, (ft+i)->fnc);
}

