/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997,98 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#ifndef _KDBS_READ_CONFIGURATION_H
#define _KDBS_READ_CONFIGURATION_H

#define GET_BOOLEAN(TOKEN, DEFAULT)		\
({						\
  int _vrf = (DEFAULT);				\
  TOKEN = strtok (NULL, " \r\t\n");		\
  if (TOKEN) {					\
    if (strcasecmp (TOKEN, "yes") == 0)		\
      _vrf = true;				\
    else if (strcasecmp (TOKEN, "no") == 0)	\
      _vrf = false;				\
    else					\
      GOERR ("bad boolean value");		\
  }						\
  _vrf;						\
})

#define GET_CONST(TOKEN, LLIMIT, ULIMIT)	\
({						\
  int _const = 0;				\
  char *_tail;					\
  TOKEN = strtok(NULL, " \r\t\n");		\
  if (TOKEN)					\
    _const = strtol (token, &_tail, 0);		\
  if (!TOKEN 					\
      || (_const < LLIMIT) 			\
      || (_const > ULIMIT))			\
    GOERR ("bad constant value");		\
  _const;					\
})

#define GET_STRING(TOKEN, STR)			\
({						\
  TOKEN = strtok(NULL, " \r\t\n");		\
  if (TOKEN)					\
    strcpy (STR, TOKEN);			\
})

#endif
