/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997,98 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#ifndef _KDBS_NET_H
#define _KDBS_NET_H

#if FREEBSD
#include <sys/socket.h>
#endif
#include <netinet/in.h>
#include "kdbs.h"

typedef struct sockaddr_in Socketaddr;

/* Netcommunicationroutines. */

#define PORT            5555
#define LOCALHOST      "localhost"
#define MAXMSG          512
#define MAXPACKET       1024
#define MAXKCPBUF       1024

/* ----------------------------------------------------------------------
   KCP: Kaenguru Communication Protocol
   ---------------------------------------------------------------------- */
#define KCP_NULL            0
#define KCP_EOL          '\r'
#define KCP_ESC          '\e'
#define KCP_SEC_EOL      'a'
#define KCP_SEC_ESC      'b'

#define KCP_KILL         "KILL"
#define KCP_CLOSE        "CLOSE"
#define KCP_LOGIN        "LOGIN"
#define KCP_SSTARTED     "SSTARTED"
#define KCP_BEGINTRANS   "BEGINTRANS"
#define KCP_CHANGETRANS  "CHANGETRANS"
#define KCP_ADDTRANS     "ADDTRANS"
#define KCP_DELTRANS     "DELTRANS"
#define KCP_TRANS        "TRANS"
#define KCP_ENDTRANS     "ENDTRANS"
#define KCP_OK           "OK"
#define KCP_OKC          '+'
#define KCP_ERR          "ERR"
#define KCP_ERRC         '-'
#define KCP_WAIT         "WAIT"
#define KCP_WAITC        '~'
#define KCP_NEXTC        '>'
#define KCP_DONEC        '.'
#define KCP_TRACE        "TRACE"
#define KCP_HELO         "HELO"
#define KCP_HALT         "HALT"
#define KCP_QUIT         "QUIT"
#define KCP_LISP         "LISP"
#define KCP_GETVAL       "GETVAL"
#define KCP_ERRMSG       "ERRMSG"
#define KCP_VERIFYDB     "VERIFYDB"
#define KCP_USRINGRP     "USRINGRP"
#define KCP_READ_DFIELD  "READDFIELD"
#define KCP_STORE_DFIELD "STOREDFIELD"
#define KCP_TALKLISP     "TALKLISP"
#define KCP_REREAD       "REREAD"
#define KCP_SUPERVISOR   "SUPERVISOR"
#define KCP_LISTCONN     "LISTCONN"

/* ------------------------------------------------------------
   Generelle Net-routinen
   ------------------------------------------------------------*/
extern int makeSocket (unsigned short port);
extern int init_sockaddr (Socketaddr *name, const char *hostname,
			  unsigned short int port);
extern unsigned short establishport (unsigned short port);
extern char * establishhost (char *host);
extern int write_blob (int filedes, char *buffer, int len);
extern int read_blob (int filedes, char **retbuf);
extern int make_connection (unsigned short *port, char **host);
extern int make_login (int socket, char *kcp_code, char *logname,
		       char *keydbfile, char **tmp, int *tmpsize);
extern int parse_login_data (char *tmp, int *connectid, char **connkey,
			    char **client_usrname, Uid *clientuid,
			    Gid *clientgid);
extern int read_from_sock (int filedes, char **buffer, int *bufsize);
extern int write_to_sock (int filedes, char *buffer);

extern int writesockf (int filedes, const char *protot, ...);


/* ----------------------------------------------------------------------
   Errorcodes
   ---------------------------------------------------------------------- */
#define NET_GOERR(estr) ({ errstr = (estr); goto errhd; })
#define NET_DESCERR(estr) (errstr = (estr))

#endif
