/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997,98 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#ifndef _KDBS_LOCK_H
#define _KDBS_LOCK_H

#define MAXRESOURCES       40	/* max. 40 gesperrte Dinge gleichzeitig */
#define MAXLOCKREQ         20	/* max. 20 Lock-requests auf einmal */
#define MAXSERVRES         50	/* max. 50 Locks pro lock-request */

typedef struct {
  int type;			/* datei in der gesperrt werden soll */
  long eid;			/* eintragsnummer */
  Dbid dbid;			/* datenbank fr die diese Res gilt! */
} Resource;

typedef struct {
  int lockid;			/* lock id number */
  char status;			/* tatschlicher Status: PENDING MIGHTY READ */
  char reqstatus;		/* erforderder Status */
  Resource rid;			/* resourceid */
} Reslistentry;			/* Locklist fr die resources */

typedef struct {
  int lockid;			/* lock id number */
  int serverid;			/* server identification */
  bool announced;		/* wurde server bereits benachrichtigt? */
  int maxrid;			/* anzahl der angeforderten Resources */
  Reslistentry *reslist[MAXSERVRES];	/* resourcen list */
} Lockreqlist;

typedef struct {
  Dbid dbid;
  char *path;
  bool dbowner;
  int lockid;			/* database lock */
} VOretval;			/* verify opendb retvalue */

/* konstanten fr die Lockingfunctions */
#define lock_NULL              0
#define lock_PENDING           1
#define lock_OK                2
#define lock_SHARED            'S'
#define lock_RESTRICTED        'R'
#define lock_LOCKED            'L'
#define lock_INDEX             'i'
#define lock_DATA              'd'
#define lock_NEXTOID           'n'
#define lock_OPENLIST          'o'
#define lock_DATABASE          'b'

extern Reslistentry resourceslist[MAXRESOURCES];
extern Lockreqlist lockreqlist_data[MAXLOCKREQ];
extern Lockreqlist *lockreqlist[MAXLOCKREQ]; 
extern int lockreqlistcount;
extern int lockchanged;

extern bool rescmp (Resource *fres, Resource *sres);
extern void setresource (Resource *res, int type, long eid, Dbid dbid);
extern void rescpy (Resource *tres, Resource *sres);
extern void clearresource (int listno);
extern void clearlock (int lockno);
extern void initreslist (void);
extern Lockreqlist * getnewlockno ();
extern int beginlock (int serverid);
extern int addtolock (int lockid, char reqstatus, Resource *rid);
extern int changelock (int lockid, char reqstatus, Resource *rid);
extern int deletelock (int lockid);
extern void deleteallserverlocks (int serverid);
extern void deletelockno (int lockno);
extern int insertnewresource (char status, int lockid, Resource *rid);
extern int deleteresource (int lockid, Resource *rid);
extern int islocked (char status, Resource *rid);
extern int get_server_no (int serverid);
extern int get_lock_no (int lockid);
extern bool updatelocklist ();
extern bool iscomplete (int lockno);
extern void resstrcat (char *, int, int, Dbid, long);
extern void resstrcpy (char *, int, int, Dbid, long);
extern int freeresources (int socket, int connectid, char *connkey,
			  int lockid, int timeoutval);
extern int getresources (int socket, int connectid, char *connkey,
			 char *func, int lockid, char *resstr,
			 int timeoutval);
extern int verify_database (int socket, int connectid, char* connkey,
			    Uid clientuid, char *dbname,
			    VOretval **voretval);

#endif
