/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997,98 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#ifndef _KDBS_KDBS_H
#define _KDBS_KDBS_H

/* this is the main config file, created by configure */
#if HAVE_CONFIG_H
#include "config.h"
#endif

/* doing internationalization */
#if defined HAVE_GETTEXT
# include <libintl.h>
# define _(String) gettext (String)
#else
# define _(STRING) STRING
#endif

#include <time.h>

/* ----------------------------------------------------------------------
   This one for compatibility
   ---------------------------------------------------------------------- */
/* On some strange systems still no definition of NULL is found.  Sigh!  */
#ifndef NULL
# if defined __STDC__ && __STDC__
#  define NULL ((void *) 0)
# else
#  define NULL 0
# endif
#endif

#ifndef HAVE_UNISTD_H
# ifndef EXIT_FAILURE
#   define EXIT_FAILURE 1
# endif
# ifndef EXIT_SUCCESS
#   define EXIT_SUCCESS 0
# endif
#endif

/* change this for global version numbering! */
#define version VERSION
#define copyrightyear COPYRIGHTYEAR

#define MAXCONNECTIONS   1024

typedef unsigned char bool;
#define true      1
#define false     0

typedef int Int32;		/* machine-independance */
typedef short Int16;
typedef bool Bool;

typedef unsigned char byte;
typedef unsigned long Long;
typedef time_t Date;

typedef unsigned char Uid;	/* User ID */
typedef unsigned char Gid;	/* Group ID */
typedef unsigned long Oid;	/* the Object ID */
typedef unsigned short Aid;	/* attr ID */
typedef unsigned char Fid;	/* (data-)file ID */
typedef unsigned char Dbid;	/* database ID */
typedef unsigned char ACode;	/* Accesscode */
typedef long Ofs;		/* Offset */
typedef long Node;		/* for the Index */

#define UNKNOWNUSR      255	/* uid for unknown user */
#define EVERYUSR        254	/* uid for every user (mask) */
#define UNKNOWNGRP      255	/* gid for unknown group */
#define UNKNOWNDB       255	/* did for unknown database */
#define U_ROOT            0	/* the root uid */
#define U_GUEST         255	/* the guest uid (id to unknown user) */
#define UNKNOWNFID      255	/* fid for unknown file */

/* ----------------------------------------------------------------------
   Accesscodes 

   Bit
   0   (1)       Gruppe darf lesen                   A_GREAD
   1   (2)       Gruppe darf schreiben/lschen       A_GWRITE
   2   (4)       Gruppe hat Zugriffsrechte           A_GACC
   3   (8)       Andere drfen lesen                 A_OREAD
   4   (16)      Anderen drfen schreiben/lschen    A_OWRITE
   5   (32)      Andere haben Zugriffsrechte         A_OACC
   6   (64)      Eigentmer darf schreiben/lschen   A_UWRITE
   7   (128)     Gste haben Leserechte              A_GUEST

   Gngige Kombinationen:

   137  Datensatz darf von allen gelesen werden, ist aber schreibgeschtzt
        (allgemeiner Recherchedatensatz) 

   9    Datensatz darf nur von Bekannten (Gruppe und Andere) gelesen werden
        (interne Recherche).
 
   64   Datensatz darf nur vom Eigentmer gelesen und verndert werden 

   75   Der Eigentmer und die Gruppe drfen schreiben/lschen, Andere drfen
        lesen (normale interne Arbeitsumgebung).

   79   Wie 75, die Gruppe darf jedoch auch Zugriffsrechte ndern (z.B.
        den Besitzer ndern) (erweiterte Arbeitsumgebung)
   
   ---------------------------------------------------------------------- */

#define A_RGRP       1
#define A_WGRP       2
#define A_AGRP       4                          
#define A_ROTH       8
#define A_WOTH      16
#define A_AOTH      32
#define A_WUSR      64
#define A_RGUEST   128

#define A_RWGRP      3		/* group: read write */
#define A_RWAGRP     7		/* group: read write access */
#define A_RWOTH     24		/* others: read write */
#define A_RWAOTH    56		/* others: read write access */

#define A_HIER      75		/* hierachical= usr: write, group: r/w */

/* ----------------------------------------------------------------------
   misc from shared/misc.c 
   ---------------------------------------------------------------------- */
extern char * errstr;
extern Date get_system_time ();

#define SERVERNAME "kaenguru"	/* the server to be started by daemon */

#endif

