/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997,98 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#ifndef _KDBS_MU_H
#define _KDBS_MU_H

#include "kdbs.h"
#include "net.h"

/* herein resides shared functions for the multiuser-library */

#define C_WAIT       'W'	/* internal status */
#define C_NULL       '0'
#define C_OK         'S'
#define C_PENDING    'P'
#define C_ZOMBIE     'Z'

#define MAXCONN       5		/* max number of parallel logins */
#define CONNKEYSIZE  12

typedef struct Connections Clist;
struct Connections {
  char status;			/* status of connection */
  int clientsock;		/* sock with client */
  int serversock;		/* sock with backend */
  int port;			/* port with backend */
  Socketaddr client;		/* host data of client */
  char *login;			/* name of client */
  char *connkey;		/* the key of a connection */
  Uid uid;			/* the logged user */
  
  int connid;			/* connection id */
  bool supervisor;		/* logged in as supervisor? */
  Clist *next;			/* next connection struct */
};

/* max. size of connection keys. */
extern char * get_conn_key (int lng);
extern void free_conn (Clist *clist);
extern Clist * alloc_clist ();
extern Clist * get_connection (Clist *clist, int connid);
extern int get_next_connid ();
extern bool checkconnkey (Clist *clist, int connid, char *key);
extern void free_total_clist (Clist **clist);
extern void free_connid (Clist **clist, int connid);
extern Clist * get_new_conn ();
extern Clist * insert_conn (Clist **clist, Clist *cl);
extern void showconns (Clist *clist);
extern int cleanup_clist (Clist **clist);

#endif
