#! /bin/bash

if [ $# = "0" ]; then
  echo "Specify the basepath:"
  echo " e.g.:  create-demo /var/lib/database/privat "
  exit 1
fi

DBNAME="books"
DBPTH="$1/$DBNAME"
DBK4PTH="$DBPTH/k4"
OPENRC="$DBK4PTH/openrc"

echo "Creating new Kaenguru Database"
echo "Name: $DBNAME"
echo "Path: $DBPATH"

# create the database
kdcreatedb -p $DBPTH -b $DBNAME -d "bib:0" \
  -i "class:0, names:1, titles:2, keys:3, publ:4"

# now construct the open-rc.kl file
mkdir $DBK4PTH
touch $OPENRC
echo ";; open rc for a books database" > $OPENRC
echo "" >> $OPENRC
echo "(require 'Bibtex.k4)" >> $OPENRC


