/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#ifndef _KDBS_SMSERVER_H
#define _KDBS_SMSERVER_H

#include "basic_type.h"
#include "net.h"
#include "defines.h"

#define MAXDB  5		/* max. number of open databases */

typedef struct Datallocitem Dballoc;
struct Datallocitem {
  char *name;
  char *path;
  char *comment;
  Dballoc *next;
};

typedef struct Dblist Databaselist;
struct Dblist {
  int mountid;
  Database db;
};


/* Error codes */
#define SMDELISTEN      2000     
#define SMDESELECT      2001
#define SMDEACCEPT      2002
#define SMDEFREEDB      2003
#define SMDECONFIG      2005
#define SMDECONFIGR     2006
#define SMDECONFIGCL    2007
#define SMDEKEYWORD     2008
#define SMDECONST       2009
#define SMDEYESNO       2016

#define SMDEDBCONFOP    2010
#define SMDEDBCONFR     2011
#define SMDEDBCONFNAME  2012
#define SMDEDBCONFPATH  2013
#define SMDEDBCONFCL    2014
#define SMDEDBCONFREC   2015

#define SMDEUNKNOWNDB   2020

#define smd_seterr(NR)({lisperr = NR; goto errhd;});
#define print_err(NR) ({fprintf (stderr, "ksmd: %s\n", slisperr(NR)); })

/* in sm_server.c */
extern int exit_status;
extern unsigned short port;
extern char *host;
extern bool errormsgs;
extern bool trace;

/* in cycle.c */
extern int storagecycle (unsigned short port);

/* config.c */
extern int init_lists ();
extern int read_database_conf ();
extern Dballoc * getdbdata_byname (char *dbname);

extern char systempath[FILENAME_MAX];
extern char basepath[FILENAME_MAX];
extern char descfile[FILENAME_MAX];

extern int read_configuration (char *name);

/* interface.c */
extern int init_dblist(void);
extern int get_next_mountid(void);
extern int get_next_freedb(void);
extern int find_mountid(int mountid);
extern int open_database(char *dbname);
extern int close_database(int mountid);
extern int create_database(char *dbname, char *list_of_files,
			   char *list_of_index);
extern int read_item(int mountid, Oid oid, char **buf);
extern int write_item(int mountid, Oid oid, char *buf, int len);
extern int new_item(int mountid, Fid fid, char *buf, int len);
extern int del_item (int mountid, Oid oid);
extern int undelete_item (int mountid, Oid oid);
extern int kill_item (int mountid, Oid oid);


#endif    /* end */















