/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <strings.h>

#include "kdbs.h"

#ifdef DISTRIBUTED_DB

#include "sm.h"
#include "defines.h"
#include "smserver.h"
#include "lock.h"
#include "error.h"

/* the list of databases.  Must be done a sometime dynamical */
Databaselist dblist[MAXDB];

/* this count starts a 0 with program start, and increases with each
   mounted database by one.  So 4294967295 databases may be opened during
   liftime of ksmd.  */
int global_mountid_counter = 0;

int
init_dblist ()
{
  int i;
  for (i = 0; i < MAXDB; i++) {
    dblist[i].mountid = 0;
    initdbvar(&dblist[i].db);
  }
  return 0;
}

int
get_next_mountid ()
{
  global_mountid_counter++;
  return global_mountid_counter;
}

int
get_next_freedb ()
{
  int i;
  for (i = 0; i < MAXDB; i++) {
    if (dblist[i].mountid == 0)
      return i;
  }
  return -1;
}

int
find_mountid (int mountid)
{
  int i;
  for (i = 0; i < MAXDB; i++) {
    if (dblist[i].mountid == mountid)
      return i;
  }
  return -1;
}


/* this is the datamanager interface to opendb ().  It serves also the
   mountdb () */
int
open_database (char *dbname)
{
  int mountno = get_next_freedb ();
  int mountid;
  Dballoc *dballoc;

  if (mountno < 0) {		/* no free database resource */
    lisperr = SMDEFREEDB;
    return -1;
  }

  dballoc = getdbdata_byname (dbname);
  if (!dballoc)
    smd_seterr (SMDEUNKNOWNDB);
  
  if (mountdb (&dblist[mountno].db, dballoc->path) < 0)
    return -1;
  dblist[mountno].mountid = mountid = get_next_mountid ();
  
  if (opendb (&dblist[mountno].db) < 0) {
    smd_seterr (NWEOPEN);
  }
  
  return mountid;
errhd:
  return 0;
}

/* this is the datamanager interface function to closedb () */
int
close_database (int mountid)
{
  int mountno, retval;
  
  mountno = find_mountid (mountid);
  
  if (mountno < 0) 
    return 0;
  
  retval = closedb (&dblist[mountno].db);
  dblist[mountno].mountid = 0;
  killdbvar (&dblist[mountno].db);
  if (retval)
    return mountid;
  else
    return 0;
}

/* this is the datamanager interface function to createdb ().  It takes no
   path-argument since you can't specify paths for remote sites.  All
   databases on remote sites are located (by create_database) in the
   standardpath defined with that datamanager. */
int
create_database (char *dbname, char *list_of_files, char *list_of_index)
{
  Database db;
  int retval;
  
  retval = createdb (&db, dbname, NULL, list_of_files, list_of_index);
  return retval;
}

int
read_item (int mountid, Oid oid, char **buf)
{
  int mountno, readsize;
  Objstat objstat;

  mountno = find_mountid (mountid);
  if (mountno < 0) 
    return -1;
  
  readsize = readItem (&dblist[mountno].db, /* database */
		       oid,	/* object id */
		       buf,	/* the buffer */
		       &objstat); /* the itemstatus */
  return readsize;
}

int
write_item (int mountid, Oid oid, char *buf, int len)
{
  int mountno, writesize;
  
  mountno = find_mountid (mountid);
  if (mountno < 0) 
    return -1;
  
  writesize = rewriteItem (&dblist[mountno].db,	/* database */
			   oid, /* the actual oid */
			   buf,	/* buffer */
			   len);	/* len of buffer */
  
  return writesize;
}

int
new_item (int mountid, Fid fid, char *buf, int len)
{
  int mountno;
  Oid newoid;

  mountno = find_mountid (mountid);
  if (mountno < 0)
    return -1;

  newoid = newItem (&dblist[mountno].db, /* database */
		    fid,      /* the actual file id */
		    0,		/* client uid! TODO ************** */
		    0,		/* client gid! TODO ************** */
		    0,		/* access code! TODO ************* */
  		    buf,      /* buffer */
		    len);     /* len of buffer */

  return newoid;
}

int
del_item (int mountid, Oid oid)
{
  return 0;
}

int
undelete_item (int mountid, Oid oid)
{
  return 0;
}

int
kill_item (int mountid, Oid oid)
{
  return 0;
}


#endif
