/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <strings.h>
#include <arpa/inet.h>
#include <ctype.h>
#include <time.h>

#include "kdbs.h"

#ifdef DISTRIBUTED_DB

#include "sm.h"
#include "defines.h"
#include "smserver.h"
#include "lock.h"
#include "error.h"
#include "conn.h"

/* GLOBALE VARIABLEN */

Clist *clist;

/* schickt allen Servern eine EXIT-Message */
int
close_all_connections ()
{
  Clist *cl = clist;
  
  while (cl) {
    if (cl->status == C_OK)
      close (cl->serversock);
    cl = cl->next;
  }
  free_total_clist (&clist);
  return 1;
}

/* ------------------------------------------------------------
   Zentrale Serverroutine
   ------------------------------------------------------------*/
int
storagecycle (unsigned short port)
{
  struct sockaddr_in clientname;
  size_t size;
  const char spacedelim[]=" \n\t\r";
  int
    sock,			/* listening socket */
    testsock,			/* testing socket */
    newsock;			/* the accepted new socket */
  fd_set
    active_fd_set, read_fd_set;	/* for select */
  int
    selectval, retval;		/* return values */
  int
    eodaemon = false;		/* Daemon end? */
  
  char buffer[1024], tmp[256];
  char *line, *token;

#define getlong(toke, num) ({\
  toke = strtok (NULL, spacedelim);\
  if (toke) {\
    char *tail;\
    num = strtol (toke, &tail, 0);\
  }\
  else\
    num = 0; })
#define checkconnkey(TOKEN, CONNID, CORRECT, CL) ({\
  CORRECT = false;\
  TOKEN = strtok (NULL, " \n\r");\
  if (TOKEN) {\
    CL = get_connection (clist, CONNID);\
    if (CL) {\
      if (checkconnkey (CL, CONNID, TOKEN))\
	CORRECT = true;\
    }\
  }})
  
  /* Create the socket and set it up to accept connections. */
  fprintf (stdout, "ksmd: Connection established on port %hd\n", port);

  sock = makeSocket (port);	/* jetzt socket einrichten */
  
  if (listen (sock, 1) < 0)
    smd_seterr (SMDELISTEN);
    
  FD_ZERO (&active_fd_set);	/* init activ-sockets for select */
  FD_SET (sock, &active_fd_set);
  
  while (!eodaemon) {		/* solange wie server activ ist */
    
    read_fd_set = active_fd_set;
    
    /* diese seltsame Schleife um Signale abzufangen */
  selectjump:
    selectval = select (FD_SETSIZE, &read_fd_set, NULL, NULL, NULL);
    if (selectval < 0) {	/* signal EINTR caught? */
      if (errno == EINTR) goto selectjump;
      smd_seterr (SMDESELECT);
    }

    for (testsock = 0; testsock < FD_SETSIZE; ++testsock) {
      if (FD_ISSET (testsock, &read_fd_set)) { /* activ socket? */
	
	/* ----- A NEW CONNECTION COMING IN ---------------------------- */
	if (testsock == sock) {	               /* request on serversocket */
	  Clist *cl;

	  size = sizeof (clientname);
	  
	  if ((newsock = accept (sock, (struct sockaddr *) &clientname,
				 &size)) < 0)
	    smd_seterr (SMDEACCEPT);
	  
	  fprintf(stderr, "ksmd: connect from host %s, port %hd.\n",
		  inet_ntoa (clientname.sin_addr),
		  ntohs (clientname.sin_port));
	  FD_SET (newsock, &active_fd_set); /* Verbindung steht */

	  cl = get_new_conn ();
	  cl->status = C_OK;
	  cl->serversock = testsock;
	  memcpy (&cl->client, &clientname, size); 
	  insert_conn (&clist, cl);
	  showconns (clist);
	}
	
	/* ----- DATA COMING FROM EXISTING CONNECTIONS ------------------- */
	else {			/* receiving data */
	  
	  retval = readFromSock(testsock, buffer);

	  if (retval < 0) {	/* Socket is brocken */
	    fprintf (stderr, "ksmd: connection to client broken\n");
	    
	    close (testsock);
	    FD_CLR (testsock, &active_fd_set);
	    break;
	  }
	  
	  /* now scan the command line */
	  fprintf (stdout, "%s", buffer);
	  
	  line = strdup (buffer);
	  token = strtok (line, spacedelim);

	  if (token) {
	    /* ----- BYE ---------------------------------------------- */
	    /* The close request of a server. SYNTAX:

	       BYE <connid> <connkey> <mountid> 
	       
	       */
	    if (strcasecmp(token, "BYE") == 0) {
	      int connid, mountid, keyok;
	      Clist *cl;
	      
	      getlong (token, connid);
	      checkconnkey (token, connid, keyok, cl);
	      
	      if (keyok) {
		getlong (token, mountid);
	      
		close_database (mountid);
		
		fprintf (stdout, "Bye request from server: %d\n", mountid);

		free_connid (&clist, connid);
		showconns (clist);
		
		close (testsock);
		FD_CLR (testsock, &active_fd_set);
	      }
	      else {
		fprintf (stdout,
			 "ksmd: unauthorized bye request from ID %id.\n",
			 connid);
	      }
	    }

	    /* ----- OPENDB Command --------------------------------------- */
	    /* This is the open database command from the server. SYNTAX
	       
	       OPENDB <connid> <connkey> <name>
	       
	       */
	    else if (strcasecmp (token, "OPENDB") == 0) {
	      int connid, keyok;
	      Clist *cl;

	      getlong (token, connid);
	      checkconnkey (token, connid, keyok, cl);

	      if (keyok) {
		token = strtok (NULL, " \r"); /* take the databasename */

		fprintf (stdout, "Open db request\n");	      
		retval = open_database (token);
		
		if (retval > 0) {
		  sprintf (tmp, "%c%s %d" , 
			   KCP_OKC, KCP_OK, retval);
		  if (writeToSock (testsock, tmp) < 0)
		    goto errhd;
		}
		else {
		  sprintf (tmp, "%c%s %s", 
			   KCP_ERRC, KCP_ERR, slisperr (lisperr));
		  if (writeToSock (testsock, tmp) < 0)
		    goto errhd;
		}
	      }
	      else {
		fprintf (stdout,
			 "ksmd: unauthorized opendb request from ID %id.\n",
			 connid);
	      }
	    }
	    
	    /* ----- CLOSEDB command -------------------------------- */
	    /* with this commando the server closes a database. SYNTAX:

	       CLOSEDB <connid> <connkey> <mountid>
	       
	       */
	    else if (strcasecmp (token, "CLOSEDB") == 0) {
	      int connid, mountid, keyok;
	      Clist *cl;
	      
	      getlong (token, connid);
	      checkconnkey (token, connid, keyok, cl);

	      if (keyok) {
		getlong (token, mountid);
		retval = close_database (mountid);
		
		fprintf (stdout,
			 "Close db request from server: %d\n", mountid);
		
		if (retval > 0) {
		  sprintf (tmp, "%c%s" , 
			   KCP_OKC, KCP_OK);
		  if (writeToSock (testsock, tmp) < 0)
		    goto errhd;
		}
		else {
		  sprintf (tmp, "%c%s %s", 
			   KCP_ERRC, KCP_ERR, slisperr (lisperr));
		  if (writeToSock (testsock, tmp) < 0)
		    goto errhd;
		}
	      }
	      else {
		fprintf (stdout,
			 "ksmd: unauthorized closedb request from ID %id.\n",
			 connid);
	      }
	    }


	    /* ----- READ_ITEM command -------------------------------- */
	    /* with this commando the server request to read an item from a
	       prefore opened database. SYNTAX:

	       READI <connid> <connkey> <mountid> <oid>
	       
	       */
	    else if (strcasecmp (token, "READI") == 0) {
	      int mountid, connid, keyok;
	      Oid oid;
	      char *rbuffer;
	      Clist *cl;

	      getlong (token, connid);
	      checkconnkey (token, connid, keyok, cl);

	      if (keyok) {
		getlong (token, mountid);
		getlong (token, oid);
		
		retval = read_item (mountid, oid, &rbuffer);
		
		fprintf (stdout, "Read db request from server: %d\n", mountid);
		
		if (retval >= 0) {
		  sprintf (tmp, "%c%s", KCP_OKC, KCP_OK);
		  if (writeToSock (testsock, tmp) < 0)
		    goto errhd;
		  
		  if (write_blob (testsock, rbuffer, retval) < 0)
		    goto errhd;
		}
		else {
		  sprintf (tmp, "%c%s %s", 
			   KCP_ERRC, KCP_ERR, slisperr (lisperr));
		  if (writeToSock (testsock, tmp) < 0)
		    goto errhd;
		}
	      }
	      else {
		fprintf (stdout,
			 "ksmd: unauthorized readi request from ID %id.\n",
			 connid);
	      }
	    }

	    /* ----- WRITE_ITEM command -------------------------------- */
	    /* with this commando the server request to rewrite an item to
	       a prefore opened database. SYNTAX:

	       WRITI <connid> <connkey> 
                     <mountid> <oid> <sizeofbuf> EOL <buffer>
	       
	       */
	    else if (strcasecmp (token, "WRITI") == 0) {
	      int mountid, sizeofbuffer, readsize, connid, keyok;
	      Oid oid;
	      char *rbuffer;
	      Clist *cl;

	      getlong (token, connid);
	      checkconnkey (token, connid, keyok, cl);

	      if (keyok) {
		getlong (token, mountid);
		getlong (token, oid);
		getlong (token, sizeofbuffer);
		
		/* allocate a buffer */
		readsize = read_blob (testsock, &rbuffer);
		if (readsize < 0) {
		  free (rbuffer);
		  
		  fprintf (stderr, "ksmd: connection to client broken\n");
		  close (testsock);
		  FD_CLR (testsock, &active_fd_set);

		  free_connid (&clist, connid);
		}
		else {
		  retval = write_item (mountid, oid,
				       rbuffer, sizeofbuffer);
		  
		  fprintf (stdout, "Rewrite db request from server: %d\n",
			   mountid);
		  
		  if (retval >= 0) {
		    sprintf (tmp, "%c%s",
			     KCP_OKC, KCP_OK);
		    if (writeToSock (testsock, tmp) < 0)
		      goto errhd;
		  }
		  else {
		    sprintf (tmp, "%c%s %s", 
			     KCP_ERRC, KCP_ERR, slisperr (lisperr));
		    if (writeToSock (testsock, tmp) < 0)
		      goto errhd;
		  }
		}
	      }
	      else {
		fprintf (stdout,
			 "ksmd: unauthorized writi request from ID %id.\n",
			 connid);
	      }
	    }
	    
	    /* ----- unknown commands ------------------------------- */
	    else {
	      fprintf (stdout, "ksmd: unknown transfer protocol (%s)\n",
		       token);
	    }
	    free (line);
	  }
        }
      }
    }
  }
  
  if (lisperr != 0)
    fprintf(stderr, "ksmd (errormsg): %s\n", geterrmsg ());
  return 0;
  
errhd:
  fprintf (stderr, "ksmd (errormsg): %s\n", geterrmsg ());
  return -1;
}

#endif /* IF DISTRIBUTED_DB */
