/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997,98 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#if HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#if defined STDC_HEADERS || defined _LIBC
# include <stdlib.h>
# if defined HAVE_STRING_H
#  include <string.h>
# else
#  include <strings.h>
# endif
#endif
#if defined HAVE_UNISTD_H || defined _LIBC
# include <unistd.h>
#endif
#include <errno.h>
#include <sys/types.h>
#if defined HAVE_SYS_TIME_H
# include <sys/time.h>
#endif
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdarg.h>

#include "kdbd.h"

bool trace = false;		/* tracing? */
FILE *tracefile;		/* das tracefile */
char *tracefilename = NULL;	/* a tracefile? */


/* --------------------------------------------------
   Tracing routinen
   -------------------------------------------------- */
void
establishtracefile (char *newtrace)
{
  if (trace) {			/* tracing? */
    if (newtrace) {
      if (tracefilename)
	free (tracefilename);
      tracefilename = strdup (newtrace);
    }
    
    if (tracefilename) {
      if (strcasecmp (tracefilename, "STDOUT") == 0) {
	tracefile = stdout;
      }
      else {
	tracefile = fopen (tracefilename, "w+");
	if (tracefile == NULL) {
	  PRINTERR (_("can't create trace file"));
	  exit (EXIT_FAILURE);
	}
      }
      free (tracefilename);
    }
    else {
      PRINTERR (_("bad or missin trace file"));
      exit (EXIT_FAILURE);
    }
  }
}

void
tracef (const char *protot, ...)
{
  if (trace) {
    char tmp[1024], itmp[32], *c, *t;
    va_list ap;
    
    ap = va_start (ap, protot);
    
    t = tmp;
    c = (char *) protot;
    while (*c) {
      if (*c == '%') {
	char *carg;
	int arg;
	
	c++;
	switch (*c) {
	case 's':
	  carg = va_arg (ap, char*);
	  strcpy (t, carg);
	  t += strlen (carg);
	  break;
	case 'c':
	  arg = va_arg (ap, int);
	  *t = (char) arg;
	  t++;
	  break;
	case 'd':
	  arg = va_arg (ap, int);
	  sprintf (itmp, "%d", arg);
	  strcpy (t, itmp);
	  t += strlen (itmp);
	  break;
	}
      }
      else {
	*t = *c; 
	t++; 
      }
      c++;
    }
    va_end (ap);
    *t = '\0';
    
    fprintf (tracefile, tmp);
    fflush (tracefile);
  }
}


