/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997,98 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#if HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#if defined STDC_HEADERS || defined _LIBC
# include <stdlib.h>
#endif
#if defined HAVE_UNISTD_H || defined _LIBC
# include <unistd.h>
#endif
#include <signal.h>
#include <sys/types.h>

#include "kdbd.h"


/* GLOBALE VARIABLEN */
pid_t parent_pgid;		/* pid-group des Daemons */

int mypipe[2], infile, outfile;

/* --------------------------------------------------
   PROCESSFORKING UND INITROUTINES
   -------------------------------------------------- */
/* initialisiere den Daemon, seine Signale, und vor allem die process-
   gruppen.  Da sollte vor allem anderen geschehen.  */
void
initDaemon ()
{
  /* Init Signals */
  signal (SIGINT, SIG_IGN);
  signal (SIGQUIT, SIG_IGN);
  signal (SIGTSTP, SIG_IGN);
  signal (SIGTTIN, SIG_IGN);
  signal (SIGTTOU, SIG_IGN);
  signal (SIGCHLD, SIG_IGN);
  
  /* Put ourselves in our own process group.  */
  parent_pgid = getpid ();
  if (setpgid (parent_pgid, parent_pgid) < 0) {
    PRINTERR (_("can't put backend in its own process group."));
    exit (EXIT_FAILURE);
  }
}

/* startet einen process */
void
launch_process (char *proc, char *argv[], pid_t pgid)
{
  pid_t pid;
  
  /* Put the process into the process group. */ 
  pid = getpid ();
  if (pgid == 0) pgid = pid;
  setpgid (pid, pgid);
  
  /* Set the handling for job control signals back to the default.  */
  signal (SIGINT, SIG_DFL);
  signal (SIGQUIT, SIG_DFL);
  signal (SIGTSTP, SIG_DFL);
  signal (SIGTTIN, SIG_DFL);
  signal (SIGTTOU, SIG_DFL);
  signal (SIGCHLD, SIG_DFL);
  
  /* Set the standard input/output channels of the new process.  */
  if (infile != STDIN_FILENO) {
    dup2 (infile, STDIN_FILENO);
    close (infile);
  }
  if (outfile != STDOUT_FILENO) {
    dup2 (outfile, STDOUT_FILENO);
    close (outfile);
  }

  /* Exec the new process.  Make sure that we exit if we return.  */
  execvp (proc, argv);
  PRINTERR (_("can't fork to backend"));
  exit (EXIT_FAILURE);
}

/* startserver fhrt endlich den richtigen Datenbankserver hoch. */

int
startserver (int clientsock)
{
  pid_t child_id;
  char *argv[20];
  int argc = 0;
  char s[512], *ap;
  int filedes[2], retval;
  char proc[FILENAME_MAX];
  
  retval = socketpair (PF_UNIX, /* Internet namespace */
		       SOCK_DGRAM, /* style */
		       0,	/* protocol, as in the doc said only 0 */
		       filedes); /* the new descriptors */
  if (retval < 0) {
    PRINTERR (_("socket failed"));

    switch (errno) {
    case EMFILE:
      PRINTERR (_("to many file descriptors"));
      break;
    case EAFNOSUPPORT:
      PRINTERR (_("unsupported namespace"));
      break;
    case EPROTONOSUPPORT:
      PRINTERR (_("unsupported protocol"));
      break;
    case EOPNOTSUPP:
      PRINTERR (_("socket pairs unsupported"));
      break;
    }
    exit (EXIT_FAILURE);
  }  
  
  ap = s;			/* zuerst die Argumentliste erstellen */
  sprintf(ap, "*%s*", SERVERNAME); /* argv[0] ist der servername! */
  argv[argc++] = ap;
  ap += strlen (ap) + 1;

  sprintf(ap, "-c%d", clientsock); /* socket to the client */
  argv[argc++] = ap;
  ap += strlen (ap) + 1;
  
  sprintf(ap, "-d%d", filedes[1]); /* sock to the daemon */
  argv[argc++] = ap;
  ap += strlen (ap) + 1;
  
  if (trace) {
    sprintf(ap, "-t");		/* trace? */
    argv[argc++] = ap;
    ap += strlen (ap) + 1;
  }

  argv[argc++] = NULL;		/* Ende der Liste */
  
  sprintf (proc, "%s/%s", binpath, SERVERNAME);	/* binpath from config.c */
  
  child_id = fork ();
  if (child_id == 0)
    launch_process (proc, argv, parent_pgid);
  else if (child_id < 0) {
    PRINTERR (_("can't fork to backend"));
    exit (EXIT_FAILURE);
  }
  
  return filedes[0];
}

