/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997,98 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#ifndef _KDBS_KDBD_H
#define _KDBS_KDBD_H

#include "kdbs.h"
#include "net.h"

#define USRCONFFILE   "users"
#define GRPCONFFILE   "groups"
#define AUTHFILE      "authority"
#define DATABASEFILE  "databases"
#define AUTHDBFILE    "authority.db"


/* definitions for the user and group lists */
typedef struct Userentry Uentry;
struct Userentry {
  char *name;
  Uid uid;
  Gid gid;
  char *comment;
  Uentry *next;
};

typedef struct Userlist Ulist;
struct Userlist {
  Uid uid;
  Ulist *next;
};

typedef struct Groupentry Gentry;
struct Groupentry {
  char *name;
  Gid gid;
  Ulist *ulist;
  char *comment;
  Gentry *next;
};

typedef struct Databaseentry Dbentry;
struct Databaseentry {
  char *name;
  Dbid dbid;
  Uid owner;
  char *path;
  Ulist *ulist;
  char *comment;
  Dbentry *next;
};

typedef struct Authentry Aentry;
struct Authentry {
  char *login;
  Uid uid;
  int key;
  Aentry *next;
};

#define KEY_LENGTH     128
   
typedef struct {
  char key[KEY_LENGTH];		/* the key */
  Date key_created;		/* key created */
  Date last_login;		/* date of last login */
  Int16 validity;		/* max. span of time the login is valid */
  Int16 max_logins;		/* maximum counts of logins */
  Int32 login_count;		/* count the times of logins */
  Bool locked;			/* is the login locked? */
} KdbKeyStruc;


/* error macros */
#define GOERR(estr)				\
({						\
  errstr = (estr); 				\
  goto errhd;					\
})
#define PRINTERR(estr)				\
({						\
  fprintf (stderr, "kdbd: %s\n", (estr));	\
})
#define GETERRDESC()					\
({							\
  char *_retval = _("No error description available");	\
  if (errstr)						\
    _retval = errstr;					\
  _retval;						\
})

/* in daemon.c */
extern unsigned short port;
extern char *host;
extern char daemon_user[128];
extern int eodaemon;
extern int maxconn;
extern int verbose;

/* in launchserver.c */
extern pid_t parent_pgid;

extern void initDaemon ();
extern void launch_process (char *proc, char *argv[], pid_t pgid);
extern int startserver (int);


/* in listen.c */
extern unsigned short portcount;
extern int listencycle (unsigned short port);


/* in trace.c */
extern bool trace;		/* tracing? */
extern FILE *tracefile;		/* the tracefile */
extern char *tracefilename;	/* a tracefile? */

extern void establishtracefile ();
extern void tracef (const char *protot, ...);

/* in config.c */
extern char binpath[FILENAME_MAX];
extern char confpath[FILENAME_MAX];
extern char systempath[FILENAME_MAX];

extern void init_lists ();
extern void free_lists ();
extern int read_user_conf ();
extern int read_group_conf ();
extern int read_auth_conf ();
extern int read_database_conf ();
extern int read_configuration (char *name);

extern Uid getusrid (char *usrname);
extern char * getusrnme (Uid uid);
extern Uentry * getusrdata (Uid uid);
extern Gid getgrpid (char *grpname);
extern Gentry * getgrpdata (Gid gid);
extern char * getgrpnme (Gid gid);
extern void getusrauth (char *logname, char *domain, Uid *uid, int *key);
extern Dbid getdbid (char *dbname);
extern char * getdbnme (Dbid dbid);
extern Dbentry * getdbdata_byid (Dbid dbid);
extern Dbentry * getdbdata_byname (char *dbname);
extern bool auth_usr_on_dbase (Uid uid, Dbid dbid);
extern bool on_ulist (Uid uid, Ulist *ulist);

extern void showlists ();

/* in auth.c */
extern void new_authorization_key (KdbKeyStruc *key, int max_logins,
				   Bool locked);
extern int write_authorization_key (KdbKeyStruc *key, int no);
extern int read_authorization_key (KdbKeyStruc *key, int no);


#endif    /* end */

