/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997,98 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#if HAVE_CONFIG_H
# include "config.h"
#endif


#include <stdio.h>
#if defined STDC_HEADERS || defined _LIBC
# include <stdlib.h>
#endif
#if defined HAVE_UNISTD_H || defined _LIBC
# include <unistd.h>
#endif
#if defined STDC_HEADERS || defined HAVE_STRING_H
# include <string.h>
#else
# include <strings.h>
#endif

#if defined HAVE_SYS_TIME_H
# include <sys/time.h>
#else
# include <time.h>
#endif

#include "kdbd.h"
#include "path.h"
#include "read_configuration.h"

/* ----------------------------------------------------------------------
   function to maintain the autorization database
   ---------------------------------------------------------------------- */
/* Creates a unique authorizationkey for login */
void
new_authorization_key (KdbKeyStruc *key, int max_logins, Bool locked)
{
  struct timeval tp;
  int i;
  long t;
  Date res;

  gettimeofday (&tp, NULL);
  t = tp.tv_sec + tp.tv_usec;

  memset (key->key, '\0', KEY_LENGTH);

  for (i = 0; i < KEY_LENGTH - 1; i++) {
    key->key[i] = (t % 95) + 33; /* no space in keyword! */
    t = (t * 99) / 100;
  }
  key->key[i] = '\0';

  key->key_created = time (&res);
  key->last_login = 0;
  key->login_count = 0;
  key->max_logins = max_logins;
  key->locked = locked;
  key->validity = 0;
}

#define AUTHDB_ERROR "authorization database"
int
write_authorization_key (KdbKeyStruc *key, int no)
{
  FILE *stream;
  char tmp[FILENAME_MAX];
  int sizewritten;

  if (no <= 0)
    return 0;
  no--;
  
  sprintf (tmp, "%s/conf/%s", systempath, AUTHDBFILE);
  stream = fopen (tmp, "r+");
  
  if (!stream)
    GOERR (_(AUTHDB_ERROR));
  
  fseek (stream, no * sizeof (KdbKeyStruc), SEEK_SET);
  sizewritten = fwrite (key, sizeof (KdbKeyStruc), 1, stream);
  
  if (sizewritten != 1) {
    fclose (stream);
    GOERR (_(AUTHDB_ERROR));
  }
  
  fclose (stream);
  return 0;
  
 errhd:
  return -1;
}

int
read_authorization_key (KdbKeyStruc *key, int no)
{
  FILE *stream;
  char tmp[FILENAME_MAX];
  int sizeread;
  
  if (no == 0)
    return 0;
  no--;

  sprintf (tmp, "%s/conf/%s", systempath, AUTHDBFILE);
  stream = fopen (tmp, "r");
  
  if (!stream)
    GOERR (_(AUTHDB_ERROR));
  
  fseek (stream, no * sizeof (KdbKeyStruc), SEEK_SET);
  sizeread = fread (key, sizeof (KdbKeyStruc), 1, stream);
  
  if (sizeread != 1) {
    fclose (stream);
    GOERR (_(AUTHDB_ERROR));
  }
  
  fclose (stream);
  return 0;
  
 errhd:
  return -1;
}

