/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997,98 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#ifndef _KDBS_KAENGURU_H
#define _KDBS_KAENGURU_H

#include <netinet/in.h>

typedef struct sockaddr_in Socketaddr;

typedef struct {
  int sock;
  unsigned short port;
  char *host;
  Socketaddr servername;
} KD_conn;

typedef struct _KD_dfield {
  int size;
  int blobid;
} KD_dfield;

typedef struct _KD_data {
  int typ;
  union {
    int num;
    long unum;
    char * str;
    KD_dfield dfield;
    /*     KD_list * list; */
  } data;
  struct _KD_data * next;
} KD_data;

#define KD_NONE         0	/* see talklisp.c: SO_NONE */
#define KD_INT          1	/* see talklisp.c: SO_INT */
#define KD_UINT         2	/* see talklisp.c: SO_UINT */
#define KD_STR          3	/* see talklisp.c: SO_STR */
#define KD_DFIELD       4	/* see talklisp.c: SO_DFIELD */
#define KD_SYM          5	/* see talklisp.c: SO_SYM */
#define KD_CHAR         6	/* see talklisp.c: SO_CHAR */
#define KD_BOOL         7	/* see talklisp.c: SO_BOOL */

/* Netcommunicationroutines. */
#define PORT            5555
#define LOCALHOST      "localhost"
#define MAXMSG          512
#define MAXPACKET       1024
#define MAXKCPBUF       1024

/* ----------------------------------------------------------------------
   KCP: Kaenguru Communication Protocol
   ---------------------------------------------------------------------- */
#define KCP_NULL         0
#define KCP_EOL          '\r'
#define KCP_ESC          '\e'
#define KCP_SEC_EOL      'a'
#define KCP_SEC_ESC      'b'

#define KCP_KILL         "KILL"
#define KCP_LOGIN        "LOGIN"
#define KCP_WAIT         "WAIT"
#define KCP_WAITC        '~'
#define KCP_OK           "OK"
#define KCP_OKC          '+'
#define KCP_ERR          "ERR"
#define KCP_ERRC         '-'
#define KCP_QUIT         "QUIT"
#define KCP_LISP         "LISP"
#define KCP_GETVAL       "GETVAL"
#define KCP_TALKLISP     "TALKLISP"
#define KCP_ERRMSG       "ERRMSG"
#define KCP_READ_DFIELD  "READDFIELD"
#define KCP_STORE_DFIELD "STOREDFIELD"

/* ------------------------------------------------------------
   Generelle Net-routinen
   ------------------------------------------------------------*/
extern int makeSocket (unsigned short port);
extern int init_sockaddr (Socketaddr *name, const char *hostname,
			  unsigned short int port);
extern unsigned short establishport (unsigned short port);
extern char * establishhost (char *host);
extern int write_blob (int filedes, char *buffer, int len);
extern int read_blob (int filedes, char **retbuf);
extern int read_from_sock (int filedes, char **buffer, int *bufsize);
extern int write_to_sock (int filedes, char *buffer);


/* for error messaging */
#define KD_SEND                0 /* error sending data */
#define KD_INTERN              1
extern int kaenguru_errno;
extern char *KD_errstr;
#define KD_SENDERR()				\
({						\
  kaenguru_errno = KD_SEND;			\
  goto errhd;					\
})
#define KD_GOERR(estr) 				\
({						\
  kaenguru_errno = KD_INTERN;			\
  KD_errstr = (estr); 				\
  goto errhd;					\
})

extern KD_conn *KD_connect (short port, char *host, char *usrname);
extern int KD_close (KD_conn *conn);
extern int KD_send (KD_conn *conn, char *command);
extern KD_data * KD_getval (KD_conn *conn);
extern char * KD_talklisp (KD_conn *conn);
extern char * KD_read_blob (KD_conn *conn, int blobid, int *size);
extern int KD_store_blob (KD_conn *conn, int blobid, char *buf, int size);
extern char * KD_geterrmsg ();
extern void KD_free (KD_data *ptr);

#endif
