/* -*- Mode: C -*- */
/* vm.h - Virtual Memory hackery.
 * Created by Robert Heller on Fri Dec  6 20:37:13 1991
 * Updated for Version 2.0 on Sat Apr 26 15:29:21 1997
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Common Header Files
 * ------------------------------------------------------------------
 * Modification History:
 * $Log: vm.h,v $
 * Revision 2.6  1998/05/16 23:43:28  heller
 * Add indexing to the documentation.
 *
 * Revision 2.5  1998/04/21 15:12:18  heller
 * Update copyright notice.
 *
 * Revision 2.4  1997/07/20 19:50:20  heller
 * Spelling errors
 *
 * Revision 2.3  1997/07/15 21:10:16  heller
 * Add Documentation
 *
 * Revision 2.2  1997/06/29 19:14:59  heller
 * Fixes for portablity with CW
 *
 * Revision 2.1  1997/04/26 21:59:06  heller
 * *** empty log message ***
 *
 * Revision 1.1  1997/04/26 21:57:43  heller
 * Initial revision
 *
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 *    Home Librarian Database -- a program for maintaining a database
 *                               for a home library
 *    Copyright (C) 1991-1997  Robert Heller D/B/A Deepwoods Software
 *			51 Locke Hill Road
 *			Wendell, MA 01379-9728
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */
#ifndef _VM_
#define _VM_
#include <common.h>
#define SEEK_SET 0
#define SEEK_END 2

#ifdef unix
typedef char *FileName;
#else
#  ifdef macintosh
#    include <Types.h>
#    include <Files.h>
     typedef FSSpec *FileName;
#  else
     typedef char *FileName;
#  endif
#endif

//@ChapterName:Virtual Memory Class

/*@ManDoc:
   \typeout{Generated from: $Id: vm.h,v 2.6 1998/05/16 23:43:28 heller Rel $}
   \index{PageFile!C++ Interface|(}
   \index{PageFile!C++ Interface!PageFile class|bold}   
   This class implements the base level disk I/O for pages and records.
   It also does the working set management (deciding when to page in a
   page and when to page out a page).
 */
class PageFile {
public:
	//@Man:  open
	//@Type: HLEnums::OpenStatus
	//@Args: (see text)
	/*@Doc:  \index{PageFile!C++ Interface!open}
	  Open the file.  Does base level file open.
	  The argument list for this function depends on the O/S it was 
	  compiled for.  On the Mac it takes the arguments:
	  (const FSSpec *filename,HLEnums::Direction direction,
	    OSType creator,int flags = ReadWriteFlags,
	    Boolean create\_if = false)
	  On UNIX systems and MS-Windows it takes the arguments:
	  (const char *filename,HLEnums::Direction direction,
	    int flags = ReadWriteFlags,int mode = ReadWriteMode,
	    Boolean create\_if = false)
	 */
	HLEnums::OpenStatus open (
		      const FileName filename,
		      HLEnums::Direction direction,
#ifdef macintosh
		      OSType creator,
		      int flags = ReadWriteFlags,
#else
		      int flags = ReadWriteFlags,
		      int mode = ReadWriteMode,
#endif
		      Boolean create_if = false
					);
	/*@ManDoc: \index{PageFile!C++ Interface!close}
	   Close the file.  Does base level file close.
	   Any core-resident pages that are "dirty" (modified) are 
	   written to disk. */
	void close ();
	//@ManDoc: \index{PageFile!C++ Interface!FlushPages} Flush pages.
	void FlushPages ();
	//@ManDoc: \index{PageFile!C++ Interface!Constructor} Constructor.
	     PageFile ();
	/*@ManDoc: \index{PageFile!C++ Interface!Destructor}
	   Destructor.  Makes sure the file is closed.  (close() is
	   OK for a closed file - it is a noop then.)*/
	    ~PageFile ();
	//@ManDoc: \index{PageFile!C++ Interface!NewPage} Make a new page.
	DiskPage NewPage();
	//@ManDoc: \index{PageFile!C++ Interface!ReadRecord} Base level record read.
	int ReadRecord(DiskRecord&, char *, int);
	//@ManDoc: \index{PageFile!C++ Interface!WriteRecord} Base level record write.
	DiskRecord WriteRecord(char *,int);
	//@ManDoc: \index{PageFile!C++ Interface!ReWriteRecord} Base level record re-write.
	DiskRecord ReWriteRecord(DiskRecord&, char *,int);
	//@Man: operator []
	//@Type: Page *
	//@Args: (LongInt addr)
	/*@Doc: \index{PageFile!C++ Interface!"[@"[] operator}
	 The [] operator does DiskPage to core Page mapping.
	 Uses FindPage to find the page.  FindPage will bring the page
	 into memory if needed.  Note:  A call to this operator
	 could cause a page out.  {\em Always} call [] to get an up-to-date
	 pointer to a Page* before referencing the core page.  {\em Always}
	 {\em copy} to local storage any pieces of a page before calling
	 [] again if you plan to copy a bit of info from one page to
	 another.*/
	Page * operator [] (LongInt addr);
	//@Man: operator []
	//@Type: Page *
	//@Args: (DiskPage page)
	//@Doc: \index{PageFile!C++ Interface!"[@"[] operator} Alternative version of [] operator.
	Page * operator [] (DiskPage page); 
	/*@ManDoc: \index{PageFile!C++ Interface!"(@"() operator}
	 The () operator gets a reference to the PT entry.
	 {\em Always} call
	 () and update the isdirty field after you modify a page and before
	 calling [].  It is not a good idea to keep a local copy of the
	 PT entry reference around, since they move around and a local
	 copy of the PT entry is not meaningful, since the contents
	 is not stable. */
	PTEntry & operator () (LongInt addr);
	//@ManDoc: \index{PageFile!C++ Interface!"[@"[] operator} Alternative version of () operator.
	PTEntry & operator () (DiskPage page);
protected:
 	//@Man: fd
 	//@Type: short int (Mac) int (others)
 	//@Doc: \index{PageFile!C++ Interface!fd} The file descriptor.
#ifdef macintosh
	short int fd;
#else
	int fd;
#endif
	//@ManDoc: \index{PageFile!C++ Interface!isopen} Are we really open? flag.
	Boolean isopen;
	//@ManDoc: \index{PageFile!C++ Interface!direction} Allowed I/O directions.
	HLEnums::Direction direction;
	//@Man: NumPTEntries
	//@Type: const
	//@Doc: \index{PageFile!C++ Interface!NumPTEntries} WSMAX.  Max number of core resident pages.
	enum {NumPTEntries = 50};
	//@ManDoc: \index{PageFile!C++ Interface!numpagesincore} WSCURRENT.  Current number of pages actually in memory.
	int numpagesincore;
	//@ManDoc: \index{PageFile!C++ Interface!pagetable} This is our page table.
	PTEntry pagetable[NumPTEntries];
	//@ManDoc: \index{PageFile!C++ Interface!temp} Scratch PT entry.
	PTEntry temp;
	//@ManDoc: \index{PageFile!C++ Interface!PageRead} Read in a page.
	Boolean PageRead(PTEntry&);
	//@ManDoc: \index{PageFile!C++ Interface!PageWrite} Write out a page.
	Boolean PageWrite(PTEntry&);
	/*@ManDoc: \index{PageFile!C++ Interface!FindPage}
	  Find a page (might cause a page in, which might in turn cause a page out).
	  \index{PageFile!C++ Interface|)}
	 */
	PTEntry & FindPage(DiskPage);
};


#endif

