/* 
 * ------------------------------------------------------------------
 * Home Libarian 1.1 by Deepwoods Software
 * ------------------------------------------------------------------
 * TkvBTree_Export.cc - Export code for TkvBTree class
 * Created by Robert Heller on Sat Sep 20 19:19:15 1997
 * ------------------------------------------------------------------
 * Modification History: 
 * $Log: TkvBTree_Export.cc,v $
 * Revision 1.2  1998/02/15 18:39:09  heller
 * Update for additional inport (delimited) and export (formatted)
 *
 * Revision 1.1  1998/01/29 00:09:04  heller
 * Initial revision
 *
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Home Librarian Database -- a program for maintaining a database
 *                                for a home library
 *     Copyright (C) 1991-1997  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

static char ID[] = "$Id: TkvBTree_Export.cc,v 1.2 1998/02/15 18:39:09 heller Rel $";

#include <TkvBTree.h>
#include <TkCardRecord.h>
#include <ListRecord.h>
#include <stdio.h>
#include <errno.h>
#include <iostream.h>
#include <fstream.h>

static void QuoteStringBuffer(char* buffer,const char* string)
{
	*buffer++ = '"';
	while (*string != 0) {
		if (*string == '"') *buffer++ = '\\';
		*buffer++ = *string++;
	}
	*buffer++ = '"';
	*buffer = 0;
}

static void QuoteStringStream(ostream& out,const char* string)
{
	out << '"';
	while (*string != 0) {
		if (*string == '"') out << '\\';
		out << *string++;
	}
	out << '"';
}

int TkvBTree::PrintCardRecordV1(CoreItem* item,int,vBTree::UserData ud)
{
	while (Tcl_DoOneEvent(TCL_DONT_WAIT)) ;
	TkvBTree *This = (TkvBTree*)ud;
	int indent = 0;
	int column = 0;
	QuoteStringBuffer(This->buffer,item->key);
	(*(This->ofp)) << This->buffer << " ";
	indent += strlen(This->buffer) + 1;
	if (item->data.size <= 0) {
		(*(This->ofp)) << "#C()" << endl;
	} else {
		(*(This->ofp)) << "#C("; indent += 3;
		column = indent;
		CardRecord rec(&item->data);
		register const Card *c = &rec;
		const char* tn = This->Tree.CardTypeName(c->type);
		(*(This->ofp)) << ":TYPE " << tn << " "; column += 7 + strlen(tn);
		QuoteStringBuffer(This->buffer,c->author);
		if ((column + 9 + strlen(This->buffer))> 75) {
			(*(This->ofp)) << endl;
			for (int cc = 0; cc < indent; cc++) (*(This->ofp)) << " ";
			column = indent;
		}
		
		(*(This->ofp)) << ":AUTHOR " << This->buffer << " ";
		column += 9 + strlen(This->buffer);
		QuoteStringBuffer(This->buffer,c->title);
		if ((column + 8 + strlen(This->buffer))> 75) {
			(*(This->ofp)) << endl;
			for (int cc = 0; cc < indent; cc++) (*(This->ofp)) << " ";
			column = indent;
		}
		(*(This->ofp)) << ":TITLE " << This->buffer << " ";
		column += 8 + strlen(This->buffer);
		QuoteStringBuffer(This->buffer,c->publisher);
		if ((column + 12 + strlen(This->buffer))> 75) {
			(*(This->ofp)) << endl;
			for (int cc = 0; cc < indent; cc++) (*(This->ofp)) << " ";
			column = indent;
		}
		(*(This->ofp)) << ":PUBLISHER " << This->buffer << " ";
		column += 12 + strlen(This->buffer);
		QuoteStringBuffer(This->buffer,c->city);
		if ((column + 7 + strlen(This->buffer))> 75) {
			(*(This->ofp)) << endl;
			for (int cc = 0; cc < indent; cc++) (*(This->ofp)) << " ";
			column = indent;
		}
		(*(This->ofp)) << ":CITY " << This->buffer << " ";
		column += 7 + strlen(This->buffer);
		sprintf(This->buffer,":VOLUME %d ",c->vol);
		if ((column + strlen(This->buffer))> 75) {
			(*(This->ofp)) << endl;
			for (int cc = 0; cc < indent; cc++) (*(This->ofp)) << " ";
			column = indent;
		}
		(*(This->ofp)) << This->buffer; column += strlen(This->buffer);
		sprintf(This->buffer,":YEAR %d ",c->year);
		if ((column + strlen(This->buffer))> 75) {
			(*(This->ofp)) << endl;
			for (int cc = 0; cc < indent; cc++) (*(This->ofp)) << " ";
			column = indent;
		}
		(*(This->ofp)) << This->buffer; column += strlen(This->buffer);
		if ((column + 12)> 75) {
			(*(This->ofp)) << endl;
			for (int cc = 0; cc < indent; cc++) (*(This->ofp)) << " ";
			column = indent;
		}
		(*(This->ofp)) << ":DESCRIPTION" << endl;
		QuoteStringStream((*(This->ofp)),c->description);
		(*(This->ofp)) << ")" << endl;
	}
	if (!(*(This->ofp))) return 1;
	else return 0;
}

int TkvBTree::PrintListRecordV1(CoreItem* item,int,vBTree::UserData ud)
{
	while (Tcl_DoOneEvent(TCL_DONT_WAIT)) ;
	TkvBTree *This = (TkvBTree*)ud;
	int indent = 0;
	int column = 0;
	QuoteStringBuffer(This->buffer,item->key);
	(*(This->ofp)) << This->buffer << " ";
	indent += strlen(This->buffer) + 1;
	if (item->data.size <= 0) {
		(*(This->ofp)) << "#()" << endl;
	} else {
		(*(This->ofp)) << "#("; indent += 2;
		column = indent;
		ListRecord rec(&item->data);
		int numitems = rec.ElementCount();
		for (int i = 0;i < numitems; i++) {
			QuoteStringBuffer(This->buffer,rec[i]);
			if ((column + 2 + strlen(This->buffer))> 75) {
				(*(This->ofp)) << endl;
				for (int c = 0; c < indent;c++)
				    (*(This->ofp)) << " ";
				column = indent;
			}
			(*(This->ofp)) << This->buffer; column += strlen(This->buffer);
			if ((i+1) < numitems) {
				(*(This->ofp)) << ", "; column += 2;
			}
		}
		(*(This->ofp)) << ")" << endl;
	}
	if (!(*(This->ofp))) return 1;
	else return 0;
}


int TkvBTree::tkvBTreeExportV1ASCII(Tcl_Interp *interp,const char *outfile)
{
	ofstream outfp(outfile,ios::out);
	ofp = &outfp;
	int ikeys = 0;
	outfp << Tree.CountPages() << endl;
	Tree.TraverseId(CountItems,(vBTree::UserData)&ikeys);
	outfp << ikeys << endl;
	Tree.TraverseId(PrintCardRecordV1,(vBTree::UserData)this);
        if (!outfp)
        {
        	Tcl_ResetResult(interp);
        	Tcl_AppendResult(interp,"Error writing to ",outfile,(char *) NULL);
		ofp = NULL;
        	return TCL_ERROR;
        }
	ikeys = 0;
	Tree.TraverseTitle(CountItems,(vBTree::UserData)&ikeys);
	outfp << ikeys << endl;
	Tree.TraverseTitle(PrintListRecordV1,(vBTree::UserData)this);
        if (!outfp)
        {
        	Tcl_ResetResult(interp);
        	Tcl_AppendResult(interp,"Error writing to ",outfile,(char *) NULL);
		ofp = NULL;
        	return TCL_ERROR;
        }
	ikeys = 0;
	Tree.TraverseAuthor(CountItems,(vBTree::UserData)&ikeys);
	outfp << ikeys << endl;
	Tree.TraverseAuthor(PrintListRecordV1,(vBTree::UserData)this);
        if (!outfp)
        {
        	Tcl_ResetResult(interp);
        	Tcl_AppendResult(interp,"Error writing to ",outfile,(char *) NULL);
		ofp = NULL;
        	return TCL_ERROR;
        }
	ikeys = 0;
	Tree.TraverseSubj(CountItems,(vBTree::UserData)&ikeys);
	outfp << ikeys << endl;
	Tree.TraverseSubj(PrintListRecordV1,(vBTree::UserData)this);
        if (!outfp)
        {
        	Tcl_ResetResult(interp);
        	Tcl_AppendResult(interp,"Error writing to ",outfile,(char *) NULL);
		ofp = NULL;
        	return TCL_ERROR;
        }
	ofp = NULL;
	Tcl_ResetResult(interp);
	return TCL_OK;
}

static int lentonl(const char *buff)
{
	const char *p = strchr(buff,'\n');
	if (p == NULL) return strlen(buff);
	else return p - buff;
}

static int lenfromnl(const char *buff)
{
	const char *p = strrchr(buff,'\n');
	if (p == NULL) return strlen(buff);
	else return p - buff;
}

#define HasEol(buff) (strchr(buff,'\n') != NULL)

int TkvBTree::PrintCardRecordV2(CoreItem* item,int,vBTree::UserData ud)
{
	while (Tcl_DoOneEvent(TCL_DONT_WAIT)) ;
	TkvBTree *This = (TkvBTree*)ud;
	TkCardRecord tkc(item);
	Tcl_DString result;
	Tcl_DStringInit(&result);
	Tcl_DStringAppendElement(&result,item->key);
	tkc.NoArgList(&result);
	char *list = Tcl_DStringValue(&result);
        char **listV;
        char *buffer  = NULL;
        int   bsize   = 0;
        int   flags;
        int    listC,icol,ielt;
        if (Tcl_SplitList(This->intp,list,&listC,&listV) != TCL_OK)
        {
        	return 1;
        }
        (*(This->ofp)) << "{";
        icol = 1;
        int needSP = 0;
        for (ielt = 0; ielt < listC; ielt++) {
        	int need = Tcl_ScanElement(listV[ielt],&flags);
        	if (need > bsize)
        	{
        		if (buffer != NULL) delete buffer;
        		buffer = new char[need+1];
        		bsize = need;
        	}
        	Tcl_ConvertElement(listV[ielt],buffer,flags);
        	int ieol = icol + lentonl(buffer) + needSP;
        	if (ieol > 80)
        	{
        		//(*(This->ofp)) << " \\"
			(*(This->ofp)) << endl;
        		needSP = 0;
        		icol = lenfromnl(buffer);
        	} else
        	{
        		if (HasEol(buffer)) {
        			icol = lenfromnl(buffer);
        		} else
        		{
        			icol = ieol;
        		}
        	}
        	if (needSP) (*(This->ofp)) << " ";
        	(*(This->ofp)) << buffer;
        	needSP = 1;
        }
        Tcl_Free((char*)listV);
        delete buffer;
        (*(This->ofp)) << "}";
	(*(This->ofp)) << endl;
	Tcl_DStringFree(&result);
	if (!(*(This->ofp))) return 1;
	else return 0;
}

int TkvBTree::PrintListRecordV2(CoreItem* item,int,vBTree::UserData ud)
{
	while (Tcl_DoOneEvent(TCL_DONT_WAIT)) ;
	TkvBTree *This = (TkvBTree*)ud;
	(*(This->ofp)) << "{";
	char *buffer  = NULL;
	int   bsize   = 0;
	int   flags;
        int   icol,ielt;
	icol = 1;
	int needSP = 0;
	int need = Tcl_ScanElement(item->key,&flags);
	if (need > bsize)
	{
		if (buffer != NULL) delete buffer;
		buffer = new char[need+1];
		bsize = need;
	}
	Tcl_ConvertElement(item->key,buffer,flags);
	int ieol = icol + lentonl(buffer) + needSP;
	if (ieol > 80)
	{
       		//(*(This->ofp)) << " \\" 
		(*(This->ofp)) << endl;
       		needSP = 0;
       		icol = lenfromnl(buffer);
       	} else
       	{
       		if (HasEol(buffer)) {
       			icol = lenfromnl(buffer);
       		} else
       		{
       			icol = ieol;
       		}
       	}
       	if (needSP) (*(This->ofp)) << " ";
       	(*(This->ofp)) << buffer;
       	needSP = 1;
	if (item->data.size > 0)
	{
		ListRecord rec(&item->data);
		int numitems = rec.ElementCount();
		for (int i = 0;i < numitems; i++)
		{
			need = Tcl_ScanElement(rec[i],&flags);
			if (need > bsize)
			{
				if (buffer != NULL) delete buffer;
				buffer = new char[need+1];
				bsize = need;
			}
			Tcl_ConvertElement(rec[i],buffer,flags);
	        	ieol = icol + lentonl(buffer) + needSP;
	        	if (ieol > 80)
	        	{
	        		//(*(This->ofp)) << " \\" 
				(*(This->ofp)) << endl;
	        		needSP = 0;
	        		icol = lenfromnl(buffer);
	        	} else
	        	{
	        		if (HasEol(buffer)) {
	        			icol = lenfromnl(buffer);
	        		} else
	        		{
	        			icol = ieol;
	        		}
	        	}
	        	if (needSP) (*(This->ofp)) << " ";
	        	(*(This->ofp)) << buffer;
	        	needSP = 1;
		}
	}
        delete buffer;
        (*(This->ofp)) << "}";
	(*(This->ofp))  << endl;
	if (!(*(This->ofp))) return 1;
	else return 0;
}

bool TkvBTree::needQE(const char *s) const
{
	if (strchr(s,del) != NULL) return true;
	else if (strchr(s,quoesc) != NULL) return true;
	else if (strchr(s,'\n') != NULL) return true;
	else return false;
}

int TkvBTree::PrintCardRecordDel(CoreItem* item,int,vBTree::UserData ud)
{
	while (Tcl_DoOneEvent(TCL_DONT_WAIT)) ;
	TkvBTree *This = (TkvBTree*)ud;
	CardRecord crec(item);
	static char buffer[80];
	char ch;
	const char *p = item->key;
	bool qit = This->needQE(p);
	if (!qit) (*(This->ofp)) << p << This->del;
	else
	{
		if (This->qe)
		{
			(*(This->ofp)) << This->quoesc;
			while (*p)
			{
				if (*p == This->quoesc) (*(This->ofp)) << This->quoesc;
				(*(This->ofp)) << *p++;
			}
			(*(This->ofp)) << This->quoesc << This->del;
		} else
		{
			while (*p)
			{
				if (*p == This->del || *p == This->quoesc ||
				    *p == '\n') (*(This->ofp)) << This->quoesc;
				(*(This->ofp)) << *p++;
			}
			(*(This->ofp)) << This->del;
		}
	}
	p = This->Tree.CardTypeName(crec->type);
	qit = This->needQE(p);
	if (!qit) (*(This->ofp)) << p << This->del;
	else
	{
		if (This->qe)
		{
			(*(This->ofp)) << This->quoesc;
			while (*p)
			{
				if (*p == This->quoesc) (*(This->ofp)) << This->quoesc;
				(*(This->ofp)) << *p++;
			}
			(*(This->ofp)) << This->quoesc << This->del;
		} else
		{
			while (*p)
			{
				if (*p == This->del || *p == This->quoesc ||
				    *p == '\n') (*(This->ofp)) << This->quoesc;
				(*(This->ofp)) << *p++;
			}
			(*(This->ofp)) << This->del;
		}
	}
	p = crec->author;
	qit = This->needQE(p);
	if (!qit) (*(This->ofp)) << p << This->del;
	else
	{
		if (This->qe)
		{
			(*(This->ofp)) << This->quoesc;
			while (*p)
			{
				if (*p == This->quoesc) (*(This->ofp)) << This->quoesc;
				(*(This->ofp)) << *p++;
			}
			(*(This->ofp)) << This->quoesc << This->del;
		} else
		{
			while (*p)
			{
				if (*p == This->del || *p == This->quoesc ||
				    *p == '\n') (*(This->ofp)) << This->quoesc;
				(*(This->ofp)) << *p++;
			}
			(*(This->ofp)) << This->del;
		}
	}
	p = crec->title;
	qit = This->needQE(p);
	if (!qit) (*(This->ofp)) << p << This->del;
	else
	{
		if (This->qe)
		{
			(*(This->ofp)) << This->quoesc;
			while (*p)
			{
				if (*p == This->quoesc) (*(This->ofp)) << This->quoesc;
				(*(This->ofp)) << *p++;
			}
			(*(This->ofp)) << This->quoesc << This->del;
		} else
		{
			while (*p)
			{
				if (*p == This->del || *p == This->quoesc ||
				    *p == '\n') (*(This->ofp)) << This->quoesc;
				(*(This->ofp)) << *p++;
			}
			(*(This->ofp)) << This->del;
		}
	}	
	p = crec->publisher;
	qit = This->needQE(p);
	if (!qit) (*(This->ofp)) << p << This->del;
	else
	{
		if (This->qe)
		{
			(*(This->ofp)) << This->quoesc;
			while (*p)
			{
				if (*p == This->quoesc) (*(This->ofp)) << This->quoesc;
				(*(This->ofp)) << *p++;
			}
			(*(This->ofp)) << This->quoesc << This->del;
		} else
		{
			while (*p)
			{
				if (*p == This->del || *p == This->quoesc ||
				    *p == '\n') (*(This->ofp)) << This->quoesc;
				(*(This->ofp)) << *p++;
			}
			(*(This->ofp)) << This->del;
		}
	}	
	p = crec->city;
	qit = This->needQE(p);
	if (!qit) (*(This->ofp)) << p << This->del;
	else
	{
		if (This->qe)
		{
			(*(This->ofp)) << This->quoesc;
			while (*p)
			{
				if (*p == This->quoesc) (*(This->ofp)) << This->quoesc;
				(*(This->ofp)) << *p++;
			}
			(*(This->ofp)) << This->quoesc << This->del;
		} else
		{
			while (*p)
			{
				if (*p == This->del || *p == This->quoesc ||
				    *p == '\n') (*(This->ofp)) << This->quoesc;
				(*(This->ofp)) << *p++;
			}
			(*(This->ofp)) << This->del;
		}
	}	
	p = crec->description;
	qit = This->needQE(p);
	if (!qit) (*(This->ofp)) << p << This->del;
	else
	{
		if (This->qe)
		{
			(*(This->ofp)) << This->quoesc;
			while (*p)
			{
				if (*p == This->quoesc) (*(This->ofp)) << This->quoesc;
				(*(This->ofp)) << *p++;
			}
			(*(This->ofp)) << This->quoesc << This->del;
		} else
		{
			while (*p)
			{
				if (*p == This->del || *p == This->quoesc ||
				    *p == '\n') (*(This->ofp)) << This->quoesc;
				(*(This->ofp)) << *p++;
			}
			(*(This->ofp)) << This->del;
		}
	}
	sprintf(buffer,"%d",crec->vol);
	p = buffer;
	qit = This->needQE(p);
	if (!qit) (*(This->ofp)) << p << This->del;
	else
	{
		if (This->qe)
		{
			(*(This->ofp)) << This->quoesc;
			while (*p)
			{
				if (*p == This->quoesc) (*(This->ofp)) << This->quoesc;
				(*(This->ofp)) << *p++;
			}
			(*(This->ofp)) << This->quoesc << This->del;
		} else
		{
			while (*p)
			{
				if (*p == This->del || *p == This->quoesc ||
				    *p == '\n') (*(This->ofp)) << This->quoesc;
				(*(This->ofp)) << *p++;
			}
			(*(This->ofp)) << This->del;
		}
	}
	sprintf(buffer,"%d",crec->year);
	p = buffer;
	qit = This->needQE(p);
	if (!qit) (*(This->ofp)) << p << This->del;
	else
	{
		if (This->qe)
		{
			(*(This->ofp)) << This->quoesc;
			while (*p)
			{
				if (*p == This->quoesc) (*(This->ofp)) << This->quoesc;
				(*(This->ofp)) << *p++;
			}
			(*(This->ofp)) << This->quoesc << This->del;
		} else
		{
			while (*p)
			{
				if (*p == This->del || *p == This->quoesc ||
				    *p == '\n') (*(This->ofp)) << This->quoesc;
				(*(This->ofp)) << *p++;
			}
			(*(This->ofp)) << This->del;
		}
	}
	p = This->Tree.LocationTypeName(crec->ltype);
	qit = This->needQE(p);
	if (!qit) (*(This->ofp)) << p << This->del;
	else
	{
		if (This->qe)
		{
			(*(This->ofp)) << This->quoesc;
			while (*p)
			{
				if (*p == This->quoesc) (*(This->ofp)) << This->quoesc;
				(*(This->ofp)) << *p++;
			}
			(*(This->ofp)) << This->quoesc << This->del;
		} else
		{
			while (*p)
			{
				if (*p == This->del || *p == This->quoesc ||
				    *p == '\n') (*(This->ofp)) << This->quoesc;
				(*(This->ofp)) << *p++;
			}
			(*(This->ofp)) << This->del;
		}
	}
	p = crec->locdetail;
	qit = This->needQE(p);
	if (!qit) (*(This->ofp)) << p << This->del;
	else
	{
		if (This->qe)
		{
			(*(This->ofp)) << This->quoesc;
			while (*p)
			{
				if (*p == This->quoesc) (*(This->ofp)) << This->quoesc;
				(*(This->ofp)) << *p++;
			}
			(*(This->ofp)) << This->quoesc << This->del;
		} else
		{
			while (*p)
			{
				if (*p == This->del || *p == This->quoesc ||
				    *p == '\n') (*(This->ofp)) << This->quoesc;
				(*(This->ofp)) << *p++;
			}
			(*(This->ofp)) << This->del;
		}
	}
	p = This->Tree.Category(crec->catcode);
	qit = This->needQE(p);
	if (!qit) (*(This->ofp)) << p << endl;
	else
	{
		if (This->qe)
		{
			(*(This->ofp)) << This->quoesc;
			while (*p)
			{
				if (*p == This->quoesc) (*(This->ofp)) << This->quoesc;
				(*(This->ofp)) << *p++;
			}
			(*(This->ofp)) << This->quoesc << endl;
		} else
		{
			while (*p)
			{
				if (*p == This->del || *p == This->quoesc ||
				    *p == '\n') (*(This->ofp)) << This->quoesc;
				(*(This->ofp)) << *p++;
			}
			(*(This->ofp)) << endl;
		}
	}
	if (!(*(This->ofp))) return 1;
	else return 0;
}

int TkvBTree::quoteLen(const char *s) const
{
	int result = 0;
	bool qit = needQE(s);
	if (!qit) return strlen(s);
	if (qe)
	{
		result++;
		while (*s)
		{
			if (*s == quoesc) result++;
			result++;
		}
		result++;
	} else
	{
		while (*s)
		{
			if (*s == del || *s == quoesc || *s == '\n') result++;
			result++;
		}
	}
	return result;
}

int TkvBTree::PrintListRecordDel(CoreItem* item,int,vBTree::UserData ud)
{
	while (Tcl_DoOneEvent(TCL_DONT_WAIT)) ;
	TkvBTree *This = (TkvBTree*)ud;
	ListRecord lrec(item);
	const char *p = item->key;
	char *p2,*p1; 
	int len,elcnt,iel;
	bool qit = This->needQE(p);
	if (!qit) (*(This->ofp)) << p << This->del;
	else
	{
		if (This->qe)
		{
			(*(This->ofp)) << This->quoesc;
			while (*p)
			{
				if (*p == This->quoesc) (*(This->ofp)) << This->quoesc;
				(*(This->ofp)) << *p++;
			}
			(*(This->ofp)) << This->quoesc << This->del;
		} else
		{
			while (*p)
			{
				if (*p == This->del || *p == This->quoesc ||
				    *p == '\n') (*(This->ofp)) << This->quoesc;
				(*(This->ofp)) << *p++;
			}
			(*(This->ofp)) << This->del;
		}
	}
	elcnt = lrec.ElementCount();
	len = 0;
	for (iel = 0; iel < elcnt; iel++)
	{
		len += This->quoteLen(lrec[iel]) + 1;
	}
	len++;
	p = (const char *) (p1 = new char[len]);
	p2 =  p1;
	for (iel = 0; iel < elcnt; iel++)
	{
		qit = This->needQE(lrec[iel]);
		if (!qit) {strcpy(p2,lrec[iel]);p2 += strlen(p2);}
		else
		{
			const char *pp = lrec[iel];
			if (This->qe)
			{
				*p2++ = This->quoesc;
				while (*pp)
				{
					if (*pp == This->quoesc) *p2++ = This->quoesc;
					*p2++ = *pp++;
				}
				*p2++ = This->quoesc;
			} else
			{
				while (*pp)
				{
					if (*pp == This->del || *pp == This->quoesc ||
					    *pp == '\n') *p2++ = This->quoesc;
					*p2++ = *pp++;
				}
			}
		}
		if ((iel+1) != elcnt) *p2++ = This->del;
	}
	*p2++ = '\0';
	qit = This->needQE(p);
	if (!qit) (*(This->ofp)) << p << endl;
	else
	{
		if (This->qe)
		{
			(*(This->ofp)) << This->quoesc;
			while (*p)
			{
				if (*p == This->quoesc) (*(This->ofp)) << This->quoesc;
				(*(This->ofp)) << *p++;
			}
			(*(This->ofp)) << This->quoesc << endl;
		} else
		{
			while (*p)
			{
				if (*p == This->del || *p == This->quoesc ||
				    *p == '\n') (*(This->ofp)) << This->quoesc;
				(*(This->ofp)) << *p++;
			}
			(*(This->ofp)) << endl;
		}
	}
	delete p1;
	if (!(*(This->ofp))) return 1;
	else return 0;
}

int TkvBTree::tkvBTreeExportV2ASCII(Tcl_Interp *interp,const char *outfile)
{
	static Card::CardType TypeVect[] = {
		Card::UC1, Card::UC2, Card::UC3, Card::UC4, Card::UC5, 
		Card::UC6, Card::UC7, Card::UC8, Card::UC9, Card::UC10
	};
	static Card::LocationType LTypeVect[] = {
		Card::UL1, Card::UL2, Card::UL3, Card::UL4, Card::UL5, 
		Card::UL6, Card::UL7, Card::UL8, Card::UL9, Card::UL10
	};
	Tcl_DString temp;
	ofstream outfp(outfile,ios::out);
	ofp = &outfp;
	intp = interp;
	int ikeys, ncats;
	outfp << "Library-V2-Ascii" << endl;
	outfp << Tree.CountPages() << endl;
	for (ikeys = 0; ikeys < (Card::NumCardTypes - Card::IndexUC1); ikeys++)
	{
		char nm[2];
		nm[0] = (char) TypeVect[ikeys];
		nm[1] = '\0';
		Tcl_DStringInit(&temp);
		Tcl_DStringAppendElement(&temp,nm);
		Tcl_DStringAppendElement(&temp,Tree.CardTypeName(TypeVect[ikeys]));
		//outfp << "{" << Tcl_DStringValue(&temp) << "}" << endl;
		outfp << Tcl_DStringValue(&temp) << endl;
		Tcl_DStringFree(&temp);
	        if (!outfp)
	        {
	        	Tcl_ResetResult(interp);
	        	Tcl_AppendResult(interp,"Error writing to ",outfile,(char *) NULL);
			ofp = NULL;
			intp = NULL;
	        	return TCL_ERROR;
	        }
	}
	for (ikeys = 0; ikeys < (Card::NumLocationTypes - Card::IndexUL1); ikeys++)
	{
		char nm[2];
		nm[0] = (char) LTypeVect[ikeys];
		nm[1] = '\0';
		Tcl_DStringInit(&temp);
		Tcl_DStringAppendElement(&temp,nm);
		Tcl_DStringAppendElement(&temp,Tree.LocationTypeName(LTypeVect[ikeys]));
		//outfp << "{" << Tcl_DStringValue(&temp) << "}" << endl;
		outfp << Tcl_DStringValue(&temp) << endl;
		Tcl_DStringFree(&temp);
	        if (!outfp)
	        {
	        	Tcl_ResetResult(interp);
	        	Tcl_AppendResult(interp,"Error writing to ",outfile,(char *) NULL);
			ofp = NULL;
			intp = NULL;
	        	return TCL_ERROR;
	        }
	}
	for (ncats=0,ikeys = 0;ikeys < 256;ikeys++)
	{
		if (strlen(Tree.Category(ikeys)) > 0) ncats++;
	}
	outfp << ncats << endl;
	for (ikeys = 0;ikeys < 256;ikeys++)
	{
		const char *cat = Tree.Category(ikeys);
		if (strlen(cat) > 0)
		{
			char ccode[8];
			Tcl_DStringInit(&temp);
			sprintf(ccode,"%d",ikeys);
			Tcl_DStringAppendElement(&temp,ccode);
			Tcl_DStringAppendElement(&temp,cat);
			//outfp << "{" << Tcl_DStringValue(&temp) << "}" << endl;
			outfp << Tcl_DStringValue(&temp) << endl;
			Tcl_DStringFree(&temp);
		        if (!outfp)
		        {
		        	Tcl_ResetResult(interp);
		        	Tcl_AppendResult(interp,"Error writing to ",outfile,(char *) NULL);
				ofp = NULL;
				intp = NULL;
		        	return TCL_ERROR;
		        }
		}
	}
	ikeys = 0;
	Tree.TraverseId(CountItems,(vBTree::UserData)&ikeys);
	outfp << ikeys << endl;
	Tree.TraverseId(PrintCardRecordV2,(vBTree::UserData)this);
        if (!outfp)
        {
        	Tcl_ResetResult(interp);
        	Tcl_AppendResult(interp,"Error writing to ",outfile,(char *) NULL);
		ofp = NULL;
        	return TCL_ERROR;
        }
	ikeys = 0;
	Tree.TraverseTitle(CountItems,(vBTree::UserData)&ikeys);
	outfp << ikeys << endl;
	Tree.TraverseTitle(PrintListRecordV2,(vBTree::UserData)this);
        if (!outfp)
        {
        	Tcl_ResetResult(interp);
        	Tcl_AppendResult(interp,"Error writing to ",outfile,(char *) NULL);
		ofp = NULL;
		intp = NULL;
        	return TCL_ERROR;
        }
	ikeys = 0;
	Tree.TraverseAuthor(CountItems,(vBTree::UserData)&ikeys);
	outfp << ikeys << endl;
	Tree.TraverseAuthor(PrintListRecordV2,(vBTree::UserData)this);
        if (!outfp)
        {
        	Tcl_ResetResult(interp);
        	Tcl_AppendResult(interp,"Error writing to ",outfile,(char *) NULL);
		ofp = NULL;
        	return TCL_ERROR;
        }
	ikeys = 0;
	Tree.TraverseSubj(CountItems,(vBTree::UserData)&ikeys);
	outfp << ikeys << endl;
	Tree.TraverseSubj(PrintListRecordV2,(vBTree::UserData)this);
        if (!outfp)
        {
        	Tcl_ResetResult(interp);
        	Tcl_AppendResult(interp,"Error writing to ",outfile,(char *) NULL);
		ofp = NULL;
		intp = NULL;
        	return TCL_ERROR;
        }
	ofp = NULL;
	Tcl_ResetResult(interp);
	return TCL_OK;
}

int TkvBTree::tkvBTreeExportDelimited(Tcl_Interp *interp,const char *outfile,
				      char delim,char quoteescape, bool qore)
{
	int numkeys;
	char *dfilename = new char[strlen(outfile)+10], *extension;
	ofstream outfp1(outfile,ios::out);
	strcpy(dfilename,outfile);
	extension = dfilename + strlen(dfilename);
	del = delim;
	quoesc = quoteescape;
	qe = qore;
	outfp1 << "# delimiter is " << del << endl;
	if (qe)
	{
		outfp1 << "# quoted with " << quoesc << endl;
	} else
	{
		outfp1 << "# escaped with " << quoesc << endl;
	}
	numkeys = 0;
	Tree.TraverseId(CountItems,(vBTree::UserData)&numkeys);
	strcpy(extension,"_cards");
	outfp1 << "# " << dfilename << ":" << numkeys << " CardRecords: <cardtype>" << del
	      << "<author>" << del << "<title>" << del << "<publisher>"
	      << del << "<city>" << del << "<description>" << del 
	      << "<volume>" << del << "<year>" << del << "<locationtype>"
	      << del << "<locationdetail>" << del << "<catcode>" << endl;
	ofstream outfp(dfilename,ios::out);
	ofp = &outfp;
	Tree.TraverseId(PrintCardRecordDel,(vBTree::UserData)this);
	if (!outfp)
	{
		Tcl_ResetResult(interp);
        	Tcl_AppendResult(interp,"Error writing to ",dfilename,(char *) NULL);
		ofp = NULL;
        	return TCL_ERROR;
        }
        outfp.close();
        numkeys = 0;
	Tree.TraverseTitle(CountItems,(vBTree::UserData)&numkeys);
	strcpy(extension,"_titles");
	outfp1 << "# " << dfilename << ":" << numkeys << " titles: <title>" << del << "<ids>" << endl;
	outfp.open(dfilename,ios::out);
	Tree.TraverseTitle(PrintListRecordDel,(vBTree::UserData)this);
	if (!outfp)
	{
		Tcl_ResetResult(interp);
        	Tcl_AppendResult(interp,"Error writing to ",dfilename,(char *) NULL);
		ofp = NULL;
        	return TCL_ERROR;
        }
        outfp.close();
        numkeys = 0;
	Tree.TraverseAuthor(CountItems,(vBTree::UserData)&numkeys);
	strcpy(extension,"_authors");
	outfp1 << "# " << dfilename << ":" << numkeys << " authors: <author>" << del << "<ids>" << endl;
	outfp.open(dfilename,ios::out);
	Tree.TraverseAuthor(PrintListRecordDel,(vBTree::UserData)this);
	if (!outfp)
	{
		Tcl_ResetResult(interp);
        	Tcl_AppendResult(interp,"Error writing to ",dfilename,(char *) NULL);
		ofp = NULL;
        	return TCL_ERROR;
        }
        outfp.close();
        numkeys = 0;
	Tree.TraverseSubj(CountItems,(vBTree::UserData)&numkeys);
	strcpy(extension,"_subjects");
	outfp1 << "# " << dfilename << ":" << numkeys << " subjects: <subject>" << del << "<ids>" << endl;
	outfp.open(dfilename,ios::out);
	Tree.TraverseSubj(PrintListRecordDel,(vBTree::UserData)this);
	if (!outfp)
	{
		Tcl_ResetResult(interp);
        	Tcl_AppendResult(interp,"Error writing to ",dfilename,(char *) NULL);
		ofp = NULL;
        	return TCL_ERROR;
        }
	outfp.close();
	ofp = NULL;	
	Tcl_ResetResult(interp);
	return TCL_OK;
}


int TkvBTree::tkvBTreeExportFormatted(Tcl_Interp *interp,const char *outfile)
{
	int numkeys;
	ofstream outfp1(outfile,ios::out);
	
	numkeys = 0;
	Tree.TraverseId(CountItems,(vBTree::UserData)&numkeys);
	outfp1 << numkeys << " Cards:" << endl;
	ofp = &outfp1;
	Tree.TraverseId(PrintCardRecordFmt,(vBTree::UserData)this);
	if (!outfp1)
	{
		Tcl_ResetResult(interp);
        	Tcl_AppendResult(interp,"Error writing to ",outfile,(char *) NULL);
		ofp = NULL;
        	return TCL_ERROR;
        }
        numkeys = 0;
	Tree.TraverseTitle(CountItems,(vBTree::UserData)&numkeys);
	outfp1 << numkeys << " Titles:" << endl;
	Tree.TraverseTitle(PrintListRecordFmt,(vBTree::UserData)this);
	if (!outfp1)
	{
		Tcl_ResetResult(interp);
        	Tcl_AppendResult(interp,"Error writing to ",outfile,(char *) NULL);
		ofp = NULL;
        	return TCL_ERROR;
        }
        numkeys = 0;
	Tree.TraverseAuthor(CountItems,(vBTree::UserData)&numkeys);
	outfp1 << numkeys << " Authors:" << endl;
	Tree.TraverseAuthor(PrintListRecordFmt,(vBTree::UserData)this);
	if (!outfp1)
	{
		Tcl_ResetResult(interp);
        	Tcl_AppendResult(interp,"Error writing to ",outfile,(char *) NULL);
		ofp = NULL;
        	return TCL_ERROR;
        }
        numkeys = 0;
	Tree.TraverseSubj(CountItems,(vBTree::UserData)&numkeys);
	outfp1 << numkeys << " Subjects:" << endl;
	Tree.TraverseSubj(PrintListRecordFmt,(vBTree::UserData)this);
	if (!outfp1)
	{
		Tcl_ResetResult(interp);
        	Tcl_AppendResult(interp,"Error writing to ",outfile,(char *) NULL);
		ofp = NULL;
        	return TCL_ERROR;
        }
	ofp = NULL;	
	Tcl_ResetResult(interp);
	return TCL_OK;
}

int TkvBTree::PrintCardRecordFmt(CoreItem* item,int,vBTree::UserData ud)
{
	while (Tcl_DoOneEvent(TCL_DONT_WAIT)) ;
	TkvBTree *This = (TkvBTree*)ud;
	CardRecord crec(item);

	(*(This->ofp)) << item->key << ":" << endl;
	(*(This->ofp)) << "\tType: "            << This->Tree.CardTypeName(crec->type) << endl;
	(*(This->ofp)) << "\tAuthor: "          << crec->author << endl;
	(*(This->ofp)) << "\tTitle: "           << crec->title << endl;
	(*(This->ofp)) << "\tPublisher: "       << crec->publisher << endl;
	(*(This->ofp)) << "\tCity: "            << crec->city << endl;
	(*(This->ofp)) << "\tDescription: "     << crec->description << endl;
	(*(This->ofp)) << "\tVolume: "          << crec->vol << endl;
	(*(This->ofp)) << "\tYear: "            << crec->year << endl;
	(*(This->ofp)) << "\tLocation Type: "   << This->Tree.LocationTypeName(crec->ltype) << endl;
	(*(This->ofp)) << "\tLocation Detail: " << crec->locdetail << endl;
	(*(This->ofp)) << "\tCategory: "        << This->Tree.Category(crec->catcode) << endl;
	(*(This->ofp)) << endl;
	if (!(*(This->ofp))) return 1;
	else return 0;
}

int TkvBTree::PrintListRecordFmt(CoreItem* item,int,vBTree::UserData ud)
{
	while (Tcl_DoOneEvent(TCL_DONT_WAIT)) ;
	TkvBTree *This = (TkvBTree*)ud;
	ListRecord lrec(item);
	int elcnt,iel;

	(*(This->ofp)) << item->key << ":" << endl;
	elcnt = lrec.ElementCount();
	for (iel = 0; iel < elcnt; iel++)
	{
		int inum = iel + 1;
		(*(This->ofp)) << "\t" << inum << ": " << lrec[iel] << endl;
	}
	(*(This->ofp)) << endl;
	if (!(*(This->ofp))) return 1;
	else return 0;
}
