/* 
 * ------------------------------------------------------------------
 * Home Libarian 1.1 by Deepwoods Software
 * ------------------------------------------------------------------
 * TkvBTree.h - Tcl interface for the vBTree class
 * Created by Robert Heller on Wed Jul  2 17:27:49 1997
 * ------------------------------------------------------------------
 * Modification History: 
 * $Log: TkvBTree.h,v $
 * Revision 2.5  1999/04/07 23:16:14  heller
 * Update for RedHat 5.2 (glibc / egcs)
 *
 * Revision 2.4  1998/02/15 18:39:48  heller
 * Update for additional inport (delimited) and export (formatted)
 *
 * Revision 2.3  1998/01/29 00:09:04  heller
 * Update for Inport/Export
 * Add Tcl_DoOneEvent() call to general traversal functions
 *
 * Revision 2.2  1997/09/13 05:27:10  heller
 * Add in V1 Import and Export code
 *
 * Revision 2.1  1997/07/26 05:55:19  heller
 * Fix things to isolate results from re-use of the interpreter during event
 * processing.
 *
 * Revision 2.0  1997/07/06 21:47:28  heller
 * *** empty log message ***
 *
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Home Librarian Database -- a program for maintaining a database
 *                                for a home library
 *     Copyright (C) 1991-1997  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

#ifndef _TKVBTREE_H_
#define _TKVBTREE_H_

#include <TkCppWraper.h>
#include <vBTree.h>
#include <iostream.h>
#include <ListRecord.h>

#ifdef macintosh

#include <Files.h>

class FSpFromPath {
	Boolean IsValid;
	FSSpec	theSpec;
public:
	FSpFromPath (const char * fullPath);
	operator const FSSpec * () const;
};

#endif


class TkvBTree : public TkCppWraper {
	struct DStringAndKey {
		Tcl_DString *travDstring;
		Key subjkey;
	};
	struct interpAndScript {
		Tcl_Interp *travinterp;
		const char *script;
	};	
	virtual const char *HandleKey() const;
	virtual int TclFunction(Tcl_Interp *interp,int argc, char *argv[]);
	int tkvBTreeExportV1ASCII(Tcl_Interp *interp,const char *outfile);
	int tkvBTreeExportV2ASCII(Tcl_Interp *interp,const char *outfile);
	int tkvBTreeExportDelimited(Tcl_Interp *interp,const char *outfile,
				    char delim,char quoteescape, bool qore);
	int tkvBTreeExportFormatted(Tcl_Interp *interp,const char *outfile);
	bool tkvBTreeImportDelimitedCardRecs(Tcl_Interp *interp,int numKeys,const char *inf1,const char *inf2);
	bool tkvBTreeImportDelimitedTitleRecs(Tcl_Interp *interp,int numKeys,const char *inf1,const char *inf2);
	bool tkvBTreeImportDelimitedAuthorRecs(Tcl_Interp *interp,int numKeys,const char *inf1,const char *inf2);
	bool tkvBTreeImportDelimitedSubjRecs(Tcl_Interp *interp,int numKeys,const char *inf1,const char *inf2);
	const char *GetNextDelimitedToken(istream &stream,bool eolIsDelimeter) const;
	const char *GetNextDelimitedToken(const char **str,bool eosIsDelimeter) const;
	const ListRecord *PeelDelimitedTokenList(const char *idlist) const;
	char buffer[2048];
	static int PrintCardRecordV1(CoreItem* item,int,vBTree::UserData ud);
	static int PrintListRecordV1(CoreItem* item,int,vBTree::UserData ud);
	static int PrintCardRecordV2(CoreItem* item,int,vBTree::UserData ud);
	static int PrintListRecordV2(CoreItem* item,int,vBTree::UserData ud);
	static int PrintCardRecordDel(CoreItem* item,int,vBTree::UserData ud);
	static int PrintListRecordDel(CoreItem* item,int,vBTree::UserData ud);
	static int PrintCardRecordFmt(CoreItem* item,int,vBTree::UserData ud);
	static int PrintListRecordFmt(CoreItem* item,int,vBTree::UserData ud);
	bool needQE(const char *s) const;
	int quoteLen(const char *s) const;
	char del, quoesc;
	bool qe;
	ostream *ofp;
	Tcl_Interp *intp;
	char *fileName;
	vBTree Tree;
	HLEnums::OpenMode _mode;
	static int  TclTraverseIds(CoreItem* item,int,vBTree::UserData ud);
	static int  TclTraverseLists(CoreItem* item,int,vBTree::UserData ud);
	static int  ExamineSubj(CoreItem* item,int,vBTree::UserData ud);
	static int  CountItems(CoreItem* item,int,vBTree::UserData ud);
	static void TclErrorHandler(HLEnums::ErrKind,const char*,vBTree::UserData);
	char ErrorBuffer[2048];
	HLEnums::ErrKind ErrorKind;
	Boolean WasError;
	void FormatError(Tcl_Interp *interp) const;
public:
	virtual const char* MyType() const;
	TkvBTree(const char *filename,
		 HLEnums::OpenMode mode = HLEnums::ReadOnly, 
		 int nfree = MaxNumFree / 10);
	virtual ~TkvBTree();
	static int tkvBTreeCreate(ClientData ,Tcl_Interp *interp,int argc, char *argv[]);
	static int tkvBTreeImportV1ASCII(ClientData ,Tcl_Interp *interp,int argc, char *argv[]);
	static int tkvBTreeImportV2ASCII(ClientData ,Tcl_Interp *interp,int argc, char *argv[]);
	static int tkvBTreeImportDelimited(ClientData ,Tcl_Interp *interp,int argc, char *argv[]);
	static int Init_TkvBTree(Tcl_Interp *interp);
};
	

#endif // _TKVBTREE_H_

