/* 
 * ------------------------------------------------------------------
 * Home Libarian 1.1 by Deepwoods Software
 * ------------------------------------------------------------------
 * TkvBTree.cc - Tcl interface for the vBTree class
 * Created by Robert Heller on Fri Jul  4 08:29:13 1997
 * ------------------------------------------------------------------
 * Modification History: 
 * $Log: TkvBTree.cc,v $
 * Revision 2.11  1998/05/16 23:43:28  heller
 * Add indexing to the documentation.
 *
 * Revision 2.10  1998/02/15 18:39:09  heller
 * Update for additional inport (delimited) and export (formatted)
 *
 * Revision 2.9  1998/01/29 00:09:04  heller
 * Update for Inport/Export
 * Add Tcl_DoOneEvent() call to general traversal functions
 *
 * Revision 2.8  1997/09/13 05:27:10  heller
 * Add in V1 Import and Export code
 *
 * Revision 2.7  1997/08/10 21:44:26  heller
 * Fix ill card type message and documentation
 *
 * Revision 2.6  1997/08/10 16:41:29  heller
 * Add in "fetchauthors" and "fetchtitles"
 *
 * Revision 2.5  1997/07/27 04:48:22  heller
 * Add additional functions for title, author, and subject tree access
 * from tcl
 *
 * Revision 2.4  1997/07/26 05:55:19  heller
 * Fix things to isolate results from re-use of the interpreter during event
 * processing.
 *
 * Revision 2.3  1997/07/23 23:48:28  heller
 * Fix spelling errors.
 *
 * Revision 2.2  1997/07/20 19:50:20  heller
 * Add in documentation
 *
 * Revision 2.1  1997/07/13 13:17:20  heller
 * MacOS fixes
 *
 * Revision 2.0  1997/07/06 21:46:53  heller
 * *** empty log message ***
 *
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Home Librarian Database -- a program for maintaining a database
 *                                for a home library
 *     Copyright (C) 1991-1997  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

//@ChapterName:Tcl/Tk Interface to vBTrees
//@Man: About this chapter
/*@Doc:
  \typeout{Generated from: $Id: TkvBTree.cc,v 2.11 1998/05/16 23:43:28 heller Rel $}
  This chapter describes th Tcl/Tk interface to instances of class vBTree.
 */
 

static char ID[] = "$Id: TkvBTree.cc,v 2.11 1998/05/16 23:43:28 heller Rel $";

#include <TkvBTree.h>
#include <TkCardRecord.h>
#include <ListRecord.h>
#include <stdio.h>
#include <errno.h>
#include <iostream.h>
#include <fstream.h>

#ifdef macintosh

/* Macintosh specific stuff.  Fun and games with pathnames, vRefNums,
  and dirIds.

  (Lifted from the morefiles package and from the Mac version of Tcl/Tk.)
 */


#include <Types.h>
#include <Errors.h>
#include <Files.h>
#include <TextUtils.h>
#include <Aliases.h>

static	OSErr GetCatInfoNoName(short vRefNum,
							   long dirID,
							   StringPtr name,
							   CInfoPBPtr pb)
{
	Str31 tempName;
	OSErr error;
	
	/* Protection against File Sharing problem */
	if ( (name == NULL) || (name[0] == 0) )
	{
		tempName[0] = 0;
		pb->dirInfo.ioNamePtr = tempName;
		pb->dirInfo.ioFDirIndex = -1;	/* use ioDirID */
	}
	else
	{
		pb->dirInfo.ioNamePtr = name;
		pb->dirInfo.ioFDirIndex = 0;	/* use ioNamePtr and ioDirID */
	}
	pb->dirInfo.ioVRefNum = vRefNum;
	pb->dirInfo.ioDrDirID = dirID;
	error = PBGetCatInfoSync(pb);
	pb->dirInfo.ioNamePtr = NULL;
	return ( error );
}

static OSErr	FSMakeFSSpecCompat(short vRefNum,
								   long dirID,
								   ConstStr255Param fileName,
								   FSSpecPtr spec)
{
	OSErr	result;
	
#if !SystemSevenOrLater
	if ( FSHasFSSpecCalls() || QTHasFSSpecCalls() )
#endif	/* !SystemSevenOrLater */
	{
		/* Let the file system create the FSSpec if it can since it does the job */
		/* much more efficiently than I can. */
		result = FSMakeFSSpec(vRefNum, dirID, fileName, spec);
		/* Fix a bug in Macintosh PC Exchange's MakeFSSpec code where 0 is */
		/* returned in the parID field when making an FSSpec to the volume's */
		/* root directory by passing a full pathname in MakeFSSpec's */
		/* fileName parameter. */
		if ( (result == noErr) && (spec->parID == 0) )
			spec->parID = fsRtParID;
	}
#if !SystemSevenOrLater
	else
	{
		Boolean	isDirectory;
		
		result = GetObjectLocation(vRefNum, dirID, (StringPtr)fileName,
									&(spec->vRefNum), &(spec->parID), spec->name,
									&isDirectory);
	}
#endif	/* !SystemSevenOrLater */
	return ( result );
}

static	OSErr	GetDirectoryID(short vRefNum,
							   long dirID,
							   StringPtr name,
							   long *theDirID,
							   Boolean *isDirectory)
{
	CInfoPBRec pb;
	OSErr error;

	error = GetCatInfoNoName(vRefNum, dirID ,name, &pb);
	*isDirectory = (pb.hFileInfo.ioFlAttrib & ioDirMask) != 0;
	*theDirID = (*isDirectory) ? pb.dirInfo.ioDrDirID : pb.hFileInfo.ioFlParID;
	return ( error );
}
static	OSErr	FSpGetDirectoryID(const FSSpec *spec,
				  long *theDirID,
				  Boolean *isDirectory)
{
	return ( GetDirectoryID(spec->vRefNum, spec->parID,
				(StringPtr)spec->name,
				 theDirID, isDirectory) );
}


FSpFromPath::FSpFromPath(const char * fullPath)
{
	const char *path;
	int length;
	Str255 fileName;
	OSErr err;
	short vRefNum;
	long dirID;
	int pos, cur;
	Boolean isDirectory, wasAlias;

	path = fullPath;
	length = strlen(fullPath);
	vRefNum = 0;
	dirID = 0;
	cur = 0;
	if (length == 0 || path[cur] == ':') 
	{
		cur++;
		if (cur >= length) {
			FSMakeFSSpecCompat(0,0,NULL,&theSpec);
			return;
		}
	} else
	{
		while (path[cur] != ':' && cur < length) cur++;
		if (cur < length) 
		{
			cur++;
			strncpy((char *)fileName+1,path,cur);
			fileName[0] = cur;
			err = FSMakeFSSpecCompat(0,0,fileName,&theSpec);
			if (err != noErr)
			{
				// errno = ???
				IsValid = false;
				return;
			}
			FSpGetDirectoryID(&theSpec,&dirID,&isDirectory);
			vRefNum = theSpec.vRefNum;
		} else
		{
			cur = 0;
		}
	}

	isDirectory = 1;
	while (cur < length) {
		if (!isDirectory) {
			// errno = ???
			IsValid = false;
			return;
		}
		pos = cur;
		while (path[pos] != ':' && pos < length) {
			pos++;
		}
		if (pos == cur) {
			strcpy((char*)fileName+1,"::");
			fileName[0] = 2;
		} else {
			strncpy((char *)fileName+1,&path[cur],pos-cur);
			fileName[0] = pos-cur;
		}
		err = FSMakeFSSpecCompat(vRefNum,dirID,fileName,&theSpec);
		if (err != noErr)
		{
			// errno = ???
			IsValid = false;
			return;
		}
		FSpGetDirectoryID(&theSpec,&dirID,&isDirectory);
		vRefNum = theSpec.vRefNum;
		cur = pos;
		if (path[cur] == ':') {
			cur++;
		}
	}
	IsValid = true;
}

FSpFromPath::operator const FSSpec * () const
{
	if (IsValid) return &theSpec;
	else return NULL;
}

#endif

const char *TkvBTree::HandleKey() const {return "vBTree";}
const char *TkvBTree::MyType() const {return "vBTree";}

/* This helper function translates the string representation of
  a file mode to a HLEnums::OpenMode value.
 */

static HLEnums::OpenMode ModeFromString(const char * m)
{
	if (strcmp(m,"ReadWrite") == 0) return (HLEnums::ReadWrite);
	else if (strcmp(m,"ReadOnly") == 0) return (HLEnums::ReadOnly);
	else if (strcmp(m,"ReadWrite|Create") == 0)
		return((HLEnums::OpenMode)(HLEnums::ReadWrite|HLEnums::Create));
	else if (strcmp(m,"Create|ReadWrite") == 0)
		return((HLEnums::OpenMode)(HLEnums::ReadWrite|HLEnums::Create));
	else return(HLEnums::ReadOnly);
}


//@Man: vBTree
//@Args: filename ?mode nfree?
/*@Doc:
  \index{vBTree!Tcl Interface|(}
  \index{vBTree!Tcl Interface!Constructor}
  This Tcl command creates vBTree instance and opens a Home Librarian card
  catalog file.  The first argument (required) is the name of the file.  The
  second argument is the mode to open the file in and should be one of the
  strings ``#ReadWrite#'', ``#ReadOnly#'', or ``#Create|ReadWrite#''.  Any other 
  string will be treated as ``#ReadOnly#''.  If omitted, then the file is opened
  as if ``#ReadOnly#'' was specified. The third argument is the number of free
  pages to preallocate.  This argument only makes sense if the mode is 
  ``#Create|ReadWrite#''.  This is the number of contiguous free pages to 
  allocate when creating a new library file.  The default is 24, which is 
  about 1/10th of the max of 249.

  It returns a string which is a ``handle'' to a vBTree instance.  This
  handle is defined as a Tcl command that will access the vBTree instance.
  */


int TkvBTree::tkvBTreeCreate(ClientData ,Tcl_Interp *interp,int argc, char *argv[])
{
	TkvBTree *tkvbtree;
	HLEnums::OpenMode mode;
	int nfree;

	if (argc < 2 || argc > 4)
	{
		Tcl_AppendResult(interp, "Wrong # args: should be \"",
				 argv[0]," filename ?mode nfree?\"",
				 (char*) NULL);
		return TCL_ERROR;
	}
	switch (argc)
	{
		case 2: tkvbtree = new TkvBTree(argv[1]); break;
		case 3: mode = ModeFromString(argv[2]);
			tkvbtree = new TkvBTree(argv[1],mode);
			break;
		case 4: mode = ModeFromString(argv[2]);
			if (Tcl_GetInt(interp,argv[3],&nfree) != TCL_OK) return(TCL_ERROR);
			tkvbtree = new TkvBTree(argv[1],mode,nfree);
			break;
		default:
		Tcl_AppendResult(interp, "Wrong # args: should be \"",
				 argv[0]," filename ?mode nfree\"",
				 (char*) NULL);
		return TCL_ERROR;
	}
	if (tkvbtree->WasError)
	{
		tkvbtree->FormatError(interp);
		delete tkvbtree;
		return TCL_ERROR;
	}
	if (tkvbtree->Tree.OpenStat() == HLEnums::failure)
	{
		int err = errno;
		Tcl_AppendResult(interp, "Open Failure on file: ",argv[1],
				 ": ",strerror(err),(char*) NULL);
		delete tkvbtree;
		return TCL_ERROR;
	}
	tkvbtree->newHandle();
	Tcl_CreateCommand(interp,tkvbtree->myHandle,
			  (Tcl_CmdProc*)TkCppWraper::TclCommand,
			  (ClientData)tkvbtree,
			  (Tcl_CmdDeleteProc*)TkCppWraper::deleteTkCppWraper);
	Tcl_AppendResult(interp,tkvbtree->myHandle,(char *) NULL);
	return TCL_OK;
}

// Counter traversal callback.

int TkvBTree::CountItems(CoreItem* /*item*/,int,vBTree::UserData ud)
{
	int * ikeys = (int *)ud;
	(*ikeys)++;
	while (Tcl_DoOneEvent(TCL_DONT_WAIT)) ;
	return 0;
}

// Function to format an error for Tcl.

void TkvBTree::FormatError(Tcl_Interp *interp) const
{
	Tcl_AppendResult(interp, "An Error of type ",(char*) NULL);
	switch (ErrorKind)
	{
		case HLEnums::sysErr:
			Tcl_AppendResult(interp, "sysErr",(char*) NULL);
			break;
		case HLEnums::memErr:
			Tcl_AppendResult(interp, "memErr",(char*) NULL);
			break;
		case HLEnums::hlErr:
			Tcl_AppendResult(interp, "hlErr",(char*) NULL);
			break;
	}
	Tcl_AppendResult(interp, " occured: ",ErrorBuffer,(char*) NULL);
}

// Error handler.

void TkvBTree::TclErrorHandler(HLEnums::ErrKind ek,const char* mess,
			       vBTree::UserData ud)
{
	TkvBTree *theTree = (TkvBTree *) ud;
	strncpy(theTree->ErrorBuffer,mess,2047);
	theTree->ErrorBuffer[2047] = '\0';
	theTree->ErrorKind = ek;
	theTree->WasError = true;
}

// Subject extractor traversal callback.

int TkvBTree::ExamineSubj(CoreItem* item,int,vBTree::UserData ud)
{
	DStringAndKey * DK = (DStringAndKey *)ud;
	if (DK->travDstring == NULL) return 0;
	if (item->data.size <= 0) return 0;
	ListRecord rec(&item->data);
	int icount = rec.ElementCount();
	for (int i = 0; i < icount; i++) {
		if (strcasecmp(DK->subjkey,rec[i]) == 0) {
			Tcl_DStringAppendElement(DK->travDstring,item->key);
			return 0;
		}
		while (Tcl_DoOneEvent(TCL_DONT_WAIT)) ;
	}
	return 0;
}

// id traversal callback.

int TkvBTree::TclTraverseIds(CoreItem* item,int,vBTree::UserData ud)
{
	interpAndScript *IS = (interpAndScript *) ud;
	const char *travScript = IS->script;
	Tcl_DString script;
	static char temp[32];
	const char *head, *p, *after;
	char fmt;
	int status;

	if (IS->travinterp == NULL) return 0;
	if (travScript == NULL || *travScript == '\0') return 0;
	if (item->data.size <= 0) return 0;
	if (TkCardRecord::createTkCardRecord(IS->travinterp,item) != TCL_OK)
		return 1;
	strcpy(temp,IS->travinterp->result);
	Tcl_DStringInit(&script);
	for (head = travScript;*head != '\0';head = after)
	{
		p = strchr(head,'%');
		if (p == NULL)
		{
			Tcl_DStringAppend(&script,head,-1);
			break;
		} else
		{
			if (p > head) Tcl_DStringAppend(&script,head,(p-head));
			fmt = *(++p);
			after = ++p;
			switch (fmt)
			{
				case '\0': after = NULL; break;
				case 'i': Tcl_DStringAppend(&script,temp,-1); break;
				case 'k': Tcl_DStringAppend(&script,item->key,-1); break;
				case '%': Tcl_DStringAppend(&script,"%",-1); break;
				default: break;
			}
			if (after == NULL) break;
		}
	}
//	cerr << "*** :- script is {" << Tcl_DStringValue(&script) << "}" << endl;
	while (Tcl_DoOneEvent(TCL_DONT_WAIT)) ;
	status = Tcl_GlobalEval(IS->travinterp,Tcl_DStringValue(&script));
	Tcl_DStringFree(&script);
	TkCardRecord *rec = TkCardRecord::FindCardByHandle(temp);
	if (rec != NULL)
	{
		Tcl_DeleteCommand(IS->travinterp,temp);
	}
	if (status == TCL_OK) return 0;
	else return status;
}

// list traversal callback.

int TkvBTree::TclTraverseLists(CoreItem* item,int,vBTree::UserData ud)
{
	interpAndScript *IS = (interpAndScript *) ud;
	const char *travScript = IS->script;
	Tcl_DString script;
	static char temp[32];
	const char *head, *p, *after;
	char fmt;
	int status;
	
	if (IS->travinterp == NULL) return 0;
	if (travScript == NULL || *travScript == '\0') return 0;
	if (item->data.size <= 0) return 0;
	ListRecord rec(&item->data);
	int icount = rec.ElementCount();
	Tcl_DStringInit(&script);
	for (head = travScript;*head != '\0';head = after)
	{
		p = strchr(head,'%');
		if (p == NULL)
		{
			Tcl_DStringAppend(&script,head,-1);
			break;
		} else
		{
			if (p > head) Tcl_DStringAppend(&script,head,(p-head));
			fmt = *(++p);
			after = ++p;
			switch (fmt)
			{
				case '\0': after = NULL; break;
				case 'i':
					Tcl_DStringStartSublist(&script);
					for (int i = 0; i < icount; i++)
					{
						Tcl_DStringAppendElement(&script,rec[i]);
					}
					Tcl_DStringEndSublist(&script);
					break;
				case 'k': Tcl_DStringAppend(&script,item->key,-1); break;
				case '%': Tcl_DStringAppend(&script,"%",1); break;
				default: break;
			}
			if (after == NULL) break;
		}
	}
	while (Tcl_DoOneEvent(TCL_DONT_WAIT)) ;
	status = Tcl_GlobalEval(IS->travinterp,Tcl_DStringValue(&script));
	Tcl_DStringFree(&script);
	if (status == TCL_OK) return 0;
	else return status;
}

//@Man: vBTree ``Handle''
//@Args: ?option optionargs?
//@See: vBTree
/*@Doc:
  \index{vBTree!Tcl Interface!Handle options|(}
  The string returned by the vBTree command is itself a Tcl command.
  This command provides access to the vBTree instance.
 */
//@{

int TkvBTree::TclFunction(Tcl_Interp *interp,int argc, char *argv[])
{
	static char tempstring[256];

	//@Man: \ 
	/*@Doc:
	  When called with no arguments, the vBTree ``Handle'' returns
	  a Tcl list containing the current contents (state) of the vBTree
	  instance.  The list contains:
	  \begin{description}
	 */

	if (argc == 1)
	{
		// no option, echo slots
		//@Doc: \item[\ ] The string ``vBTree''.
		Tcl_DString result;
		Tcl_DStringInit(&result);
		Tcl_DStringAppendElement(&result,"vBTree");

		/*@Doc: \item[\ ] A list containing the string ``FileName''
		  and the filename. */
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"FileName");
		Tcl_DStringAppendElement(&result,(const char*)fileName);
		Tcl_DStringEndSublist(&result);

		/*@Doc: \item[\ ] A list containing the string ``Mode''
		  and the mode.*/
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Mode");
		switch (_mode)
		{
			case HLEnums::ReadOnly: Tcl_DStringAppendElement(&result,"ReadOnly");
				       break;
			case HLEnums::ReadWrite: Tcl_DStringAppendElement(&result,"ReadWrite");
				       break;
			default: break;
		}
		Tcl_DStringEndSublist(&result);			

		/*@Doc: \item[\ ] A list containing the string ``OpenStat''
		  and the open status.*/
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"OpenStat");
		switch (Tree.OpenStat())
		{
			case HLEnums::failure: Tcl_DStringAppendElement(&result,"failure");
				      break;
			case HLEnums::openold: Tcl_DStringAppendElement(&result,"openold");
				      break;
			case HLEnums::opennew: Tcl_DStringAppendElement(&result,"opennew");
				      break;
		}
		Tcl_DStringEndSublist(&result);

		/*@Doc: \end{description} */
		Tcl_DStringResult(interp,&result);
		return TCL_OK;
	}
	if (argc < 2)
	{
		Tcl_AppendResult(interp, "wrong # args: should be \"",
				 argv[0], " option ?arg arg ...?\"",
				 (char *) NULL);
		return TCL_ERROR;
	}
	//@Man: type
	//@Doc: With the option ``type'', the string ``vBTree'' is returned.
	if (strcmp(argv[1], "type") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],(char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp, "vBTree", (char *) NULL);
		return TCL_OK;
	//@Man: openstat
	/*@Doc: With the option ``openstat'', the open status is returned.
	  One of the strings ``failure'', ``openold'', or ``opennew'' is 
	  returned, which describe the status of the open file.
	 */
	} else if (strcmp(argv[1], "openstat") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		switch (Tree.OpenStat())
		{
			case HLEnums::failure: Tcl_AppendElement(interp, "failure"); break;
			case HLEnums::openold: Tcl_AppendElement(interp, "openold"); break;
			case HLEnums::opennew: Tcl_AppendElement(interp, "opennew"); break;
		}
		return TCL_OK;
	//@Man: mode
	/*@Doc: With the option ``mode'', the mode the file was opened is
	  returned.  Either ``ReadOnly'' or ``ReadWrite''.
	 */
	} else if (strcmp(argv[1], "mode") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		switch (_mode)
		{
			case HLEnums::ReadOnly: Tcl_AppendElement(interp, "ReadOnly"); break;
			case HLEnums::ReadWrite:Tcl_AppendElement(interp, "ReadWrite"); break;
			default: break;
		}
		return TCL_OK;
	//@Man: filename
	/*@Doc: With the option ``filename'', the filename of the file is
	  returned.
	 */
	} else if (strcmp(argv[1], "filename") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendElement(interp,(const char*)fileName);
		return TCL_OK;
	//@Man: searchids
	//@Args: ?key?
	/*@Doc: With the option ``searchids'', the file is searched for id
	  prefixes matching ``key''.  A list of matching keys is returned.
	  If ``key'' is omitted, all ids in the file are listed.
	 */
	} else if (strcmp(argv[1], "searchids") == 0)
	{
		Key searchkey;
		if (argc == 2) searchkey[0] = '\0';
		else if (argc == 3)
		{
			strncpy(searchkey,argv[2],KeySize-1);
			searchkey[KeySize-1] = '\0';
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?key?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		Tcl_DString result;
		Tcl_DStringInit(&result);
		CoreItem item;
		if (Tree.SearchId(searchkey,&item))
		{
			do {
				Tcl_DStringAppendElement(&result,(const char*)item.key);
				while (Tcl_DoOneEvent(TCL_DONT_WAIT)) ;
			} while (Tree.SearchIdAgain(&item));
		}
		if (WasError)
		{
			Tcl_DStringFree(&result);
			FormatError(interp);
			return TCL_ERROR;
		}
		Tcl_DStringResult(interp,&result);
		return TCL_OK;
	//@Man: readid
	//@Args: key
	/*@Doc: With the option ``readid'', a CardRecord is read in and a 
	  handle to it is returned. (See Chapter \ref{TkCardRecord}.)
	 */
	} else if (strcmp(argv[1], "readid") == 0)
	{
		Key searchkey;
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," key\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		CoreItem item;
		strncpy(searchkey,argv[2],KeySize-1);
		searchkey[KeySize-1] = '\0';
		if (Tree.SearchId(searchkey,&item) &&
		    strlen(searchkey) == strlen(item.key))
		{
			return TkCardRecord::createTkCardRecord(interp,&item);
		} else if (WasError)
		{
			FormatError(interp);
			return TCL_ERROR;
		} else
		{
			return TCL_OK;
		}
	//@Man: searchtitles
	//@Args: ?key?
	/*@Doc: With the option ``searchtitles'', the file is searched for
	  title prefixes matching ``key''.  A list of matching keys is 
	  returned.  If ``key'' is omitted, a list of all titles is returned.
	 */
	} else if (strcmp(argv[1], "searchtitles") == 0)
	{
		Key searchkey;
		if (argc == 2) searchkey[0] = '\0';
		else if (argc == 3)
		{
			strncpy(searchkey,argv[2],KeySize-1);
			searchkey[KeySize-1] = '\0';
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?key?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		Tcl_DString result;
		Tcl_DStringInit(&result);
		CoreItem item;
		if (Tree.SearchTitle(searchkey,&item))
		{
			do {
				Tcl_DStringAppendElement(&result,(const char*)item.key);
				while (Tcl_DoOneEvent(TCL_DONT_WAIT)) ;
			} while (Tree.SearchTitleAgain(&item));
		}
		if (WasError)
		{
			Tcl_DStringFree(&result);
			FormatError(interp);
			return TCL_ERROR;
		}
		Tcl_DStringResult(interp,&result);
		return TCL_OK;
	//@Man: readtitlelist
	//@Args: key
	/*@Doc: With the option ``readtitlelist'', a list of ids for the title
	  matching ``key'' is returned.
	 */
	} else if (strcmp(argv[1], "readtitlelist") == 0)
	{
		Key searchkey;
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," key\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		CoreItem item;
		strncpy(searchkey,argv[2],KeySize-1);
		searchkey[KeySize-1] = '\0';
		if (Tree.SearchTitle(searchkey,&item) &&
		    strlen(searchkey) == strlen(item.key))
		{
			ListRecord rec(&item.data);
			int elc = rec.ElementCount();
			for (int i = 0;i < elc;i++)
			{
				Tcl_AppendElement(interp,(const char*)rec[i]);
			}
			return  TCL_OK;
		} else if (WasError)
		{
			FormatError(interp);
			return TCL_ERROR;
		} else
		{
			return TCL_OK;
		}
	//@Man: searchauthors
	//@Args: ?key?
	/*@Doc: With the option ``searchauthors'', the file is searched for
	  author prefixes matching ``key''.  A list of matching keys is 
	  returned.  If ``key'' is omitted, a list of all authors is returned.
	 */
	} else if (strcmp(argv[1], "searchauthors") == 0)
	{
		Key searchkey;
		if (argc == 2) searchkey[0] = '\0';
		else if (argc == 3)
		{
			strncpy(searchkey,argv[2],KeySize-1);
			searchkey[KeySize-1] = '\0';
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?key?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		Tcl_DString result;
		Tcl_DStringInit(&result);
		CoreItem item;
		if (Tree.SearchAuthor(searchkey,&item))
		{
			do {
				Tcl_DStringAppendElement(&result,(const char*)item.key);
				while (Tcl_DoOneEvent(TCL_DONT_WAIT)) ;
			} while (Tree.SearchAuthorAgain(&item));
		}
		if (WasError)
		{
			Tcl_DStringFree(&result);
			FormatError(interp);
			return TCL_ERROR;
		}
		Tcl_DStringResult(interp,&result);
		return TCL_OK;
	//@Man: readauthorlist
	//@Args: key
	/*@Doc: With the option ``readauthorlist'', a list of ids for the
	  author matching ``key'' is returned.
	 */
	} else if (strcmp(argv[1], "readauthorlist") == 0)
	{
		Key searchkey;
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," key\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		CoreItem item;
		strncpy(searchkey,argv[2],KeySize-1);
		searchkey[KeySize-1] = '\0';
		if (Tree.SearchAuthor(searchkey,&item) &&
		    strlen(searchkey) == strlen(item.key))
		{
			ListRecord rec(&item.data);
			int elc = rec.ElementCount();
			for (int i = 0;i < elc;i++)
			{
				Tcl_AppendElement(interp,(const char*)rec[i]);
			}
			return  TCL_OK;
		} else if (WasError)
		{
			FormatError(interp);
			return TCL_ERROR;
		} else
		{
			return TCL_OK;
		}
	//@Man: searchsubjects
	//@Args: ?key?
	/*@Doc: With the option ``searchsubjects'', the file is searched for
	  subject prefixes matching ``key''.  A list of matching keys is 
	  returned.  If ``key'' is omitted, a list of all subjects is returned.
	 */
	} else if (strcmp(argv[1], "searchsubjects") == 0)
	{
		Key searchkey;
		if (argc == 2) searchkey[0] = '\0';
		else if (argc == 3)
		{
			strncpy(searchkey,argv[2],KeySize-1);
			searchkey[KeySize-1] = '\0';
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?key?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		Tcl_DString result;
		Tcl_DStringInit(&result);
		CoreItem item;
		if (Tree.SearchSubj(searchkey,&item))
		{
			do {
				Tcl_DStringAppendElement(&result,(const char*)item.key);
				while (Tcl_DoOneEvent(TCL_DONT_WAIT)) ;
			} while (Tree.SearchSubjAgain(&item));
		}
		if (WasError)
		{
			Tcl_DStringFree(&result);
			FormatError(interp);
			return TCL_ERROR;
		}
		Tcl_DStringResult(interp,&result);
		return TCL_OK;
	//@Man: readsubjectlist
	//@Args: key
	/*@Doc: With the option ``readsubjectlist'', a list of ids for the
	  subject matching ``key'' is returned.
	 */
	} else if (strcmp(argv[1], "readsubjectlist") == 0)
	{
		Key searchkey;
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," key\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		CoreItem item;
		strncpy(searchkey,argv[2],KeySize-1);
		searchkey[KeySize-1] = '\0';
		if (Tree.SearchSubj(searchkey,&item) &&
		    strlen(searchkey) == strlen(item.key))
		{
			ListRecord rec(&item.data);
			int elc = rec.ElementCount();
			for (int i = 0;i < elc;i++)
			{
				Tcl_AppendElement(interp,(const char*)rec[i]);
			}
			return  TCL_OK;
		} else if (WasError)
		{
			FormatError(interp);
			return TCL_ERROR;
		} else
		{
			return TCL_OK;
		}
	//@Man: fetchsubjs
	//@Args: idkey
	/*@Doc: With the option ``fetchsubjs'', a list of subjects that list
	  the specified ``idkey'' is returned.
	 */
	} else if (strcmp(argv[1], "fetchsubjs") == 0)
	{
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," idkey\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		DStringAndKey DK;
		strncpy(DK.subjkey,argv[2],KeySize-1);
		DK.subjkey[KeySize-1] = '\0';
		Tcl_DString SubjectList;
		Tcl_DStringInit(&SubjectList);
		DK.travDstring = &SubjectList;
		int status = Tree.TraverseSubj(ExamineSubj,(vBTree::UserData)&DK);
		if (status != 0) {
			Tcl_DStringFree(&SubjectList);
			return status;
		}
		if (WasError)
		{
			Tcl_DStringFree(&SubjectList);
			FormatError(interp);
			return TCL_ERROR;
		}
		Tcl_DStringResult(interp,&SubjectList);
		return TCL_OK;
	//@Man: fetchauthors
	//@Args: idkey
	/*@Doc: With the option ``fetchauthors'', a list of authors that list
	  the specified ``idkey'' is returned.
	 */
	} else if (strcmp(argv[1], "fetchauthors") == 0)
	{
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," idkey\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		DStringAndKey DK;
		strncpy(DK.subjkey,argv[2],KeySize-1);
		DK.subjkey[KeySize-1] = '\0';
		Tcl_DString SubjectList;
		Tcl_DStringInit(&SubjectList);
		DK.travDstring = &SubjectList;
		int status = Tree.TraverseAuthor(ExamineSubj,(vBTree::UserData)&DK);
		if (status != 0) {
			Tcl_DStringFree(&SubjectList);
			return status;
		}
		if (WasError)
		{
			Tcl_DStringFree(&SubjectList);
			FormatError(interp);
			return TCL_ERROR;
		}
		Tcl_DStringResult(interp,&SubjectList);
		return TCL_OK;
	//@Man: fetchtitles
	//@Args: idkey
	/*@Doc: With the option ``fetchtitles'', a list of titles that list
	  the specified ``idkey'' is returned.
	 */
	} else if (strcmp(argv[1], "fetchtitles") == 0)
	{
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," idkey\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		DStringAndKey DK;
		strncpy(DK.subjkey,argv[2],KeySize-1);
		DK.subjkey[KeySize-1] = '\0';
		Tcl_DString SubjectList;
		Tcl_DStringInit(&SubjectList);
		DK.travDstring = &SubjectList;
		int status = Tree.TraverseTitle(ExamineSubj,(vBTree::UserData)&DK);
		if (status != 0) {
			Tcl_DStringFree(&SubjectList);
			return status;
		}
		if (WasError)
		{
			Tcl_DStringFree(&SubjectList);
			FormatError(interp);
			return TCL_ERROR;
		}
		Tcl_DStringResult(interp,&SubjectList);
		return TCL_OK;
	//@Man: updatesubjs
	//@Args: subjs osubjs idkey
	/*@Doc: The option ``updatesubjs'' updates the subject listing for the
	  specified ``idkey''.  ``Subjs'' is the new subject list, ``osubjs''
	  is the old subject list.
	 */
	} else if (strcmp(argv[1], "updatesubjs") == 0)
	{
		Key key;
		int subjc,osubjc,is1,is2;
		char **subjv,**osubjv;

		if (_mode != HLEnums::ReadWrite)
		{
			Tcl_AppendResult(interp, "ReadOnly file!",(char *) NULL);
			return TCL_ERROR;
		}
		if (argc != 5)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],
					 " subjs osubjs idkey\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		strncpy(key,argv[4],KeySize-1);
		key[KeySize-1] = '\0';
		if (Tcl_SplitList(interp, argv[2], &subjc, &subjv) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_SplitList(interp, argv[3], &osubjc, &osubjv) != TCL_OK)
		{
			Tcl_Free((char*)subjv);
			return TCL_ERROR;
		}
		for (is1 = 0; is1 < osubjc;is1++)
		{
			Boolean retain = false;
			for (is2 = 0; is2 < subjc;is2++)
			{
				if (strncasecmp(osubjv[is1],
						subjv[is2],
						KeySize-1) == 0)
				{
					retain = true;
					break;
				}
			}
			if (!retain)
			{
				CoreItem temp;
				Key skey;
				strncpy(skey,osubjv[is1],KeySize-1);
				skey[KeySize-1] = '\0';
				if (Tree.SearchSubj(skey,&temp) &&
				    strlen(skey) == strlen(temp.key))
				{
					ListRecord rec(&temp.data);
					int outitems = rec.RemoveElement(key);
					if (outitems == 0)
					{
						Tree.DeleteSubj(skey);
					} else
					{
						Record rawrec = rec;
						Tree.InsertSubj(key,&rawrec);
					}
				}
			}
			while (Tcl_DoOneEvent(TCL_DONT_WAIT)) ;
		}
		for (is1 = 0; is1 < subjc;is1++)
		{
			Boolean addnew = true;
			for (is2 = 0; is2 < osubjc;is2++)
			{
				if (strncasecmp(subjv[is1],
						osubjv[is2],
						KeySize-1) == 0)
				{
					addnew = false;
					break;
				}
			}
			if (addnew)
			{
				CoreItem temp;
				Key skey;
				strncpy(skey,subjv[is1],KeySize-1);
				skey[KeySize-1] = '\0';
				if (Tree.SearchSubj(skey,&temp) &&
				    strlen(skey) == strlen(temp.key))
				{
					ListRecord rec(&temp.data);
					int nitems = rec.ElementCount();
					int outitems = rec.AddElement(key);
					Record rawrec = rec;
					if (outitems != nitems) Tree.InsertSubj(skey,&rawrec);
				} else
				{
					ListRecord rec(key);
					Record rawrec = rec;
					Tree.InsertSubj(skey,&rawrec);
				}
			}
			while (Tcl_DoOneEvent(TCL_DONT_WAIT)) ;
		}
		Tcl_Free((char*)subjv);
		Tcl_Free((char*)osubjv);
		if (WasError)
		{
			FormatError(interp);
			return TCL_ERROR;
		}
		return TCL_OK;
	//@Man: updateauthor
	//@Args: newauthor oldauthor idkey
	/*@Doc: The option ``updateauthor'' updates the author listing for 
	  the specified ``idkey''.  ``Newauthor'' is the new author and 
	  ``oldauthor'' is the old author.
	 */
	} else if (strcmp(argv[1], "updateauthor") == 0)
	{
		Key key, authkey, oauthkey;
		if (_mode != HLEnums::ReadWrite)
		{
			Tcl_AppendResult(interp, "ReadOnly file!",(char *) NULL);
			return TCL_ERROR;
		}
		if (argc != 5)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],
					 " newauthor oldauthor idkey\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		strncpy(authkey,argv[2],KeySize-1);
		authkey[KeySize-1] = '\0';
		strncpy(oauthkey,argv[3],KeySize-1);
		oauthkey[KeySize-1] = '\0';
		strncpy(key,argv[4],KeySize-1);
		key[KeySize-1] = '\0';
		//cerr << "*** In TkvBTree::TclFunction():" << endl;
		//cerr << "*** -: oauthkey = '" << oauthkey << "', authkey = '"
		//     << authkey << "', key = '" << key << "'" << endl;
		if (strcasecmp(authkey,oauthkey) != 0)
		{
			//int ii;
			CoreItem temp;
			if (oauthkey[0] != '\0' &&
			    Tree.SearchAuthor(oauthkey,&temp) &&
			    strlen(oauthkey) == strlen(temp.key))
			{
				ListRecord rec(&temp.data);
				//cerr << "*** -: Found old author, list is {";
				//for (ii = 0; ii < rec.ElementCount(); ii++)
				//{
				//	cerr << rec[ii] << " ";
				//}
				//cerr << "}" << endl;
				int outitems = rec.RemoveElement(key);
				if (outitems == 0)
				{
					Tree.DeleteAuthor(oauthkey);
				} else
				{
					Record rawrec = rec;
					Tree.InsertAuthor(oauthkey,&rawrec);
				}
			}
			if (authkey[0] != '\0' &&
			    Tree.SearchAuthor(authkey,&temp) &&
			    strlen(authkey) == strlen(temp.key))
			{
				ListRecord rec(&temp.data);
				//cerr << "*** -: Found new author, list is {";
				//for (ii = 0; ii < rec.ElementCount(); ii++)
				//{
				//	cerr << rec[ii] << " ";
				//}
				//cerr << "}" << endl;
				int nitems = rec.ElementCount();
				int outitems = rec.AddElement(key);
				//cerr << "*** -: nitems = " << nitems << ", outitems = " << outitems << endl;
				Record rawrec = rec;
				if (outitems != nitems) Tree.InsertAuthor(authkey,&rawrec);
			} else if (authkey[0] != 0)
			{
				ListRecord rec(key);
				Record rawrec = rec;
				Tree.InsertAuthor(authkey,&rawrec);
			}
		}
		if (WasError)
		{
			FormatError(interp);
			return TCL_ERROR;
		}
		return TCL_OK;
	//@Man: updatetitle
	//@Args: newtitle oldtitle idkey
	/*@Doc: The option ``updatetitle'' updates the title listing for 
	  the specified ``idkey''.  ``Newtitle'' is the new title and 
	  ``oldtitle'' is the old title.
	 */
	} else if (strcmp(argv[1], "updatetitle") == 0)
	{
		Key key, titlekey, otitlekey;
		if (_mode != HLEnums::ReadWrite)
		{
			Tcl_AppendResult(interp, "ReadOnly file!",(char *) NULL);
			return TCL_ERROR;
		}
		if (argc != 5)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],
					 " newtitle oldtitle idkey\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		strncpy(titlekey,argv[2],KeySize-1);
		titlekey[KeySize-1] = '\0';
		strncpy(otitlekey,argv[3],KeySize-1);
		otitlekey[KeySize-1] = '\0';
		strncpy(key,argv[4],KeySize-1);
		key[KeySize-1] = '\0';
		if (strcasecmp(titlekey,otitlekey) != 0)
		{
			CoreItem temp;
			if (otitlekey[0] != '\0' &&
			    Tree.SearchTitle(otitlekey,&temp) &&
			    strlen(otitlekey) == strlen(temp.key))
			{
				ListRecord rec(&temp.data);
				int outitems = rec.RemoveElement(key);
				if (outitems == 0)
				{
					Tree.DeleteTitle(otitlekey);
				} else
				{
					Record rawrec = rec;
					Tree.InsertTitle(otitlekey,&rawrec);
				}
			}
			if (titlekey[0] != 0 &&
			    Tree.SearchTitle(titlekey,&temp) &&
			    strlen(titlekey) == strlen(temp.key))
			{
				ListRecord rec(&temp.data);
				int nitems = rec.ElementCount();
				int outitems = rec.AddElement(key);
				Record rawrec = rec;
				if (outitems != nitems) Tree.InsertTitle(titlekey,&rawrec);
			} else if (titlekey[0] != 0)
			{
				ListRecord rec(key);
				Record rawrec = rec;
				Tree.InsertTitle(titlekey,&rawrec);
			}
		}
		if (WasError)
		{
			FormatError(interp);
			return TCL_ERROR;
		}
		return TCL_OK;
	//@Man: insertid
	//@Args: idkey cardhandle
	/*@Doc: The option ``insertid'' inserts or replaces a card in the file
	  under the key ``idkey''.  ``Cardhandle'' is a CardRecord handle to
	  the card to be inserted.  (See Chapter \ref{TkCardRecord}.)
	 */
	} else if (strcmp(argv[1], "insertid") == 0)
	{
		Key key;
		const TkCardRecord *rec;
		if (_mode != HLEnums::ReadWrite)
		{
			Tcl_AppendResult(interp, "ReadOnly file!",(char *) NULL);
			return TCL_ERROR;
		}
		if (argc != 4)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],
					 " idkey cardhandle\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		strncpy(key,argv[2],KeySize-1);
		key[KeySize-1] = '\0';
		if (argv[3][0] == '\0')
		{
			Tcl_AppendResult(interp, "bad (empty) cardhandle", (char *) NULL);
			return TCL_ERROR;
		}
		rec = TkCardRecord::FindCardByHandle(argv[3]);
		if (rec == NULL) return TCL_ERROR;
		Record rawrec = *(rec->theCardRecord());
		Tree.InsertId(key,&rawrec);
		if (WasError)
		{
			FormatError(interp);
			return TCL_ERROR;
		}
		return TCL_OK;
	//@Man: deleteid
	//@Args: idkey
	/*@Doc: The option ``deleteid'' deletes the specified ``idkey''
	  from the file.
	 */
	} else if (strcmp(argv[1], "deleteid") == 0)
	{
		Key key;
		if (_mode != HLEnums::ReadWrite)
		{
			Tcl_AppendResult(interp, "ReadOnly file!",(char *) NULL);
			return TCL_ERROR;
		}
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],
					 " idkey\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		strncpy(key,argv[2],KeySize-1);
		key[KeySize-1] = '\0';
		CoreItem temp;
		if (Tree.SearchId(key,&temp) &&
		    strlen(key) == strlen(temp.key))
		{
			Tree.DeleteId(key);
			return TCL_OK;
		} else if (WasError)
		{
			FormatError(interp);
			return TCL_ERROR;
		} else
		{
			Tcl_AppendResult(interp, "No such key: ",argv[2],(char *) NULL);
			return TCL_ERROR;
		}
	//@Man: inserttitle
	//@Args: titlekey idlist 
	/*@Doc: The option ``inserttitle'' inserts or replaces a list of card ids
	  in the file under the key ``titlekey''.  ``idlist'' is a list of card
	  ids.
	 */
	} else if (strcmp(argv[1], "inserttitle") == 0)
	{
		Key key;
		int idc;
		char **idv;
		if (_mode != HLEnums::ReadWrite)
		{
			Tcl_AppendResult(interp, "ReadOnly file!",(char *) NULL);
			return TCL_ERROR;
		}
		if (argc != 4)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],
					 " titlekey idlist\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		strncpy(key,argv[2],KeySize-1);
		key[KeySize-1] = '\0';
		if (Tcl_SplitList(interp, argv[3], &idc, &idv) != TCL_OK)
		{
			return TCL_ERROR;
		}
		ListRecord *rec = new ListRecord(idc,idv);
		Tcl_Free((char*)idv);
		if (rec == NULL) return TCL_ERROR;
		Record rawrec = *rec;
		Tree.InsertTitle(key,&rawrec);
		delete rec;
		if (WasError)
		{
			FormatError(interp);
			return TCL_ERROR;
		}
		return TCL_OK;
	//@Man: deletetitle
	//@Args: titlekey
	/*@Doc: The option ``deletetitle'' deletes the specified ``titlekey''
	  from the file.
	 */
	} else if (strcmp(argv[1], "deletetitle") == 0)
	{
		Key key;
		if (_mode != HLEnums::ReadWrite)
		{
			Tcl_AppendResult(interp, "ReadOnly file!",(char *) NULL);
			return TCL_ERROR;
		}
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],
					 " titlekey\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		strncpy(key,argv[2],KeySize-1);
		key[KeySize-1] = '\0';
		CoreItem temp;
		if (Tree.SearchTitle(key,&temp) &&
		    strlen(key) == strlen(temp.key))
		{
			Tree.DeleteTitle(key);
			return TCL_OK;
		} else if (WasError)
		{
			FormatError(interp);
			return TCL_ERROR;
		} else
		{
			Tcl_AppendResult(interp, "No such key: ",argv[2],(char *) NULL);
			return TCL_ERROR;
		}
	//@Man: insertauthor
	//@Args: authorkey idlist 
	/*@Doc: The option ``insertauthor'' inserts or replaces a list of card ids
	  in the file under the key ``authorkey''.  ``idlist'' is a list of card
	  ids.
	 */
	} else if (strcmp(argv[1], "insertauthor") == 0)
	{
		Key key;
		int idc;
		char **idv;
		if (_mode != HLEnums::ReadWrite)
		{
			Tcl_AppendResult(interp, "ReadOnly file!",(char *) NULL);
			return TCL_ERROR;
		}
		if (argc != 4)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],
					 " authorkey idlist\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		strncpy(key,argv[2],KeySize-1);
		key[KeySize-1] = '\0';
		if (Tcl_SplitList(interp, argv[3], &idc, &idv) != TCL_OK)
		{
			return TCL_ERROR;
		}
		ListRecord *rec = new ListRecord(idc,idv);
		Tcl_Free((char*)idv);
		if (rec == NULL) return TCL_ERROR;
		Record rawrec = *rec;
		Tree.InsertAuthor(key,&rawrec);
		delete rec;
		if (WasError)
		{
			FormatError(interp);
			return TCL_ERROR;
		}
		return TCL_OK;
	//@Man: deleteauthor
	//@Args: authorkey
	/*@Doc: The option ``deleteauthor'' deletes the specified ``authorkey''
	  from the file.
	 */
	} else if (strcmp(argv[1], "deleteauthor") == 0)
	{
		Key key;
		if (_mode != HLEnums::ReadWrite)
		{
			Tcl_AppendResult(interp, "ReadOnly file!",(char *) NULL);
			return TCL_ERROR;
		}
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],
					 " authorkey\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		strncpy(key,argv[2],KeySize-1);
		key[KeySize-1] = '\0';
		CoreItem temp;
		if (Tree.SearchAuthor(key,&temp) &&
		    strlen(key) == strlen(temp.key))
		{
			Tree.DeleteAuthor(key);
			return TCL_OK;
		} else if (WasError)
		{
			FormatError(interp);
			return TCL_ERROR;
		} else
		{
			Tcl_AppendResult(interp, "No such key: ",argv[2],(char *) NULL);
			return TCL_ERROR;
		}
	//@Man: insertsubject
	//@Args: sublectkey idlist 
	/*@Doc: The option ``insertsubject'' inserts or replaces a list of card ids
	  in the file under the key ``subjectkey''.  ``idlist'' is a list of card
	  ids.
	 */
	} else if (strcmp(argv[1], "insertsubject") == 0)
	{
		Key key;
		int idc;
		char **idv;
		if (_mode != HLEnums::ReadWrite)
		{
			Tcl_AppendResult(interp, "ReadOnly file!",(char *) NULL);
			return TCL_ERROR;
		}
		if (argc != 4)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],
					 " subjectkey idlist\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		strncpy(key,argv[2],KeySize-1);
		key[KeySize-1] = '\0';
		if (Tcl_SplitList(interp, argv[3], &idc, &idv) != TCL_OK)
		{
			return TCL_ERROR;
		}
		ListRecord *rec = new ListRecord(idc,idv);
		Tcl_Free((char*)idv);
		if (rec == NULL) return TCL_ERROR;
		Record rawrec = *rec;
		Tree.InsertSubj(key,&rawrec);
		delete rec;
		if (WasError)
		{
			FormatError(interp);
			return TCL_ERROR;
		}
		return TCL_OK;
	//@Man: deletesubject
	//@Args: subjectkey
	/*@Doc: The option ``deletesubject'' deletes the specified ``subjectkey''
	  from the file.
	 */
	} else if (strcmp(argv[1], "deletesubject") == 0)
	{
		Key key;
		if (_mode != HLEnums::ReadWrite)
		{
			Tcl_AppendResult(interp, "ReadOnly file!",(char *) NULL);
			return TCL_ERROR;
		}
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],
					 " subjectkey\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		strncpy(key,argv[2],KeySize-1);
		key[KeySize-1] = '\0';
		CoreItem temp;
		if (Tree.SearchSubj(key,&temp) &&
		    strlen(key) == strlen(temp.key))
		{
			Tree.DeleteSubj(key);
			return TCL_OK;
		} else if (WasError)
		{
			FormatError(interp);
			return TCL_ERROR;
		} else
		{
			Tcl_AppendResult(interp, "No such key: ",argv[2],(char *) NULL);
			return TCL_ERROR;
		}
	//@Man: traverseid
	//@Args: script
	/*@Doc: The option ``traverseid'' traverses the Id tree.  At each
	  non-empty node, the supplied script is invoked.  Percent (#%#)
	  substitution is performed as follows:
	  \begin{description}
	  \item[i] Replaced by a handle to the card record.
	  \item[k] Replaced by the id.
	  \item[{\tt %}] Replaced by a #%#.
	  \end{description}
	 */
	} else if (strcmp(argv[1], "traverseid") == 0)
	{
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," script\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		interpAndScript IS;
		IS.travinterp = interp;
		IS.script = argv[2];
		int status = Tree.TraverseId(TclTraverseIds,(vBTree::UserData)&IS);
		if (status != 0) return status;
		if (WasError)
		{
			FormatError(interp);
			return TCL_ERROR;
		}
		return TCL_OK;
	//@Man: traverseauthor
	//@Args: script
	/*@Doc: The option ``traverseauthor'' traverses the Author tree.  At
	  each non-empty node, the supplied script is invoked.  Percent (#%#)
	  substitution is performed as follows:
	  \begin{description}
	  \item[i] Replaced by the list of ids in for the node.
	  \item[k] Replaced by the id.
	  \item[{\tt %}] Replaced by a #%#.
	  \end{description}
	 */
	} else if (strcmp(argv[1], "traverseauthor") == 0)
	{
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," script\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		interpAndScript IS;
		IS.travinterp = interp;
		IS.script = argv[2];
		int status = Tree.TraverseAuthor(TclTraverseLists,(vBTree::UserData)&IS);
		if (status != 0) return status;
		if (WasError)
		{
			FormatError(interp);
			return TCL_ERROR;
		}
		return TCL_OK;
	//@Man: traversetitle
	//@Args: script
	/*@Doc: The option ``traversetitle'' traverses the Title tree.  At
	  each non-empty node, the supplied script is invoked.  Percent (#%#)
	  substitution is performed as follows:
	  \begin{description}
	  \item[i] Replaced by the list of ids in for the node.
	  \item[k] Replaced by the id.
	  \item[{\tt %}] Replaced by a #%#.
	  \end{description}
	 */
	} else if (strcmp(argv[1], "traversetitle") == 0)
	{
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," script\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		interpAndScript IS;
		IS.travinterp = interp;
		IS.script = argv[2];
		int status = Tree.TraverseTitle(TclTraverseLists,(vBTree::UserData)&IS);
		if (status != 0) return status;
		if (WasError)
		{
			FormatError(interp);
			return TCL_ERROR;
		}
		return TCL_OK;
	//@Man: traversesubj
	//@Args: script
	/*@Doc: The option ``traversesubj'' traverses the Subject tree.  At
	  each non-empty node, the supplied script is invoked.  Percent (#%#)
	  substitution is performed as follows:
	  \begin{description}
	  \item[i] Replaced by the list of ids in for the node.
	  \item[k] Replaced by the id.
	  \item[{\tt %}] Replaced by a #%#.
	  \end{description}
	 */
	} else if (strcmp(argv[1], "traversesubj") == 0)
	{
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," script\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		interpAndScript IS;
		IS.travinterp = interp;
		IS.script = argv[2];
		int status = Tree.TraverseSubj(TclTraverseLists,(vBTree::UserData)&IS);
		if (status != 0) return status;
		if (WasError)
		{
			FormatError(interp);
			return TCL_ERROR;
		}
		return TCL_OK;
	//@Man: cardtypename
	//@Args: cardtype
	/*@Doc: This option returns the name of a card type, given a CardType
	  character.  The argument should be a sting starting with one of
	  the characters ``B M D C 8 A L V S E 4 O a b c d e f g h i j''.
	 */
	} else if (strcmp(argv[1], "cardtypename") == 0)
	{
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," cardtype\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		if (!Card::IsCardType(argv[2][0]))
		{
			Tcl_AppendResult(interp, "Bad card type: ",
					 argv[2]," should be one of {",
					 "B M D C 8 A L V S E 4 O a b c d e f",
					 " g h i j}",(char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp,
				 Tree.CardTypeName((Card::CardType)argv[2][0]),
				 (char *) NULL);
		return TCL_OK;
	//@Man:  cardtypenamep
	//@Args: cardtypename
	/*@Doc: This option is a predicate that tests its argument against the
	  the list of card type names. If the argument is matched, 1 is returned,
	  otherwise 0 is returned.
	 */
	} else if (strcmp(argv[1], "cardtypenamep") == 0)
	{
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," cardtypename\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		if (Tree.CardTypeNameP(argv[2]))
			Tcl_AppendResult(interp, "1", (char *) NULL);
		else	Tcl_AppendResult(interp, "0", (char *) NULL);
		return TCL_OK;
	//@Man: cardtypefromname
	//@Args: cardtypename
	/*@Doc: This option returns the Card Type character that matches
	  the named card type.  The CardType ``Other'' is returned (#O#) if
	  the name does not match any known type names.
	 */
	} else if (strcmp(argv[1], "cardtypefromname") == 0)
	{
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," cardtypename\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		tempstring[0] = (char) Tree.CardTypeFromName(argv[2]);
		tempstring[1] = '\0';
		Tcl_AppendResult(interp,tempstring,(char *) NULL);
		return TCL_OK;
	//@Man: addcardtypename
	//@Args: cardtype cardtypename
	/*@Doc: This option adds (or replaces) a card type name for a
	  specified CardType character.
	 */
	} else if (strcmp(argv[1], "addcardtypename") == 0)
	{
		if (argc != 4)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					argv[0]," ",argv[1]," cardtype cardtypename\"",
					(char *) NULL);
			return TCL_ERROR;
		}
		if (!Card::IsCardType(argv[2][0]))
		{
			Tcl_AppendResult(interp, "Bad card type: ",
					 argv[2]," should be one of {",
					 "B M D C 8 A L V S E 4 O a b c d e f",
					 " g h i j}",(char *) NULL);
			return TCL_ERROR;
		}
		Tree.AddCardTypeName((Card::CardType)argv[2][0],argv[3]);
		if (WasError)
		{
			FormatError(interp);
			return TCL_ERROR;
		}
		return TCL_OK;
	//@Man: locationtypename
	//@Args: locationtype
	/*@Doc: This option returns the name of a location type, given a
	  LocationType character.  The argument should be a sting starting 
	  with one of the characters ``S L O D s U a b c d e f g h i j''.
	 */
	} else if (strcmp(argv[1], "locationtypename") == 0)
	{
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," locationtype\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		if (!Card::IsLocationType(argv[2][0]))
		{
			Tcl_AppendResult(interp, "Bad location type: ",
					 argv[2]," should be one of {",
					 "S L O D s U a b c d e f g h",
					 " i j}",(char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp,
				 Tree.LocationTypeName((Card::LocationType)argv[2][0]),
				 (char *) NULL);
		return TCL_OK;
	//@Man:  locationtypenamep
	//@Args: locationtypename
	/*@Doc: This option is a predicate that tests its argument against the
	  the list of location type names. If the argument is matched, 1 is returned,
	  otherwise 0 is returned.
	 */
	} else if (strcmp(argv[1], "locationtypenamep") == 0)
	{
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," locationtypename\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		if (Tree.LocationTypeNameP(argv[2]))
			Tcl_AppendResult(interp, "1", (char *) NULL);
		else	Tcl_AppendResult(interp, "0", (char *) NULL);
		return TCL_OK;
	//@Man: locationtypefromname
	//@Args: locationtypename
	/*@Doc: This option returns the Location Type character that matches
	  the named card type.  The LocationType ``Unknown'' is returned (#U#)
	  if the name does not match any known type names.
	 */
	} else if (strcmp(argv[1], "locationtypefromname") == 0)
	{
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," locationtypename\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		tempstring[0] = (char) Tree.LocationTypeFromName(argv[2]);
		tempstring[1] = '\0';
		Tcl_AppendResult(interp,tempstring,(char *) NULL);
		return TCL_OK;
	//@Man: addlocationtypename
	//@Args: locationtype locationtypename
	/*@Doc: This option adds (or replaces) a location type name for a
	  specified LocationType character.
	 */
	} else if (strcmp(argv[1], "addlocationtypename") == 0)
	{
		if (argc != 4)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					argv[0]," ",argv[1]," locationtype locationtypename\"",
					(char *) NULL);
			return TCL_ERROR;
		}
		if (!Card::IsLocationType(argv[2][0]))
		{
			Tcl_AppendResult(interp, "Bad location type: ",
					 argv[2]," should be one of {",
					 "S L O D s U a b c d e f g h",
					 " i j}",(char *) NULL);
			return TCL_ERROR;
		}
		Tree.AddLocationTypeName((Card::LocationType)argv[2][0],argv[3]);
		if (WasError)
		{
			FormatError(interp);
			return TCL_ERROR;
		}
		return TCL_OK;
	//@Man: category
	//@Args: catcode
	/*@Doc: This option returns a Category given its code.  The category
	  code is an integer from 0 to 255, inclusive.
	 */
	} else if (strcmp(argv[1], "category") == 0)
	{
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," catcode\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		int cc;
		if (Tcl_GetInt(interp, argv[2], &cc) != TCL_OK) return TCL_ERROR;
		if (cc < 0 || cc > 255)
		{
			Tcl_AppendResult(interp, "Category code, ",
					 argv[2],
					 " out of range: should be from 0 to 255, inclusive",
					 (char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp,
				 Tree.Category((unsigned char)cc),
				 (char *) NULL);
		return TCL_OK;
	//@Man:  catcodenamep
	//@Args: catcodename
	/*@Doc: This option is a predicate that tests its argument against the
	  the list of Categories. If the argument is matched, 1 is returned,
	  otherwise 0 is returned.
	 */
	} else if (strcmp(argv[1], "catcodenamep") == 0)
	{
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," category\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		if (Tree.CatCodeNameP(argv[2]))
			Tcl_AppendResult(interp, "1", (char *) NULL);
		else	Tcl_AppendResult(interp, "0", (char *) NULL);
		return TCL_OK;
	//@Man: catcodefromname
	//@Args: category
	/*@Doc: This option returns the catcode that matches
	  the Category.  The value 0 is returned if
	  the name does not match any known type names.
	 */
	} else if (strcmp(argv[1], "catcodefromname") == 0)
	{
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," category\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		sprintf(tempstring,"%d",Tree.CatCodeFromName(argv[2]));
		Tcl_AppendResult(interp,tempstring,(char *) NULL);
		return TCL_OK;
	//@Man: addcategory
	//@Args: catcode category
	/*@Doc: This option adds (or replaces) a category for a
	  specified catcode.
	 */
	} else if (strcmp(argv[1], "addcategory") == 0)
	{
		if (argc != 4)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					argv[0]," ",argv[1]," catcode category\"",
					(char *) NULL);
			return TCL_ERROR;
		}
		int cc;
		if (Tcl_GetInt(interp, argv[2], &cc) != TCL_OK) return TCL_ERROR;
		if (cc < 0 || cc > 255)
		{
			Tcl_AppendResult(interp, "Category code, ",
					 argv[2],
					 " out of range: should be from 0 to 255, inclusive",
					 (char *) NULL);
			return TCL_ERROR;
		}
		Tree.AddCategory((unsigned char)cc,argv[3]);
		if (WasError)
		{
			FormatError(interp);
			return TCL_ERROR;
		}
		return TCL_OK;
	//@Man: countpages
	//@Doc: This option counts and returns the number of pages in the file.
	} else if (strcmp(argv[1], "countpages") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		int numpages = Tree.CountPages();
		sprintf(tempstring,"%d",numpages);
		Tcl_AppendResult(interp, tempstring, (char *) NULL);
		return TCL_OK;
	//@Man: countids
	//@Doc: This option counts and returns the number of ids in the file.
	} else if (strcmp(argv[1], "countids") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		int numids = 0;
		Tree.TraverseId(CountItems,(vBTree::UserData)&numids);
		sprintf(tempstring,"%d",numids);
		Tcl_AppendResult(interp, tempstring, (char *) NULL);
		return TCL_OK;
	//@Man: counttitles
	//@Doc: This option counts and returns the number of titles in the file.
	} else if (strcmp(argv[1], "counttitles") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		int numtitles = 0;
		Tree.TraverseTitle(CountItems,(vBTree::UserData)&numtitles);
		sprintf(tempstring,"%d",numtitles);
		Tcl_AppendResult(interp, tempstring, (char *) NULL);
		return TCL_OK;
	//@Man: countauthors
	//@Doc: This option counts and returns the number of authors in the file.
	} else if (strcmp(argv[1], "countauthors") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		int numauthors = 0;
		Tree.TraverseAuthor(CountItems,(vBTree::UserData)&numauthors);
		sprintf(tempstring,"%d",numauthors);
		Tcl_AppendResult(interp, tempstring, (char *) NULL);
		return TCL_OK;
	//@Man: countsubjs
	//@Doc: This option counts and returns the number of subjects in the file.
	} else if (strcmp(argv[1], "countsubjs") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		int numsubjs = 0;
		Tree.TraverseSubj(CountItems,(vBTree::UserData)&numsubjs);
		sprintf(tempstring,"%d",numsubjs);
		Tcl_AppendResult(interp, tempstring, (char *) NULL);
		return TCL_OK;
	//@Man: writable
	//@Doc: Returns 1 if the file is writable.
	} else if (strcmp(argv[1], "writable") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		if (Tree.Writable())
			Tcl_AppendResult(interp, "1", (char *) NULL);
		else	Tcl_AppendResult(interp, "0", (char *) NULL);
		return TCL_OK;
	//@Man: libraryversion
	/*@Doc: Returns 1 if this is an old library file or 2 if this is a
	  new library file.
	 */
	} else if (strcmp(argv[1], "libraryversion") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		sprintf(tempstring,"%d",Tree.LibraryVersion());
		Tcl_AppendResult(interp, tempstring, (char *) NULL);
		return TCL_OK;
	//@Man: exportv1ascii
	//@Args: outfilename
	/*@Doc: With the option ``exportv1ascii'', the vBTree is exported as
	  a V1 ASCII file (as in the old Libr2Ascii program).  The one argument,
	  ``outfilename'' is the name of the output text file.
	 */
	} else if (strcmp(argv[1], "exportv1ascii") == 0)
	{
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," outfilename\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		return tkvBTreeExportV1ASCII(interp,argv[2]);
	//@Man: exportv2ascii
	//@Args: outfilename
	/*@Doc: With the option ``exportv2ascii'', the vBTree is exported as
	  a V2 ASCII file.  The one argument, ``outfilename'' is the name of 
	  the output text file.
	 */
	} else if (strcmp(argv[1], "exportv2ascii") == 0)
	{
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," outfilename\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		return tkvBTreeExportV2ASCII(interp,argv[2]);
	//@Man: exportdelimited
	//@Args: outfilename delimiter quoteorescchar quoteorescflag
	/*@Doc: With the option ``exportdelimited'', the vBTree is exported as
	  a delimited file.  The first argument, ``outfilename'' is the name of 
	  the output text file.  The second argument, ``delimiter'' is the 
	  delimiter character, the third argument, ``quoteorescchar'' is the
	  quote or escape character, and the fourth argument, ``quoteorescflag''
	  is a boolean specifing whether to quote or escape strings.
	 */
	} else if (strcmp(argv[1], "exportdelimited") == 0)
	{
		if (argc != 6)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," outfilename",
					 " delimiter quoteorescchar",
					 " quoteorescflag\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		int bval;
		if (Tcl_GetBoolean(interp,argv[5],&bval) != TCL_OK) return TCL_ERROR;
		return tkvBTreeExportDelimited(interp,argv[2],argv[3][0],
						argv[4][0],bval == 1);
	//@Man: exportformatted
	//@Args: outfilename
	/*@Doc: With the option ``exportformatter'', the vBTree is exported as
	  a human-readable formatted file.  The first argument, ``outfilename''
	  is the name of the output text file.
	 */
	} else if (strcmp(argv[1], "exportformatted") == 0)
	{
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," outfilename\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		return tkvBTreeExportFormatted(interp,argv[2]);
	//@Man: delete
	/*@Doc: With the option ``delete'', the vBTree instance is deleted
	  and the file closed.  The handle command is deleted from Tcl.
	  \index{vBTree!Tcl Interface!Handle options|)}
	  \index{vBTree!Tcl Interface|)}
	 */
	} else if (strcmp(argv[1], "delete") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		return Tcl_DeleteCommand(interp,argv[0]);
	} else
	{
		Tcl_AppendResult(interp, "Bad option: ",argv[1],(char *) NULL);
		return TCL_ERROR;
	}

}

TkvBTree::TkvBTree(const char *filename,HLEnums::OpenMode mode,int nfree)
{
	myEntry = NULL;
	WasError = false;
	FileName theName;
	Tree.SetErrorFun(TclErrorHandler,(vBTree::UserData)this);

	fileName = new char[strlen(filename)+1];
	strcpy(fileName,filename);
#ifdef macintosh
	theName = (FileName) FSpFromPath(filename);
	if (theName == NULL)
	{
		WasError = true;
		ErrorKind = HLEnums::sysErr;
		sprintf(ErrorBuffer,"Illegal file spec: %s",filename);
	}
#else
	theName = filename;
#endif
	Tree.open(theName,mode,nfree);
	_mode = (HLEnums::OpenMode) (mode & HLEnums::ModeMask);
}

TkvBTree::~TkvBTree()
{
	delete fileName;
	DeleteMyHandle();
}

int TkvBTree::Init_TkvBTree(Tcl_Interp *interp)
{
	Tcl_CreateCommand(interp, "vBTree",
				(Tcl_CmdProc*)TkvBTree::tkvBTreeCreate,
				(ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	Tcl_CreateCommand(interp, "ImportV1ASCIIvBTree",
				(Tcl_CmdProc*)TkvBTree::tkvBTreeImportV1ASCII,
				(ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	Tcl_CreateCommand(interp, "ImportV2ASCIIvBTree",
				(Tcl_CmdProc*)TkvBTree::tkvBTreeImportV2ASCII,
				(ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	Tcl_CreateCommand(interp, "ImportDelimitedvBTree",
				(Tcl_CmdProc*)TkvBTree::tkvBTreeImportDelimited,
				(ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	return TCL_OK;
}

//@}
