/* 
 * ------------------------------------------------------------------
 * Home Libarian 1.1 by Deepwoods Software
 * ------------------------------------------------------------------
 * TkHlPackage.cc - Tcl Home Librarian Package interface
 * Created by Robert Heller on Tue Jul  1 13:45:34 1997
 * ------------------------------------------------------------------
 * Modification History: 
 * $Log: TkHlPackage.cc,v $
 * Revision 2.0  1997/07/06 21:46:53  heller
 * *** empty log message ***
 *
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Home Librarian Database -- a program for maintaining a database
 *                                for a home library
 *     Copyright (C) 1991-1997  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

static char ID[] = "$Id: TkHlPackage.cc,v 2.0 1997/07/06 21:46:53 heller Rel $";

#include <TkCppWraper.h>
#include <TkCardRecord.h>
#include <TkvBTree.h>
#include <stdio.h>

extern "C" int Hllibr_Init(Tcl_Interp *interp)
{
	int code;
	code = Tcl_PkgProvide(interp, "hllibr", "2.0");
	if (code != TCL_OK)
	{
		return code;
	}
	code = TkCppWraper::InitHashTable(interp);
	if (code != TCL_OK)
	{
		return code;
	}
	code = TkCardRecord::Init_TkCardRecord(interp);
	if (code != TCL_OK)
	{
		return code;
	}
	code = TkvBTree::Init_TkvBTree(interp);
	if (code != TCL_OK)
	{
		return code;
	}
	return TCL_OK;
}	
