/* 
 * ------------------------------------------------------------------
 * Home Libarian 1.1 by Deepwoods Software
 * ------------------------------------------------------------------
 * TkCppWraper.h - Generic C++ wrapper Class (virtual base class)
 * Created by Robert Heller on Mon Jun 30 21:54:59 1997
 * ------------------------------------------------------------------
 * Modification History:
 * $Log: TkCppWraper.h,v $
 * Revision 2.0  1997/07/06 21:47:28  heller
 * *** empty log message ***
 *
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Home Librarian Database -- a program for maintaining a database
 *                                for a home library
 *     Copyright (C) 1991-1997  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

#ifndef _TKCPPWRAPER_H_
#define _TKCPPWRAPER_H_

#include <tcl.h>

class TkCppWraper {
protected:
	static Tcl_HashTable HandleHashTable;
	virtual const char *HandleKey() const = 0;
	virtual int TclFunction(Tcl_Interp *interp,int argc, char *argv[]) = 0;
	void newHandle();
	char myHandle[32];
	Tcl_HashEntry * myEntry;
	void DeleteMyHandle();
public:
	TkCppWraper();
	virtual ~TkCppWraper();
	virtual const char* MyType() const = 0;
	static int InitHashTable(Tcl_Interp *inter);
	static int TclCommand(ClientData clientData,Tcl_Interp *interp,
				int argc, char *argv[]);
	static void deleteTkCppWraper(ClientData clientData);
};
	

#endif // _TKCPPWRAPER_H_

