/* 
 * ------------------------------------------------------------------
 * Home Libarian 1.1 by Deepwoods Software
 * ------------------------------------------------------------------
 * TkCppWraper.cc - Generic C++ wrapper Class (virtual base class)
 * Created by Robert Heller on Mon Jun 30 21:56:00 1997
 * ------------------------------------------------------------------
 * Modification History: 
 * $Log: TkCppWraper.cc,v $
 * Revision 2.0  1997/07/06 21:46:53  heller
 * *** empty log message ***
 *
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Home Librarian Database -- a program for maintaining a database
 *                                for a home library
 *     Copyright (C) 1991-1997  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

static char ID[] = "$Id: TkCppWraper.cc,v 2.0 1997/07/06 21:46:53 heller Rel $";

#include <TkCppWraper.h>

Tcl_HashTable TkCppWraper::HandleHashTable;

void TkCppWraper::newHandle()
{
	const char *hkey = this->HandleKey();
	int ih;
	for (ih = 1;;ih++)
	{
		sprintf(myHandle,"%s%d",hkey,ih);
		myEntry = Tcl_FindHashEntry(&HandleHashTable,myHandle);
		if (myEntry == NULL) break;
	}
	int np;
	myEntry = Tcl_CreateHashEntry(&HandleHashTable,myHandle,&np);
	Tcl_SetHashValue(myEntry,this);
}

TkCppWraper::TkCppWraper()
{
	myEntry = NULL;
}

TkCppWraper::~TkCppWraper()
{
	DeleteMyHandle();
}

void TkCppWraper::DeleteMyHandle()
{
	if (myEntry != NULL) Tcl_DeleteHashEntry(myEntry);
	myEntry = NULL;
}

int TkCppWraper::InitHashTable(Tcl_Interp */* interp */)
{
	Tcl_InitHashTable(&HandleHashTable,TCL_STRING_KEYS);
	return TCL_OK;
}

int TkCppWraper::TclCommand(ClientData clientData,Tcl_Interp *interp,int argc, char *argv[])
{
	register TkCppWraper* instance = (TkCppWraper*) clientData;
	return instance->TclFunction(interp,argc,argv);
}

void TkCppWraper::deleteTkCppWraper(ClientData clientData)
{
	register TkCppWraper* instance = (TkCppWraper*) clientData;
	delete instance;
}
