/* 
 * ------------------------------------------------------------------
 * Home Libarian 1.1 by Deepwoods Software
 * ------------------------------------------------------------------
 * TkCardRecord.h - Tcl interface for the CardRecord class
 * Created by Robert Heller on Mon Jun 30 22:48:08 1997
 * ------------------------------------------------------------------
 * Modification History: 
 * $Log: TkCardRecord.h,v $
 * Revision 2.1  1997/09/15 23:19:40  heller
 * Extract out CardRecord => Tcl list code.
 *
 * Revision 2.0  1997/07/06 21:47:28  heller
 * *** empty log message ***
 *
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Home Librarian Database -- a program for maintaining a database
 *                                for a home library
 *     Copyright (C) 1991-1997  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

#ifndef _TKCARDRECORD_H_
#define _TKCARDRECORD_H_

#include <TkCppWraper.h>
#include <CardRecord.h>
class TkvBTree;

class TkCardRecord : public TkCppWraper {
	virtual const char *HandleKey() const;
	virtual int TclFunction(Tcl_Interp *interp,int argc, char *argv[]);
	CardRecord *CardRec;
	void NoArgList(Tcl_DString *result);
	friend class TkvBTree;
public:
	const CardRecord * theCardRecord () const;
	virtual const char* MyType() const;
	TkCardRecord(const Record* record);
        TkCardRecord(const CoreItem* coreitem);
	TkCardRecord(const Card* card);
	TkCardRecord(const CardRecord& cardrecord);
	virtual ~TkCardRecord();
	static int createTkCardRecord(Tcl_Interp *interp,const Record* record);
	static int createTkCardRecord(Tcl_Interp *interp,const CoreItem* coreitem);
	static int createTkCardRecord(Tcl_Interp *interp,const Card* card);
	static int createTkCardRecord(Tcl_Interp *interp,const CardRecord& cardrecord);
	static TkCardRecord* FindCardByHandle(const char* handle);
	static int tkCardRecordCreate(ClientData ,Tcl_Interp *interp,int argc, char *argv[]);
	static int Init_TkCardRecord(Tcl_Interp *interp);
};

	
#endif // _TKCARDRECORD_H_

