/* 
 * ------------------------------------------------------------------
 * Home Libarian 1.1 by Deepwoods Software
 * ------------------------------------------------------------------
 * TkCardRecord.cc - Tcl interface for the CardRecord class
 * Created by Robert Heller on Mon Jun 30 23:07:47 1997
 * ------------------------------------------------------------------
 * Modification History: 
 * $Log: TkCardRecord.cc,v $
 * Revision 2.6  1998/05/16 23:43:28  heller
 * Add indexing to the documentation.
 *
 * Revision 2.5  1997/09/15 23:19:40  heller
 * Extract out CardRecord => Tcl list code.
 *
 * Revision 2.4  1997/07/20 21:13:11  heller
 * Fun with \ref
 *
 * Revision 2.3  1997/07/20 20:34:53  heller
 * Squigle fun...
 *
 * Revision 2.2  1997/07/20 19:50:20  heller
 * Spelling errors
 *
 * Revision 2.1  1997/07/15 23:25:17  heller
 * Add documentation.
 *
 * Revision 2.0  1997/07/06 21:46:53  heller
 * *** empty log message ***
 *
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Home Librarian Database -- a program for maintaining a database
 *                                for a home library
 *     Copyright (C) 1991-1997  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

//@ChapterName:Tcl/Tk Interface to CardRecords

//@Man: About this chapter
/*@Doc:
  \typeout{Generated from: $Id: TkCardRecord.cc,v 2.6 1998/05/16 23:43:28 heller Rel $}
  This chapter describes th Tcl/Tk interface to instances of class CardRecord.

 */

static char ID[] = "$Id: TkCardRecord.cc,v 2.6 1998/05/16 23:43:28 heller Rel $";

#include <TkCardRecord.h>
#include <stdio.h>

const char *TkCardRecord::HandleKey() const {return "CardRecord";}

//@Man: CardRecord
//@Args: ?type author title publisher city description vol year ltype ldetail catcode?
/*@Doc:
  \index{CardRecord!Tcl Interface|(}
  \index{CardRecord!Tcl Interface!Constructor|(}
  This Tcl command creates a CardRecord instance.  With no arguments, it
  creates one with a default set of field values. (See Chapter\space\ref{Card}.)
  Otherwise its argument list matches that of the constructor for a Card.

  It returns a string which is a ``handle'' to a CardRecord instance.  This
  handle is defined as a Tcl command that will access the CardRecord instance.
 */
//@{

int TkCardRecord::tkCardRecordCreate(ClientData ,Tcl_Interp *interp,int argc, char *argv[])
{
	Card *incard;

	if (argc != 1 && argc != 12)
	{
		Tcl_AppendResult(interp, "Wrong # args: should be \"",
				 argv[0]," ?type author title ",
				 "publisher city description vol year ",
				 "ltype ldetail catcode?\"",
				 (char*) NULL);
		return TCL_ERROR;
	}
	if (argc == 1) incard = new Card();
	else
	{
		Card::CardType type;
		int vol,year,tc;
		Card::LocationType ltype;
		unsigned char catcode;
  //@Man: type
  //@Type: CardType character code.
  /*@Doc: This argument is the CardType to initialize the CardRecord with.
    Legal values are: ``B M D C 8 E 4 O a b c d e f g h i j''.
    Only the first character is checked.
   */
		if (!Card::IsCardType(argv[1][0]))
		{
			Tcl_AppendResult(interp, "Bad card type: ",
					 argv[1]," should be one of {",
					 "B M D C 8 E 4 O a b c d e f",
					 " g h i j}",
					 (char *) NULL);
			return TCL_ERROR;
		}
		type = (Card::CardType)argv[1][0];
  //@Man: author
  //@Type: string
  //@Doc: This argument is the author to initialize the CardRecord with.
		// argv[2] : author
  //@Man: title
  //@Type: string
  //@Doc: This argument is the title to initialize the CardRecord with.
		// argv[3] : title
  //@Man: publisher
  //@Type: string
  //@Doc: This argument is the publisher to initialize the CardRecord with.
		// argv[4] : publisher
  //@Man: city
  //@Type: string
  //@Doc: This argument is the city to initialize the CardRecord with.
		// argv[5] : city
  //@Man: description
  //@Type: string
  //@Doc: This argument is the description to initialize the CardRecord with.
		// argv[6] : description
  //@Man: vol
  //@Type: integer
  //@Doc: This argument is the volume to initialize the CardRecord with.
		if (Tcl_GetInt(interp, argv[7], &vol) != TCL_OK) return TCL_ERROR;
  //@Man: year
  //@Type: integer
  //@Doc: This argument is the year to initialize the CardRecord with.
		if (Tcl_GetInt(interp, argv[8], &year) != TCL_OK) return TCL_ERROR;
  //@Man: ltype
  //@Type: LocationType character code.
  /*@Doc: This argument is the LocationType to initialize the CardRecord with.
    Legal values are: ``S L O D s U a b c d e f g h i j''.
    Only the first character is checked.
   */
		if (!Card::IsLocationType(argv[9][0]))
		{
			Tcl_AppendResult(interp, "Bad location type: ",
					 argv[2]," should be one of {",
					 "S L O D s U a b c d e f g h",
					 " i j}",(char *) NULL);
			return TCL_ERROR;
		}
		ltype = (Card::LocationType)argv[9][0];
  //@Man: ldetail
  //@Type: string
  //@Doc: This argument is the location detail to initialize the CardRecord with.
		// argv[10] : ldetail
  //@Man: catcode
  //@Type: integer (range 0-255)
  /*@Doc: This argument is the category code to initialize the CardRecord with
    It must be in the range of 0 to 255, inclusive.
    \index{CardRecord!Tcl Interface!Constructor|)}
   */
		if (Tcl_GetInt(interp, argv[11], &tc) != TCL_OK) return TCL_ERROR;
		if (tc < 0 || tc > 255)
		{
			Tcl_AppendResult(interp, "Category code, ",argv[11],
					 " out of range: should be from 0 to 255, inclusive",
				         (char *) NULL);
			return TCL_ERROR;
		}
		catcode = (unsigned char) tc;
		incard = new Card(type,argv[2],argv[3],argv[4],argv[5],argv[6],
				  vol,year,ltype,argv[10],catcode);
	}
	int status = createTkCardRecord(interp,incard);
	delete incard;
	return status;
}

//@}

void TkCardRecord::NoArgList(Tcl_DString *result)
{
	static char tempstring[256];
	const Card *c = &(*CardRec);

	Tcl_DStringAppendElement(result,"CardRecord");
	Tcl_DStringStartSublist(result);
	Tcl_DStringAppendElement(result,"cardtype");
	tempstring[0] = (char) c->type;
	tempstring[1] = '\0';
	Tcl_DStringAppendElement(result,tempstring);
	Tcl_DStringEndSublist(result);

	Tcl_DStringStartSublist(result);
	Tcl_DStringAppendElement(result,"author");
	Tcl_DStringAppendElement(result,c->author);
	Tcl_DStringEndSublist(result);

	Tcl_DStringStartSublist(result);
	Tcl_DStringAppendElement(result,"title");
	Tcl_DStringAppendElement(result,c->title);
	Tcl_DStringEndSublist(result);

	Tcl_DStringStartSublist(result);
	Tcl_DStringAppendElement(result,"publisher");
	Tcl_DStringAppendElement(result,c->publisher);
	Tcl_DStringEndSublist(result);

	Tcl_DStringStartSublist(result);
	Tcl_DStringAppendElement(result,"city");
	Tcl_DStringAppendElement(result,c->city);
	Tcl_DStringEndSublist(result);

	Tcl_DStringStartSublist(result);
	Tcl_DStringAppendElement(result,"description");
	Tcl_DStringAppendElement(result,c->description);
	Tcl_DStringEndSublist(result);

	Tcl_DStringStartSublist(result);
	Tcl_DStringAppendElement(result,"vol");
	sprintf(tempstring,"%d",c->vol);
	Tcl_DStringAppendElement(result,tempstring);
	Tcl_DStringEndSublist(result);
		
	Tcl_DStringStartSublist(result);
	Tcl_DStringAppendElement(result,"year");
	sprintf(tempstring,"%d",c->year);
	Tcl_DStringAppendElement(result,tempstring);
	Tcl_DStringEndSublist(result);

	Tcl_DStringStartSublist(result);
	Tcl_DStringAppendElement(result,"locationtype");
	tempstring[0] = (char) c->ltype;
	tempstring[1] = '\0';
	Tcl_DStringAppendElement(result,tempstring);
	Tcl_DStringEndSublist(result);

	Tcl_DStringStartSublist(result);
	Tcl_DStringAppendElement(result,"locationdetail");
	Tcl_DStringAppendElement(result,c->locdetail);
	Tcl_DStringEndSublist(result);

	Tcl_DStringStartSublist(result);
	Tcl_DStringAppendElement(result,"categorycode");
	sprintf(tempstring,"%d",c->catcode);
	Tcl_DStringAppendElement(result,tempstring);
	Tcl_DStringEndSublist(result);
}

//@Man: CardRecord ``Handle''
//@Args: ?option optionargs?
//@See: CardRecord
/*@Doc:
  \index{CardRecord!Tcl Interface!Handle options|(}
  The string returned by the CardRecord command is itself a Tcl command.
  This command provides access to the CardRecord instance.
 */
//@{
int TkCardRecord::TclFunction(Tcl_Interp *interp,int argc, char *argv[])
{
	static char tempstring[256];

	//@Man: \  
	/*@Doc: When called with no arguments, the CardRecord ``Handle'' returns
	  a Tcl list containing the current contents of the CardRecord 
	  instance.  The list contains:
	  \begin{description}
	 */
	
	if (argc == 1)
	{
		// no option, echo slots
		//@Doc: \item[\ ] The string ``CardRecord''.
		Tcl_DString result;

		/*@Doc: \item[\ ]  A list containing the string ``cardtype'' and
		  the CardType character code.*/
		/*@Doc:  \item[\ ] A list containing the string ``author'' and the author.
		 */
		/*@Doc:  \item[\ ] A list containing the string ``title'' and the title.*/
		/*@Doc:  \item[\ ] A list containing the string ``publisher'' and the
		  publisher. */
		/*@Doc: \item[\ ] A  list containing the string ``city'' and the city. */
		/*@Doc: \item[\ ]  A list containing the string ``description'' and the
		  description. */
		/*@Doc: \item[\ ]  A list containing the string ``vol'' and the volume
		  number.*/
		/*@Doc: \item[\ ]  A list containing the string ``year'' and the year.*/
		/*@Doc: \item[\ ]  A list containing the string ``locationtype'' and the
		  LocationType character.*/
		/*@Doc: \item[\ ]  A list containing the string ``locationdetail'' and
		  the location detail. */
		/*@Doc: \item[\ ]  A list containing the string ``categorycode'' and the
		  catcode number.*/
		/*@Doc: \end{description} */
		Tcl_DStringInit(&result);
		NoArgList(&result);
		Tcl_DStringResult(interp,&result);
		return TCL_OK;
	}
	if (argc < 2)
	{
		Tcl_AppendResult(interp, "wrong # args: should be \"",
				 argv[0], " option ?arg arg ...?\"",
				 (char *) NULL);
		return TCL_ERROR;
	}
	//@Man: type
	/*@Doc: With the option ``type'', the string ``CardRecord'' is returned. */
	if (strcmp(argv[1], "type") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],(char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp, "CardRecord", (char *) NULL);
		return TCL_OK;
	//@Man: cardtype
	//@Args: ?newcardtype?
	/*@Doc: With the option ``cardtype'' and no additional arguments, the
	  CardType character code is returned.  With one additional argument,
	  a CardType character code (one of the characters ``B M D C 8 E 4 O a
	  b c d e f g h i j''), the CardType is set to this CardType character
	  code, which is also returned.
	 */
	} else if (strcmp(argv[1], "cardtype") == 0)
	{
		if (argc == 3)
		{
			if (!Card::IsCardType(argv[2][0]))
			{
				Tcl_AppendResult(interp, "Bad card type: ",
						 argv[2]," should be one of {",
						 "B M D C 8 E 4 O a b c d e f",
						 " g h i j}",
						 (char *) NULL);
				return TCL_ERROR;
			}
			CardRec->SetType((Card::CardType)argv[2][0]);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		tempstring[0] = (char) (*CardRec)->type;
		tempstring[1] = '\0';
		Tcl_AppendResult(interp, tempstring, (char *) NULL);
		return TCL_OK;
	//@Man: author
	//@Args: ?newauthor?
	/*@Doc: With the option ``author'' and no additional arguments, the
	  author is returned.  With one additional argument, a string, the
	  author is set to this string, which is also returned.
	 */
	} else if (strcmp(argv[1], "author") == 0)
	{
		if (argc == 3)
		{
			CardRec->SetAuthor(argv[2]);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp, (*CardRec)->author, (char *) NULL);
		return TCL_OK;
	//@Man: title
	//@Args: ?newtitle?
	/*@Doc: With the option ``title'' and no additional arguments, the
	  title is returned.  With one additional argument, a string, the
	  title is set to this string, which is also returned.
	 */
	} else if (strcmp(argv[1], "title") == 0)
	{
		if (argc == 3)
		{
			CardRec->SetTitle(argv[2]);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp, (*CardRec)->title, (char *) NULL);
		return TCL_OK;
	//@Man: publisher
	//@Args: ?newpublisher?
	/*@Doc: With the option ``publisher'' and no additional arguments, the
	  publisher is returned.  With one additional argument, a string, the
	  publisher is set to this string, which is also returned.
	 */
	} else if (strcmp(argv[1], "publisher") == 0)
	{
		if (argc == 3)
		{
			CardRec->SetPublisher(argv[2]);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp, (*CardRec)->publisher, (char *) NULL);
		return TCL_OK;
	//@Man: city
	//@Args: ?newcity?
	/*@Doc: With the option ``city'' and no additional arguments, the
	  city is returned.  With one additional argument, a string, the
	  city is set to this string, which is also returned.
	 */
	} else if (strcmp(argv[1], "city") == 0)
	{
		if (argc == 3)
		{
			CardRec->SetCity(argv[2]);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp, (*CardRec)->city, (char *) NULL);
		return TCL_OK;
	//@Man: description
	//@Args: ?newdescription?
	/*@Doc: With the option ``description'' and no additional arguments, the
	  description is returned.  With one additional argument, a string, the
	  description is set to this string, which is also returned.
	 */
	} else if (strcmp(argv[1], "description") == 0)
	{
		if (argc == 3)
		{
			CardRec->SetDescription(argv[2]);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp, (*CardRec)->description, (char *) NULL);
		return TCL_OK;
	//@Man: vol
	//@Args: ?newvol?
	/*@Doc: With the option ``vol'' and no additional arguments, the volume
	  number is returned.  With one additional argument, an integer, the
	  volume number is set to this integer, which is also returned.
	 */
	} else if (strcmp(argv[1], "vol") == 0)
	{
		if (argc == 3)
		{
			int Vol;
			if (Tcl_GetInt(interp, argv[2], &Vol) != TCL_OK)
				return TCL_ERROR;
			CardRec->SetVol(Vol);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		sprintf(tempstring,"%d",(*CardRec)->vol);
		Tcl_AppendResult(interp,tempstring,(char *) NULL);
		return TCL_OK;
	//@Man: year
	//@Args: ?newyear?
	/*@Doc: With the option ``year'' and no additional arguments, the year
	  is returned.  With one additional argument, an integer, the year is 
	  set to this integer, which is also returned.
	 */
	} else if (strcmp(argv[1], "year") == 0)
	{
		if (argc == 3)
		{
			int Year;
			if (Tcl_GetInt(interp, argv[2], &Year) != TCL_OK)
				return TCL_ERROR;
			CardRec->SetYear(Year);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		sprintf(tempstring,"%d",(*CardRec)->year);
		Tcl_AppendResult(interp,tempstring,(char *) NULL);
		return TCL_OK;
	//@Man: locationtype
	//@Args: ?newlocationtype?
	/*@Doc: With the option ``locationtype'' and no additional arguments,
	  the LocationType character code is returned.  With one additional
	  argument, a LocationType character code (one of the characters ``S L
	  O D s U a b c d e f g h i j''), the LocationType is set to this 
	  LocationType character code, which is also returned.
	 */
	} else if (strcmp(argv[1], "locationtype") == 0)
	{
		if (argc == 3)
		{
			if (!Card::IsLocationType(argv[2][0]))
			{
				Tcl_AppendResult(interp, "Bad location type: ",
						 argv[2]," should be one of {",
						 "S L O D s U a b c d e f g h",
						 " i j}",(char *) NULL);
				return TCL_ERROR;
			}
			CardRec->SetLocType((Card::LocationType)argv[2][0]);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		tempstring[0] = (char) (*CardRec)->ltype;
		tempstring[1] = '\0';
		Tcl_AppendResult(interp, tempstring, (char *) NULL);
		return TCL_OK;
	//@Man: locationdetail
	//@Args: ?newlocationdetail?
	/*@Doc: With the option ``locationdetail'' and no additional arguments,
	  the location detail is returned.  With one additional argument, a 
	  string, the location detail is set to this string, which is also 
	  returned.
	 */
	} else if (strcmp(argv[1], "locationdetail") == 0)
	{
		if (argc == 3)
		{
			CardRec->SetLocDetail(argv[2]);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp, (*CardRec)->locdetail, (char *) NULL);
		return TCL_OK;
	//@Man: categorycode
	//@Args: ?newcategorycode
	/*@Doc: With the option ``categorycode'' and no additional arguments,
	  the catcode is returned.  With one additional argument, an integer
	  in the range 0-255 inclusive, the catcode is set to this integer,
	  which is also returned.
	 */
	} else if (strcmp(argv[1], "categorycode") == 0)
	{
		if (argc == 3)
		{
			int cc;
			if (Tcl_GetInt(interp, argv[2], &cc) != TCL_OK)
				return TCL_ERROR;
			if (cc < 0 || cc > 255)
			{
				Tcl_AppendResult(interp, "Catagory code, ",
						 argv[2],
						 " out of range: should be from 0 to 255, inclusive",
						 (char *) NULL);
				return TCL_ERROR;
			}
			CardRec->SetCatCode((unsigned char)cc);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		sprintf(tempstring,"%d",(*CardRec)->catcode);
		Tcl_AppendResult(interp,tempstring,(char *) NULL);
		return TCL_OK;
	//@Man: delete
	/*@Doc: With the option ``delete'', the CardRecord instance is
	  deleted and its memory re-claimed.  The handle command is deleted
	  from Tcl.
	  \index{CardRecord!Tcl Interface!Handle options|)}
	  \index{CardRecord!Tcl Interface|)}
	 */
	} else if (strcmp(argv[1], "delete") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		return Tcl_DeleteCommand(interp,argv[0]);
	} else
	{
		Tcl_AppendResult(interp, "Bad option: ",argv[1],(char *) NULL);
		return TCL_ERROR;
	}
}
//@}

TkCardRecord::TkCardRecord(const Record* record)
{
	myEntry = NULL;
	CardRec = new CardRecord(record);
}

TkCardRecord::TkCardRecord(const CoreItem* coreitem)
{
	myEntry = NULL;
	CardRec = new CardRecord(coreitem);
}

TkCardRecord::TkCardRecord(const Card* card)
{
	myEntry = NULL;
	CardRec = new CardRecord(card);
}

TkCardRecord::TkCardRecord(const CardRecord& cardrecord)
{
	myEntry = NULL;
	CardRec = new CardRecord(cardrecord);
}

TkCardRecord::~TkCardRecord()
{
	DeleteMyHandle();
	if (CardRec != NULL) delete CardRec;
}

int TkCardRecord::createTkCardRecord(Tcl_Interp *interp,const Record* record)
{
	TkCardRecord *tkCardRecord = new TkCardRecord(record);
	tkCardRecord->newHandle();
	Tcl_CreateCommand(interp,tkCardRecord->myHandle,
			  (Tcl_CmdProc*)TkCppWraper::TclCommand,
			  (ClientData)tkCardRecord,
			  (Tcl_CmdDeleteProc*)TkCppWraper::deleteTkCppWraper);
	Tcl_AppendResult(interp,tkCardRecord->myHandle,(char *) NULL);
	return TCL_OK;
}

int TkCardRecord::createTkCardRecord(Tcl_Interp *interp,const CoreItem* coreitem)
{
	TkCardRecord *tkCardRecord = new TkCardRecord(coreitem);
	tkCardRecord->newHandle();
	Tcl_CreateCommand(interp,tkCardRecord->myHandle,
			  (Tcl_CmdProc*)TkCppWraper::TclCommand,
			  (ClientData)tkCardRecord,
			  (Tcl_CmdDeleteProc*)TkCppWraper::deleteTkCppWraper);
	Tcl_AppendResult(interp,tkCardRecord->myHandle,(char *) NULL);
	return TCL_OK;
}

int TkCardRecord::createTkCardRecord(Tcl_Interp *interp,const Card* card)
{
	TkCardRecord *tkCardRecord = new TkCardRecord(card);
	tkCardRecord->newHandle();
	Tcl_CreateCommand(interp,tkCardRecord->myHandle,
			  (Tcl_CmdProc*)TkCppWraper::TclCommand,
			  (ClientData)tkCardRecord,
			  (Tcl_CmdDeleteProc*)TkCppWraper::deleteTkCppWraper);
	Tcl_AppendResult(interp,tkCardRecord->myHandle,(char *) NULL);
	return TCL_OK;
}

int TkCardRecord::createTkCardRecord(Tcl_Interp *interp,const CardRecord& cardrecord)
{
	TkCardRecord *tkCardRecord = new TkCardRecord(cardrecord);
	tkCardRecord->newHandle();
	Tcl_CreateCommand(interp,tkCardRecord->myHandle,
			  (Tcl_CmdProc*)TkCppWraper::TclCommand,
			  (ClientData)tkCardRecord,
			  (Tcl_CmdDeleteProc*)TkCppWraper::deleteTkCppWraper);
	Tcl_AppendResult(interp,tkCardRecord->myHandle,(char *) NULL);
	return TCL_OK;
}

const char* TkCardRecord::MyType() const
{
	return "CardRecord";
}

const CardRecord * TkCardRecord::theCardRecord() const
{
	return CardRec;
}

TkCardRecord* TkCardRecord::FindCardByHandle(const char* handle)
{
	Tcl_HashEntry *entry = Tcl_FindHashEntry(&HandleHashTable,handle);
	if (entry == NULL) return NULL;
	else
	{
		TkCppWraper *tmp = (TkCppWraper *) Tcl_GetHashValue(entry);
		if (strcmp(tmp->MyType(),"CardRecord") == 0)
			return (TkCardRecord*) tmp;
		else return NULL;
	}
}

int TkCardRecord::Init_TkCardRecord(Tcl_Interp *interp)
{
	Tcl_CreateCommand(interp, "CardRecord",
			  (Tcl_CmdProc*)TkCardRecord::tkCardRecordCreate,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	return TCL_OK;
}

