/* -*- Mode: C -*- */
/* ListRecord.h - A record as a list
 * Created by Robert Heller on Fri Dec  6 20:25:42 1991
 * Updated for Version 2.0 on Sat Apr 26 13:19:50 1997
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Common Header Files
 * ------------------------------------------------------------------
 * Modification History:
 * $Log: ListRecord.h,v $
 * Revision 2.7  1998/05/16 23:43:28  heller
 * Add indexing to the documentation.
 *
 * Revision 2.6  1998/04/21 15:12:18  heller
 * Update copyright notice.
 *
 * Revision 2.5  1997/07/20 19:50:20  heller
 * Spelling errors
 *
 * Revision 2.4  1997/07/15 21:38:16  heller
 * Update documentation (operator weirdness)
 *
 * Revision 2.3  1997/07/15 17:08:18  heller
 * Add in documentation
 *
 * Revision 2.2  1997/07/13 13:16:57  heller
 * Added strncasecmp for MacOS
 *
 * Revision 2.1  1997/06/29 19:14:59  heller
 * Fixes for portablity with CW
 *
 * Revision 2.0  1997/04/26 19:06:49  heller
 * *** empty log message ***
 *
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 *    Home Librarian Database -- a program for maintaining a database
 *                               for a home library
 *    Copyright (C) 1991-1997  Robert Heller D/B/A Deepwoods Software
 *			51 Locke Hill Road
 *			Wendell, MA 01379-9728
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */
#ifndef _LRECORD_
#define _LRECORD_
#include <common.h>

//@ChapterName:Class For Storing Lists of Things.

/*@ManDoc:
  \typeout{Generated from: $Id: ListRecord.h,v 2.7 1998/05/16 23:43:28 heller Rel $}
  \index{ListRecord!C++ Interface|(}
  \index{ListRecord!C++ Interface!ListRecord class|bold}
   This class maps between the list on disk (as a record) and the list
   in memory (as a vector).
 */
class ListRecord {
	//@ManMemo: RawData is the disk record.
	Record RawData;
	//@ManMemo: numelts is the number of elements.
	int numelts;
	//@ManMemo: elems is the vector in memory.
	char** elems;
	//@ManMemo: make a record from the existing vector.
	void UpdateRecord();
	//@ManMemo: make a record from a new vector vector.
	void CreateRecord(int numitems,const char* const inelems[]);
public:
	/*@ManDoc: \index{ListRecord!C++ Interface!Constructor (from a record)} 
	  A ListRecord from a Record.
	 */
	      ListRecord(const Record* record);
	/*@ManDoc: \index{ListRecord!C++ Interface!Constructor (from a coreitem)}
	  A ListRecord from a CoreItem.
	 */
	      ListRecord(const CoreItem* coreitem);
	/*@ManDoc: \index{ListRecord!C++ Interface!Constructor (from a vector)}
	  A ListRecord from a vector.
	 */
	      ListRecord(int numitems,const char* const inelems[]);
	/*@ManDoc: \index{ListRecord!C++ Interface!Constructor (from a single element)}
	  A ListRecord from a single element.
	 */
	      ListRecord(const char* element);
	/*@ManDoc: \index{ListRecord!C++ Interface!Copier Constructor}
	  Copier Constructor.
	 */
	      ListRecord(const ListRecord& oldrec);
	/*@ManDoc: \index{ListRecord!C++ Interface!AddElement}
	  Add an element.  Elements are checked for duplicates
	  (case folded).  Returns the new element count.
	 */
	int AddElement(const char* element);
	/*@ManDoc: \index{ListRecord!C++ Interface!RemoveElement (named)}
	  Remove a named element. Returns the new element count. */
	int RemoveElement(const char* element);
	/*@ManDoc: \index{ListRecord!C++ Interface!RemoveElement (indexed)}
	  Remove an element by index. Returns the new element count. */
	int RemoveElement(int ielt);
	/*@ManDoc: \index{ListRecord!C++ Interface!"=@"= operator}
	  Assignment operator. */
	ListRecord& operator = (const ListRecord& oldrec) ; 
	/*@ManDoc: \index{ListRecord!C++ Interface!Destructor}
	  Destructor.  Clean things up. */
	     ~ListRecord() { RawData.NewBuffer(0); delete elems; }
	//@Man: operator []
	//@Type: const char*
	//@Args: (int index)
	//@Doc: \index{ListRecord!C++ Interface!"[@"[] operator} Index operator.
	const char* operator [] (int index) const
			{ if (index >= 0 && index < numelts)
			       return elems[index];
			  else return NULL;}
	//@Man: operator const Record
	//@Args: ()
	//@Doc: \index{ListRecord!C++ Interface!"(@"() operator} Convert a ListRecord to a plain Record.
	operator const Record () const
		{
			return RawData;
		}
	//@ManDoc: \index{ListRecord!C++ Interface!ElementCount} Return number of elements.   \index{ListRecord!C++ Interface|)}
	int ElementCount () const { return numelts; }
};

#ifdef __MWERKS__
extern int strcasecmp(const char *s1, const char *s2);
extern int strncasecmp(const char *s1, const char *s2,int len);
#endif
#endif
