/* -*- Mode: C -*- */
/* CardRecord.h - A record as a card
 * Created by Robert Heller on Fri Dec  6 20:20:08 1991
 * Updated for Version 2.0 on Sat Apr 26 13:19:29 1997
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Common Header Files
 * ------------------------------------------------------------------
 * Modification History:
 * $Log: CardRecord.h,v $
 * Revision 2.3  1998/05/16 23:43:28  heller
 * Add indexing to the documentation.
 *
 * Revision 2.2  1998/04/21 15:12:18  heller
 * Update copyright notice.
 *
 * Revision 2.1  1997/07/15 14:24:46  heller
 * Add in documentation
 *
 * Revision 2.0  1997/04/26 19:06:49  heller
 * *** empty log message ***
 *
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 *    Home Librarian Database -- a program for maintaining a database
 *                               for a home library
 *    Copyright (C) 1991-1997  Robert Heller D/B/A Deepwoods Software
 *			51 Locke Hill Road
 *			Wendell, MA 01379-9728
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */

//@ChapterName:Class For Storing Catalog Card Images

#ifndef _CRECORD_
#define _CRECORD_
#include <common.h>
#include <Card.h>

/*@ManDoc:
  \typeout{Generated from: $Id: CardRecord.h,v 2.3 1998/05/16 23:43:28 heller Rel $}
  \index{CardRecord!C++ Interface|(}
  \index{CardRecord!C++ Interface!CardRecord class|bold}
  This class maps between the card on disk (as a record) and the card
  in memory (as a Card structure).
  */
class CardRecord {
	//@ManMemo: RawData is the disk record.
	Record RawData;
	//@ManMemo: Card is the structure representation.
	Card* card;
	//@ManMemo: Parse a card record into a Card*
	Card* RecordToCard() const;
	//@ManMemo: Convert a Card* to a record.
	void CreateRecord(const Card* card);
	//@ManMemo: Convert a Card* to a record.
	void UpdateRecord();
public:
	/*@ManDoc: \index{CardRecord!C++ Interface!Constructor (from a Record)}
	  Construct a CardRecord from a Record. */
	      CardRecord(const Record* record);
	/*@ManDoc: \index{CardRecord!C++ Interface!Constructor (from a CoreItem)}
	  Construct a CardRecord from a CoreItem.
	 */
	      CardRecord(const CoreItem* coreitem);
	/*@ManDoc: \index{CardRecord!C++ Interface!Constructor (from a Card)}
	  Construct a CardRecord from a Card.
	 */
	      CardRecord(const Card* card);
	/*@ManDoc: \index{CardRecord!C++ Interface!Constructor (from a another CardRecord)}
	  Construct a CardRecord from another CardRecord.
	 */
	      CardRecord(const CardRecord& cardrecord);
	/*@ManDoc: \index{CardRecord!C++ Interface!Destructor}
	  Deconstruct a CardRecord.
	 */
	     ~CardRecord();
	/*@ManDoc:  \index{CardRecord!C++ Interface!"->@"-> operator}
	  Pointer magic - make a CardRecord look just like a Card*
	 */
	const Card* operator -> () const {return card;}
	/*@ManDoc:  \index{CardRecord!C++ Interface!"*@"* operator}
	 Pointer magic - make a CardRecord look just like a Card*
	 */
	const Card& operator *  () const {return *card;}
	/*@ManDoc: \index{CardRecord!C++ Interface!"&@"\& operator}
	  Pointer magic - make a CardRecord look just like a Card*
	 */
	const Card* operator &  () const {return card;}
	/*@ManDoc: \index{CardRecord!C++ Interface!SetType}
	  Set the item type field.
	 */
	void  SetType(const Card::CardType t)
		{card->type = t;UpdateRecord();}
	/*@ManDoc: \index{CardRecord!C++ Interface!SetAuthor}
	  Set the author field.
	 */
	void  SetAuthor(const char* a)
		{
			card->author = a;
			UpdateRecord();
		}
	/*@ManDoc: \index{CardRecord!C++ Interface!SetTitle}
	  Set the title field.
	 */
	void  SetTitle(const char* a)
		{
			card->title = a;
			UpdateRecord();
		}
	/*@ManDoc: \index{CardRecord!C++ Interface!SetPublisher}
	  Set the publisher field.
	 */
	void  SetPublisher(const char* a)
		{
			card->publisher = a;
			UpdateRecord();
		}
	/*@ManDoc: \index{CardRecord!C++ Interface!SetCity}
	  Set the city field.
	 */
	void  SetCity(const char* a)
		{
			card->city = a;
			UpdateRecord();
		}
	/*@ManDoc: \index{CardRecord!C++ Interface!SetDescription}
	  Set the description field.
	 */
	void  SetDescription(const char* a)
		{
			card->description = a;
			UpdateRecord();
		}
	/*@ManDoc: \index{CardRecord!C++ Interface!SetVol}
	  Set the vol field.
	 */
	void  SetVol(const int v)
		{card->vol = v;UpdateRecord();}
	/*@ManDoc: \index{CardRecord!C++ Interface!SetYear}
	  Set the year field.
	 */
	void  SetYear(const int y)
		{card->year = y;UpdateRecord();}
	/*@ManDoc: \index{CardRecord!C++ Interface!SetLocType}
	  Set the location type field.
	 */
	void  SetLocType(const Card::LocationType t)
		{card->ltype = t;UpdateRecord();}
	/*@ManDoc: \index{CardRecord!C++ Interface!SetLocDetail}
	  Set the location detail field.
	 */
	void  SetLocDetail(const char* a)
		{
			card->locdetail = a;
			UpdateRecord();
		}
	/*@ManDoc: \index{CardRecord!C++ Interface!SetCatCode}
	  Set the category code field.
	 */
	void  SetCatCode(const unsigned char cc)
		{
			card->catcode = cc;
			UpdateRecord();
		}
	/*@ManDoc: \index{CardRecord!C++ Interface!"=@"= operator}
	  Copier (assignment) function.
	 */
	CardRecord& operator = (const CardRecord& cardrecord);
	/*@ManDoc: \index{CardRecord!C++ Interface!Record operator}
	  Convert a CardRecord to a plain Record.
	  \index{CardRecord!C++ Interface|)}
	 */
	operator const Record  () const
		{
			return RawData;
		}
};

#endif


