/* -*- Mode: C -*- */
/* CardRecord.cc - Implementation of CardRecords
 * Created by Robert Heller on Sat Dec  7 00:01:57 1991
 * Updated for Version 2.0 on Sat Apr 26 13:55:22 1997
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Common Class library implementation code
 * ------------------------------------------------------------------
 * Modification History:
 * $Log: CardRecord.cc,v $
 * Revision 2.3  1998/04/21 15:12:18  heller
 * Update copyright notice.
 *
 * Revision 2.2  1997/09/20 02:56:59  heller
 * Bulletproof for NULL pointer string fields in a card.
 *
 * Revision 2.1  1997/07/06 21:44:54  heller
 * Misc. changes
 *
 * Revision 2.0  1997/04/26 19:06:49  heller
 * *** empty log message ***
 *
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 *    Home Librarian Database -- a program for maintaining a database
 *                               for a home library
 *    Copyright (C) 1991-1997  Robert Heller D/B/A Deepwoods Software
 *			51 Locke Hill Road
 *			Wendell, MA 01379-9728
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */

#ifdef MESSYDOS
#include <cardrec.h>
#else
#include <CardRecord.h>
#endif
#include <stdio.h>
//#include <iostream.h>

static char ID[] = "$Id: CardRecord.cc,v 2.3 1998/04/21 15:12:18 heller Rel $";

// CardRecord constructor, given an existing CardRecord
CardRecord::CardRecord(const CardRecord& cardrecord)
{
	RawData = cardrecord.RawData;
	card = RecordToCard();
}
// CardRecord copier function
CardRecord& CardRecord::operator = (const CardRecord& cardrecord)
{
	RawData = cardrecord.RawData;
	if (card != NULL) {
		delete card;
	}
	card = RecordToCard();
	return *this;
}
// CardRecord constructor, given a CoreItem
CardRecord::CardRecord(const CoreItem* coreitem)
{
	RawData = coreitem->data;
	card = RecordToCard();
}
// CardRecord constructor, given a Record*
CardRecord::CardRecord(const Record* record)
{
	RawData = *record;
	card = RecordToCard();
}
// CardRecord constructor, given a Card*
CardRecord::CardRecord(const Card* incard)
{
	card = NULL;
	CreateRecord(incard);
	card = RecordToCard();
}
// CardRecord destructor
CardRecord::~CardRecord()
{
	delete card;
	RawData.NewBuffer(0);
}
// Conversion function - convert from a Record to a Card
// derived from the code for RawBook::RawToBook() on page 91 of
// "C++, a guide for C programmers", by Sharam Hekmatpour
Card*  CardRecord::RecordToCard () const
{
	register char* str = RawData.buffer;	// Data string
	register int   bytesleft = RawData.size; // Number of bytes
	register Card *cd = new Card;		// allocate a fresh Card


	// while bytes remain...
	while (bytesleft > 0) {
		// scan for field specifier
		while (*str != '%' && bytesleft > 0) { str++; bytesleft--; }
		// skip over specified prefix
		str++; bytesleft--;
		// while there still are bytes...
		if (bytesleft <= 0) break;
		// fan out based on field key
		switch (*str++) {
			case 'A': cd->author = str;  break;
			case 'T': cd->title  = str;  break;
			case 'P': cd->publisher = str;  break;
			case 'C': cd->city = str;    break;
			case 'V': cd->vol = atoi(str); break;
			case 'Y': cd->year = atoi(str); break;
			case 'D': cd->description = str; break;
			case 't': cd->type = (enum Card::CardType) *str; break;
			case 'l': cd->ltype = (enum Card::LocationType) *str; break;
			case 'L': cd->locdetail = str; break;
			case 'c': cd->catcode = atoi(str); break;
		}
		// count specifier
		bytesleft--;
		// find strlen plus nul byte
		int slen = strlen(str) + 1;
		// update counter and pointer
		bytesleft -= slen;
		str += slen;
		// EOR marker?
		if (*str == '\n') break;
	}
	// return new Card* pointer
	return cd;
}

// Create a fresh record from a Card
void CardRecord::CreateRecord(const Card* incard)
{
	static char vstr[20], ystr[20], cstr[10];	// temp strings for numerics

	//cerr << "*** CardRecord::CreateRecord: incard = "; cerr.form("0x%08x",(long int)incard); cerr << endl;
	// form numeric strings
	sprintf(vstr,"%d",incard->vol);
	sprintf(ystr,"%d",incard->year);
	sprintf(cstr,"%d",incard->catcode);
	// compute buffer size
	int rsize = 4 +				// "%tT\0"
		4 +				// "%lL\0"
		((incard->author)?(strlen(incard->author)):(0)) + 3 +	// "%Aauthor\0"
		((incard->title)?(strlen(incard->title)):(0)) + 3 +	// "%Ttitle\0"
		((incard->publisher)?(strlen(incard->publisher)):(0)) + 3 +	// "%Ppublisher\0"
		((incard->city)?(strlen(incard->city)):(0)) + 3 +	// "%Ccity\0"
		((incard->description)?(strlen(incard->description)):(0)) + 3 +	// "%Ddescription\0"
		((incard->locdetail)?(strlen(incard->locdetail)):(0)) + 3 + // "%Llocdetail\0"
		strlen(vstr) + 3 +		// "%Vnnnn\0"
		strlen(ystr) + 3 +		// "%Ynnnn\0"
		strlen(cstr) + 3 +		// "%cnnnn\0"
		strlen("\n") + 1;		// "\n\0"
	// allocate a string
#ifdef __DMALLOC_H__
	_dmalloc_file = __FILE__; _dmalloc_line = __LINE__;
#endif
	char* str = new char[rsize]; char* p = str;
	// pack data into the string
	*p++ = '%'; *p++ = 't'; *p++ = incard->type;  *p++ = 0;
	*p++ = '%'; *p++ = 'l'; *p++ = incard->ltype; *p++ = 0;
	*p++ = '%'; *p++ = 'A'; if (incard->author) strcpy(p,incard->author); else strcpy(p,""); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'T'; if (incard->title) strcpy(p,incard->title); else strcpy(p,""); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'P'; if (incard->publisher) strcpy(p,incard->publisher); else strcpy(p,""); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'C'; if (incard->city) strcpy(p,incard->city); else strcpy(p,""); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'D'; if (incard->description) strcpy(p,incard->description); else strcpy(p,""); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'V'; strcpy(p,vstr); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'Y'; strcpy(p,ystr); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'c'; strcpy(p,cstr); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'L'; if (incard->locdetail) strcpy(p,incard->locdetail); else strcpy(p,""); p += strlen(p) + 1;
//	cerr.form("*** before *p++ = '\\n'; *p++ = 0;: p = 0x%08x\n",(long) p);
	*p++ = '\n'; *p++ = 0;
//	cerr.form("*** after  *p++ = '\\n'; *p++ = 0;: p = 0x%08x\n",(long) p);
	// free up old buffer
	RawData.NewBuffer(0);
	// paste in new buffer
	RawData.size = rsize;
	RawData.buffer = str;
}

void CardRecord::UpdateRecord()
{
	CreateRecord(card);
	delete card;
	card = RecordToCard();
}
