/* -*- Mode: C -*- */
/* Card.cc - Card class implementation
 * Created by Robert Heller on Fri Dec  6 23:52:08 1991
 * Updated for Version 2.0 on Sat Apr 26 13:23:06 1997
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Common Class library implementation code
 * ------------------------------------------------------------------
 * Modification History:
 * $Log: Card.cc,v $
 * Revision 2.6  1998/04/21 15:12:18  heller
 * Update copyright notice.
 *
 * Revision 2.5  1997/07/06 21:44:54  heller
 * remove need for global constructor.
 *
 * Revision 2.4  1997/07/01 16:40:04  heller
 * Remove "const" from static check functions
 *
 * Revision 2.3  1997/07/01 15:58:57  heller
 * Add in check functions for CardType and LocationType
 *
 * Revision 2.2  1997/06/29 19:14:59  heller
 * Fixes for portablity with CW
 *
 * Revision 2.1  1997/04/26 19:15:30  heller
 * small typo
 *
 * Revision 2.0  1997/04/26 19:06:49  heller
 * *** empty log message ***
 *
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *    Home Librarian Database -- a program for maintaining a database
 *                               for a home library
 *    Copyright (C) 1991-1998  Robert Heller D/B/A Deepwoods Software
 *			51 Locke Hill Road
 *			Wendell, MA 01379-9728
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * 
 */
#include <Card.h>
#include <ctype.h>
#include <iostream.h>

static char ID[] = "$Id: Card.cc,v 2.6 1998/04/21 15:12:18 heller Rel $";

#ifdef MYSTORAGE
int Card::numblocks = 0;	// current number of allocated blocks
Card* Card::blocks[maxblocks]; // allocated cards
Card* Card::freelist = NULL;	// linked list of available cards

// Helper function to allocate an additional block of 100 Cards
void Card::moreblocks ()
{
	// Have we run out of blocks?
	if (numblocks < maxblocks) {
		// if not...  bump block counter
		int iblock = numblocks++;
		// snarf some memory
		Card* p = blocks[iblock] = (Card*) new char[sizeof(Card)*blocksize];
		// build linked list.  author field doubles as next pointer.
		for (int ic = 1; ic < blocksize; ic++) {
			p->author = (char*) (p+1);
			p++;
		}
		// point last tail at current freelist
		p->author = (char*) freelist;
		// and set freelist head to first Card in fresh block
		freelist = blocks[iblock];
	}
}
			
// overloaded new operator for Cards
void* Card::operator new (long)
{
	// if freelist is empty, get more memory
	if (Card::freelist == 0) Card::moreblocks();
	// if freelist is still empty, return null
	if (Card::freelist == 0) return(0);
	// get pointer to head of list
	Card* newcard = Card::freelist;
	// set freelist to next card in the list
	Card::freelist = (Card*) newcard->author;
	// unlink new card from the list
	newcard->author = 0;
	cerr << "*** new ((Card*)"; cerr.form("0x%08x",(long int)newcard);
	cerr << ");" << endl;
	// retun new card
	return(newcard);
}

// overloaded delete operator for Cards
void Card::operator delete(void* vptr)
{
	// convert pointer to a Card*
	Card* ptr = (Card*) vptr;
	// if a null pointer, just return
	if (ptr == 0) return;
	// has this card already be freed?
	cerr << "*** delete ((Card*)";
	cerr.form("0x%08x",(long int)ptr);
	cerr << ");" << endl;
//	for (Card* p = Card::freelist; p != 0; p = (Card*) p->author) {
//		if (p == ptr) return;	// if so, don't free it again
//	}
	// link onto head of free list
	ptr->author = (char*) Card::freelist;
	Card::freelist = ptr;
}
#endif

Boolean Card::IsCardType (char tc)
{
	switch (tc)
	{
		case Book:
		case Magazine:
		case CD:
		case AudioCassette:
		case Album:
		case LaserDisk:
		case VHSVideo:
		case BetaVideo:
		case EightMM:
		case EightTrack:
		case DAT:
		case Other:
		case UC1:
		case UC2:
		case UC3:
		case UC4:
		case UC5:
		case UC6:
		case UC7:
		case UC8:
		case UC9:
		case UC10: return true; break;
		default: return false;
	}
		
}

Boolean Card::IsLocationType (char tc)
{
	switch (tc)
	{
		case OnShelf:
		case OnLoan:
		case OnOrder:
		case Destroyed:
		case InStorage:
		case Unknown:
		case UL1:
		case UL2:
		case UL3:
		case UL4:
		case UL5:
		case UL6:
		case UL7:
		case UL8:
		case UL9:
		case UL10: return true; break;
		default: return false;
	}		
}

