#@Chapter:balloon.tcl
#@Label:balloon.tcl
#@Typeout:BALLOON.TCL - Copyright (c) by Victor Wagner, 1997
#
# Tcl Library to provide balloon help.
#
# balloon help bindings are automatically added to all buttons and
# menus by init_balloon call.
# you have only to provide descriptions for buttons or menu items by
# setting elements of global help_tips array, indexed by button path or
# menu path,item to something useful.
# if you want to have balloon helps for any other widget you can
# do so by enable_balloon widget_path_or_class
# or enable_balloon_selective widget_path_or_class Tcl_Script
#
# You can toggle balloon help globally on and off by setting variable
# use_balloons to true or false

catch "package require getopt"

proc enable_balloon {name_to_bind {script {}}} {
# Enable ballon help.
# [index] enable\_balloon!procedure


  if ![llength $script] {
    bind $name_to_bind <Any-Enter> "+schedule_balloon %W %X %Y"
    bind $name_to_bind <Any-Motion> "+reset_balloon %W %X %Y"
  } else {
    bind $name_to_bind <Any-Enter> "+schedule_balloon %W %X %Y \[$script\]"
    bind $name_to_bind <Any-Motion> "+reset_balloon %W %X %Y \[$script\]"
  }
  bind $name_to_bind <Any-Leave> "+cancel_balloon"
}

proc schedule_balloon {window x y {item {}}} {
# Schedule ballon help
# [index] schedule\_balloon!procedure

  global use_balloons help_tips balloon_after_ID 
  if !$use_balloons return
  if [string length $item] {
    set index "$window,$item"
  } else {
    set index $window
  }
  if [info exists help_tips($index)] {
    set balloon_after_ID \
	[after $help_tips(delay) "create_balloon \"$help_tips($index)\" $x $y"]
  }
}
proc reset_balloon {window x y {item {}}} {
# Reset ballon help.
# [index] reset\_balloon!procedure

  cancel_balloon
  schedule_balloon $window $x $y $item
}

proc cancel_balloon {} {
# Cancel ballon help.
# [index] cancel\_balloon!procedure

  global balloon_after_ID
  if [info exists balloon_after_ID] {
    catch "after cancel $balloon_after_ID"
    catch "unset balloon_after_ID"
  } else { 
    if [winfo exists .balloon_help] {catch "destroy .balloon_help"}
  }
}

proc create_balloon {text x y} {
# Create a help ballon.
# [index] create\_balloon!procedure

  global balloon_after_ID help_tips
  catch "destroy .balloon_help"
  toplevel .balloon_help -relief flat
  unset balloon_after_ID
  wm overrideredirect .balloon_help true
  wm positionfrom .balloon_help program
  wm geometry .balloon_help "+[expr $x+5]+[expr $y+5]"
  frame .balloon_help.f -relief ridge -borderwidth 2 -bg black
  pack .balloon_help.f -expand 1 -fill both
  label .balloon_help.f.tip -text $text -wraplength $help_tips(width) \
	-bg $help_tips(color) -font $help_tips(font)
  pack .balloon_help.f.tip -fill both
}

proc init_balloons {args} {
# Initialize ballon help.
# [index] init\_balloons!procedure

  global help_tips use_balloons
  set help_tips(width) 150
  set help_tips(color) #ffff60
  set help_tips(delay) 1000
  label .x
  set help_tips(font) "[.x cget -font]"
  destroy .x
  getopt help_tips $args
  set use_balloons 1
  enable_balloon Button
  enable_balloon Menubutton
  enable_balloon Menu "%W index active" 
}
package provide balloon 1.0

