proc DoCard {heading Id Record} {
  set upi [printer getunitsperinch]
  set topleftbottomright "[printer getpagebbox]"
  if {[lindex $topleftbottomright 0] < [lindex $topleftbottomright 2]} {
    set dy 1
  } else {
    set dy -1
  }
  if {[lindex $topleftbottomright 1] < [lindex $topleftbottomright 3]} {
    set dx 1
  } else {
    set dx -1
  }
  set top [lindex $topleftbottomright 0]
  set left [lindex $topleftbottomright 1]
  set bottom [expr $top + (5 * $upi * $dy)]
  set right [expr $left + (8 * $upi * $dx)]
  printer openpage
  printer setcolor 0 0 0
  printer drawrectangle $left $top $right $bottom [expr $upi / 16]
  printer setfont Courier-Bold [expr $upi * .125]
  set textX1 [expr $left + ($upi * .5 * $dx)]
  set textY1 [expr $top + ($upi * .125 * $dy)]
  set textX2 [expr $right - ($upi / 16 * $dx)]
  set textY2 [expr $textY1 + ($upi * .125 * $dy)]
  printer drawtextinbbox $textX1 $textY1 $textX2 $textY2 "$heading - $Id"
  printer setfont Courier [expr $upi * .125]
  set textX1 [expr $left + ($upi * .25 * $dx)]
  set textY1 [expr $top + ($upi * .375 * $dy)]
  set textY2 [expr $textY1 + ($upi * .125 * $dy)]
  printer drawtextinbbox $textX1 $textY1 $textX2 $textY2 "[$Record title]"
  set textY1 $textY2
  set textY2 [expr $textY1 + ($upi * .125 * $dy)]
  printer drawtextinbbox $textX1 $textY1 $textX2 $textY2 "[$Record author]"
  set textX1 [expr $left + ($upi * .125 * $dx)]
  set textY1 $textY2
  set textY2 [expr $bottom - ($upi / 16 * $dy)]
  printer drawtextinbbox $textX1 $textY1 $textX2 $textY2 "[$Record description]"
  printer closepage
}
