#* 
#* ------------------------------------------------------------------
#* Home Libarian 1.1 by Deepwoods Software
#* ------------------------------------------------------------------
#* HL20_searchFrame.tcl - Search mode
#* Created by Robert Heller on Sat Sep  6 10:15:13 1997
#* ------------------------------------------------------------------
#* Modification History: 
#* $Log: HL20_searchFrame.tcl,v $
#* Revision 2.6  1999/02/23 13:27:59  heller
#* Fixes to deal with 'odd' file names (spaces, etc.)
#*
#* Revision 2.5  1998/05/17 21:14:18  heller
#* Add in indexing
#*
#* Revision 2.4  1998/04/21 18:38:33  heller
#* Final Release...
#*
#* Revision 2.3  1998/02/15 18:40:54  heller
#* Minor updates (printer interface).
#*
#* Revision 2.2  1997/09/07 00:44:10  heller
#* Make chapter names even shorter.
#*
#* Revision 2.1  1997/09/06 23:42:04  heller
#* Fix chapter name.
#*
#* Revision 2.0  1997/09/06 14:53:06  heller
#* *** empty log message ***
#*
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Home Librarian Database -- a program for maintaining a database
#*                                for a home library
#*     Copyright (C) 1991-1997  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

#@Chapter: HL20\_searchFrame.tcl -- search mode.
#@Label: HL20searchFrame.tcl
#$Id: HL20_searchFrame.tcl,v 2.6 1999/02/23 13:27:59 heller Rel $

global SearchBy
# Search by radio button variable
# [index] SearchBy!global variable

set SearchBy {Author}

global KeysAre
# Current type of keys in the list box.
# [index] KeysAre!global variable

set KeysAre {}

proc searchFrame {} {
  # Put up the search frame GUI.
  #
  # This GUI is in several parts:
  # <Search RadioBox> -- this section selects the search mode (Author, Title, 
  # or Subject) and inputs the search prefix.
  # <Result List> -- this section displays the search results.  It includes 
  # buttons to get more information on a selected result item or to add the
  # item to the notepad area.
  # <Note Pad> -- this is a general purpose text area for taking notes.
  # <Buttons> -- this section contains some buttons for general operations,
  # such as closing the library and printing the notepad.
  # [index] searchFrame!procedure

  global help_tips

  # build widget .mainFrame.searchFrame
  frame .mainFrame.searchFrame \
    -borderwidth {2} \
    -height {296} \
    -relief {raised} \
    -width {496}

  # build widget .mainFrame.searchFrame.serb
  frame .mainFrame.searchFrame.serb \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .mainFrame.searchFrame.serb.seb
  frame .mainFrame.searchFrame.serb.seb

  # build widget .mainFrame.searchFrame.serb.seb.search
  button .mainFrame.searchFrame.serb.seb.search \
    -padx {9} \
    -pady {3} \
    -text {Search For:} \
    -command {
	.mainFrame.searchFrame.results.lbbuttons.add configure -state disabled
	.mainFrame.searchFrame.results.lbbuttons.more configure -state disabled
	.mainFrame.searchFrame.results.frame0.frame3.listbox8 delete 0 end
	SearchForCards "[.mainFrame.searchFrame.serb.seb.searchString get]" \
			.mainFrame.searchFrame.results.frame0.frame3.listbox8
    }
  set help_tips(.mainFrame.searchFrame.serb.seb.search) \
	{Start a search of the library}

  # build widget .mainFrame.searchFrame.serb.seb.searchString
  entry .mainFrame.searchFrame.serb.seb.searchString \
  	-exportselection 0
  bind .mainFrame.searchFrame.serb.seb.searchString <Return> {
     .mainFrame.searchFrame.serb.seb.search invoke
  }
  set help_tips(.mainFrame.searchFrame.serb.seb.searchString) \
  	{This is the search string prefix to use}
  enable_balloon .mainFrame.searchFrame.serb.seb.searchString

  # build widget .mainFrame.searchFrame.serb.radio
  frame .mainFrame.searchFrame.serb.radio

  # build widget .mainFrame.searchFrame.serb.radio.label33
  label .mainFrame.searchFrame.serb.radio.label33 \
    -text {Search By:}

  # build widget .mainFrame.searchFrame.serb.radio.a
  radiobutton .mainFrame.searchFrame.serb.radio.a \
    -text {Author} \
    -value {Author} \
    -variable {SearchBy}
  set help_tips(.mainFrame.searchFrame.serb.radio.a) \
  	{Select search by Author}

  # build widget .mainFrame.searchFrame.serb.radio.t
  radiobutton .mainFrame.searchFrame.serb.radio.t \
    -text {Title} \
    -value {Title} \
    -variable {SearchBy}
  set help_tips(.mainFrame.searchFrame.serb.radio.t) \
	{Select search by Title}

  # build widget .mainFrame.searchFrame.serb.radio.s
  radiobutton .mainFrame.searchFrame.serb.radio.s \
    -text {Subject} \
    -value {Subject} \
    -variable {SearchBy}
  set help_tips(.mainFrame.searchFrame.serb.radio.s) \
	{Select search by Subject}

  # build widget .mainFrame.searchFrame.results
  frame .mainFrame.searchFrame.results \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .mainFrame.searchFrame.results.frame0
  frame .mainFrame.searchFrame.results.frame0 \
    -borderwidth {2}

  # build widget .mainFrame.searchFrame.results.frame0.frame3
  frame .mainFrame.searchFrame.results.frame0.frame3 \
    -borderwidth {2}

  # build widget .mainFrame.searchFrame.results.frame0.frame3.listbox8
  listbox .mainFrame.searchFrame.results.frame0.frame3.listbox8 \
    -height {2} \
    -width {10} \
    -font {-*-courier-bold-r-normal-*-*-120-*-*-*-*-*-*} \
    -selectmode single \
    -exportselection 0 \
    -yscrollcommand {.mainFrame.searchFrame.results.frame0.frame4.scrollbar9 set}
  bind .mainFrame.searchFrame.results.frame0.frame3.listbox8 <1> {
	.mainFrame.searchFrame.results.lbbuttons.add configure -state normal
	.mainFrame.searchFrame.results.lbbuttons.more configure -state normal
  }
  bind .mainFrame.searchFrame.results.frame0.frame3.listbox8 <Double-1> {
  	if [winfo exists %W] {
	  tkListboxBeginSelect %W [%W index @%x,%y]
	}
	.mainFrame.searchFrame.results.lbbuttons.add configure -state normal
	.mainFrame.searchFrame.results.lbbuttons.more configure -state normal
	.mainFrame.searchFrame.results.lbbuttons.add invoke
  }
  set help_tips(.mainFrame.searchFrame.results.frame0.frame3.listbox8) \
	{Listing of the search results}
  enable_balloon .mainFrame.searchFrame.results.frame0.frame3.listbox8

  # build widget .mainFrame.searchFrame.results.frame0.frame4
  frame .mainFrame.searchFrame.results.frame0.frame4 \
    -borderwidth {2}

  # build widget .mainFrame.searchFrame.results.frame0.frame4.scrollbar9
  scrollbar .mainFrame.searchFrame.results.frame0.frame4.scrollbar9 \
    -command {.mainFrame.searchFrame.results.frame0.frame3.listbox8 yview} \
    -width {13}

  # build widget .mainFrame.searchFrame.results.lbbuttons
  frame .mainFrame.searchFrame.results.lbbuttons \
    -borderwidth {2}

  # build widget .mainFrame.searchFrame.results.lbbuttons.add
  button .mainFrame.searchFrame.results.lbbuttons.add \
    -padx {9} \
    -pady {3} \
    -text {Add To Notepad} \
    -state disabled \
    -command {
	AddToNotePad .mainFrame.searchFrame.results.frame0.frame3.listbox8 \
		     .mainFrame.searchFrame.notepad.frame.text2
    }
  set help_tips(.mainFrame.searchFrame.results.lbbuttons.add) \
	{Add the currently selected list entry to the note pad text area}

  # build widget .mainFrame.searchFrame.results.lbbuttons.more
  button .mainFrame.searchFrame.results.lbbuttons.more \
    -padx {9} \
    -pady {3} \
    -text {Display More Information} \
    -state disabled \
    -command {
	DisplayMoreInfo .mainFrame.searchFrame.results.frame0.frame3.listbox8 \
		        .mainFrame.searchFrame.notepad.frame.text2
    }
  set help_tips(.mainFrame.searchFrame.results.lbbuttons.more) \
	{Get more detailed information about the currently selected entry}

  # build widget .mainFrame.searchFrame.notepad
  frame .mainFrame.searchFrame.notepad \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .mainFrame.searchFrame.notepad.frame
  frame .mainFrame.searchFrame.notepad.frame \
    -relief {raised}

  # build widget .mainFrame.searchFrame.notepad.frame.scrollbar1
  scrollbar .mainFrame.searchFrame.notepad.frame.scrollbar1 \
    -command {.mainFrame.searchFrame.notepad.frame.text2 yview} \
    -relief {raised}

  # build widget .mainFrame.searchFrame.notepad.frame.text2
  text .mainFrame.searchFrame.notepad.frame.text2 \
    -height {5} \
    -relief {raised} \
    -wrap {none} \
    -exportselection 0 \
    -yscrollcommand {.mainFrame.searchFrame.notepad.frame.scrollbar1 set}
  set help_tips(.mainFrame.searchFrame.notepad.frame.text2) \
  	{General note pad -- you can make notes here or add entries}
  enable_balloon .mainFrame.searchFrame.notepad.frame.text2

  # build widget .mainFrame.searchFrame.buttons
  frame .mainFrame.searchFrame.buttons \
    -borderwidth {2}

  # build widget .mainFrame.searchFrame.buttons.close
  button .mainFrame.searchFrame.buttons.close \
    -padx {9} \
    -pady {3} \
    -text {Close} \
    -command {CloseCurrentLibrary}
  set help_tips(.mainFrame.searchFrame.buttons.close) {Close the library file}

  # build widget .mainFrame.searchFrame.buttons.prNote
  button .mainFrame.searchFrame.buttons.prNote \
    -padx {9} \
    -pady {3} \
    -text {Print Notes} \
    -command {
	PrintNotes .mainFrame.searchFrame.notepad.frame.text2
    }
  set help_tips(.mainFrame.searchFrame.buttons.prNote) \
	{Print the contents of the notes area or save it to a file}

  # build widget .mainFrame.searchFrame.buttons.clear
  button .mainFrame.searchFrame.buttons.clear \
    -padx {9} \
    -pady {3} \
    -text {Clear Notes} \
    -command {.mainFrame.searchFrame.notepad.frame.text2 delete 1.0 end}
  set help_tips(.mainFrame.searchFrame.buttons.clear) \
	{Clear the contents of the notes area}

  # build widget .mainFrame.searchFrame.buttons.help
  button .mainFrame.searchFrame.buttons.help \
    -padx {9} \
    -pady {3} \
    -text {Help} \
    -command {hl_Help {Searching a Card Catalog database}}
  set help_tips(.mainFrame.searchFrame.buttons.help) {Popup detailed help}

  # pack master .mainFrame.searchFrame.serb
  pack configure .mainFrame.searchFrame.serb.seb \
    -fill x
  pack configure .mainFrame.searchFrame.serb.radio \
    -fill x

  # pack master .mainFrame.searchFrame.serb.seb
  pack configure .mainFrame.searchFrame.serb.seb.search \
    -side left
  pack configure .mainFrame.searchFrame.serb.seb.searchString \
    -expand 1 \
    -fill x \
    -side right

  # pack master .mainFrame.searchFrame.serb.radio
  pack configure .mainFrame.searchFrame.serb.radio.label33 \
    -side left
  pack configure .mainFrame.searchFrame.serb.radio.a \
    -expand 1 \
    -side left
  pack configure .mainFrame.searchFrame.serb.radio.t \
    -side left
  pack configure .mainFrame.searchFrame.serb.radio.s \
    -expand 1 \
    -side right

  # pack master .mainFrame.searchFrame.results
  pack configure .mainFrame.searchFrame.results.frame0 \
    -expand 1 \
    -fill both
  pack configure .mainFrame.searchFrame.results.lbbuttons \
    -fill x

  # pack master .mainFrame.searchFrame.results.frame0
  pack configure .mainFrame.searchFrame.results.frame0.frame3 \
    -expand 1 \
    -fill both \
    -side left
  pack configure .mainFrame.searchFrame.results.frame0.frame4 \
    -fill y \
    -side right

  # pack master .mainFrame.searchFrame.results.frame0.frame3
  pack configure .mainFrame.searchFrame.results.frame0.frame3.listbox8 \
    -expand 1 \
    -fill both \
    -side left

  # pack master .mainFrame.searchFrame.results.frame0.frame4
  pack configure .mainFrame.searchFrame.results.frame0.frame4.scrollbar9 \
    -expand 1 \
    -fill y

  # pack master .mainFrame.searchFrame.results.lbbuttons
  pack configure .mainFrame.searchFrame.results.lbbuttons.add \
    -expand 1 \
    -side left
  pack configure .mainFrame.searchFrame.results.lbbuttons.more \
    -expand 1 \
    -side left

  # pack master .mainFrame.searchFrame.notepad
  pack configure .mainFrame.searchFrame.notepad.frame \
    -expand 1 \
    -fill both

  # pack master .mainFrame.searchFrame.notepad.frame
  pack configure .mainFrame.searchFrame.notepad.frame.scrollbar1 \
    -fill y \
    -side right
  pack configure .mainFrame.searchFrame.notepad.frame.text2 \
    -expand 1 \
    -fill both

  # pack master .mainFrame.searchFrame.buttons
  pack configure .mainFrame.searchFrame.buttons.close \
    -expand 1 \
    -side left
  pack configure .mainFrame.searchFrame.buttons.prNote \
    -expand 1 \
    -side left
  pack configure .mainFrame.searchFrame.buttons.clear \
    -expand 1 \
    -side left
  pack configure .mainFrame.searchFrame.buttons.help \
    -expand 1 \
    -side right

  # pack master .mainFrame.searchFrame
  pack configure .mainFrame.searchFrame.serb \
    -fill x
  pack configure .mainFrame.searchFrame.results \
    -expand 1 \
    -fill both
  pack configure .mainFrame.searchFrame.notepad \
    -expand 1 \
    -fill both
  pack configure .mainFrame.searchFrame.buttons \
    -fill both

  # pack slave .mainFrame.searchFrame
  pack configure .mainFrame.searchFrame \
    -expand 1 \
    -fill both

  .mainFrame.searchFrame.serb.seb.searchString insert end {}
  .mainFrame.searchFrame.notepad.frame.text2 insert end {}

  focus .mainFrame.searchFrame.serb.seb.searchString

# end of widget tree

}

proc PrintNotes {text} {
  # Print Notes dialog.  This proc puts up a dialog to print the note pad.
  #
  # Arguments:
  # <in> text -- this is the text area containing the note pad.
  # [index] PrintNotes!procedure

  global FileOrPrinter
  set FileOrPrinter Printer
  global help_tips

  # build widget .printDialog
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .printDialog"
  } {
    catch "destroy .printDialog"
  }
  toplevel .printDialog 

  # Window manager configurations
  wm maxsize .printDialog 1265 994
  wm minsize .printDialog 1 1
  wm title .printDialog {Print Note Pad}
  wm transient .printDialog .

  label .printDialog.text -text "$text"

  # build widget .printDialog.top
  frame .printDialog.top \
    -borderwidth {2}

  # build widget .printDialog.top.label2
  label .printDialog.top.label2 \
    -image {SmallFace}

  # build widget .printDialog.top.label3
  label .printDialog.top.label3 \
    -background {yellow} \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -foreground {brown} \
    -text {Print Note Pad}

  # build widget .printDialog.fileOrPrinter
  frame .printDialog.fileOrPrinter \
    -borderwidth {2} \
    -relief {groove}

  # build widget .printDialog.fileOrPrinter.radio
  frame .printDialog.fileOrPrinter.radio \
    -borderwidth {2}

  # build widget .printDialog.fileOrPrinter.radio.radiobutton16
  radiobutton .printDialog.fileOrPrinter.radio.radiobutton16 \
    -text {File} \
    -value {File} \
    -variable {FileOrPrinter} \
    -command {
	foreach w [winfo children  .printDialog.fileOrPrinter.fileFrame] {
	   catch "$w configure -state normal"
	}
	foreach w [winfo children .printDialog.fileOrPrinter.printerFrame] {
	   catch "$w configure -state disabled"
	}
	focus .printDialog.fileOrPrinter.fileFrame.filename
    }
  set help_tips(.printDialog.fileOrPrinter.radio.radiobutton16) \
	{Select output to a file}

  # build widget .printDialog.fileOrPrinter.radio.radiobutton17
  radiobutton .printDialog.fileOrPrinter.radio.radiobutton17 \
    -text {Printer} \
    -value {Printer} \
    -variable {FileOrPrinter} \
    -command {
	foreach w [winfo children .printDialog.fileOrPrinter.fileFrame] {
	   catch "$w configure -state disabled"
	}
	foreach w [winfo children .printDialog.fileOrPrinter.printerFrame] {
	    catch "$w configure -state normal"
	}
	focus .printDialog.fileOrPrinter.printerFrame.printer
    }
  set help_tips(.printDialog.fileOrPrinter.radio.radiobutton17) \
	{Select output to a printer}

  # build widget .printDialog.fileOrPrinter.fileFrame
  frame .printDialog.fileOrPrinter.fileFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .printDialog.fileOrPrinter.fileFrame.label4
  label .printDialog.fileOrPrinter.fileFrame.label4 \
    -text {Filename:}

  # build widget .printDialog.fileOrPrinter.fileFrame.filename
  entry .printDialog.fileOrPrinter.fileFrame.filename \
    -state disabled \
    -exportselection 0
  set help_tips(.printDialog.fileOrPrinter.fileFrame.filename) \
	{Enter the file to save to here}
  enable_balloon .printDialog.fileOrPrinter.fileFrame.filename

  # build widget .printDialog.fileOrPrinter.fileFrame.button6
  button .printDialog.fileOrPrinter.fileFrame.button6 \
    -padx {11} \
    -pady {4} \
    -text {Browse} \
    -state disabled \
    -command {
	set fname [tk_getSaveFile \
			-defaultextension {.txt}\
			-initialfile "[.printDialog.fileOrPrinter.fileFrame.filename get]" \
			-title "Select a file to save Note pad in" \
			-filetypes {{{Text Files} {.txt} {TEXT}}}]
	if {[string length "$fname"] > 0} {
	   .printDialog.fileOrPrinter.fileFrame.filename delete 0 end
	   .printDialog.fileOrPrinter.fileFrame.filename insert 0 "$fname"
	}
    }
  set help_tips(.printDialog.fileOrPrinter.fileFrame.button6) \
	{Browse for an output file}

  # build widget .printDialog.fileOrPrinter.printerFrame
  frame .printDialog.fileOrPrinter.printerFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .printDialog.fileOrPrinter.printerFrame.label19
  label .printDialog.fileOrPrinter.printerFrame.label19 \
    -text {Print Command (text printer):}

  # build widget .printDialog.fileOrPrinter.printerFrame.printer
  entry .printDialog.fileOrPrinter.printerFrame.printer \
  	-exportselection 0
  set help_tips(.printDialog.fileOrPrinter.printerFrame.printer) \
	{Enter the print command here}
  enable_balloon .printDialog.fileOrPrinter.printerFrame.printer

  # build widget .printDialog.buttons
  frame .printDialog.buttons \
    -borderwidth {2}

  # build widget .printDialog.buttons.button31
  button .printDialog.buttons.button31 \
    -padx {11} \
    -pady {4} \
    -text {OK} \
    -command {
  global FileOrPrinter
  set text "[.printDialog.text cget -text]"
  if {[string compare "$FileOrPrinter" {File}] == 0} {
    set fname "[.printDialog.fileOrPrinter.fileFrame.filename get]"
    if {[catch [list open "$fname" w] fp]} {
      hl_error "error opening $fname: $fp"
      return
    }
  } elseif {[string compare "$FileOrPrinter" {Printer}] == 0} {
    global tcl_platform
    if {"$tcl_platform(platform)" == {unix}} {
      set printer "[.printDialog.fileOrPrinter.printerFrame.printer get]"
      set fname "|$printer"
      if {[catch [list open "$fname" w] fp]} {
        hl_error "error opening pipe to $printer: $fp"
        return
      }
    } else {
      set fname "[printer maketempfilename]"
      if {[catch [list open "$fname" w] fp]} {
	hl_error "error opening temporary file ($fname): $fp"
	return
      }
    }
  }
  set textBuffer "[$text get 1.0 end-1c]"
  puts $fp "$textBuffer"
  close $fp
  if {"$tcl_platform(platform)" != {unix} && "$FileOrPrinter" == {Printer}} {
    printer spoolplaintextfile "$fname"
    catch [list file delete "$fname"]
  }
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .printDialog"
  } {
    catch "destroy .printDialog"
  }
    }
  set help_tips(.printDialog.buttons.button31) \
	{Initiate the print or file save operation}

  # build widget .printDialog.buttons.button32
  button .printDialog.buttons.button32 \
    -padx {11} \
    -pady {4} \
    -text {Cancel} \
    -command {
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .printDialog"
  } {
    catch "destroy .printDialog"
  }
    }
  set help_tips(.printDialog.buttons.button2) \
	{Cancel the print or file save operation}

  # build widget .printDialog.buttons.button33
  button .printDialog.buttons.button33 \
    -padx {11} \
    -pady {4} \
    -text {Help} \
    -command {hl_Help {Print Notes dialog}}
  set help_tips(.printDialog.buttons.button33) \
	{Get detailed help}

  # pack master .printDialog.top
  pack configure .printDialog.top.label2 \
    -fill y \
    -side left
  pack configure .printDialog.top.label3 \
    -fill x \
    -side right \
    -expand 1

  # pack master .printDialog.fileOrPrinter
  pack configure .printDialog.fileOrPrinter.radio \
    -fill x
  pack configure .printDialog.fileOrPrinter.fileFrame \
    -fill x
  global tcl_platform
  if {"$tcl_platform(platform)" == {unix}} {
  pack configure .printDialog.fileOrPrinter.printerFrame \
    -fill x
  }
  

  # pack master .printDialog.fileOrPrinter.radio
  pack configure .printDialog.fileOrPrinter.radio.radiobutton16 \
    -expand 1 \
    -side left
  pack configure .printDialog.fileOrPrinter.radio.radiobutton17 \
    -expand 1 \
    -side right

  # pack master .printDialog.fileOrPrinter.fileFrame
  pack configure .printDialog.fileOrPrinter.fileFrame.label4 \
    -side left
  pack configure .printDialog.fileOrPrinter.fileFrame.filename \
    -expand 1 \
    -fill x \
    -side left
  pack configure .printDialog.fileOrPrinter.fileFrame.button6 \
    -side right

  # pack master .printDialog.fileOrPrinter.printerFrame
  pack configure .printDialog.fileOrPrinter.printerFrame.label19 \
    -side left
  pack configure .printDialog.fileOrPrinter.printerFrame.printer \
    -expand 1 \
    -fill x \
    -side right

  # pack master .printDialog.buttons
  pack configure .printDialog.buttons.button31 \
    -expand 1 \
    -side left
  pack configure .printDialog.buttons.button32 \
    -expand 1 \
    -side left
  pack configure .printDialog.buttons.button33 \
    -expand 1 \
    -side right

  # pack master .printDialog
  pack configure .printDialog.top -fill x
  pack configure .printDialog.fileOrPrinter \
    -fill x
  pack configure .printDialog.buttons \
    -fill both

  .printDialog.fileOrPrinter.fileFrame.filename insert end {notepad.txt}
  .printDialog.fileOrPrinter.printerFrame.printer insert end {lpr -}

# end of widget tree
  wm withdraw .printDialog
  update idletasks
  set x [expr [winfo screenwidth .printDialog]/2 - \
	      [winfo reqwidth .printDialog]/2 - \
	      [winfo vrootx .]]
  set y [expr [winfo screenheight .printDialog]/2 - \
	      [winfo reqheight .printDialog]/2 - \
	      [winfo vrooty .]]
  wm geom .printDialog +$x+$y
  wm deiconify .printDialog

  update idletasks
  grab .printDialog
  tkwait window .printDialog

}

proc PrintCard {toplevel} {
  # Print A card.  This proc puts up a dialog box to print a card popup.
  #
  # Arguments:
  # <in> toplevel -- the name of the toplevel containing the card.
  # [index] PrintCard!procedure

  global help_tips
  global FileOrPrinter
  set FileOrPrinter Printer

# .printDialog
# The above line makes pasting MUCH easier for me.
# It contains the pathname of the cutted widget.
# Tcl version: 7.6 (Tcl/Tk/XF)
# Tk version: 4.2
# XF version: 4.0
#

  # build widget .printDialog
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .printDialog"
  } {
    catch "destroy .printDialog"
  }
  toplevel .printDialog 

  # Window manager configurations
  wm maxsize .printDialog 1265 994
  wm minsize .printDialog 1 1
  wm title .printDialog {Print A Card}
  wm transient .printDialog .

  label .printDialog.text -text "$toplevel"

  # build widget .printDialog.top
  frame .printDialog.top \
    -borderwidth {2}

  # build widget .printDialog.top.label2
  label .printDialog.top.label2 \
    -image {SmallFace}

  # build widget .printDialog.top.label3
  label .printDialog.top.label3 \
    -background {yellow} \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -foreground {brown} \
    -text {Print A Card}

  # build widget .printDialog.fileOrPrinter
  frame .printDialog.fileOrPrinter \
    -borderwidth {2} \
    -relief {groove}

  # build widget .printDialog.fileOrPrinter.radio
  frame .printDialog.fileOrPrinter.radio \
    -borderwidth {2}

  # build widget .printDialog.fileOrPrinter.radio.radiobutton16
  radiobutton .printDialog.fileOrPrinter.radio.radiobutton16 \
    -text {File} \
    -value {File} \
    -variable {FileOrPrinter} \
    -command {
	foreach w [winfo children  .printDialog.fileOrPrinter.fileFrame] {
	   catch "$w configure -state normal"
	}
	foreach w [winfo children .printDialog.fileOrPrinter.printerFrame] {
	   catch "$w configure -state disabled"
	}
	focus .printDialog.fileOrPrinter.fileFrame.filename
    }
  set help_tips(.printDialog.fileOrPrinter.radio.radiobutton16) \
	{Select output to a file}

  # build widget .printDialog.fileOrPrinter.radio.radiobutton17
  radiobutton .printDialog.fileOrPrinter.radio.radiobutton17 \
    -text {Printer} \
    -value {Printer} \
    -variable {FileOrPrinter} \
    -command {
	foreach w [winfo children .printDialog.fileOrPrinter.fileFrame] {
	   catch "$w configure -state disabled"
	}
	foreach w [winfo children .printDialog.fileOrPrinter.printerFrame] {
	    catch "$w configure -state normal"
	}
	focus .printDialog.fileOrPrinter.printerFrame.printer
    }
  set help_tips(.printDialog.fileOrPrinter.radio.radiobutton17) \
	{Select output to a printer}

  # build widget .printDialog.fileOrPrinter.fileFrame
  frame .printDialog.fileOrPrinter.fileFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .printDialog.fileOrPrinter.fileFrame.label4
  label .printDialog.fileOrPrinter.fileFrame.label4 \
    -text {Filename:}

  # build widget .printDialog.fileOrPrinter.fileFrame.filename
  entry .printDialog.fileOrPrinter.fileFrame.filename \
    -state disabled \
    -exportselection 0
  set help_tips(.printDialog.fileOrPrinter.fileFrame.filename) \
	{Enter the file to save to here}
  enable_balloon .printDialog.fileOrPrinter.fileFrame.filename

  # build widget .printDialog.fileOrPrinter.fileFrame.button6
  button .printDialog.fileOrPrinter.fileFrame.button6 \
    -padx {11} \
    -pady {4} \
    -text {Browse} \
    -state disabled \
    -command {
	set fname [tk_getSaveFile \
			-defaultextension {.txt}\
			-initialfile "[.printDialog.fileOrPrinter.fileFrame.filename get]" \
			-title "Select a file to save Note pad in" \
			-filetypes {{{Text Files} {.txt} {TEXT}}}]
	if {[string length "$fname"] > 0} {
	   .printDialog.fileOrPrinter.fileFrame.filename delete 0 end
	   .printDialog.fileOrPrinter.fileFrame.filename insert 0 "$fname"
	}
    }
  set help_tips(.printDialog.fileOrPrinter.fileFrame.button6) \
	{Browse for an output file}


  # build widget .printDialog.fileOrPrinter.printerFrame
  frame .printDialog.fileOrPrinter.printerFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .printDialog.fileOrPrinter.printerFrame.label19
  label .printDialog.fileOrPrinter.printerFrame.label19 \
    -text {Print Command (text printer):}

  # build widget .printDialog.fileOrPrinter.printerFrame.printer
  entry .printDialog.fileOrPrinter.printerFrame.printer \
  	-exportselection 0
  set help_tips(.printDialog.fileOrPrinter.printerFrame.printer) \
	{Enter the print command here}
  enable_balloon .printDialog.fileOrPrinter.printerFrame.printer

  # build widget .printDialog.buttons
  frame .printDialog.buttons \
    -borderwidth {2}

  # build widget .printDialog.buttons.button31
  button .printDialog.buttons.button31 \
    -padx {11} \
    -pady {4} \
    -text {OK} \
    -command {
  global FileOrPrinter
  set toplevel "[.printDialog.text cget -text]"
  if {[string compare "$FileOrPrinter" {File}] == 0} {
    set fname "[.printDialog.fileOrPrinter.fileFrame.filename get]"
    if {[catch [list open "$fname" w] fp]} {
      hl_error "error opening $fname: $fp"
      return
    }
  } elseif {[string compare "$FileOrPrinter" {Printer}] == 0} {
    if {"$tcl_platform(platform)" == {unix}} {
      set printer "[.printDialog.fileOrPrinter.printerFrame.printer get]"
      set fname "|$printer"
      if {[catch [list open "$fname" w] fp]} {
        hl_error "error opening pipe to $printer: $fp"
        return
      }
    } else {
      set fname "[printer maketempfilename]"
      if {[catch [list open "$fname" w] fp]} {
	hl_error "error opening temporary file ($fname): $fp"
	return
      }
    }
  }

  puts $fp "[$toplevel.idFrame.label14 cget -text] [$toplevel.idFrame.id cget -text]"
  puts $fp "[$toplevel.titleFrame.label16 cget -text] [$toplevel.titleFrame.title cget -text]"
  puts $fp "[$toplevel.authorFrame.label18 cget -text] [$toplevel.authorFrame.author cget -text]"
  puts $fp "[$toplevel.typeFrame.label20 cget -text] [$toplevel.typeFrame.type cget -text]"
  puts -nonewline $fp "[$toplevel.publisherFrame.label22 cget -text] [$toplevel.publisherFrame.publisher cget -text]"
  puts -nonewline $fp " [$toplevel.publisherFrame.label24 cget -text] [$toplevel.publisherFrame.city cget -text]"
  puts $fp " [$toplevel.publisherFrame.label26 cget -text] [$toplevel.publisherFrame.year cget -text]"
  puts -nonewline $fp "[$toplevel.volumeCatFrame.label28 cget -text] [$toplevel.volumeCatFrame.volume cget -text]"
  puts $fp " [$toplevel.volumeCatFrame.label30 cget -text] [$toplevel.volumeCatFrame.lcategory cget -text]"
  puts $fp "[$toplevel.frame.text2 get 1.0 end-1c]"
  puts $fp "[$toplevel.locationFrame.label32 cget -text] [$toplevel.locationFrame.location cget -text]"

  close $fp
  if {"$tcl_platform(platform)" != {unix} && "$FileOrPrinter" == {Printer}} {
    printer spoolplaintextfile "$fname"
    catch [list file delete "$fname"]
  }
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .printDialog"
  } {
    catch "destroy .printDialog"
  }
    }
  set help_tips(.printDialog.buttons.button31) \
	{Initiate the print or file save operation}

  # build widget .printDialog.buttons.button32
  button .printDialog.buttons.button32 \
    -padx {11} \
    -pady {4} \
    -text {Cancel} \
    -command {
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .printDialog"
  } {
    catch "destroy .printDialog"
  }
    }
  set help_tips(.printDialog.buttons.button2) \
	{Cancel the print or file save operation}

  # build widget .printDialog.buttons.button33
  button .printDialog.buttons.button33 \
    -padx {11} \
    -pady {4} \
    -text {Help} \
    -command {hl_Help {Print Card dialog}}
  set help_tips(.printDialog.buttons.button33) \
	{Get detailed help}

  # pack master .printDialog.top
  pack configure .printDialog.top.label2 \
    -fill y \
    -side left
  pack configure .printDialog.top.label3 \
    -fill x \
    -side right \
    -expand 1

  # pack master .printDialog.fileOrPrinter
  pack configure .printDialog.fileOrPrinter.radio \
    -fill x
  pack configure .printDialog.fileOrPrinter.fileFrame \
    -fill x
  global tcl_platform
  if {"$tcl_platform(platform)" == {unix}} {
  pack configure .printDialog.fileOrPrinter.printerFrame \
    -fill x
  }

  # pack master .printDialog.fileOrPrinter.radio
  pack configure .printDialog.fileOrPrinter.radio.radiobutton16 \
    -expand 1 \
    -side left
  pack configure .printDialog.fileOrPrinter.radio.radiobutton17 \
    -expand 1 \
    -side right

  # pack master .printDialog.fileOrPrinter.fileFrame
  pack configure .printDialog.fileOrPrinter.fileFrame.label4 \
    -side left
  pack configure .printDialog.fileOrPrinter.fileFrame.filename \
    -expand 1 \
    -fill x \
    -side left
  pack configure .printDialog.fileOrPrinter.fileFrame.button6 \
    -side right

  # pack master .printDialog.fileOrPrinter.printerFrame
  pack configure .printDialog.fileOrPrinter.printerFrame.label19 \
    -side left
  pack configure .printDialog.fileOrPrinter.printerFrame.printer \
    -expand 1 \
    -fill x \
    -side right

  # pack master .printDialog.buttons
  pack configure .printDialog.buttons.button31 \
    -expand 1 \
    -side left
  pack configure .printDialog.buttons.button32 \
    -expand 1 \
    -side left
  pack configure .printDialog.buttons.button33 \
    -expand 1 \
    -side right

  # pack master .printDialog
  pack configure .printDialog.top -fill x
  pack configure .printDialog.fileOrPrinter \
    -fill x
  pack configure .printDialog.buttons \
    -fill both

  .printDialog.fileOrPrinter.fileFrame.filename insert end {notepad.txt}
  .printDialog.fileOrPrinter.printerFrame.printer insert end {lpr -}

# end of widget tree

  wm withdraw .printDialog
  update idletasks
  set x [expr [winfo screenwidth .printDialog]/2 - \
	      [winfo reqwidth .printDialog]/2 - \
	      [winfo vrootx .]]
  set y [expr [winfo screenheight .printDialog]/2 - \
	      [winfo reqheight .printDialog]/2 - \
	      [winfo vrooty .]]
  wm geom .printDialog +$x+$y
  wm deiconify .printDialog
  update idletasks
  grab .printDialog
  tkwait window .printDialog

}

proc SearchForCards {string list} {
  # Search for cards.  Search the catalog (using the global SearchBy to select
  # which index) for keys with a prefix of string.  Put the results in the
  # listbox named by list.
  #
  # Arguments:
  # <in> string -- the search string prefix
  # <in> list -- the listbox to put the results.
  # <global> SearchBy -- the library index to search
  # [index] SearchForCards!procedure

  global CurrentCardCatalog
  global SearchBy
  global KeysAre
  global Work
  set message {}
  if {[string compare "$CurrentCardCatalog" {}] == 0} {return}
  StartWorking
  switch -exact $SearchBy {
    Author {
	if {[string length "$string"] == 0} {
	  set resultList "[$CurrentCardCatalog searchauthors]"
	} else {
	  set resultList "[$CurrentCardCatalog searchauthors $string]"
	}
	set KeysAre Author
	set nMatches [llength "$resultList"]
 	if {$nMatches == 0} {
	  set message "Found no matches\nfor \"$string\""
	} elseif {$nMatches < 5} {
	  set resultList "[ExpandAuthors $resultList]"
	  set nMatches [llength "$resultList"]
	  set KeysAre Id
	  set message "Found $nMatches match"
	  if {$nMatches > 1} {append message "es"}
	  append message "\nfor \"$string\""
	} else {
	  set message "Found $nMatches match"
	  if {$nMatches > 1} {append message "es"}
	  append message "\nfor \"$string\""
	}
	if {"$KeysAre" == {Id}} {
	  foreach a $resultList {
	    $list insert end "[format "%-36s %s %s" [lindex $a 0] [lindex $a 1] [lindex $a 2]]"
	  }
	} else {
	  foreach a $resultList {
	    $list insert end "$a"
	  }
	}
      }
    Title {
	if {[string length "$string"] == 0} {
	  set resultList "[$CurrentCardCatalog searchtitles]"
	} else {
	  set resultList "[$CurrentCardCatalog searchtitles $string]"
	}
	set KeysAre Title
 	set nMatches [llength "$resultList"]
 	if {$nMatches == 0} {
	  set message "Found no matches\nfor \"$string\""
	} elseif {$nMatches < 5} {
	  set resultList "[ExpandTitles $resultList]"
	  set nMatches [llength "$resultList"]
	  set KeysAre Id
	  set message "Found $nMatches match"
	  if {$nMatches > 1} {append message "es"}
	  append message "\nfor \"$string\""
	} else {
	  set message "Found $nMatches match"
	  if {$nMatches > 1} {append message "es"}
	  append message "\nfor \"$string\""
	}
	if {"$KeysAre" == {Id}} {
	  foreach a $resultList {
	    $list insert end "[format "%-36s %s %s" [lindex $a 0] [lindex $a 1] [lindex $a 2]]"
	  }
	} else {
	  foreach a $resultList {
	    $list insert end "$a"
	  }
	}
      }
    Subject {
	if {[string length "$string"] == 0} {
	  set resultList "[$CurrentCardCatalog searchsubjects]"
	} else {
	  set resultList "[$CurrentCardCatalog searchsubjects $string]"
	}
	set KeysAre Subject
	set nMatches [llength "$resultList"]
 	if {$nMatches == 0} {
	  set message "Found no matches\nfor \"$string\""
	} elseif {$nMatches < 5} {
	  set resultList "[ExpandSubjects $resultList]"
	  set nMatches [llength "$resultList"]
	  set KeysAre Id
	  set message "Found $nMatches match"
	  if {$nMatches > 1} {append message "es"}
	  append message "\nfor \"$string\""
	} else {
	  set message "Found $nMatches match"
	  if {$nMatches > 1} {append message "es"}
	  append message "\nfor \"$string\""
	}
	if {"$KeysAre" == {Id}} {
	  foreach a $resultList {
	    $list insert end "[format "%-36s %s %s" [lindex $a 0] [lindex $a 1] [lindex $a 2]]"
	  }
	} else {
	  foreach a $resultList {
	    $list insert end "$a"
	  }
	}
      }
    default {}
  }
  if {[string compare "$KeysAre" {Id}] != 0} {
    EndWorking "$message ($KeysAre)"
  } else {
    EndWorking "$message"
  }
}

proc AddToNotePad {lb text} {
  # Add the currently selected item in the listbox to the notepad.
  #
  # Arguments:
  # <in> lb -- the listbox
  # <in> text -- the text area to add to.
  # [index] AddToNotePad!procedure

  set cs "[$lb curselection]"
  if {[llength "$cs"] < 1} {return}
  set item "[$lb get $cs]"
  $text insert end "$item\n"
}

proc DisplayCard {lb text} {
  # Display the currently selected card.
  #
  # Arguments:
  # <in> lb -- the listbox
  # <in> text -- the notepad text area.
  # [index] DisplayCard!procedure

  set cs "[$lb curselection]"
  if {[llength "$cs"] < 1} {return}
  set item "[$lb get $cs]"
  PopupCard "$item" $text
}

proc DisplayMoreInfo {lb text} {
  # Display more info about a selected item.
  #
  # Arguments:
  # <in> lb -- the listbox
  # <in> text -- the notepad text area.
  # [index] DisplayMoreInfo!procedure

  global KeysAre
  set cs "[$lb curselection]"
  if {[llength "$cs"] < 1} {return}
  set item "[$lb get $cs]"
  switch -exact $KeysAre {
    Author {
      PopupAuthorList "$item" $text
    }
    Title  {
      PopupTitleList "$item" $text
    }
    Subject {
      PopupSubjectList "$item" $text
    }
    Id {
      PopupCard "$item" $text
    }
    default {}
  }
}

proc PopupAuthorList {author text} {
  # Popup an author list
  #
  # Arguments:
  # <in> author -- the selected author key.
  # <in> text -- the notepad text area.
  # [index] PopupAuthorList!procedure

  GenericListPopup $text "Items for $author" [ExpandAuthors [list $author]]
}

proc PopupTitleList {title text} {
  # Popup a title list
  #
  # Arguments:
  # <in> title -- the selected title key.
  # <in> text -- the notepad text area.
  # [index] PopupTitleList!procedure

  GenericListPopup $text "Items for $title" [ExpandTitles [list $title]]
}

proc PopupSubjectList {subject text} {
  # Popup a subject list
  #
  # Arguments:
  # <in> subject -- the selected subject key.
  # <in> text -- the notepad text area.
  # [index] PopupSubjectList!procedure

  GenericListPopup $text "Items for $subject" [ExpandSubjects [list $subject]]
}

proc GenericListPopup {text title itemList} {
  # Generic list popup -- pop up a generic list, expanded from an author, a
  # title, or a subject.
  #
  # Arguments:
  # <in> text -- the notepad text area.
  # <in> title -- the popup's title.
  # <in> itemList -- the list of items to display
  # [index] GenericListPopup!procedure

  global help_tips

  for {set i 1} {[winfo exists .popUpList$i] == 1} {incr i} {}
  set toplevel ".popUpList$i"

  # build widget $toplevel
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy $toplevel"
  } {
    catch "destroy $toplevel"
  }
  toplevel $toplevel 

  # Window manager configurations
  wm maxsize $toplevel 1009 738
  wm minsize $toplevel 1 1
  wm title $toplevel "$title"
  AddTopLevel $toplevel
  wm protocol $toplevel WM_DELETE_WINDOW "RemoveTopLevel $toplevel"


  # build widget $toplevel.topFrame
  frame $toplevel.topFrame -borderwidth {2} -relief flat

  # build widget $toplevel.topFrame.icon
  label $toplevel.topFrame.icon \
    -image SmallFace -relief flat

  # build widget $toplevel.topFrame.bigLabel
  label $toplevel.topFrame.bigLabel \
    -bg yellow -fg brown \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -text "Expansion of\n$title"

  # build widget $toplevel.frame0
  frame $toplevel.frame0 \
    -borderwidth {2}

  # build widget $toplevel.frame0.frame1
  frame $toplevel.frame0.frame1

  # build widget $toplevel.frame0.frame1.frame3
  frame $toplevel.frame0.frame1.frame3 \
    -borderwidth {2}

  # build widget $toplevel.frame0.frame1.frame3.listbox8
  listbox $toplevel.frame0.frame1.frame3.listbox8 \
    -height {16} \
    -width {60} \
    -selectmode single \
    -exportselection 0 \
    -font {-*-courier-bold-r-normal-*-*-120-*-*-*-*-*-*} \
    -xscrollcommand "$toplevel.frame0.frame2.frame5.scrollbar10 set" \
    -yscrollcommand "$toplevel.frame0.frame1.frame4.scrollbar9 set"
  bind $toplevel.frame0.frame1.frame3.listbox8 <1> \
	"$toplevel.buttons.button2 configure -state normal;\
	 $toplevel.buttons.button2a configure -state normal"
  bind $toplevel.frame0.frame1.frame3.listbox8 <Double-1> \
	"if \{\[winfo exists %W\]\} \{tkListboxBeginSelect %W \[%W index @%x,%y\]\};\
	$toplevel.buttons.button2 configure -state normal;\
	$toplevel.buttons.button2a configure -state normal;\
	$toplevel.buttons.button2 invoke"
  foreach i $itemList {
    $toplevel.frame0.frame1.frame3.listbox8 insert end  \
	"[format "%-36s %s %s" [lindex $i 0] [lindex $i 1] [lindex $i 2]]"
  }
  set help_tips($toplevel.frame0.frame1.frame3.listbox8) \
	"List of items that expand from $title"
  enable_balloon $toplevel.frame0.frame1.frame3.listbox8

  # build widget $toplevel.frame0.frame1.frame4
  frame $toplevel.frame0.frame1.frame4 \
    -borderwidth {2}

  # build widget $toplevel.frame0.frame1.frame4.scrollbar9
  scrollbar $toplevel.frame0.frame1.frame4.scrollbar9 \
    -command "$toplevel.frame0.frame1.frame3.listbox8 yview" \
    -width {13}

  # build widget $toplevel.frame0.frame2
  frame $toplevel.frame0.frame2 \
    -borderwidth {1}

  # build widget $toplevel.frame0.frame2.frame5
  frame $toplevel.frame0.frame2.frame5 \
    -borderwidth {2}

  # build widget $toplevel.frame0.frame2.frame5.scrollbar10
  scrollbar $toplevel.frame0.frame2.frame5.scrollbar10 \
    -command "$toplevel.frame0.frame1.frame3.listbox8 xview" \
    -orient {horizontal} \
    -width {13}

  # build widget $toplevel.frame0.frame2.frame6
  frame $toplevel.frame0.frame2.frame6 \
    -borderwidth {2}

  # build widget $toplevel.frame0.frame2.frame6.frame11
  frame $toplevel.frame0.frame2.frame6.frame11 \
    -borderwidth {2} \
    -height {13} \
    -width {16}

  # build widget $toplevel.buttons
  frame $toplevel.buttons \
    -borderwidth {2}

  # build widget $toplevel.buttons.button2
  button $toplevel.buttons.button2 \
    -padx {9} \
    -pady {3} \
    -text {Add To Note Pad} \
    -state disabled \
    -command  \
	"AddToNotePad $toplevel.frame0.frame1.frame3.listbox8 $text"
  set help_tips($toplevel.buttons.button2) \
	{Add the currently selected list entry to the note pad text area}

  # build widget $toplevel.buttons.button2a
  button $toplevel.buttons.button2a \
    -padx {9} \
    -pady {3} \
    -text {Display More Information} \
    -state disabled \
    -command  \
	"DisplayCard $toplevel.frame0.frame1.frame3.listbox8 $text"
  set help_tips($toplevel.buttons.button2a) \
	{Get more detailed information about the currently selected entry}

  # build widget $toplevel.buttons.button3
  button $toplevel.buttons.button3 \
    -padx {9} \
    -pady {3} \
    -text {Dismis} \
    -command "RemoveTopLevel $toplevel"
  set help_tips($toplevel.buttons.button3) {Dismis this popup}

  # build widget $toplevel.buttons.button4
  button $toplevel.buttons.button4 \
    -padx {9} \
    -pady {3} \
    -text {Help} \
    -command {hl_Help {Generic List dialog}}
  set help_tips($toplevel.buttons.button4) {Get detailed hellp}

  # pack master $toplevel.topFrame
  pack configure $toplevel.topFrame.icon -side left
  pack configure $toplevel.topFrame.bigLabel -side right -expand 1 -fill both

  # pack master $toplevel.frame0
  pack configure $toplevel.frame0.frame1 \
    -expand 1 \
    -fill both
  pack configure $toplevel.frame0.frame2 \
    -fill x \
    -side bottom

  # pack master $toplevel.frame0.frame1
  pack configure $toplevel.frame0.frame1.frame3 \
    -expand 1 \
    -fill both \
    -side left
  pack configure $toplevel.frame0.frame1.frame4 \
    -fill y \
    -side right

  # pack master $toplevel.frame0.frame1.frame3
  pack configure $toplevel.frame0.frame1.frame3.listbox8 \
    -expand 1 \
    -fill both \
    -side left

  # pack master $toplevel.frame0.frame1.frame4
  pack configure $toplevel.frame0.frame1.frame4.scrollbar9 \
    -expand 1 \
    -fill y

  # pack master $toplevel.frame0.frame2
  pack configure $toplevel.frame0.frame2.frame5 \
    -expand 1 \
    -fill both \
    -side left
  pack configure $toplevel.frame0.frame2.frame6 \
    -fill y \
    -side right

  # pack master $toplevel.frame0.frame2.frame5
  pack configure $toplevel.frame0.frame2.frame5.scrollbar10 \
    -expand 1 \
    -fill x \
    -side left

  # pack master $toplevel.frame0.frame2.frame6
  pack configure $toplevel.frame0.frame2.frame6.frame11 \
    -expand 1 \
    -fill both

  # pack master $toplevel.buttons
  pack configure $toplevel.buttons.button2 \
    -expand 1 \
    -side left
  pack configure $toplevel.buttons.button2a \
    -expand 1 \
    -side left
  pack configure $toplevel.buttons.button3 \
    -expand 1 \
    -side left
  pack configure $toplevel.buttons.button4 \
    -expand 1 \
    -side right

  # pack master $toplevel
  pack configure $toplevel.topFrame -fill x
  pack configure $toplevel.frame0 \
    -expand 1 \
    -fill both
  pack configure $toplevel.buttons \
    -fill x
# end of widget tree


}

proc PopupCard {item text} {
  # Popup a card.
  #
  # Arguments:
  # <in> item -- the card's key.
  # <in> text -- the notepad text area.
  # [index] PopupCard!procedure

  global help_tips
  global CurrentCardCatalog
  if {[string length "$CurrentCardCatalog"] == 0} {return}
  set id "[string trim [string range $item 0 35]]"
  set theCard [$CurrentCardCatalog readid "$id"]

  for {set i 1} {[winfo exists .popUpCard$i] == 1} {incr i} {}
  set toplevel ".popUpCard$i"

  # build widget $toplevel
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy $toplevel"
  } {
    catch "destroy $toplevel"
  }
  toplevel $toplevel 

  # Window manager configurations
  wm maxsize $toplevel 1009 738
  wm minsize $toplevel 1 1
  wm title $toplevel "$item"
  AddTopLevel $toplevel
  wm protocol $toplevel WM_DELETE_WINDOW "RemoveTopLevel $toplevel"

  # build widget $toplevel.topFrame
  frame $toplevel.topFrame -borderwidth {2} -relief flat

  # build widget $toplevel.topFrame.icon
  label $toplevel.topFrame.icon \
    -image SmallFace -relief flat

  # build widget $toplevel.topFrame.bigLabel
  label $toplevel.topFrame.bigLabel \
    -bg yellow -fg brown \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -text "Card for\n$item"

  # build widget $toplevel.idFrame
  frame $toplevel.idFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $toplevel.idFrame.label14
  label $toplevel.idFrame.label14 \
    -text {Identification:}

  # build widget $toplevel.idFrame.id
  label $toplevel.idFrame.id \
    -relief {flat} -justify left -foreground blue \
    -text "$id"
  set help_tips($toplevel.idFrame.id) {This is the item's Identification}
  enable_balloon $toplevel.idFrame.id

  # build widget $toplevel.idFrame.fill
  frame $toplevel.idFrame.fill -relief {flat}

  # build widget $toplevel.titleFrame
  frame $toplevel.titleFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $toplevel.titleFrame.label16
  label $toplevel.titleFrame.label16 \
    -text {Title:}

  # build widget $toplevel.titleFrame.title
  label $toplevel.titleFrame.title \
    -relief {flat} -justify left -foreground blue \
    -text "[$theCard title]"
  set help_tips($toplevel.titleFrame.title) {This is the item's Title}
  enable_balloon $toplevel.titleFrame.title

  # build widget $toplevel.titleFrame.fill
  frame $toplevel.titleFrame.fill -relief {flat}

  # build widget $toplevel.authorFrame
  frame $toplevel.authorFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $toplevel.authorFrame.label18
  label $toplevel.authorFrame.label18 \
    -text {Author:}

  # build widget $toplevel.authorFrame.author
  label $toplevel.authorFrame.author \
    -relief {flat} -justify left -foreground blue \
    -text "[$theCard author]"
  set help_tips($toplevel.authorFrame.author) {This is the item's Author}
  enable_balloon $toplevel.authorFrame.author
    
  # build widget $toplevel.authorFrame.fill
  frame $toplevel.authorFrame.fill -relief {flat}


  # build widget $toplevel.typeFrame
  frame $toplevel.typeFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $toplevel.typeFrame.label20
  label $toplevel.typeFrame.label20 \
    -text {Item type:}

  # build widget $toplevel.typeFrame.type
  label $toplevel.typeFrame.type \
    -relief {flat} -justify left -foreground blue \
    -text "[$CurrentCardCatalog cardtypename [$theCard cardtype]]"
  set help_tips($toplevel.typeFrame.type) {This is the item's type}
  enable_balloon $toplevel.typeFrame.type

  # build widget $toplevel.typeFrame.fill
  frame $toplevel.typeFrame.fill -relief {flat}

  # build widget $toplevel.publisherFrame
  frame $toplevel.publisherFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $toplevel.publisherFrame.label22
  label $toplevel.publisherFrame.label22 \
    -text {Published by:}

  # build widget $toplevel.publisherFrame.publisher
  label $toplevel.publisherFrame.publisher \
    -relief {flat} -justify left -foreground blue \
    -text "[$theCard publisher]"
  set help_tips($toplevel.publisherFrame.publisher) {This is the item's Publisher}
  enable_balloon $toplevel.publisherFrame.publisher

  # build widget $toplevel.publisherFrame.label24
  label $toplevel.publisherFrame.label24 \
    -text {of}

  # build widget $toplevel.publisherFrame.city
  label $toplevel.publisherFrame.city \
    -relief {flat} -justify left -foreground blue \
    -text "[$theCard city]"
  set help_tips($toplevel.publisherFrame.city) {This is the city the Publisher is in}
  enable_balloon $toplevel.publisherFrame.city

  # build widget $toplevel.publisherFrame.label26
  label $toplevel.publisherFrame.label26 \
    -text {in the year:}

  # build widget $toplevel.publisherFrame.year
  label $toplevel.publisherFrame.year \
    -relief {flat} -justify left -foreground blue \
    -text "[$theCard year]"
  set help_tips($toplevel.publisherFrame.year) {This is the year the item was published}
  enable_balloon $toplevel.publisherFrame.year

  # build widget $toplevel.publisherFrame.fill
  frame $toplevel.publisherFrame.fill -relief {flat}

  # build widget $toplevel.volumeCatFrame
  frame $toplevel.volumeCatFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $toplevel.volumeCatFrame.label28
  label $toplevel.volumeCatFrame.label28 \
    -text {Volume:}

  # build widget $toplevel.volumeCatFrame.volume
  label $toplevel.volumeCatFrame.volume \
    -relief {flat} -justify left -foreground blue \
    -text "[$theCard vol]"
  set help_tips($toplevel.volumeCatFrame.volume) {This is the item's volume number}
  enable_balloon $toplevel.volumeCatFrame.volume

  # build widget $toplevel.volumeCatFrame.label30
  label $toplevel.volumeCatFrame.label30 \
    -text {Category:}

  # build widget $toplevel.volumeCatFrame.lcategory
  label $toplevel.volumeCatFrame.lcategory \
    -relief {flat} -justify left -foreground blue \
    -text "[$CurrentCardCatalog category [$theCard categorycode]]"
  set help_tips($toplevel.volumeCatFrame.lcategory) {This is the item's Category}
  enable_balloon $toplevel.volumeCatFrame.lcategory

  # build widget $toplevel.volumeCatFrame.fill
  frame $toplevel.volumeCatFrame.fill -relief {flat}

  # build widget $toplevel.frame
  frame $toplevel.frame \
    -borderwidth {3} \
    -relief {ridge}

  # build widget $toplevel.frame.scrollbar1
  scrollbar $toplevel.frame.scrollbar1 \
    -command "$toplevel.frame.text2 yview"

  # build widget $toplevel.frame.text2
  text $toplevel.frame.text2 \
    -wrap {word} \
    -relief flat -foreground blue \
    -yscrollcommand "$toplevel.frame.scrollbar1 set" \
    -exportselection 0 \
    -cursor {} \
    -height 15
  # bindings
  bind $toplevel.frame.text2 <Key> {break}
  
  $toplevel.frame.text2 insert end "[$theCard description]"
  set help_tips($toplevel.frame.text2) \
	{This is the item's description}
  enable_balloon $toplevel.frame.text2

  # build widget $toplevel.locationFrame
  frame $toplevel.locationFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $toplevel.locationFrame.label32
  label $toplevel.locationFrame.label32 \
    -text {Location:}

  # build widget $toplevel.locationFrame.location
  label $toplevel.locationFrame.location \
    -relief {flat} -justify left -foreground blue \
    -text "[$CurrentCardCatalog locationtypename [$theCard locationtype]] ([$theCard locationdetail])"
  set help_tips($toplevel.locationFrame.location) {This is the item's Location}
  enable_balloon $toplevel.locationFrame.location

  # build widget $toplevel.locationFrame.fill
  frame $toplevel.locationFrame.fill -relief {flat}

  # build widget $toplevel.buttons
  frame $toplevel.buttons \
    -borderwidth {2}

  # build widget $toplevel.buttons.button37
  button $toplevel.buttons.button37 \
    -padx {9} \
    -pady {3} \
    -text {Add To Notepad} \
    -command \
	"$text insert end \"$item\n\""
  set help_tips($toplevel.buttons.button37) \
	{Add this card to the note pad text area}

  # build widget $toplevel.buttons.button40
  button $toplevel.buttons.button40 \
    -padx {9} \
    -pady {3} \
    -text {Print Card} \
    -command  "PrintCard $toplevel"
  set help_tips($toplevel.buttons.button40) {Print or save this card to a file}

  # build widget $toplevel.buttons.button38
  button $toplevel.buttons.button38 \
    -padx {9} \
    -pady {3} \
    -text {Dismis} \
    -command "RemoveTopLevel $toplevel"
  set help_tips($toplevel.buttons.button38) {Dismis this popup}

  # build widget $toplevel.buttons.button39
  button $toplevel.buttons.button39 \
    -padx {9} \
    -pady {3} \
    -text {Help} \
    -command {hl_Help {Show Card dialog}}
  set help_tips($toplevel.buttons.button39) {Get detailed help}

  # pack master $toplevel.topFrame
  pack configure $toplevel.topFrame.icon -side left
  pack configure $toplevel.topFrame.bigLabel -side right -expand 1 -fill both

  # pack master $toplevel.idFrame
  pack configure $toplevel.idFrame.label14 \
    -side left
  pack configure $toplevel.idFrame.id \
    -anchor w \
    -side left
  pack configure $toplevel.idFrame.fill \
    -side right \
    -fill both


  # pack master $toplevel.titleFrame
  pack configure $toplevel.titleFrame.label16 \
    -side left
  pack configure $toplevel.titleFrame.title \
    -anchor w \
    -side left
  pack configure $toplevel.titleFrame.fill \
    -side right \
    -fill both

  # pack master $toplevel.authorFrame
  pack configure $toplevel.authorFrame.label18 \
    -side left
  pack configure $toplevel.authorFrame.author \
    -anchor w \
    -side left
  pack configure $toplevel.authorFrame.fill \
    -side right \
    -fill both

  # pack master $toplevel.typeFrame
  pack configure $toplevel.typeFrame.label20 \
    -side left
  pack configure $toplevel.typeFrame.type \
    -anchor w \
    -side left
  pack configure $toplevel.typeFrame.fill \
    -side right \
    -fill both

  # pack master $toplevel.publisherFrame
  pack configure $toplevel.publisherFrame.label22 \
    -side left
  pack configure $toplevel.publisherFrame.publisher \
    -anchor w \
    -side left
  pack configure $toplevel.publisherFrame.label24 \
    -side left
  pack configure $toplevel.publisherFrame.city \
    -anchor w \
    -side left
  pack configure $toplevel.publisherFrame.label26 \
    -side left
  pack configure $toplevel.publisherFrame.year \
    -anchor w \
    -side left
  pack configure $toplevel.publisherFrame.fill \
    -side right \
    -fill both

  # pack master $toplevel.volumeCatFrame
  pack configure $toplevel.volumeCatFrame.label28 \
    -side left
  pack configure $toplevel.volumeCatFrame.volume \
    -anchor w \
    -side left
  pack configure $toplevel.volumeCatFrame.label30 \
    -side left
  pack configure $toplevel.volumeCatFrame.lcategory \
    -anchor w \
    -side left
  pack configure $toplevel.publisherFrame.fill \
    -side right \
    -fill both

  # pack master $toplevel.frame
  pack configure $toplevel.frame.scrollbar1 \
    -fill y \
    -side right
  pack configure $toplevel.frame.text2 \
    -expand 1 \
    -fill both

  # pack master $toplevel.locationFrame
  pack configure $toplevel.locationFrame.label32 \
    -side left
  pack configure $toplevel.locationFrame.location \
    -anchor w \
    -side left
  pack configure $toplevel.locationFrame.fill \
    -side right \
    -fill both

  # pack master $toplevel.buttons
  pack configure $toplevel.buttons.button37 \
    -expand 1 \
    -side left
  pack configure $toplevel.buttons.button40 \
    -expand 1 \
    -side left
  pack configure $toplevel.buttons.button38 \
    -expand 1 \
    -side left
  pack configure $toplevel.buttons.button39 \
    -expand 1 \
    -side right

  # pack master $toplevel
  pack configure $toplevel.topFrame -fill x
  pack configure $toplevel.idFrame \
    -fill x
  pack configure $toplevel.titleFrame \
    -fill x
  pack configure $toplevel.authorFrame \
    -fill x
  pack configure $toplevel.typeFrame \
    -fill x
  pack configure $toplevel.publisherFrame \
    -fill x
  pack configure $toplevel.volumeCatFrame \
    -fill x
  pack configure $toplevel.frame \
    -expand 1 \
    -fill both
  pack configure $toplevel.locationFrame \
    -fill x
  pack configure $toplevel.buttons \
    -fill x

# end of widget tree

  $theCard delete

}

proc SearchOldLibrary {} {
  # Search an existing library.
  # [index] SearchOldLibrary!procedure

  global HLTypes
  set fname [tk_getOpenFile -defaultextension {.libr} \
			    -title "Select a library name" \
			    -filetypes $HLTypes]
  if {[string length "$fname"] == 0} {return}
  global CurrentCardCatalog
  if {[catch [list vBTree "$fname" {ReadOnly}] CurrentCardCatalog]} {
    hl_error $CurrentCardCatalog
    set CurrentCardCatalog {}
    return
  }

  pack forget .mainFrame.openFrame

  global tk_version
  if {$tk_version >= 8.0} {
    set fm {.menuBar.file}
  } else {
    set fm {.menuBar.fileButton.m}
  }
  $fm entryconfigure {New...} -state disabled
  $fm entryconfigure {Open...} -state disabled
  $fm entryconfigure {Import...} -state disabled
  $fm entryconfigure {Search...} -state disabled
  $fm entryconfigure {Close} -state normal


  .auxFrame.messages configure \
	-text "[file tail $fname] [$CurrentCardCatalog openstat]"

  if {![winfo exists .mainFrame.searchFrame]} {
    searchFrame
  } else {
    .mainFrame.searchFrame.serb.seb.searchString delete 0 end
    .mainFrame.searchFrame.notepad.frame.text2 delete 1.0 end
    .mainFrame.searchFrame.results.frame0.frame3.listbox8 delete 0 end
    global SearchBy
    set SearchBy {Author}
    global KeysAre
    set KeysAre {}
  }
  pack configure .mainFrame.searchFrame \
	-expand 1 \
	-fill both

}

package provide HL20_searchFrame 1.0
