#* 
#* ------------------------------------------------------------------
#* Home Libarian 1.1 by Deepwoods Software
#* ------------------------------------------------------------------
#* HL20_editForm.tcl - Editing more
#* Created by Robert Heller on Sat Sep  6 13:18:07 1997
#* ------------------------------------------------------------------
#* Modification History: 
#* $Log: HL20_editForm.tcl,v $
#* Revision 2.7  1999/07/01 23:57:29  heller
#* Fix small bug in CreateNewLibrary
#*
#* Revision 2.6  1999/02/23 13:27:59  heller
#* Fixes to deal with 'odd' file names (spaces, etc.)
#*
#* Revision 2.5  1998/05/17 21:14:18  heller
#* Add in indexing
#*
#* Revision 2.4  1998/04/21 18:38:33  heller
#* Final Release...
#*
#* Revision 2.3  1998/01/18 20:51:56  heller
#* Assorted fixes for Card editing
#*
#* Revision 2.2  1997/09/13 05:39:02  heller
#* Fix problems with indexing for EditCardById and DeleteCardById calls
#*
#* Revision 2.1  1997/09/07 17:00:28  heller
#* Move Import, Export, and Print variables to the files where they belong
#*
#* Revision 2.0  1997/09/06 18:48:13  heller
#* *** empty log message ***
#*
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Home Librarian Database -- a program for maintaining a database
#*                                for a home library
#*     Copyright (C) 1991-1997  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

#@Chapter: HL20\_editForm.tcl -- editing form.
#@Label: HL20editForm.tcl
#$Id: HL20_editForm.tcl,v 2.7 1999/07/01 23:57:29 heller Rel $

# This script contains most of the editing code.


global TypeMenus
# List of all currently active Card Type menus.
# [index] TypeMenus!global variable

set TypeMenus {}

global LocationMenus
# List of all currently active Location Type menus.
# [index] LocationMenus!global variable

set LocationMenus {}

global CategoryMenus
# List of all currently active Category menus.
# [index] CategoryMenus!global variable

set CategoryMenus {}

global TemplateCards
# List of all loaded Template Cards.
# [index] TemplateCards!global variable

catch {set TemplateCards(<Default>) [list [CardRecord] {} {} {} 0]}

global NumNewPages
# The number of new pages to pre-allocate when creating a new library file.
# [index] NumNewPages!global variable

set NumNewPages {}

global FindBy
# Findby radiobutton set.
# [index] FindBy!global variable

set FindBy {Id}

global DeleteBy
# Deleteby radiobutton set.
# [index] DeleteBy!global variable

set DeleteBy {Id}

proc editForm {} {
# Edit GUI:
#
# Contains:
# <Edit Card> frame -- edit a specific card.
# <Find Cards> frame -- find cards to edit.
# <Delete Cards> frame -- find cards to delete.
# <Buttons> frame -- various useful buttons.
# [index] editForm!procedure

  global help_tips

  # build widget .mainFrame.editForm
  frame .mainFrame.editForm \
    -borderwidth {2} \
    -height {296} \
    -relief {raised} \
    -width {496}

  # build widget .mainFrame.editForm.editFrame
  frame .mainFrame.editForm.editFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .mainFrame.editForm.editFrame.edit
  button .mainFrame.editForm.editFrame.edit \
    -padx {9} \
    -pady {3} \
    -text {Edit Card:} \
    -command {EditCardById "[.mainFrame.editForm.editFrame.editId get]"}
  set help_tips(.mainFrame.editForm.editFrame.edit) \
	{Edit the selected card by its Id}

  # build widget .mainFrame.editForm.editFrame.editId
  entry .mainFrame.editForm.editFrame.editId \
    -exportselection 0
  bind .mainFrame.editForm.editFrame.editId <Return> \
	{.mainFrame.editForm.editFrame.edit invoke}
  enable_balloon .mainFrame.editForm.editFrame.editId
  set help_tips(.mainFrame.editForm.editFrame.editId) \
  	{This is the Id of the card to edit}

  # build widget .mainFrame.editForm.findFrame
  frame .mainFrame.editForm.findFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .mainFrame.editForm.findFrame.find
  button .mainFrame.editForm.findFrame.find \
    -padx {9} \
    -pady {3} \
    -text {Find A Card:} \
    -command {
	global FindBy
	FindCardsToEdit "[.mainFrame.editForm.findFrame.findString get]" $FindBy
	}
  set help_tips(.mainFrame.editForm.findFrame.find) \
	{Search for cards to edit}

  # build widget .mainFrame.editForm.findFrame.findString
  entry .mainFrame.editForm.findFrame.findString \
    -exportselection 0
  bind .mainFrame.editForm.findFrame.findString <Return> \
	{.mainFrame.editForm.findFrame.find invoke}
  enable_balloon .mainFrame.editForm.findFrame.findString
  set help_tips(.mainFrame.editForm.findFrame.findString) \
	{Search prefix for finding cards to edit}

  # build widget .mainFrame.editForm.findFrame.rgroup
  frame .mainFrame.editForm.findFrame.rgroup

  # build widget .mainFrame.editForm.findFrame.rgroup.i
  radiobutton .mainFrame.editForm.findFrame.rgroup.i \
    -text {By Id} \
    -value {Id} \
    -variable {FindBy}
  set help_tips(.mainFrame.editForm.findFrame.rgroup.i) \
	{Search for cards to edit with a matching Id prefix}

  # build widget .mainFrame.editForm.findFrame.rgroup.a
  radiobutton .mainFrame.editForm.findFrame.rgroup.a \
    -text {By Author} \
    -value {Author} \
    -variable {FindBy}
  set help_tips(.mainFrame.editForm.findFrame.rgroup.a) \
	{Search for cards to edit with a matching Author prefix}

  # build widget .mainFrame.editForm.findFrame.rgroup.t
  radiobutton .mainFrame.editForm.findFrame.rgroup.t \
    -text {By Title} \
    -value {Title} \
    -variable {FindBy}
  set help_tips(.mainFrame.editForm.findFrame.rgroup.t) \
	{Search for cards to edit with a matching Title prefix}

  # build widget .mainFrame.editForm.findFrame.rgroup.s
  radiobutton .mainFrame.editForm.findFrame.rgroup.s \
    -text {By Subject} \
    -value {Subject} \
    -variable {FindBy}
  set help_tips(.mainFrame.editForm.findFrame.rgroup.s) \
	{Search for cards to edit with a matching Subject prefix}

  # build widget .mainFrame.editForm.deleteFrame
  frame .mainFrame.editForm.deleteFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .mainFrame.editForm.deleteFrame.delete
  button .mainFrame.editForm.deleteFrame.delete \
    -padx {9} \
    -pady {3} \
    -text {Delete Cards:} \
    -command {
	global DeleteBy
	FindCardsToDelete "[.mainFrame.editForm.deleteFrame.deleteString get]" \
			  $DeleteBy
	}
  set help_tips(.mainFrame.editForm.deleteFrame.delete) \
	{Search for cards to delete}

  # build widget .mainFrame.editForm.deleteFrame.rgroup
  frame .mainFrame.editForm.deleteFrame.rgroup

  # build widget .mainFrame.editForm.deleteFrame.rgroup.i
  radiobutton .mainFrame.editForm.deleteFrame.rgroup.i \
    -text {By Id} \
    -value {Id} \
    -variable {DeleteBy}
  set help_tips(.mainFrame.editForm.deleteFrame.rgroup.i) \
	{Search for cards to delete with a matching Id prefix}

  # build widget .mainFrame.editForm.deleteFrame.rgroup.a
  radiobutton .mainFrame.editForm.deleteFrame.rgroup.a \
    -text {By Author} \
    -value {Author} \
    -variable {DeleteBy}
  set help_tips(.mainFrame.editForm.deleteFrame.rgroup.a) \
	{Search for cards to delete with a matching Author prefix}

  # build widget .mainFrame.editForm.deleteFrame.rgroup.t
  radiobutton .mainFrame.editForm.deleteFrame.rgroup.t \
    -text {By Title} \
    -value {Title} \
    -variable {DeleteBy}
  set help_tips(.mainFrame.editForm.deleteFrame.rgroup.t) \
	{Search for cards to delete with a matching Title prefix}

  # build widget .mainFrame.editForm.deleteFrame.rgroup.s
  radiobutton .mainFrame.editForm.deleteFrame.rgroup.s \
    -text {By Subject} \
    -value {Subject} \
    -variable {DeleteBy}
  set help_tips(.mainFrame.editForm.deleteFrame.rgroup.s) \
	{Search for cards to delete with a matching Subject prefix}

  # build widget .mainFrame.editForm.deleteFrame.deleteString
  entry .mainFrame.editForm.deleteFrame.deleteString \
    -exportselection 0
  bind .mainFrame.editForm.deleteFrame.deleteString <Return> \
	{.mainFrame.editForm.deleteFrame.delete invoke}
  enable_balloon .mainFrame.editForm.deleteFrame.deleteString
  set help_tips(.mainFrame.editForm.deleteFrame.deleteString) \
	{Search prefix for finding cards to delete}

  # build widget .mainFrame.editForm.buttons
  frame .mainFrame.editForm.buttons \
    -borderwidth {2}

  # build widget .mainFrame.editForm.buttons.close
  button .mainFrame.editForm.buttons.close \
    -padx {9} \
    -pady {3} \
    -text {Close} \
    -command {CloseCurrentLibrary}
  set help_tips(.mainFrame.editForm.buttons.close) {Close the library file}

  # build widget .mainFrame.editForm.buttons.save
  button .mainFrame.editForm.buttons.save \
    -padx {9} \
    -pady {3} \
    -text {Save} \
    -command {SaveCurrentLibrary}
  set help_tips(.mainFrame.editForm.buttons.save) {Save the library file}


  # build widget .mainFrame.editForm.buttons.help
  button .mainFrame.editForm.buttons.help \
    -padx {9} \
    -pady {3} \
    -takefocus 0 \
    -text {Help} \
    -command {hl_Help {Editing a Card Catalog database}}
  set help_tips(.mainFrame.editForm.buttons.help) {Popup detailed help}

  # pack master .mainFrame.editForm.editFrame
  pack configure .mainFrame.editForm.editFrame.edit \
    -side left
  pack configure .mainFrame.editForm.editFrame.editId \
    -expand 1 \
    -fill x \
    -side right

  # pack master .mainFrame.editForm.findFrame
  pack configure .mainFrame.editForm.findFrame.findString \
    -anchor se \
    -expand 1 \
    -fill x \
    -side right
  pack configure .mainFrame.editForm.findFrame.find \
    -anchor nw \
    -side left
  pack configure .mainFrame.editForm.findFrame.rgroup \
    -side left

  # pack master .mainFrame.editForm.findFrame.rgroup
  pack configure .mainFrame.editForm.findFrame.rgroup.i \
    -anchor w
  pack configure .mainFrame.editForm.findFrame.rgroup.a \
    -anchor w
  pack configure .mainFrame.editForm.findFrame.rgroup.t \
    -anchor w
  pack configure .mainFrame.editForm.findFrame.rgroup.s \
    -anchor w

  # pack master .mainFrame.editForm.deleteFrame
  pack configure .mainFrame.editForm.deleteFrame.delete \
    -anchor nw \
    -side left
  pack configure .mainFrame.editForm.deleteFrame.rgroup \
    -side left
  pack configure .mainFrame.editForm.deleteFrame.deleteString \
    -anchor se \
    -expand 1 \
    -fill x \
    -side right

  # pack master .mainFrame.editForm.deleteFrame.rgroup
  pack configure .mainFrame.editForm.deleteFrame.rgroup.i \
    -anchor w
  pack configure .mainFrame.editForm.deleteFrame.rgroup.a \
    -anchor w
  pack configure .mainFrame.editForm.deleteFrame.rgroup.t \
    -anchor w
  pack configure .mainFrame.editForm.deleteFrame.rgroup.s \
    -anchor w

  # pack master .mainFrame.editForm.buttons
  pack configure .mainFrame.editForm.buttons.close \
    -expand 1 \
    -side left
  pack configure .mainFrame.editForm.buttons.save \
    -expand 1 \
    -side left
  pack configure .mainFrame.editForm.buttons.help \
    -expand 1 \
    -side right

  # pack master .mainFrame.editForm
  pack configure .mainFrame.editForm.editFrame \
    -fill x
  pack configure .mainFrame.editForm.findFrame \
    -expand 1 \
    -fill both
  pack configure .mainFrame.editForm.deleteFrame \
    -expand 1 \
    -fill both
  pack configure .mainFrame.editForm.buttons \
    -fill x

  # pack slave .mainFrame.editForm
  pack configure .mainFrame.editForm \
    -expand 1 \
    -fill both

  .mainFrame.editForm.editFrame.editId insert end {}
  .mainFrame.editForm.findFrame.findString insert end {}
  .mainFrame.editForm.deleteFrame.deleteString insert end {}

  global FindBy
  set FindBy {Id}

  global DeleteBy
  set DeleteBy {Id}


# end of widget tree

}

proc FindCardsToEdit {string findby} {
# Search for cards to edit.
#
# Arguments:
# <in> string -- search prefix string.
# <in> findby -- index to search.
# [index] FindCardsToEdit!procedure

  global CurrentCardCatalog
  global Work
  set message {}
  if {[string compare "$CurrentCardCatalog" {}] == 0} {return}
  StartWorking
  switch -exact $findby {
    Id     {
	if {[string length "$string"] == 0} {
	  set idList "[$CurrentCardCatalog searchids]"
	} else {
	  set idList "[$CurrentCardCatalog searchids $string]"
	}
	set nMatches [llength "$idList"]
	if {$nMatches == 0} {
	  set message "Found no matches\nfor \"$string\""
	} else {
	  set results {}
	  foreach id $idList {
	    set card "[$CurrentCardCatalog readid $id]"
	    lappend results "[list $id [$card author] [$card title]]"
	    $card delete
	  }
	  set resultList "[SortCardList $results]"
	  set message "Found $nMatches match"
	  if {$nMatches > 1} {append message "es"}
	  append message "\nfor \"$string\""
	}
	set KeysAre Id
	if {$nMatches == 1} {
	  EditCardById "[lindex [lindex $resultList 0] 0]"
	} elseif {$nMatches > 1} {
	  PopupIdEditList "$resultList" "By Id prefix $string"
	}
      }
    Author {
	if {[string length "$string"] == 0} {
	  set resultList "[$CurrentCardCatalog searchauthors]"
	} else {
	  set resultList "[$CurrentCardCatalog searchauthors $string]"
	}
	set KeysAre Author
	set nMatches [llength "$resultList"]
 	if {$nMatches == 0} {
	  set message "Found no matches\nfor \"$string\""
	} elseif {$nMatches < 5} {
	  set resultList "[ExpandAuthors $resultList]"
	  set nMatches [llength "$resultList"]
	  set KeysAre Id
	  set message "Found $nMatches match"
	  if {$nMatches > 1} {append message "es"}
	  append message "\nfor \"$string\""
	} else {
	  set message "Found $nMatches match"
	  if {$nMatches > 1} {append message "es"}
	  append message "\nfor \"$string\""
	}
	if {$nMatches == 1} {
	  EditCardById "[lindex [lindex $resultList 0] 0]"
	} elseif {$nMatches > 1} {
	  if {$KeysAre == {Id}} {
	    PopupIdEditList "$resultList" "By Author prefix $string"
	  } else {
	    PopupAuthorEditList "$resultList" "By Author prefix $string"
	  }
	}
      }
    Title {
	if {[string length "$string"] == 0} {
	  set resultList "[$CurrentCardCatalog searchtitles]"
	} else {
	  set resultList "[$CurrentCardCatalog searchtitles $string]"
	}
	set KeysAre Title
	set nMatches [llength "$resultList"]
 	if {$nMatches == 0} {
	  set message "Found no matches\nfor \"$string\""
	} elseif {$nMatches < 5} {
	  set resultList "[ExpandTitles $resultList]"
	  set nMatches [llength "$resultList"]
	  set KeysAre Id
	  set message "Found $nMatches match"
	  if {$nMatches > 1} {append message "es"}
	  append message "\nfor \"$string\""
	} else {
	  set message "Found $nMatches match"
	  if {$nMatches > 1} {append message "es"}
	  append message "\nfor \"$string\""
	}
	if {$nMatches == 1} {
	  EditCardById "[lindex [lindex $resultList 0] 0]"
	} elseif {$nMatches > 1} {
	  if {$KeysAre == {Id}} {
	    PopupIdEditList "$resultList" "By Title prefix $string"
	  } else {
	    PopupTitleEditList "$resultList" "By Title prefix $string"
	  }
	}
      }
    Subject {
	if {[string length "$string"] == 0} {
	  set resultList "[$CurrentCardCatalog searchsubjects]"
	} else {
	  set resultList "[$CurrentCardCatalog searchsubjects $string]"
	}
	set KeysAre Subject
	set nMatches [llength "$resultList"]
 	if {$nMatches == 0} {
	  set message "Found no matches\nfor \"$string\""
	} elseif {$nMatches < 5} {
	  set resultList "[ExpandSubjects $resultList]"
	  set nMatches [llength "$resultList"]
	  set KeysAre Id
	  set message "Found $nMatches match"
	  if {$nMatches > 1} {append message "es"}
	  append message "\nfor \"$string\""
	} else {
	  set message "Found $nMatches match"
	  if {$nMatches > 1} {append message "es"}
	  append message "\nfor \"$string\""
	}
	if {$nMatches == 1} {
	  EditCardById "[lindex [lindex $resultList 0] 0]"
	} elseif {$nMatches > 1} {
	  if {$KeysAre == {Id}} {
	    PopupIdEditList "$resultList" "By Subject prefix $string"
	  } else {
	    PopupSubjectEditList "$resultList" "By Subject prefix $string"
	  }
	}
      }
    default {}
  }
  if {[string compare "$KeysAre" {Id}] != 0} {
    EndWorking "$message ($KeysAre)"
  } else {
    EndWorking "$message"
  }
}


proc PopupIdEditList {itemList title} {
# Popup a list of cards to possibly edit.
#
# Arguments:
# <in> itemList -- the list of items.
# <in> title -- the title to use.
# [index] PopupIdEditList!procedure

  global help_tips

  for {set i 1} {[winfo exists .popUpList$i] == 1} {incr i} {}
  set toplevel ".popUpIdEditList$i"

  # build widget $toplevel
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy $toplevel"
  } {
    catch "destroy $toplevel"
  }
  toplevel $toplevel 

  # Window manager configurations
  wm maxsize $toplevel 1009 738
  wm minsize $toplevel 1 1
  wm title $toplevel "$title"
  AddTopLevel $toplevel
  wm protocol $toplevel WM_DELETE_WINDOW "RemoveTopLevel $toplevel"


  # build widget $toplevel.topFrame
  frame $toplevel.topFrame -borderwidth {2} -relief flat

  # build widget $toplevel.topFrame.icon
  label $toplevel.topFrame.icon \
    -image SmallFace -relief flat

  # build widget $toplevel.topFrame.bigLabel
  label $toplevel.topFrame.bigLabel \
    -bg yellow -fg brown \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -text "$title"

  # build widget $toplevel.frame0
  frame $toplevel.frame0 \
    -borderwidth {2}

  # build widget $toplevel.frame0.frame1
  frame $toplevel.frame0.frame1

  # build widget $toplevel.frame0.frame1.frame3
  frame $toplevel.frame0.frame1.frame3 \
    -borderwidth {2}

  # build widget $toplevel.frame0.frame1.frame3.listbox8
  listbox $toplevel.frame0.frame1.frame3.listbox8 \
    -height {16} \
    -width {60} \
    -selectmode single \
    -exportselection 0 \
    -font {-*-courier-bold-r-normal-*-*-120-*-*-*-*-*-*} \
    -xscrollcommand "$toplevel.frame0.frame2.frame5.scrollbar10 set" \
    -yscrollcommand "$toplevel.frame0.frame1.frame4.scrollbar9 set"
  bind $toplevel.frame0.frame1.frame3.listbox8 <1> \
	"$toplevel.buttons.button2 configure -state normal"
  bind $toplevel.frame0.frame1.frame3.listbox8 <Double-1> \
	"if \{\[winfo exists %W\]\} \{tkListboxBeginSelect %W \[%W index @%x,%y\]\};\
	$toplevel.buttons.button2 configure -state normal;\
	$toplevel.buttons.button2 invoke"
  foreach i $itemList {
    $toplevel.frame0.frame1.frame3.listbox8 insert end  \
	"[format "%-36s %s %s" [lindex $i 0] [lindex $i 1] [lindex $i 2]]"
  }
  set help_tips($toplevel.frame0.frame1.frame3.listbox8) \
	"List of items that expand from $title"
  enable_balloon $toplevel.frame0.frame1.frame3.listbox8

  # build widget $toplevel.frame0.frame1.frame4
  frame $toplevel.frame0.frame1.frame4 \
    -borderwidth {2}

  # build widget $toplevel.frame0.frame1.frame4.scrollbar9
  scrollbar $toplevel.frame0.frame1.frame4.scrollbar9 \
    -command "$toplevel.frame0.frame1.frame3.listbox8 yview" \
    -width {13}

  # build widget $toplevel.frame0.frame2
  frame $toplevel.frame0.frame2 \
    -borderwidth {1}

  # build widget $toplevel.frame0.frame2.frame5
  frame $toplevel.frame0.frame2.frame5 \
    -borderwidth {2}

  # build widget $toplevel.frame0.frame2.frame5.scrollbar10
  scrollbar $toplevel.frame0.frame2.frame5.scrollbar10 \
    -command "$toplevel.frame0.frame1.frame3.listbox8 xview" \
    -orient {horizontal} \
    -width {13}

  # build widget $toplevel.frame0.frame2.frame6
  frame $toplevel.frame0.frame2.frame6 \
    -borderwidth {2}

  # build widget $toplevel.frame0.frame2.frame6.frame11
  frame $toplevel.frame0.frame2.frame6.frame11 \
    -borderwidth {2} \
    -height {13} \
    -width {16}

  # build widget $toplevel.buttons
  frame $toplevel.buttons \
    -borderwidth {2}

  # build widget $toplevel.buttons.button2
  button $toplevel.buttons.button2 \
    -padx {9} \
    -pady {3} \
    -text {Edit Card} \
    -state disabled \
    -command  \
	"EditCardFromList $toplevel.frame0.frame1.frame3.listbox8"
  set help_tips($toplevel.buttons.button2) \
	{Edit the selected card}

  # build widget $toplevel.buttons.button3
  button $toplevel.buttons.button3 \
    -padx {9} \
    -pady {3} \
    -text {Dismis} \
    -command "RemoveTopLevel $toplevel"
  set help_tips($toplevel.buttons.button3) {Dismis this popup}

  # build widget $toplevel.buttons.button4
  button $toplevel.buttons.button4 \
    -padx {9} \
    -pady {3} \
    -text {Help} \
    -command {hl_Help {Generic Edit Id List dialog}}
  set help_tips($toplevel.buttons.button4) {Get detailed hellp}

  # pack master $toplevel.topFrame
  pack configure $toplevel.topFrame.icon -side left
  pack configure $toplevel.topFrame.bigLabel -side right -expand 1 -fill both

  # pack master $toplevel.frame0
  pack configure $toplevel.frame0.frame1 \
    -expand 1 \
    -fill both
  pack configure $toplevel.frame0.frame2 \
    -fill x \
    -side bottom

  # pack master $toplevel.frame0.frame1
  pack configure $toplevel.frame0.frame1.frame3 \
    -expand 1 \
    -fill both \
    -side left
  pack configure $toplevel.frame0.frame1.frame4 \
    -fill y \
    -side right

  # pack master $toplevel.frame0.frame1.frame3
  pack configure $toplevel.frame0.frame1.frame3.listbox8 \
    -expand 1 \
    -fill both \
    -side left

  # pack master $toplevel.frame0.frame1.frame4
  pack configure $toplevel.frame0.frame1.frame4.scrollbar9 \
    -expand 1 \
    -fill y

  # pack master $toplevel.frame0.frame2
  pack configure $toplevel.frame0.frame2.frame5 \
    -expand 1 \
    -fill both \
    -side left
  pack configure $toplevel.frame0.frame2.frame6 \
    -fill y \
    -side right

  # pack master $toplevel.frame0.frame2.frame5
  pack configure $toplevel.frame0.frame2.frame5.scrollbar10 \
    -expand 1 \
    -fill x \
    -side left

  # pack master $toplevel.frame0.frame2.frame6
  pack configure $toplevel.frame0.frame2.frame6.frame11 \
    -expand 1 \
    -fill both

  # pack master $toplevel.buttons
  pack configure $toplevel.buttons.button2 \
    -expand 1 \
    -side left
  pack configure $toplevel.buttons.button3 \
    -expand 1 \
    -side left
  pack configure $toplevel.buttons.button4 \
    -expand 1 \
    -side right

  # pack master $toplevel
  pack configure $toplevel.topFrame -fill x
  pack configure $toplevel.frame0 \
    -expand 1 \
    -fill both
  pack configure $toplevel.buttons \
    -fill x
# end of widget tree

}

proc EditCardFromList {lb} {
# Select a card to edit.
#
# Arguments:
# <in> lb -- the listbox with the selected card.
# [index] EditCardFromList!procedure

  set cs "[$lb curselection]"
  if {[llength "$cs"] < 1} {return}
  set item "[$lb get $cs]"
  set id "[string trim [string range $item 0 35]]"
  EditCardById "$id"
}

proc ExpandEditList {lb expFun} {
# Expand a selected author, title, or subject to edit.
#
# Arguments:
# <in> lb -- the listbox with the selected key.
# <in> expFun -- the function to expand the key.
# [index] ExpandEditList!procedure

  set cs "[$lb curselection]"
  if {[llength "$cs"] < 1} {return}
  set item "[$lb get $cs]"
  set itemList "[eval [list $expFun [list $item]]]"
  PopupIdEditList "$itemList" "Expanded from $item"
}


proc PopupAuthorEditList {list title} {
# Popup a list of authors to edit from.
#
# Arguments:
# <in> list -- the listbox to select from.
# <in> title -- the title to use.
# [index] PopupAuthorEditList!procedure

  PopupEditListList "$list" "$title" ExpandAuthors
}

proc PopupTitleEditList {list title} {
# Popup a list of titles to edit from.
#
# Arguments:
# <in> list -- the listbox to select from.
# <in> title -- the title to use.
# [index] PopupTitleEditList!procedure

  PopupEditListList "$list" "$title" ExpandTitles
}

proc PopupSubjectEditList {list title} {
# Popup a list of subjects to edit from.
#
# Arguments:
# <in> list -- the listbox to select from.
# <in> title -- the title to use.
# [index] PopupSubjectEditList!procedure

  PopupEditListList "$list" "$title" ExpandSubjects
}

proc PopupEditListList {itemList title expandFunction} {
# Pop up a list of items to edit.
#
# Arguments:
# <in> itemList -- list of items.
# <in> title -- the title to use.
# <in> expandFunction -- the expansion function to use.
# [index] PopupEditListList!procedure

  global help_tips

  for {set i 1} {[winfo exists .popUpList$i] == 1} {incr i} {}
  set toplevel ".popUpEditList$i"

  # build widget $toplevel
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy $toplevel"
  } {
    catch "destroy $toplevel"
  }
  toplevel $toplevel 

  # Window manager configurations
  wm maxsize $toplevel 1009 738
  wm minsize $toplevel 1 1
  wm title $toplevel "$title"
  AddTopLevel $toplevel
  wm protocol $toplevel WM_DELETE_WINDOW "RemoveTopLevel $toplevel"


  # build widget $toplevel.topFrame
  frame $toplevel.topFrame -borderwidth {2} -relief flat

  # build widget $toplevel.topFrame.icon
  label $toplevel.topFrame.icon \
    -image SmallFace -relief flat

  # build widget $toplevel.topFrame.bigLabel
  label $toplevel.topFrame.bigLabel \
    -bg yellow -fg brown \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -text "$title"

  # build widget $toplevel.frame0
  frame $toplevel.frame0 \
    -borderwidth {2}

  # build widget $toplevel.frame0.frame1
  frame $toplevel.frame0.frame1

  # build widget $toplevel.frame0.frame1.frame3
  frame $toplevel.frame0.frame1.frame3 \
    -borderwidth {2}

  # build widget $toplevel.frame0.frame1.frame3.listbox8
  listbox $toplevel.frame0.frame1.frame3.listbox8 \
    -height {16} \
    -width {60} \
    -selectmode single \
    -exportselection 0 \
    -font {-*-courier-bold-r-normal-*-*-120-*-*-*-*-*-*} \
    -xscrollcommand "$toplevel.frame0.frame2.frame5.scrollbar10 set" \
    -yscrollcommand "$toplevel.frame0.frame1.frame4.scrollbar9 set"
  bind $toplevel.frame0.frame1.frame3.listbox8 <1> \
	"$toplevel.buttons.button2 configure -state normal"
  bind $toplevel.frame0.frame1.frame3.listbox8 <Double-1> \
	"if \{\[winfo exists %W\]\} \{tkListboxBeginSelect %W \[%W index @%x,%y\]\};\
	$toplevel.buttons.button2 configure -state normal;\
	$toplevel.buttons.button2 invoke"
  foreach i $itemList {
    $toplevel.frame0.frame1.frame3.listbox8 insert end "$i"
  }
  set help_tips($toplevel.frame0.frame1.frame3.listbox8) \
	"List of items that expand from $title"
  enable_balloon $toplevel.frame0.frame1.frame3.listbox8

  # build widget $toplevel.frame0.frame1.frame4
  frame $toplevel.frame0.frame1.frame4 \
    -borderwidth {2}

  # build widget $toplevel.frame0.frame1.frame4.scrollbar9
  scrollbar $toplevel.frame0.frame1.frame4.scrollbar9 \
    -command "$toplevel.frame0.frame1.frame3.listbox8 yview" \
    -width {13}

  # build widget $toplevel.frame0.frame2
  frame $toplevel.frame0.frame2 \
    -borderwidth {1}

  # build widget $toplevel.frame0.frame2.frame5
  frame $toplevel.frame0.frame2.frame5 \
    -borderwidth {2}

  # build widget $toplevel.frame0.frame2.frame5.scrollbar10
  scrollbar $toplevel.frame0.frame2.frame5.scrollbar10 \
    -command "$toplevel.frame0.frame1.frame3.listbox8 xview" \
    -orient {horizontal} \
    -width {13}

  # build widget $toplevel.frame0.frame2.frame6
  frame $toplevel.frame0.frame2.frame6 \
    -borderwidth {2}

  # build widget $toplevel.frame0.frame2.frame6.frame11
  frame $toplevel.frame0.frame2.frame6.frame11 \
    -borderwidth {2} \
    -height {13} \
    -width {16}

  # build widget $toplevel.buttons
  frame $toplevel.buttons \
    -borderwidth {2}

  # build widget $toplevel.buttons.button2
  button $toplevel.buttons.button2 \
    -padx {9} \
    -pady {3} \
    -text {Expand Item} \
    -state disabled \
    -command  \
	[list ExpandEditList $toplevel.frame0.frame1.frame3.listbox8 $expandFunction]
  set help_tips($toplevel.buttons.button2) \
	{Expand item}

  # build widget $toplevel.buttons.button3
  button $toplevel.buttons.button3 \
    -padx {9} \
    -pady {3} \
    -text {Dismis} \
    -command "RemoveTopLevel $toplevel"
  set help_tips($toplevel.buttons.button3) {Dismis this popup}

  # build widget $toplevel.buttons.button4
  button $toplevel.buttons.button4 \
    -padx {9} \
    -pady {3} \
    -text {Help} \
    -command {hl_Help {Generic Edit List dialog}}
  set help_tips($toplevel.buttons.button4) {Get detailed hellp}

  # pack master $toplevel.topFrame
  pack configure $toplevel.topFrame.icon -side left
  pack configure $toplevel.topFrame.bigLabel -side right -expand 1 -fill both

  # pack master $toplevel.frame0
  pack configure $toplevel.frame0.frame1 \
    -expand 1 \
    -fill both
  pack configure $toplevel.frame0.frame2 \
    -fill x \
    -side bottom

  # pack master $toplevel.frame0.frame1
  pack configure $toplevel.frame0.frame1.frame3 \
    -expand 1 \
    -fill both \
    -side left
  pack configure $toplevel.frame0.frame1.frame4 \
    -fill y \
    -side right

  # pack master $toplevel.frame0.frame1.frame3
  pack configure $toplevel.frame0.frame1.frame3.listbox8 \
    -expand 1 \
    -fill both \
    -side left

  # pack master $toplevel.frame0.frame1.frame4
  pack configure $toplevel.frame0.frame1.frame4.scrollbar9 \
    -expand 1 \
    -fill y

  # pack master $toplevel.frame0.frame2
  pack configure $toplevel.frame0.frame2.frame5 \
    -expand 1 \
    -fill both \
    -side left
  pack configure $toplevel.frame0.frame2.frame6 \
    -fill y \
    -side right

  # pack master $toplevel.frame0.frame2.frame5
  pack configure $toplevel.frame0.frame2.frame5.scrollbar10 \
    -expand 1 \
    -fill x \
    -side left

  # pack master $toplevel.frame0.frame2.frame6
  pack configure $toplevel.frame0.frame2.frame6.frame11 \
    -expand 1 \
    -fill both

  # pack master $toplevel.buttons
  pack configure $toplevel.buttons.button2 \
    -expand 1 \
    -side left
  pack configure $toplevel.buttons.button3 \
    -expand 1 \
    -side left
  pack configure $toplevel.buttons.button4 \
    -expand 1 \
    -side right

  # pack master $toplevel
  pack configure $toplevel.topFrame -fill x
  pack configure $toplevel.frame0 \
    -expand 1 \
    -fill both
  pack configure $toplevel.buttons \
    -fill x
# end of widget tree

}

proc FindCardsToDelete {string deleteby} {
# Search for cards to delete.
#
# Arguments:
# <in> string -- search prefix string.
# <in> deleteby -- index to search.
# [index] FindCardsToDelete!procedure

  global CurrentCardCatalog
  global Work
  set message {}
  if {[string compare "$CurrentCardCatalog" {}] == 0} {return}
  StartWorking
  switch -exact $deleteby {
    Id     {
	if {[string length "$string"] == 0} {
	  set idList "[$CurrentCardCatalog searchids]"
	} else {
	  set idList "[$CurrentCardCatalog searchids $string]"
	}
	set nMatches [llength "$idList"]
	if {$nMatches == 0} {
	  set message "Found no matches\nfor \"$string\""
	} else {
	  set results {}
	  foreach id $idList {
	    set card "[$CurrentCardCatalog readid $id]"
	    lappend results "[list $id [$card author] [$card title]]"
	    $card delete
	  }
	  set resultList "[SortCardList $results]"
	  set message "Found $nMatches match"
	  if {$nMatches > 1} {append message "es"}
	  append message "\nfor \"$string\""
	}
	set KeysAre Id
	if {$nMatches == 1} {
	  DeleteCardById "[lindex [lindex $resultList 0] 0]"
	} elseif {$nMatches > 1} {
	  PopupIdDeleteList "$resultList" "By Id prefix $string"
	}
      }
    Author {
	if {[string length "$string"] == 0} {
	  set resultList "[$CurrentCardCatalog searchauthors]"
	} else {
	  set resultList "[$CurrentCardCatalog searchauthors $string]"
	}
	set KeysAre Author
	set nMatches [llength "$resultList"]
 	if {$nMatches == 0} {
	  set message "Found no matches\nfor \"$string\""
	} elseif {$nMatches < 5} {
	  set resultList "[ExpandAuthors $resultList]"
	  set nMatches [llength "$resultList"]
	  set KeysAre Id
	  set message "Found $nMatches match"
	  if {$nMatches > 1} {append message "es"}
	  append message "\nfor \"$string\""
	} else {
	  set message "Found $nMatches match"
	  if {$nMatches > 1} {append message "es"}
	  append message "\nfor \"$string\""
	}
	if {$nMatches == 1} {
	  DeleteCardById "[lindex [lindex $resultList 0] 0]"
	} elseif {$nMatches > 1} {
	  if {$KeysAre == {Id}} {
	    PopupIdDeleteList "$resultList" "By Author prefix $string"
	  } else {
	    PopupAuthorDeleteList "$resultList" "By Author prefix $string"
	  }
	}
      }
    Title {
	if {[string length "$string"] == 0} {
	  set resultList "[$CurrentCardCatalog searchtitles]"
	} else {
	  set resultList "[$CurrentCardCatalog searchtitles $string]"
	}
	set KeysAre Title
	set nMatches [llength "$resultList"]
 	if {$nMatches == 0} {
	  set message "Found no matches\nfor \"$string\""
	} elseif {$nMatches < 5} {
	  set resultList "[ExpandTitles $resultList]"
	  set nMatches [llength "$resultList"]
	  set KeysAre Id
	  set message "Found $nMatches match"
	  if {$nMatches > 1} {append message "es"}
	  append message "\nfor \"$string\""
	} else {
	  set message "Found $nMatches match"
	  if {$nMatches > 1} {append message "es"}
	  append message "\nfor \"$string\""
	}
	if {$nMatches == 1} {
	  DeleteCardById "[lindex [lindex $resultList 0] 0]"
	} elseif {$nMatches > 1} {
	  if {$KeysAre == {Id}} {
	    PopupIdDeleteList "$resultList" "By Title prefix $string"
	  } else {
	    PopupTitleDeleteList "$resultList" "By Title prefix $string"
	  }
	}
      }
    Subject {
	if {[string length "$string"] == 0} {
	  set resultList "[$CurrentCardCatalog searchsubjects]"
	} else {
	  set resultList "[$CurrentCardCatalog searchsubjects $string]"
	}
	set KeysAre Subject
	set nMatches [llength "$resultList"]
 	if {$nMatches == 0} {
	  set message "Found no matches\nfor \"$string\""
	} elseif {$nMatches < 5} {
	  set resultList "[ExpandSubjects $resultList]"
	  set nMatches [llength "$resultList"]
	  set KeysAre Id
	  set message "Found $nMatches match"
	  if {$nMatches > 1} {append message "es"}
	  append message "\nfor \"$string\""
	} else {
	  set message "Found $nMatches match"
	  if {$nMatches > 1} {append message "es"}
	  append message "\nfor \"$string\""
	}
	if {$nMatches == 1} {
	  DeleteCardById "[lindex [lindex $resultList 0] 0]"
	} elseif {$nMatches > 1} {
	  if {$KeysAre == {Id}} {
	    PopupIdDeleteList "$resultList" "By Subject prefix $string"
	  } else {
	    PopupSubjectDeleteList "$resultList" "By Subject prefix $string"
	  }
	}
      }
    default {}
  }
  if {[string compare "$KeysAre" {Id}] != 0} {
    EndWorking "$message ($KeysAre)"
  } else {
    EndWorking "$message"
  }
}

proc PopupIdDeleteList {itemList title} {
# Popup a list of cards to possibly delete.
#
# Arguments:
# <in> itemList -- the list of items.
# <in> title -- the title to use.
# [index] PopupIdDeleteList!procedure

  global help_tips

  for {set i 1} {[winfo exists .popUpList$i] == 1} {incr i} {}
  set toplevel ".popUpIdDeleteList$i"

  # build widget $toplevel
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy $toplevel"
  } {
    catch "destroy $toplevel"
  }
  toplevel $toplevel 

  # Window manager configurations
  wm maxsize $toplevel 1009 738
  wm minsize $toplevel 1 1
  wm title $toplevel "$title"
  AddTopLevel $toplevel
  wm protocol $toplevel WM_DELETE_WINDOW "RemoveTopLevel $toplevel"


  # build widget $toplevel.topFrame
  frame $toplevel.topFrame -borderwidth {2} -relief flat

  # build widget $toplevel.topFrame.icon
  label $toplevel.topFrame.icon \
    -image SmallFace -relief flat

  # build widget $toplevel.topFrame.bigLabel
  label $toplevel.topFrame.bigLabel \
    -bg yellow -fg brown \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -text "$title"

  # build widget $toplevel.frame0
  frame $toplevel.frame0 \
    -borderwidth {2}

  # build widget $toplevel.frame0.frame1
  frame $toplevel.frame0.frame1

  # build widget $toplevel.frame0.frame1.frame3
  frame $toplevel.frame0.frame1.frame3 \
    -borderwidth {2}

  # build widget $toplevel.frame0.frame1.frame3.listbox8
  listbox $toplevel.frame0.frame1.frame3.listbox8 \
    -height {16} \
    -width {60} \
    -selectmode single \
    -exportselection 0 \
    -font {-*-courier-bold-r-normal-*-*-120-*-*-*-*-*-*} \
    -xscrollcommand "$toplevel.frame0.frame2.frame5.scrollbar10 set" \
    -yscrollcommand "$toplevel.frame0.frame1.frame4.scrollbar9 set"
  bind $toplevel.frame0.frame1.frame3.listbox8 <1> \
	"$toplevel.buttons.button2 configure -state normal"
  bind $toplevel.frame0.frame1.frame3.listbox8 <Double-1> \
	"if \{\[winfo exists %W\]\} \{tkListboxBeginSelect %W \[%W index @%x,%y\]\};\
	$toplevel.buttons.button2 configure -state normal;\
	$toplevel.buttons.button2 invoke"
  foreach i $itemList {
    $toplevel.frame0.frame1.frame3.listbox8 insert end  \
	"[format "%-36s %s %s" [lindex $i 0] [lindex $i 1] [lindex $i 2]]"
  }
  set help_tips($toplevel.frame0.frame1.frame3.listbox8) \
	"List of items that expand from $title"
  enable_balloon $toplevel.frame0.frame1.frame3.listbox8

  # build widget $toplevel.frame0.frame1.frame4
  frame $toplevel.frame0.frame1.frame4 \
    -borderwidth {2}

  # build widget $toplevel.frame0.frame1.frame4.scrollbar9
  scrollbar $toplevel.frame0.frame1.frame4.scrollbar9 \
    -command "$toplevel.frame0.frame1.frame3.listbox8 yview" \
    -width {13}

  # build widget $toplevel.frame0.frame2
  frame $toplevel.frame0.frame2 \
    -borderwidth {1}

  # build widget $toplevel.frame0.frame2.frame5
  frame $toplevel.frame0.frame2.frame5 \
    -borderwidth {2}

  # build widget $toplevel.frame0.frame2.frame5.scrollbar10
  scrollbar $toplevel.frame0.frame2.frame5.scrollbar10 \
    -command "$toplevel.frame0.frame1.frame3.listbox8 xview" \
    -orient {horizontal} \
    -width {13}

  # build widget $toplevel.frame0.frame2.frame6
  frame $toplevel.frame0.frame2.frame6 \
    -borderwidth {2}

  # build widget $toplevel.frame0.frame2.frame6.frame11
  frame $toplevel.frame0.frame2.frame6.frame11 \
    -borderwidth {2} \
    -height {13} \
    -width {16}

  # build widget $toplevel.buttons
  frame $toplevel.buttons \
    -borderwidth {2}

  # build widget $toplevel.buttons.button2
  button $toplevel.buttons.button2 \
    -padx {9} \
    -pady {3} \
    -text {Delete Card} \
    -state disabled \
    -command  \
	"DeleteCardFromList $toplevel.frame0.frame1.frame3.listbox8"
  set help_tips($toplevel.buttons.button2) \
	{Delete the selected card}

  # build widget $toplevel.buttons.button3
  button $toplevel.buttons.button3 \
    -padx {9} \
    -pady {3} \
    -text {Dismis} \
    -command "RemoveTopLevel $toplevel"
  set help_tips($toplevel.buttons.button3) {Dismis this popup}

  # build widget $toplevel.buttons.button4
  button $toplevel.buttons.button4 \
    -padx {9} \
    -pady {3} \
    -text {Help} \
    -command {hl_Help {Generic Delete Id List dialog}}
  set help_tips($toplevel.buttons.button4) {Get detailed hellp}

  # pack master $toplevel.topFrame
  pack configure $toplevel.topFrame.icon -side left
  pack configure $toplevel.topFrame.bigLabel -side right -expand 1 -fill both

  # pack master $toplevel.frame0
  pack configure $toplevel.frame0.frame1 \
    -expand 1 \
    -fill both
  pack configure $toplevel.frame0.frame2 \
    -fill x \
    -side bottom

  # pack master $toplevel.frame0.frame1
  pack configure $toplevel.frame0.frame1.frame3 \
    -expand 1 \
    -fill both \
    -side left
  pack configure $toplevel.frame0.frame1.frame4 \
    -fill y \
    -side right

  # pack master $toplevel.frame0.frame1.frame3
  pack configure $toplevel.frame0.frame1.frame3.listbox8 \
    -expand 1 \
    -fill both \
    -side left

  # pack master $toplevel.frame0.frame1.frame4
  pack configure $toplevel.frame0.frame1.frame4.scrollbar9 \
    -expand 1 \
    -fill y

  # pack master $toplevel.frame0.frame2
  pack configure $toplevel.frame0.frame2.frame5 \
    -expand 1 \
    -fill both \
    -side left
  pack configure $toplevel.frame0.frame2.frame6 \
    -fill y \
    -side right

  # pack master $toplevel.frame0.frame2.frame5
  pack configure $toplevel.frame0.frame2.frame5.scrollbar10 \
    -expand 1 \
    -fill x \
    -side left

  # pack master $toplevel.frame0.frame2.frame6
  pack configure $toplevel.frame0.frame2.frame6.frame11 \
    -expand 1 \
    -fill both

  # pack master $toplevel.buttons
  pack configure $toplevel.buttons.button2 \
    -expand 1 \
    -side left
  pack configure $toplevel.buttons.button3 \
    -expand 1 \
    -side left
  pack configure $toplevel.buttons.button4 \
    -expand 1 \
    -side right

  # pack master $toplevel
  pack configure $toplevel.topFrame -fill x
  pack configure $toplevel.frame0 \
    -expand 1 \
    -fill both
  pack configure $toplevel.buttons \
    -fill x
# end of widget tree

}

proc DeleteCardFromList {lb} {
# Select a card to delete.
#
# Arguments:
# <in> lb -- the listbox with the selected card.
# [index] DeleteCardFromList!procedure

  set cs "[$lb curselection]"
  if {[llength "$cs"] < 1} {return}
  set item "[$lb get $cs]"
  set id "[string trim [string range $item 0 35]]"
  DeleteCardById "$id"
}

proc ExpandDeleteList {lb expFun} {
# Expand a selected author, title, or subject to delete.
#
# Arguments:
# <in> lb -- the listbox with the selected key.
# <in> expFun -- the function to expand the key.
# [index] ExpandDeleteList!procedure

  set cs "[$lb curselection]"
  if {[llength "$cs"] < 1} {return}
  set item "[$lb get $cs]"
  set itemList "[eval [list $expFun [list $item]]]"
  PopupIdDeleteList "$itemList" "Expanded from $item"
}


proc PopupAuthorDeleteList {list title} {
# Popup a list of authors to delete from.
#
# Arguments:
# <in> list -- the listbox to select from.
# <in> title -- the title to use.
# [index] PopupAuthorDeleteList!procedure

  PopupDeleteListList "$list" "$title" ExpandAuthors
}

proc PopupTitleDeleteList {list title} {
# Popup a list of titles to delete from.
#
# Arguments:
# <in> list -- the listbox to select from.
# <in> title -- the title to use.
# [index] PopupTitleDeleteList!procedure

  PopupDeleteListList "$list" "$title" ExpandTitles
}

proc PopupSubjectDeleteList {list title} {
# Popup a list of subjects to delete from.
#
# Arguments:
# <in> list -- the listbox to select from.
# <in> title -- the title to use.
# [index] PopupSubjectDeleteList!procedure

  PopupDeleteListList "$list" "$title" ExpandSubjects
}

proc PopupDeleteListList {itemList title expandFunction} {
# Pop up a list of items to delete.
#
# Arguments:
# <in> itemList -- list of items.
# <in> title -- the title to use.
# <in> expandFunction -- the expansion function to use.
# [index] PopupDeleteListList!procedure

  global help_tips

  for {set i 1} {[winfo exists .popUpList$i] == 1} {incr i} {}
  set toplevel ".popUpDeleteList$i"

  # build widget $toplevel
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy $toplevel"
  } {
    catch "destroy $toplevel"
  }
  toplevel $toplevel 

  # Window manager configurations
  wm maxsize $toplevel 1009 738
  wm minsize $toplevel 1 1
  wm title $toplevel "$title"
  AddTopLevel $toplevel
  wm protocol $toplevel WM_DELETE_WINDOW "RemoveTopLevel $toplevel"


  # build widget $toplevel.topFrame
  frame $toplevel.topFrame -borderwidth {2} -relief flat

  # build widget $toplevel.topFrame.icon
  label $toplevel.topFrame.icon \
    -image SmallFace -relief flat

  # build widget $toplevel.topFrame.bigLabel
  label $toplevel.topFrame.bigLabel \
    -bg yellow -fg brown \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -text "$title"

  # build widget $toplevel.frame0
  frame $toplevel.frame0 \
    -borderwidth {2}

  # build widget $toplevel.frame0.frame1
  frame $toplevel.frame0.frame1

  # build widget $toplevel.frame0.frame1.frame3
  frame $toplevel.frame0.frame1.frame3 \
    -borderwidth {2}

  # build widget $toplevel.frame0.frame1.frame3.listbox8
  listbox $toplevel.frame0.frame1.frame3.listbox8 \
    -height {16} \
    -width {60} \
    -selectmode single \
    -exportselection 0 \
    -font {-*-courier-bold-r-normal-*-*-120-*-*-*-*-*-*} \
    -xscrollcommand "$toplevel.frame0.frame2.frame5.scrollbar10 set" \
    -yscrollcommand "$toplevel.frame0.frame1.frame4.scrollbar9 set"
  bind $toplevel.frame0.frame1.frame3.listbox8 <1> \
	"$toplevel.buttons.button2 configure -state normal"
  bind $toplevel.frame0.frame1.frame3.listbox8 <Double-1> \
	"if \{\[winfo exists %W\]\} \{tkListboxBeginSelect %W \[%W index @%x,%y\]\};\
	$toplevel.buttons.button2 configure -state normal;\
	$toplevel.buttons.button2 invoke"
  foreach i $itemList {
    $toplevel.frame0.frame1.frame3.listbox8 insert end "$i"
  }
  set help_tips($toplevel.frame0.frame1.frame3.listbox8) \
	"List of items that expand from $title"
  enable_balloon $toplevel.frame0.frame1.frame3.listbox8

  # build widget $toplevel.frame0.frame1.frame4
  frame $toplevel.frame0.frame1.frame4 \
    -borderwidth {2}

  # build widget $toplevel.frame0.frame1.frame4.scrollbar9
  scrollbar $toplevel.frame0.frame1.frame4.scrollbar9 \
    -command "$toplevel.frame0.frame1.frame3.listbox8 yview" \
    -width {13}

  # build widget $toplevel.frame0.frame2
  frame $toplevel.frame0.frame2 \
    -borderwidth {1}

  # build widget $toplevel.frame0.frame2.frame5
  frame $toplevel.frame0.frame2.frame5 \
    -borderwidth {2}

  # build widget $toplevel.frame0.frame2.frame5.scrollbar10
  scrollbar $toplevel.frame0.frame2.frame5.scrollbar10 \
    -command "$toplevel.frame0.frame1.frame3.listbox8 xview" \
    -orient {horizontal} \
    -width {13}

  # build widget $toplevel.frame0.frame2.frame6
  frame $toplevel.frame0.frame2.frame6 \
    -borderwidth {2}

  # build widget $toplevel.frame0.frame2.frame6.frame11
  frame $toplevel.frame0.frame2.frame6.frame11 \
    -borderwidth {2} \
    -height {13} \
    -width {16}

  # build widget $toplevel.buttons
  frame $toplevel.buttons \
    -borderwidth {2}

  # build widget $toplevel.buttons.button2
  button $toplevel.buttons.button2 \
    -padx {9} \
    -pady {3} \
    -text {Expand Item} \
    -state disabled \
    -command  \
	[list ExpandDeleteList $toplevel.frame0.frame1.frame3.listbox8 $expandFunction]
  set help_tips($toplevel.buttons.button2) \
	{Expand item}

  # build widget $toplevel.buttons.button3
  button $toplevel.buttons.button3 \
    -padx {9} \
    -pady {3} \
    -text {Dismis} \
    -command "RemoveTopLevel $toplevel"
  set help_tips($toplevel.buttons.button3) {Dismis this popup}

  # build widget $toplevel.buttons.button4
  button $toplevel.buttons.button4 \
    -padx {9} \
    -pady {3} \
    -text {Help} \
    -command {hl_Help {Generic Delete List dialog}}
  set help_tips($toplevel.buttons.button4) {Get detailed hellp}

  # pack master $toplevel.topFrame
  pack configure $toplevel.topFrame.icon -side left
  pack configure $toplevel.topFrame.bigLabel -side right -expand 1 -fill both

  # pack master $toplevel.frame0
  pack configure $toplevel.frame0.frame1 \
    -expand 1 \
    -fill both
  pack configure $toplevel.frame0.frame2 \
    -fill x \
    -side bottom

  # pack master $toplevel.frame0.frame1
  pack configure $toplevel.frame0.frame1.frame3 \
    -expand 1 \
    -fill both \
    -side left
  pack configure $toplevel.frame0.frame1.frame4 \
    -fill y \
    -side right

  # pack master $toplevel.frame0.frame1.frame3
  pack configure $toplevel.frame0.frame1.frame3.listbox8 \
    -expand 1 \
    -fill both \
    -side left

  # pack master $toplevel.frame0.frame1.frame4
  pack configure $toplevel.frame0.frame1.frame4.scrollbar9 \
    -expand 1 \
    -fill y

  # pack master $toplevel.frame0.frame2
  pack configure $toplevel.frame0.frame2.frame5 \
    -expand 1 \
    -fill both \
    -side left
  pack configure $toplevel.frame0.frame2.frame6 \
    -fill y \
    -side right

  # pack master $toplevel.frame0.frame2.frame5
  pack configure $toplevel.frame0.frame2.frame5.scrollbar10 \
    -expand 1 \
    -fill x \
    -side left

  # pack master $toplevel.frame0.frame2.frame6
  pack configure $toplevel.frame0.frame2.frame6.frame11 \
    -expand 1 \
    -fill both

  # pack master $toplevel.buttons
  pack configure $toplevel.buttons.button2 \
    -expand 1 \
    -side left
  pack configure $toplevel.buttons.button3 \
    -expand 1 \
    -side left
  pack configure $toplevel.buttons.button4 \
    -expand 1 \
    -side right

  # pack master $toplevel
  pack configure $toplevel.topFrame -fill x
  pack configure $toplevel.frame0 \
    -expand 1 \
    -fill both
  pack configure $toplevel.buttons \
    -fill x
# end of widget tree

}

proc DeleteCardById {Id} {
# Delete a selected card.  Popup a confirm box before deleting the card.
#
# Arguments:
# <in> Id -- the id of the card to delete.
# [index] DeleteCardById!procedure

  set ans [hl_dialog .deleteConfirm "Deleting card $Id" \
		"Do you really want to delete card $Id?" \
		questhead 1 {Yes} {No}]
  if {$ans == 0} {
    global CurrentCardCatalog
    set authors "[$CurrentCardCatalog fetchauthors $Id]"
    set titles "[$CurrentCardCatalog fetchtitles $Id]"
    set subjects "[$CurrentCardCatalog fetchsubjs $Id]"
    $CurrentCardCatalog updatesubjs {} "$subjects" "$Id"
    foreach oa "$authors" {
      $CurrentCardCatalog updateauthor {} "$oa" "$Id"
    }
    foreach ot "$titles" {
      $CurrentCardCatalog updatetitle {} "$ot" "$Id"
    }
    $CurrentCardCatalog deleteid "$Id"
  }
}


proc CreateNewLibrary {} {
# Create a new, empty V2 card catalog.
# [index] CreateNewLibrary!procedure

  global HLTypes

  set fname [tk_getSaveFile -defaultextension {.libr} -initialfile new.libr \
			    -title "Select a new library name" \
			    -filetypes $HLTypes]
  if {[string length "$fname"] == 0} {return}
  catch [list file delete -force "$fname"]
  global NumNewPages
  set NumNewPages {}
  global help_tips

  # build widget .newLibr
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .newLibr"
  } {
    catch "destroy .newLibr"
  }
  toplevel .newLibr 

  # Window manager configurations
  wm maxsize .newLibr 1265 994
  wm minsize .newLibr 1 1
  wm title .newLibr {Select the number of pages to pre-allocate}
  wm transient  .newLibr .

  # build widget .newLibr.top
  frame .newLibr.top \
    -borderwidth {2}

  # build widget .newLibr.top.label2
  label .newLibr.top.label2 \
    -image {SmallFace}

  # build widget .newLibr.top.label3
  label .newLibr.top.label3 \
    -background {yellow} \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -foreground {brown} \
    -text {Select the number of pages to pre-allocate}

  # build widget .newLibr.numPagesFrame
  frame .newLibr.numPagesFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .newLibr.numPagesFrame.label8
  label .newLibr.numPagesFrame.label8 \
    -text {Number of Pages to pre-allocate: }

  # build widget .newLibr.numPagesFrame.numPages
  entry .newLibr.numPagesFrame.numPages \
    -exportselection 0
  bind .newLibr.numPagesFrame.numPages <Return> \
	{.newLibr.frame10.button12 invoke}
  enable_balloon .newLibr.numPagesFrame.numPages
  set help_tips(.newLibr.numPagesFrame.numPages) \
	{This is the custom number of pages to pre-allocate when creating the new library}

  # build widget .newLibr.frame10
  frame .newLibr.frame10 \
    -borderwidth {2}

  # build widget .newLibr.frame10.button11
  button .newLibr.frame10.button11 \
    -padx {11} \
    -pady {4} \
    -text {Use Default} \
    -command {
	  if {"[info procs XFEdit]" != ""} {
	    catch "XFDestroy .newLibr"
	  } {
	    catch "destroy .newLibr"
	  }
    }
  set help_tips(.newLibr.frame10.button11) \
	{Pre-allocate the default number of pages (24)}

  # build widget .newLibr.frame10.button12
  button .newLibr.frame10.button12 \
    -padx {11} \
    -pady {4} \
    -text {Use This Number} \
    -command {
	  global NumNewPages
	  set NumNewPages [.newLibr.numPagesFrame.numPages get]
	  if {![IsIntegerGTZero $NumNewPages]} {
	    set NumNewPages {}
	  } else {
	    if {"[info procs XFEdit]" != ""} {
	      catch "XFDestroy .newLibr"
	    } {
	      catch "destroy .newLibr"
	    }
	  }
    }
  set help_tips(.newLibr.frame10.button12) \
	{Select the number of pages to pre-allocate}

  # build widget .newLibr.frame10.button13
  button .newLibr.frame10.button13 \
    -padx {11} \
    -pady {4} \
    -takefocus 0 \
    -text {Help} \
    -command {hl_Help {Creating a new Card Catalog database}}

  # pack master .newLibr.top
  pack configure .newLibr.top.label2 \
    -fill y \
    -side left
  pack configure .newLibr.top.label3 \
    -fill x \
    -side right \
    -expand 1

  # pack master .newLibr.numPagesFrame
  pack configure .newLibr.numPagesFrame.label8 \
    -side left
  pack configure .newLibr.numPagesFrame.numPages \
    -expand 1 \
    -fill x \
    -side right

  # pack master .newLibr.frame10
  pack configure .newLibr.frame10.button11 \
    -expand 1 \
    -side left
  pack configure .newLibr.frame10.button12 \
    -expand 1 \
    -side left
  pack configure .newLibr.frame10.button13 \
    -expand 1 \
    -side right

  # pack master .newLibr
  pack configure .newLibr.top -fill x
  pack configure .newLibr.numPagesFrame \
    -fill x
  pack configure .newLibr.frame10 \
    -fill x

  .newLibr.numPagesFrame.numPages insert end {24}


# end of widget tree

  wm withdraw .newLibr
  update idletasks
  set x [expr [winfo screenwidth .newLibr]/2 - \
	      [winfo reqwidth .newLibr]/2 - \
	      [winfo vrootx .]]
  set y [expr [winfo screenheight .newLibr]/2 - \
	      [winfo reqheight .newLibr]/2 - \
	      [winfo vrooty .]]
  wm geom .newLibr +$x+$y
  wm deiconify .newLibr
  update idletasks
  focus .newLibr.numPagesFrame.numPages
  grab  .newLibr
  tkwait window  .newLibr

  global CurrentCardCatalog
  if {[string length "$NumNewPages"] == 0} {
    if {[catch [list vBTree "$fname" {Create|ReadWrite}] CurrentCardCatalog]} {
      hl_error $CurrentCardCatalog
      set CurrentCardCatalog {}
      return
    }
  } elseif {[catch [list vBTree "$fname" {Create|ReadWrite} $NumNewPages] CurrentCardCatalog]} {
    hl_error $CurrentCardCatalog
    set CurrentCardCatalog {}
    return
  }


  global tk_version
  if {$tk_version >= 8.0} {
    set fm {.menuBar.file}
  } else {
    set fm {.menuBar.fileButton.m}
  }
  $fm entryconfigure {New...} -state disabled
  $fm entryconfigure {Open...} -state disabled
  $fm entryconfigure {Import...} -state disabled
  $fm entryconfigure {Search...} -state disabled
  $fm entryconfigure {Close} -state normal
  $fm entryconfigure {Print...} -state normal
  $fm entryconfigure {Export...} -state normal
  if {$tk_version >= 8.0} {
    set sm {.menuBar.special}
  } else {
    set sm {.menuBar.specialButton.m}
  }
  $sm entryconfigure {Define a new Card Type} -state normal
  $sm entryconfigure {Define a new Location Type} -state normal
  $sm entryconfigure {Define a new Category} -state normal
  $sm entryconfigure {Create a template Card} -state normal
  $sm entryconfigure {Edit a template Card} -state normal
  $sm entryconfigure {Remove a template Card} -state normal
  $sm entryconfigure {Save Card template} -state normal
  $sm entryconfigure {Load Card templates} -state normal


  .auxFrame.messages configure -text "[file tail $fname] [$CurrentCardCatalog openstat]"

  pack forget .mainFrame.openFrame
  if {![winfo exists .mainFrame.editForm]} {editForm}
  pack configure .mainFrame.editForm \
	-expand 1 \
	-fill both

}

proc OpenOldLibrary {} {
# Open an old existing V1 or V2 library.
# [index] OpenOldLibrary!procedure

  global HLTypes
  set fname [tk_getOpenFile -defaultextension {.libr} \
			    -title "Select a library name" \
			    -filetypes $HLTypes]
  if {[string length "$fname"] == 0} {return}
  global CurrentCardCatalog
  if {[catch [list vBTree "$fname" {ReadWrite}] CurrentCardCatalog]} {
    hl_error $CurrentCardCatalog
    set CurrentCardCatalog {}
    return
  }


  global tk_version
  if {$tk_version >= 8.0} {
    set fm {.menuBar.file}
  } else {
    set fm {.menuBar.fileButton.m}
  }
  $fm entryconfigure {New...} -state disabled
  $fm entryconfigure {Open...} -state disabled
  $fm entryconfigure {Import...} -state disabled
  $fm entryconfigure {Search...} -state disabled
  $fm entryconfigure {Close} -state normal
  $fm entryconfigure {Print...} -state normal
  $fm entryconfigure {Export...} -state normal
  if {[$CurrentCardCatalog libraryversion] > 1} {
    if {$tk_version >= 8.0} {
      set sm {.menuBar.special}
    } else {
      set sm {.menuBar.specialButton.m}
    }
    $sm entryconfigure {Define a new Card Type} -state normal
    $sm entryconfigure {Define a new Location Type} -state normal
    $sm entryconfigure {Define a new Category} -state normal
    $sm entryconfigure {Create a template Card} -state normal
    $sm entryconfigure {Edit a template Card} -state normal
    $sm entryconfigure {Remove a template Card} -state normal
    $sm entryconfigure {Save Card template} -state normal
    $sm entryconfigure {Load Card templates} -state normal
  }

  .auxFrame.messages configure -text "[file tail $fname] [$CurrentCardCatalog openstat]"

  pack forget .mainFrame.openFrame
  if {![winfo exists .mainFrame.editForm]} {editForm}
  pack configure .mainFrame.editForm \
	-expand 1 \
	-fill both

}

proc SaveCurrentLibrary {} {
# Save the current library.
# [index] SaveCurrentLibrary!procedure

  global CurrentCardCatalog
  if {[string compare "$CurrentCardCatalog" {}] == 0} {return}
  set fname "[$CurrentCardCatalog filename]"
  $CurrentCardCatalog delete
  set CurrentCardCatalog {}
  if {[catch [list vBTree "$fname" {ReadWrite}] CurrentCardCatalog]} {
    hl_error $CurrentCardCatalog
    set CurrentCardCatalog {}
    return
  }
}

proc CardTypeOptionMenu {w toplevel} {
# Create a Card Type option menu.  Adapted from tk_optionMenu.
# [index] CardTypeOptionMenu!procedure

  global CurrentCardCatalog
  global TypeMenus
  upvar #0 $toplevel var

  if {![info exists var(Type)]} {
    set var(Type) {O}
  }

  menubutton $w -text "[$CurrentCardCatalog cardtypename $var(Type)]" -indicatoron 1 \
	-menu $w.menu -relief raised -bd 2 -highlightthickness 2 -anchor c \
	-takefocus 0
  menu $w.menu -tearoff 0
  foreach t {B M D C 8 A L V S E 4 O a b c d e f g h i j} {
    set tn "[$CurrentCardCatalog cardtypename $t]"
    if {[string compare "$tn" {}] == 0} {continue}
    $w.menu add command -label "$tn" -command [list settype "$toplevel" $w $t]
  }
  lappend TypeMenus [list $w $w.menu $toplevel]
  return $w.menu
}

proc FindMLEltGivenTL {ML tl} {
# Find a Menu List element, given a toplevel name.
# [index] FindMLEltGivenTL!procedure

  set len [llength "$ML"]
  for {set i 0} {$i < $len} {incr $i} {
    if {[string compare "$tl" "[lindex [lindex $ML $i] 2]"] == 0} {return $i}
  }
  return -1
}

proc RemoveCardTypeOptionMenu {toplevel} {
# Remove a card type option menu from the list of active card type option menus.
# [index] RemoveCardTypeOptionMenu!procedure

  global TypeMenus
  set idx [FindMLEltGivenTL $TypeMenus $toplevel]
  if {$idx < 0} {return}
  set TypeMenus [lreplace $TypeMenus $idx $idx]
} 

proc UpdateCardTypeOptionMenus {} {
# Update all card type option menus.
# [index] RemoveCardTypeOptionMenu!procedure

  global TypeMenus
  foreach tm $TypeMenus {UpdateCardTypeOptionMenu $tm}
}

proc UpdateCardTypeOptionMenu {tm} {
# Update one card type option menu.
# [index] UpdateCardTypeOptionMenu!procedure

  set w [lindex $tm 0]
  set wmenu [lindex $tm 1]
  set toplevel [lindex $tm 2]
  global CurrentCardCatalog
  global $toplevel
  upvar #0 $toplevel var
  $w configure  -text "[$CurrentCardCatalog cardtypename $var(Type)]"
  $wmenu delete 0 end
  foreach t {B M D C 8 A L V S E 4 O a b c d e f g h i j} {
    set tn "[$CurrentCardCatalog cardtypename $t]"
    if {[string compare "$tn" {}] == 0} {continue}
    $wmenu add command -label "$tn" -command [list settype "$toplevel" $w $t]
  }
}

proc settype {toplevel w t} {
# Update a card's type.
# [index] settype!procedure

  global CurrentCardCatalog
  global $toplevel
  upvar #0 $toplevel var

#  set var(Type) "$t"
  set $toplevel\(Type) "$t"
  $w configure -text "[$CurrentCardCatalog cardtypename $t]"
}

proc DefineNewCardType {} { 
# Define a new card type.
# [index] DefineNewCardType!procedure

  global CurrentCardCatalog
  # build widget .newCardType
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .newCardType"
  } {
    catch "destroy .newCardType"
  }
  toplevel .newCardType 

  # Window manager configurations
  wm maxsize .newCardType 1009 738
  wm minsize .newCardType 1 1
  wm title .newCardType {New Card Type}
  wm transient .newCardType .


  # build widget .newCardType.top
  frame .newCardType.top \
    -borderwidth {2}

  # build widget .newCardType.top.label2
  label .newCardType.top.label2 \
    -image {SmallFace}

  # build widget .newCardType.top.label3
  label .newCardType.top.label3 \
    -background {yellow} \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -foreground {brown} \
    -text {New Card Type}

  # build widget .newCardType.typeFrame
  frame .newCardType.typeFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .newCardType.typeFrame.typeCode
  menubutton .newCardType.typeFrame.typeCode \
    -text {UC1} \
    -menu {.newCardType.typeFrame.typeCode.menu} \
    -indicatoron 1 \
    -relief raised -bd 2 -highlightthickness 2 -anchor c \
    -takefocus 0

  # build widget .newCardType.typeFrame.typeCode.menu
  menu .newCardType.typeFrame.typeCode.menu -tearoff 0
  for {set i 0} {$i < 10} {incr i} {
    set tn [format {UC%d} [expr $i + 1]]
    set t [format {%c} [expr 65 + 32 + $i]]
    .newCardType.typeFrame.typeCode.menu add command \
	-label "$tn" \
	-command [list setNewTn .newCardType.typeFrame.typeEntry $t \
				.newCardType.typeFrame.typeCode $tn]
  }

  # build widget .newCardType.typeFrame.label4
  label .newCardType.typeFrame.label4 \
    -text {Type name:}

  # build widget .newCardType.typeFrame.typeEntry
  entry .newCardType.typeFrame.typeEntry \
    -exportselection {0}
  bind .newCardType.typeFrame.typeEntry <Return> \
	{.newCardType.buttons.button6 invoke}

  # build widget .newCardType.buttons
  frame .newCardType.buttons \
    -borderwidth {2}

  # build widget .newCardType.buttons.button6
  button .newCardType.buttons.button6 \
    -padx {9} \
    -pady {3} \
    -text {Add Type} \
    -command {
	  set t [format {%c} [expr 64 + 32 + int([string range [.newCardType.typeFrame.typeCode cget -text] 2 end])]]
	  set tn "[.newCardType.typeFrame.typeEntry get]"
	  global CurrentCardCatalog
	  $CurrentCardCatalog addcardtypename $t "$tn"
	  UpdateCardTypeOptionMenus
	  if {"[info procs XFEdit]" != ""} {
	    catch "XFDestroy .newCardType"
	  } {
	    catch "destroy .newCardType"
	  }
	}

  # build widget .newCardType.buttons.button7
  button .newCardType.buttons.button7 \
    -padx {9} \
    -pady {3} \
    -text {Abort} \
    -command {
	  if {"[info procs XFEdit]" != ""} {
	    catch "XFDestroy .newCardType"
	  } {
	    catch "destroy .newCardType"
	  }
	}

  # build widget .newCardType.buttons.button8
  button .newCardType.buttons.button8 \
    -padx {9} \
    -pady {3} \
    -text {Help} \
    -command {hl_Help {Defining a New Card Type}}

  # pack master .newCardType.top
  pack configure .newCardType.top.label2 \
    -fill y \
    -side left
  pack configure .newCardType.top.label3 \
    -expand 1 \
    -fill x \
    -side right

  # pack master .newCardType.typeFrame
  pack configure .newCardType.typeFrame.typeCode \
    -side left
  pack configure .newCardType.typeFrame.label4 \
    -side left
  pack configure .newCardType.typeFrame.typeEntry \
    -expand 1 \
    -fill x \
    -side right

  # pack master .newCardType.buttons
  pack configure .newCardType.buttons.button6 \
    -expand 1 \
    -side left
  pack configure .newCardType.buttons.button7 \
    -expand 1 \
    -side left
  pack configure .newCardType.buttons.button8 \
    -expand 1 \
    -side right

  # pack master .newCardType
  pack configure .newCardType.top \
    -fill x
  pack configure .newCardType.typeFrame \
    -fill x
  pack configure .newCardType.buttons \
    -fill x

  global CurrentCardCatalog
  .newCardType.typeFrame.typeEntry insert end "[$CurrentCardCatalog cardtypename a]"

# end of widget tree

  wm withdraw .newCardType
  update idletasks
  set x [expr [winfo screenwidth .newCardType]/2 - \
	      [winfo reqwidth .newCardType]/2 - \
	      [winfo vrootx .]]
  set y [expr [winfo screenheight .newCardType]/2 - \
	      [winfo reqheight .newCardType]/2 - \
	      [winfo vrooty .]]
  wm geom .newCardType +$x+$y
  wm deiconify .newCardType
  update idletasks
  focus .newCardType.typeFrame.typeEntry
  grab .newCardType
  tkwait window .newCardType  
 
}

proc setNewTn {entry t mb tn} {
# Insert the new card type into the library.
# [index] setNewTn!procedure

  global CurrentCardCatalog
  $mb configure -text "$tn"
  $entry delete 0 end
  $entry insert end "[$CurrentCardCatalog cardtypename $t]"
}

proc LocationTypeOptionMenu {w toplevel} {
# Create a location type menu.  Adapted from tk_optionMenu.
# [index] LocationTypeOptionMenu!procedure

  global CurrentCardCatalog
  global LocationMenus
  upvar #0 $toplevel var

  if {![info exists var(LocationType)]} {
    set var(LocationType) {U}
  }

  menubutton $w -text "[$CurrentCardCatalog locationtypename $var(LocationType)]" -indicatoron 1 \
	-menu $w.menu -relief raised -bd 2 -highlightthickness 2 -anchor c \
	-takefocus 0
  menu $w.menu -tearoff 0
  foreach t {S L O D s U a b c d e f g h i j} {
    set tn "[$CurrentCardCatalog locationtypename $t]"
    if {[string compare "$tn" {}] == 0} {continue}
    $w.menu add command -label "$tn" -command [list setltype "$toplevel" $w $t]
  }
  lappend LocationMenus [list $w $w.menu $toplevel]
  return $w.menu
}

proc RemoveLocationTypeOptionMenu {toplevel} {
# Remove a location type option menu from the list of active location type menus.
# [index] RemoveLocationTypeOptionMenu!procedure

  global LocationMenus
  set idx [FindMLEltGivenTL $LocationMenus $toplevel]
  if {$idx < 0} {return}
  set LocationMenus [lreplace $LocationMenus $idx $idx]
}

proc UpdateLocationTypeOptionMenus {} {
# Update all location type option menus.
# [index] UpdateLocationTypeOptionMenus!procedure

  global LocationMenus
  foreach lm $LocationMenus {UpdateLocationTypeOptionMenu $lm}
}

proc UpdateLocationTypeOptionMenu {lm} {
# Update one location type option menu.
# [index] UpdateLocationTypeOptionMenu!procedure

  set w [lindex $lm 0]
  set wmenu [lindex $lm 1]
  set toplevel [lindex $lm 2]
  global CurrentCardCatalog
  global $toplevel
  upvar #0 $toplevel var
  $w configure  -text "[$CurrentCardCatalog locationtypename $var(LocationType)]"
  $wmenu delete 0 end
  foreach t {S L O D s U a b c d e f g h i j} {
    set tn "[$CurrentCardCatalog locationtypename $t]"
    if {[string compare "$tn" {}] == 0} {continue}
    $wmenu add command -label "$tn" -command [list setltype "$toplevel" $w $t]
  }
}  

proc setltype {toplevel w t} {
# Update a cards location type.
# [index] setltype!procedure

  global CurrentCardCatalog
  global $toplevel
  upvar #0 $toplevel var

#  set var(LocationType) "$t"
  set $toplevel\(LocationType) "$t"
  $w configure -text "[$CurrentCardCatalog locationtypename $t]"
}


proc DefineNewLocationType {} { 
# Define a new location type.
# [index] DefineNewLocationType!procedure

  global CurrentCardCatalog
  # build widget .newLocationType
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .newLocationType"
  } {
    catch "destroy .newLocationType"
  }
  toplevel .newLocationType 

  # Window manager configurations
  wm maxsize .newLocationType 1009 738
  wm minsize .newLocationType 1 1
  wm title .newLocationType {New Location Type}
  wm transient .newLocationType .


  # build widget .newLocationType.top
  frame .newLocationType.top \
    -borderwidth {2}

  # build widget .newLocationType.top.label2
  label .newLocationType.top.label2 \
    -image {SmallFace}

  # build widget .newLocationType.top.label3
  label .newLocationType.top.label3 \
    -background {yellow} \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -foreground {brown} \
    -text {New Location Type}

  # build widget .newLocationType.typeFrame
  frame .newLocationType.typeFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .newLocationType.typeFrame.typeCode
  menubutton .newLocationType.typeFrame.typeCode \
    -text {UL1} \
    -menu {.newLocationType.typeFrame.typeCode.menu} \
    -indicatoron 1 \
    -relief raised -bd 2 -highlightthickness 2 -anchor c \
    -takefocus 0

  # build widget .newLocationType.typeFrame.typeCode.menu
  menu .newLocationType.typeFrame.typeCode.menu -tearoff 0
  for {set i 0} {$i < 10} {incr i} {
    set tn [format {UL%d} [expr $i + 1]]
    set t [format {%c} [expr 65 + 32 + $i]]
    .newLocationType.typeFrame.typeCode.menu add command \
	-label "$tn" \
	-command [list setNewLTn .newLocationType.typeFrame.typeEntry $t \
				.newLocationType.typeFrame.typeCode $tn]
  }

  # build widget .newLocationType.typeFrame.label4
  label .newLocationType.typeFrame.label4 \
    -text {Type name:}

  # build widget .newLocationType.typeFrame.typeEntry
  entry .newLocationType.typeFrame.typeEntry \
    -exportselection {0}
  bind .newLocationType.typeFrame.typeEntry <Return> \
  	{.newLocationType.buttons.button6 invoke}

  # build widget .newLocationType.buttons
  frame .newLocationType.buttons \
    -borderwidth {2}

  # build widget .newLocationType.buttons.button6
  button .newLocationType.buttons.button6 \
    -padx {9} \
    -pady {3} \
    -text {Add Type} \
    -command {
	  set t [format {%c} [expr 64 + 32 + int([string range [.newLocationType.typeFrame.typeCode cget -text] 2 end])]]
	  set tn "[.newLocationType.typeFrame.typeEntry get]"
	  global CurrentCardCatalog
	  $CurrentCardCatalog addlocationtypename $t "$tn"
	  UpdateLocationTypeOptionMenus
	  if {"[info procs XFEdit]" != ""} {
	    catch "XFDestroy .newLocationType"
	  } {
	    catch "destroy .newLocationType"
	  }
	}

  # build widget .newLocationType.buttons.button7
  button .newLocationType.buttons.button7 \
    -padx {9} \
    -pady {3} \
    -text {Abort} \
    -command {
	  if {"[info procs XFEdit]" != ""} {
	    catch "XFDestroy .newLocationType"
	  } {
	    catch "destroy .newLocationType"
	  }
	}

  # build widget .newLocationType.buttons.button8
  button .newLocationType.buttons.button8 \
    -padx {9} \
    -pady {3} \
    -text {Help} \
    -command {hl_Help {Defining a New Location Type}}

  # pack master .newLocationType.top
  pack configure .newLocationType.top.label2 \
    -fill y \
    -side left
  pack configure .newLocationType.top.label3 \
    -expand 1 \
    -fill x \
    -side right

  # pack master .newLocationType.typeFrame
  pack configure .newLocationType.typeFrame.typeCode \
    -side left
  pack configure .newLocationType.typeFrame.label4 \
    -side left
  pack configure .newLocationType.typeFrame.typeEntry \
    -expand 1 \
    -fill x \
    -side right

  # pack master .newLocationType.buttons
  pack configure .newLocationType.buttons.button6 \
    -expand 1 \
    -side left
  pack configure .newLocationType.buttons.button7 \
    -expand 1 \
    -side left
  pack configure .newLocationType.buttons.button8 \
    -expand 1 \
    -side right

  # pack master .newLocationType
  pack configure .newLocationType.top \
    -fill x
  pack configure .newLocationType.typeFrame \
    -fill x
  pack configure .newLocationType.buttons \
    -fill x

  global CurrentCardCatalog
  .newLocationType.typeFrame.typeEntry insert end "[$CurrentCardCatalog locationtypename a]"

# end of widget tree

  wm withdraw .newLocationType
  update idletasks
  set x [expr [winfo screenwidth .newLocationType]/2 - \
	      [winfo reqwidth .newLocationType]/2 - \
	      [winfo vrootx .]]
  set y [expr [winfo screenheight .newLocationType]/2 - \
	      [winfo reqheight .newLocationType]/2 - \
	      [winfo vrooty .]]
  wm geom .newLocationType +$x+$y
  wm deiconify .newLocationType
  update idletasks
  focus .newLocationType.typeFrame.typeEntry
  grab .newLocationType
  tkwait window .newLocationType  
 
}

proc setNewLTn {entry t mb tn} {
# Insert a new location type into the library.
# [index] setNewLTn!procedure

  global CurrentCardCatalog
  $mb configure -text "$tn"
  $entry delete 0 end
  $entry insert end "[$CurrentCardCatalog locationtypename $t]"
}

proc CategoryOptionMenu {w toplevel} {
# Create a Categort option menu.  Adapted from tk_optionMenu.
# [index] CategoryOptionMenu!procedure

  global CurrentCardCatalog
  global CategoryMenus
  upvar #0 $toplevel var

  if {![info exists var(Category)]} {
    set var(Category) 0
  }
  menubutton $w -text "[$CurrentCardCatalog category $var(Category)]" -indicatoron 1 \
	-menu $w.menu -relief raised -bd 2 -highlightthickness 2 -anchor c \
	-takefocus 0
  menu $w.menu -tearoff 0
  for {set t 0} {$t < 256} {incr t} {
    set tn "[$CurrentCardCatalog category $t]"
    if {[string compare "$tn" {}] == 0} {continue}
    $w.menu add command -label "$tn" -command [list setccode "$toplevel" $w "$t"]
  }
  lappend CategoryMenus [list $w $w.menu $toplevel]
  return $w.menu
}

proc RemoveCategoryOptionMenu {toplevel} { 
# Remove a Category option menu from the list of active Category option menus.
# [index] RemoveCategoryOptionMenu!procedure

  global CategoryMenus
  set idx [FindMLEltGivenTL $CategoryMenus $toplevel]
  if {$idx < 0} {return}
  set CategoryMenus [lreplace $CategoryMenus $idx $idx]
}

proc UpdateCategoryOptionMenus {} {
# Update all Category Option Menus.
# [index] UpdateCategoryOptionMenus!procedure

  global CategoryMenus
  foreach cm $CategoryMenus {UpdateCategoryOptionMenu $cm}
}

proc UpdateCategoryOptionMenu {cm} {
# Update one Category Option Menu.
# [index] UpdateCategoryOptionMenu!procedure

  set w [lindex $cm 0]
  set wmenu [lindex $cm 1]
  set toplevel [lindex $cm 2]  
  global CurrentCardCatalog
  global CategoryMenus
  upvar #0 $toplevel var

  $w configure -text "[$CurrentCardCatalog category $var(Category)]"
  $wmenu delete 0 end
  for {set t 0} {$t < 256} {incr t} {
    set tn "[$CurrentCardCatalog category $t]"
    if {[string compare "$tn" {}] == 0} {continue}
    $wmenu add command -label "$tn" -command [list setccode "$toplevel" $w "$t"]
  }
}
  

proc setccode  {toplevel w t} {
# Update a card's catcode.
# [index] setccode!procedure

  global CurrentCardCatalog
  global $toplevel
  upvar #0 $toplevel var

#  set var(Category) $t
  set $toplevel\(Category) $t
  $w configure -text "[$CurrentCardCatalog category $t]"
}

proc DefineNewCategory {} {
# Define a new category.
# [index] DefineNewCategory!procedure

  global CurrentCardCatalog
  # build widget .newCategory
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .newCategory"
  } {
    catch "destroy .newCategory"
  }
  toplevel .newCategory 

  # Window manager configurations
  wm positionfrom .newCategory ""
  wm sizefrom .newCategory ""
  wm maxsize .newCategory 1009 738
  wm minsize .newCategory 1 1
  wm title .newCategory {New Category}


  # build widget .newCategory.top
  frame .newCategory.top \
    -borderwidth {2}

  # build widget .newCategory.top.label2
  label .newCategory.top.label2 \
    -image {SmallFace}

  # build widget .newCategory.top.label3
  label .newCategory.top.label3 \
    -background {yellow} \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -foreground {brown} \
    -text {New Category}

  # build widget .newCategory.catFrame
  frame .newCategory.catFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .newCategory.catFrame.ccodeScale
  scale .newCategory.catFrame.ccodeScale \
    -command {setNewCat .newCategory.catFrame.category} \
    -label {Cat Code} \
    -from {0} \
    -to {255}

  # build widget .newCategory.catFrame.label11
  label .newCategory.catFrame.label11 \
    -text {Category:}

  # build widget .newCategory.catFrame.category
  entry .newCategory.catFrame.category \
    -exportselection {0}
  bind .newCategory.catFrame.category <Return> \
	{.newCategory.buttons.button6 invoke}

  # build widget .newCategory.buttons
  frame .newCategory.buttons \
    -borderwidth {2}

  # build widget .newCategory.buttons.button6
  button .newCategory.buttons.button6 \
    -padx {9} \
    -pady {3} \
    -text {Add Category} \
    -command {
	  global CurrentCardCatalog
	  $CurrentCardCatalog addcategory \
		[expr int([.newCategory.catFrame.ccodeScale get])] \
		"[.newCategory.catFrame.category get]"
	  UpdateCategoryOptionMenus
	  if {"[info procs XFEdit]" != ""} {
	    catch "XFDestroy .newCategory"
	  } {
	    catch "destroy .newCategory"
	  }
	}

  # build widget .newCategory.buttons.button7
  button .newCategory.buttons.button7 \
    -padx {9} \
    -pady {3} \
    -text {Abort} \
    -command {
	  if {"[info procs XFEdit]" != ""} {
	    catch "XFDestroy .newCategory"
	  } {
	    catch "destroy .newCategory"
	  }
	}

  # build widget .newCategory.buttons.button8
  button .newCategory.buttons.button8 \
    -padx {9} \
    -pady {3} \
    -text {Help} \
    -command {hl_Help {Defining a New Category}}

  # pack master .newCategory.top
  pack configure .newCategory.top.label2 \
    -fill y \
    -side left
  pack configure .newCategory.top.label3 \
    -expand 1 \
    -fill x \
    -side right

  # pack master .newCategory.catFrame
  pack configure .newCategory.catFrame.ccodeScale \
    -side left
  pack configure .newCategory.catFrame.label11 \
    -side left
  pack configure .newCategory.catFrame.category \
    -expand 1 \
    -fill x \
    -side right

  # pack master .newCategory.buttons
  pack configure .newCategory.buttons.button6 \
    -expand 1 \
    -side left
  pack configure .newCategory.buttons.button7 \
    -expand 1 \
    -side left
  pack configure .newCategory.buttons.button8 \
    -expand 1 \
    -side right

  # pack master .newCategory
  pack configure .newCategory.top \
    -fill x
  pack configure .newCategory.catFrame \
    -fill x
  pack configure .newCategory.buttons \
    -fill x

  global CurrentCardCatalog
  .newCategory.catFrame.category insert end "[$CurrentCardCatalog category 0]"


# end of widget tree


  wm withdraw .newCategory
  update idletasks
  set x [expr [winfo screenwidth .newCategory]/2 - \
	      [winfo reqwidth .newCategory]/2 - \
	      [winfo vrootx .]]
  set y [expr [winfo screenheight .newCategory]/2 - \
	      [winfo reqheight .newCategory]/2 - \
	      [winfo vrooty .]]
  wm geom .newCategory +$x+$y
  wm deiconify .newCategory
  update idletasks
  focus .newCategory.catFrame.category
  grab .newCategory
  tkwait window .newCategory  
 


}

proc setNewCat {entry ccode} {
# Insert a new category into the library.
# [index] setNewCat!procedure

  global CurrentCardCatalog
  set ccode [expr int($ccode)]
  $entry delete 0 end
  $entry insert end "[$CurrentCardCatalog category $ccode]"
}

proc CopyCardRecord {cr} {
# Copy a card record.
# [index] CopyCardRecord!procedure

  set newRecord [CardRecord]
  foreach f {title author cardtype publisher city year vol categorycode 
	     locationtype locationdetail description} {
    $newRecord $f "[$cr $f]"
  }
  return $newRecord
}

proc SelectTemplate {} {
# Select a template to create or edit.
# [index] SelectTemplate!procedure

  global SelectedTemplate
  set SelectedTemplate {}
  global help_tips
  global TemplateCards

  # build widget .selectTemplate
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .selectTemplate"
  } {
    catch "destroy .selectTemplate"
  }
  toplevel .selectTemplate 

  # Window manager configurations
  wm maxsize .selectTemplate 1009 738
  wm minsize .selectTemplate 1 1
  wm title .selectTemplate {Select A Template Card}
  wm transient .selectTemplate .


  # build widget .selectTemplate.top
  frame .selectTemplate.top \
    -borderwidth {2}

  # build widget .selectTemplate.top.label2
  label .selectTemplate.top.label2 \
    -image {SmallFace}

  # build widget .selectTemplate.top.label3
  label .selectTemplate.top.label3 \
    -background {yellow} \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -foreground {brown} \
    -text {Select a template card}

  # build widget .selectTemplate.frame0
  frame .selectTemplate.frame0 \
    -borderwidth {2}

  # build widget .selectTemplate.frame0.frame1
  frame .selectTemplate.frame0.frame1

  # build widget .selectTemplate.frame0.frame1.frame3
  frame .selectTemplate.frame0.frame1.frame3 \
    -borderwidth {2}

  # build widget .selectTemplate.frame0.frame1.frame3.listbox8
  listbox .selectTemplate.frame0.frame1.frame3.listbox8 \
    -selectmode single \
    -xscrollcommand {.selectTemplate.frame0.frame2.frame5.scrollbar10 set} \
    -yscrollcommand {.selectTemplate.frame0.frame1.frame4.scrollbar9 set} \
    -exportselection 0
  bind .selectTemplate.frame0.frame1.frame3.listbox8 <Double-1> \
    {.selectTemplate.buttons.button5 invoke}
  foreach tc [array names TemplateCards] {
    .selectTemplate.frame0.frame1.frame3.listbox8 insert end "$tc"
  }

  # build widget .selectTemplate.frame0.frame1.frame4
  frame .selectTemplate.frame0.frame1.frame4 \
    -borderwidth {2}

  # build widget .selectTemplate.frame0.frame1.frame4.scrollbar9
  scrollbar .selectTemplate.frame0.frame1.frame4.scrollbar9 \
    -command {.selectTemplate.frame0.frame1.frame3.listbox8 yview} \
    -width {13}

  # build widget .selectTemplate.frame0.frame2
  frame .selectTemplate.frame0.frame2 \
    -borderwidth {1}

  # build widget .selectTemplate.frame0.frame2.frame5
  frame .selectTemplate.frame0.frame2.frame5 \
    -borderwidth {2}

  # build widget .selectTemplate.frame0.frame2.frame5.scrollbar10
  scrollbar .selectTemplate.frame0.frame2.frame5.scrollbar10 \
    -command {.selectTemplate.frame0.frame1.frame3.listbox8 xview} \
    -orient {horizontal} \
    -width {13}

  # build widget .selectTemplate.frame0.frame2.frame6
  frame .selectTemplate.frame0.frame2.frame6 \
    -borderwidth {2}

  # build widget .selectTemplate.frame0.frame2.frame6.frame11
  frame .selectTemplate.frame0.frame2.frame6.frame11 \
    -borderwidth {2} \
    -height {13} \
    -width {16}

  # build widget .selectTemplate.buttons
  frame .selectTemplate.buttons \
    -borderwidth {2}

  # build widget .selectTemplate.buttons.button5
  button .selectTemplate.buttons.button5 \
    -padx {9} \
    -pady {3} \
    -text {OK} \
    -command {
	global SelectedTemplate
	set cs "[.selectTemplate.frame0.frame1.frame3.listbox8 curselection]"
	if {[llength "$cs"] < 1} {return}
	set SelectedTemplate "[.selectTemplate.frame0.frame1.frame3.listbox8 get $cs]"
	if {"[info procs XFEdit]" != ""} {
	  catch "XFDestroy .selectTemplate"
	} {
	  catch "destroy .selectTemplate"
	}
    }

  # build widget .selectTemplate.buttons.button6
  button .selectTemplate.buttons.button6 \
    -padx {9} \
    -pady {3} \
    -text {Cancel} \
    -command {
	global SelectedTemplate
	set SelectedTemplate {}
	if {"[info procs XFEdit]" != ""} {
	  catch "XFDestroy .selectTemplate"
	} {
	  catch "destroy .selectTemplate"
	}
    }

  # build widget .selectTemplate.buttons.button7
  button .selectTemplate.buttons.button7 \
    -padx {9} \
    -pady {3} \
    -text {Help} \
    -command {hl_Help {Selecting a template}}

  # pack master .selectTemplate.top
  pack configure .selectTemplate.top.label2 \
    -fill y \
    -side left
  pack configure .selectTemplate.top.label3 \
    -expand 1 \
    -fill x \
    -side right

  # pack master .selectTemplate.frame0
  pack configure .selectTemplate.frame0.frame1 \
    -expand 1 \
    -fill both
  pack configure .selectTemplate.frame0.frame2 \
    -fill x \
    -side bottom

  # pack master .selectTemplate.frame0.frame1
  pack configure .selectTemplate.frame0.frame1.frame3 \
    -expand 1 \
    -fill both \
    -side left
  pack configure .selectTemplate.frame0.frame1.frame4 \
    -fill y \
    -side right

  # pack master .selectTemplate.frame0.frame1.frame3
  pack configure .selectTemplate.frame0.frame1.frame3.listbox8 \
    -expand 1 \
    -fill both \
    -side left

  # pack master .selectTemplate.frame0.frame1.frame4
  pack configure .selectTemplate.frame0.frame1.frame4.scrollbar9 \
    -expand 1 \
    -fill y

  # pack master .selectTemplate.frame0.frame2
  pack configure .selectTemplate.frame0.frame2.frame5 \
    -expand 1 \
    -fill both \
    -side left
  pack configure .selectTemplate.frame0.frame2.frame6 \
    -fill y \
    -side right

  # pack master .selectTemplate.frame0.frame2.frame5
  pack configure .selectTemplate.frame0.frame2.frame5.scrollbar10 \
    -expand 1 \
    -fill x \
    -side left

  # pack master .selectTemplate.frame0.frame2.frame6
  pack configure .selectTemplate.frame0.frame2.frame6.frame11 \
    -expand 1 \
    -fill both

  # pack master .selectTemplate.buttons
  pack configure .selectTemplate.buttons.button5 \
    -expand 1 \
    -side left
  pack configure .selectTemplate.buttons.button6 \
    -expand 1 \
    -side left
  pack configure .selectTemplate.buttons.button7 \
    -expand 1 \
    -side right

  # pack master .selectTemplate
  pack configure .selectTemplate.top \
    -fill x
  pack configure .selectTemplate.frame0 \
    -expand 1 \
    -fill both
  pack configure .selectTemplate.buttons \
    -fill x
# end of widget tree

  wm withdraw .selectTemplate
  update idletasks
  set x [expr [winfo screenwidth .selectTemplate]/2 - \
	      [winfo reqwidth .selectTemplate]/2 - \
	      [winfo vrootx .]]
  set y [expr [winfo screenheight .selectTemplate]/2 - \
	      [winfo reqheight .selectTemplate]/2 - \
	      [winfo vrooty .]]
  wm geom .selectTemplate +$x+$y
  wm deiconify .selectTemplate
  update idletasks
  grab .selectTemplate
  tkwait window .selectTemplate

  if {[string compare "$SelectedTemplate" {}] == 0} {
    return {}
  } else {
    return "[list $SelectedTemplate $TemplateCards($SelectedTemplate)]"
  }
}

proc EditCardById {Id} {
# Edit a selected card by id.
# [index] EditCardById!procedure

  global CurrentCardCatalog
  set Id "[string toupper [string trim $Id]]"
  set OldCard [$CurrentCardCatalog readid "$Id"]
  set OldAuthors {}
  set OldTitles {}
  set OldSubjects {}
  if {[string compare "$OldCard" {}] == 0} {
    set answer [hl_dialog .newCardBox "Create New Card?" \
		   "Card $Id does not exist, create a new card?" \
		   questhead 1 {Yes} {No}]
    if {$answer == 1} {return}
    set selectedTemplate "[SelectTemplate]"
    if {[string compare "$selectedTemplate" {}] == 0} {return}
    set selectedTemplate [lindex $selectedTemplate 1]
    set OldCard [CopyCardRecord [lindex $selectedTemplate 0]]
    set OldAuthors "[lindex $selectedTemplate 1]"
    set OldTitles "[lindex $selectedTemplate 2]"
  } else {
    set OldAuthors "[$CurrentCardCatalog fetchauthors $Id]"
    set OldTitles "[$CurrentCardCatalog fetchtitles $Id]"
    set OldSubjects "[$CurrentCardCatalog fetchsubjs $Id]"
  }
  EditCard "$Id" $OldCard SaveCardInLibrary \
	-subjects "$OldSubjects" \
	-authors "$OldAuthors" \
	-titles "$OldTitles"
}
    
proc SetDifference {s1 s2} {
# Compute the set difference of s1 minus s2.
# [index] SetDifference!procedure

  set result {}
  foreach e1 $s1 {
    if {[lsearchexactnocase "$s2" "$e1"] < 0} {
      lappend result "$e1"
    }
  }
  return "$result"
}

proc SaveCardInLibrary {Id record toplevel SaveP} {
# Save a selected card into the library.
# [index] SaveCardInLibrary!procedure

  if {$SaveP} {
    upvar #0 $toplevel card
    $record title "$card(Title)"
    $record author "$card(Author)"
    $record cardtype $card(Type)
    $record publisher "$card(Publisher)"
    $record city "$card(City)"
    $record year $card(Year)
    $record vol $card(Volume)
    $record categorycode $card(Category)
    $record locationtype $card(LocationType)
    $record locationdetail "$card(LocationDetail)"
    $record description "$card(Description)"
    global CurrentCardCatalog
    $CurrentCardCatalog insertid "$Id" $record
    $CurrentCardCatalog updatesubjs "$card(Subjects)" "$card(OldSubjects)" "$Id"
    # update: $card(Authors) and $card(Titles) 
    # from $card(Author) and $card(Title), if non empty.
    set DeletedAuthors "[SetDifference $card(OldAuthors) $card(Authors)]"
    if {[llength "$DeletedAuthors"] > 0} {
      foreach oa "$DeletedAuthors" {
	$CurrentCardCatalog updateauthor {} "$oa" "$Id"
      }
    }
    set InsertedAuthors "[SetDifference $card(Authors) $card(OldAuthors)]"
    if {[llength "$InsertedAuthors"] > 0} {
      foreach na "$InsertedAuthors" {
	$CurrentCardCatalog updateauthor "$na" {} "$Id"
      }
    }
    set DeletedTitles "[SetDifference $card(OldTitles) $card(Titles)]"
    if {[llength "$DeletedTitles"] > 0} {
      foreach ot "$DeletedTitles" {
	$CurrentCardCatalog updatetitle {} "$ot" "$Id"
      }
    }
    set InsertedTitles "[SetDifference $card(Titles) $card(OldTitles)]"
    if {[llength "$InsertedTitles"] > 0} {
      foreach nt "$InsertedTitles" {
	$CurrentCardCatalog updatetitle "$nt" {} "$Id"
      }
    }
  }
  $record delete
}


proc EditCard {Id OldCardRecord SaveFunction args} {
# Edit a selected card.
# [index] EditCard!procedure

  global CurrentCardCatalog

  for {set i 1} {[winfo exists .editCard$i] == 1} {incr i} {}
  set toplevel ".editCard$i"
  global $toplevel
  catch "unset $toplevel"

  set $toplevel\(Subjects) {}
  set $toplevel\(OldSubjects) {}
  set $toplevel\(Authors) {}
  set $toplevel\(OldAuthors) {}
  set $toplevel\(Titles) {}
  set $toplevel\(OldTitles) {}
  set $toplevel\(DoSubjects) 1

  set ac [llength $args]
  for {set iac 0} {$iac < $ac} {incr iac} {
    switch -exact -- "[lindex $args $iac]" {
      -dontdosubjects {
		set $toplevel\(DoSubjects) 0
      }
      -subjects {
	incr iac
	if {$iac < $ac} {
	   set $toplevel\(Subjects) "[lindex $args $iac]"
	   set $toplevel\(OldSubjects) "[lindex $args $iac]"
	} else {
	   hl_error "EditCard: Value missing for -subjects"
	   return
	}
      }
      -authors {
	incr iac
	if {$iac < $ac} {
	   set $toplevel\(Authors) "[lindex $args $iac]"
	   set $toplevel\(OldAuthors) "[lindex $args $iac]"
	} else {
	   hl_error "EditCard: Value missing for -authors"
	   return
	}
      }
      -titles {
	incr iac
	if {$iac < $ac} {
	   set $toplevel\(Titles) "[lindex $args $iac]"
	   set $toplevel\(OldTitles) "[lindex $args $iac]"
	} else {
	   hl_error "EditCard: Value missing for -titles"
	   return
	}
      }
      default {
	hl_error "EditCard: unknown option [lindex $args $iac]"
	return
      }
    }
  }

  set doSubjects [set $toplevel\(DoSubjects)]

  # build widget $toplevel
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy $toplevel"
  } {
    catch "destroy $toplevel"
  }
  toplevel $toplevel 

  # Window manager configurations
  wm positionfrom $toplevel ""
  wm sizefrom $toplevel ""
  wm maxsize $toplevel 1009 738
  wm minsize $toplevel 1 1
  wm protocol $toplevel WM_DELETE_WINDOW \
	[list SaveOrAbortEditCard "$Id" $OldCardRecord $SaveFunction $toplevel]
  wm title $toplevel "Editing Card $Id"
  AddTopLevel $toplevel


  # build widget $toplevel.top
  frame $toplevel.top

  # build widget $toplevel.top.label8
  label $toplevel.top.label8 \
    -image {SmallFace}

  # build widget $toplevel.top.label9
  label $toplevel.top.label9 \
    -background {yellow} \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -foreground {brown} \
    -text "Editing card $Id"

  # build widget $toplevel.idFrame
  frame $toplevel.idFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $toplevel.idFrame.label11
  label $toplevel.idFrame.label11 \
    -text {Identification:}

  # build widget $toplevel.idFrame.label12
  label $toplevel.idFrame.label12 \
    -foreground {blue} \
    -text "$Id"

  # build widget $toplevel.idFrame.frame13
  frame $toplevel.idFrame.frame13

  # build widget $toplevel.titleFrame
  frame $toplevel.titleFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $toplevel.titleFrame.label20
  label $toplevel.titleFrame.label20 \
    -text {Title:}

  # build widget $toplevel.titleFrame.entry21
  entry $toplevel.titleFrame.entry21 \
    -foreground {blue} \
    -textvariable "$toplevel\(Title)" \
    -exportselection 0
  bind $toplevel.titleFrame.entry21 <Return> \
	"CheckList {Titles} $toplevel Title Titles"
  set $toplevel\(Title) "[$OldCardRecord title]"

  # build widget $toplevel.titleFrame.button22
  button $toplevel.titleFrame.button22 \
    -text {Indexed Titles} \
    -takefocus 0 \
    -command "DoIndexList {Titles} $toplevel Title Titles"

  # build widget $toplevel.authorFrame
  frame $toplevel.authorFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $toplevel.authorFrame.label20
  label $toplevel.authorFrame.label20 \
    -text {Author:}

  # build widget $toplevel.authorFrame.entry21
  entry $toplevel.authorFrame.entry21 \
    -foreground {blue} \
    -textvariable "$toplevel\(Author)" \
    -exportselection 0
  bind $toplevel.authorFrame.entry21 <Return> \
	"CheckList {Authors} $toplevel Author Authors"
  set $toplevel\(Author) "[$OldCardRecord author]"

  # build widget $toplevel.authorFrame.button22
  button $toplevel.authorFrame.button22 \
    -text {Indexed Authors} \
    -takefocus 0 \
    -command "DoIndexList {Authors} $toplevel Author Authors"

  # build widget $toplevel.typeFrame
  frame $toplevel.typeFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $toplevel.typeFrame.label23
  label $toplevel.typeFrame.label23 \
    -text {Type:}

  set $toplevel\(Type) "[$OldCardRecord cardtype]"
  CardTypeOptionMenu $toplevel.typeFrame.menubutton24 $toplevel

  # build widget $toplevel.typeFrame.button25
  button $toplevel.typeFrame.button25 \
    -padx {9} \
    -pady {3} \
    -text {New Type} \
    -command {DefineNewCardType}
  if {[$CurrentCardCatalog libraryversion] < 2} {
    $toplevel.typeFrame.button25 configure -state disabled
  }

  # build widget $toplevel.publisherFrame
  frame $toplevel.publisherFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $toplevel.publisherFrame.label27
  label $toplevel.publisherFrame.label27 \
    -text {Published By:}

  # build widget $toplevel.publisherFrame.entry28
  entry $toplevel.publisherFrame.entry28 \
    -foreground {blue} \
    -textvariable "$toplevel\(Publisher)" \
    -exportselection 0
  set $toplevel\(Publisher) "[$OldCardRecord publisher]"

  # build widget $toplevel.publisherFrame.label29
  label $toplevel.publisherFrame.label29 \
    -foreground {black} \
    -text {of}

  # build widget $toplevel.publisherFrame.entry30
  entry $toplevel.publisherFrame.entry30 \
    -foreground {blue} \
    -textvariable "$toplevel\(City)" \
    -exportselection 0
  set $toplevel\(City) "[$OldCardRecord city]"

  # build widget $toplevel.publisherFrame.label31
  label $toplevel.publisherFrame.label31 \
    -text {in the year}

  # build widget $toplevel.publisherFrame.entry32
  entry $toplevel.publisherFrame.entry32 \
    -foreground {blue} \
    -textvariable "$toplevel\(Year)" \
    -exportselection 0
  set $toplevel\(Year_old) [$OldCardRecord year]
  set $toplevel\(Year) [$OldCardRecord year]

  # build widget $toplevel.volumeCatFrame
  frame $toplevel.volumeCatFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $toplevel.volumeCatFrame.label33
  label $toplevel.volumeCatFrame.label33 \
    -text {Volume:}

  # build widget $toplevel.volumeCatFrame.entry34
  entry $toplevel.volumeCatFrame.entry34 \
    -foreground {blue} \
    -textvariable "$toplevel\(Volume)" \
    -exportselection 0
  set $toplevel\(Volume_old) [$OldCardRecord vol]
  set $toplevel\(Volume) [$OldCardRecord vol]

  # build widget $toplevel.volumeCatFrame.label35
  label $toplevel.volumeCatFrame.label35 \
    -text {, Category:}

  set $toplevel\(Category) "[$OldCardRecord categorycode]"
  CategoryOptionMenu $toplevel.volumeCatFrame.menubutton36 $toplevel

  # build widget $toplevel.volumeCatFrame.button37
  button $toplevel.volumeCatFrame.button37 \
    -padx {9} \
    -pady {3} \
    -text {New Category} \
    -command {DefineNewCategory}
  if {[$CurrentCardCatalog libraryversion] < 2} {
    $toplevel.volumeCatFrame.button37 configure -state disabled
  }

  # build widget $toplevel.locationFrame
  frame $toplevel.locationFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $toplevel.locationFrame.label38
  label $toplevel.locationFrame.label38 \
    -text {Location:}

  set $toplevel\(LocationType) "[$OldCardRecord locationtype]"
  LocationTypeOptionMenu $toplevel.locationFrame.menubutton39 $toplevel  

  # build widget $toplevel.locationFrame.button40
  button $toplevel.locationFrame.button40 \
    -padx {9} \
    -pady {3} \
    -text {New Location Type} \
    -command {DefineNewLocationType}
  if {[$CurrentCardCatalog libraryversion] < 2} {
    $toplevel.locationFrame.button40 configure -state disabled
  }

  # build widget $toplevel.locationFrame.label41
  label $toplevel.locationFrame.label41 \
    -text {(}

  # build widget $toplevel.locationFrame.entry42
  entry $toplevel.locationFrame.entry42 \
    -foreground {blue} \
    -textvariable "$toplevel\(LocationDetail)" \
    -exportselection 0
  set $toplevel\(LocationDetail) [$OldCardRecord locationdetail]

  # build widget $toplevel.locationFrame.label43
  label $toplevel.locationFrame.label43 \
    -text {)}

  if {$doSubjects} {
    # build widget $toplevel.subjectFrame
    frame $toplevel.subjectFrame \
      -borderwidth {2} \
      -relief {ridge}

    # build widget $toplevel.subjectFrame.frame0
    frame $toplevel.subjectFrame.frame0 \
      -borderwidth {2}

    # build widget $toplevel.subjectFrame.frame0.frame1
    frame $toplevel.subjectFrame.frame0.frame1

    # build widget $toplevel.subjectFrame.frame0.frame1.frame3
    frame $toplevel.subjectFrame.frame0.frame1.frame3 \
      -borderwidth {2}

    # build widget $toplevel.subjectFrame.frame0.frame1.frame3.listbox8
    listbox $toplevel.subjectFrame.frame0.frame1.frame3.listbox8 \
      -height {2} \
      -width {10} \
      -selectmode single \
      -exportselection 0 \
      -xscrollcommand "$toplevel.subjectFrame.frame0.frame2.frame5.scrollbar10 set" \
      -yscrollcommand "$toplevel.subjectFrame.frame0.frame1.frame4.scrollbar9 set"
    bind $toplevel.subjectFrame.frame0.frame1.frame3.listbox8 <1> \
	[list EditCardSubjectList_1 \
	      $toplevel.subjectFrame.subjectButtons.button5 \
	      $toplevel.subjectFrame.subjectButtons.button6 \
	      $toplevel.subjectFrame.subjectButtons.subjectEntry \
	      %W %x %y]
    foreach s "[set $toplevel\(Subjects)]" {
      $toplevel.subjectFrame.frame0.frame1.frame3.listbox8 insert end "$s"
    }

    # build widget $toplevel.subjectFrame.frame0.frame1.frame4
    frame $toplevel.subjectFrame.frame0.frame1.frame4 \
      -borderwidth {2}

    # build widget $toplevel.subjectFrame.frame0.frame1.frame4.scrollbar9
    scrollbar $toplevel.subjectFrame.frame0.frame1.frame4.scrollbar9 \
      -command "$toplevel.subjectFrame.frame0.frame1.frame3.listbox8 yview" \
      -width {13}

    # build widget $toplevel.subjectFrame.frame0.frame2
    frame $toplevel.subjectFrame.frame0.frame2 \
      -borderwidth {1}

    # build widget $toplevel.subjectFrame.frame0.frame2.frame5
    frame $toplevel.subjectFrame.frame0.frame2.frame5 \
      -borderwidth {2}

    # build widget $toplevel.subjectFrame.frame0.frame2.frame5.scrollbar10
    scrollbar $toplevel.subjectFrame.frame0.frame2.frame5.scrollbar10 \
      -command "$toplevel.subjectFrame.frame0.frame1.frame3.listbox8 xview" \
      -orient {horizontal} \
      -width {13}

    # build widget $toplevel.subjectFrame.frame0.frame2.frame6
    frame $toplevel.subjectFrame.frame0.frame2.frame6 \
      -borderwidth {2}

    # build widget $toplevel.subjectFrame.frame0.frame2.frame6.frame11
    frame $toplevel.subjectFrame.frame0.frame2.frame6.frame11 \
      -borderwidth {2} \
      -height {13} \
      -width {16}

    # build widget $toplevel.subjectFrame.subjectButtons
    frame $toplevel.subjectFrame.subjectButtons

    # build widget $toplevel.subjectFrame.subjectButtons.button5
    button $toplevel.subjectFrame.subjectButtons.button5 \
      -padx {9} \
      -pady {3} \
      -state disabled \
      -text {Remove} \
      -command "EditCardSubjectRemove $toplevel \
      			$toplevel.subjectFrame.frame0.frame1.frame3.listbox8 \
			$toplevel.subjectFrame.subjectButtons.subjectEntry \
			$toplevel.subjectFrame.subjectButtons.button5 \
			$toplevel.subjectFrame.subjectButtons.button6"

    # build widget $toplevel.subjectFrame.subjectButtons.button6
    button $toplevel.subjectFrame.subjectButtons.button6 \
      -padx {9} \
      -pady {3} \
      -state disabled \
      -text {Replace} \
      -command "EditCardSubjectReplace $toplevel \
      			$toplevel.subjectFrame.frame0.frame1.frame3.listbox8 \
			$toplevel.subjectFrame.subjectButtons.subjectEntry \
			$toplevel.subjectFrame.subjectButtons.button5 \
			$toplevel.subjectFrame.subjectButtons.button6"

    # build widget $toplevel.subjectFrame.subjectButtons.button7
    button $toplevel.subjectFrame.subjectButtons.button7 \
      -padx {9} \
      -pady {3} \
      -text {Add} \
      -command "EditCardSubjectAdd $toplevel \
      			$toplevel.subjectFrame.frame0.frame1.frame3.listbox8 \
			$toplevel.subjectFrame.subjectButtons.subjectEntry \
			$toplevel.subjectFrame.subjectButtons.button5 \
			$toplevel.subjectFrame.subjectButtons.button6"

    # build widget $toplevel.subjectFrame.subjectButtons.subjectEntry
    entry $toplevel.subjectFrame.subjectButtons.subjectEntry \
      -foreground {blue} \
      -exportselection 0
    bind $toplevel.subjectFrame.subjectButtons.subjectEntry <Return> \
	"$toplevel.subjectFrame.subjectButtons.button7 invoke"
  }

  # build widget $toplevel.buttons
  frame $toplevel.buttons \
    -borderwidth {2}

  # build widget $toplevel.buttons.checkbutton44
  checkbutton $toplevel.buttons.checkbutton44 \
    -variable "$toplevel\(DirtyFlag)"
  set $toplevel\(DirtyFlag) 0

  # build widget $toplevel.buttons.button45
  button $toplevel.buttons.button45 \
    -padx {9} \
    -pady {3} \
    -text {Save} \
    -command [list SaveCard "$Id" $OldCardRecord $SaveFunction $toplevel]

  # build widget $toplevel.buttons.button46
  button $toplevel.buttons.button46 \
    -padx {9} \
    -pady {3} \
    -text {Abort} \
    -command [list AbortCard "$Id" $OldCardRecord $SaveFunction $toplevel]

  # build widget $toplevel.buttons.button47
  button $toplevel.buttons.button47 \
    -padx {9} \
    -pady {3} \
    -text {Help} \
    -command {hl_Help {Editing a Card image}}

  # build widget $toplevel.frame
  frame $toplevel.frame \
    -relief {raised}

  # build widget $toplevel.frame.scrollbar1
  scrollbar $toplevel.frame.scrollbar1 \
    -command "$toplevel.frame.text2 yview" \
    -relief {raised}

  # build widget $toplevel.frame.text2
  text $toplevel.frame.text2 \
    -relief {raised} \
    -wrap {word} \
    -height 10 \
    -foreground {blue} \
    -yscrollcommand "$toplevel.frame.scrollbar1 set" \
    -exportselection 0
  $toplevel.frame.text2 insert end "[$OldCardRecord description]"
  set $toplevel\(Description) "[$OldCardRecord description]"
  bind $toplevel.frame.text2 <KeyPress> "setdescr $toplevel $toplevel.frame.text2"
  bind $toplevel.frame.text2 <ButtonPress> "setdescr $toplevel $toplevel.frame.text2"
  bindtags $toplevel.frame.text2 [list Text $toplevel.frame.text2 $toplevel all]

  # pack master $toplevel.top
  pack configure $toplevel.top.label8 \
    -fill y \
    -side left
  pack configure $toplevel.top.label9 \
    -expand 1 \
    -fill x \
    -side right

  # pack master $toplevel.idFrame
  pack configure $toplevel.idFrame.label11 \
    -side left
  pack configure $toplevel.idFrame.label12 \
    -side left
  pack configure $toplevel.idFrame.frame13 \
    -fill x \
    -side right

  # pack master $toplevel.titleFrame
  pack configure $toplevel.titleFrame.label20 \
    -side left
  pack configure $toplevel.titleFrame.entry21 \
    -expand 1 \
    -fill x \
    -side left
  pack configure $toplevel.titleFrame.button22 \
    -side right

  # pack master $toplevel.authorFrame
  pack configure $toplevel.authorFrame.label20 \
    -side left
  pack configure $toplevel.authorFrame.entry21 \
    -expand 1 \
    -fill x \
    -side left
  pack configure $toplevel.authorFrame.button22 \
    -side right

  # pack master $toplevel.typeFrame
  pack configure $toplevel.typeFrame.label23 \
    -side left
  pack configure $toplevel.typeFrame.menubutton24 \
    -expand 1 \
    -fill x \
    -side left
  pack configure $toplevel.typeFrame.button25 \
    -side right

  # pack master $toplevel.publisherFrame
  pack configure $toplevel.publisherFrame.label27 \
    -side left
  pack configure $toplevel.publisherFrame.entry28 \
    -expand 1 \
    -fill x \
    -side left
  pack configure $toplevel.publisherFrame.label29 \
    -side left
  pack configure $toplevel.publisherFrame.entry30 \
    -side left
  pack configure $toplevel.publisherFrame.label31 \
    -side left
  pack configure $toplevel.publisherFrame.entry32 \
    -side right

  # pack master $toplevel.volumeCatFrame
  pack configure $toplevel.volumeCatFrame.label33 \
    -side left
  pack configure $toplevel.volumeCatFrame.entry34 \
    -expand 1 \
    -fill x \
    -side left
  pack configure $toplevel.volumeCatFrame.label35 \
    -side left
  pack configure $toplevel.volumeCatFrame.menubutton36 \
    -side left
  pack configure $toplevel.volumeCatFrame.button37 \
    -side right

  # pack master $toplevel.locationFrame
  pack configure $toplevel.locationFrame.label38 \
    -side left
  pack configure $toplevel.locationFrame.menubutton39 \
    -side left
  pack configure $toplevel.locationFrame.button40 \
    -side left
  pack configure $toplevel.locationFrame.label41 \
    -side left
  pack configure $toplevel.locationFrame.entry42 \
    -expand 1 \
    -fill x \
    -side left
  pack configure $toplevel.locationFrame.label43 \
    -side right

  if {$doSubjects} {
    # pack master $toplevel.subjectFrame
    pack configure $toplevel.subjectFrame.frame0 \
      -expand 1 \
      -fill both
    pack configure $toplevel.subjectFrame.subjectButtons \
      -fill x

    # pack master $toplevel.subjectFrame.frame0
    pack configure $toplevel.subjectFrame.frame0.frame1 \
      -expand 1 \
      -fill both
    pack configure $toplevel.subjectFrame.frame0.frame2 \
      -fill x \
      -side bottom

    # pack master $toplevel.subjectFrame.frame0.frame1
    pack configure $toplevel.subjectFrame.frame0.frame1.frame3 \
      -expand 1 \
      -fill both \
      -side left
    pack configure $toplevel.subjectFrame.frame0.frame1.frame4 \
      -fill y \
      -side right

    # pack master $toplevel.subjectFrame.frame0.frame1.frame3
    pack configure $toplevel.subjectFrame.frame0.frame1.frame3.listbox8 \
      -expand 1 \
      -fill both \
      -side left

    # pack master $toplevel.subjectFrame.frame0.frame1.frame4
    pack configure $toplevel.subjectFrame.frame0.frame1.frame4.scrollbar9 \
      -expand 1 \
      -fill y

    # pack master $toplevel.subjectFrame.frame0.frame2
    pack configure $toplevel.subjectFrame.frame0.frame2.frame5 \
      -expand 1 \
      -fill both \
      -side left
    pack configure $toplevel.subjectFrame.frame0.frame2.frame6 \
      -fill y \
      -side right

    # pack master $toplevel.subjectFrame.frame0.frame2.frame5
    pack configure $toplevel.subjectFrame.frame0.frame2.frame5.scrollbar10 \
      -expand 1 \
      -fill x \
      -side left

    # pack master $toplevel.subjectFrame.frame0.frame2.frame6
    pack configure $toplevel.subjectFrame.frame0.frame2.frame6.frame11 \
      -expand 1 \
      -fill both

    # pack master $toplevel.subjectFrame.subjectButtons
    pack configure $toplevel.subjectFrame.subjectButtons.button5 \
      -side left
    pack configure $toplevel.subjectFrame.subjectButtons.button6 \
      -side left
    pack configure $toplevel.subjectFrame.subjectButtons.button7 \
      -side left
    pack configure $toplevel.subjectFrame.subjectButtons.subjectEntry \
      -expand 1 \
      -fill x \
      -side right

  }

  # pack master $toplevel.buttons
  pack configure $toplevel.buttons.checkbutton44 \
    -side left
  pack configure $toplevel.buttons.button45 \
    -expand 1 \
    -side left
  pack configure $toplevel.buttons.button46 \
    -expand 1 \
    -side left
  pack configure $toplevel.buttons.button47 \
    -expand 1 \
    -side right

  # pack master $toplevel.frame
  pack configure $toplevel.frame.scrollbar1 \
    -fill y \
    -side right
  pack configure $toplevel.frame.text2 \
    -expand 1 \
    -fill both

  # pack master $toplevel
  pack configure $toplevel.top \
    -fill x
  pack configure $toplevel.idFrame \
    -fill x
  pack configure $toplevel.titleFrame \
    -fill x
  pack configure $toplevel.authorFrame \
    -fill x
  pack configure $toplevel.typeFrame \
    -fill x
  pack configure $toplevel.publisherFrame \
    -fill x
  pack configure $toplevel.volumeCatFrame \
    -fill x
  pack configure $toplevel.frame \
    -fill both
  pack configure $toplevel.locationFrame \
    -fill x
  if {$doSubjects} {
    pack configure $toplevel.subjectFrame \
      -fill x
  }
  pack configure $toplevel.buttons \
    -fill x

  trace variable $toplevel w updateCard

# end of widget tree


}

proc EditCardSubjectList_1 {Remove Replace Entry listbox x y} {
# Respond to a <Button1> event in the subject list.
# [index] EditCardSubjectList\_1!procedure

  set item [$listbox index @$x,$y]
  set length [$listbox size]
  if {$item >= $length} {return}
  set subj "[$listbox get $item]"
  $Remove config -state normal
  $Replace config -state normal
  $Entry delete 0 end
  $Entry insert end "$subj"
}

proc EditCardSubjectRemove {toplevel listbox Entry Remove Replace} {
# Respond to the Remove button in the subject section of the edit card dialog.
# [index] EditCardSubjectRemove!procedure

  global $toplevel
  set cs "[$listbox curselection]"
  if {[string compare "$cs" {}] != 0} {
    set val "[$listbox get $cs]"
    $listbox delete $cs
    $Entry delete 0 end
    set el [lsearchexactnocase "[set $toplevel\(Subjects)]" "$val"]
    if {$el >= 0} {
      set newSubjs [lreplace "[set $toplevel\(Subjects)]" $el $el]
      set $toplevel\(Subjects) "$newSubjs"
    }
  }
  $Remove config -state disabled
  $Replace config -state disabled
}

proc EditCardSubjectReplace {toplevel listbox Entry Remove Replace} {
# Respond to the Replace button.
# [index] EditCardSubjectReplace!procedure

  global $toplevel
  set cs "[$listbox curselection]"
  if {[string compare "$cs" {}] != 0} {
    set val "[$listbox get $cs]"
    $listbox delete $cs
    $Entry delete 0 end
    set el [lsearchexactnocase [set $toplevel\(Subjects)] "$val"]
    set newel "[$Entry get]"
    if {$el >= 0} {
      if {[string compare "$newel" {}] == 0} {
        set newSubjs [lreplace "[set $toplevel\(Subjects)]" $el $el]
      } else {
	set newSubjs [lreplace "[set $toplevel\(Subjects)]" $el $el "$newel"]
      }
      set $toplevel\(Subjects) "$newSubjs"
    }
  }
  $Remove config -state disabled
  $Replace config -state disabled
}

proc EditCardSubjectAdd {toplevel listbox Entry Remove Replace} {
# Respond to the Add button.
# [index] EditCardSubjectAdd!procedure

  global $toplevel
  set newel "[$Entry get]"
  if {[string compare "$newel" {}] == 0} {return}
  set newSubjs "[set $toplevel\(Subjects)]"
  lappend newSubjs "$newel"
  set $toplevel\(Subjects) "$newSubjs"
  $Remove config -state disabled
  $Replace config -state disabled
  $listbox insert end "$newel"
  $listbox selection clear 0 end
}



proc setdescr {toplevel text} {
# Update the description.
# [index] setdescr!procedure

  global $toplevel
  upvar #0 $toplevel var

  set old "$var(Description)"
  set new "[$text get 1.0 end-1c]"
  if {[string compare "$old" "$new"] != 0} {
    set $toplevel\(Description) "$new"
  }
}


proc updateCard {varN ele op} {
# Handle card updates.
# [index] updateCard!procedure

  global $varN
  upvar #0 $varN var

  switch -exact "$ele" {
    ScratchList -
    DirtyFlag -
    Year_old  -
    Volume_old {return}
    Year -
    Volume {
	if {![regexp {^[0-9]*$} $var($ele)]} {
	  bell -displayof .
	  set var($ele) $var($ele\_old)
	  return
	}
	set var($ele\_old) $var($ele)
    }
  }
  set var(DirtyFlag) 1
}

proc SaveOrAbortEditCard {Id OldCardRecord SaveFunction toplevel} {
# Handle closing an edit dialog.
# [index] SaveOrAbortEditCard!procedure

  upvar #0 $toplevel var

  if {$var(DirtyFlag)} {
    if {[hl_dialog .abortCard "Abort Card?" "Card is modified, save it?" \
		   questhead 0 {Yes} {No}] == 0} {
      SaveCard "$Id" $OldCardRecord $SaveFunction $toplevel
    } else {
      AbortCard "$Id" $OldCardRecord $SaveFunction $toplevel
    }
  } else {
    AbortCard "$Id" $OldCardRecord $SaveFunction $toplevel
  }
}

proc AbortCard {Id OldCardRecord SaveFunction toplevel} {
# Abort editing a card.
# [index] AbortCard!procedure

  $SaveFunction "$Id" $OldCardRecord $toplevel 0
  global $toplevel
  catch "unset $toplevel"
  RemoveCardTypeOptionMenu $toplevel
  RemoveLocationTypeOptionMenu $toplevel
  RemoveCategoryOptionMenu $toplevel
  RemoveTopLevel $toplevel
}

proc SaveCard {Id OldCardRecord SaveFunction toplevel} {
# Save the card we are editing.
# [index] SaveCard!procedure

  CheckList {Authors} $toplevel Author Authors
  CheckList {Titles} $toplevel Title Titles
  $SaveFunction "$Id" $OldCardRecord $toplevel 1
  global $toplevel
  catch "unset $toplevel"
  RemoveCardTypeOptionMenu $toplevel
  RemoveLocationTypeOptionMenu $toplevel
  RemoveCategoryOptionMenu $toplevel
  RemoveTopLevel $toplevel
}

proc lsearchexactnocase {list element} {
# Search list for element. Ignore case
# [index] lsearchexactnocase!procedure

  set element [string toupper "$element"]
  set elenum 0
  foreach e $list {
    if {[string compare [string toupper "$e"] "$element"] == 0} {return $elenum}
    incr elenum
  }
  return -1
}

proc CheckList {title toplevel primary indexlist} {
# Check either the author or title lists.
# [index] CheckList!procedure

  global $toplevel
  upvar #0 $toplevel card

  if {[lsearchexactnocase "$card($indexlist)" "$card($primary)"] < 0} {
    set answer [hl_dialog .checklist "Primary Not in List?" \
	"$card($primary) is not in the $title list, should I add it?" \
	questhead 1 {Yes} {No}]
    if {$answer == 1} {return}
    lappend card($indexlist) "$card($primary)"
  }
}

proc DoIndexList {title toplevel primary indexlist} {
# Put up an index list.
# [index] DoIndexList!procedure

  global $toplevel
  upvar #0 $toplevel card

# .hlDialog
# The above line makes pasting MUCH easier for me.
# It contains the pathname of the cutted widget.
# Tcl version: 7.6 (Tcl/Tk/XF)
# Tk version: 4.2
# XF version: 4.0
#


  # build widget $toplevel.indexList
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy $toplevel.indexList"
  } {
    catch "destroy $toplevel.indexList"
  }
  toplevel $toplevel.indexList 

  # Window manager configurations
  wm maxsize $toplevel.indexList 1009 738
  wm minsize $toplevel.indexList 1 1
  wm title $toplevel.indexList "$title Indexing List"
  wm transient $toplevel.indexList $toplevel

  # build widget $toplevel.indexList.top
  frame $toplevel.indexList.top \
    -borderwidth {2}

  # build widget $toplevel.indexList.top.label2
  label $toplevel.indexList.top.label2 \
    -image {SmallFace}

  # build widget $toplevel.indexList.top.label3
  label $toplevel.indexList.top.label3 \
    -background {yellow} \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -foreground {brown} \
    -text "Update $title index list"

  # build widget $toplevel.indexList.frame0
  frame $toplevel.indexList.frame0 \
    -borderwidth {2}

  # build widget $toplevel.indexList.frame0.frame1
  frame $toplevel.indexList.frame0.frame1

  # build widget $toplevel.indexList.frame0.frame1.frame3
  frame $toplevel.indexList.frame0.frame1.frame3 \
    -borderwidth {2}

  # build widget $toplevel.indexList.frame0.frame1.frame3.listbox8
  listbox $toplevel.indexList.frame0.frame1.frame3.listbox8 \
    -selectmode single \
    -xscrollcommand "$toplevel.indexList.frame0.frame2.frame5.scrollbar10 set" \
    -yscrollcommand "$toplevel.indexList.frame0.frame1.frame4.scrollbar9 set" \
    -exportselection 0
  foreach item "[set $toplevel\($indexlist)]" {
    $toplevel.indexList.frame0.frame1.frame3.listbox8 insert end "$item"
  }
  set $toplevel\(ScratchList) "[set $toplevel\($indexlist)]"
  bind $toplevel.indexList.frame0.frame1.frame3.listbox8 <1> \
    [list DoIndexListListbox_1 \
	$toplevel.indexList.workButtons.button10 \
	$toplevel.indexList.workButtons.button11 \
	$toplevel.indexList.workButtons.value \
	%W %x %y]	

  # build widget $toplevel.indexList.frame0.frame1.frame4
  frame $toplevel.indexList.frame0.frame1.frame4 \
    -borderwidth {2}

  # build widget $toplevel.indexList.frame0.frame1.frame4.scrollbar9
  scrollbar $toplevel.indexList.frame0.frame1.frame4.scrollbar9 \
    -command "$toplevel.indexList.frame0.frame1.frame3.listbox8 yview" \
    -width {13}

  # build widget $toplevel.indexList.frame0.frame2
  frame $toplevel.indexList.frame0.frame2 \
    -borderwidth {1}

  # build widget $toplevel.indexList.frame0.frame2.frame5
  frame $toplevel.indexList.frame0.frame2.frame5 \
    -borderwidth {2}

  # build widget $toplevel.indexList.frame0.frame2.frame5.scrollbar10
  scrollbar $toplevel.indexList.frame0.frame2.frame5.scrollbar10 \
    -command "$toplevel.indexList.frame0.frame1.frame3.listbox8 xview" \
    -orient {horizontal} \
    -width {13}

  # build widget $toplevel.indexList.frame0.frame2.frame6
  frame $toplevel.indexList.frame0.frame2.frame6 \
    -borderwidth {2}

  # build widget $toplevel.indexList.frame0.frame2.frame6.frame11
  frame $toplevel.indexList.frame0.frame2.frame6.frame11 \
    -borderwidth {2} \
    -height {13} \
    -width {16}

  # build widget $toplevel.indexList.workButtons
  frame $toplevel.indexList.workButtons \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $toplevel.indexList.workButtons.button10
  button $toplevel.indexList.workButtons.button10 \
    -padx {9} \
    -pady {3} \
    -state disabled \
    -text {Remove} \
    -command [list DoIndexListRemove $toplevel \
			$toplevel.indexList.frame0.frame1.frame3.listbox8 \
			$toplevel.indexList.workButtons.value \
			$toplevel.indexList.workButtons.button10 \
			$toplevel.indexList.workButtons.button11]

  # build widget $toplevel.indexList.workButtons.button11
  button $toplevel.indexList.workButtons.button11 \
    -padx {9} \
    -pady {3} \
    -state disabled \
    -text {Replace} \
    -command [list DoIndexListReplace $toplevel \
			$toplevel.indexList.frame0.frame1.frame3.listbox8 \
			$toplevel.indexList.workButtons.value \
			$toplevel.indexList.workButtons.button10 \
			$toplevel.indexList.workButtons.button11]


  # build widget $toplevel.indexList.workButtons.button12
  button $toplevel.indexList.workButtons.button12 \
    -padx {9} \
    -pady {3} \
    -text {Add} \
   -command [list DoIndexListAdd $toplevel \
			$toplevel.indexList.frame0.frame1.frame3.listbox8 \
			$toplevel.indexList.workButtons.value \
			$toplevel.indexList.workButtons.button10 \
			$toplevel.indexList.workButtons.button11]


  # build widget $toplevel.indexList.workButtons.value
  entry $toplevel.indexList.workButtons.value \
    -foreground {blue} \
    -exportselection 0
  bind $toplevel.indexList.workButtons.value <Return> \
	"$toplevel.indexList.workButtons.button12 invoke"

  # build widget $toplevel.indexList.buttons
  frame $toplevel.indexList.buttons \
    -borderwidth {2}

  # build widget $toplevel.indexList.buttons.button14
  button $toplevel.indexList.buttons.button14 \
    -padx {9} \
    -pady {3} \
    -text {OK} \
    -command "DoIndexListOK $toplevel $primary $indexlist"
	

  # build widget $toplevel.indexList.buttons.button15
  button $toplevel.indexList.buttons.button15 \
    -padx {9} \
    -pady {3} \
    -text {Cancel} \
    -command "DoIndexListCancel $toplevel $primary $indexlist"

  # build widget $toplevel.indexList.buttons.button16
  button $toplevel.indexList.buttons.button16 \
    -padx {9} \
    -pady {3} \
    -text {Help} \
    -command {hl_Help {Index list dialog}}

  # pack master $toplevel.indexList.top
  pack configure $toplevel.indexList.top.label2 \
    -fill y \
    -side left
  pack configure $toplevel.indexList.top.label3 \
    -expand 1 \
    -fill x \
    -side right

  # pack master $toplevel.indexList.frame0
  pack configure $toplevel.indexList.frame0.frame1 \
    -expand 1 \
    -fill both
  pack configure $toplevel.indexList.frame0.frame2 \
    -fill x \
    -side bottom

  # pack master $toplevel.indexList.frame0.frame1
  pack configure $toplevel.indexList.frame0.frame1.frame3 \
    -expand 1 \
    -fill both \
    -side left
  pack configure $toplevel.indexList.frame0.frame1.frame4 \
    -fill y \
    -side right

  # pack master $toplevel.indexList.frame0.frame1.frame3
  pack configure $toplevel.indexList.frame0.frame1.frame3.listbox8 \
    -expand 1 \
    -fill both \
    -side left

  # pack master $toplevel.indexList.frame0.frame1.frame4
  pack configure $toplevel.indexList.frame0.frame1.frame4.scrollbar9 \
    -expand 1 \
    -fill y

  # pack master $toplevel.indexList.frame0.frame2
  pack configure $toplevel.indexList.frame0.frame2.frame5 \
    -expand 1 \
    -fill both \
    -side left
  pack configure $toplevel.indexList.frame0.frame2.frame6 \
    -fill y \
    -side right

  # pack master $toplevel.indexList.frame0.frame2.frame5
  pack configure $toplevel.indexList.frame0.frame2.frame5.scrollbar10 \
    -expand 1 \
    -fill x \
    -side left

  # pack master $toplevel.indexList.frame0.frame2.frame6
  pack configure $toplevel.indexList.frame0.frame2.frame6.frame11 \
    -expand 1 \
    -fill both

  # pack master $toplevel.indexList.workButtons
  pack configure $toplevel.indexList.workButtons.button10 \
    -side left
  pack configure $toplevel.indexList.workButtons.button11 \
    -side left
  pack configure $toplevel.indexList.workButtons.button12 \
    -side left
  pack configure $toplevel.indexList.workButtons.value \
    -expand 1 \
    -fill y \
    -side right

  # pack master $toplevel.indexList.buttons
  pack configure $toplevel.indexList.buttons.button14 \
    -expand 1 \
    -side left
  pack configure $toplevel.indexList.buttons.button15 \
    -expand 1 \
    -side left
  pack configure $toplevel.indexList.buttons.button16 \
    -expand 1 \
    -side right

  # pack master $toplevel.indexList
  pack configure $toplevel.indexList.top \
    -fill x
  pack configure $toplevel.indexList.frame0 \
    -expand 1 \
    -fill both
  pack configure $toplevel.indexList.workButtons \
    -fill x
  pack configure $toplevel.indexList.buttons \
    -fill x

  $toplevel.indexList.workButtons.value insert end "[set $toplevel\($primary)]"

# end of widget tree

  wm withdraw $toplevel.indexList
  update idletasks
  set x [expr [winfo screenwidth $toplevel.indexList]/2 - \
	      [winfo reqwidth $toplevel.indexList]/2 - \
	      [winfo vrootx $toplevel]]
  set y [expr [winfo screenheight $toplevel.indexList]/2 - \
	      [winfo reqheight $toplevel.indexList]/2 - \
	      [winfo vrooty $toplevel]]
  wm geom $toplevel.indexList +$x+$y
  wm deiconify $toplevel.indexList
  update idletasks
  focus $toplevel.indexList.workButtons.value
  grab $toplevel.indexList
  tkwait window $toplevel.indexList
  
}

proc DoIndexListListbox_1 {Remove Replace Entry listbox x y} {
# Button1 events on the index list.
# [index] DoIndexListListbox\_1!procedure

  set item [$listbox index @$x,$y]
  set length [$listbox size]
  if {$item >= $length} {return}
  set value "[$listbox get $item]"
  $Remove config -state normal
  $Replace config -state normal
  $Entry delete 0 end
  $Entry insert end "$value"
}

proc DoIndexListRemove {toplevel listbox Entry Remove Replace} {
# Remove button on the index list.
# [index] DoIndexListRemove!procedure

  global $toplevel
  upvar #0 $toplevel card

  set cs "[$listbox curselection]"
  if {[string compare "$cs" {}] != 0} {
    set val "[$listbox get $cs]"
    $listbox delete $cs
    $Entry delete 0 end
    set el [lsearchexactnocase "[set $toplevel\(ScratchList)]" "$val"]
    if {$el >= 0} {
      set newList [lreplace "[set $toplevel\(ScratchList)]" $el $el]
      set $toplevel\(ScratchList) "$newList"
    }
  }
  $Remove config -state disabled
  $Replace config -state disabled
}

proc DoIndexListReplace {toplevel listbox Entry Remove Replace} {
# Replace button on the index list.
# [index] DoIndexListReplace!procedure

  global $toplevel
  upvar #0 $toplevel card
  set cs "[$listbox curselection]"
  if {[string compare "$cs" {}] != 0} {
    set val "[$listbox get $cs]"
    $listbox delete $cs
    $Entry delete 0 end
    set el [lsearchexactnocase "[set $toplevel\(ScratchList)]" "$val"]
    set newel "[$Entry get]"
    if {$el >= 0} {
      if {[string compare "$newel" {}] == 0} {
        set newList [lreplace "[set $toplevel\(ScratchList)]" $el $el]
      } else {
	set newList [lreplace "[set $toplevel\(ScratchList)]" $el $el "$newel"]
      }
      set $toplevel\(ScratchList) "$newList"
    }
  }
  $Remove config -state disabled
  $Replace config -state disabled
}

proc DoIndexListAdd {toplevel listbox Entry Remove Replace} {
# Add button on the index list.
# [index] DoIndexListAdd!procedure

  global $toplevel
  upvar #0 $toplevel card
  set newel "[$Entry get]"
  if {[string compare "$newel" {}] == 0} {return}
  set newList "[set $toplevel\(ScratchList)]"
  lappend newList "$newel"
  set $toplevel\(ScratchList) "$newList"
  $Remove config -state disabled
  $Replace config -state disabled
  $listbox insert end "$newel"
  $listbox selection clear 0 end
}

proc DoIndexListOK {toplevel primary indexlist} {
# OK Button on the index list.
# [index] DoIndexListOK!procedure

  global $toplevel
  upvar #0 $toplevel card

  set $toplevel\($indexlist) "[set $toplevel\(ScratchList)]"

  set tl "$toplevel.indexList"

  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy $tl"
  } {
    catch "destroy $tl"
  }
}

proc DoIndexListCancel {toplevel primary indexlist} {
# Cancel button on the index list.
# [index] DoIndexListCancel!procedure

  set tl "$toplevel.indexList"

  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy $tl"
  } {
    catch "destroy $tl"
  }
}

proc SaveTemplateCard {name record toplevel SaveP} {
# Save a template card.
# [index] SaveTemplateCard!procedure

  if {$SaveP} {
    upvar #0 $toplevel card
    $record title "$card(Title)"
    $record author "$card(Author)"
    $record cardtype $card(Type)
    $record publisher "$card(Publisher)"
    $record city "$card(City)"
    $record year $card(Year)
    $record vol $card(Volume)
    $record categorycode $card(Category)
    $record locationtype $card(LocationType)
    $record locationdetail "$card(LocationDetail)"
    $record description "$card(Description)"
    global TemplateCards
    set TemplateCards($name) [list $record \
				"$card(Authors)" "$card(Titles)" {} 1]
  } else {
    $record delete
  }
}

proc SaveEditedTemplateCard {name record toplevel SaveP} {
# Save an edited template card.
# [index] SaveEditedTemplateCard!procedure

  if {$SaveP} {
    upvar #0 $toplevel card
    $record title "$card(Title)"
    $record author "$card(Author)"
    $record cardtype $card(Type)
    $record publisher "$card(Publisher)"
    $record city "$card(City)"
    $record year $card(Year)
    $record vol $card(Volume)
    $record categorycode $card(Category)
    $record locationtype $card(LocationType)
    $record locationdetail "$card(LocationDetail)"
    $record description "$card(Description)"
    global TemplateCards
    set TemplateCards($name) [list $record \
				"$card(Authors)" "$card(Titles)" \
				"[lindex $TemplateCards($name) 3]" 1]
  }
}

proc CreateTemplateCard {} {
# Create a new template card.
# [index] CreateTemplateCard!procedure

  global TemplateCards
  # build widget .hlDialog
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .hlDialog"
  } {
    catch "destroy .hlDialog"
  }
  toplevel .hlDialog 

  # Window manager configurations
  wm positionfrom .hlDialog ""
  wm sizefrom .hlDialog ""
  wm maxsize .hlDialog 1009 738
  wm minsize .hlDialog 1 1
  wm title .hlDialog {Get Template Card Name}
  wm transient .


  # build widget .hlDialog.top
  frame .hlDialog.top \
    -borderwidth {2}

  # build widget .hlDialog.top.label2
  label .hlDialog.top.label2 \
    -image {SmallFace}

  # build widget .hlDialog.top.label3
  label .hlDialog.top.label3 \
    -background {yellow} \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -foreground {brown} \
    -text {Enter a name for the new template card}

  # build widget .hlDialog.nameFrame
  frame .hlDialog.nameFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .hlDialog.nameFrame.label5
  label .hlDialog.nameFrame.label5 \
    -text {Name:}

  # build widget .hlDialog.nameFrame.entry6
  entry .hlDialog.nameFrame.entry6 \
    -foreground {blue} \
    -exportselection 0
  bind .hlDialog.nameFrame.entry6 <Return> {.hlDialog.frame7.button8 invoke}

  # build widget .hlDialog.frame7
  frame .hlDialog.frame7 \
    -borderwidth {2}

  # build widget .hlDialog.frame7.button8
  button .hlDialog.frame7.button8 \
    -padx {9} \
    -pady {3} \
    -text {OK} \
    -command {
      global hlDialog
      set hlDialog "[.hlDialog.nameFrame.entry6 get]"
      global TemplateCards
      if {[lsearch -exact [array names TemplateCards] "$hlDialog"] >= 0} {
	hl_warning "Name already in use, pick another"
	return
      }
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .hlDialog"
  } {
    catch "destroy .hlDialog"
  }
    }
  # build widget .hlDialog.frame7.button9
  button .hlDialog.frame7.button9 \
    -padx {9} \
    -pady {3} \
    -text {Cancel} \
    -command {
      global hlDialog
      set hlDialog {}
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .hlDialog"
  } {
    catch "destroy .hlDialog"
  }
    }

  # build widget .hlDialog.frame7.button10
  button .hlDialog.frame7.button10 \
    -padx {9} \
    -pady {3} \
    -text {Help} \
    -command {hl_Help {New template name dialog}}

  # pack master .hlDialog.top
  pack configure .hlDialog.top.label2 \
    -fill y \
    -side left
  pack configure .hlDialog.top.label3 \
    -fill x \
    -side right

  # pack master .hlDialog.nameFrame
  pack configure .hlDialog.nameFrame.label5 \
    -side left
  pack configure .hlDialog.nameFrame.entry6 \
    -expand 1 \
    -fill x \
    -side right

  # pack master .hlDialog.frame7
  pack configure .hlDialog.frame7.button8 \
    -expand 1 \
    -side left
  pack configure .hlDialog.frame7.button9 \
    -expand 1 \
    -side left
  pack configure .hlDialog.frame7.button10 \
    -expand 1 \
    -side right

  # pack master .hlDialog
  pack configure .hlDialog.top \
    -fill x
  pack configure .hlDialog.nameFrame \
    -fill x
  pack configure .hlDialog.frame7 \
    -fill both

  .hlDialog.nameFrame.entry6 insert end {}


# end of widget tree

  wm withdraw .hlDialog
  update idletasks
  set x [expr [winfo screenwidth .hlDialog]/2 - \
	      [winfo reqwidth .hlDialog]/2 - \
	      [winfo vrootx .]]
  set y [expr [winfo screenheight .hlDialog]/2 - \
	      [winfo reqheight .hlDialog]/2 - \
	      [winfo vrooty .]]
  wm geom .hlDialog +$x+$y
  wm deiconify .hlDialog
  update idletasks
  focus .hlDialog.nameFrame.entry6
  grab .hlDialog
  tkwait window .hlDialog

  global hlDialog
  if {[string compare "$hlDialog" {}] == 0} {return}

  EditCard "$hlDialog" [CardRecord] SaveTemplateCard -dontdosubjects
}


proc EditTemplateCard {} {
# Edit a template card.
# [index] EditTemplateCard!procedure

  set template "[SelectTemplate]"
  if {[string compare "$template" {}] == 0} {return}
  set name "[lindex $template 0]"
  set card  [lindex $template 1]
  if {![lindex $card 4]} {
    hl_warning "You cannot edit a locked template."
    return
  }

  EditCard "$name" [lindex $card 0] SaveEditedTemplateCard -dontdosubjects \
	-authors "[lindex $card 1]" -titles "[lindex $card 2]"
}

proc RemoveTemplateCard {} {
# Replace a template card.
# [index] RemoveTemplateCard!procedure

  set template "[SelectTemplate]"
  if {[string compare "$template" {}] == 0} {return}
  set name "[lindex $template 0]"
  set card  [lindex $template 1]
  if {![lindex $card 4]} {
    hl_warning "You cannot remove a locked template."
    return
  }

  global TemplateCards
  unset TemplateCards($name)
}

proc SaveCardTemplate {} {
# Save a template card.
# [index] SaveCardTemplate!procedure

  set template "[SelectTemplate]"
  if {[string compare "$template" {}] == 0} {return}
  set name "[lindex $template 0]"
  set card  [lindex $template 1]
  if {![lindex $card 4]} {
    hl_warning "You cannot save a locked template."
    return
  }

  global TemplateCards
  set fname [tk_getSaveFile -defaultextension {.tmc} \
			    -initialfile "[lindex $card 3]" \
			    -title "Select a file to save template in" \
			    -filetypes {{{Text Files} {.tmc} {TEXT}}}]
  if {[string length "$fname"] == 0} {return}
  if {[catch [list open "$fname" a] fp]} {
    hl_error "Error opening $fname: $fp"
    return
  }
  puts $fp "\{$name\} \{[[lindex $card 0]]\} \{[lindex $card 1]\} \{[lindex $card 2]\}"
  close $fp
  set TemplateCards($name) \
	[list [lindex $card 0] \
	      [lindex $card 1] \
	      [lindex $card 2] \
	      "$fname" \
	      [lindex $card 4]]
}

proc LoadCardTemplates {} {
# Load template cards.
# [index] LoadCardTemplates!procedure

  global TemplateCards
  set fname [tk_getOpenFile -defaultextension {.tmc} \
			    -title "Select a file to load templates from" \
			    -filetypes {{{Text Files} {.tmc} {TEXT}}}]
  if {[string length "$fname"] == 0} {return}
  if {[catch [list open "$fname" r] fp]} {
    hl_error "Error opening $fname: $fp"
    return
  }
  while {[gets $fp list] >= 0} {
    set name "[lindex $list 0]"
    set dumpedCard "[lindex $list 1]"
    set authors "[lindex $list 2]"
    set titles  "[lindex $list 3]"
    set card [CardRecord]
    foreach f [lrange $dumpedCard 1 end] {
      set k "[lindex $f 0]"
      set v "[lindex $f 1]"
      $card $k "$v"
    }
    set TemplateCards($name) \
	[list $card "$authors" "$titles" "$fname" 1]
  }
  close $fp
}




package provide HL20_editForm 1.0
