#* 
#* ------------------------------------------------------------------
#* Home Libarian 1.1 by Deepwoods Software
#* ------------------------------------------------------------------
#* HL20_dialogs.tcl - Home Librarian standard dialog support code
#* Created by Robert Heller on Sat Sep  6 17:27:28 1997
#* ------------------------------------------------------------------
#* Modification History: 
#* $Log: HL20_dialogs.tcl,v $
#* Revision 2.3  1998/05/17 21:14:18  heller
#* Add in indexing
#*
#* Revision 2.2  1997/09/07 00:44:10  heller
#* Make chapter names even shorter.
#*
#* Revision 2.1  1997/09/06 23:42:04  heller
#* Fix chapter name.
#*
#* Revision 2.0  1997/09/06 21:29:22  heller
#* *** empty log message ***
#*
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Home Librarian Database -- a program for maintaining a database
#*                                for a home library
#*     Copyright (C) 1991-1997  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

#@Chapter: HL20\_dialogs.tcl -- dialog boxes.
#@Label: HL20dialogs.tcl
#$Id: HL20_dialogs.tcl,v 2.3 1998/05/17 21:14:18 heller Rel $

# This file contains a standard set of generic dialog boxes for Home Librarian
# use.  This file is derived from the dialog.tcl file provided by the Tk 
# library.

proc hl_dialog {w title text bitmap default args} {
# hl_dialog:      
# 
# (modified from tk_dialog to add in HL's small image / title frame)
#
# This procedure displays a dialog box, waits for a button in the dialog
# to be invoked, then returns the index of the selected button.  If the
# dialog somehow gets destroyed, -1 is returned.
# 
# Arguments:
# <in> w --           Window to use for dialog top-level.
# <in> title --       Title to display in dialog's decorative frame.
# <in> text --        Message to display in dialog.
# <in> bitmap --      Bitmap to display in dialog (empty string means none).
# <in> default --     Index of button that is to display the default ring
#               (-1 means none).
# <in> args --        One or more strings to display in buttons across the
#               bottom of the dialog box.
# [index] hl\_dialog!procedure

    global tkPriv

    # 1. Create the top-level window and divide it into top
    # and bottom parts.

    catch {destroy $w}
    toplevel $w -class Dialog
    wm title $w $title
    wm iconname $w {HL20 Dialog}
    wm protocol $w WM_DELETE_WINDOW { }

    # The following command means that the dialog won't be posted if
    # [winfo parent $w] is iconified, but it's really needed;  otherwise
    # the dialog can become obscured by other windows in the application,
    # even though its grab keeps the rest of the application from being used.

    wm transient $w [winfo toplevel [winfo parent $w]]

    frame $w.toptop -borderwidth {2}
    pack $w.toptop -side top -fill x
    label $w.toptop.label2 -image {SmallFace}
    pack $w.toptop.label2 -fill y -side left
    label $w.toptop.label3 \
	-background {yellow} \
	-font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
	-foreground {brown} \
	-text "$title"
    pack $w.toptop.label3 -fill x -side right -expand 1

    frame $w.bot -relief raised -bd 1
    pack $w.bot -side bottom -fill both
    frame $w.top -relief raised -bd 1
    pack $w.top -side top -fill both -expand 1

    # 2. Fill the top part with bitmap and message (use the option
    # database for -wraplength so that it can be overridden by
    # the caller).

    option add *Dialog.msg.wrapLength 3i widgetDefault
    label $w.msg -justify left -text $text
    catch {$w.msg configure -font \
		-Adobe-Times-Medium-R-Normal--*-180-*-*-*-*-*-*
    }
    pack $w.msg -in $w.top -side right -expand 1 -fill both -padx 3m -pady 3m
    if {$bitmap != ""} {
	label $w.bitmap -bitmap $bitmap
	pack $w.bitmap -in $w.top -side left -padx 3m -pady 3m
    }

    # 3. Create a row of buttons at the bottom of the dialog.

    set i 0
    foreach but $args {
	button $w.button$i -text $but -command "set tkPriv(button) $i"
	if {$i == $default} {
	    frame $w.default -relief sunken -bd 1
	    raise $w.button$i $w.default
	    pack $w.default -in $w.bot -side left -expand 1 -padx 3m -pady 2m
	    pack $w.button$i -in $w.default -padx 2m -pady 2m
	} else {
	    pack $w.button$i -in $w.bot -side left -expand 1 \
		    -padx 3m -pady 2m
	}
	incr i
    }

    # 4. Create a binding for <Return> on the dialog if there is a
    # default button.

    if {$default >= 0} {
	bind $w <Return> "
	    $w.button$default configure -state active -relief sunken
	    update idletasks
	    after 100
	    set tkPriv(button) $default
	"
    }

    # 5. Create a <Destroy> binding for the window that sets the
    # button variable to -1;  this is needed in case something happens
    # that destroys the window, such as its parent window being destroyed.

    bind $w <Destroy> {set tkPriv(button) -1}

    # 6. Withdraw the window, then update all the geometry information
    # so we know how big it wants to be, then center the window in the
    # display and de-iconify it.

    wm withdraw $w
    update idletasks
    set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
	    - [winfo vrootx [winfo parent $w]]]
    set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
	    - [winfo vrooty [winfo parent $w]]]
    wm geom $w +$x+$y
    wm deiconify $w

    # 7. Set a grab and claim the focus too.

    set oldFocus [focus]
    set oldGrab [grab current $w]
    if {$oldGrab != ""} {
	set grabStatus [grab status $oldGrab]
    }
    grab $w
    if {$default >= 0} {
	focus $w.button$default
    } else {
	focus $w
    }

    # 8. Wait for the user to respond, then restore the focus and
    # return the index of the selected button.  Restore the focus
    # before deleting the window, since otherwise the window manager
    # may take the focus away so we can't redirect it.  Finally,
    # restore any grab that was in effect.

    tkwait variable tkPriv(button)
    catch {focus $oldFocus}
    catch {
	# It's possible that the window has already been destroyed,
	# hence this "catch".  Delete the Destroy handler so that
	# tkPriv(button) doesn't get reset by it.

	bind $w <Destroy> {}
	destroy $w
    }
    if {$oldGrab != ""} {
	if {$grabStatus == "global"} {
	    grab -global $oldGrab
	} else {
	    grab $oldGrab
	}
    }
    return $tkPriv(button)
}

proc hl_error {mess} {
  # Generate an error dialog.
  # <in> mess -- error message.
  # [index] hl\_error!procedure

  hl_dialog .errorbox "HL 2.0 Error" "$mess" error 0 OK
}

proc hl_warning {mess} {
  # Generate an warning dialog.
  # <in> mess -- warning message.
  # [index] hl\_warning!procedure

  hl_dialog .warningbox "HL 2.0 Warning" "$mess" warning 0 OK
}

proc hl_info {mess} {
  # Generate an info dialog.
  # <in> mess -- info message.
  # [index] hl\_info!procedure

  hl_dialog .infobox "HL 2.0 Information" "$mess" info 0 OK
}



package provide HL20_dialogs 1.0
