#* 
#* ------------------------------------------------------------------
#* Home Libarian 1.1 by Deepwoods Software
#* ------------------------------------------------------------------
#* HL20_Registration.tcl - Registration handling code
#* Created by Robert Heller on Sat Sep  6 12:03:25 1997
#* ------------------------------------------------------------------
#* Modification History: 
#* $Log: HL20_Registration.tcl,v $
#* Revision 2.5  1998/05/17 21:14:18  heller
#* Add in indexing
#*
#* Revision 2.4  1998/04/21 18:38:33  heller
#* Final Release...
#*
#* Revision 2.3  1997/09/07 00:44:10  heller
#* Make chapter names even shorter.
#*
#* Revision 2.2  1997/09/06 23:42:04  heller
#* Fix chapter name.
#*
#* Revision 2.1  1997/09/06 16:23:20  heller
#* Minor fixes for tcl2tex...
#*
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Home Librarian Database -- a program for maintaining a database
#*                                for a home library
#*     Copyright (C) 1991-1997  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

#@Chapter: HL20\_Registration.tcl -- registration.
#@Label: HL20Registration.tcl
#$Id: HL20_Registration.tcl,v 2.5 1998/05/17 21:14:18 heller Rel $

# This file contains the code to deal with registration.

global RegistrationFile
# The name of the registration file.
# [index] RegistrationFile!global variable

set RegistrationFile {Registration.tcl}

proc hl_GetRegistration {} {
  # Fetch the registration info.
  # [index] hl\_GetRegistration!procedure

  global LibDir
  global RegistrationFile
  global Registration

  if {[info exists Registration]} {
    if {![catch "array names Registration" regfields]} {
      if {[lcontains {Name Organization SN} "$regfields"]} {
         return 1
      }
    } else {
      unset Registration
    }
  }
  set rf "[file join $LibDir $RegistrationFile]"
  if {[file exists "$rf"]} {
    if {[catch [list hl_SafeLoadRegistration "$rf"]]} {
      hl_error "Error loading Registration: $rf"
      return 0
    } else {
      return 1
    }
  } else {
    return 0
  }
  
  if {[info exists Registration]} {
    if {![catch "array names Registration" regfields]} {
      if {[lcontains {Name Organization SN} "$regfields"]} {
         return 1
      }
    }
  }
  return 0
}

proc hl_SafeLoadRegistration {fname} {
  # A safe replacement for the source command the only loads the 
  # registration information and nothing else.
  # [index] hl\_SafeLoadRegistration!procedure

  set fn [open "$fname" r]
  set script "[read $fn]"
  if {[regsub -all "\r" "$script" {} new] > 0} {
    set script "$new"
  }
  interp create -safe hl_SafeLoadRegistrationI
  hl_SafeLoadRegistrationI eval $script
  close $fn
  if {[hl_SafeLoadRegistrationI eval info exists Registration]} {
    if {![catch "hl_SafeLoadRegistrationI eval array names Registration" regfields]} {
      if {[lcontains {Name Organization SN} "$regfields"]} {
	global Registration
	foreach rf {Name Organization SN} {
	  set Registration($rf) "[hl_SafeLoadRegistrationI eval set Registration($rf)]"
	}
      } else {
	hl_error "Ill formed Registration file: one or more fields are missing"
      }
    } else {
       hl_error "Ill formed Registration file: could not get fields: $regfields"
    }
  } else {
    hl_error "Ill formed Registration file - missing Registration"
  }
  interp delete hl_SafeLoadRegistrationI
}

proc hl_Register {} {
  # Create a registration file.
  # [index] hl\_Register!procedure

  if {[hl_GetRegistration]} {
    global Registration
    hl_info "This copy of Home Librarian is already registered to $Registration(Name)"
    return
  }

  global help_tips

  # build widget .hl_GetRegistration
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .hl_GetRegistration"
  } {
    catch "destroy .hl_GetRegistration"
  }
  toplevel .hl_GetRegistration 

  # Window manager configurations
  wm positionfrom .hl_GetRegistration ""
  wm sizefrom .hl_GetRegistration ""
  wm maxsize .hl_GetRegistration 1009 738
  wm minsize .hl_GetRegistration 1 1
  wm title .hl_GetRegistration {Registration}
  wm transient .hl_GetRegistration .


  # build widget .hl_GetRegistration.top
  frame .hl_GetRegistration.top

  # build widget .hl_GetRegistration.top.l1
  label .hl_GetRegistration.top.l1 \
    -image {SmallFace}

  # build widget .hl_GetRegistration.top.l2
  label .hl_GetRegistration.top.l2 \
    -background {yellow} \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -foreground {brown} \
    -text {Registration}

  # build widget .hl_GetRegistration.middle
  frame .hl_GetRegistration.middle \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .hl_GetRegistration.middle.nameFrame
  frame .hl_GetRegistration.middle.nameFrame

  # build widget .hl_GetRegistration.middle.nameFrame.l
  label .hl_GetRegistration.middle.nameFrame.l \
    -text {Name:}

  # build widget .hl_GetRegistration.middle.nameFrame.e
  entry .hl_GetRegistration.middle.nameFrame.e \
    -textvariable {Registration(Name)} \
    -exportselection 0
  enable_balloon .hl_GetRegistration.middle.nameFrame.e
  set help_tips(.hl_GetRegistration.middle.nameFrame.e) \
	{This is the registrant's name}

  # build widget .hl_GetRegistration.middle.orgFrame
  frame .hl_GetRegistration.middle.orgFrame

  # build widget .hl_GetRegistration.middle.orgFrame.l
  label .hl_GetRegistration.middle.orgFrame.l \
    -text {Organization:}

  # build widget .hl_GetRegistration.middle.orgFrame.e
  entry .hl_GetRegistration.middle.orgFrame.e \
    -textvariable {Registration(Organization)} \
    -exportselection 0
  enable_balloon .hl_GetRegistration.middle.orgFrame.e
  set help_tips(.hl_GetRegistration.middle.orgFrame.e) \
	{This is the registrant's organization}

  # build widget .hl_GetRegistration.middle.snFrame
  frame .hl_GetRegistration.middle.snFrame

  # build widget .hl_GetRegistration.middle.snFrame.l
  label .hl_GetRegistration.middle.snFrame.l \
    -text {Serial Number:}

  # build widget .hl_GetRegistration.middle.snFrame.e
  entry .hl_GetRegistration.middle.snFrame.e \
    -textvariable {Registration(SN)} \
    -exportselection 0
  enable_balloon .hl_GetRegistration.middle.snFrame.e
  set help_tips(.hl_GetRegistration.middle.snFrame.e) \
	{This is the serial number}

  # build widget .hl_GetRegistration.buttons
  frame .hl_GetRegistration.buttons

  # build widget .hl_GetRegistration.buttons.ok
  button .hl_GetRegistration.buttons.ok \
    -padx {9} \
    -pady {3} \
    -text {OK} \
    -command {
	  global LibDir
	  global RegistrationFile
	  set rf "[file join $LibDir $RegistrationFile]"
	  if {[catch [list open "$rf" w] rfp]} {
	    hl_error "Error opening registration file: $rfp"
	    return
	  }
	  puts $rfp {#* Created by Home Librarian Register proc}
	  puts $rfp {#* Do no Edit!}
	  puts $rfp {#*}
	  puts $rfp {}

	  puts $rfp "global Registration"
	  foreach n [array names Registration] {
	    puts $rfp "set Registration($n) \{$Registration($n)\}"
	  }
	  close $rfp
	  if {"[info procs XFEdit]" != ""} {
	    catch "XFDestroy .hl_GetRegistration"
	  } {
	    catch "destroy .hl_GetRegistration"
	  }
    }
  set help_tips(.hl_GetRegistration.buttons.ok) \
	{Click here to enter the registration}

  # build widget .hl_GetRegistration.buttons.cancel
  button .hl_GetRegistration.buttons.cancel \
    -padx {9} \
    -pady {3} \
    -text {Cancel} \
    -command {
	  catch "unset Registration(Name)"
	  catch "unset Registration(Organization)"
	  catch "unset Registration(SN)"
	  catch "unset Registration"
	  if {"[info procs XFEdit]" != ""} {
	    catch "XFDestroy .hl_GetRegistration"
	  } {
	    catch "destroy .hl_GetRegistration"
	  }
	}
  set help_tips(.hl_GetRegistration.buttons.cancel) \
	{Click here to abort the registration}

  # build widget .hl_GetRegistration.buttons.help
  button .hl_GetRegistration.buttons.help \
    -padx {9} \
    -pady {3} \
    -text {Help} \
    -command {hl_Help {Registration Dialog}}
  set help_tips(.hl_GetRegistration.buttons.help) \
	{Click here to get detailed help}

  # pack master .hl_GetRegistration.top
  pack configure .hl_GetRegistration.top.l1 \
    -fill y \
    -side left
  pack configure .hl_GetRegistration.top.l2 \
    -expand 1 \
    -fill x \
    -side right

  # pack master .hl_GetRegistration.middle
  pack configure .hl_GetRegistration.middle.nameFrame \
    -fill x
  pack configure .hl_GetRegistration.middle.orgFrame \
    -fill x
  pack configure .hl_GetRegistration.middle.snFrame \
    -fill x

  # pack master .hl_GetRegistration.middle.nameFrame
  pack configure .hl_GetRegistration.middle.nameFrame.l \
    -side left
  pack configure .hl_GetRegistration.middle.nameFrame.e \
    -expand 1 \
    -fill x \
    -side right

  # pack master .hl_GetRegistration.middle.orgFrame
  pack configure .hl_GetRegistration.middle.orgFrame.l \
    -side left
  pack configure .hl_GetRegistration.middle.orgFrame.e \
    -expand 1 \
    -fill x \
    -side right

  # pack master .hl_GetRegistration.middle.snFrame
  pack configure .hl_GetRegistration.middle.snFrame.l \
    -side left
  pack configure .hl_GetRegistration.middle.snFrame.e \
    -expand 1 \
    -fill x \
    -side right

  # pack master .hl_GetRegistration.buttons
  pack configure .hl_GetRegistration.buttons.ok \
    -expand 1 \
    -side left
  pack configure .hl_GetRegistration.buttons.cancel \
    -expand 1 \
    -side left
  pack configure .hl_GetRegistration.buttons.help \
    -expand 1 \
    -side right

  # pack master .hl_GetRegistration
  pack configure .hl_GetRegistration.top \
    -fill x
  pack configure .hl_GetRegistration.middle \
    -expand 1 \
    -fill both
  pack configure .hl_GetRegistration.buttons \
    -fill x
# end of widget tree

  wm withdraw .hl_GetRegistration
  update idletasks 
  set x [expr [winfo screenwidth .hl_GetRegistration]/2 - \
	      [winfo reqwidth .hl_GetRegistration]/2 - \
	      [winfo vrootx .]]
  set y [expr [winfo screenheight .hl_GetRegistration]/2 - \
	      [winfo reqheight .hl_GetRegistration]/2 - \
	      [winfo vrooty .]]
  wm geom .hl_GetRegistration +$x+$y
  wm deiconify .hl_GetRegistration

  update idletasks
  grab .hl_GetRegistration
  focus .hl_GetRegistration.middle.nameFrame.e
  tkwait window .hl_GetRegistration
}

proc hl_DisplayRegistration {} {
  # Display the current registration.
  # [index] hl\_DisplayRegistration!procedure

  if {[hl_GetRegistration]} {
    global Registration

  # build widget .displayRegistration
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .displayRegistration"
  } {
    catch "destroy .displayRegistration"
  }
  toplevel .displayRegistration 

  # Window manager configurations
  wm positionfrom .displayRegistration ""
  wm sizefrom .displayRegistration ""
  wm maxsize .displayRegistration 1009 738
  wm minsize .displayRegistration 1 1
  wm title .displayRegistration {Registration}
  wm transient .displayRegistration .


  # build widget .displayRegistration.top
  frame .displayRegistration.top

  # build widget .displayRegistration.top.l1
  label .displayRegistration.top.l1 \
    -image {SmallFace}

  # build widget .displayRegistration.top.l2
  label .displayRegistration.top.l2 \
    -background {yellow} \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -foreground {brown} \
    -text {Registration}

  # build widget .displayRegistration.middle
  frame .displayRegistration.middle \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .displayRegistration.middle.nameFrame
  frame .displayRegistration.middle.nameFrame

  # build widget .displayRegistration.middle.nameFrame.l
  label .displayRegistration.middle.nameFrame.l \
    -text {Name:}

  # build widget .displayRegistration.middle.nameFrame.e
  label .displayRegistration.middle.nameFrame.e \
    -textvariable {Registration(Name)} \
    -relief sunken

  # build widget .displayRegistration.middle.orgFrame
  frame .displayRegistration.middle.orgFrame

  # build widget .displayRegistration.middle.orgFrame.l
  label .displayRegistration.middle.orgFrame.l \
    -text {Organization:}

  # build widget .displayRegistration.middle.orgFrame.e
  label .displayRegistration.middle.orgFrame.e \
    -textvariable {Registration(Organization)} \
    -relief sunken

  # build widget .displayRegistration.middle.snFrame
  frame .displayRegistration.middle.snFrame

  # build widget .displayRegistration.middle.snFrame.l
  label .displayRegistration.middle.snFrame.l \
    -text {Serial Number:}

  # build widget .displayRegistration.middle.snFrame.e
  label .displayRegistration.middle.snFrame.e \
    -textvariable {Registration(SN)} \
    -relief sunken

  # build widget .displayRegistration.buttons
  frame .displayRegistration.buttons

  # build widget .displayRegistration.buttons.ok
  button .displayRegistration.buttons.ok \
    -padx {9} \
    -pady {3} \
    -text {Dismis} \
    -command {
	  if {"[info procs XFEdit]" != ""} {
	    catch "XFDestroy .displayRegistration"
	  } {
	    catch "destroy .displayRegistration"
  	  }
	}

  # build widget .displayRegistration.buttons.help
  button .displayRegistration.buttons.help \
    -padx {9} \
    -pady {3} \
    -text {Help} \
    -command {hl_Help {Registration display dialog}}

  # pack master .displayRegistration.top
  pack configure .displayRegistration.top.l1 \
    -fill y \
    -side left
  pack configure .displayRegistration.top.l2 \
    -expand 1 \
    -fill x \
    -side right

  # pack master .displayRegistration.middle
  pack configure .displayRegistration.middle.nameFrame \
    -fill x
  pack configure .displayRegistration.middle.orgFrame \
    -fill x
  pack configure .displayRegistration.middle.snFrame \
    -fill x

  # pack master .displayRegistration.middle.nameFrame
  pack configure .displayRegistration.middle.nameFrame.l \
    -side left
  pack configure .displayRegistration.middle.nameFrame.e \
    -expand 1 \
    -fill x \
    -side right

  # pack master .displayRegistration.middle.orgFrame
  pack configure .displayRegistration.middle.orgFrame.l \
    -side left
  pack configure .displayRegistration.middle.orgFrame.e \
    -expand 1 \
    -fill x \
    -side right

  # pack master .displayRegistration.middle.snFrame
  pack configure .displayRegistration.middle.snFrame.l \
    -side left
  pack configure .displayRegistration.middle.snFrame.e \
    -expand 1 \
    -fill x \
    -side right

  # pack master .displayRegistration.buttons
  pack configure .displayRegistration.buttons.ok \
    -expand 1 \
    -side left
  pack configure .displayRegistration.buttons.help \
    -expand 1 \
    -side right

  # pack master .displayRegistration
  pack configure .displayRegistration.top \
    -fill x
  pack configure .displayRegistration.middle \
    -expand 1 \
    -fill both
  pack configure .displayRegistration.buttons \
    -fill x
# end of widget tree

  wm withdraw .displayRegistration
  update idletasks
  set x [expr [winfo screenwidth .displayRegistration]/2 - \
	      [winfo reqwidth .displayRegistration]/2 - \
	      [winfo vrootx .]]
  set y [expr [winfo screenheight .displayRegistration]/2 - \
	      [winfo reqheight .displayRegistration]/2 - \
	      [winfo vrooty .]]
  wm geom .displayRegistration +$x+$y
  wm deiconify .displayRegistration

  } else {
    hl_info {This copy of Home Librarian is not registered.}
  }
}

proc lcontains {l1 l2} {
  # Check to see if the elements of the list l1 are in the list l2
  #
  # Arguments:
  # <in> l1 -- the set of elements to look for
  # <in> l2 -- the list to search.
  # [index] lcontains!procedure

  foreach a $l1 {
    if {[lsearch -exact $l2 "$a"] < 0} {
      return 0
    }
  }
  return 1
}

package provide HL20_Registration 1.0
