#* 
#* ------------------------------------------------------------------
#* Home Libarian 1.1 by Deepwoods Software
#* ------------------------------------------------------------------
#* HL20_PrintLibr.tcl - Print a card catalog file
#* Created by Robert Heller on Sat Sep  6 14:22:30 1997
#* ------------------------------------------------------------------
#* Modification History: 
#* $Log: HL20_PrintLibr.tcl,v $
#* Revision 1.4  1998/05/17 21:14:18  heller
#* Add in indexing
#*
#* Revision 1.3  1998/04/21 18:38:33  heller
#* Final Release...
#*
#* Revision 1.2  1998/02/15 18:40:54  heller
#* Update printer library.
#*
#* Revision 1.1  1998/01/29 00:07:38  heller
#* Initial revision
#*
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Home Librarian Database -- a program for maintaining a database
#*                                for a home library
#*     Copyright (C) 1991-1997  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

#@Chapter: HL20\_PrintLibr.tcl -- print library.
#@Label: HL20PrintLibr.tcl
#$Id: HL20_PrintLibr.tcl,v 1.4 1998/05/17 21:14:18 heller Rel $

global PrintOnlyOptions
# Array of option slots for ``Print Only''.
# [index] PrintOnlyOptions!global variable

global NumPrintOnlyOptions
# The number of currently active ``Print Only'' options.
# [index] NumPrintOnlyOptions!global variable

set NumPrintOnlyOptions 0

global FileOrPrinter
# Print to a file or a printer flag.
# [index] FileOrPrinter!global variable

set FileOrPrinter Printer

global PrintFormat
# Print format value.
# [index] PrintFormat!global variable

set PrintFormat {3x5}

global PrintBy
# Which tree to traverse when printing.
# [index] PrintBy!global variable

set PrintBy Id

global PrintOnlyP
# Print Only flag.
# [index] PrintOnlyP!global variable

set PrintOnlyP 0

proc RemovePrintOnlyOptionFrame {parent} {
# Remove the last Print Only Option frame.
# [index] RemovePrintOnlyOptionFrame!procedure

  global NumPrintOnlyOptions

  if {$NumPrintOnlyOptions < 2} {return}

  catch "destroy $parent.frame$NumPrintOnlyOptions"

  incr NumPrintOnlyOptions -1
  focus $parent.frame$NumPrintOnlyOptions.value
}

proc PrintOnlyOptionFrame {parent {initstate normal}} {
# Insert a new Print Only Option frame.
# [index] PrintOnlyOptionFrame!procedure

  global NumPrintOnlyOptions

  incr NumPrintOnlyOptions
  # build widget $parent.frame$NumPrintOnlyOptions
  frame $parent.frame$NumPrintOnlyOptions \
    -borderwidth {2} -relief {groove}
  tk_optionMenu $parent.frame$NumPrintOnlyOptions.field \
		PrintOnlyOptions($NumPrintOnlyOptions,field) \
		{Author} \
		{Title} \
		{Type} \
		{Location Type} \
		{Location} \
		{Category} \
		{Publisher} \
		{Id} \
		{Volume} \
		{Year} \
		{City}
  $parent.frame$NumPrintOnlyOptions.field config -takefocus 0
  $parent.frame$NumPrintOnlyOptions.field configure -state $initstate
  tk_optionMenu $parent.frame$NumPrintOnlyOptions.predicate \
  		PrintOnlyOptions($NumPrintOnlyOptions,predicate) \
		{Contains} \
		{Is} \
		{Is Not} \
		{Is Less Than} \
		{Is Greater Than} \
		{Matches (regular expression)}
  $parent.frame$NumPrintOnlyOptions.predicate config -takefocus 0
  $parent.frame$NumPrintOnlyOptions.predicate configure -state $initstate
  entry $parent.frame$NumPrintOnlyOptions.value \
  	-textvariable PrintOnlyOptions($NumPrintOnlyOptions,value) \
	-state $initstate \
  	-exportselection 0

  set PrintOnlyOptions($NumPrintOnlyOptions,value) {}

  pack configure $parent.frame$NumPrintOnlyOptions.field -side left
  pack configure $parent.frame$NumPrintOnlyOptions.predicate -side left
  pack configure $parent.frame$NumPrintOnlyOptions.value \
	-side right -expand 1 -fill x

  pack configure $parent.frame$NumPrintOnlyOptions -side top -fill x
  focus $parent.frame$NumPrintOnlyOptions.value
}

proc FormPrintOnlyExprList {} {
# Form a print only expr list.
# [index] FormPrintOnlyExprList!procedure

  global NumPrintOnlyOptions
  global PrintOnlyOptions
  set result {}
  for {set i 1} {$i <= $NumPrintOnlyOptions} {incr i} {
    lappend result [list $PrintOnlyOptions($i,field) \
			 $PrintOnlyOptions($i,predicate) \
			 $PrintOnlyOptions($i,value)]
  }
  return "$result"
}

proc PrintDialog {} {
# Put up a print dialog.
# [index] PrintDialog!procedure

  global NumPrintOnlyOptions
  set NumPrintOnlyOptions 0
  global FileOrPrinter
  set FileOrPrinter Printer
  global PrintFormat
  set PrintFormat {3x5}
  global PrintBy
  set PrintBy Id
  global PrintOnlyP
  set PrintOnlyP 0

# .printDialog
# The above line makes pasting MUCH easier for me.
# It contains the pathname of the cutted widget.
# Tcl version: 7.6 (Tcl/Tk/XF)
# Tk version: 4.2
# XF version: 4.0
#

  # build widget .printDialog
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .printDialog"
  } {
    catch "destroy .printDialog"
  }
  toplevel .printDialog 

  # Window manager configurations
  wm maxsize .printDialog 1265 994
  wm minsize .printDialog 1 1
  wm title .printDialog {Print A Card Caralog}
  wm transient .printDialog .

  # build widget .printDialog.top
  frame .printDialog.top \
    -borderwidth {2}

  # build widget .printDialog.top.label2
  label .printDialog.top.label2 \
    -image {SmallFace}

  # build widget .printDialog.top.label3
  label .printDialog.top.label3 \
    -background {yellow} \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -foreground {brown} \
    -text {Print A Card Catalog}

  # build widget .printDialog.fileOrPrinter
  frame .printDialog.fileOrPrinter \
    -borderwidth {2} \
    -relief {groove}

  # build widget .printDialog.fileOrPrinter.radio
  frame .printDialog.fileOrPrinter.radio \
    -borderwidth {2}

  # build widget .printDialog.fileOrPrinter.radio.radiobutton16
  radiobutton .printDialog.fileOrPrinter.radio.radiobutton16 \
    -text {File} \
    -value {File} \
    -takefocus 0 \
    -variable {FileOrPrinter} \
    -command {
	foreach w [winfo children  .printDialog.fileOrPrinter.fileFrame] {
	   catch "$w configure -state normal"
	}
	foreach w [winfo children .printDialog.fileOrPrinter.printerFrame] {
	   catch "$w configure -state disabled"
	}
	focus .printDialog.fileOrPrinter.fileFrame.filename
    }

  # build widget .printDialog.fileOrPrinter.radio.radiobutton17
  radiobutton .printDialog.fileOrPrinter.radio.radiobutton17 \
    -text {Printer} \
    -value {Printer} \
    -variable {FileOrPrinter} \
    -takefocus 0 \
    -command {
	foreach w [winfo children .printDialog.fileOrPrinter.fileFrame] {
	   catch "$w configure -state disabled"
	}
	foreach w [winfo children .printDialog.fileOrPrinter.printerFrame] {
	    catch "$w configure -state normal"
	}
	focus .printDialog.fileOrPrinter.printerFrame.printer
    }

  # build widget .printDialog.fileOrPrinter.fileFrame
  frame .printDialog.fileOrPrinter.fileFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .printDialog.fileOrPrinter.fileFrame.label4
  label .printDialog.fileOrPrinter.fileFrame.label4 \
    -text {Filename:}

  # build widget .printDialog.fileOrPrinter.fileFrame.filename
  entry .printDialog.fileOrPrinter.fileFrame.filename \
    -state disabled \
    -exportselection 0

  # build widget .printDialog.fileOrPrinter.fileFrame.button6
  button .printDialog.fileOrPrinter.fileFrame.button6 \
    -padx {11} \
    -pady {4} \
    -takefocus 0 \
    -text {Browse} \
    -state disabled \
    -command {
	set fname [tk_getSaveFile \
			-defaultextension {.ps}\
			-initialfile "[.printDialog.fileOrPrinter.fileFrame.filename get]" \
			-title "Select a file to print library to" \
			-filetypes {{{PostScript Files} {.ps} {TEXT}}}]
	if {[string length "$fname"] > 0} {
	   .printDialog.fileOrPrinter.fileFrame.filename delete 0 end
	   .printDialog.fileOrPrinter.fileFrame.filename insert 0 "$fname"
	}
    }

  # build widget .printDialog.fileOrPrinter.printerFrame
  frame .printDialog.fileOrPrinter.printerFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .printDialog.fileOrPrinter.printerFrame.label19
  label .printDialog.fileOrPrinter.printerFrame.label19 \
    -text {Print Command (Postscript printer):}

  # build widget .printDialog.printerFrame.printer
  entry .printDialog.fileOrPrinter.printerFrame.printer \
    -exportselection 0

  # build widget .printDialog.formatFrame
  frame .printDialog.formatFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .printDialog.formatFrame.radiobutton22
  radiobutton .printDialog.formatFrame.radiobutton22 \
    -text {3x5 Cards} \
    -value {3x5} \
    -takefocus 0 \
    -variable {PrintFormat} \
    -command {
	.printDialog.formatFrame.format configure -state disabled
	.printDialog.formatFrame.button26 configure -state disabled
    }

  # build widget .printDialog.formatFrame.radiobutton23
  radiobutton .printDialog.formatFrame.radiobutton23 \
    -text {5x8 Cards} \
    -value {5x8} \
    -takefocus 0 \
    -variable {PrintFormat} \
    -command {
	.printDialog.formatFrame.format configure -state disabled
	.printDialog.formatFrame.button26 configure -state disabled
    }

  # build widget .printDialog.formatFrame.radiobutton24
  radiobutton .printDialog.formatFrame.radiobutton24 \
    -text {Other Format:} \
    -value {Other} \
    -takefocus 0 \
    -variable {PrintFormat} \
    -command {
	.printDialog.formatFrame.format configure -state normal
	.printDialog.formatFrame.button26 configure -state normal
	focus .printDialog.formatFrame.format
    }

  # build widget .printDialog.formatFrame.format
  entry .printDialog.formatFrame.format \
    -state disabled \
    -exportselection 0

  # build widget .printDialog.formatFrame.button26
  button .printDialog.formatFrame.button26 \
    -padx {11} \
    -pady {4} \
    -text {Browse} \
    -takefocus 0 \
    -state disabled \
    -command {
	set fname [tk_getOpenFile \
			-defaultextension {.tcl}\
			-initialfile "[.printDialog.formatFrame.format get]" \
			-title "Select a file to print library to" \
			-filetypes {{{Tcl Files} {.tcl} {TEXT}}}]
	if {[string length "$fname"] > 0} {
	   .printDialog.formatFrame.format delete 0 end
	   .printDialog.formatFrame.format insert 0 "$fname"
	}
    }

  # build widget .printDialog.formatFrame.label41
  label .printDialog.formatFrame.label41 \
    -text {Print:}

  # build widget .printDialog.printByFrame
  frame .printDialog.printByFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .printDialog.printByFrame.radiobutton36
  radiobutton .printDialog.printByFrame.radiobutton36 \
    -text {Shelf List} \
    -takefocus 0 \
    -value {Id} \
    -variable {PrintBy}

  # build widget .printDialog.printByFrame.radiobutton37
  radiobutton .printDialog.printByFrame.radiobutton37 \
    -text {by Subject} \
    -takefocus 0 \
    -value {Subject} \
    -variable {PrintBy}

  # build widget .printDialog.printByFrame.radiobutton38
  radiobutton .printDialog.printByFrame.radiobutton38 \
    -text {by Title} \
    -value {Title} \
    -takefocus 0 \
    -variable {PrintBy}

  # build widget .printDialog.printByFrame.radiobutton39
  radiobutton .printDialog.printByFrame.radiobutton39 \
    -text {by Author} \
    -value {Author} \
    -takefocus 0 \
    -variable {PrintBy}

  # build widget .printDialog.printByFrame.label40
  label .printDialog.printByFrame.label40 \
    -text {Print:}

  # build widget .printDialog.printOnlyFrame
  frame .printDialog.printOnlyFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .printDialog.printOnlyFrame.button46
  button .printDialog.printOnlyFrame.button46 \
    -padx {11} \
    -pady {4} \
    -takefocus 0 \
    -text {More...} \
    -command {PrintOnlyOptionFrame .printDialog.printOnlyFrame.frame47} \
    -state disabled

  # build widget .printDialog.printOnlyFrame.button47
  button .printDialog.printOnlyFrame.button47 \
    -padx {11} \
    -pady {4} \
    -text {Less...} \
    -command {RemovePrintOnlyOptionFrame .printDialog.printOnlyFrame.frame47} \
    -takefocus 0 \
    -state disabled

  # build widget .printDialog.printOnlyFrame.frame47
  frame .printDialog.printOnlyFrame.frame47

  PrintOnlyOptionFrame .printDialog.printOnlyFrame.frame47 disabled

  # build widget .printDialog.printOnlyFrame.checkbutton49
  checkbutton .printDialog.printOnlyFrame.checkbutton49 \
    -text {Print Only:} \
    -takefocus 0 \
    -variable {PrintOnlyP} \
    -command {
	global PrintOnlyP
	global NumPrintOnlyOptions
	if {$PrintOnlyP} {
	    .printDialog.printOnlyFrame.button46 configure -state normal
	    .printDialog.printOnlyFrame.button47 configure -state normal
	    for {set i 1} {$i <= $NumPrintOnlyOptions} {incr i} {
		.printDialog.printOnlyFrame.frame47.frame$i.field configure -state normal
		.printDialog.printOnlyFrame.frame47.frame$i.predicate configure -state normal
		.printDialog.printOnlyFrame.frame47.frame$i.value configure -state normal
	    }
	    focus .printDialog.printOnlyFrame.frame47.frame1.value
	} else {
	    .printDialog.printOnlyFrame.button46 configure -state disabled
	    .printDialog.printOnlyFrame.button47 configure -state disabled
	    for {set i 1} {$i <= $NumPrintOnlyOptions} {incr i} {
		.printDialog.printOnlyFrame.frame47.frame$i.field configure -state disabled
		.printDialog.printOnlyFrame.frame47.frame$i.predicate configure -state disabled
		.printDialog.printOnlyFrame.frame47.frame$i.value configure -state disabled
	    }
	}
    }

		

  # build widget .printDialog.buttons
  frame .printDialog.buttons \
    -borderwidth {2}

  # build widget .printDialog.buttons.button31
  button .printDialog.buttons.button31 \
    -padx {11} \
    -pady {4} \
    -takefocus 0 \
    -text {OK} \
    -command {
	global FileOrPrinter
	global PrintFormat
	global PrintBy
	global PrintOnlyP
	set printFileName "[.printDialog.fileOrPrinter.fileFrame.filename get]"
	set printCommand "[.printDialog.fileOrPrinter.printerFrame.printer get]"
	set format "[.printDialog.formatFrame.format get]"
	if {"[info procs XFEdit]" != ""} {
	  catch "XFDestroy .printDialog"
	} {
	  catch "destroy .printDialog"
	}
	DoPrint $FileOrPrinter $PrintFormat $PrintBy $PrintOnlyP \
		"$printFileName" \
		"$printCommand" \
		"$format" \
		"[FormPrintOnlyExprList]"
    }

  # build widget .printDialog.buttons.button32
  button .printDialog.buttons.button32 \
    -padx {11} \
    -pady {4} \
    -takefocus 0 \
    -text {Cancel} \
    -command {
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .printDialog"
  } {
    catch "destroy .printDialog"
  }
    }

  # build widget .printDialog.buttons.button33
  button .printDialog.buttons.button33 \
    -padx {11} \
    -takefocus 0 \
    -pady {4} \
    -text {Help} \
    -command {hl_Help {Printing a Card Catalog database}}

  # pack master .printDialog.top
  pack configure .printDialog.top.label2 \
    -fill y \
    -side left
  pack configure .printDialog.top.label3 \
    -fill x \
    -side right \
    -expand 1

  # pack master .printDialog.fileOrPrinter
  pack configure .printDialog.fileOrPrinter.radio \
    -fill x
  pack configure .printDialog.fileOrPrinter.fileFrame \
    -fill x
  pack configure .printDialog.fileOrPrinter.printerFrame \
    -fill x

  # pack master .printDialog.fileOrPrinter.radio
  pack configure .printDialog.fileOrPrinter.radio.radiobutton16 \
    -expand 1 \
    -side left
  pack configure .printDialog.fileOrPrinter.radio.radiobutton17 \
    -expand 1 \
    -side right

  # pack master .printDialog.fileOrPrinter.fileFrame
  pack configure .printDialog.fileOrPrinter.fileFrame.label4 \
    -side left
  pack configure .printDialog.fileOrPrinter.fileFrame.filename \
    -expand 1 \
    -fill x \
    -side left
  pack configure .printDialog.fileOrPrinter.fileFrame.button6 \
    -side right

  # pack master .printDialog.fileOrPrinter.printerFrame
  pack configure .printDialog.fileOrPrinter.printerFrame.label19 \
    -side left
  pack configure .printDialog.fileOrPrinter.printerFrame.printer \
    -expand 1 \
    -fill x \
    -side right

  # pack master .printDialog.formatFrame
  pack configure .printDialog.formatFrame.label41 \
    -side left
  pack configure .printDialog.formatFrame.radiobutton22 \
    -side left
  pack configure .printDialog.formatFrame.radiobutton23 \
    -side left
  pack configure .printDialog.formatFrame.radiobutton24 \
    -side left
  pack configure .printDialog.formatFrame.format \
    -side left -fill x -expand 1
  pack configure .printDialog.formatFrame.button26 \
    -side right

  # pack master .printDialog.printByFrame
  pack configure .printDialog.printByFrame.label40 \
    -side left
  pack configure .printDialog.printByFrame.radiobutton36 \
    -expand 1 \
    -side left
  pack configure .printDialog.printByFrame.radiobutton37 \
    -expand 1 \
    -side left
  pack configure .printDialog.printByFrame.radiobutton38 \
    -expand 1 \
    -side left
  pack configure .printDialog.printByFrame.radiobutton39 \
    -expand 1 \
    -side right

  # pack master .printDialog.printOnlyFrame
  pack configure .printDialog.printOnlyFrame.checkbutton49 \
    -side left -expand 1 -fill y
  pack configure .printDialog.printOnlyFrame.button47 \
    -side right -expand 1 -fill y
  pack configure .printDialog.printOnlyFrame.button46 \
    -side right -expand 1 -fill y
  pack configure .printDialog.printOnlyFrame.frame47 \
    -expand 1 \
    -fill x \
    -side left

  # pack master .printDialog.buttons
  pack configure .printDialog.buttons.button31 \
    -expand 1 \
    -side left
  pack configure .printDialog.buttons.button32 \
    -expand 1 \
    -side left
  pack configure .printDialog.buttons.button33 \
    -expand 1 \
    -side right

  # pack master .printDialog
  pack configure .printDialog.top -fill x
  global tcl_platform
  if {"$tcl_platform(platform)" == {unix}} {
    pack configure .printDialog.fileOrPrinter \
      -fill x
  }
  pack configure .printDialog.formatFrame \
    -fill x
  pack configure .printDialog.printByFrame \
    -fill x
  pack configure .printDialog.printOnlyFrame \
    -fill x
  pack configure .printDialog.buttons \
    -fill both

  global CurrentCardCatalog
  .printDialog.fileOrPrinter.fileFrame.filename configure -state normal
  .printDialog.fileOrPrinter.fileFrame.filename insert end "[formPSName [$CurrentCardCatalog filename]]"
  .printDialog.fileOrPrinter.fileFrame.filename configure -state disabled
  .printDialog.fileOrPrinter.printerFrame.printer insert end {lpr -}
  .printDialog.formatFrame.format insert end {}


# end of widget tree

  wm withdraw .printDialog
  update idletasks
  set x [expr [winfo screenwidth .printDialog]/2 - \
	      [winfo reqwidth .printDialog]/2 - \
	      [winfo vrootx .]]
  set y [expr [winfo screenheight .printDialog]/2 - \
	      [winfo reqheight .printDialog]/2 - \
	      [winfo vrooty .]]
  wm geom .printDialog +$x+$y
  wm deiconify .printDialog
  update idletasks
  grab .printDialog
  tkwait window .printDialog

}

proc formPSName {filename} {
# generate a base PostScript filename from filename
# [index] formPSName!procedure

  return [join [list [file rootname [file tail "$filename"]] {ps}] {.}]
}

proc PrintCurrentLibrary {} {
# Print the current library.
# [index] PrintCurrentLibrary!procedure

  global CurrentCardCatalog
  if {[string compare "$CurrentCardCatalog" {}] == 0} {return}
  PrintDialog
}

proc FetchSubjects {Id} {
# Hook function to get the subject list for the specified Id.
# This proc gets aliased into the safe interpreter used to print
# items.
# [index] FetchSubjects!procedure

  global CurrentCardCatalog
  return [$CurrentCardCatalog fetchsubjs "$Id"]
}

proc FetchTitles {Id} {
# Hook function to get the title list for the specified Id.
# This proc gets aliased into the safe interpreter used to print
# items.
# [index] FetchTitles!procedure

  global CurrentCardCatalog
  return [$CurrentCardCatalog fetchtitles "$Id"]
}

proc FetchAuthors {Id} {
# Hook function to get the author list for the specified Id.
# This proc gets aliased into the safe interpreter used to print
# items.
# [index] FetchAuthors!procedure

  global CurrentCardCatalog
  return [$CurrentCardCatalog fetchauthors "$Id"]
}

proc FetchTypeName {cardtype} {
# Hook function to get the type name for the specified card type code.
# This proc gets aliased into the safe interpreter used to print
# items.
# [index] FetchTypeName!procedure

  global CurrentCardCatalog
  return [$CurrentCardCatalog cardtypename $cardtype]
}

proc FetchLTypeName {ltype} {
# Hook function to get the location type name for the specified location 
# type code.
# This proc gets aliased into the safe interpreter used to print
# items.
# [index] FetchLTypeName!procedure

  global CurrentCardCatalog
  return [$CurrentCardCatalog locationtypename $ltype]
}

proc FetchCategory {ccode} {
# Hook function to get the category for the specified category code.
# This proc gets aliased into the safe interpreter used to print
# items.
# [index] FetchCategory!procedure

  global CurrentCardCatalog
  return [$CurrentCardCatalog category $ccode]
}

proc DoPrint {FileOrPrinter PrintFormat PrintBy PrintOnlyP printFileName printerCommand Format PrintOnlyExprL} {
# Start the print job
# [index] DoPrint!procedure

  global CurrentCardCatalog

  global LibDir	
  switch -exact -- "$PrintFormat" {
    3x5 {
	set FormatFile "[file join $LibDir HL_PR3x5.tcl]"
    }
    5x8 {
	set FormatFile "[file join $LibDir HL_PR5x8.tcl]"
    }
    Other {
	set FormatFile "$Format"
    }
  }

  if {[catch [list open "$FormatFile" r] ifp]} {
    hl_error "Error opening $FormatFile: $ifp"
    return
  }

  set prscript "[read $ifp]"
  close $ifp

  interp create -safe printInterp

  printInterp alias printer printer
  printInterp alias FetchSubjects FetchSubjects
  printInterp alias FetchAuthors FetchAuthors
  printInterp alias FetchTitles FetchTitles
  printInterp alias FetchTypeName FetchTypeName
  printInterp alias FetchLTypeName FetchLTypeName
  printInterp alias FetchCategory FetchCategory
  interp share {} stderr printInterp
  interp share {} stdout printInterp
  printInterp eval {proc BeginCards {} {}}
  printInterp eval {proc EndCards {} {}}


  if {[catch [list printInterp eval $prscript] mess]} {
    hl_error "Error sourcing $FormatFile: $mess"
    interp delete printInterp
    return
  }

  StartWorking
  global tcl_platform
  if {"$tcl_platform(platform)" == {unix}} {
    if {[catch [list printer open "$FileOrPrinter" "$printerCommand" "$printFileName"] mess]} {
      hl_error "Error opening printer: $mess"
      interp delete printInterp
      EndWorking
      return
    }
  } else {
    if {[catch "printer open" mess]} {
      hl_error "Error opening printer: $mess"
      interp delete printInterp
      EndWorking
      return
    }
  }

  if {[catch "printer styledialog" mess]} {
    hl_error "Error with style dialog: $mess"
    interp delete printInterp
    catch "printer close"
    EndWorking
    return
  }
  if {[catch "printer jobdialog" mess]} {
    hl_error "Error with job dialog: $mess"
    interp delete printInterp
    catch "printer close"
    EndWorking
    return
  }
  if {[catch "printer opendoc" mess]} {
    hl_error "Error opening printer document: $mess"
    interp delete printInterp
    catch "printer close"
    EndWorking
    return
  }

  if {[catch [list printInterp eval BeginCards] error]} {
    hl_error "Error in BeginCards: $error"
    interp delete printInterp
    catch "printer close"
    EndWorking
    return
  }

  switch -exact -- "$PrintBy" {
    Id {
	if {[catch [list $CurrentCardCatalog traverseid "PrintTheCard {Shelf List} {%k} %i printInterp $PrintOnlyP {$PrintOnlyExprL}"] mess]} {
	  hl_error "Error traversing Ids: $mess"
        }
    }
    Subject {
	if {[catch [list $CurrentCardCatalog traversesubj "PrintTheList {%k} %i {author title} printInterp $PrintOnlyP {$PrintOnlyExprL}"] mess]} {
	  hl_error "Error traversing Subjects: $mess"
        }
    }
    Title {
	if {[catch [list $CurrentCardCatalog traversetitle "PrintTheList {%k} %i {title author} printInterp $PrintOnlyP {$PrintOnlyExprL}"] mess]} {
	  hl_error "Error traversing Titles: $mess"
        }
    }
    Author {
	if {[catch [list $CurrentCardCatalog traverseauthor "PrintTheList {%k} %i {author title} printInterp $PrintOnlyP {$PrintOnlyExprL}"] mess]} {
	  hl_error "Error traversing Authors: $mess"
        }
    }
  }

  if {[catch [list printInterp eval EndCards] error]} {
    hl_error "Error in EndCards: $error"
  }

  printInterp eval close stderr
  printInterp eval close stdout
  interp delete printInterp

  if {[catch "printer closedoc" mess]} {
    hl_error "Error closing printer document: $mess"
    catch "printer close"
    EndWorking
    return
  }
  if {[catch "printer close" mess]} {
    hl_error "Error closing printer: $mess"
    EndWorking
    return
  }
  EndWorking
}

proc PrintTheCard {heading Id Record theInterp PrintOnlyP PrintOnlyExprL} {
# Procedure to actually print the card.  After doing the print only check,
# it calls the user supplied ``DoCard'' function to actually print the card.
# [index] PrintTheCard!procedure

  global CurrentCardCatalog
  if {$PrintOnlyP} {
    foreach POE $PrintOnlyExprL {
      set field [lindex $POE 0]
      set predicate [lindex $POE 1]
      set value [lindex $POE 2]
      switch -exact -- "$field" {
	Author {set tval "[$Record author]"}
	Title {set tval "[$Record title]"}
	Type {set tval "[$CurrentCardCatalog cardtypename [$Record cardtype]]"}
	{Location Type} {set tval "[$CurrentCardCatalog locationtypename [$Record locationtype]]"}
	Location {set tval "[$Record location]"}
	Category {set tval "[$CurrentCardCatalog category [$Record catcode]]"}
	Publisher {set tval "[$Record publisher]"}
	Id {set tval "$Id"}
	Volume {set tval [$Record volume]}
	Year {set tval [$Record year]}
	City {set tval "[$Record city]"}
      }
      switch -exact -- "$predicate" {
	Contains {if {[string first "$value" "$tval"] < 0} {return}}
	Is {if {[string compare "$value" "$tval"] != 0} {return}}
	{Is Not} {if {[string compare "$value" "$tval"] == 0} {return}}
	{Is Less Than} {if {[string compare "$value" "$tval"] >= 0} {return}}
	{Is Greater Than} {if {[string compare "$value" "$tval"] <= 0} {return}}
	{Matches (regular expression)} {
	  if {[regexp "$value" "$tval"] == 0} {return}
	}
      }
    }
  }
#  set subjlist [$CurrentCardCatalog fetchsubjs "$Id"]
#  set authorlist [$CurrentCardCatalog fetchauthors "$Id"]
#  set titlelist [$CurrentCardCatalog fetchtitles "$Id"]

  $theInterp alias $Record $Record
  $theInterp eval [list DoCard "$heading" "$Id" $Record]
  puts [list DoCard "$heading" "$Id" $Record]
  $theInterp alias $Record {}
}

proc fieldsort {fieldnames a b} {
# Helper function to sort a field list.
# [index] fieldsort!procedure

  global CurrentCardCatalog
  set ra [$CurrentCardCatalog readid "$a"]
  set rb [$CurrentCardCatalog readid "$b"]
  set comp 0
  set fnum 0
  set flen [llength $fieldnames]
  while {$comp == 0} {
    if {$fnum >= $flen} {
      $ra delete
      $rb delete
      return $comp
    }
    set field [lindex $fieldnames $fnum]
    set comp [string compare "[$ra $field]" "[$rb $field]"]
    incr fnum
  }
  $ra delete
  $rb delete
  return $comp
}

proc SortIds {idlist sortfieldnames} {
# Helper function to sort an id list.
# [index] SortIds!procedure

  return [lsort -command [list fieldsort "$sortfieldnames"] "$idlist"]
}

proc PrintTheList {heading List sortfieldnames theInterp PrintOnlyP PrintOnlyExprL} {
# Print an id list of cards.
# [index] PrintTheList!procedure

  global CurrentCardCatalog
  foreach Id [SortIds "$List" "$sortfieldnames"] {
    set Record [$CurrentCardCatalog readid "$Id"]
    PrintTheCard "$heading" "$Id" "$Record" $theInterp $PrintOnlyP "$PrintOnlyExprL"
    $Record delete
  }
}



package provide HL20_PrintLibr 1.0
