#* 
#* ------------------------------------------------------------------
#* Home Libarian 2.0 by Deepwoods Software
#* ------------------------------------------------------------------
#* HL20_PrLayout.tcl - Code to implement the Print Layout dialog
#* Created by Robert Heller on Tue Mar 24 10:31:54 1998
#* ------------------------------------------------------------------
#* Modification History: 
#* $Log: HL20_PrLayout.tcl,v $
#* Revision 1.4  1998/05/17 21:14:18  heller
#* Add in indexing
#*
#* Revision 1.3  1998/05/17 02:10:03  heller
#* Adjust sizes of the textInBBoxDialog dialog.
#*
#* Revision 1.2  1998/05/01 23:41:22  heller
#* Disable useless "Edit Tcl Code" button.
#*
#* Revision 1.1  1998/04/21 18:39:45  heller
#* Initial revision
#*
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Home Librarian Database -- a program for maintaining a database
#*                                for a home library
#*     Copyright (C) 1991-1998  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

#@Chapter: HL20\_PrLayout.tcl -- Print Layout
#@Label: HL20PrLayout.tcl
#$Id: HL20_PrLayout.tcl,v 1.4 1998/05/17 21:14:18 heller Rel $


# This file contains the code to handle the Print Layout dialog

global printLayout
# Contains the state info for the print layout.  This is a Tcl array with the
# fields:
#
# <Script>		The generated or loaded script. Initially it is {}.
# <Filename>		The name of the file currently being edited. 
#			Initially it is {}.
# <Dirty>		Dirty flag. Initially it is 0.
# <ScriptOutdated>	Flag to indicate if the script needs regenerating. 
#			Initially it is 0.
# <NumRows>		Number of rows per page. Initially it is 1.
# <NumCols>		Number of columns per page. Initially it is 1.
# <PageWidth>		Width of each print item. Initially it is 8.5 (inches).
# <PageHeight>		Height of each print item. Initially it is 11 (inches).
# <ColumnOffsets>	List of column offsets. Initially it is {0}.
# <RowOffsets>		List of row offsets. Initially it is {0}.
# <RORadio>		Row radiobutton variable. Initially it is Regular.
# <COBase>		Column base. Initially it is 0.
# <COInterval>		Column interval. Initially it is 0.
# <CORadio>		Column radiobutton variable. Initially it is Regular.
# <ROBase>		Row base. Initially it is 0.
# <ROInterval>		Row interval. Initially it is 0.
# <ItemList>		Item list. Initially it is {}.
# <SelectedItem>	Currently selected item. Initially it is {}.
# [index] printLayout!global variable

set printLayout(Script) {}
set printLayout(Filename) {}
set printLayout(Dirty) 0
set printLayout(ScriptOutdated) 0
set printLayout(NumRows) 1
set printLayout(NumCols) 1
set printLayout(PageWidth) 8.5
set printLayout(PageHeight) 11
set printLayout(ColumnOffsets) {0}
set printLayout(RowOffsets) {0}
set printLayout(RORadio) Regular
set printLayout(COBase) 0
set printLayout(COInterval) 0
set printLayout(CORadio) Regular
set printLayout(ROBase) 0
set printLayout(ROInterval) 0
set printLayout(ItemList) {}
set printLayout(SelectedItem) {}

proc hl_printLayout {{filename {}}} {
# Main entry to creating or editing print layout files.
#
# First ask if this is a new or old layout file, and then fetch
# the file name and load up the editor.
# [index] hl\_printLayout!procedure

  global printLayout

# .printLayout
# The above line makes pasting MUCH easier for me.
# It contains the pathname of the cutted widget.
# Tcl version: 7.6 (Tcl/Tk/XF)
# Tk version: 4.2
# XF version: 4.0
#

  # build widget .printLayout
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .printLayout"
  } {
    catch "destroy .printLayout"
  }
  toplevel .printLayout 

  # Window manager configurations
  wm positionfrom .printLayout ""
  wm sizefrom .printLayout ""
  wm maxsize .printLayout 1000 1000
  wm minsize .printLayout 10 10
  wm protocol .printLayout 
  wm title .printLayout {Print Layout}


  # build widget .printLayout.frame0
  frame .printLayout.frame0 \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .printLayout.frame0.frame1
  frame .printLayout.frame0.frame1

  # build widget .printLayout.frame0.frame1.frame3
  frame .printLayout.frame0.frame1.frame3

  # build widget .printLayout.frame0.frame1.frame3.frame5
  frame .printLayout.frame0.frame1.frame3.frame5 \
    -borderwidth {2}

  # build widget .printLayout.frame0.frame1.frame3.frame5.canvas8
  canvas .printLayout.frame0.frame1.frame3.frame5.canvas8 \
    -borderwidth {2} \
    -height {150} \
    -relief {sunken} \
    -width {300} \
    -xscrollcommand {.printLayout.frame0.frame1.frame4.frame5.scrollbar10 set} \
    -yscrollcommand {.printLayout.frame0.frame1.frame3.frame6.scrollbar9 set}
  canvas .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet \
	-width 0 -height 0 -background white \
	-borderwidth 2 -highlightthickness 0 -relief ridge
  # build canvas items .printLayout.frame0.frame1.frame3.frame5.canvas8
  .printLayout.frame0.frame1.frame3.frame5.canvas8 create window 0 0 \
	-window .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet \
	-tags Sheet -anchor nw
  # bindings
  global tcl_platform
  if {$tcl_platform(platform) == "unix"} {
    bind .printLayout.frame0.frame1.frame3.frame5.canvas8 <Button-2> {StartHand %W %x %y}
    bind .printLayout.frame0.frame1.frame3.frame5.canvas8 <B2-Motion> {MoveHand %W %x %y}
    bind .printLayout.frame0.frame1.frame3.frame5.canvas8 <ButtonRelease-2> {StopHand %W %x %y}
    bind .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet <Button-2> {StartHandS %W %x %y}
    bind .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet <B2-Motion> {MoveHandS %W %x %y}
    bind .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet <ButtonRelease-2> {StopHandS %W %x %y}
  } elseif {$tcl_platform(platform) == "macintosh"} {
    bind .printLayout.frame0.frame1.frame3.frame5.canvas8 <Command-Button-1> {StartHand %W %x %y}
    bind .printLayout.frame0.frame1.frame3.frame5.canvas8 <Command-B1-Motion> {MoveHand %W %x %y}
    bind .printLayout.frame0.frame1.frame3.frame5.canvas8 <Commant-ButtonRelease-1> {StopHand %W %x %y}
    bind .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet <Command-Button-1> {StartHandS %W %x %y}
    bind .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet <Command-B1-Motion> {MoveHandS %W %x %y}
    bind .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet <Commant-ButtonRelease-1> {StopHandS %W %x %y}
  } else {
    bind .printLayout.frame0.frame1.frame3.frame5.canvas8 <Control-Button-1> {StartHand %W %x %y}
    bind .printLayout.frame0.frame1.frame3.frame5.canvas8 <Control-B1-Motion> {MoveHand %W %x %y}
    bind .printLayout.frame0.frame1.frame3.frame5.canvas8 <Control-ButtonRelease-1> {StopHand %W %x %y}
    bind .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet <Control-Button-1> {StartHandS %W %x %y}
    bind .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet <Control-B1-Motion> {MoveHandS %W %x %y}
    bind .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet <Control-ButtonRelease-1> {StopHandS %W %x %y}
  }

  # build widget .printLayout.frame0.frame1.frame3.frame6
  frame .printLayout.frame0.frame1.frame3.frame6 \
    -borderwidth {2}

  # build widget .printLayout.frame0.frame1.frame3.frame6.scrollbar9
  scrollbar .printLayout.frame0.frame1.frame3.frame6.scrollbar9 \
    -command {.printLayout.frame0.frame1.frame3.frame5.canvas8 yview} \
    -width {13}

  # build widget .printLayout.frame0.frame1.frame4
  frame .printLayout.frame0.frame1.frame4 \
    -borderwidth {1}

  # build widget .printLayout.frame0.frame1.frame4.frame5
  frame .printLayout.frame0.frame1.frame4.frame5 \
    -borderwidth {2}

  # build widget .printLayout.frame0.frame1.frame4.frame5.scrollbar10
  scrollbar .printLayout.frame0.frame1.frame4.frame5.scrollbar10 \
    -command {.printLayout.frame0.frame1.frame3.frame5.canvas8 xview} \
    -orient {horizontal} \
    -width {13}

  # build widget .printLayout.frame0.frame1.frame4.frame7
  frame .printLayout.frame0.frame1.frame4.frame7 \
    -borderwidth {2}

  # build widget .printLayout.frame0.frame1.frame4.frame7.frame11
  frame .printLayout.frame0.frame1.frame4.frame7.frame11 \
    -borderwidth {2} \
    -height {13} \
    -width {16}

  # build widget .printLayout.frame0.frame3
  frame .printLayout.frame0.frame3 \
    -borderwidth {2}

  # build widget .printLayout.frame0.frame3.insert
  button .printLayout.frame0.frame3.insert \
    -padx {11} \
    -pady {4} \
    -text {Insert Item} \
    -state disabled \
    -command {PrInsertItem}

  # build widget .printLayout.frame0.frame3.remove
  button .printLayout.frame0.frame3.remove \
    -padx {11} \
    -pady {4} \
    -text {Remove Item} \
    -state disabled \
    -command {PrRemoveItem}

  # build widget .printLayout.frame0.frame3.edit
  button .printLayout.frame0.frame3.edit \
    -padx {11} \
    -pady {4} \
    -text {Edit Item} \
    -state disabled \
    -command {PrEditItem}

  # build widget .printLayout.frame0.frame3.deselect
  button .printLayout.frame0.frame3.deselect \
    -padx {11} \
    -pady {4} \
    -text {Deselect Item} \
    -state disabled \
    -command {PrDeselectItem}

  # build widget .printLayout.frame1
  frame .printLayout.frame1 \
    -borderwidth {2} \
    -relief {groove}

  # build widget .printLayout.frame1.frame
  frame .printLayout.frame1.frame \
    -borderwidth {5}

  # build widget .printLayout.frame1.frame.scrollbar2
  scrollbar .printLayout.frame1.frame.scrollbar2 \
    -command {.printLayout.frame1.frame.listbox1 yview}

  # build widget .printLayout.frame1.frame.frame
  frame .printLayout.frame1.frame.frame

  # build widget .printLayout.frame1.frame.frame.scrollbar3
  scrollbar .printLayout.frame1.frame.frame.scrollbar3 \
    -command {.printLayout.frame1.frame.listbox1 xview} \
    -orient {horizontal}

  # build widget .printLayout.frame1.frame.frame.frame
  frame .printLayout.frame1.frame.frame.frame \
    -height {10} \
    -width {19}

  # build widget .printLayout.frame1.frame.label1
  label .printLayout.frame1.frame.label1 \
    -text {Insertable Items}

  # build widget .printLayout.frame1.frame.listbox1
  listbox .printLayout.frame1.frame.listbox1 \
    -exportselection {0} \
    -width {14} \
    -height 8 \
    -selectmode single \
    -xscrollcommand {.printLayout.frame1.frame.frame.scrollbar3 set} \
    -yscrollcommand {.printLayout.frame1.frame.scrollbar2 set}
  .printLayout.frame1.frame.listbox1 insert end \
	{drawtextat X Y String} \
	{drawtextinbbox X1 Y1 X2 Y2 String} \
	{drawline X1 Y1 X2 Y2 LineWidth} \
	{drawrectangle X1 Y1 X2 Y2 Thickness} \
	{drawfilledrectangle X1 Y1 X2 Y2} \
	{drawoval X1 Y1 X2 Y2 Thickness} \
	{drawfilledoval X1 Y1 X2 Y2} \
	{drawimage X1 Y1 X2 Y2 Bitmap}
  bind .printLayout.frame1.frame.listbox1 <Button-1> {+prl_NormalizeInsertButton}

  # build widget .printLayout.bottomButtons
  frame .printLayout.bottomButtons \
    -borderwidth {2}

  # build widget .printLayout.bottomButtons.save
  button .printLayout.bottomButtons.save \
    -padx {11} \
    -pady {4} \
    -text {Save} \
    -state disabled \
    -command {SaveScript}
  if {$printLayout(Dirty)} {.printLayout.bottomButtons.save config -state normal}

  # build widget .printLayout.bottomButtons.button9
  button .printLayout.bottomButtons.button9 \
    -padx {11} \
    -pady {4} \
    -text {Close} \
    -command {
  if {$printLayout(Dirty)} {
    if {[AskSaveScript]} {
      if {"[info procs XFEdit]" != ""} {
        catch "XFDestroy .printLayout"
      } {
        catch "destroy .printLayout"
      }
    }
  } else {
    if {"[info procs XFEdit]" != ""} {
      catch "XFDestroy .printLayout"
    } {
      catch "destroy .printLayout"
    }
  }
	}

  # build widget .printLayout.bottomButtons.button10
  button .printLayout.bottomButtons.button10 \
    -padx {11} \
    -pady {4} \
    -text {Edit Tcl Code} \
    -state {disabled}

  # build widget .printLayout.bottomButtons.button11
  button .printLayout.bottomButtons.button11 \
    -padx {11} \
    -pady {4} \
    -text {Page Properties} \
    -command {PagePropertiesDialog}

  # build widget .printLayout.bottomButtons.button12
  button .printLayout.bottomButtons.button12 \
    -padx {11} \
    -pady {4} \
    -text {Help} \
    -command {hl_Help {Print Layout Dialog Box}}

  # build widget .printLayout.top
  frame .printLayout.top \
    -borderwidth {2}

  # build widget .printLayout.top.label2
  label .printLayout.top.label2 \
    -image {SmallFace}

  # build widget .printLayout.top.label3
  label .printLayout.top.label3 \
    -background {yellow} \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -foreground {brown} \
    -text {Print Layout}

  # pack master .printLayout.frame0
  pack configure .printLayout.frame0.frame1 \
    -expand 1 \
    -fill both \
    -side left
  pack configure .printLayout.frame0.frame3 \
    -fill y \
    -side right

  # pack master .printLayout.frame0.frame1
  pack configure .printLayout.frame0.frame1.frame3 \
    -expand 1 \
    -fill both
  pack configure .printLayout.frame0.frame1.frame4 \
    -fill x \
    -side bottom

  # pack master .printLayout.frame0.frame1.frame3
  pack configure .printLayout.frame0.frame1.frame3.frame5 \
    -expand 1 \
    -fill both \
    -side left
  pack configure .printLayout.frame0.frame1.frame3.frame6 \
    -fill y \
    -side right

  # pack master .printLayout.frame0.frame1.frame3.frame5
  pack configure .printLayout.frame0.frame1.frame3.frame5.canvas8 \
    -expand 1 \
    -fill both \
    -side left

  # pack master .printLayout.frame0.frame1.frame3.frame6
  pack configure .printLayout.frame0.frame1.frame3.frame6.scrollbar9 \
    -expand 1 \
    -fill y

  # pack master .printLayout.frame0.frame1.frame4
  pack configure .printLayout.frame0.frame1.frame4.frame5 \
    -expand 1 \
    -fill both \
    -side left
  pack configure .printLayout.frame0.frame1.frame4.frame7 \
    -fill y \
    -side right

  # pack master .printLayout.frame0.frame1.frame4.frame5
  pack configure .printLayout.frame0.frame1.frame4.frame5.scrollbar10 \
    -expand 1 \
    -fill x \
    -side left

  # pack master .printLayout.frame0.frame1.frame4.frame7
  pack configure .printLayout.frame0.frame1.frame4.frame7.frame11 \
    -expand 1 \
    -fill both

  # pack master .printLayout.frame0.frame3
  pack configure .printLayout.frame0.frame3.insert \
    -expand 1 \
    -fill x
  pack configure .printLayout.frame0.frame3.remove \
    -expand 1 \
    -fill x
  pack configure .printLayout.frame0.frame3.edit \
    -expand 1 \
    -fill x
  pack configure .printLayout.frame0.frame3.deselect \
    -expand 1 \
    -fill x

  # pack master .printLayout.frame1
  pack configure .printLayout.frame1.frame \
    -expand 1 \
    -fill both \
    -side left

  # pack master .printLayout.frame1.frame
  pack configure .printLayout.frame1.frame.label1 \
    -fill x
  pack configure .printLayout.frame1.frame.frame \
    -fill x \
    -side bottom
  pack configure .printLayout.frame1.frame.scrollbar2 \
    -fill y \
    -padx 4 \
    -side right
  pack configure .printLayout.frame1.frame.listbox1 \
    -expand 1 \
    -fill both

  # pack master .printLayout.frame1.frame.frame
  pack configure .printLayout.frame1.frame.frame.scrollbar3 \
    -expand 1 \
    -fill x \
    -pady 4 \
    -side left
  pack configure .printLayout.frame1.frame.frame.frame \
    -padx 4 \
    -side left

  # pack master .printLayout.bottomButtons
  pack configure .printLayout.bottomButtons.save \
    -expand 1 \
    -side left
  pack configure .printLayout.bottomButtons.button9 \
    -expand 1 \
    -side left
  pack configure .printLayout.bottomButtons.button10 \
    -expand 1 \
    -side left
  pack configure .printLayout.bottomButtons.button11 \
    -expand 1 \
    -side left
  pack configure .printLayout.bottomButtons.button12 \
    -expand 1 \
    -side right

  # pack master .printLayout.top
  pack configure .printLayout.top.label2 \
    -fill y \
    -side left
  pack configure .printLayout.top.label3 \
    -expand 1 \
    -fill x \
    -side right

  # pack master .printLayout
  pack configure .printLayout.top \
    -fill x
  pack configure .printLayout.frame0 \
    -expand 1 \
    -fill both
  pack configure .printLayout.frame1 \
    -fill x
  pack configure .printLayout.bottomButtons \
    -fill x

# end of widget tree
  if {[string length "$filename"] > 0 && \
      [file exists "$filename"] && \
      [file readable "$filename"] && \
      [file writable "$filename"]} {
    set printLayout(Filename) "$filename"
    set fp [open "$filename" r]
    set printLayout(Script) "[read $fp]"
    set printLayout(ScriptOutdated) 0
    ExtractPropertiesFromScript
    close $fp
    set printLayout(Dirty) 0
    set printLayout(ScriptOutdated) 0
  } elseif {[string length "$filename"] > 0} {
    hl_warning "Unusable print layout file '$filename'-- select another"
    set filename {}
  }

  if {[string length "$filename"] == 0} {
    set ans [hl_dialog .oldOrNew {Old or new?} \
		       {Edit an old print layout or create a new one?} \
		       questhead 1 Old New Cancel]
    switch $ans {
      0 {
	 set filename [tk_getOpenFile -defaultextension {.tcl} \
                                      -filetypes {{{Tcl Files} {.tcl} TEXT}} \
				      -parent .printLayout \
                                      -title {Select a script file to edit}]
	 if {[string length "$filename"] == 0} {return}
	 set printLayout(Filename) "$filename"
	 set fp [open "$filename" r]
	 set printLayout(ScriptOutdated) 0
	 set printLayout(Script) "[read $fp]"
	 ExtractPropertiesFromScript
	 close $fp
	 set printLayout(Dirty) 0
	}
      1 {
	 set filename [tk_getSaveFile -defaultextension {.tcl} \
				      -filetypes {{{Tcl Files} {.tcl} TEXT}} \
				      -parent .printLayout \
				      -title {Select a script file to create}]
	 if {[string length "$filename"] == 0} {return}
	 set printLayout(Filename) "$filename"
	 set printLayout(Dirty) 1
         set printLayout(NumRows) 1
	 set printLayout(NumCols) 1
	 set printLayout(PageWidth) 8.5
	 set printLayout(PageHeight) 11
	 set printLayout(ColumnOffsets) {0}
	 set printLayout(RowOffsets) {0}
	 set printLayout(RORadio) Regular
	 set printLayout(COBase) 0
	 set printLayout(COInterval) 0
	 set printLayout(CORadio) Regular
	 set printLayout(ROBase) 0
	 set printLayout(ROInterval) 0
	 set printLayout(ItemList) {}
	 GenerateScriptFromProperties
#         puts stderr "*** printLayout(Script) = {$printLayout(Script)}"
	}
      2 {
	  if {"[info procs XFEdit]" != ""} {
	    catch "XFDestroy .printLayout"
	  } {
	    catch "destroy .printLayout"
	  }
	  return
	}
    }
  }





  update idletasks


  SetSize $printLayout(PageWidth)i $printLayout(PageHeight)i

  set oldFocus [focus]
  set oldGrab [grab current .printLayout]
  if {$oldGrab != ""} {
    set grabStatus [grab status $oldGrab]
  }
  grab .printLayout
  focus .printLayout

  tkwait window .printLayout

  catch {focus $oldFocus}
  if {$oldGrab != ""} {  
    if {$grabStatus == "global"} {
      grab -global $oldGrab
    } else {
      grab $oldGrab
    }
  }   

}

proc SetSize {width height} {
# Procedure to set the size of the print item.
# [index] SetSize!procedure

  set srX1 -4
  set srY1 -4
  set srX2 [expr [.printLayout.frame0.frame1.frame3.frame5.canvas8 canvasx $width] + 8]
  set srY2 [expr [.printLayout.frame0.frame1.frame3.frame5.canvas8 canvasy $height] + 8]
  set cw [winfo width .printLayout.frame0.frame1.frame3.frame5.canvas8]
  set rw [.printLayout.frame0.frame1.frame3.frame5.canvas8 canvasx $width]
  if {[expr $rw + 8] > $cw} {
    set x0 0
    set x1 $rw
  } else {
    set Ccenter [expr $cw / 2.0]
    set Rcenter [expr $rw / 2.0]
    set x0 [expr $Ccenter - $Rcenter]
    set x1 [expr $x0 + $rw]
    set srX1 0
    set srX2 $cw
  }
  set ch [winfo height .printLayout.frame0.frame1.frame3.frame5.canvas8]
  set rh [.printLayout.frame0.frame1.frame3.frame5.canvas8 canvasy $height]
  if {[expr $rh + 8] > $ch} {
    set y0 0
    set y1 $rh
  } else {
    set Ccenter [expr $ch / 2.0]
    set Rcenter [expr $rh / 2.0]
    set y0 [expr $Ccenter - $Rcenter]
    set y1 [expr $y0 + $rh]
    set srY1 0
    set srY2 $ch
  }
  .printLayout.frame0.frame1.frame3.frame5.canvas8 configure -scrollregion \
     [list $srX1 $srY1 $srX2 $srY2]
  set twidth [expr 4 + ($x1 - $x0)]
  set theight [expr 4 + ($y1 - $y0)]
  set innerSR [list -2 -2 [expr ($x1 - $x0) + 2] [expr ($y1 - $y0) + 2]]
  .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet configure \
	-width $twidth -height $theight -scrollregion $innerSR
  .printLayout.frame0.frame1.frame3.frame5.canvas8 coords Sheet \
	[expr $x0 - 2] [expr $y0 - 2]
}

proc StartHandS {sheet sx sy} {
# Start hand in sheet -- the pointer position in the parent is computed and
# the upper level StartHand is invoked.
# [index] StartHandS!procedure

  set canvas [winfo parent $sheet]
  set x [expr [winfo pointerx $canvas] - [winfo rootx $canvas]]
  set y [expr [winfo pointery $canvas] - [winfo rooty $canvas]]
  StartHand $canvas $x $y
}

proc StartHand {canvas x y} {
# Start hand in display canvas.
# Collect and initialize state info and change the cursor.
# [index] StartHand!procedure

  upvar #0 $canvas data
  set data(StartX) $x
  set data(StartY) $y
  set data(OldCursor) "[$canvas cget -cursor]"
  set data(StartXView) [lindex [$canvas xview] 0]
  set data(StartYView) [lindex [$canvas yview] 0]

#  global HANDBM

#  global tcl_platform
#  if {$tcl_platform(platform) == "unix"} {
#    $canvas configure -cursor \
#	[list "@$HANDBM" black]
#  } else {
    $canvas configure -cursor hand2
#  }

}

proc MoveHandS {sheet sx sy} {
# Move hand in sheet -- the pointer position in the parent is computed and
# the upper level MoveHand is invoked. 
# [index] MoveHandS!procedure

  set canvas [winfo parent $sheet]
  set x [expr [winfo pointerx $canvas] - [winfo rootx $canvas]]
  set y [expr [winfo pointery $canvas] - [winfo rooty $canvas]]
  MoveHand $canvas $x $y
}

proc MoveHand {canvas x y} {
# Move hand in display canvas.  Adjust the view pased on mouse movement.
# [index] MoveHand!procedure

  upvar #0 $canvas data

  set dx [expr $data(StartX) - $x]
  set dy [expr $data(StartY) - $y]

  set xrmoveto [expr $dx / double([winfo width $canvas])]
  set yrmoveto [expr $dy / double([winfo height $canvas])]

  set xmoveto [expr $data(StartXView) + $xrmoveto]
  set ymoveto [expr $data(StartYView) + $yrmoveto]

  $canvas xview moveto $xmoveto
  $canvas yview moveto $ymoveto

}

proc StopHandS {sheet sx sy} {
# Stop hand in sheet -- the pointer position in the parent is computed and
# the upper level StopHand is invoked.
# [index] StopHandS!procedure

  set canvas [winfo parent $sheet]
  set x [expr [winfo pointerx $canvas] - [winfo rootx $canvas]]
  set y [expr [winfo pointery $canvas] - [winfo rooty $canvas]]
  StopHand $canvas $x $y
}

proc StopHand {canvas x y} {
# Stop hand in display canvas.  Restore state.
# [index] StopHand!procedure

  upvar #0 $canvas data

  if {![catch "set data(OldCursor)" oldCursor]} {
    $canvas configure -cursor "$oldCursor"
  }

  catch "unset data"
}

proc prl_NormalizeInsertButton {} {
# Normalize the insert button.
# [index] prl\_NormalizeInsertButton!procedure

  .printLayout.frame0.frame3.insert configure -state normal
}

proc prl_DisableInsertButton {} {
# Disable the insert button.
# [index] prl\_DisableInsertButton!procedure

  .printLayout.frame0.frame3.insert configure -state disabled
}

proc SaveScript {} {
# Save the script.
# [index] SaveScript!procedure

  global printLayout
  catch [list file rename -force "$printLayout(Filename)" "$printLayout(Filename)##"]
  if {[catch [list open "$printLayout(Filename)" w] ofp]} {
    hl_error "Could not open $printLayout(Filename) for writing: $ofp"
    catch [list file rename -force "$printLayout(Filename)##" "$printLayout(Filename)"]
    return 0
  }
  if {$printLayout(ScriptOutdated)} {
    if {[catch "GenerateScriptFromProperties" error]} {
      global errorCode errorInfo
      set ec "$errorCode"
      set ei "$errorInfo"
      close $ofp
      catch [list file rename -force "$printLayout(Filename)##" "$printLayout(Filename)"]
      error "$error" "$ei" "$ec"
    }
  }
  puts $ofp "$printLayout(Script)"
  close $ofp
  catch [list file rename -force "$printLayout(Filename)##" "$printLayout(Filename)~"]
  set printLayout(Dirty) 0
  .printLayout.bottomButtons.save config -state disabled
  return 1
}

proc AskSaveScript {} {
# If closing the dialog box on a ``dirty'' script, ask the user if we should
# save it.
# [index] AskSaveScript!procedure

  switch [hl_dialog .saveOrNot {Save it?} \
	{Current script has been modified since last save!!} \
	questhead 0 {Save it} {Don't Save it} {Cancel}] {
    0 { return [SaveScript] }
    1 {return 1}
    2 {return 0}
  }
}

global CloseBrace
# Close Brace character
# [index] CloseBrace!global variable

set CloseBrace "[format {%c} 125]"

global OpenBrace
# Open Brace character
# [index] OpenBrace!global variable

set OpenBrace "[format {%c} 123]"

proc GenerateScriptFromProperties {} {
# Generate the script from the properties.
# [index] GenerateScriptFromProperties!procedure

  global OpenBrace
  global CloseBrace
  global printLayout
  set printLayout(Script) {
# This script was generated by hl_printLayout -- do not edit!
#
}
  append printLayout(Script) "#NumRows\nglobal NumRows\nset NumRows $printLayout(NumRows)\n\n"
  append printLayout(Script) "#NumCols\nglobal NumCols\nset NumCols $printLayout(NumCols)\n\n"
  append printLayout(Script) "#PageWidth\nglobal PageWidth\nset PageWidth $printLayout(PageWidth)\n\n"
  append printLayout(Script) "#PageHeight\nglobal PageHeight\nset PageHeight $printLayout(PageHeight)\n\n"
  append printLayout(Script) "#ColumnOffsets\nglobal ColumnOffsets\n"
#  if {[llength $printLayout(ColumnOffsets)] == 1} {
#    append printLayout(Script) "set ColumnOffsets {$printLayout(ColumnOffsets)}"
#  } else {
#    append printLayout(Script) "set ColumnOffsets $printLayout(ColumnOffsets)"
#  }
  append printLayout(Script) [list set ColumnOffsets $printLayout(ColumnOffsets)]
  append printLayout(Script) "\n\n"
  append printLayout(Script) "#RowOffsets\nglobal RowOffsets\n"
#  if {[llength $printLayout(RowOffsets)] == 1} {
#    append printLayout(Script) "set RowOffsets {$printLayout(RowOffsets)}"
#  } else {
#    append printLayout(Script) "set RowOffsets $printLayout(RowOffsets)"
#  }
  append printLayout(Script) [list set RowOffsets $printLayout(RowOffsets)]
  append printLayout(Script) "\n\n"
  append printLayout(Script) {

global RowNum
set RowNum 999

global ColNum
set ColNum 999

global PageWidthPix
set PageWidthPix -1

global PageHeightPix
set PageHeightPix -1

global PrinterDy
set PrinterDy 0

global PrinterDx
set PrinterDx 0

global LeftOffsets
set LeftOffsets {}

global TopOffsets
set TopOffsets {}

global PageIsOpen
set PageIsOpen 0
  }
  append printLayout(Script) "\nproc BeginCards {} $OpenBrace"
  append printLayout(Script) {
  global RowNum
  global ColNum
  global NumCols
  global NumRows
  global PageIsOpen
  global PageWidth
  global PageHeight
  global PageWidthPix
  global PageHeightPix
  global PrinterDy
  global PrinterDx
  global LeftOffsets
  global TopOffsets
  global ColumnOffsets
  global RowOffsets
  set upi [printer getunitsperinch]
  set topleftbottomright "[printer getpagebbox]"
  if {[lindex $topleftbottomright 0] < [lindex $topleftbottomright 2]} {
    set PrinterDy 1
  } else {
    set PrinterDy -1
  }
  if {[lindex $topleftbottomright 1] < [lindex $topleftbottomright 3]} {
    set PrinterDx 1
  } else {
    set PrinterDx -1
  }
  set PageWidthPix [expr $upi * $PageWidth]
  set PageHeightPix [expr $upi * $PageHeight]
  set LeftOffsets {}
  foreach co $ColumnOffsets {
    lappend LeftOffsets [expr [lindex $topleftbottomright 1] + ($upi * $co * $PrinterDx)]
  }
  set TopOffsets {}
  foreach ro $RowOffsets {
    lappend TopOffsets [expr [lindex $topleftbottomright 0] + ($upi * $ro * $PrinterDy)]
  }
  set RowNum $NumRows
  set ColNum $NumCols
  }
  append printLayout(Script) "\n$CloseBrace\nproc EndCards {} $OpenBrace"
  append printLayout(Script) {
  global PageIsOpen
  if {$PageIsOpen} {printer closepage}
  set PageIsOpen 0
  }
  append printLayout(Script) "\n$CloseBrace\nproc DoCard {heading id record} $OpenBrace\n"
  append printLayout(Script) {
  global RowNum
  global ColNum
  global NumRows
  global NumCols
  global PageWidthPix
  global PageHeightPix
  global LeftOffsets
  global TopOffsets
  global PageIsOpen
  global PrinterDy
  global PrinterDx

  set upi [printer getunitsperinch]

  incr ColNum
  if {$ColNum >= $NumCols} {
    set ColNum 0
    incr RowNum
  }

  if {$RowNum >= $NumRows} {
    if {$PageIsOpen} {printer closepage}
    printer openpage
    set PageIsOpen 1
    set RowNum 0
    set ColNum 0
  }

  set baseX [lindex $LeftOffsets $ColNum]
  set baseY [lindex $TopOffsets $RowNum]
#ItemListBegin
  }
  foreach Item $printLayout(ItemList) {
    append printLayout(Script) "\n#Item\n"
    append printLayout(Script) "# \{[PrEscapeNLs $Item]\}\n"
    switch -exact [LAssoc :Type $Item] {
      textat {
	set font [LAssoc :Font $Item]
	set color [LAssoc :Color $Item]
	set text [LAssoc :Text $Item]
	set x [LAssoc :X $Item]
	set y [LAssoc :Y $Item]
	set pf [lindex $font 0]
	append printLayout(Script) "  printer setfont \{[lindex $pf 0]\} \[expr \$upi * [lindex $pf 1]\]\n"
	set pc [lindex $color 0]
	append printLayout(Script) "  printer setcolor [lindex $pc 0] [lindex $pc 1] [lindex $pc 2]\n"
	append printLayout(Script) "  printer drawtextat \[expr \$baseX + (\$upi * [lindex $x 0])\] \[expr \$baseY + (\$upi * \$PrinterDy * ([lindex $y 0] + [lindex $pf 1]))\] \"[lindex $text 0]\"\n"
      }
      textinbbox {
	set font [LAssoc :Font $Item]
	set color [LAssoc :Color $Item] 
	set text [LAssoc :Text $Item]
	set x1 [LAssoc :X1 $Item]
	set x2 [LAssoc :X2 $Item]
	set y1 [LAssoc :Y1 $Item]
	set y2 [LAssoc :Y2 $Item]
	set pf [lindex $font 0]
	append printLayout(Script) "  printer setfont \{[lindex $pf 0]\} \[expr \$upi * [lindex $pf 1]\]\n"
	set pc [lindex $color 0]
	append printLayout(Script) "  printer setcolor [lindex $pc 0] [lindex $pc 1] [lindex $pc 2]\n"
	append printLayout(Script) "  printer drawtextinbbox \\\n"
	append printLayout(Script) "		\[expr \$baseX + (\$upi * [lindex $x1 0])\] \\\n"
	append printLayout(Script) "		\[expr \$baseY + (\$upi * \$PrinterDy * ([lindex $y1 0] + [lindex $pf 1]))\] \\\n"
	append printLayout(Script) "		\[expr \$baseX + (\$upi * [lindex $x2 0])\] \\\n"
	append printLayout(Script) "		\[expr \$baseY + (\$upi * \$PrinterDy * ([lindex $y2 0] + [lindex $pf 1]))\] \\\n"
	append printLayout(Script) "		\"[PrEscapeNLs [lindex $text 0]]\"\n"
      }
      line {
	set color [LAssoc :Color $Item] 
	set x1 [LAssoc :X1 $Item]
	set x2 [LAssoc :X2 $Item]
	set y1 [LAssoc :Y1 $Item]
	set y2 [LAssoc :Y2 $Item]
        set lw [LAssoc :LW $Item]
	set pc [lindex $color 0]
	append printLayout(Script) "  printer setcolor [lindex $pc 0] [lindex $pc 1] [lindex $pc 2]\n"
	append printLayout(Script) "  printer drawline \\\n"
	append printLayout(Script) "		\[expr \$baseX + (\$upi * [lindex $x1 0])\] \\\n"
	append printLayout(Script) "		\[expr \$baseY + (\$upi * \$PrinterDy * ([lindex $y1 0] + [lindex $pf 1]))\] \\\n"
	append printLayout(Script) "		\[expr \$baseX + (\$upi * [lindex $x2 0])\] \\\n"
	append printLayout(Script) "		\[expr \$baseY + (\$upi * \$PrinterDy * ([lindex $y2 0] + [lindex $pf 1]))\] \\\n"
        append printLayout(Script) "            \[expr \$upi * [lindex $lw 0]\]\n"
      }
      rectangle {
	set color [LAssoc :Color $Item] 
	set x1 [LAssoc :X1 $Item]
	set x2 [LAssoc :X2 $Item]
	set y1 [LAssoc :Y1 $Item]
	set y2 [LAssoc :Y2 $Item]
        set thk [LAssoc :THK $Item]
	set pc [lindex $color 0]
	append printLayout(Script) "  printer setcolor [lindex $pc 0] [lindex $pc 1] [lindex $pc 2]\n"
	append printLayout(Script) "  printer drawrectangle \\\n"
	append printLayout(Script) "		\[expr \$baseX + (\$upi * [lindex $x1 0])\] \\\n"
	append printLayout(Script) "		\[expr \$baseY + (\$upi * \$PrinterDy * ([lindex $y1 0] + [lindex $pf 1]))\] \\\n"
	append printLayout(Script) "		\[expr \$baseX + (\$upi * [lindex $x2 0])\] \\\n"
	append printLayout(Script) "		\[expr \$baseY + (\$upi * \$PrinterDy * ([lindex $y2 0] + [lindex $pf 1]))\] \\\n"
        append printLayout(Script) "            \[expr \$upi * [lindex $thk 0]\]\n"
      }
      filledrectangle {
	set color [LAssoc :Color $Item] 
	set x1 [LAssoc :X1 $Item]
	set x2 [LAssoc :X2 $Item]
	set y1 [LAssoc :Y1 $Item]
	set y2 [LAssoc :Y2 $Item]
	set pc [lindex $color 0]
	append printLayout(Script) "  printer setcolor [lindex $pc 0] [lindex $pc 1] [lindex $pc 2]\n"
	append printLayout(Script) "  printer drawfilledrectangle \\\n"
	append printLayout(Script) "		\[expr \$baseX + (\$upi * [lindex $x1 0])\] \\\n"
	append printLayout(Script) "		\[expr \$baseY + (\$upi * \$PrinterDy * ([lindex $y1 0] + [lindex $pf 1]))\] \\\n"
	append printLayout(Script) "		\[expr \$baseX + (\$upi * [lindex $x2 0])\] \\\n"
	append printLayout(Script) "		\[expr \$baseY + (\$upi * \$PrinterDy * ([lindex $y2 0] + [lindex $pf 1]))\]\n"
      }
      oval {
	set color [LAssoc :Color $Item] 
	set x1 [LAssoc :X1 $Item]
	set x2 [LAssoc :X2 $Item]
	set y1 [LAssoc :Y1 $Item]
	set y2 [LAssoc :Y2 $Item]
        set thk [LAssoc :THK $Item]
	set pc [lindex $color 0]
	append printLayout(Script) "  printer setcolor [lindex $pc 0] [lindex $pc 1] [lindex $pc 2]\n"
	append printLayout(Script) "  printer drawoval \\\n"
	append printLayout(Script) "		\[expr \$baseX + (\$upi * [lindex $x1 0])\] \\\n"
	append printLayout(Script) "		\[expr \$baseY + (\$upi * \$PrinterDy * ([lindex $y1 0] + [lindex $pf 1]))\] \\\n"
	append printLayout(Script) "		\[expr \$baseX + (\$upi * [lindex $x2 0])\] \\\n"
	append printLayout(Script) "		\[expr \$baseY + (\$upi * \$PrinterDy * ([lindex $y2 0] + [lindex $pf 1]))\] \\\n"
        append printLayout(Script) "            \[expr \$upi * [lindex $thk 0]\]\n"
      }
      filledoval {
	set color [LAssoc :Color $Item] 
	set x1 [LAssoc :X1 $Item]
	set x2 [LAssoc :X2 $Item]
	set y1 [LAssoc :Y1 $Item]
	set y2 [LAssoc :Y2 $Item]
	set pc [lindex $color 0]
	append printLayout(Script) "  printer setcolor [lindex $pc 0] [lindex $pc 1] [lindex $pc 2]\n"
	append printLayout(Script) "  printer drawfilledoval \\\n"
	append printLayout(Script) "		\[expr \$baseX + (\$upi * [lindex $x1 0])\] \\\n"
	append printLayout(Script) "		\[expr \$baseY + (\$upi * \$PrinterDy * ([lindex $y1 0] + [lindex $pf 1]))\] \\\n"
	append printLayout(Script) "		\[expr \$baseX + (\$upi * [lindex $x2 0])\] \\\n"
	append printLayout(Script) "		\[expr \$baseY + (\$upi * \$PrinterDy * ([lindex $y2 0] + [lindex $pf 1]))\]\n"
      }
      image {
	set color [LAssoc :Color $Item] 
	set x1 [LAssoc :X1 $Item]
	set x2 [LAssoc :X2 $Item]
	set y1 [LAssoc :Y1 $Item]
	set y2 [LAssoc :Y2 $Item]
	set bm [lindex [LAssoc :Bitmap $Item] 0]
	set pc [lindex $color 0]
	append printLayout(Script) "  printer setcolor [lindex $pc 0] [lindex $pc 1] [lindex $pc 2]\n"
	append printLayout(Script) "  printer drawimage \\\n"
	append printLayout(Script) "		\[expr \$baseX + (\$upi * [lindex $x1 0])\] \\\n"
	append printLayout(Script) "		\[expr \$baseY + (\$upi * \$PrinterDy * ([lindex $y1 0] + [lindex $pf 1]))\] \\\n"
	append printLayout(Script) "		\[expr \$baseX + (\$upi * [lindex $x2 0])\] \\\n"
	append printLayout(Script) "		\[expr \$baseY + (\$upi * \$PrinterDy * ([lindex $y2 0] + [lindex $pf 1]))\] \\\n"
	append printLayout(Script) "		$bm\n"
      }
      default {}
    }
  }
  append printLayout(Script) "\n#ItemListEnd\n$CloseBrace"
  set printLayout(ScriptOutdated) 0
}

proc ExtractPropertiesFromScript {} {
# Given a properly formatted script, extract the properties.
# [index] ExtractPropertiesFromScript!procedure

  global printLayout
  if {[regexp "#NumRows\nglobal NumRows\nset NumRows (\[^\n\]+)\n" \
	      "$printLayout(Script)" while nr] > 0} {
    set printLayout(NumRows) $nr
  } else {
    hl_warning "Invalid script (can't find NumRows)"
    set printLayout(NumRows) 1
  }
  if {[regexp "#NumCols\nglobal NumCols\nset NumCols (\[^\n\]+)\n" \
	      "$printLayout(Script)" while nr] > 0} {
    set printLayout(NumCols) $nr
  } else {
    hl_warning "Invalid script (can't find NumCols)"
    set printLayout(NumCols) 1
  }
  if {[regexp "#PageWidth\nglobal PageWidth\nset PageWidth (\[^\n\]+)\n" \
	      "$printLayout(Script)" while nr] > 0} {
    set printLayout(PageWidth) $nr
  } else {
    hl_warning "Invalid script (can't find PageWidth)"
    set printLayout(PageWidth) 8.5
  }
  if {[regexp "#PageHeight\nglobal PageHeight\nset PageHeight (\[^\n\]+)\n" \
	      "$printLayout(Script)" while nr] > 0} {
    set printLayout(PageHeight) $nr
  } else {
    hl_warning "Invalid script (can't find PageHeight)"
    set printLayout(PageHeight) 11
  }
  if {[regexp "#ColumnOffsets\nglobal ColumnOffsets\nset ColumnOffsets {(\[^\}\]+)}\n" \
	      "$printLayout(Script)" while nr] > 0} {
#    puts stderr "*** nr = '$nr' [llength $nr] elements"
    set printLayout(ColumnOffsets) $nr
  } else {
    hl_warning "Invalid script (can't find ColumnOffsets)"
    set printLayout(ColumnOffsets) {0}
  }
  if {[isRegular $printLayout(ColumnOffsets)]} {
    set printLayout(CORadio) Regular
    set printLayout(COInterval) [ExtractInterval $printLayout(ColumnOffsets)]
    set printLayout(COBase) [lindex $printLayout(ColumnOffsets) 0]
  } else {
    set printLayout(CORadio) Irregular
  }
  if {[regexp "#RowOffsets\nglobal RowOffsets\nset RowOffsets {(\[^\}\]+)}\n" \
	      "$printLayout(Script)" while nr] > 0} {
#    puts stderr "*** nr = '$nr' [llength $nr] elements"
    set printLayout(RowOffsets) $nr
  } else {
    hl_warning "Invalid script (can't find RowOffsets)"
    set printLayout(RowOffsets) {0}
  }
  if {[isRegular $printLayout(RowOffsets)]} {
    set printLayout(RORadio) Regular
    set printLayout(ROInterval) [ExtractInterval $printLayout(RowOffsets)]
    set printLayout(ROBase) [lindex $printLayout(RowOffsets) 0]
  } else {
    set printLayout(RORadio) Irregular
  }
  set printLayout(ItemList) {}
  .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet delete all
  if {[regexp "#ItemListBegin\n(.+)\n#ItemListEnd\n" \
	      "$printLayout(Script)" whole items] > 0} {
    for {set pos [string first "#Item\n#" "$items"]} \
	{$pos >= 0} \
	{set pos [string first "#Item\n#" "$items"]} {
      set p1 [expr $pos + 7]
      set p2 [expr [string first "\}\n" "$items"] + 1]
      set item [lindex [string trim [string range "$items" $p1 $p2]] 0]
      set item [PrUnEscapeNLs $item]
      set items [string range "$items" $p2 end]
      puts stderr "*** item: '$item', [llength $item] elements"
      lappend printLayout(ItemList) $item
      set indexTag [LAssoc :IndexTag $item]
      switch -exact [LAssoc :Type $item] {
	textat {
	  set TkFont [lindex [LAssoc :Font $item] 1]
	  set TkColor [lindex [LAssoc :Color $item] 1]
	  set DText [lindex [LAssoc :Text $item] 1]
	  set DX [lindex [LAssoc :X $item] 1]
	  set DY [lindex [LAssoc :Y $item] 1]
	  .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet create text $DX $DY \
		-anchor nw -fill "$TkColor" -font "$TkFont" -text "$DText" \
		-tags $indexTag
	  .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet bind $indexTag <1> "PrSetSelection $indexTag"
	}
	textinbbox {
	  set TkFont [lindex [LAssoc :Font $item] 1]
	  set TkColor [lindex [LAssoc :Color $item] 1]
	  set DText [lindex [LAssoc :Text $item] 1]
	  set DX1 [lindex [LAssoc :X1 $item] 1]
	  set DY1 [lindex [LAssoc :Y1 $item] 1]
	  set DX2 [lindex [LAssoc :X2 $item] 1]
	  set DY2 [lindex [LAssoc :Y2 $item] 1]
	  .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet create text $DX1 $DY1 \
		-anchor nw -fill "$TkColor" -font "$TkFont" -text "$DText" \
		-tags $indexTag
	  .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet create rectangle \
		$DX1 $DY1 $DX2 $DY2 -fill {} -width 1 -outline black \
		-tags $indexTag
	  .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet bind $indexTag <1> "PrSetSelection $indexTag"
 	}
	line {
	  set TkColor [lindex [LAssoc :Color $item] 1]
	  set DX1 [lindex [LAssoc :X1 $item] 1]
	  set DY1 [lindex [LAssoc :Y1 $item] 1]
	  set DX2 [lindex [LAssoc :X2 $item] 1]
	  set DY2 [lindex [LAssoc :Y2 $item] 1]
	  set DLW [lindex [LAssoc :LW $item] 1]
	  .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet create line \
		$DX1 $DY1 $DX2 $DY2 -fill "$TkColor" -width $DLW \
		-tags $indexTag
	  .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet bind $indexTag <1> "PrSetSelection $indexTag"
	}
	rectangle {
	  set TkColor [lindex [LAssoc :Color $item] 1]
	  set DX1 [lindex [LAssoc :X1 $item] 1]
	  set DY1 [lindex [LAssoc :Y1 $item] 1]
	  set DX2 [lindex [LAssoc :X2 $item] 1]
	  set DY2 [lindex [LAssoc :Y2 $item] 1]
	  set DTHK [lindex [LAssoc :THK $item] 1]
	  .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet create rectangle \
		$DX1 $DY1 $DX2 $DY2 -fill {} -outline "$TkColor" -width $DTHK \
		-tags $indexTag
	  .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet bind $indexTag <1> "PrSetSelection $indexTag"
	}
	filledrectangle {
	  set TkColor [lindex [LAssoc :Color $item] 1]
	  set DX1 [lindex [LAssoc :X1 $item] 1]
	  set DY1 [lindex [LAssoc :Y1 $item] 1]
	  set DX2 [lindex [LAssoc :X2 $item] 1]
	  set DY2 [lindex [LAssoc :Y2 $item] 1]
	  .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet create rectangle \
		$DX1 $DY1 $DX2 $DY2 -fill "$TkColor" -width 0 -outline {} \
		-tags $indexTag
	  .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet bind $indexTag <1> "PrSetSelection $indexTag"
	}
	oval {
	  set TkColor [lindex [LAssoc :Color $item] 1]
	  set DX1 [lindex [LAssoc :X1 $item] 1]
	  set DY1 [lindex [LAssoc :Y1 $item] 1]
	  set DX2 [lindex [LAssoc :X2 $item] 1]
	  set DY2 [lindex [LAssoc :Y2 $item] 1]
	  set DTHK [lindex [LAssoc :THK $item] 1]
	  .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet create oval \
		$DX1 $DY1 $DX2 $DY2 -fill {} -outline "$TkColor" -width $DTHK \
		-tags $indexTag
	  .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet bind $indexTag <1> "PrSetSelection $indexTag"
	}
	filledoval {
	  set TkColor [lindex [LAssoc :Color $item] 1]
	  set DX1 [lindex [LAssoc :X1 $item] 1]
	  set DY1 [lindex [LAssoc :Y1 $item] 1]
	  set DX2 [lindex [LAssoc :X2 $item] 1]
	  set DY2 [lindex [LAssoc :Y2 $item] 1]
	  .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet create oval \
		$DX1 $DY1 $DX2 $DY2 -fill "$TkColor" -width 0 -outline {} \
		-tags $indexTag
	  .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet bind $indexTag <1> "PrSetSelection $indexTag"
	}
	image {
	  set TkColor [lindex [LAssoc :Color $item] 1]
	  set DX1 [lindex [LAssoc :X1 $item] 1]
	  set DY1 [lindex [LAssoc :Y1 $item] 1]
	  set DX2 [lindex [LAssoc :X2 $item] 1]
	  set DY2 [lindex [LAssoc :Y2 $item] 1]
	  set bm [lindex [LAssoc :Bitmap $item] 0]
	  .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet create bitmap \
		$DX1 $DY1 -foreground "$TkColor" -bitmap "$bm" -anchor nw \
		-tags $indexTag
	  .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet create rectangle \
		$DX1 $DY1 $DX2 $DY2 -fill {} -width 1 -outline black \
		-tags $indexTag
	  .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet bind $indexTag <1> "PrSetSelection $indexTag"
	}
	default {}
      }
    }
  } else {
    hl_warning "Invalid script (can't find ItemList)"
    set printLayout(ItemList) {}
  }
}

proc isRegular {offsetlist} {
# Scan down offsetlist and see if it describes regular intervals.
# [index] isRegular!procedure

  set len [llength $offsetlist]
  if {$len <= 2} {return 1}
  set iv1 [expr [lindex $offsetlist 1] - [lindex $offsetlist 0]]
  set a [lindex $offsetlist 1]
  foreach b [lrange $offsetlist 2 end] {
    set iv2 [expr $b - $a]
    if {$iv2 != $iv1} {return 0}
    set a $b
  }
  return 1
}

proc ExtractInterval {offsetlist} {
# Extract the interval from an offset list.
# [index] ExtractInterval!procedure

  set len [llength $offsetlist]
  if {$len == 1} {return 0}
  return [expr [lindex $offsetlist 1] - [lindex $offsetlist 0]]
}

  

proc PagePropertiesDialog {} {
# Put up the page properties dialog.
# [index] PagePropertiesDialog!procedure

  global printLayout
  set printLayout(XRORadio) $printLayout(RORadio)
  set printLayout(XCORadio) $printLayout(CORadio)

# .prlayoutPageproperties
# The above line makes pasting MUCH easier for me.
# It contains the pathname of the cutted widget.
# Tcl version: 7.6 (Tcl/Tk/XF)
# Tk version: 4.2
# XF version: 4.0
#

  # build widget .prlayoutPageproperties
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .prlayoutPageproperties"
  } {
    catch "destroy .prlayoutPageproperties"
  }
  toplevel .prlayoutPageproperties 

  # Window manager configurations
  wm positionfrom .prlayoutPageproperties ""
  wm sizefrom .prlayoutPageproperties ""
  wm maxsize .prlayoutPageproperties 1000 1000
  wm minsize .prlayoutPageproperties 10 10
  wm title .prlayoutPageproperties {Page Properties}


  # build widget .prlayoutPageproperties.top
  frame .prlayoutPageproperties.top \
    -borderwidth {2}

  # build widget .prlayoutPageproperties.top.label2
  label .prlayoutPageproperties.top.label2 \
    -image {SmallFace}

  # build widget .prlayoutPageproperties.top.label3
  label .prlayoutPageproperties.top.label3 \
    -background {yellow} \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -foreground {brown} \
    -text {Page Properties}

  # build widget .prlayoutPageproperties.sizes
  frame .prlayoutPageproperties.sizes \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .prlayoutPageproperties.sizes.width
  frame .prlayoutPageproperties.sizes.width

  # build widget .prlayoutPageproperties.sizes.width.label6
  label .prlayoutPageproperties.sizes.width.label6 \
    -text {Width:}

  # build widget .prlayoutPageproperties.sizes.width.value
  entry .prlayoutPageproperties.sizes.width.value

  # build widget .prlayoutPageproperties.sizes.width.label8
  label .prlayoutPageproperties.sizes.width.label8 \
    -text {inches}

  # build widget .prlayoutPageproperties.sizes.height
  frame .prlayoutPageproperties.sizes.height

  # build widget .prlayoutPageproperties.sizes.height.label9
  label .prlayoutPageproperties.sizes.height.label9 \
    -text {Height:}

  # build widget .prlayoutPageproperties.sizes.height.value
  entry .prlayoutPageproperties.sizes.height.value

  # build widget .prlayoutPageproperties.sizes.height.label11
  label .prlayoutPageproperties.sizes.height.label11 \
    -text {inches}

  # build widget .prlayoutPageproperties.offsets
  frame .prlayoutPageproperties.offsets \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .prlayoutPageproperties.offsets.numrows
  frame .prlayoutPageproperties.offsets.numrows

  # build widget .prlayoutPageproperties.offsets.numrows.label9
  label .prlayoutPageproperties.offsets.numrows.label9 \
    -text {Number of Rows per page:}

  # build widget .prlayoutPageproperties.offsets.numrows.value
  entry .prlayoutPageproperties.offsets.numrows.value

  # build widget .prlayoutPageproperties.offsets.rowoffsets
  frame .prlayoutPageproperties.offsets.rowoffsets

  # build widget .prlayoutPageproperties.offsets.rowoffsets.label9
  label .prlayoutPageproperties.offsets.rowoffsets.label9 \
    -text {Row Offsets:}

  # build widget .prlayoutPageproperties.offsets.rowoffsets.vframe
  frame .prlayoutPageproperties.offsets.rowoffsets.vframe \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .prlayoutPageproperties.offsets.rowoffsets.vframe.radiobuttons
  frame .prlayoutPageproperties.offsets.rowoffsets.vframe.radiobuttons \
    -borderwidth {2}

  # build widget .prlayoutPageproperties.offsets.rowoffsets.vframe.radiobuttons.radiobutton18
  radiobutton .prlayoutPageproperties.offsets.rowoffsets.vframe.radiobuttons.radiobutton18 \
    -text {Regular intervals} \
    -value {Regular} \
    -variable {printLayout(XRORadio)} \
    -command {pr_ToggleStates rframe iframe .prlayoutPageproperties.offsets.rowoffsets.vframe}

  # build widget .prlayoutPageproperties.offsets.rowoffsets.vframe.radiobuttons.radiobutton19
  radiobutton .prlayoutPageproperties.offsets.rowoffsets.vframe.radiobuttons.radiobutton19 \
    -text {Irregular intervals} \
    -value {Irregular} \
    -variable {printLayout(XRORadio)} \
    -command {pr_ToggleStates iframe rframe .prlayoutPageproperties.offsets.rowoffsets.vframe}

  # build widget .prlayoutPageproperties.offsets.rowoffsets.vframe.rframe
  frame .prlayoutPageproperties.offsets.rowoffsets.vframe.rframe \
    -borderwidth {2} \
    -relief {groove}

  # build widget .prlayoutPageproperties.offsets.rowoffsets.vframe.rframe.label9
  label .prlayoutPageproperties.offsets.rowoffsets.vframe.rframe.label9 \
    -text {Offset:}

  # build widget .prlayoutPageproperties.offsets.rowoffsets.vframe.rframe.value
  entry .prlayoutPageproperties.offsets.rowoffsets.vframe.rframe.value

  # build widget .prlayoutPageproperties.offsets.rowoffsets.vframe.rframe.label28
  label .prlayoutPageproperties.offsets.rowoffsets.vframe.rframe.label28 \
    -text {, Interval:}

  # build widget .prlayoutPageproperties.offsets.rowoffsets.vframe.rframe.deltav
  entry .prlayoutPageproperties.offsets.rowoffsets.vframe.rframe.deltav

  # build widget .prlayoutPageproperties.offsets.rowoffsets.vframe.iframe
  frame .prlayoutPageproperties.offsets.rowoffsets.vframe.iframe \
    -borderwidth {2} \
    -relief {groove}

  # build widget .prlayoutPageproperties.offsets.rowoffsets.vframe.iframe.label9
  label .prlayoutPageproperties.offsets.rowoffsets.vframe.iframe.label9 \
    -text {Offset List:}

  # build widget .prlayoutPageproperties.offsets.rowoffsets.vframe.iframe.value
  entry .prlayoutPageproperties.offsets.rowoffsets.vframe.iframe.value

  # build widget .prlayoutPageproperties.offsets.coloffsets
  frame .prlayoutPageproperties.offsets.coloffsets

  # build widget .prlayoutPageproperties.offsets.coloffsets.label9
  label .prlayoutPageproperties.offsets.coloffsets.label9 \
    -text {Column Offsets:}

  # build widget .prlayoutPageproperties.offsets.coloffsets.vframe
  frame .prlayoutPageproperties.offsets.coloffsets.vframe \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .prlayoutPageproperties.offsets.coloffsets.vframe.radiobuttons
  frame .prlayoutPageproperties.offsets.coloffsets.vframe.radiobuttons \
    -borderwidth {2}

  # build widget .prlayoutPageproperties.offsets.coloffsets.vframe.radiobuttons.radiobutton18
  radiobutton .prlayoutPageproperties.offsets.coloffsets.vframe.radiobuttons.radiobutton18 \
    -text {Regular intervals} \
    -value {Regular} \
    -variable {printLayout(XCORadio)} \
    -command {pr_ToggleStates rframe iframe .prlayoutPageproperties.offsets.coloffsets.vframe}

  # build widget .prlayoutPageproperties.offsets.coloffsets.vframe.radiobuttons.radiobutton19
  radiobutton .prlayoutPageproperties.offsets.coloffsets.vframe.radiobuttons.radiobutton19 \
    -text {Irregular intervals} \
    -value {Irregular} \
    -variable {printLayout(XCORadio)} \
    -command {pr_ToggleStates iframe rframe .prlayoutPageproperties.offsets.coloffsets.vframe}

  # build widget .prlayoutPageproperties.offsets.coloffsets.vframe.rframe
  frame .prlayoutPageproperties.offsets.coloffsets.vframe.rframe \
    -borderwidth {2} \
    -relief {groove}

  # build widget .prlayoutPageproperties.offsets.coloffsets.vframe.rframe.label9
  label .prlayoutPageproperties.offsets.coloffsets.vframe.rframe.label9 \
    -text {Offset:}

  # build widget .prlayoutPageproperties.offsets.coloffsets.vframe.rframe.value
  entry .prlayoutPageproperties.offsets.coloffsets.vframe.rframe.value

  # build widget .prlayoutPageproperties.offsets.coloffsets.vframe.rframe.label28
  label .prlayoutPageproperties.offsets.coloffsets.vframe.rframe.label28 \
    -text {, Interval:}

  # build widget .prlayoutPageproperties.offsets.coloffsets.vframe.rframe.deltav
  entry .prlayoutPageproperties.offsets.coloffsets.vframe.rframe.deltav

  # build widget .prlayoutPageproperties.offsets.coloffsets.vframe.iframe
  frame .prlayoutPageproperties.offsets.coloffsets.vframe.iframe \
    -borderwidth {2} \
    -relief {groove}

  # build widget .prlayoutPageproperties.offsets.coloffsets.vframe.iframe.label9
  label .prlayoutPageproperties.offsets.coloffsets.vframe.iframe.label9 \
    -text {Offset List:}

  # build widget .prlayoutPageproperties.offsets.coloffsets.vframe.iframe.value
  entry .prlayoutPageproperties.offsets.coloffsets.vframe.iframe.value

  # build widget .prlayoutPageproperties.offsets.numcols
  frame .prlayoutPageproperties.offsets.numcols

  # build widget .prlayoutPageproperties.offsets.numcols.label9
  label .prlayoutPageproperties.offsets.numcols.label9 \
    -text {Number of Columns per page:}

  # build widget .prlayoutPageproperties.offsets.numcols.value
  entry .prlayoutPageproperties.offsets.numcols.value

  # build widget .prlayoutPageproperties.buttons
  frame .prlayoutPageproperties.buttons \
    -borderwidth {2}

  # build widget .prlayoutPageproperties.buttons.button25
  button .prlayoutPageproperties.buttons.button25 \
    -padx {11} \
    -pady {4} \
    -text {OK} \
    -command {
  global printLayout
  set x "[.prlayoutPageproperties.offsets.numrows.value get]"
  if {[catch [list expr "int($x)"] v]} {
    hl_warning "Not a number (NumRows): $x, NumRows not modified"
  } else {
    set printLayout(NumRows) $v
    set printLayout(Dirty) 1
    set printLayout(ScriptOutdated) 1
  }
  set x "[.prlayoutPageproperties.offsets.numcols.value get]"
  if {[catch [list expr "int($x)"] v]} {
    hl_warning "Not a number (NumCols): $x, NumRows not modified"
    
  } else {
    set printLayout(NumCols) $v
    set printLayout(Dirty) 1
    set printLayout(ScriptOutdated) 1
  }
  set x "[.prlayoutPageproperties.sizes.width.value get]"
  if {[catch [list expr "double($x)"] v]} {
    hl_warning "Not a number (PageWidth): $x, PageWidth not modified"
  } else {
    set printLayout(PageWidth) $v
    set printLayout(Dirty) 1
    set printLayout(ScriptOutdated) 1
  }
  set x "[.prlayoutPageproperties.sizes.height.value get]"
  if {[catch [list expr "double($x)"] v]} {
    hl_warning "Not a number (PageHeight): $x, PageHeight not modified"
  } else {
    set printLayout(PageHeight) $v
    set printLayout(Dirty) 1
    set printLayout(ScriptOutdated) 1
  }
  if {"$printLayout(RORadio)" != "$printLayout(XRORadio)"} {
    set printLayout(RORadio) $printLayout(XRORadio)
    set printLayout(Dirty) 1
    set printLayout(ScriptOutdated) 1
  }
  if {"$printLayout(CORadio)" != "$printLayout(XCORadio)"} {
    set printLayout(CORadio) $printLayout(XCORadio)
    set printLayout(Dirty) 1
    set printLayout(ScriptOutdated) 1
  }
  if {"$printLayout(RORadio)" == {Regular}} {
    set base "[.prlayoutPageproperties.offsets.rowoffsets.vframe.rframe.value get]"
    set delta "[.prlayoutPageproperties.offsets.rowoffsets.vframe.rframe.deltav get]"
    if {[catch [list expr "double($base)"] v]} {
      hl_warning "Not a number (ROBase): $base, ROBase not modified"
      set base $printLayout(ROBase)
    } else {
      set printLayout(ROBase) $v
      set base $v
      set printLayout(Dirty) 1
      set printLayout(ScriptOutdated) 1
    }
    if {[catch [list expr "double($delta)"] v]} {
      hl_warning "Not a number (ROInterval): $delta, ROInterval not modified"
      set delta $printLayout(ROInterval)
    } else {
      set printLayout(ROInterval) $v
      set delta $v
      set printLayout(Dirty) 1
      set printLayout(ScriptOutdated) 1
    }
    set newOffs [MakeRegularOffsetList $printLayout(NumRows) $base $delta]
    if {[string compare "$newOffs" "$printLayout(RowOffsets)"] != 0} {
      set printLayout(RowOffsets) "$newOffs"
      set printLayout(Dirty) 1
      set printLayout(ScriptOutdated) 1
    }
  } elseif if {[string compare \
		"[.prlayoutPageproperties.offsets.rowoffsets.vframe.iframe.value get]" \
		"$printLayout(RowOffsets)"] != 0} {
    set printLayout(RowOffsets) "[.prlayoutPageproperties.offsets.rowoffsets.vframe.iframe.value get]"
    set printLayout(Dirty) 1
    set printLayout(ScriptOutdated) 1
  }
  if {"$printLayout(CORadio)" == {Regular}} {
    set base "[.prlayoutPageproperties.offsets.coloffsets.vframe.rframe.value get]"
    set delta "[.prlayoutPageproperties.offsets.coloffsets.vframe.rframe.deltav get]"
    if {[catch [list expr "double($base)"] v]} {
      hl_warning "Not a number (CROBase): $base, COBase not modified"
      set base $printLayout(COBase)
    } else {
      set printLayout(COBase) $v
      set base $v
      set printLayout(Dirty) 1
      set printLayout(ScriptOutdated) 1
    }
    if {[catch [list expr "double($delta)"] v]} {
      hl_warning "Not a number (COInterval): $delta, COInterval not modified"
      set delta $printLayout(COInterval)
    } else {
      set printLayout(COInterval) $v
      set delta $v
      set printLayout(Dirty) 1
    }
    set newOffs [MakeRegularOffsetList $printLayout(NumCols) $base $delta]
    if {[string compare "$newOffs" "$printLayout(ColumnOffsets)"] != 0} {
      set printLayout(ColumnOffsets) "$newOffs"
      set printLayout(Dirty) 1
      set printLayout(ScriptOutdated) 1
    }
  } elseif if {[string compare \
		"[.prlayoutPageproperties.offsets.coloffsets.vframe.iframe.value get]" \
		"$printLayout(ColumnOffsets)"] != 0} {
    set printLayout(ColumnOffsets) "[.prlayoutPageproperties.offsets.coloffsets.vframe.iframe.value get]"
    set printLayout(Dirty) 1
    set printLayout(ScriptOutdated) 1
  }
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .prlayoutPageproperties"
  } {
    catch "destroy .prlayoutPageproperties"
  }
    }

  # build widget .prlayoutPageproperties.buttons.button26
  button .prlayoutPageproperties.buttons.button26 \
    -command {
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .prlayoutPageproperties"
  } {
    catch "destroy .prlayoutPageproperties"
  }
    } \
    -padx {11} \
    -pady {4} \
    -text {Cancel}

  # build widget .prlayoutPageproperties.buttons.button27
  button .prlayoutPageproperties.buttons.button27 \
    -padx {11} \
    -pady {4} \
    -text {Help} \
    -command {hl_Help {Print Layout Page Properties Dialog Help}}

  # pack master .prlayoutPageproperties.top
  pack configure .prlayoutPageproperties.top.label2 \
    -fill y \
    -side left
  pack configure .prlayoutPageproperties.top.label3 \
    -expand 1 \
    -fill x \
    -side right

  # pack master .prlayoutPageproperties.sizes
  pack configure .prlayoutPageproperties.sizes.width \
    -expand 1 \
    -fill x
  pack configure .prlayoutPageproperties.sizes.height \
    -fill x

  # pack master .prlayoutPageproperties.sizes.width
  pack configure .prlayoutPageproperties.sizes.width.label6 \
    -side left
  pack configure .prlayoutPageproperties.sizes.width.value \
    -expand 1 \
    -fill x \
    -side left
  pack configure .prlayoutPageproperties.sizes.width.label8 \
    -side left

  # pack master .prlayoutPageproperties.sizes.height
  pack configure .prlayoutPageproperties.sizes.height.label9 \
    -side left
  pack configure .prlayoutPageproperties.sizes.height.value \
    -expand 1 \
    -fill x \
    -side left
  pack configure .prlayoutPageproperties.sizes.height.label11 \
    -side left

  # pack master .prlayoutPageproperties.offsets
  pack configure .prlayoutPageproperties.offsets.numrows \
    -fill x
  pack configure .prlayoutPageproperties.offsets.numcols \
    -fill x
  pack configure .prlayoutPageproperties.offsets.rowoffsets \
    -fill x
  pack configure .prlayoutPageproperties.offsets.coloffsets \
    -fill x

  # pack master .prlayoutPageproperties.offsets.numrows
  pack configure .prlayoutPageproperties.offsets.numrows.label9 \
    -side left
  pack configure .prlayoutPageproperties.offsets.numrows.value \
    -expand 1 \
    -fill x \
    -side left

  # pack master .prlayoutPageproperties.offsets.rowoffsets
  pack configure .prlayoutPageproperties.offsets.rowoffsets.label9 \
    -side left
  pack configure .prlayoutPageproperties.offsets.rowoffsets.vframe \
    -expand 1 \
    -fill both \
    -side right

  # pack master .prlayoutPageproperties.offsets.rowoffsets.vframe
  pack configure .prlayoutPageproperties.offsets.rowoffsets.vframe.radiobuttons \
    -fill x
  pack configure .prlayoutPageproperties.offsets.rowoffsets.vframe.rframe \
    -fill x
  pack configure .prlayoutPageproperties.offsets.rowoffsets.vframe.iframe \
    -fill x

  # pack master .prlayoutPageproperties.offsets.rowoffsets.vframe.radiobuttons
  pack configure .prlayoutPageproperties.offsets.rowoffsets.vframe.radiobuttons.radiobutton18 \
    -side left
  pack configure .prlayoutPageproperties.offsets.rowoffsets.vframe.radiobuttons.radiobutton19 \
    -side right

  # pack master .prlayoutPageproperties.offsets.rowoffsets.vframe.rframe
  pack configure .prlayoutPageproperties.offsets.rowoffsets.vframe.rframe.label9 \
    -side left
  pack configure .prlayoutPageproperties.offsets.rowoffsets.vframe.rframe.value \
    -expand 1 \
    -fill x \
    -side left
  pack configure .prlayoutPageproperties.offsets.rowoffsets.vframe.rframe.label28 \
    -side left
  pack configure .prlayoutPageproperties.offsets.rowoffsets.vframe.rframe.deltav \
    -expand 1 \
    -fill x \
    -side left

  # pack master .prlayoutPageproperties.offsets.rowoffsets.vframe.iframe
  pack configure .prlayoutPageproperties.offsets.rowoffsets.vframe.iframe.label9 \
    -side left
  pack configure .prlayoutPageproperties.offsets.rowoffsets.vframe.iframe.value \
    -expand 1 \
    -fill x \
    -side left

  # pack master .prlayoutPageproperties.offsets.coloffsets
  pack configure .prlayoutPageproperties.offsets.coloffsets.label9 \
    -anchor n \
    -side left
  pack configure .prlayoutPageproperties.offsets.coloffsets.vframe \
    -expand 1 \
    -fill both \
    -side right

  # pack master .prlayoutPageproperties.offsets.coloffsets.vframe
  pack configure .prlayoutPageproperties.offsets.coloffsets.vframe.radiobuttons \
    -fill x
  pack configure .prlayoutPageproperties.offsets.coloffsets.vframe.rframe \
    -fill x
  pack configure .prlayoutPageproperties.offsets.coloffsets.vframe.iframe \
    -fill x

  # pack master .prlayoutPageproperties.offsets.coloffsets.vframe.radiobuttons
  pack configure .prlayoutPageproperties.offsets.coloffsets.vframe.radiobuttons.radiobutton18 \
    -side left
  pack configure .prlayoutPageproperties.offsets.coloffsets.vframe.radiobuttons.radiobutton19 \
    -side right

  # pack master .prlayoutPageproperties.offsets.coloffsets.vframe.rframe
  pack configure .prlayoutPageproperties.offsets.coloffsets.vframe.rframe.label9 \
    -side left
  pack configure .prlayoutPageproperties.offsets.coloffsets.vframe.rframe.value \
    -expand 1 \
    -fill x \
    -side left
  pack configure .prlayoutPageproperties.offsets.coloffsets.vframe.rframe.label28 \
    -side left
  pack configure .prlayoutPageproperties.offsets.coloffsets.vframe.rframe.deltav \
    -expand 1 \
    -fill x \
    -side left

  # pack master .prlayoutPageproperties.offsets.coloffsets.vframe.iframe
  pack configure .prlayoutPageproperties.offsets.coloffsets.vframe.iframe.label9 \
    -side left
  pack configure .prlayoutPageproperties.offsets.coloffsets.vframe.iframe.value \
    -expand 1 \
    -fill x \
    -side left

  # pack master .prlayoutPageproperties.offsets.numcols
  pack configure .prlayoutPageproperties.offsets.numcols.label9 \
    -side left
  pack configure .prlayoutPageproperties.offsets.numcols.value \
    -expand 1 \
    -fill x \
    -side left

  # pack master .prlayoutPageproperties.buttons
  pack configure .prlayoutPageproperties.buttons.button25 \
    -expand 1 \
    -side left
  pack configure .prlayoutPageproperties.buttons.button26 \
    -expand 1 \
    -side left
  pack configure .prlayoutPageproperties.buttons.button27 \
    -expand 1 \
    -side right

  # pack master .prlayoutPageproperties
  pack configure .prlayoutPageproperties.top \
    -fill x
  pack configure .prlayoutPageproperties.sizes \
    -fill x
  pack configure .prlayoutPageproperties.offsets \
    -fill x
  pack configure .prlayoutPageproperties.buttons \
    -fill x

  global printLayout
  .prlayoutPageproperties.sizes.width.value insert end $printLayout(PageWidth)
  .prlayoutPageproperties.sizes.height.value insert end $printLayout(PageHeight)
  .prlayoutPageproperties.offsets.numrows.value insert end $printLayout(NumRows)
  .prlayoutPageproperties.offsets.rowoffsets.vframe.rframe.value insert end $printLayout(ROBase)
  .prlayoutPageproperties.offsets.rowoffsets.vframe.rframe.deltav insert end $printLayout(ROInterval)
  .prlayoutPageproperties.offsets.rowoffsets.vframe.iframe.value insert end "$printLayout(RowOffsets)"
  .prlayoutPageproperties.offsets.coloffsets.vframe.rframe.value insert end $printLayout(COBase)
  .prlayoutPageproperties.offsets.coloffsets.vframe.rframe.deltav insert end $printLayout(COInterval)
  .prlayoutPageproperties.offsets.coloffsets.vframe.iframe.value insert end "$printLayout(ColumnOffsets)"
  .prlayoutPageproperties.offsets.numcols.value insert end $printLayout(NumCols)

  switch $printLayout(RORadio) {
    Regular {
      foreach w [winfo children .prlayoutPageproperties.offsets.rowoffsets.vframe.iframe] {
	catch "$w configure -state disabled"
      }
    }
    Irregular {
      foreach w [winfo children .prlayoutPageproperties.offsets.rowoffsets.vframe.rframe] {
	catch "$w configure -state disabled"
      }
    }
  }

  switch $printLayout(CORadio) {
    Regular {
      foreach w [winfo children .prlayoutPageproperties.offsets.coloffsets.vframe.iframe] {
	catch "$w configure -state disabled"
      }
    }
    Irregular {
      foreach w [winfo children .prlayoutPageproperties.offsets.coloffsets.vframe.rframe] {
	catch "$w configure -state disabled"
      }
    }
  }


  set oldFocus [focus]
  set oldGrab [grab current .prlayoutPageproperties]
  if {$oldGrab != ""} {
    set grabStatus [grab status $oldGrab]
  }
  grab .prlayoutPageproperties
  focus .prlayoutPageproperties

  tkwait window .prlayoutPageproperties

  catch {focus $oldFocus}
  if {$oldGrab != ""} {  
    if {$grabStatus == "global"} {
      grab -global $oldGrab
    } else {
      grab $oldGrab
    }
  }   

# end of widget tree
  if {$printLayout(Dirty)} {
    GenerateScriptFromProperties
#    puts stderr "*** printLayout(Script) = {$printLayout(Script)}"
    .printLayout.bottomButtons.save config -state normal
    SetSize $printLayout(PageWidth)i $printLayout(PageHeight)i
  }

}

proc pr_ToggleStates {on off base} {
# Toggle the normal / disabled state of a pair of set of buttons.
# [index] pr\_ToggleStates!procedure

  foreach w [winfo children $base.$on] {
    catch "$w configure -state normal"
  }
  foreach w [winfo children $base.$off] {
    catch "$w configure -state disabled"
  }
}

proc MakeRegularOffsetList {elecount base delta} {
# Generate an offset list from a base and a delta.
# [index] MakeRegularOffsetList!procedure

  set result {}
  for {set pos $base;set i 0} {$i < $elecount} {set pos [expr $pos + $delta];incr i} {
    lappend result $pos
  }
  return "$result"
}

proc PrInsertItem {} {
# Insert an item.
# [index] PrInsertItem!procedure

  set cs [.printLayout.frame1.frame.listbox1 curselection]
  if {[llength $cs] < 1} {
    .printLayout.frame0.frame3.insert configure -state disabled
    return
  }
  set itemName "[.printLayout.frame1.frame.listbox1 get [lindex $cs 0]]"
  switch -exact "$itemName" {
    {drawtextat X Y String} {
      TextAtDialog
    }
    {drawtextinbbox X1 Y1 X2 Y2 String} {
      TextInBBoxDialog
    }
    {drawline X1 Y1 X2 Y2 LineWidth} {
      LineDialog
    }
    {drawrectangle X1 Y1 X2 Y2 Thickness} {
      RectangleDialog
    }
    {drawfilledrectangle X1 Y1 X2 Y2} {
      FilledRectangleDialog
    }
    {drawoval X1 Y1 X2 Y2 Thickness} {
      OvalDialog
    }
    {drawfilledoval X1 Y1 X2 Y2} {
      FilledOvalDialog
    }
    {drawimage X1 Y1 X2 Y2 Bitmap} {
      ImageDialog
    }
  }
}


proc TextAtDialog {{oldItem {}}} {
# Text At insertion / edit dialog.
# [index] TextAtDialog!procedure

  global textAtDialog
  set textAtDialog(oldItem) "$oldItem"
  set textAtDialog(button) -1

# .textAtDialog
# The above line makes pasting MUCH easier for me.
# It contains the pathname of the cutted widget.
# Tcl version: 7.6 (Tcl/Tk/XF)
# Tk version: 4.2
# XF version: 4.0
#

  # build widget .textAtDialog
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .textAtDialog"
  } {
    catch "destroy .textAtDialog"
  }
  toplevel .textAtDialog 

  # Window manager configurations
  wm positionfrom .textAtDialog ""
  wm sizefrom .textAtDialog ""
  wm maxsize .textAtDialog 1000 1000
  wm minsize .textAtDialog 10 10
  wm protocol .textAtDialog WM_DELETE_WINDOW {}
  wm title .textAtDialog {Insert Text At}
  wm transient .textAtDialog .printLayout


  # build widget .textAtDialog.top
  frame .textAtDialog.top \
    -borderwidth {2}

  # build widget .textAtDialog.top.label2
  label .textAtDialog.top.label2 \
    -image {SmallFace}

  # build widget .textAtDialog.top.label3
  label .textAtDialog.top.label3 \
    -background {yellow} \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -foreground {brown} \
    -text {Insert Text At}

  # build widget .textAtDialog.parameters
  frame .textAtDialog.parameters \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .textAtDialog.parameters.font
  frame .textAtDialog.parameters.font \
    -borderwidth {2}

  # build widget .textAtDialog.parameters.font.label8
  label .textAtDialog.parameters.font.label8 \
    -text {Font:}

  # build widget .textAtDialog.parameters.font.name
  frame .textAtDialog.parameters.font.name \
    -borderwidth {2} \
    -relief {raised}

  # build widget .textAtDialog.parameters.font.name.label1
  label .textAtDialog.parameters.font.name.label1 \
    -borderwidth {0} \
    -text {Name:}

  # build widget .textAtDialog.parameters.font.name.value
  tk_optionMenu .textAtDialog.parameters.font.name.value FindFont(name) \
        courier helvetica {new century schoolbook} times utopia

  # build widget .textAtDialog.parameters.font.weight
  frame .textAtDialog.parameters.font.weight \
    -borderwidth {2} \
    -relief {raised}

  # build widget .textAtDialog.parameters.font.weight.label1
  label .textAtDialog.parameters.font.weight.label1 \
    -borderwidth {0} \
    -text {Weight:}

  # build widget .textAtDialog.parameters.font.weight.value
  tk_optionMenu .textAtDialog.parameters.font.weight.value FindFont(weight) {bold} {normal}

  # build widget .textAtDialog.parameters.font.slant
  frame .textAtDialog.parameters.font.slant \
    -borderwidth {2} \
    -relief {raised}

  # build widget .textAtDialog.parameters.font.slant.label1
  label .textAtDialog.parameters.font.slant.label1 \
    -borderwidth {0} \
    -text {Slant:}

  # build widget .textAtDialog.parameters.font.slant.value
  tk_optionMenu .textAtDialog.parameters.font.slant.value FindFont(slant) {roman} {italic}

  # build widget .textAtDialog.parameters.font.label11
  label .textAtDialog.parameters.font.label11 \
    -text {Size:}

  # build widget .textAtDialog.parameters.font.size
  entry .textAtDialog.parameters.font.size \
    -width {5}

  # build widget .textAtDialog.parameters.position
  frame .textAtDialog.parameters.position \
    -borderwidth {2}

  # build widget .textAtDialog.parameters.position.label18
  label .textAtDialog.parameters.position.label18 \
    -text {X:}

  # build widget .textAtDialog.parameters.position.x
  entry .textAtDialog.parameters.position.x

  # build widget .textAtDialog.parameters.position.label20
  label .textAtDialog.parameters.position.label20 \
    -text {Y:}

  # build widget .textAtDialog.parameters.position.y
  entry .textAtDialog.parameters.position.y

  # build widget .textAtDialog.parameters.text
  frame .textAtDialog.parameters.text \
    -borderwidth {2}

  # build widget .textAtDialog.parameters.text.label22
  label .textAtDialog.parameters.text.label22 \
    -text {Text:}

  # build widget .textAtDialog.parameters.text.text
  entry .textAtDialog.parameters.text.text

  # build widget .textAtDialog.parameters.color
  frame .textAtDialog.parameters.color \
    -borderwidth {2}

  # build widget .textAtDialog.parameters.color.label25
  label .textAtDialog.parameters.color.label25 \
    -text {Color:}

  # build widget .textAtDialog.parameters.color.value
  entry .textAtDialog.parameters.color.value

  # build widget .textAtDialog.parameters.color.button27
  button .textAtDialog.parameters.color.button27 \
    -command {set newColor "[tk_chooseColor -title {Select A Color} -initialcolor [.textAtDialog.parameters.color.value get]]"
if {[string length "$newColor"] > 0} {
  .textAtDialog.parameters.color.value delete 0 end
  .textAtDialog.parameters.color.value insert end "$newColor"
}} \
    -padx {9} \
    -pady {3} \
    -text {Browse}

  # build widget .textAtDialog.frame2
  frame .textAtDialog.frame2 \
    -borderwidth {2}

  # build widget .textAtDialog.frame2.button15
  button .textAtDialog.frame2.button15 \
    -padx {9} \
    -pady {3} \
    -text {OK} \
    -command {
	global textAtDialog
	global FindFont
	if {[catch [list expr "double([.textAtDialog.parameters.font.size get])"] v]} {
	  hl_warning "Not a number (Font Size): [.textAtDialog.parameters.font.size get], try again"
	  return
	} elseif {$v <= 0} {
	  hl_warning "Zero or negative Font Size: $v, try again"
	  return
	}
	if {![CheckXtypeAndRange {X} "[.textAtDialog.parameters.position.x get]"} {return}
	if {![CheckYtypeAndRange {Y} "[.textAtDialog.parameters.position.y get]"} {return}
	set color "[.textAtDialog.parameters.color.value get]"
	if {[catch [list winfo rgb . $color]]} {
	  hl_warning "Bad color spec: $color, try again"
	  return
	}
	set textAtDialog(button) 1
    }

  # build widget .textAtDialog.frame2.button16
  button .textAtDialog.frame2.button16 \
    -padx {9} \
    -pady {3} \
    -text {Cancel} \
    -command {
	global textAtDialog
	set textAtDialog(button) 0
    }

  # build widget .textAtDialog.frame2.button17
  button .textAtDialog.frame2.button17 \
    -padx {9} \
    -pady {3} \
    -text {Help} \
    -command {hl_Help {Text At Dialog Help}}

  # pack master .textAtDialog.top
  pack configure .textAtDialog.top.label2 \
    -fill y \
    -side left
  pack configure .textAtDialog.top.label3 \
    -expand 1 \
    -fill x \
    -side right

  # pack master .textAtDialog.parameters
  pack configure .textAtDialog.parameters.font \
    -expand 1 \
    -fill x
  pack configure .textAtDialog.parameters.color \
    -expand 1 \
    -fill x
  pack configure .textAtDialog.parameters.position \
    -expand 1 \
    -fill x
  pack configure .textAtDialog.parameters.text \
    -expand 1 \
    -fill x

  # pack master .textAtDialog.parameters.font
  pack configure .textAtDialog.parameters.font.label8 \
    -side left
  pack configure .textAtDialog.parameters.font.name \
    -fill x \
    -side left
  pack configure .textAtDialog.parameters.font.weight \
    -fill x \
    -side left
  pack configure .textAtDialog.parameters.font.slant \
    -fill x \
    -side left
  pack configure .textAtDialog.parameters.font.label11 \
    -side left
  pack configure .textAtDialog.parameters.font.size \
    -expand 1 \
    -fill x \
    -side left

  # pack master .textAtDialog.parameters.font.name
  pack configure .textAtDialog.parameters.font.name.label1 \
    -fill both \
    -side left
  pack configure .textAtDialog.parameters.font.name.value \
    -expand 1 \
    -fill both \
    -side left

  # pack master .textAtDialog.parameters.font.weight
  pack configure .textAtDialog.parameters.font.weight.label1 \
    -fill both \
    -side left
  pack configure .textAtDialog.parameters.font.weight.value \
    -expand 1 \
    -fill both \
    -side left

  # pack master .textAtDialog.parameters.font.slant
  pack configure .textAtDialog.parameters.font.slant.label1 \
    -fill both \
    -side left
  pack configure .textAtDialog.parameters.font.slant.value \
    -expand 1 \
    -fill both \
    -side left

  # pack master .textAtDialog.parameters.position
  pack configure .textAtDialog.parameters.position.label18 \
    -side left
  pack configure .textAtDialog.parameters.position.x \
    -expand 1 \
    -fill x \
    -side left
  pack configure .textAtDialog.parameters.position.label20 \
    -side left
  pack configure .textAtDialog.parameters.position.y \
    -expand 1 \
    -fill x \
    -side left

  # pack master .textAtDialog.parameters.text
  pack configure .textAtDialog.parameters.text.label22 \
    -side left
  pack configure .textAtDialog.parameters.text.text \
    -expand 1 \
    -fill x \
    -side left

  # pack master .textAtDialog.parameters.color
  pack configure .textAtDialog.parameters.color.label25 \
    -side left
  pack configure .textAtDialog.parameters.color.value \
    -expand 1 \
    -fill x \
    -side left
  pack configure .textAtDialog.parameters.color.button27 \
    -side right

  # pack master .textAtDialog.frame2
  pack configure .textAtDialog.frame2.button15 \
    -expand 1 \
    -side left
  pack configure .textAtDialog.frame2.button16 \
    -expand 1 \
    -side left
  pack configure .textAtDialog.frame2.button17 \
    -expand 1 \
    -side right

  # pack master .textAtDialog
  pack configure .textAtDialog.top \
    -fill x
  pack configure .textAtDialog.parameters \
    -expand 1 \
    -fill both
  pack configure .textAtDialog.frame2 \
    -expand 1 \
    -fill x

  global printLayout
  global FindFont

  if {[llength "$oldItem"] == 0} {
    set FindFont(name) {courier}
    set FindFont(weight) {normal}
    set FindFont(slant) {roman}
    .textAtDialog.parameters.font.size insert end {.167}
    .textAtDialog.parameters.position.x insert end {0}
    .textAtDialog.parameters.position.y insert end {0}
    .textAtDialog.parameters.text.text insert end {}
    .textAtDialog.parameters.color.value insert end {black}
  } else {
    set dfont [lindex [LAssoc :Font $oldItem] 2]
    set FindFont(name) "[lindex $dfont 0]"
    set FindFont(weight) "[lindex $dfont 1]"
    set FindFont(slant) "[lindex $dfont 2]"
    .textAtDialog.parameters.font.size insert end "[lindex $dfont 3]"
    .textAtDialog.parameters.position.x insert end "[lindex [LAssoc :X $oldItem] 0]"
    .textAtDialog.parameters.position.y insert end "[lindex [LAssoc :Y $oldItem] 0]"
    .textAtDialog.parameters.text.text insert end "[lindex [LAssoc :Text $oldItem] 1]"
    .textAtDialog.parameters.color.value insert end "[lindex [LAssoc :Color $oldItem] 1]"
  }



# end of widget tree

  set oldFocus [focus]
  set oldGrab [grab current .textAtDialog]
  if {$oldGrab != ""} {
    set grabStatus [grab status $oldGrab]
  }
  grab .textAtDialog
  focus .textAtDialog
  tkwait variable textAtDialog(button)

  catch {focus $oldFocus}
  if {$oldGrab != ""} {
    if {$grabStatus == "global"} {
      grab -global $oldGrab
    } else {
      grab $oldGrab
    }
  }

  if {$textAtDialog(button) == 1} {
    global printLayout
    global FindFont
    set TkFont [MakeTkFont $FindFont(name) $FindFont(weight) $FindFont(slant) "[.textAtDialog.parameters.font.size get]"]
    set PrinterFont [MakePrinterFont  $FindFont(name) $FindFont(weight) $FindFont(slant) "[.textAtDialog.parameters.font.size get]"]
    set TkColor [MakeTkColor "[.textAtDialog.parameters.color.value get]"]
    set PrinterColor [MakePrinterColor "[.textAtDialog.parameters.color.value get]"]
    set DText "[.textAtDialog.parameters.text.text get]"
    set PText [ParseText "$DText"]
    set DX [.textAtDialog.parameters.position.x get]i
    set X [.textAtDialog.parameters.position.x get]
    set DY [.textAtDialog.parameters.position.y get]i
    set Y [.textAtDialog.parameters.position.y get]
    set theItem [list :Type textat \
		:Font [list $PrinterFont $TkFont \
			[list "$FindFont(name)" "$FindFont(weight)" "$FindFont(slant)" "[.textAtDialog.parameters.font.size get]"]] \
		:Color [list $PrinterColor $TkColor]\
		:Text [list $PText $DText] \
		:X [list $X $DX] :Y [list $Y $DY]]
    if {[llength "$oldItem"] != 0} {
      set indexTag [LAssoc :IndexTag $oldItem]
      set index [FindItemIndex $indexTag]
      set printLayout(ItemList) [lreplace "$printLayout(ItemList)" $index  $index [concat :IndexTag $indexTag "$theItem"]]
      catch ".printLayout.frame0.frame1.frame3.frame5.canvas8.sheet delete $indexTag"
    } else {
      set indexTag [GetNextUnusedIndexTag $printLayout(ItemList)]
      lappend printLayout(ItemList) [concat :IndexTag $indexTag "$theItem"]
    }
    set printLayout(Dirty) 1
    set printLayout(ScriptOutdated) 1
    .printLayout.bottomButtons.save config -state normal
    .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet create text $DX $DY \
		-anchor nw -fill "$TkColor" -font "$TkFont" -text "$DText" \
		-tags $indexTag
    PrSetSelection $indexTag
    .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet bind $indexTag <1> "PrSetSelection $indexTag"
  }
	
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .textAtDialog"
  } {
    catch "destroy .textAtDialog"
  }
}

proc TextInBBoxDialog {{oldItem {}}} {
# Text In BBox insertion / edit dialog.
# [index] TextInBBoxDialog!procedure

  global printLayout
  global textInBBoxDialog
  set textInBBoxDialog(oldItem) "$oldItem"
  set textInBBoxDialog(button) -1

# .textInBBoxDialog
# The above line makes pasting MUCH easier for me.
# It contains the pathname of the cutted widget.
# Tcl version: 7.6 (Tcl/Tk/XF)
# Tk version: 4.2
# XF version: 4.0
#

  # build widget .textInBBoxDialog
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .textInBBoxDialog"
  } {
    catch "destroy .textInBBoxDialog"
  }
  toplevel .textInBBoxDialog 

  # Window manager configurations
  wm positionfrom .textInBBoxDialog ""
  wm sizefrom .textInBBoxDialog ""
  wm maxsize .textInBBoxDialog 1000 1000
  wm minsize .textInBBoxDialog 10 10
  wm protocol .textInBBoxDialog WM_DELETE_WINDOW {}
  wm title .textInBBoxDialog {Insert Text In Bounding Box}
  wm transient .textInBBoxDialog .printLayout


  # build widget .textInBBoxDialog.top
  frame .textInBBoxDialog.top \
    -borderwidth {2}

  # build widget .textInBBoxDialog.top.label2
  label .textInBBoxDialog.top.label2 \
    -image {SmallFace}

  # build widget .textInBBoxDialog.top.label3
  label .textInBBoxDialog.top.label3 \
    -background {yellow} \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -foreground {brown} \
    -text {Insert Text In Bounding Box}

  # build widget .textInBBoxDialog.parameters
  frame .textInBBoxDialog.parameters \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .textInBBoxDialog.parameters.font
  frame .textInBBoxDialog.parameters.font \
    -borderwidth {2}

  # build widget .textInBBoxDialog.parameters.font.label8
  label .textInBBoxDialog.parameters.font.label8 \
    -text {Font:}

  # build widget .textInBBoxDialog.parameters.font.name
  frame .textInBBoxDialog.parameters.font.name \
    -borderwidth {2} \
    -relief {raised}

  # build widget .textInBBoxDialog.parameters.font.name.label1
  label .textInBBoxDialog.parameters.font.name.label1 \
    -borderwidth {0} \
    -text {Name:}

  # build widget .textInBBoxDialog.parameters.font.name.value
  tk_optionMenu .textInBBoxDialog.parameters.font.name.value FindFont(name) \
        courier helvetica {new century schoolbook} times utopia

  # build widget .textInBBoxDialog.parameters.font.weight
  frame .textInBBoxDialog.parameters.font.weight \
    -borderwidth {2} \
    -relief {raised}

  # build widget .textInBBoxDialog.parameters.font.weight.label1
  label .textInBBoxDialog.parameters.font.weight.label1 \
    -borderwidth {0} \
    -text {Weight:}

  # build widget .textInBBoxDialog.parameters.font.weight.value
  tk_optionMenu .textInBBoxDialog.parameters.font.weight.value FindFont(weight) {bold} {normal}

  # build widget .textInBBoxDialog.parameters.font.slant
  frame .textInBBoxDialog.parameters.font.slant \
    -borderwidth {2} \
    -relief {raised}

  # build widget .textInBBoxDialog.parameters.font.slant.label1
  label .textInBBoxDialog.parameters.font.slant.label1 \
    -borderwidth {0} \
    -text {Slant:}

  # build widget .textInBBoxDialog.parameters.font.slant.value
  tk_optionMenu .textInBBoxDialog.parameters.font.slant.value FindFont(slant) {roman} {italic}

  # build widget .textInBBoxDialog.parameters.font.label11
  label .textInBBoxDialog.parameters.font.label11 \
    -text {Size:}

  # build widget .textInBBoxDialog.parameters.font.size
  entry .textInBBoxDialog.parameters.font.size \
    -width {5}

  # build widget .textInBBoxDialog.parameters.position
  frame .textInBBoxDialog.parameters.position \
    -borderwidth {2}

  # build widget .textInBBoxDialog.parameters.position.label18
  label .textInBBoxDialog.parameters.position.label18 \
    -text {X1:}

  # build widget .textInBBoxDialog.parameters.position.x1
  entry .textInBBoxDialog.parameters.position.x1 \
    -width {5}

  # build widget .textInBBoxDialog.parameters.position.label20
  label .textInBBoxDialog.parameters.position.label20 \
    -text {Y1:}

  # build widget .textInBBoxDialog.parameters.position.y1
  entry .textInBBoxDialog.parameters.position.y1 \
    -width {5}

  # build widget .textInBBoxDialog.parameters.position.label19
  label .textInBBoxDialog.parameters.position.label19 \
    -text {X2:}

  # build widget .textInBBoxDialog.parameters.position.x2
  entry .textInBBoxDialog.parameters.position.x2 \
    -width {5}

  # build widget .textInBBoxDialog.parameters.position.label21
  label .textInBBoxDialog.parameters.position.label21 \
    -text {Y2:}

  # build widget .textInBBoxDialog.parameters.position.y2
  entry .textInBBoxDialog.parameters.position.y2 \
    -width {5}

  # build widget .textInBBoxDialog.parameters.text
  frame .textInBBoxDialog.parameters.text \
    -borderwidth {2}

  # build widget .textInBBoxDialog.parameters.text.label22
  label .textInBBoxDialog.parameters.text.label22 \
    -text {Text:}

  # build widget .textInBBoxDialog.parameters.text.tf1
  frame .textInBBoxDialog.parameters.text.tf1

  # build widget .textInBBoxDialog.parameters.text.tf1.text
  text .textInBBoxDialog.parameters.text.tf1.text \
    -wrap {word} \
    -width 40 \
    -height 10 \
    -xscrollcommand {.textInBBoxDialog.parameters.text.tf2.scrollbar5 set} \
    -yscrollcommand {.textInBBoxDialog.parameters.text.tf1.scrollbar4 set}

  # build widget .textInBBoxDialog.parameters.text.tf1.scrollbar4
  scrollbar .textInBBoxDialog.parameters.text.tf1.scrollbar4 \
    -command {.textInBBoxDialog.parameters.text.tf1.text yview} \
    -width {13}

  # build widget .textInBBoxDialog.parameters.text.tf2
  frame .textInBBoxDialog.parameters.text.tf2

  # build widget .textInBBoxDialog.parameters.text.tf2.scrollbar5
  scrollbar .textInBBoxDialog.parameters.text.tf2.scrollbar5 \
    -command {.textInBBoxDialog.parameters.text.tf1.text xview} \
    -orient {horizontal} \
    -width {13}

  # build widget .textInBBoxDialog.parameters.text.tf2.frame6
  frame .textInBBoxDialog.parameters.text.tf2.frame6 \
    -borderwidth {2} \
    -height {13} \
    -width {16}


  # build widget .textInBBoxDialog.parameters.color
  frame .textInBBoxDialog.parameters.color \
    -borderwidth {2}

  # build widget .textInBBoxDialog.parameters.color.label25
  label .textInBBoxDialog.parameters.color.label25 \
    -text {Color:}

  # build widget .textInBBoxDialog.parameters.color.value
  entry .textInBBoxDialog.parameters.color.value

  # build widget .textInBBoxDialog.parameters.color.button27
  button .textInBBoxDialog.parameters.color.button27 \
    -command {set newColor "[tk_chooseColor -title {Select A Color} -initialcolor [.textInBBoxDialog.parameters.color.value get]]"
if {[string length "$newColor"] > 0} {
  .textInBBoxDialog.parameters.color.value delete 0 end
  .textInBBoxDialog.parameters.color.value insert end "$newColor"
}} \
    -padx {9} \
    -pady {3} \
    -text {Browse}

  # build widget .textInBBoxDialog.frame2
  frame .textInBBoxDialog.frame2 \
    -borderwidth {2}

  # build widget .textInBBoxDialog.frame2.button15
  button .textInBBoxDialog.frame2.button15 \
    -padx {9} \
    -pady {3} \
    -text {OK} \
    -command {
	global textInBBoxDialog
	global FindFont
	if {[catch [list expr "double([.textInBBoxDialog.parameters.font.size get])"] v]} {
	  hl_warning "Not a number (Font Size): [.textInBBoxDialog.parameters.font.size get], try again"
	  return
	} elseif {$v <= 0} {
	  hl_warning "Zero or negative Font Size: $v, try again"
	  return
	}
	if {![CheckXtypeAndRange {X1} "[.textInBBoxDialog.parameters.position.x1 get]"} {return}
	if {![CheckYtypeAndRange {Y1} "[.textInBBoxDialog.parameters.position.y1 get]"} {return}
	if {![CheckXtypeAndRange {X2} "[.textInBBoxDialog.parameters.position.x2 get]"} {return}
	if {![CheckYtypeAndRange {Y2} "[.textInBBoxDialog.parameters.position.y2 get]"} {return}
	set color "[.textInBBoxDialog.parameters.color.value get]"
	if {[catch [list winfo rgb . $color]]} {
	  hl_warning "Bad color spec: $color, try again"
	  return
	}
	set textInBBoxDialog(button) 1
    }

  # build widget .textInBBoxDialog.frame2.button16
  button .textInBBoxDialog.frame2.button16 \
    -padx {9} \
    -pady {3} \
    -text {Cancel} \
    -command {
	global textInBBoxDialog
	set textInBBoxDialog(button) 0
    }

  # build widget .textInBBoxDialog.frame2.button17
  button .textInBBoxDialog.frame2.button17 \
    -padx {9} \
    -pady {3} \
    -text {Help} \
    -command {hl_Help {Text In BBox Dialog Help}}

  # pack master .textInBBoxDialog.top
  pack configure .textInBBoxDialog.top.label2 \
    -fill y \
    -side left
  pack configure .textInBBoxDialog.top.label3 \
    -expand 1 \
    -fill x \
    -side right

  # pack master .textInBBoxDialog.parameters
  pack configure .textInBBoxDialog.parameters.font \
    -expand 1 \
    -fill x
  pack configure .textInBBoxDialog.parameters.color \
    -expand 1 \
    -fill x
  pack configure .textInBBoxDialog.parameters.position \
    -expand 1 \
    -fill x
  pack configure .textInBBoxDialog.parameters.text \
    -expand 1 \
    -fill x

  # pack master .textInBBoxDialog.parameters.font
  pack configure .textInBBoxDialog.parameters.font.label8 \
    -side left
  pack configure .textInBBoxDialog.parameters.font.name \
    -fill x \
    -side left
  pack configure .textInBBoxDialog.parameters.font.weight \
    -fill x \
    -side left
  pack configure .textInBBoxDialog.parameters.font.slant \
    -fill x \
    -side left
  pack configure .textInBBoxDialog.parameters.font.label11 \
    -side left
  pack configure .textInBBoxDialog.parameters.font.size \
    -expand 1 \
    -fill x \
    -side left

  # pack master .textInBBoxDialog.parameters.font.name
  pack configure .textInBBoxDialog.parameters.font.name.label1 \
    -fill both \
    -side left
  pack configure .textInBBoxDialog.parameters.font.name.value \
    -expand 1 \
    -fill both \
    -side left

  # pack master .textInBBoxDialog.parameters.font.weight
  pack configure .textInBBoxDialog.parameters.font.weight.label1 \
    -fill both \
    -side left
  pack configure .textInBBoxDialog.parameters.font.weight.value \
    -expand 1 \
    -fill both \
    -side left

  # pack master .textInBBoxDialog.parameters.font.slant
  pack configure .textInBBoxDialog.parameters.font.slant.label1 \
    -fill both \
    -side left
  pack configure .textInBBoxDialog.parameters.font.slant.value \
    -expand 1 \
    -fill both \
    -side left

  # pack master .textInBBoxDialog.parameters.position
  pack configure .textInBBoxDialog.parameters.position.label18 \
    -side left
  pack configure .textInBBoxDialog.parameters.position.x1 \
    -expand 1 \
    -fill x \
    -side left
  pack configure .textInBBoxDialog.parameters.position.label20 \
    -side left
  pack configure .textInBBoxDialog.parameters.position.y1 \
    -expand 1 \
    -fill x \
    -side left
  pack configure .textInBBoxDialog.parameters.position.label19 \
    -side left
  pack configure .textInBBoxDialog.parameters.position.x2 \
    -expand 1 \
    -fill x \
    -side left
  pack configure .textInBBoxDialog.parameters.position.label21 \
    -side left
  pack configure .textInBBoxDialog.parameters.position.y2 \
    -expand 1 \
    -fill x \
    -side left

  # pack master .textInBBoxDialog.parameters.text
  pack configure .textInBBoxDialog.parameters.text.label22 \
    -side top
  pack configure .textInBBoxDialog.parameters.text.tf1 \
    -expand 1 \
    -fill both
  pack configure .textInBBoxDialog.parameters.text.tf2 \
    -expand 1 \
    -fill x

  # pack master .textInBBoxDialog.parameters.text.tf1
  pack configure .textInBBoxDialog.parameters.text.tf1.text \
    -expand 1 \
    -fill both \
    -side left
  pack configure .textInBBoxDialog.parameters.text.tf1.scrollbar4 \
    -fill y \
    -side right

  # pack master .textInBBoxDialog.parameters.text.tf2
  pack configure .textInBBoxDialog.parameters.text.tf2.scrollbar5 \
    -expand 1 \
    -fill x \
    -side left
  pack configure .textInBBoxDialog.parameters.text.tf2.frame6 \
    -side right

  # pack master .textInBBoxDialog.parameters.color
  pack configure .textInBBoxDialog.parameters.color.label25 \
    -side left
  pack configure .textInBBoxDialog.parameters.color.value \
    -expand 1 \
    -fill x \
    -side left
  pack configure .textInBBoxDialog.parameters.color.button27 \
    -side right

  # pack master .textInBBoxDialog.frame2
  pack configure .textInBBoxDialog.frame2.button15 \
    -expand 1 \
    -side left
  pack configure .textInBBoxDialog.frame2.button16 \
    -expand 1 \
    -side left
  pack configure .textInBBoxDialog.frame2.button17 \
    -expand 1 \
    -side right

  # pack master .textInBBoxDialog
  pack configure .textInBBoxDialog.top \
    -fill x
  pack configure .textInBBoxDialog.parameters \
    -expand 1 \
    -fill both
  pack configure .textInBBoxDialog.frame2 \
    -expand 1 \
    -fill x

  global printLayout
  global FindFont

  if {[llength "$oldItem"] == 0} {
    set FindFont(name) {courier}
    set FindFont(weight) {normal}
    set FindFont(slant) {roman}
    .textInBBoxDialog.parameters.font.size insert end {.167}
    .textInBBoxDialog.parameters.position.x1 insert end {0}
    .textInBBoxDialog.parameters.position.y1 insert end {0}
    .textInBBoxDialog.parameters.position.x2 insert end {0}
    .textInBBoxDialog.parameters.position.y2 insert end {0}
    .textInBBoxDialog.parameters.text.tf1.text insert end {}
    .textInBBoxDialog.parameters.color.value insert end {black}
  } else {
    set dfont [lindex [LAssoc :Font $oldItem] 2]
    set FindFont(name) "[lindex $dfont 0]"
    set FindFont(weight) "[lindex $dfont 1]"
    set FindFont(slant) "[lindex $dfont 2]"
    .textInBBoxDialog.parameters.font.size insert end "[lindex $dfont 3]"
    .textInBBoxDialog.parameters.position.x1 insert end "[lindex [LAssoc :X1 $oldItem] 0]"
    .textInBBoxDialog.parameters.position.y1 insert end "[lindex [LAssoc :Y1 $oldItem] 0]"
    .textInBBoxDialog.parameters.position.x2 insert end "[lindex [LAssoc :X2 $oldItem] 0]"
    .textInBBoxDialog.parameters.position.y2 insert end "[lindex [LAssoc :Y2 $oldItem] 0]"
    .textInBBoxDialog.parameters.text.tf1.text insert end "[lindex [LAssoc :Text $oldItem] 1]"
    .textInBBoxDialog.parameters.color.value insert end "[lindex [LAssoc :Color $oldItem] 1]"
  }



# end of widget tree

  set oldFocus [focus]
  set oldGrab [grab current .textInBBoxDialog]
  if {$oldGrab != ""} {
    set grabStatus [grab status $oldGrab]
  }
  grab .textInBBoxDialog
  focus .textInBBoxDialog
  tkwait variable textInBBoxDialog(button)

  catch {focus $oldFocus}
  if {$oldGrab != ""} {
    if {$grabStatus == "global"} {
      grab -global $oldGrab
    } else {
      grab $oldGrab
    }
  }

  if {$textInBBoxDialog(button) == 1} {
    global printLayout
    global FindFont
    set TkFont [MakeTkFont $FindFont(name) $FindFont(weight) $FindFont(slant) "[.textInBBoxDialog.parameters.font.size get]"]
    set PrinterFont [MakePrinterFont  $FindFont(name) $FindFont(weight) $FindFont(slant) "[.textInBBoxDialog.parameters.font.size get]"]
    set TkColor [MakeTkColor "[.textInBBoxDialog.parameters.color.value get]"]
    set PrinterColor [MakePrinterColor "[.textInBBoxDialog.parameters.color.value get]"]
    set DText "[.textInBBoxDialog.parameters.text.tf1.text get 1.0 end-1c]"
    set PText [ParseText "$DText"]
    set DX1 [.textInBBoxDialog.parameters.position.x1 get]i
    set X1 [.textInBBoxDialog.parameters.position.x1 get]
    set DY1 [.textInBBoxDialog.parameters.position.y1 get]i
    set Y1 [.textInBBoxDialog.parameters.position.y1 get]
    set DX2 [.textInBBoxDialog.parameters.position.x2 get]i
    set X2 [.textInBBoxDialog.parameters.position.x2 get]
    set DY2 [.textInBBoxDialog.parameters.position.y2 get]i
    set Y2 [.textInBBoxDialog.parameters.position.y2 get]
    set theItem [list :Type textinbbox \
		:Font [list $PrinterFont $TkFont \
			[list "$FindFont(name)" "$FindFont(weight)" "$FindFont(slant)" "[.textInBBoxDialog.parameters.font.size get]"]] \
		:Color [list $PrinterColor $TkColor]\
		:Text [list $PText $DText] \
		:X1 [list $X1 $DX1] :Y1 [list $Y1 $DY1]\
		:X2 [list $X2 $DX2] :Y2 [list $Y2 $DY2]]
    if {[llength "$oldItem"] != 0} {
      set indexTag [LAssoc :IndexTag $oldItem]
      set index [FindItemIndex $indexTag]
      set printLayout(ItemList) [lreplace "$printLayout(ItemList)" $index  $index [concat :IndexTag $indexTag "$theItem"]]
      catch ".printLayout.frame0.frame1.frame3.frame5.canvas8.sheet delete $indexTag"
    } else {
      set indexTag [GetNextUnusedIndexTag $printLayout(ItemList)]
      lappend printLayout(ItemList) [concat :IndexTag $indexTag "$theItem"]
    }
    set printLayout(Dirty) 1
    set printLayout(ScriptOutdated) 1
    .printLayout.bottomButtons.save config -state normal
    .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet create text $DX1 $DY1 \
		-anchor nw -fill "$TkColor" -font "$TkFont" -text "$DText" \
		-tags $indexTag
    .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet create rectangle \
		$DX1 $DY1 $DX2 $DY2 -fill {} -width 1 -outline black \
		-tags $indexTag
    PrSetSelection $indexTag
    .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet bind $indexTag <1> "PrSetSelection $indexTag"
  }
	
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .textInBBoxDialog"
  } {
    catch "destroy .textInBBoxDialog"
  }
}

proc LineDialog {{oldItem {}}} {
# Line insertion / edit dialog.
# [index] LineDialog!procedure

  global printLayout
  global lineDialog
  set lineDialog(oldItem) "$oldItem"
  set lineDialog(button) -1

# .lineDialog
# The above line makes pasting MUCH easier for me.
# It contains the pathname of the cutted widget.
# Tcl version: 7.6 (Tcl/Tk/XF)
# Tk version: 4.2
# XF version: 4.0
#

  # build widget .lineDialog
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .lineDialog"
  } {
    catch "destroy .lineDialog"
  }
  toplevel .lineDialog 

  # Window manager configurations
  wm maxsize .lineDialog 1009 738
  wm minsize .lineDialog 1 1
  wm protocol .lineDialog WM_DELETE_WINDOW {}
  wm title .lineDialog {Insert a Line}
  wm transient .lineDialog .printLayout

  # build widget .lineDialog.top
  frame .lineDialog.top \
    -borderwidth {2}

  # build widget .lineDialog.top.label2
  label .lineDialog.top.label2 \
    -image {SmallFace}

  # build widget .lineDialog.top.label3
  label .lineDialog.top.label3 \
    -background {yellow} \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -foreground {brown} \
    -text {Insert a Line}

  # build widget .lineDialog.parameters
  frame .lineDialog.parameters \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .lineDialog.parameters.position1
  frame .lineDialog.parameters.position1 \
    -borderwidth {2}

  # build widget .lineDialog.parameters.position1.label18
  label .lineDialog.parameters.position1.label18 \
    -text {X1:}

  # build widget .lineDialog.parameters.position1.x
  entry .lineDialog.parameters.position1.x

  # build widget .lineDialog.parameters.position1.label20
  label .lineDialog.parameters.position1.label20 \
    -text {Y1:}

  # build widget .lineDialog.parameters.position1.y
  entry .lineDialog.parameters.position1.y

  # build widget .lineDialog.parameters.position2
  frame .lineDialog.parameters.position2 \
    -borderwidth {2}

  # build widget .lineDialog.parameters.position2.label18
  label .lineDialog.parameters.position2.label18 \
    -text {X2:}

  # build widget .lineDialog.parameters.position2.x
  entry .lineDialog.parameters.position2.x

  # build widget .lineDialog.parameters.position2.label20
  label .lineDialog.parameters.position2.label20 \
    -text {Y2:}

  # build widget .lineDialog.parameters.position2.y
  entry .lineDialog.parameters.position2.y

  # build widget .lineDialog.parameters.color
  frame .lineDialog.parameters.color \
    -borderwidth {2}

  # build widget .lineDialog.parameters.color.label25
  label .lineDialog.parameters.color.label25 \
    -text {Color:}

  # build widget .lineDialog.parameters.color.value
  entry .lineDialog.parameters.color.value

  # build widget .lineDialog.parameters.color.button27
  button .lineDialog.parameters.color.button27 \
    -command {set newColor "[tk_chooseColor -title {Select A Color} -initialcolor [.lineDialog.parameters.color.value get]]"
if {[string length "$newColor"] > 0} {
  .lineDialog.parameters.color.value delete 0 end
  .lineDialog.parameters.color.value insert end "$newColor"
}} \
    -padx {9} \
    -pady {3} \
    -text {Browse}

  # build widget .lineDialog.parameters.lineWidth
  frame .lineDialog.parameters.lineWidth \
    -borderwidth {2}

  # build widget .lineDialog.parameters.lineWidth.label5
  label .lineDialog.parameters.lineWidth.label5 \
    -text {Line Width:}

  # build widget .lineDialog.parameters.lineWidth.lwOpt
  tk_optionMenu .lineDialog.parameters.lineWidth.lwOpt lineDialog(Width) \
		1/16 1/8 3/16 1/4 5/16 3/8 7/16 1/2 9/16 5/8 11/16 3/4 13/16 \
		7/8 15/16 1 Other

  # build widget .lineDialog.parameters.lineWidth.lineWidth
  entry .lineDialog.parameters.lineWidth.lineWidth

  # build widget .lineDialog.parameters.lineWidth.label6
  label .lineDialog.parameters.lineWidth.label6 \
    -text {inches}

  # build widget .lineDialog.frame2
  frame .lineDialog.frame2 \
    -borderwidth {2}

  # build widget .lineDialog.frame2.button15
  button .lineDialog.frame2.button15 \
    -padx {9} \
    -pady {3} \
    -text {OK} \
    -command {
	global lineDialog
        if {![CheckXtypeAndRange {X1} "[.lineDialog.parameters.position1.x get]"]} {return}
        if {![CheckYtypeAndRange {Y1} "[.lineDialog.parameters.position1.y get]"]} {return}
        if {![CheckXtypeAndRange {X2} "[.lineDialog.parameters.position2.x get]"]} {return}
        if {![CheckYtypeAndRange {Y2} "[.lineDialog.parameters.position2.y get]"]} {return}
	set color "[.lineDialog.parameters.color.value get]"
	if {[catch [list winfo rgb . $color]]} {
	  hl_warning "Bad color spec: $color, try again"
	  return
	}
	if {[string compare "$lineDialog(Width)" {Other}] == 0} {
	  set lw "[.lineDialog.parameters.lineWidth.lineWidth get]"
	  if {[catch [list expr "double($lw)"] v]} {
	    hl_warning "Not a number (Line Width): $lw, try again"
	    return
	  } elseif {$v <= 0} {
	    hl_warning "Zero or negative Line Width: $v, try again"
	    return
	  }
	}
	set lineDialog(button) 1
    }

  # build widget .lineDialog.frame2.button16
  button .lineDialog.frame2.button16 \
    -padx {9} \
    -pady {3} \
    -text {Cancel} \
    -command {
	global lineDialog
	set lineDialog(button) 0
    }

  # build widget .lineDialog.frame2.button17
  button .lineDialog.frame2.button17 \
    -padx {9} \
    -pady {3} \
    -text {Help} \
    -command {hl_Help {Line Dialog Help}}

  # pack master .lineDialog.top
  pack configure .lineDialog.top.label2 \
    -fill y \
    -side left
  pack configure .lineDialog.top.label3 \
    -expand 1 \
    -fill x \
    -side right

  # pack master .lineDialog.parameters
  pack configure .lineDialog.parameters.color \
    -expand 1 \
    -fill x
  pack configure .lineDialog.parameters.position1 \
    -expand 1 \
    -fill x
  pack configure .lineDialog.parameters.position2 \
    -expand 1 \
    -fill x
  pack configure .lineDialog.parameters.lineWidth \
    -expand 1 \
    -fill x

  # pack master .lineDialog.parameters.position1
  pack configure .lineDialog.parameters.position1.label18 \
    -side left
  pack configure .lineDialog.parameters.position1.x \
    -expand 1 \
    -fill x \
    -side left
  pack configure .lineDialog.parameters.position1.label20 \
    -side left
  pack configure .lineDialog.parameters.position1.y \
    -expand 1 \
    -fill x \
    -side left

  # pack master .lineDialog.parameters.position2
  pack configure .lineDialog.parameters.position2.label18 \
    -side left
  pack configure .lineDialog.parameters.position2.x \
    -expand 1 \
    -fill x \
    -side left
  pack configure .lineDialog.parameters.position2.label20 \
    -side left
  pack configure .lineDialog.parameters.position2.y \
    -expand 1 \
    -fill x \
    -side left

  # pack master .lineDialog.parameters.color
  pack configure .lineDialog.parameters.color.label25 \
    -side left
  pack configure .lineDialog.parameters.color.value \
    -expand 1 \
    -fill x \
    -side left
  pack configure .lineDialog.parameters.color.button27 \
    -side right

  # pack master .lineDialog.parameters.lineWidth
  pack configure .lineDialog.parameters.lineWidth.label5 \
    -side left
  pack configure .lineDialog.parameters.lineWidth.lwOpt \
    -side left
  pack configure .lineDialog.parameters.lineWidth.lineWidth \
    -expand 1 \
    -fill x \
    -side left
  pack configure .lineDialog.parameters.lineWidth.label6 \
    -side right
    

  # pack master .lineDialog.frame2
  pack configure .lineDialog.frame2.button15 \
    -expand 1 \
    -side left
  pack configure .lineDialog.frame2.button16 \
    -expand 1 \
    -side left
  pack configure .lineDialog.frame2.button17 \
    -expand 1 \
    -side right

  # pack master .lineDialog
  pack configure .lineDialog.top \
    -fill x
  pack configure .lineDialog.parameters \
    -expand 1 \
    -fill both
  pack configure .lineDialog.frame2 \
    -expand 1 \
    -fill x

  global printLayout
  if {[llength "$oldItem"] == 0} {
    .lineDialog.parameters.position1.x insert end {0}
    .lineDialog.parameters.position1.y insert end {0}
    .lineDialog.parameters.position2.x insert end {0}
    .lineDialog.parameters.position2.y insert end {0}
    .lineDialog.parameters.color.value insert end {black}
    .lineDialog.parameters.lineWidth.lineWidth insert end {0.0625}
    set lineDialog(Width) 1/16
  } else {
    .lineDialog.parameters.position1.x insert end "[lindex [LAssoc :X1 $oldItem] 0]"
    .lineDialog.parameters.position1.y insert end "[lindex [LAssoc :Y1 $oldItem] 0]"
    .lineDialog.parameters.position2.x insert end "[lindex [LAssoc :X2 $oldItem] 0]"
    .lineDialog.parameters.position2.y insert end "[lindex [LAssoc :Y2 $oldItem] 0]"
    .lineDialog.parameters.color.value insert end "[lindex [LAssoc :Color $oldItem] 1]"
    .lineDialog.parameters.lineWidth.lineWidth insert end "[lindex [LAssoc :LW $oldItem] 0]"
    set lw [expr int([lindex [LAssoc :LW $oldItem] 0] * 16)]
    switch -exact $lw {
      1 {
	  set lineDialog(Width) 1/16
      }
      2 {
	  set lineDialog(Width) 1/8
      }
      3 {
	  set lineDialog(Width) 3/16
      }
      4 {
	  set lineDialog(Width) 1/4
      }
      5 {
	  set lineDialog(Width) 5/16
      }
      6 {
	  set lineDialog(Width) 3/8
      }
      7 {
	  set lineDialog(Width) 7/16
      }
      8 {
	  set lineDialog(Width) 1/2
      }
      9 {
	  set lineDialog(Width) 9/16
      }
      10 {
	  set lineDialog(Width) 5/8
      }
      11 {
	  set lineDialog(Width) 11/16
      }
      12 {
	  set lineDialog(Width) 3/4
      }
      13 {
	  set lineDialog(Width) 13/16
      }
      14 {
	  set lineDialog(Width) 7/8
      }
      15 {
	  set lineDialog(Width) 15/16
      }
      16 {
	  set lineDialog(Width) 1
      }
      default {
	  set lineDialog(Width) Other
      }
    }
  }

# end of widget tree

  set oldFocus [focus]
  set oldGrab [grab current .lineDialog]
  if {$oldGrab != ""} {
    set grabStatus [grab status $oldGrab]
  }
  grab .lineDialog
  focus .lineDialog
  tkwait variable lineDialog(button)

  catch {focus $oldFocus}
  if {$oldGrab != ""} {
    if {$grabStatus == "global"} {
      grab -global $oldGrab
    } else {
      grab $oldGrab
    }
  }

  if {$lineDialog(button) == 1} {
    global printLayout
    set TkColor [MakeTkColor "[.lineDialog.parameters.color.value get]"]
    set PrinterColor [MakePrinterColor "[.lineDialog.parameters.color.value get]"]
    set DX1 [.lineDialog.parameters.position1.x get]i
    set X1 [.lineDialog.parameters.position1.x get]
    set DY1 [.lineDialog.parameters.position1.y get]i
    set Y1 [.lineDialog.parameters.position1.y get]
    set DX2 [.lineDialog.parameters.position2.x get]i
    set X2 [.lineDialog.parameters.position2.x get]
    set DY2 [.lineDialog.parameters.position2.y get]i
    set Y2 [.lineDialog.parameters.position2.y get]
    if {[string compare "$lineDialog(Width)" {Other}] == 0} {
      set LW "[.lineDialog.parameters.lineWidth.lineWidth get]"
    } elseif {[string compare "$lineDialog(Width)" {1}] == 0} {
      set LW 1
    } else {
      set ND [split $lineDialog(Width) {/}]
      set LW [expr double([lindex $ND 0]) / double([lindex $ND 1])]
    }
    set DLW "$LW"
    append DLW {i}      
    set theItem [list :Type line \
		      :Color [list $PrinterColor $TkColor]\
		      :X1 [list $X1 $DX1] :Y1 [list $Y1 $DY1]\
		      :X2 [list $X2 $DX2] :Y2 [list $Y2 $DY2]\
		      :LW [list $LW $DLW]]
    if {[llength "$oldItem"] != 0} {
      set indexTag [LAssoc :IndexTag $oldItem]
      set index [FindItemIndex $indexTag]
      set printLayout(ItemList) [lreplace "$printLayout(ItemList)" $index  $index [concat :IndexTag $indexTag "$theItem"]]
      catch ".printLayout.frame0.frame1.frame3.frame5.canvas8.sheet delete $indexTag"
    } else {
      set indexTag [GetNextUnusedIndexTag $printLayout(ItemList)]
      lappend printLayout(ItemList) [concat :IndexTag $indexTag "$theItem"]
    }
    set printLayout(Dirty) 1
    set printLayout(ScriptOutdated) 1
    .printLayout.bottomButtons.save config -state normal
    .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet create line \
	$DX1 $DY1 $DX2 $DY2 -fill "$TkColor" -width $DLW -tags $indexTag
    PrSetSelection $indexTag
    .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet bind $indexTag <1> "PrSetSelection $indexTag"
  }

  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .lineDialog"
  } {
    catch "destroy .lineDialog"
  }

}

proc RectangleDialog {{oldItem {}}} {
# Rectangle insertion / edit dialog.
# [index] RectangleDialog!procedure

  global printLayout
  global rectangleDialog
  set rectangleDialog(oldItem) "$oldItem"
  set rectangleDialog(button) -1

# .rectangleDialog
# The above line makes pasting MUCH easier for me.
# It contains the pathname of the cutted widget.
# Tcl version: 7.6 (Tcl/Tk/XF)
# Tk version: 4.2
# XF version: 4.0
#

  # build widget .rectangleDialog
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .rectangleDialog"
  } {
    catch "destroy .rectangleDialog"
  }
  toplevel .rectangleDialog 

  # Window manager configurations
  wm maxsize .rectangleDialog 1009 738
  wm minsize .rectangleDialog 1 1
  wm protocol .rectangleDialog WM_DELETE_WINDOW {}
  wm title .rectangleDialog {Insert a Rectangle}
  wm transient .rectangleDialog .printLayout

  # build widget .rectangleDialog.top
  frame .rectangleDialog.top \
    -borderwidth {2}

  # build widget .rectangleDialog.top.label2
  label .rectangleDialog.top.label2 \
    -image {SmallFace}

  # build widget .rectangleDialog.top.label3
  label .rectangleDialog.top.label3 \
    -background {yellow} \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -foreground {brown} \
    -text {Insert a Rectangle}

  # build widget .rectangleDialog.parameters
  frame .rectangleDialog.parameters \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .rectangleDialog.parameters.position1
  frame .rectangleDialog.parameters.position1 \
    -borderwidth {2}

  # build widget .rectangleDialog.parameters.position1.label18
  label .rectangleDialog.parameters.position1.label18 \
    -text {X1:}

  # build widget .rectangleDialog.parameters.position1.x
  entry .rectangleDialog.parameters.position1.x

  # build widget .rectangleDialog.parameters.position1.label20
  label .rectangleDialog.parameters.position1.label20 \
    -text {Y1:}

  # build widget .rectangleDialog.parameters.position1.y
  entry .rectangleDialog.parameters.position1.y

  # build widget .rectangleDialog.parameters.position2
  frame .rectangleDialog.parameters.position2 \
    -borderwidth {2}

  # build widget .rectangleDialog.parameters.position2.label18
  label .rectangleDialog.parameters.position2.label18 \
    -text {X2:}

  # build widget .rectangleDialog.parameters.position2.x
  entry .rectangleDialog.parameters.position2.x

  # build widget .rectangleDialog.parameters.position2.label20
  label .rectangleDialog.parameters.position2.label20 \
    -text {Y2:}

  # build widget .rectangleDialog.parameters.position2.y
  entry .rectangleDialog.parameters.position2.y

  # build widget .rectangleDialog.parameters.color
  frame .rectangleDialog.parameters.color \
    -borderwidth {2}

  # build widget .rectangleDialog.parameters.color.label25
  label .rectangleDialog.parameters.color.label25 \
    -text {Color:}

  # build widget .rectangleDialog.parameters.color.value
  entry .rectangleDialog.parameters.color.value

  # build widget .rectangleDialog.parameters.color.button27
  button .rectangleDialog.parameters.color.button27 \
    -command {set newColor "[tk_chooseColor -title {Select A Color} -initialcolor [.rectangleDialog.parameters.color.value get]]"
if {[string length "$newColor"] > 0} {
  .rectangleDialog.parameters.color.value delete 0 end
  .rectangleDialog.parameters.color.value insert end "$newColor"
}} \
    -padx {9} \
    -pady {3} \
    -text {Browse}

  # build widget .rectangleDialog.parameters.thickness
  frame .rectangleDialog.parameters.thickness \
    -borderwidth {2}

  # build widget .rectangleDialog.parameters.thickness.label5
  label .rectangleDialog.parameters.thickness.label5 \
    -text {Line Width:}

  # build widget .rectangleDialog.parameters.thickness.thkOpt
  tk_optionMenu .rectangleDialog.parameters.thickness.thkOpt rectangleDialog(Width) \
		1/16 1/8 3/16 1/4 5/16 3/8 7/16 1/2 9/16 5/8 11/16 3/4 13/16 \
		7/8 15/16 1 Other

  # build widget .rectangleDialog.parameters.thickness.thickness
  entry .rectangleDialog.parameters.thickness.thickness

  # build widget .rectangleDialog.parameters.thickness.label6
  label .rectangleDialog.parameters.thickness.label6 \
    -text {inches}

  # build widget .rectangleDialog.frame2
  frame .rectangleDialog.frame2 \
    -borderwidth {2}

  # build widget .rectangleDialog.frame2.button15
  button .rectangleDialog.frame2.button15 \
    -padx {9} \
    -pady {3} \
    -text {OK} \
    -command {
	global rectangleDialog
        if {![CheckXtypeAndRange {X1} "[.rectangleDialog.parameters.position1.x get]"]} {return}
        if {![CheckYtypeAndRange {Y1} "[.rectangleDialog.parameters.position1.y get]"]} {return}
        if {![CheckXtypeAndRange {X2} "[.rectangleDialog.parameters.position2.x get]"]} {return}
        if {![CheckYtypeAndRange {Y2} "[.rectangleDialog.parameters.position2.y get]"]} {return}
	set color "[.rectangleDialog.parameters.color.value get]"
	if {[catch [list winfo rgb . $color]]} {
	  hl_warning "Bad color spec: $color, try again"
	  return
	}
	if {[string compare "$rectangleDialog(Width)" {Other}] == 0} {
	  set thk "[.rectangleDialog.parameters.thickness.thickness get]"
	  if {[catch [list expr "double($thk)"] v]} {
	    hl_warning "Not a number (Line Width): $thk, try again"
	    return
	  } elseif {$v <= 0} {
	    hl_warning "Zero or negative Line Width: $v, try again"
	    return
	  }
	}
	set rectangleDialog(button) 1
    }

  # build widget .rectangleDialog.frame2.button16
  button .rectangleDialog.frame2.button16 \
    -padx {9} \
    -pady {3} \
    -text {Cancel} \
    -command {
	global rectangleDialog
	set rectangleDialog(button) 0
    }

  # build widget .rectangleDialog.frame2.button17
  button .rectangleDialog.frame2.button17 \
    -padx {9} \
    -pady {3} \
    -text {Help} \
    -command {hl_Help {Rectangle Dialog Help}}

  # pack master .rectangleDialog.top
  pack configure .rectangleDialog.top.label2 \
    -fill y \
    -side left
  pack configure .rectangleDialog.top.label3 \
    -expand 1 \
    -fill x \
    -side right

  # pack master .rectangleDialog.parameters
  pack configure .rectangleDialog.parameters.color \
    -expand 1 \
    -fill x
  pack configure .rectangleDialog.parameters.position1 \
    -expand 1 \
    -fill x
  pack configure .rectangleDialog.parameters.position2 \
    -expand 1 \
    -fill x
  pack configure .rectangleDialog.parameters.thickness \
    -expand 1 \
    -fill x

  # pack master .rectangleDialog.parameters.position1
  pack configure .rectangleDialog.parameters.position1.label18 \
    -side left
  pack configure .rectangleDialog.parameters.position1.x \
    -expand 1 \
    -fill x \
    -side left
  pack configure .rectangleDialog.parameters.position1.label20 \
    -side left
  pack configure .rectangleDialog.parameters.position1.y \
    -expand 1 \
    -fill x \
    -side left

  # pack master .rectangleDialog.parameters.position2
  pack configure .rectangleDialog.parameters.position2.label18 \
    -side left
  pack configure .rectangleDialog.parameters.position2.x \
    -expand 1 \
    -fill x \
    -side left
  pack configure .rectangleDialog.parameters.position2.label20 \
    -side left
  pack configure .rectangleDialog.parameters.position2.y \
    -expand 1 \
    -fill x \
    -side left

  # pack master .rectangleDialog.parameters.color
  pack configure .rectangleDialog.parameters.color.label25 \
    -side left
  pack configure .rectangleDialog.parameters.color.value \
    -expand 1 \
    -fill x \
    -side left
  pack configure .rectangleDialog.parameters.color.button27 \
    -side right

  # pack master .rectangleDialog.parameters.thickness
  pack configure .rectangleDialog.parameters.thickness.label5 \
    -side left
  pack configure .rectangleDialog.parameters.thickness.thkOpt \
    -side left
  pack configure .rectangleDialog.parameters.thickness.thickness \
    -expand 1 \
    -fill x \
    -side left
  pack configure .rectangleDialog.parameters.thickness.label6 \
    -side right
    

  # pack master .rectangleDialog.frame2
  pack configure .rectangleDialog.frame2.button15 \
    -expand 1 \
    -side left
  pack configure .rectangleDialog.frame2.button16 \
    -expand 1 \
    -side left
  pack configure .rectangleDialog.frame2.button17 \
    -expand 1 \
    -side right

  # pack master .rectangleDialog
  pack configure .rectangleDialog.top \
    -fill x
  pack configure .rectangleDialog.parameters \
    -expand 1 \
    -fill both
  pack configure .rectangleDialog.frame2 \
    -expand 1 \
    -fill x

  global printLayout
  if {[llength "$oldItem"] == 0} {
    .rectangleDialog.parameters.position1.x insert end {0}
    .rectangleDialog.parameters.position1.y insert end {0}
    .rectangleDialog.parameters.position2.x insert end {0}
    .rectangleDialog.parameters.position2.y insert end {0}
    .rectangleDialog.parameters.color.value insert end {black}
    .rectangleDialog.parameters.thickness.thickness insert end {0.0625}
    set rectangleDialog(Width) 1/16
  } else {
    .rectangleDialog.parameters.position1.x insert end "[lindex [LAssoc :X1 $oldItem] 0]"
    .rectangleDialog.parameters.position1.y insert end "[lindex [LAssoc :Y1 $oldItem] 0]"
    .rectangleDialog.parameters.position2.x insert end "[lindex [LAssoc :X2 $oldItem] 0]"
    .rectangleDialog.parameters.position2.y insert end "[lindex [LAssoc :Y2 $oldItem] 0]"
    .rectangleDialog.parameters.color.value insert end "[lindex [LAssoc :Color $oldItem] 1]"
    .rectangleDialog.parameters.thickness.thickness insert end "[lindex [LAssoc :THK $oldItem] 0]"
    set thk [expr int([lindex [LAssoc :THK $oldItem] 0] * 16)]
    switch -exact $thk {
      1 {
	  set rectangleDialog(Width) 1/16
      }
      2 {
	  set rectangleDialog(Width) 1/8
      }
      3 {
	  set rectangleDialog(Width) 3/16
      }
      4 {
	  set rectangleDialog(Width) 1/4
      }
      5 {
	  set rectangleDialog(Width) 5/16
      }
      6 {
	  set rectangleDialog(Width) 3/8
      }
      7 {
	  set rectangleDialog(Width) 7/16
      }
      8 {
	  set rectangleDialog(Width) 1/2
      }
      9 {
	  set rectangleDialog(Width) 9/16
      }
      10 {
	  set rectangleDialog(Width) 5/8
      }
      11 {
	  set rectangleDialog(Width) 11/16
      }
      12 {
	  set rectangleDialog(Width) 3/4
      }
      13 {
	  set rectangleDialog(Width) 13/16
      }
      14 {
	  set rectangleDialog(Width) 7/8
      }
      15 {
	  set rectangleDialog(Width) 15/16
      }
      16 {
	  set rectangleDialog(Width) 1
      }
      default {
	  set rectangleDialog(Width) Other
      }
    }
  }

# end of widget tree

  set oldFocus [focus]
  set oldGrab [grab current .rectangleDialog]
  if {$oldGrab != ""} {
    set grabStatus [grab status $oldGrab]
  }
  grab .rectangleDialog
  focus .rectangleDialog
  tkwait variable rectangleDialog(button)

  catch {focus $oldFocus}
  if {$oldGrab != ""} {
    if {$grabStatus == "global"} {
      grab -global $oldGrab
    } else {
      grab $oldGrab
    }
  }

  if {$rectangleDialog(button) == 1} {
    global printLayout
    set TkColor [MakeTkColor "[.rectangleDialog.parameters.color.value get]"]
    set PrinterColor [MakePrinterColor "[.rectangleDialog.parameters.color.value get]"]
    set DX1 [.rectangleDialog.parameters.position1.x get]i
    set X1 [.rectangleDialog.parameters.position1.x get]
    set DY1 [.rectangleDialog.parameters.position1.y get]i
    set Y1 [.rectangleDialog.parameters.position1.y get]
    set DX2 [.rectangleDialog.parameters.position2.x get]i
    set X2 [.rectangleDialog.parameters.position2.x get]
    set DY2 [.rectangleDialog.parameters.position2.y get]i
    set Y2 [.rectangleDialog.parameters.position2.y get]
    if {[string compare "$rectangleDialog(Width)" {Other}] == 0} {
      set thk "[.rectangleDialog.parameters.thickness.thickness get]"
    } elseif {[string compare "$rectangleDialog(Width)" {1}] == 0} {
      set thk 1
    } else {
      set ND [split $rectangleDialog(Width) {/}]
      set thk [expr double([lindex $ND 0]) / double([lindex $ND 1])]
    }
    set dthk "$thk"
    append dthk {i}      
    set theItem [list :Type rectangle \
		      :Color [list $PrinterColor $TkColor]\
		      :X1 [list $X1 $DX1] :Y1 [list $Y1 $DY1]\
		      :X2 [list $X2 $DX2] :Y2 [list $Y2 $DY2]\
		      :THK [list $thk $dthk]]
    if {[llength "$oldItem"] != 0} {
      set indexTag [LAssoc :IndexTag $oldItem]
      set index [FindItemIndex $indexTag]
      set printLayout(ItemList) [lreplace "$printLayout(ItemList)" $index  $index [concat :IndexTag $indexTag "$theItem"]]
      catch ".printLayout.frame0.frame1.frame3.frame5.canvas8.sheet delete $indexTag"
    } else {
      set indexTag [GetNextUnusedIndexTag $printLayout(ItemList)]
      lappend printLayout(ItemList) [concat :IndexTag $indexTag "$theItem"]
    }
    set printLayout(Dirty) 1
    set printLayout(ScriptOutdated) 1
    .printLayout.bottomButtons.save config -state normal
    .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet create rectangle \
	$DX1 $DY1 $DX2 $DY2 -fill {} -outline "$TkColor" -width $dthk -tags $indexTag
    PrSetSelection $indexTag
    .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet bind $indexTag <1> "PrSetSelection $indexTag"
  }

  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .rectangleDialog"
  } {
    catch "destroy .rectangleDialog"
  }
}

proc FilledRectangleDialog {{oldItem {}}} {
# Filled Rectangle insertion / edit dialog.
# [index] FilledRectangleDialog!procedure

  global printLayout
  global filledRectangleDialog
  set filledRectangleDialog(oldItem) "$oldItem"
  set filledRectangleDialog(button) -1

# .filledRectangleDialog
# The above line makes pasting MUCH easier for me.
# It contains the pathname of the cutted widget.
# Tcl version: 7.6 (Tcl/Tk/XF)
# Tk version: 4.2
# XF version: 4.0
#

  # build widget .filledRectangleDialog
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .filledRectangleDialog"
  } {
    catch "destroy .filledRectangleDialog"
  }
  toplevel .filledRectangleDialog 

  # Window manager configurations
  wm maxsize .filledRectangleDialog 1009 738
  wm minsize .filledRectangleDialog 1 1
  wm protocol .filledRectangleDialog WM_DELETE_WINDOW {}
  wm title .filledRectangleDialog {Insert a Filled Rectangle}
  wm transient .filledRectangleDialog .printLayout

  # build widget .filledRectangleDialog.top
  frame .filledRectangleDialog.top \
    -borderwidth {2}

  # build widget .filledRectangleDialog.top.label2
  label .filledRectangleDialog.top.label2 \
    -image {SmallFace}

  # build widget .filledRectangleDialog.top.label3
  label .filledRectangleDialog.top.label3 \
    -background {yellow} \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -foreground {brown} \
    -text {Insert a Filled Rectangle}

  # build widget .filledRectangleDialog.parameters
  frame .filledRectangleDialog.parameters \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .filledRectangleDialog.parameters.position1
  frame .filledRectangleDialog.parameters.position1 \
    -borderwidth {2}

  # build widget .filledRectangleDialog.parameters.position1.label18
  label .filledRectangleDialog.parameters.position1.label18 \
    -text {X1:}

  # build widget .filledRectangleDialog.parameters.position1.x
  entry .filledRectangleDialog.parameters.position1.x

  # build widget .filledRectangleDialog.parameters.position1.label20
  label .filledRectangleDialog.parameters.position1.label20 \
    -text {Y1:}

  # build widget .filledRectangleDialog.parameters.position1.y
  entry .filledRectangleDialog.parameters.position1.y

  # build widget .filledRectangleDialog.parameters.position2
  frame .filledRectangleDialog.parameters.position2 \
    -borderwidth {2}

  # build widget .filledRectangleDialog.parameters.position2.label18
  label .filledRectangleDialog.parameters.position2.label18 \
    -text {X2:}

  # build widget .filledRectangleDialog.parameters.position2.x
  entry .filledRectangleDialog.parameters.position2.x

  # build widget .filledRectangleDialog.parameters.position2.label20
  label .filledRectangleDialog.parameters.position2.label20 \
    -text {Y2:}

  # build widget .filledRectangleDialog.parameters.position2.y
  entry .filledRectangleDialog.parameters.position2.y

  # build widget .filledRectangleDialog.parameters.color
  frame .filledRectangleDialog.parameters.color \
    -borderwidth {2}

  # build widget .filledRectangleDialog.parameters.color.label25
  label .filledRectangleDialog.parameters.color.label25 \
    -text {Color:}

  # build widget .filledRectangleDialog.parameters.color.value
  entry .filledRectangleDialog.parameters.color.value

  # build widget .filledRectangleDialog.parameters.color.button27
  button .filledRectangleDialog.parameters.color.button27 \
    -command {set newColor "[tk_chooseColor -title {Select A Color} -initialcolor [.filledRectangleDialog.parameters.color.value get]]"
if {[string length "$newColor"] > 0} {
  .filledRectangleDialog.parameters.color.value delete 0 end
  .filledRectangleDialog.parameters.color.value insert end "$newColor"
}} \
    -padx {9} \
    -pady {3} \
    -text {Browse}

  # build widget .filledRectangleDialog.frame2
  frame .filledRectangleDialog.frame2 \
    -borderwidth {2}

  # build widget .filledRectangleDialog.frame2.button15
  button .filledRectangleDialog.frame2.button15 \
    -padx {9} \
    -pady {3} \
    -text {OK} \
    -command {
	global filledRectangleDialog
        if {![CheckXtypeAndRange {X1} "[.filledRectangleDialog.parameters.position1.x get]"]} {return}
        if {![CheckYtypeAndRange {Y1} "[.filledRectangleDialog.parameters.position1.y get]"]} {return}
        if {![CheckXtypeAndRange {X2} "[.filledRectangleDialog.parameters.position2.x get]"]} {return}
        if {![CheckYtypeAndRange {Y2} "[.filledRectangleDialog.parameters.position2.y get]"]} {return}
	set color "[.filledRectangleDialog.parameters.color.value get]"
	if {[catch [list winfo rgb . $color]]} {
	  hl_warning "Bad color spec: $color, try again"
	  return
	}
	set filledRectangleDialog(button) 1
    }

  # build widget .filledRectangleDialog.frame2.button16
  button .filledRectangleDialog.frame2.button16 \
    -padx {9} \
    -pady {3} \
    -text {Cancel} \
    -command {
	global filledRectangleDialog
	set filledRectangleDialog(button) 0
    }

  # build widget .filledRectangleDialog.frame2.button17
  button .filledRectangleDialog.frame2.button17 \
    -padx {9} \
    -pady {3} \
    -text {Help} \
    -command {hl_Help {Filled Rectangle Dialog Help}}

  # pack master .filledRectangleDialog.top
  pack configure .filledRectangleDialog.top.label2 \
    -fill y \
    -side left
  pack configure .filledRectangleDialog.top.label3 \
    -expand 1 \
    -fill x \
    -side right

  # pack master .filledRectangleDialog.parameters
  pack configure .filledRectangleDialog.parameters.color \
    -expand 1 \
    -fill x
  pack configure .filledRectangleDialog.parameters.position1 \
    -expand 1 \
    -fill x
  pack configure .filledRectangleDialog.parameters.position2 \
    -expand 1 \
    -fill x

  # pack master .filledRectangleDialog.parameters.position1
  pack configure .filledRectangleDialog.parameters.position1.label18 \
    -side left
  pack configure .filledRectangleDialog.parameters.position1.x \
    -expand 1 \
    -fill x \
    -side left
  pack configure .filledRectangleDialog.parameters.position1.label20 \
    -side left
  pack configure .filledRectangleDialog.parameters.position1.y \
    -expand 1 \
    -fill x \
    -side left

  # pack master .filledRectangleDialog.parameters.position2
  pack configure .filledRectangleDialog.parameters.position2.label18 \
    -side left
  pack configure .filledRectangleDialog.parameters.position2.x \
    -expand 1 \
    -fill x \
    -side left
  pack configure .filledRectangleDialog.parameters.position2.label20 \
    -side left
  pack configure .filledRectangleDialog.parameters.position2.y \
    -expand 1 \
    -fill x \
    -side left

  # pack master .filledRectangleDialog.parameters.color
  pack configure .filledRectangleDialog.parameters.color.label25 \
    -side left
  pack configure .filledRectangleDialog.parameters.color.value \
    -expand 1 \
    -fill x \
    -side left
  pack configure .filledRectangleDialog.parameters.color.button27 \
    -side right

  # pack master .filledRectangleDialog.frame2
  pack configure .filledRectangleDialog.frame2.button15 \
    -expand 1 \
    -side left
  pack configure .filledRectangleDialog.frame2.button16 \
    -expand 1 \
    -side left
  pack configure .filledRectangleDialog.frame2.button17 \
    -expand 1 \
    -side right

  # pack master .filledRectangleDialog
  pack configure .filledRectangleDialog.top \
    -fill x
  pack configure .filledRectangleDialog.parameters \
    -expand 1 \
    -fill both
  pack configure .filledRectangleDialog.frame2 \
    -expand 1 \
    -fill x

  global printLayout
  if {[llength "$oldItem"] == 0} {
    .filledRectangleDialog.parameters.position1.x insert end {0}
    .filledRectangleDialog.parameters.position1.y insert end {0}
    .filledRectangleDialog.parameters.position2.x insert end {0}
    .filledRectangleDialog.parameters.position2.y insert end {0}
    .filledRectangleDialog.parameters.color.value insert end {black}
  } else {
    .filledRectangleDialog.parameters.position1.x insert end "[lindex [LAssoc :X1 $oldItem] 0]"
    .filledRectangleDialog.parameters.position1.y insert end "[lindex [LAssoc :Y1 $oldItem] 0]"
    .filledRectangleDialog.parameters.position2.x insert end "[lindex [LAssoc :X2 $oldItem] 0]"
    .filledRectangleDialog.parameters.position2.y insert end "[lindex [LAssoc :Y2 $oldItem] 0]"
    .filledRectangleDialog.parameters.color.value insert end "[lindex [LAssoc :Color $oldItem] 1]"
  }


# end of widget tree

  set oldFocus [focus]
  set oldGrab [grab current .filledRectangleDialog]
  if {$oldGrab != ""} {
    set grabStatus [grab status $oldGrab]
  }
  grab .filledRectangleDialog
  focus .filledRectangleDialog
  tkwait variable filledRectangleDialog(button)

  catch {focus $oldFocus}
  if {$oldGrab != ""} {
    if {$grabStatus == "global"} {
      grab -global $oldGrab
    } else {
      grab $oldGrab
    }
  }

  if {$filledRectangleDialog(button) == 1} {
    global printLayout
    set TkColor [MakeTkColor "[.filledRectangleDialog.parameters.color.value get]"]
    set PrinterColor [MakePrinterColor "[.filledRectangleDialog.parameters.color.value get]"]
    set DX1 [.filledRectangleDialog.parameters.position1.x get]i
    set X1 [.filledRectangleDialog.parameters.position1.x get]
    set DY1 [.filledRectangleDialog.parameters.position1.y get]i
    set Y1 [.filledRectangleDialog.parameters.position1.y get]
    set DX2 [.filledRectangleDialog.parameters.position2.x get]i
    set X2 [.filledRectangleDialog.parameters.position2.x get]
    set DY2 [.filledRectangleDialog.parameters.position2.y get]i
    set Y2 [.filledRectangleDialog.parameters.position2.y get]
    set theItem [list :Type filledrectangle \
		      :Color [list $PrinterColor $TkColor]\
		      :X1 [list $X1 $DX1] :Y1 [list $Y1 $DY1]\
		      :X2 [list $X2 $DX2] :Y2 [list $Y2 $DY2]]
    if {[llength "$oldItem"] != 0} {
      set indexTag [LAssoc :IndexTag $oldItem]
      set index [FindItemIndex $indexTag]
      set printLayout(ItemList) [lreplace "$printLayout(ItemList)" $index  $index [concat :IndexTag $indexTag "$theItem"]]
      catch ".printLayout.frame0.frame1.frame3.frame5.canvas8.sheet delete $indexTag"
    } else {
      set indexTag [GetNextUnusedIndexTag $printLayout(ItemList)]
      lappend printLayout(ItemList) [concat :IndexTag $indexTag "$theItem"]
    }
    set printLayout(Dirty) 1
    set printLayout(ScriptOutdated) 1
    .printLayout.bottomButtons.save config -state normal
    .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet create rectangle \
	$DX1 $DY1 $DX2 $DY2 -fill "$TkColor" -width 0 -outline {} -tags $indexTag
    PrSetSelection $indexTag
    .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet bind $indexTag <1> "PrSetSelection $indexTag"
  }

  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .filledRectangleDialog"
  } {
    catch "destroy .filledRectangleDialog"
  }
}

proc OvalDialog {{oldItem {}}} {
# Oval Dialog insertion / edit dialog.
# [index] OvalDialog!procedure

  global printLayout
  global ovalDialog
  set ovalDialog(oldItem) "$oldItem"
  set ovalDialog(button) -1

# .ovalDialog
# The above line makes pasting MUCH easier for me.
# It contains the pathname of the cutted widget.
# Tcl version: 7.6 (Tcl/Tk/XF)
# Tk version: 4.2
# XF version: 4.0
#

  # build widget .ovalDialog
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .ovalDialog"
  } {
    catch "destroy .ovalDialog"
  }
  toplevel .ovalDialog 

  # Window manager configurations
  wm maxsize .ovalDialog 1009 738
  wm minsize .ovalDialog 1 1
  wm protocol .ovalDialog WM_DELETE_WINDOW {}
  wm title .ovalDialog {Insert an Oval}
  wm transient .ovalDialog .printLayout

  # build widget .ovalDialog.top
  frame .ovalDialog.top \
    -borderwidth {2}

  # build widget .ovalDialog.top.label2
  label .ovalDialog.top.label2 \
    -image {SmallFace}

  # build widget .ovalDialog.top.label3
  label .ovalDialog.top.label3 \
    -background {yellow} \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -foreground {brown} \
    -text {Insert an Oval}

  # build widget .ovalDialog.parameters
  frame .ovalDialog.parameters \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .ovalDialog.parameters.position1
  frame .ovalDialog.parameters.position1 \
    -borderwidth {2}

  # build widget .ovalDialog.parameters.position1.label18
  label .ovalDialog.parameters.position1.label18 \
    -text {X1:}

  # build widget .ovalDialog.parameters.position1.x
  entry .ovalDialog.parameters.position1.x

  # build widget .ovalDialog.parameters.position1.label20
  label .ovalDialog.parameters.position1.label20 \
    -text {Y1:}

  # build widget .ovalDialog.parameters.position1.y
  entry .ovalDialog.parameters.position1.y

  # build widget .ovalDialog.parameters.position2
  frame .ovalDialog.parameters.position2 \
    -borderwidth {2}

  # build widget .ovalDialog.parameters.position2.label18
  label .ovalDialog.parameters.position2.label18 \
    -text {X2:}

  # build widget .ovalDialog.parameters.position2.x
  entry .ovalDialog.parameters.position2.x

  # build widget .ovalDialog.parameters.position2.label20
  label .ovalDialog.parameters.position2.label20 \
    -text {Y2:}

  # build widget .ovalDialog.parameters.position2.y
  entry .ovalDialog.parameters.position2.y

  # build widget .ovalDialog.parameters.color
  frame .ovalDialog.parameters.color \
    -borderwidth {2}

  # build widget .ovalDialog.parameters.color.label25
  label .ovalDialog.parameters.color.label25 \
    -text {Color:}

  # build widget .ovalDialog.parameters.color.value
  entry .ovalDialog.parameters.color.value

  # build widget .ovalDialog.parameters.color.button27
  button .ovalDialog.parameters.color.button27 \
    -command {set newColor "[tk_chooseColor -title {Select A Color} -initialcolor [.ovalDialog.parameters.color.value get]]"
if {[string length "$newColor"] > 0} {
  .ovalDialog.parameters.color.value delete 0 end
  .ovalDialog.parameters.color.value insert end "$newColor"
}} \
    -padx {9} \
    -pady {3} \
    -text {Browse}

  # build widget .ovalDialog.parameters.thickness
  frame .ovalDialog.parameters.thickness \
    -borderwidth {2}

  # build widget .ovalDialog.parameters.thickness.label5
  label .ovalDialog.parameters.thickness.label5 \
    -text {Line Width:}

  # build widget .ovalDialog.parameters.thickness.thkOpt
  tk_optionMenu .ovalDialog.parameters.thickness.thkOpt ovalDialog(Width) \
		1/16 1/8 3/16 1/4 5/16 3/8 7/16 1/2 9/16 5/8 11/16 3/4 13/16 \
		7/8 15/16 1 Other

  # build widget .ovalDialog.parameters.thickness.thickness
  entry .ovalDialog.parameters.thickness.thickness

  # build widget .ovalDialog.parameters.thickness.label6
  label .ovalDialog.parameters.thickness.label6 \
    -text {inches}

  # build widget .ovalDialog.frame2
  frame .ovalDialog.frame2 \
    -borderwidth {2}

  # build widget .ovalDialog.frame2.button15
  button .ovalDialog.frame2.button15 \
    -padx {9} \
    -pady {3} \
    -text {OK} \
    -command {
	global ovalDialog
        if {![CheckXtypeAndRange {X1} "[.ovalDialog.parameters.position1.x get]"]} {return}
        if {![CheckYtypeAndRange {Y1} "[.ovalDialog.parameters.position1.y get]"]} {return}
        if {![CheckXtypeAndRange {X2} "[.ovalDialog.parameters.position2.x get]"]} {return}
        if {![CheckYtypeAndRange {Y2} "[.ovalDialog.parameters.position2.y get]"]} {return}
	set color "[.ovalDialog.parameters.color.value get]"
	if {[catch [list winfo rgb . $color]]} {
	  hl_warning "Bad color spec: $color, try again"
	  return
	}
	if {[string compare "$ovalDialog(Width)" {Other}] == 0} {
	  set thk "[.ovalDialog.parameters.thickness.thickness get]"
	  if {[catch [list expr "double($thk)"] v]} {
	    hl_warning "Not a number (Line Width): $thk, try again"
	    return
	  } elseif {$v <= 0} {
	    hl_warning "Zero or negative Line Width: $v, try again"
	    return
	  }
	}
	set ovalDialog(button) 1
    }

  # build widget .ovalDialog.frame2.button16
  button .ovalDialog.frame2.button16 \
    -padx {9} \
    -pady {3} \
    -text {Cancel} \
    -command {
	global ovalDialog
	set ovalDialog(button) 0
    }

  # build widget .ovalDialog.frame2.button17
  button .ovalDialog.frame2.button17 \
    -padx {9} \
    -pady {3} \
    -text {Help} \
    -command {hl_Help {Oval Dialog Help}}

  # pack master .ovalDialog.top
  pack configure .ovalDialog.top.label2 \
    -fill y \
    -side left
  pack configure .ovalDialog.top.label3 \
    -expand 1 \
    -fill x \
    -side right

  # pack master .ovalDialog.parameters
  pack configure .ovalDialog.parameters.color \
    -expand 1 \
    -fill x
  pack configure .ovalDialog.parameters.position1 \
    -expand 1 \
    -fill x
  pack configure .ovalDialog.parameters.position2 \
    -expand 1 \
    -fill x
  pack configure .ovalDialog.parameters.thickness \
    -expand 1 \
    -fill x

  # pack master .ovalDialog.parameters.position1
  pack configure .ovalDialog.parameters.position1.label18 \
    -side left
  pack configure .ovalDialog.parameters.position1.x \
    -expand 1 \
    -fill x \
    -side left
  pack configure .ovalDialog.parameters.position1.label20 \
    -side left
  pack configure .ovalDialog.parameters.position1.y \
    -expand 1 \
    -fill x \
    -side left

  # pack master .ovalDialog.parameters.position2
  pack configure .ovalDialog.parameters.position2.label18 \
    -side left
  pack configure .ovalDialog.parameters.position2.x \
    -expand 1 \
    -fill x \
    -side left
  pack configure .ovalDialog.parameters.position2.label20 \
    -side left
  pack configure .ovalDialog.parameters.position2.y \
    -expand 1 \
    -fill x \
    -side left

  # pack master .ovalDialog.parameters.color
  pack configure .ovalDialog.parameters.color.label25 \
    -side left
  pack configure .ovalDialog.parameters.color.value \
    -expand 1 \
    -fill x \
    -side left
  pack configure .ovalDialog.parameters.color.button27 \
    -side right

  # pack master .ovalDialog.parameters.thickness
  pack configure .ovalDialog.parameters.thickness.label5 \
    -side left
  pack configure .ovalDialog.parameters.thickness.thkOpt \
    -side left
  pack configure .ovalDialog.parameters.thickness.thickness \
    -expand 1 \
    -fill x \
    -side left
  pack configure .ovalDialog.parameters.thickness.label6 \
    -side right
    

  # pack master .ovalDialog.frame2
  pack configure .ovalDialog.frame2.button15 \
    -expand 1 \
    -side left
  pack configure .ovalDialog.frame2.button16 \
    -expand 1 \
    -side left
  pack configure .ovalDialog.frame2.button17 \
    -expand 1 \
    -side right

  # pack master .ovalDialog
  pack configure .ovalDialog.top \
    -fill x
  pack configure .ovalDialog.parameters \
    -expand 1 \
    -fill both
  pack configure .ovalDialog.frame2 \
    -expand 1 \
    -fill x

  global printLayout
  if {[llength "$oldItem"] == 0} {
    .ovalDialog.parameters.position1.x insert end {0}
    .ovalDialog.parameters.position1.y insert end {0}
    .ovalDialog.parameters.position2.x insert end {0}
    .ovalDialog.parameters.position2.y insert end {0}
    .ovalDialog.parameters.color.value insert end {black}
    .ovalDialog.parameters.thickness.thickness insert end {0.0625}
    set ovalDialog(Width) 1/16
  } else {
    .ovalDialog.parameters.position1.x insert end "[lindex [LAssoc :X1 $oldItem] 0]"
    .ovalDialog.parameters.position1.y insert end "[lindex [LAssoc :Y1 $oldItem] 0]"
    .ovalDialog.parameters.position2.x insert end "[lindex [LAssoc :X2 $oldItem] 0]"
    .ovalDialog.parameters.position2.y insert end "[lindex [LAssoc :Y2 $oldItem] 0]"
    .ovalDialog.parameters.color.value insert end "[lindex [LAssoc :Color $oldItem] 1]"
    .ovalDialog.parameters.thickness.thickness insert end "[lindex [LAssoc :THK $oldItem] 0]"
    set thk [expr int([lindex [LAssoc :THK $oldItem] 0] * 16)]
    switch -exact $thk {
      1 {
	  set ovalDialog(Width) 1/16
      }
      2 {
	  set ovalDialog(Width) 1/8
      }
      3 {
	  set ovalDialog(Width) 3/16
      }
      4 {
	  set ovalDialog(Width) 1/4
      }
      5 {
	  set ovalDialog(Width) 5/16
      }
      6 {
	  set ovalDialog(Width) 3/8
      }
      7 {
	  set ovalDialog(Width) 7/16
      }
      8 {
	  set ovalDialog(Width) 1/2
      }
      9 {
	  set ovalDialog(Width) 9/16
      }
      10 {
	  set ovalDialog(Width) 5/8
      }
      11 {
	  set ovalDialog(Width) 11/16
      }
      12 {
	  set ovalDialog(Width) 3/4
      }
      13 {
	  set ovalDialog(Width) 13/16
      }
      14 {
	  set ovalDialog(Width) 7/8
      }
      15 {
	  set ovalDialog(Width) 15/16
      }
      16 {
	  set ovalDialog(Width) 1
      }
      default {
	  set ovalDialog(Width) Other
      }
    }
  }

# end of widget tree

  set oldFocus [focus]
  set oldGrab [grab current .ovalDialog]
  if {$oldGrab != ""} {
    set grabStatus [grab status $oldGrab]
  }
  grab .ovalDialog
  focus .ovalDialog
  tkwait variable ovalDialog(button)

  catch {focus $oldFocus}
  if {$oldGrab != ""} {
    if {$grabStatus == "global"} {
      grab -global $oldGrab
    } else {
      grab $oldGrab
    }
  }

  if {$ovalDialog(button) == 1} {
    global printLayout
    set TkColor [MakeTkColor "[.ovalDialog.parameters.color.value get]"]
    set PrinterColor [MakePrinterColor "[.ovalDialog.parameters.color.value get]"]
    set DX1 [.ovalDialog.parameters.position1.x get]i
    set X1 [.ovalDialog.parameters.position1.x get]
    set DY1 [.ovalDialog.parameters.position1.y get]i
    set Y1 [.ovalDialog.parameters.position1.y get]
    set DX2 [.ovalDialog.parameters.position2.x get]i
    set X2 [.ovalDialog.parameters.position2.x get]
    set DY2 [.ovalDialog.parameters.position2.y get]i
    set Y2 [.ovalDialog.parameters.position2.y get]
    if {[string compare "$ovalDialog(Width)" {Other}] == 0} {
      set thk "[.ovalDialog.parameters.thickness.thickness get]"
    } elseif {[string compare "$ovalDialog(Width)" {1}] == 0} {
      set thk 1
    } else {
      set ND [split $ovalDialog(Width) {/}]
      set thk [expr double([lindex $ND 0]) / double([lindex $ND 1])]
    }
    set dthk "$thk"
    append dthk {i}      
    set theItem [list :Type oval \
		      :Color [list $PrinterColor $TkColor]\
		      :X1 [list $X1 $DX1] :Y1 [list $Y1 $DY1]\
		      :X2 [list $X2 $DX2] :Y2 [list $Y2 $DY2]\
		      :THK [list $thk $dthk]]
    if {[llength "$oldItem"] != 0} {
      set indexTag [LAssoc :IndexTag $oldItem]
      set index [FindItemIndex $indexTag]
      set printLayout(ItemList) [lreplace "$printLayout(ItemList)" $index  $index [concat :IndexTag $indexTag "$theItem"]]
      catch ".printLayout.frame0.frame1.frame3.frame5.canvas8.sheet delete $indexTag"
    } else {
      set indexTag [GetNextUnusedIndexTag $printLayout(ItemList)]
      lappend printLayout(ItemList) [concat :IndexTag $indexTag "$theItem"]
    }
    set printLayout(Dirty) 1
    set printLayout(ScriptOutdated) 1
    .printLayout.bottomButtons.save config -state normal
    .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet create oval \
	$DX1 $DY1 $DX2 $DY2 -fill {} -outline "$TkColor" -width $dthk -tags $indexTag
    PrSetSelection $indexTag
    .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet bind $indexTag <1> "PrSetSelection $indexTag"
  }

  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .ovalDialog"
  } {
    catch "destroy .ovalDialog"
  }
}

proc FilledOvalDialog {{oldItem {}}} {
# Filled Oval insertion / edit dialog.
# [index] FilledOvalDialog!procedure

  global printLayout
  global filledOvalDialog
  set filledOvalDialog(oldItem) "$oldItem"
  set filledOvalDialog(button) -1

# .filledOvalDialog
# The above line makes pasting MUCH easier for me.
# It contains the pathname of the cutted widget.
# Tcl version: 7.6 (Tcl/Tk/XF)
# Tk version: 4.2
# XF version: 4.0
#

  # build widget .filledOvalDialog
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .filledOvalDialog"
  } {
    catch "destroy .filledOvalDialog"
  }
  toplevel .filledOvalDialog 

  # Window manager configurations
  wm maxsize .filledOvalDialog 1009 738
  wm minsize .filledOvalDialog 1 1
  wm protocol .filledOvalDialog WM_DELETE_WINDOW {}
  wm title .filledOvalDialog {Insert a Filled Oval}
  wm transient .filledOvalDialog .printLayout

  # build widget .filledOvalDialog.top
  frame .filledOvalDialog.top \
    -borderwidth {2}

  # build widget .filledOvalDialog.top.label2
  label .filledOvalDialog.top.label2 \
    -image {SmallFace}

  # build widget .filledOvalDialog.top.label3
  label .filledOvalDialog.top.label3 \
    -background {yellow} \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -foreground {brown} \
    -text {Insert a Filled Oval}

  # build widget .filledOvalDialog.parameters
  frame .filledOvalDialog.parameters \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .filledOvalDialog.parameters.position1
  frame .filledOvalDialog.parameters.position1 \
    -borderwidth {2}

  # build widget .filledOvalDialog.parameters.position1.label18
  label .filledOvalDialog.parameters.position1.label18 \
    -text {X1:}

  # build widget .filledOvalDialog.parameters.position1.x
  entry .filledOvalDialog.parameters.position1.x

  # build widget .filledOvalDialog.parameters.position1.label20
  label .filledOvalDialog.parameters.position1.label20 \
    -text {Y1:}

  # build widget .filledOvalDialog.parameters.position1.y
  entry .filledOvalDialog.parameters.position1.y

  # build widget .filledOvalDialog.parameters.position2
  frame .filledOvalDialog.parameters.position2 \
    -borderwidth {2}

  # build widget .filledOvalDialog.parameters.position2.label18
  label .filledOvalDialog.parameters.position2.label18 \
    -text {X2:}

  # build widget .filledOvalDialog.parameters.position2.x
  entry .filledOvalDialog.parameters.position2.x

  # build widget .filledOvalDialog.parameters.position2.label20
  label .filledOvalDialog.parameters.position2.label20 \
    -text {Y2:}

  # build widget .filledOvalDialog.parameters.position2.y
  entry .filledOvalDialog.parameters.position2.y

  # build widget .filledOvalDialog.parameters.color
  frame .filledOvalDialog.parameters.color \
    -borderwidth {2}

  # build widget .filledOvalDialog.parameters.color.label25
  label .filledOvalDialog.parameters.color.label25 \
    -text {Color:}

  # build widget .filledOvalDialog.parameters.color.value
  entry .filledOvalDialog.parameters.color.value

  # build widget .filledOvalDialog.parameters.color.button27
  button .filledOvalDialog.parameters.color.button27 \
    -command {set newColor "[tk_chooseColor -title {Select A Color} -initialcolor [.filledOvalDialog.parameters.color.value get]]"
if {[string length "$newColor"] > 0} {
  .filledOvalDialog.parameters.color.value delete 0 end
  .filledOvalDialog.parameters.color.value insert end "$newColor"
}} \
    -padx {9} \
    -pady {3} \
    -text {Browse}

  # build widget .filledOvalDialog.frame2
  frame .filledOvalDialog.frame2 \
    -borderwidth {2}

  # build widget .filledOvalDialog.frame2.button15
  button .filledOvalDialog.frame2.button15 \
    -padx {9} \
    -pady {3} \
    -text {OK} \
    -command {
	global filledOvalDialog
        if {![CheckXtypeAndRange {X1} "[.filledOvalDialog.parameters.position1.x get]"]} {return}
        if {![CheckYtypeAndRange {Y1} "[.filledOvalDialog.parameters.position1.y get]"]} {return}
        if {![CheckXtypeAndRange {X2} "[.filledOvalDialog.parameters.position2.x get]"]} {return}
        if {![CheckYtypeAndRange {Y2} "[.filledOvalDialog.parameters.position2.y get]"]} {return}
	set color "[.filledOvalDialog.parameters.color.value get]"
	if {[catch [list winfo rgb . $color]]} {
	  hl_warning "Bad color spec: $color, try again"
	  return
	}
	set filledOvalDialog(button) 1
    }

  # build widget .filledOvalDialog.frame2.button16
  button .filledOvalDialog.frame2.button16 \
    -padx {9} \
    -pady {3} \
    -text {Cancel} \
    -command {
	global filledOvalDialog
	set filledOvalDialog(button) 0
    }

  # build widget .filledOvalDialog.frame2.button17
  button .filledOvalDialog.frame2.button17 \
    -padx {9} \
    -pady {3} \
    -text {Help} \
    -command {hl_Help {Filled Oval Dialog Help}}

  # pack master .filledOvalDialog.top
  pack configure .filledOvalDialog.top.label2 \
    -fill y \
    -side left
  pack configure .filledOvalDialog.top.label3 \
    -expand 1 \
    -fill x \
    -side right

  # pack master .filledOvalDialog.parameters
  pack configure .filledOvalDialog.parameters.color \
    -expand 1 \
    -fill x
  pack configure .filledOvalDialog.parameters.position1 \
    -expand 1 \
    -fill x
  pack configure .filledOvalDialog.parameters.position2 \
    -expand 1 \
    -fill x

  # pack master .filledOvalDialog.parameters.position1
  pack configure .filledOvalDialog.parameters.position1.label18 \
    -side left
  pack configure .filledOvalDialog.parameters.position1.x \
    -expand 1 \
    -fill x \
    -side left
  pack configure .filledOvalDialog.parameters.position1.label20 \
    -side left
  pack configure .filledOvalDialog.parameters.position1.y \
    -expand 1 \
    -fill x \
    -side left

  # pack master .filledOvalDialog.parameters.position2
  pack configure .filledOvalDialog.parameters.position2.label18 \
    -side left
  pack configure .filledOvalDialog.parameters.position2.x \
    -expand 1 \
    -fill x \
    -side left
  pack configure .filledOvalDialog.parameters.position2.label20 \
    -side left
  pack configure .filledOvalDialog.parameters.position2.y \
    -expand 1 \
    -fill x \
    -side left

  # pack master .filledOvalDialog.parameters.color
  pack configure .filledOvalDialog.parameters.color.label25 \
    -side left
  pack configure .filledOvalDialog.parameters.color.value \
    -expand 1 \
    -fill x \
    -side left
  pack configure .filledOvalDialog.parameters.color.button27 \
    -side right

  # pack master .filledOvalDialog.frame2
  pack configure .filledOvalDialog.frame2.button15 \
    -expand 1 \
    -side left
  pack configure .filledOvalDialog.frame2.button16 \
    -expand 1 \
    -side left
  pack configure .filledOvalDialog.frame2.button17 \
    -expand 1 \
    -side right

  # pack master .filledOvalDialog
  pack configure .filledOvalDialog.top \
    -fill x
  pack configure .filledOvalDialog.parameters \
    -expand 1 \
    -fill both
  pack configure .filledOvalDialog.frame2 \
    -expand 1 \
    -fill x

  global printLayout
  if {[llength "$oldItem"] == 0} {
    .filledOvalDialog.parameters.position1.x insert end {0}
    .filledOvalDialog.parameters.position1.y insert end {0}
    .filledOvalDialog.parameters.position2.x insert end {0}
    .filledOvalDialog.parameters.position2.y insert end {0}
    .filledOvalDialog.parameters.color.value insert end {black}
  } else {
    .filledOvalDialog.parameters.position1.x insert end "[lindex [LAssoc :X1 $oldItem] 0]"
    .filledOvalDialog.parameters.position1.y insert end "[lindex [LAssoc :Y1 $oldItem] 0]"
    .filledOvalDialog.parameters.position2.x insert end "[lindex [LAssoc :X2 $oldItem] 0]"
    .filledOvalDialog.parameters.position2.y insert end "[lindex [LAssoc :Y2 $oldItem] 0]"
    .filledOvalDialog.parameters.color.value insert end "[lindex [LAssoc :Color $oldItem] 1]"
  }

# end of widget tree

  set oldFocus [focus]
  set oldGrab [grab current .filledOvalDialog]
  if {$oldGrab != ""} {
    set grabStatus [grab status $oldGrab]
  }
  grab .filledOvalDialog
  focus .filledOvalDialog
  tkwait variable filledOvalDialog(button)

  catch {focus $oldFocus}
  if {$oldGrab != ""} {
    if {$grabStatus == "global"} {
      grab -global $oldGrab
    } else {
      grab $oldGrab
    }
  }

  if {$filledOvalDialog(button) == 1} {
    global printLayout
    set TkColor [MakeTkColor "[.filledOvalDialog.parameters.color.value get]"]
    set PrinterColor [MakePrinterColor "[.filledOvalDialog.parameters.color.value get]"]
    set DX1 [.filledOvalDialog.parameters.position1.x get]i
    set X1 [.filledOvalDialog.parameters.position1.x get]
    set DY1 [.filledOvalDialog.parameters.position1.y get]i
    set Y1 [.filledOvalDialog.parameters.position1.y get]
    set DX2 [.filledOvalDialog.parameters.position2.x get]i
    set X2 [.filledOvalDialog.parameters.position2.x get]
    set DY2 [.filledOvalDialog.parameters.position2.y get]i
    set Y2 [.filledOvalDialog.parameters.position2.y get]
    set theItem [list :Type filledoval \
		      :Color [list $PrinterColor $TkColor]\
		      :X1 [list $X1 $DX1] :Y1 [list $Y1 $DY1]\
		      :X2 [list $X2 $DX2] :Y2 [list $Y2 $DY2]]
    if {[llength "$oldItem"] != 0} {
      set indexTag [LAssoc :IndexTag $oldItem]
      set index [FindItemIndex $indexTag]
      set printLayout(ItemList) [lreplace "$printLayout(ItemList)" $index  $index [concat :IndexTag $indexTag "$theItem"]]
      catch ".printLayout.frame0.frame1.frame3.frame5.canvas8.sheet delete $indexTag"
    } else {
      set indexTag [GetNextUnusedIndexTag $printLayout(ItemList)]
      lappend printLayout(ItemList) [concat :IndexTag $indexTag "$theItem"]
    }
    set printLayout(Dirty) 1
    set printLayout(ScriptOutdated) 1
    .printLayout.bottomButtons.save config -state normal
    .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet create oval \
	$DX1 $DY1 $DX2 $DY2 -fill "$TkColor" -width 0 -outline {} -tags $indexTag
    PrSetSelection $indexTag
    .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet bind $indexTag <1> "PrSetSelection $indexTag"
  }

  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .filledOvalDialog"
  } {
    catch "destroy .filledOvalDialog"
  }
}

proc ImageDialog {{oldItem {}}} {
# Image insertion / edit dialog.
# [index] ImageDialog!procedure

  global printLayout
  global imageDialog
  set imageDialog(oldItem) "$oldItem"
  set imageDialog(button) -1

# .imageDialog
# The above line makes pasting MUCH easier for me.
# It contains the pathname of the cutted widget.
# Tcl version: 7.6 (Tcl/Tk/XF)
# Tk version: 4.2
# XF version: 4.0
#

  # build widget .imageDialog
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .imageDialog"
  } {
    catch "destroy .imageDialog"
  }
  toplevel .imageDialog 

  # Window manager configurations
  wm positionfrom .imageDialog ""
  wm sizefrom .imageDialog ""
  wm maxsize .imageDialog 1009 738
  wm minsize .imageDialog 1 1
  wm protocol .imageDialog WM_DELETE_WINDOW {}
  wm title .imageDialog {Insert an Image}
  wm transient .imageDialog .printLayout


  # build widget .imageDialog.top
  frame .imageDialog.top \
    -borderwidth {2}

  # build widget .imageDialog.top.label2
  label .imageDialog.top.label2 \
    -image {SmallFace}

  # build widget .imageDialog.top.label3
  label .imageDialog.top.label3 \
    -background {yellow} \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -foreground {brown} \
    -text {Insert an Image}

  # build widget .imageDialog.parameters
  frame .imageDialog.parameters \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .imageDialog.parameters.color
  frame .imageDialog.parameters.color \
    -borderwidth {2}

  # build widget .imageDialog.parameters.color.label25
  label .imageDialog.parameters.color.label25 \
    -text {Color:}

  # build widget .imageDialog.parameters.color.value
  entry .imageDialog.parameters.color.value
  
  # build widget .imageDialog.parameters.color.button27
  button .imageDialog.parameters.color.button27 \
    -command {set newColor "[tk_chooseColor -title {Select A Color} -initialcolor [.imageDialog.parameters.color.value get]]"
if {[string length "$newColor"] > 0} {
  .imageDialog.parameters.color.value delete 0 end
  .imageDialog.parameters.color.value insert end "$newColor"
}} \
    -padx {9} \
    -pady {3} \
    -text {Browse}
  
  # build widget .imageDialog.parameters.position1
  frame .imageDialog.parameters.position1 \
    -borderwidth {2}

  # build widget .imageDialog.parameters.position1.label4
  label .imageDialog.parameters.position1.label4 \
    -text {X1:}

  # build widget .imageDialog.parameters.position1.x
  entry .imageDialog.parameters.position1.x \
    -width {0}

  # build widget .imageDialog.parameters.position1.label6
  label .imageDialog.parameters.position1.label6 \
    -text {Y1:}

  # build widget .imageDialog.parameters.position1.y
  entry .imageDialog.parameters.position1.y \
    -width {0}

  # build widget .imageDialog.parameters.position2
  frame .imageDialog.parameters.position2 \
    -borderwidth {2}

  # build widget .imageDialog.parameters.position2.label4
  label .imageDialog.parameters.position2.label4 \
    -text {X2:}

  # build widget .imageDialog.parameters.position2.x
  entry .imageDialog.parameters.position2.x \
    -width {0}

  # build widget .imageDialog.parameters.position2.label6
  label .imageDialog.parameters.position2.label6 \
    -text {Y2:}

  # build widget .imageDialog.parameters.position2.y
  entry .imageDialog.parameters.position2.y \
    -width {0}

  # build widget .imageDialog.parameters.bitmap
  frame .imageDialog.parameters.bitmap \
    -borderwidth {2}

  # build widget .imageDialog.parameters.bitmap.label10
  label .imageDialog.parameters.bitmap.label10 \
    -text {Bitmap:}
  
  # build widget .imageDialog.parameters.bitmap.bmOpt
  global tk_version
  global tcl_platform
  if {$tk_version >= 8.0 && "$tcl_platform(platform)" == {macintosh}} {
    tk_optionMenu .imageDialog.parameters.bitmap.bmOpt imageDialog(BMOpt) \
	error gray75 gray50 gray25 gray12 hourglass info \
	questhead question warning document stationery edition \
	application accessory folder pfolder trash floppy \
	ramdisk cdrom preferences querydoc stop note \
	caution {@}
  } elseif {$tk_version >= 8.0} {
    tk_optionMenu .imageDialog.parameters.bitmap.bmOpt imageDialog(BMOpt) \
	error gray75 gray50 gray25 gray12 hourglass info \
	questhead question warning {@}
  } else {
    tk_optionMenu .imageDialog.parameters.bitmap.bmOpt imageDialog(BMOpt) \
	error gray50 gray12 hourglass info \
	questhead question warning {@}
  }
  set imageDialog(BMOpt) info
  
  # build widget .imageDialog.parameters.bitmap.bmfilename
  entry .imageDialog.parameters.bitmap.bmfilename \
    -width {0}

  # build widget .imageDialog.parameters.bitmap.button13
  button .imageDialog.parameters.bitmap.button13 \
    -command {set fm [tk_getOpenFile -defaultextension {.xbm}  -initialfile "[.imageDialog.parameters.bitmap.bmfilename get]"  -filetypes {{{X11 Bitmap Files} {.xbm} TEXT}}  -title {Select a bitmap file}]
if {[string length "$fm"] > 0} {
   .imageDialog.parameters.bitmap.bmfilename delete 0 end
   .imageDialog.parameters.bitmap.bmfilename insert enf "$fm"
   global imageDialog
   set imageDialog(BMOpt) {@}
}} \
    -padx {9} \
    -pady {3} \
    -text {Browse}
  
  # build widget .imageDialog.frame2
  frame .imageDialog.frame2 \
    -borderwidth {2}

  # build widget .imageDialog.frame2.button14
  button .imageDialog.frame2.button14 \
    -padx {9} \
    -pady {3} \
    -text {OK} \
    -command {
	global imageDialog
	if {![CheckXtypeAndRange {X1} "[.imageDialog.parameters.position1.x get]"]} {return}
        if {![CheckYtypeAndRange {Y1} "[.imageDialog.parameters.position1.y get]"]} {return}
        if {![CheckXtypeAndRange {X2} "[.imageDialog.parameters.position2.x get]"]} {return}
        if {![CheckYtypeAndRange {Y2} "[.imageDialog.parameters.position2.y get]"]} {return}
	set color "[.imageDialog.parameters.color.value get]"
	if {[catch [list winfo rgb . $color]]} {
	  hl_warning "Bad color spec: $color, try again"
	  return
	}
	if {[string compare "$imageDialog(BMOpt)" {@}] == 0} {
	  if {![CheckBMFile "[.imageDialog.parameters.bitmap.bmfilename get]"]} {return}
	}
	set imageDialog(button) 1
    }
  
  # build widget .imageDialog.frame2.button15
  button .imageDialog.frame2.button15 \
    -padx {9} \
    -pady {3} \
    -text {Cancel} \
    -command {
	global imageDialog
	set imageDialog(button) 0
    }

  # build widget .imageDialog.frame2.button16
  button .imageDialog.frame2.button16 \
    -padx {9} \
    -pady {3} \
    -text {button16}

  # build widget .imageDialog.frame2.button17
  button .imageDialog.frame2.button17 \
    -padx {9} \
    -pady {3} \
    -text {Help} \
    -command {hl_Help {Image Dialog Help}}

  # pack master .imageDialog.top
  pack configure .imageDialog.top.label2 \
    -fill y \
    -side left
  pack configure .imageDialog.top.label3 \
    -expand 1 \
    -fill x \
    -side right

  # pack master .imageDialog.parameters
  pack configure .imageDialog.parameters.color \
    -expand 1 \
    -fill x
  pack configure .imageDialog.parameters.position1 \
    -fill x
  pack configure .imageDialog.parameters.position2 \
    -fill x
  pack configure .imageDialog.parameters.bitmap \
    -fill x

  # pack master .imageDialog.parameters.color
  pack configure .imageDialog.parameters.color.label25 \
    -side left
  pack configure .imageDialog.parameters.color.value \
    -expand 1 \
    -fill x \
    -side left
  pack configure .imageDialog.parameters.color.button27 \
    -side right

  # pack master .imageDialog.parameters.position1
  pack configure .imageDialog.parameters.position1.label4 \
    -side left
  pack configure .imageDialog.parameters.position1.x \
    -expand 1 \
    -fill x \
    -side left
  pack configure .imageDialog.parameters.position1.label6 \
    -side left
  pack configure .imageDialog.parameters.position1.y \
    -expand 1 \
    -fill x \
    -side left

  # pack master .imageDialog.parameters.position2
  pack configure .imageDialog.parameters.position2.label4 \
    -side left
  pack configure .imageDialog.parameters.position2.x \
    -expand 1 \
    -fill x \
    -side left
  pack configure .imageDialog.parameters.position2.label6 \
    -side left
  pack configure .imageDialog.parameters.position2.y \
    -expand 1 \
    -fill x \
    -side left

  # pack master .imageDialog.parameters.bitmap
  pack configure .imageDialog.parameters.bitmap.label10 \
    -side left
  pack configure .imageDialog.parameters.bitmap.bmOpt \
    -side left
  pack configure .imageDialog.parameters.bitmap.bmfilename \
    -expand 1 \
    -fill x \
    -side left
  pack configure .imageDialog.parameters.bitmap.button13 \
    -side left

  # pack master .imageDialog.frame2
  pack configure .imageDialog.frame2.button14 \
    -expand 1 \
    -side left
  pack configure .imageDialog.frame2.button15 \
    -expand 1 \
    -side left
  pack configure .imageDialog.frame2.button17 \
    -expand 1 \
    -side right

  # pack master .imageDialog
  pack configure .imageDialog.top \
    -fill x
  pack configure .imageDialog.parameters
  pack configure .imageDialog.frame2 \
    -fill x
  
  global printLayout
  if {[llength "$oldItem"] == 0} {
    .imageDialog.parameters.color.value insert end {black}
    .imageDialog.parameters.position1.x insert end {0}
    .imageDialog.parameters.position1.y insert end {0}
    .imageDialog.parameters.position2.x insert end {0}
    .imageDialog.parameters.position2.y insert end {0}
    .imageDialog.parameters.bitmap.bmfilename insert end {}
    set imageDialog(BMOpt) info
  } else {
    .imageDialog.parameters.position1.x insert end "[lindex [LAssoc :X1 $oldItem] 0]"
    .imageDialog.parameters.position1.y insert end "[lindex [LAssoc :Y1 $oldItem] 0]"
    .imageDialog.parameters.position2.x insert end "[lindex [LAssoc :X2 $oldItem] 0]"
    .imageDialog.parameters.position2.y insert end "[lindex [LAssoc :Y2 $oldItem] 0]"
    .imageDialog.parameters.color.value insert end "[lindex [LAssoc :Color $oldItem] 1]"
    set bm "[lindex [LAssoc :Bitmap $oldItem] 0]"
    if {[string compare "[string index $bm 0]" {@}] == 0} {
      set imageDialog(BMOpt) {@}
      .imageDialog.parameters.bitmap.bmfilename insert end "[string range $bm 1 end]"
    } else {
      set imageDialog(BMOpt) "$bm"
    }
  }
# end of widget tree

  set oldFocus [focus]
  set oldGrab [grab current .imageDialog]
  if {$oldGrab != ""} {
    set grabStatus [grab status $oldGrab]
  }
  
  grab .imageDialog
  focus .imageDialog
  set imageDialog(button) -1
  tkwait variable imageDialog(button)

  catch {focus $oldFocus}
  if {$oldGrab != ""} {
    if {$grabStatus == "global"} {
      grab -global $oldGrab
    } else {
      grab $oldGrab
    }
  }
  
  if {$imageDialog(button) == 1} {
    global printLayout
    global imageDialog
    set TkColor [MakeTkColor "[.imageDialog.parameters.color.value get]"]
    set PrinterColor [MakePrinterColor "[.imageDialog.parameters.color.value get]"]
    set DX1 [.imageDialog.parameters.position1.x get]i
    set X1 [.imageDialog.parameters.position1.x get]
    set DY1 [.imageDialog.parameters.position1.y get]i
    set Y1 [.imageDialog.parameters.position1.y get]
    set DX2 [.imageDialog.parameters.position2.x get]i
    set X2 [.imageDialog.parameters.position2.x get]
    set DY2 [.imageDialog.parameters.position2.y get]i
    set Y2 [.imageDialog.parameters.position2.y get]
    if {[string compare "$imageDialog(BMOpt)" {@}] == 0} {
      set BM "@[.imageDialog.parameters.bitmap.bmfilename get]"
    } else {
      set BM "$imageDialog(BMOpt)"
    }
    set theItem [list :Type image \
		      :Color [list $PrinterColor $TkColor]\
		      :X1 [list $X1 $DX1] :Y1 [list $Y1 $DY1]\
		      :X2 [list $X2 $DX2] :Y2 [list $Y2 $DY2]\
		      :Bitmap [list $BM $BM]]
    if {[llength "$oldItem"] != 0} {
      set indexTag [LAssoc :IndexTag $oldItem]
      set index [FindItemIndex $indexTag]
      set printLayout(ItemList) [lreplace "$printLayout(ItemList)" $index  $index [concat :IndexTag $indexTag "$theItem"]]
      catch ".printLayout.frame0.frame1.frame3.frame5.canvas8.sheet delete $indexTag"
    } else {
      set indexTag [GetNextUnusedIndexTag $printLayout(ItemList)]
      lappend printLayout(ItemList) [concat :IndexTag $indexTag "$theItem"]
    }

    set printLayout(Dirty) 1
    set printLayout(ScriptOutdated) 1
    .printLayout.bottomButtons.save config -state normal
    .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet create bitmap $DX1 $DY1 \
		-anchor nw -foreground "$TkColor" -bitmap "$BM" \
		-tags $indexTag
    .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet create rectangle \
		$DX1 $DY1 $DX2 $DY2 -fill {} -width 1 -outline black \
		-tags $indexTag
    PrSetSelection $indexTag
    .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet bind $indexTag <1> "PrSetSelection $indexTag"
  }
  

  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .imageDialog"
  } {
    catch "destroy .imageDialog"
  }
}




proc PrRemoveItem {} {
# Remove item.
# [index] PrRemoveItem!procedure

  global printLayout
  if {[string length "$printLayout(SelectedItem)"] == 0} {
    PrDeselectItem
    return
  }
  set newItemList {}
  foreach item $printLayout(ItemList) {
    if {[string compare "[LAssoc :IndexTag $item]" "$printLayout(SelectedItem)"] != 0} {
      lappend newItemList "$item"
    }
  }
  catch [list .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet delete "$printLayout(SelectedItem)"]
  PrDeselectItem
  set printLayout(Dirty) 1
  .printLayout.bottomButtons.save config -state normal
  set printLayout(ScriptOutdated) 1
}

proc PrEditItem {} {
# Edit Item.
# [index] PrEditItem!procedure

  global printLayout
  if {[string length "$printLayout(SelectedItem)"] == 0} {
    PrDeselectItem
    return
  }

  set item "[FindItem $printLayout(SelectedItem)]"
  if {[string length "$item"] == 0} {
    PrDeselectItem
    return
  }
  switch -exact [LAssoc :Type $item] {
    textat {TextAtDialog "$item"}
    textinbbox {TextInBBoxDialog "$item"}
    line {LineDialog "$item"}
    rectangle {RectangleDialog "$item"}
    filledrectangle {FilledRectangleDialog "$item"}
    oval {OvalDialog "$item"}
    filledoval {FilledOvalDialog "$item"}
    image {ImageDialog "$item"}
    default {}
  }
}

proc FindItem {indexTag} {
# Find item, given its index tag.
# [index] FindItem!procedure

  global printLayout
  foreach item $printLayout(ItemList) {
    if {[string compare "[LAssoc :IndexTag $item]" "$indexTag"] == 0} {
      return "$item"
    }
  }
  return {}
}

proc FindItemIndex {indexTag} {
# Find item index, given its index tag.
# [index] FindItemIndex!procedure

  global printLayout
  set i -1
  foreach item $printLayout(ItemList) {
    incr i
    if {[string compare "[LAssoc :IndexTag $item]" "$indexTag"] == 0} {
      return $i
    }
  }
  return [llength $printLayout(ItemList)]
}


proc PrDeselectItem {} {
# Deselect item.
# [index] PrDeselectItem!procedure

  global printLayout
  catch {.printLayout.frame0.frame1.frame3.frame5.canvas8.sheet delete SelectBox}
  set printLayout(SelectedItem) {}
  .printLayout.frame0.frame3.remove config -state disabled
  .printLayout.frame0.frame3.edit config -state disabled
  .printLayout.frame0.frame3.deselect config -state disabled
}

proc GetNextUnusedIndexTag {itemList} {
# Generate an unused index tag.
# [index] GetNextUnusedIndexTag!procedure

  set used {}
  foreach i $itemList {
    if {[regexp {Index([0-9]*)$} "[LAssoc :IndexTag $i]" whole un] > 0} {
      lappend used $un
    }
  }
  set i 1
  foreach u [lsort -integer $used] {
    if {$u == $i} {
      incr i
    } else {
      return "Index$i"
    }
  }
  return "Index$i"
}

proc MakeTkFont {name weight slant size} {
# Build a Tk font object.
# [index] MakeTkFont!procedure

  if {[catch "expr double($size)"]} {set size 0.167}
  return "[FindFont $name $weight $slant $size]"
}

proc MakePrinterFont {name weight slant size} {
# Build a printer font object.
# [index] MakePrinterFont!procedure

  if {[catch "expr double($size)"]} {set size 0.167}
  global tcl_platform
  if {$tcl_platform(platform) == "unix"} {
    switch -exact $name {
      courier {
	if {"$slant" == "italic"} {
	  if {"$weight" == "bold"} {
	    set PName {Courier-BoldItalic}
	  } else {
	    set PName {Courier-Italic}
	  }
	} else {
	  if {"$weight" == "bold"} {
	    set PName {Courier-Bold}
	  } else {
	    set PName {Courier}
	  }
	}
      }
      helvetica {
	if {"$slant" == "italic"} {
	  if {"$weight" == "bold"} {
	    set PName {Helvetica-BoldOblique}
	  } else {
	    set PName {Helvetica-Oblique}
	  }
	} else {
	  if {"$weight" == "bold"} {
	    set PName {Helvetica-Bold}
	  } else {
	    set PName {Helvetica}
	  }
	}
      }
      {new century schoolbook} {
	if {"$slant" == "italic"} {
	  if {"$weight" == "bold"} {
	    set PName {NewCenturySchlbk-BoldItalic}
	  } else {
	    set PName {NewCenturySchlbk-Italic}
	  }
	} else {
	  if {"$weight" == "bold"} {
	    set PName {NewCenturySchlbk-Bold}
	  } else {
	    set PName {NewCenturySchlbk-Roman}
	  }
	}
      }
      times {
	if {"$slant" == "italic"} {
	  if {"$weight" == "bold"} {
	    set PName {Times-BoldItalic}
	  } else {
	    set PName {Times-Italic}
	  }
	} else {
	  if {"$weight" == "bold"} {
	    set PName {Timesr-Bold}
	  } else {
	    set PName {Times-Roman}
	  }
	}
      }
      utopia {
	if {"$slant" == "italic"} {
	  if {"$weight" == "bold"} {
	    set PName {Utopia-BoldItalic}
	  } else {
	    set PName {Utopia-Italic}
	  }
	} else {
	  if {"$weight" == "bold"} {
	    set PName {Utopia-Bold}
	  } else {
	    set PName {Utopia-Regular}
	  }
	}
      }
    }
    return [list $PName $size]
  } else {
    set TkFn [FindFont $name $weight $slant $size]
    set name "[LAssoc -family $TkFn] [LAssoc -weight $TkFn] [LAssoc -slant $TkFn]"
    return [list "$name" $size]
  }
}

proc LAssoc {key list} {
# Get an item from an association list.
# [index] LAssoc!procedure

  set index [expr 1 + [lsearch -exact $list $key]]
  if {$index == 0} {return {}}
  return [lindex $list $index]
}

proc MakeTkColor {cn} {
# Make a Tk color name.
# [index] MakeTkColor!procedure

  if {[catch [list winfo rgb . "$cn"]]} {
    return {black}
  } else {
    return "$cn"
  }
}

proc MakePrinterColor {cn} {
# Make a printer color list.
# [index] MakePrinterColor!procedure

  if {[catch [list winfo rgb . "$cn"] rgb]} {
    return [list 0.0 0.0 0.0]
  } else {
    return [list [expr [lindex $rgb 0] / 65535.0] \
	         [expr [lindex $rgb 1] / 65535.0] \
		 [expr [lindex $rgb 2] / 65535.0]]
  }
}

proc ParseText {text} {
# Parse a text item, replacing ``%'' keys with code to fetch the specified
# values.
# [index] ParseText!procedure

  set result {}
  for {set per [string first {%} "$text"]} \
	{$per >= 0} {set per [string first {%} "$text"]} {
    set b [expr $per - 1]
    set a [expr $per + 1]
    append result "[string range $text 0 $b]"
    set t1 "[string range $text $a end]"
    if {[string compare "[string index $t1 0]" {%}] == 0} {
      append result {%}
      set text "[string range $t1 1 end]"
    } elseif {[regexp {^([a-zA-Z]+)(.*)$} "$t1" whole key t2] > 0} {
      switch -exact $key {
	heading {append result {$heading}}
	id {append result {$id}}
	cardtype {append result {[FetchTypeName [$record cardtype]]}}
	author {append result {[$record author]}}
	title {append result {[$record title]}}
	publisher {append result {[$record publisher]}}
	city {append result {[$record city]}}
	description {append result {[$record description]}}
	vol {append result {[$record vol]}}
	year {append result {[$record year]}}
	locationtype {append result {[FetchLTypeName [$record locationtype]]}}
	locationdetail {append result {[$record locationdetail]}}
	category {append result {[FetchCategory [$record categorycode]]}}
	subjects {append result {[FetchSubjects $id]}}
	authors {append result {[FetchAuthors $id]}}
	titles {append result {[FetchTitles $id]}}
	default {append result {UNKNOWNKEY}}
      }
      set text "$t2"
    }
  }
  return "$result$text"
}

proc FindFont {name weight slant size} {
# Lookup and generate a font spec.
# [index] FindFont!procedure

  global tk_version
  if {$tk_version >= 8.0} {
    set newFont [font create -family $name  -weight $weight  -size [expr int($size * 72)]  -slant $slant]
    set actual "[font actual $newFont]"
    font delete $newFont
    return "$actual"
  } else {
    if {[string compare "$weight" {normal}] == 0} {set weight medium}
    if {[string compare "$slant" {roman}] == 0} {
      set slant {r}
    } elseif {[string compare "$slant" {italic}] == 0} {
      set slant {i}
    }
    if {"[info procs XFEdit]" != ""} {
      catch {XFDestroy .z______}
    } else {
      catch {destroy .z______}
    }
    canvas .z______
    if {$size < 0} {
      set XLFD [format {-*-%s-%s-%s-*-*-*-*-*-*-*-*-*-*} $name $weight $slant]
      if {[catch [list .z______ create text 0 0 -text {x} \
				-font $XLFD \
			  ] \
		   ]} {
	if {"$weight" != {*}} {
	  return "[FindFont $name {*} $slant $size]"
	} elseif {"$slant" != {*}} {
	  return "[FindFont $name $weight {*} $size]"
	} elseif {"$name" != {*}} {
	  return "[FindFont {*} $weight $slant $size]"
	} else {
	  return {-*-*-*-*-*-*-*-*-*-*-*-*-*-*}
	}
      } else {
	return "$XLFD"
      }
    }	  
    set p1 [expr 1.0 / 72.0]
    set s $size
    while {$s > 0} {
	set XLFD [format {-*-%s-%s-%s-*-*-*-%d0-*-*-*-*-*-*} \
			$name $weight $slant [expr int($s * 72)]]
	if {![catch [list .z______ create text 0 0 -text {x} \
				-font $XLFD]]} {break}
	set s [expr $s - $p1]
    }
    if {"[info procs XFEdit]" != ""} {
      catch {XFDestroy .z______}
    } else {
      catch {destroy .z______}
    }
    if {$s <= 0} {
      if {"$weight" != {*}} {
	set XLFD "[FindFont $name {*} $slant $size]"
	if {"$XLFD" == {}} {
	  return "[FindFont $name $weight $slant -1]"
	} else {
	  return "$XLFD"
	}
      } elseif {"$slant" != {*}} {
	return "[FindFont $name $weight {*} $size]"
      } elseif {"$name" != {*}} {
	return "[FindFont {*} $weight $slant $size]"
      } else {
	return {}
      }
    } else {
      return "$XLFD"
    }
  }
}

proc PrSetSelection {indexTag} {
# Set the ``selection'' to the item specified.
# [index] PrSetSelection!procedure

  global printLayout
  catch {.printLayout.frame0.frame1.frame3.frame5.canvas8.sheet delete SelectBox}
  set ibbox [.printLayout.frame0.frame1.frame3.frame5.canvas8.sheet bbox $indexTag]
  .printLayout.frame0.frame1.frame3.frame5.canvas8.sheet create rectangle \
			[lindex $ibbox 0] [lindex $ibbox 1] \
			[lindex $ibbox 2] [lindex $ibbox 3] -fill {} \
			-outline red -width 2 -tags SelectBox
  set printLayout(SelectedItem) $indexTag
  .printLayout.frame0.frame3.remove config -state normal
  .printLayout.frame0.frame3.edit config -state normal
  .printLayout.frame0.frame3.deselect config -state normal
}

proc PrEscapeNLs {string} {
# Generate Tcl escaped new lines.
# [index] PrEscapeNLs!procedure

  if {[regsub -all "\n" "$string" {\n} newstring] > 0} {
    return "$newstring"
  } else {
    return "$string"
  }
}

proc PrUnEscapeNLs {string} {
# Convert escaped newlines to the real thing.
# [index] PrUnEscapeNLs!procedure

  if {[regsub -all {\\n} "$string" "\n" newstring] > 0} {
    return "$newstring"
  } else {
    return "$string"
  }
}

proc CheckXtypeAndRange {name value} {
# Check an X value's type and range.
# [index] CheckXtypeAndRange!procedure

  global printLayout
  if {[catch [list expr "double($value)"] v]} {
    hl_warning "Not a number ($name): $value, try again"
    return 0
  } elseif {$v < 0} {
    hl_warning "Negative $name: $v, try again"
    return 0
  } elseif {$v > $printLayout(PageWidth)} {
    hl_warning "$name past Page Width ($v > $printLayout(PageWidth)), try again"
    return 0
  } else {
    return 1
  }
}

proc CheckYtypeAndRange {name value} {
# Check an Y value's type and range.
# [index] CheckYtypeAndRange!procedure

  global printLayout
  if {[catch [list expr "double($value)"] v]} {
    hl_warning "Not a number ($name): $value, try again"
    return 0
  } elseif {$v < 0} {
    hl_warning "Negative $name: $v, try again"
    return 0
  } elseif {$v > $printLayout(PageHeight)} {
    hl_warning "$name past Page Height ($v > $printLayout(PageHeight)), try again"
    return 0
  } else {
    return 1
  }
}

proc CheckBMFile {bmfile} {
# Check a bitmap file -- make sure it exists and that Tcl can gronk it.
# [index] CheckBMFile!procedure

  if {[catch [list .printLayout.frame0.frame1.frame3.frame5.canvas8 create \
		   bitmap 0 0 -bitmap "@$bmfile"] item]} {
    hl_warning "Bad bitmap file, $bmfile: $item, try again"
    return 0
  } else {
    catch [list .printLayout.frame0.frame1.frame3.frame5.canvas8 delete $item]
    return 1
  }
}


package provide HL20_PrLayout 1.0
