#* 
#* ------------------------------------------------------------------
#* Home Libarian 1.1 by Deepwoods Software
#* ------------------------------------------------------------------
#* HL20_Import.tcl - Import logic
#* Created by Robert Heller on Sat Sep  6 14:20:23 1997
#* ------------------------------------------------------------------
#* Modification History: 
#* $Log: HL20_Import.tcl,v $
#* Revision 1.4  1998/06/21 19:06:02  heller
#* Small problems with the delimited interface
#*
#* Revision 1.3  1998/05/17 21:14:18  heller
#* Add in indexing
#*
#* Revision 1.2  1998/04/21 18:38:33  heller
#* Final Release...
#*
#* Revision 1.1  1998/01/29 00:07:38  heller
#* Initial revision
#*
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Home Librarian Database -- a program for maintaining a database
#*                                for a home library
#*     Copyright (C) 1991-1997  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

#@Chapter:HL20\_Import.tcl -- Import ASCII files.
#@Label:HL20Import.tcl
#$Id: HL20_Import.tcl,v 1.4 1998/06/21 19:06:02 heller Rel $

# This file defines the procedures to import card catalog data from external
# (ASCII) formats.
#
# Both Version 1 and Version 2 ASCII files, as well as delimited files are
# handled.
global ImportType
# Import type option menu.
# [index] ImportType!global variable

set ImportType {V1 ASCII}

global EscapedOrQuoted
# Escaped or quoted flag.
# [index] EscapedOrQuoted!global variable

set EscapedOrQuoted Quoted

proc ImportDialog {} {
# Put up the Import Dialog.
# [index] ImportDialog!procedure

  global ImportType   
  set ImportType {V1 ASCII}
  global EscapedOrQuoted
  set EscapedOrQuoted Quoted

  global help_tips

  # build widget .importDialog
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .importDialog"
  } {
    catch "destroy .importDialog"
  }
  toplevel .importDialog 

  # Window manager configurations
  wm maxsize .importDialog 1265 994
  wm minsize .importDialog 1 1
  wm title .importDialog {Import Card Catalog Library}
  wm transient  .importDialog .

  # build widget .importDialog.fileFrame
  frame .importDialog.fileFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .importDialog.fileFrame.label4
  label .importDialog.fileFrame.label4 \
    -text {Filename:}

  # build widget .importDialog.fileFrame.filename
  entry .importDialog.fileFrame.filename \
    -exportselection 0

  bind .importDialog.fileFrame.filename <Return> \
	{.importDialog.buttons.button9 invoke}
  enable_balloon .importDialog.fileFrame.filename
  set help_tips(.importDialog.fileFrame.filename) \
	{This is the name of the file to import}

  # build widget .importDialog.fileFrame.button6
  button .importDialog.fileFrame.button6 \
    -padx {11} \
    -pady {4} \
    -text {Browse} \
    -takefocus 0 \
    -command {
	set fname [tk_getOpenFile \
			-defaultextension {.txt} \
			-initialfile "[.importDialog.fileFrame.filename get]" \
			-title "Select a file to import" \
			-filetypes {{{Text Files} {.txt .text .asc .ascii} TEXT}
				    {{All Text Files} * TEXT}
				   }]
	if {[string length "$fname"] > 0} {
	  .importDialog.fileFrame.filename delete 0 end
	  .importDialog.fileFrame.filename insert 0 "$fname"
	}
    }
  set help_tips(.importDialog.fileFrame.button6) \
	{Browse for a file to import}

  # build widget .importDialog.outfileFrame
  frame .importDialog.outfileFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .importDialog.outfileFrame.label4
  label .importDialog.outfileFrame.label4 \
    -text {Output Filename:}

  # build widget .importDialog.outfileFrame.filename
  entry .importDialog.outfileFrame.filename \
    -exportselection 0

  bind .importDialog.outfileFrame.filename <Return> \
	{.importDialog.outbuttons.button9 invoke}
  enable_balloon .importDialog.outfileFrame.filename
  set help_tips(.importDialog.outfileFrame.filename) \
	{This is the name of the card catalog file to create}

  # build widget .importDialog.outfileFrame.button6
  button .importDialog.outfileFrame.button6 \
    -padx {11} \
    -pady {4} \
    -text {Browse} \
    -takefocus 0 \
    -command {
	global HLTypes
	set fname [tk_getSaveFile \
			-defaultextension {.libr} \
			-initialfile "[.importDialog.outfileFrame.filename get]" \
			-title "Select a file to create" \
			-filetypes $HLTypes]
	if {[string length "$fname"] > 0} {
	  catch [list file delete -force "$fname"]
	  .importDialog.outfileFrame.filename delete 0 end
	  .importDialog.outfileFrame.filename insert 0 "$fname"
	}
    }
  set help_tips(.importDialog.outfileFrame.button6) \
	{Browse for a file to create}

  # build widget .importDialog.typeFrame
  frame .importDialog.typeFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .importDialog.typeFrame.label7
  label .importDialog.typeFrame.label7 \
    -text {Import From:}

  tk_optionMenu .importDialog.typeFrame.importType \
  	ImportType \
	{V1 ASCII} {V2 ASCII} {Delimited}
  .importDialog.typeFrame.importType config  -takefocus 0

  set help_tips(.importDialog.typeFrame.importType) \
	{Select the format of the file to be imported}
  set help_tips(.importDialog.typeFrame.importType.menu,0) \
	{Version 1 ASCII}
  set help_tips(.importDialog.typeFrame.importType.menu,1) \
	{Version 2 ASCII}
  set help_tips(.importDialog.typeFrame.importType.menu,2) \
	{A delimited file (typically exported from another database system)}

  # build widget .importDialog.delimFrame
  frame .importDialog.delimFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .importDialog.delimFrame.label51
  label .importDialog.delimFrame.label51 \
    -text {Delimiter: }

  # build widget .importDialog.delimFrame.delim
  entry .importDialog.delimFrame.delim \
    -width {1} \
    -exportselection 0

  # build widget .importDialog.delimFrame.radiobutton53
  radiobutton .importDialog.delimFrame.radiobutton53 \
    -relief {raised} \
    -text {Escaped with:} \
    -takefocus 0 \
    -value {Escape} \
    -variable {EscapedOrQuoted} \
    -command {focus .importDialog.delimFrame.escapeChar}

  # build widget .importDialog.delimFrame.radiobutton54
  radiobutton .importDialog.delimFrame.radiobutton54 \
    -relief {raised} \
    -text {Quoted With:} \
    -takefocus 0 \
    -value {Quoted} \
    -variable {EscapedOrQuoted} \
    -command {focus .importDialog.delimFrame.quoteChar}

  # build widget .importDialog.delimFrame.escapeChar
  entry .importDialog.delimFrame.escapeChar \
    -width {1} \
    -exportselection 0

  # build widget .importDialog.delimFrame.quoteChar
  entry .importDialog.delimFrame.quoteChar \
    -width {1} \
    -exportselection 0

  # build widget .importDialog.buttons
  frame .importDialog.buttons \
    -borderwidth {2}

  # build widget .importDialog.buttons.button9
  button .importDialog.buttons.button9 \
    -padx {11} \
    -pady {4} \
    -takefocus 0 \
    -text {OK} \
    -command {
	  global EscapedOrQuoted
 	  global ImportType
 	  set infile "[.importDialog.fileFrame.filename get]"
 	  set outfile "[.importDialog.outfileFrame.filename get]"
 	  set delim "[.importDialog.delimFrame.delim get]"
 	  set escapeChar "[.importDialog.delimFrame.escapeChar get]"
 	  set quoteChar "[.importDialog.delimFrame.quoteChar get]"
	  if {"[info procs XFEdit]" != ""} {
	    catch "XFDestroy .importDialog"
	  } {
	    catch "destroy .importDialog"
	  }
	  DoImport "$infile" "$outfile" "$delim" "$escapeChar" \
		   "$quoteChar" "$ImportType" $EscapedOrQuoted
    }

  # build widget .importDialog.buttons.button10
  button .importDialog.buttons.button10 \
    -padx {11} \
    -takefocus 0 \
    -pady {4} \
    -text {Cancel} \
    -command {
	  if {"[info procs XFEdit]" != ""} {
	    catch "XFDestroy .importDialog"
	  } {
	    catch "destroy .importDialog"
	  }
    }

  # build widget .importDialog.buttons.button11
  button .importDialog.buttons.button11 \
    -padx {11} \
    -takefocus 0 \
    -pady {4} \
    -text {Help} \
    -command {hl_Help {Importing a Card Catalog database}}

  # pack master .importDialog.fileFrame
  pack configure .importDialog.fileFrame.label4 \
    -side left
  pack configure .importDialog.fileFrame.filename \
    -expand 1 \
    -fill x \
    -side left
  pack configure .importDialog.fileFrame.button6 \
    -side right

  # pack master .importDialog.outfileFrame
  pack configure .importDialog.outfileFrame.label4 \
    -side left
  pack configure .importDialog.outfileFrame.filename \
    -expand 1 \
    -fill x \
    -side left
  pack configure .importDialog.outfileFrame.button6 \
    -side right

  # pack master .importDialog.typeFrame
  pack configure .importDialog.typeFrame.label7 \
    -side left
  pack configure .importDialog.typeFrame.importType \
    -expand 1 \
    -fill x \
    -side right

  # pack master .importDialog.delimFrame
  pack configure .importDialog.delimFrame.label51 \
    -side left
  pack configure .importDialog.delimFrame.delim \
    -side left
  pack configure .importDialog.delimFrame.radiobutton53 \
    -side left
  pack configure .importDialog.delimFrame.escapeChar \
    -side left
  pack configure .importDialog.delimFrame.radiobutton54 \
    -side left
  pack configure .importDialog.delimFrame.quoteChar \
    -side left

  # pack master .importDialog.buttons
  pack configure .importDialog.buttons.button9 \
    -expand 1 \
    -side left
  pack configure .importDialog.buttons.button10 \
    -expand 1 \
    -side left
  pack configure .importDialog.buttons.button11 \
    -expand 1 \
    -side right

  # pack master .importDialog
  pack configure .importDialog.fileFrame \
    -fill x
  pack configure .importDialog.outfileFrame \
    -fill x
  pack configure .importDialog.typeFrame \
    -fill x
  pack configure .importDialog.delimFrame \
    -fill x
  pack configure .importDialog.buttons \
    -expand 1 \
    -fill both

  .importDialog.fileFrame.filename insert end {}
  .importDialog.outfileFrame.filename insert end {}
  .importDialog.delimFrame.delim insert end {,}
  .importDialog.delimFrame.escapeChar insert end "\\"
  .importDialog.delimFrame.quoteChar insert end {"}

  wm withdraw .importDialog
  update idletasks
  set x [expr [winfo screenwidth .importDialog]/2 - \
	      [winfo reqwidth .importDialog]/2 - \
	      [winfo vrootx .]]
  set y [expr [winfo screenheight .importDialog]/2 - \
	      [winfo reqheight .importDialog]/2 - \
	      [winfo vrooty .]]
  wm geom .importDialog +$x+$y
  wm deiconify .importDialog

# end of widget tree

   update idle
   grab .importDialog
   focus .importDialog.fileFrame.filename 
   tkwait window .importDialog

}

proc ImportLibrary {} {
# Import a card catalog.
# [index] ImportLibrary!procedure

  global CurrentCardCatalog
  if {[string compare "$CurrentCardCatalog" {}] != 0} {return}
  ImportDialog
}

proc DoImport {importFile outFile delim escape quote importType escapeOrQuoted} {
# Perform the import.
#
# Arguments:
# <in> importFile -- this is the file to import from
# <in> outFile -- this is the file to import to
# <in> delim -- delimiter character (only used if importType is Delimited)
# <in> escape -- escape character (only used if importType is Delimited)
# <in> quote -- quote character (only used if importType is Delimited)
# <in> importType -- import mode, one of {V1 ASCII} {V2 ASCII} {Delimited}
# <in> escapeOrQuoted -- escape or quoted, either Escape or Quoted
# [index] DoImport!procedure

  switch -exact -- "$importType" {
    {V1 ASCII} {DoImportV1ASCII "$importFile" "$outFile"}
    {V2 ASCII} {DoImportV2ASCII "$importFile" "$outFile"}
    {Delimited} {
	DoImportDelimited "$importFile" "$outFile" "$delim" "$escape" \
			  "$quote" "$escapeOrQuoted"
	}
    default {
	hl_error "Unsupported or unknown import type: $importType"
    }
  }
}

proc DoImportV1ASCII {importFile outFile} {
# Import a Version 1 ASCII file (as typically generated by Libr2Ascii)
#
# Arguments:
# <in> importFile -- this is the file to import from
# <in> outFile -- this is the file to import to
# [index] DoImportV1ASCII!procedure

  StartWorking
  global CurrentCardCatalog
  if {[catch [list ImportV1ASCIIvBTree "$importFile" "$outFile"] CurrentCardCatalog]} {
    EndWorking
    hl_error $CurrentCardCatalog
    set CurrentCardCatalog {}
    return
  }
  EndWorking

  global tk_version
  if {$tk_version >= 8.0} {
    set fm {.menuBar.file}
  } else {
    set fm {.menuBar.fileButton.m}
  }
  $fm entryconfigure {New...} -state disabled
  $fm entryconfigure {Open...} -state disabled
  $fm entryconfigure {Import...} -state disabled
  $fm entryconfigure {Search...} -state disabled
  $fm entryconfigure {Close} -state normal
  $fm entryconfigure {Print...} -state normal
  $fm entryconfigure {Export...} -state normal
  if {$tk_version >= 8.0} {
    set sm {.menuBar.special}
  } else {
    set sm {.menuBar.specialButton.m}
  }
  $sm entryconfigure {Define a new Card Type} -state normal
  $sm entryconfigure {Define a new Location Type} -state normal
  $sm entryconfigure {Define a new Category} -state normal
  $sm entryconfigure {Create a template Card} -state normal
  $sm entryconfigure {Edit a template Card} -state normal
  $sm entryconfigure {Remove a template Card} -state normal
  $sm entryconfigure {Save Card template} -state normal
  $sm entryconfigure {Load Card templates} -state normal


  .auxFrame.messages configure -text "[file tail $outFile] [$CurrentCardCatalog openstat]"

  pack forget .mainFrame.openFrame
  if {![winfo exists .mainFrame.editForm]} {editForm}
  pack configure .mainFrame.editForm \
	-expand 1 \
	-fill both

}

proc DoImportV2ASCII {importFile outFile} {
# Import a Version 1 ASCII file (as typically generated by Libr2Ascii)
#
# Arguments:
# <in> importFile -- this is the file to import from
# <in> outFile -- this is the file to import to
# [index] DoImportV2ASCII!procedure

  StartWorking
  global CurrentCardCatalog
  if {[catch [list ImportV2ASCIIvBTree "$importFile" "$outFile"] CurrentCardCatalog]} {
    EndWorking
    hl_error $CurrentCardCatalog
    set CurrentCardCatalog {}
    return
  }
  EndWorking

  global tk_version
  if {$tk_version >= 8.0} {
    set fm {.menuBar.file}
  } else {
    set fm {.menuBar.fileButton.m}
  }
  $fm entryconfigure {New...} -state disabled
  $fm entryconfigure {Open...} -state disabled
  $fm entryconfigure {Import...} -state disabled
  $fm entryconfigure {Search...} -state disabled
  $fm entryconfigure {Close} -state normal
  $fm entryconfigure {Print...} -state normal
  $fm entryconfigure {Export...} -state normal
  if {$tk_version >= 8.0} {
    set sm {.menuBar.special}
  } else {
    set sm {.menuBar.specialButton.m}
  }
  $sm entryconfigure {Define a new Card Type} -state normal
  $sm entryconfigure {Define a new Location Type} -state normal
  $sm entryconfigure {Define a new Category} -state normal
  $sm entryconfigure {Create a template Card} -state normal
  $sm entryconfigure {Edit a template Card} -state normal
  $sm entryconfigure {Remove a template Card} -state normal
  $sm entryconfigure {Save Card template} -state normal
  $sm entryconfigure {Load Card templates} -state normal


  .auxFrame.messages configure -text "[file tail $outFile] [$CurrentCardCatalog openstat]"

  pack forget .mainFrame.openFrame
  if {![winfo exists .mainFrame.editForm]} {editForm}
  pack configure .mainFrame.editForm \
	-expand 1 \
	-fill both

}

proc DoImportDelimited {importFile outFile delim escape quote escapeOrQuoted} {
# Import a Version 1 ASCII file (as typically generated by Libr2Ascii)
#
# Arguments:
# <in> importFile -- this is the file to import from
# <in> outFile -- this is the file to import to
# <in> delim   -- delimiter character
# <in> escape  -- escape charscrer
# <in> quote   -- quote character
# <in> escapeOrQuoted   -- escape or quoted flag.
# [index] DoImportDelimited!procedure

  StartWorking
  global CurrentCardCatalog
  if {!$escapeOrQuoted} {
    set escape "$quote"
  } 
  if {[catch [list ImportDelimitedvBTree "$importFile" "$outFile"] CurrentCardCatalog]} {
    EndWorking
    hl_error $CurrentCardCatalog
    set CurrentCardCatalog {}
    return
  }
  EndWorking

  global tk_version
  if {$tk_version >= 8.0} {
    set fm {.menuBar.file}
  } else {
    set fm {.menuBar.fileButton.m}
  }
  $fm entryconfigure {New...} -state disabled
  $fm entryconfigure {Open...} -state disabled
  $fm entryconfigure {Import...} -state disabled
  $fm entryconfigure {Search...} -state disabled
  $fm entryconfigure {Close} -state normal
  $fm entryconfigure {Print...} -state normal
  $fm entryconfigure {Export...} -state normal
  if {$tk_version >= 8.0} {
    set sm {.menuBar.special}
  } else {
    set sm {.menuBar.specialButton.m}
  }
  $sm entryconfigure {Define a new Card Type} -state normal
  $sm entryconfigure {Define a new Location Type} -state normal
  $sm entryconfigure {Define a new Category} -state normal
  $sm entryconfigure {Create a template Card} -state normal
  $sm entryconfigure {Edit a template Card} -state normal
  $sm entryconfigure {Remove a template Card} -state normal
  $sm entryconfigure {Save Card template} -state normal
  $sm entryconfigure {Load Card templates} -state normal


  .auxFrame.messages configure -text "[file tail $outFile] [$CurrentCardCatalog openstat]"

  pack forget .mainFrame.openFrame
  if {![winfo exists .mainFrame.editForm]} {editForm}
  pack configure .mainFrame.editForm \
	-expand 1 \
	-fill both

}
  


package provide HL20_Import 1.0
