#* 
#* ------------------------------------------------------------------
#* Home Libarian 1.1 by Deepwoods Software
#* ------------------------------------------------------------------
#* HL20_Help.tcl - On-line Help support code
#* Created by Robert Heller on Sat Sep  6 09:16:53 1997
#* ------------------------------------------------------------------
#* Modification History: 
#* $Log: HL20_Help.tcl,v $
#* Revision 2.2  1998/05/21 20:30:06  heller
#* Minor problem in help file offset lookup code.
#*
#* Revision 2.1  1998/05/17 21:14:18  heller
#* Add in indexing
#*
#* Revision 2.0  1997/09/06 13:29:41  heller
#* *** empty log message ***
#*
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Home Librarian Database -- a program for maintaining a database
#*                                for a home library
#*     Copyright (C) 1991-1997  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

#@Chapter: HL20\_Help.tcl  -- Help dialog support
#@Label: HL20Help.tcl
#$Id: HL20_Help.tcl,v 2.2 1998/05/21 20:30:06 heller Rel $

# This script implements the on-line help dialog.

global LibDir

global HelpFile
# This is the name of the help file.
# [index] HelpFile!global variable

set HelpFile {HomeLibrarian.help}

global TopicMap
# This is the topic map.
# [index] TopicMap!global variable

global TopicMapInit
# This is a flag to indicate if the topic map has been loaded.
# [index] TopicMapInit!global variable

set TopicMapInit 0

global TopicPattern
# Pattern to match a topic line.
# [index] TopicPattern!global variable

set TopicPattern {^\*(.*)$}

proc HomeLibrarianVersion {} {
  # Display version info.
  # [index] HomeLibrarianVersion!procedure

  hl_Help Version
}

proc HomeLibrarianCopying {} {
  # Display the GPL.
  # [index] HomeLibrarianCopying!procedure

  hl_Help Copying
}

proc HomeLibrarianWarranty {} {
  # Display the Warrantry (none).
  # [index] HomeLibrarianWarranty!procedure

  hl_Help Warrantry
}

proc HomeLibrarianRegistering {} {
  # Display help on registering.
  # [index] HomeLibrarianRegistering!procedure

  hl_Help Registering
}

proc AboutHomeLibrarian {} {
  # Display help about Home Librarian.
  # [index] AboutHomeLibrarian!procedure

  hl_Help About
}


proc hl_Help {{topic {}}} {
  # Main workhorse function.  Popup the help dialog and fill in the help.
  # If the help dialog is already up, then just update the help text.
  #
  # Arguments:
  # <in> (optional) topic -- the topic to display.
  # [index] hl\_Help!procedure

  if {[winfo exists .helpWindow]} {
    hl_help1 "$topic"
    return
  }

# .helpWindow
# The above line makes pasting MUCH easier for me.
# It contains the pathname of the cutted widget.
# Tcl version: 7.6 (Tcl/Tk/XF)
# Tk version: 4.2
# XF version: 4.0
#

  # build widget .helpWindow
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .helpWindow"
  } {
    catch "destroy .helpWindow"
  }
  toplevel .helpWindow 

  # Window manager configurations
  wm maxsize .helpWindow 1009 738
  wm minsize .helpWindow 1 1
  wm title .helpWindow {Help For Home Librarian}


  # build widget .helpWindow.top
  frame .helpWindow.top \
    -borderwidth {2}

  # build widget .helpWindow.top.label2
  label .helpWindow.top.label2 \
    -image {SmallFace}

  # build widget .helpWindow.top.label3
  label .helpWindow.top.label3 \
    -background {yellow} \
    -font {-*-new century schoolbook-bold-r-*-*-18-*-*-*-*-*-*-*} \
    -foreground {brown} \
    -text {Help For Home Librarian}

  # build widget .helpWindow.mFrame
  frame .helpWindow.mFrame

  # build widget .helpWindow.mFrame.topicFrame
  frame .helpWindow.mFrame.topicFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .helpWindow.mFrame.topicFrame.label5
  label .helpWindow.mFrame.topicFrame.label5 \
    -text {Topics List}

  # build widget .helpWindow.mFrame.topicFrame.frame0
  frame .helpWindow.mFrame.topicFrame.frame0 \
    -borderwidth {2}

  # build widget .helpWindow.mFrame.topicFrame.frame0.frame1
  frame .helpWindow.mFrame.topicFrame.frame0.frame1

  # build widget .helpWindow.mFrame.topicFrame.frame0.frame1.frame3
  frame .helpWindow.mFrame.topicFrame.frame0.frame1.frame3 \
    -borderwidth {2}

  # build widget .helpWindow.mFrame.topicFrame.frame0.frame1.frame3.listbox8
  listbox .helpWindow.mFrame.topicFrame.frame0.frame1.frame3.listbox8 \
    -width {20} \
    -selectmode single \
    -xscrollcommand {.helpWindow.mFrame.topicFrame.frame0.frame2.frame5.scrollbar10 set} \
    -yscrollcommand {.helpWindow.mFrame.topicFrame.frame0.frame1.frame4.scrollbar9 set} \
    -exportselection 0
  bind .helpWindow.mFrame.topicFrame.frame0.frame1.frame3.listbox8 <Double-1> {
        if [winfo exists %W] {
          tkListboxBeginSelect %W [%W index @%x,%y]
        }
	.helpWindow.buttons.button7 invoke	
  }

  # build widget .helpWindow.mFrame.topicFrame.frame0.frame1.frame4
  frame .helpWindow.mFrame.topicFrame.frame0.frame1.frame4 \
    -borderwidth {2}

  # build widget .helpWindow.mFrame.topicFrame.frame0.frame1.frame4.scrollbar9
  scrollbar .helpWindow.mFrame.topicFrame.frame0.frame1.frame4.scrollbar9 \
    -command {.helpWindow.mFrame.topicFrame.frame0.frame1.frame3.listbox8 yview} \
    -width {13}

  # build widget .helpWindow.mFrame.topicFrame.frame0.frame2
  frame .helpWindow.mFrame.topicFrame.frame0.frame2 \
    -borderwidth {1}

  # build widget .helpWindow.mFrame.topicFrame.frame0.frame2.frame5
  frame .helpWindow.mFrame.topicFrame.frame0.frame2.frame5 \
    -borderwidth {2}

  # build widget .helpWindow.mFrame.topicFrame.frame0.frame2.frame5.scrollbar10
  scrollbar .helpWindow.mFrame.topicFrame.frame0.frame2.frame5.scrollbar10 \
    -command {.helpWindow.mFrame.topicFrame.frame0.frame1.frame3.listbox8 xview} \
    -orient {horizontal} \
    -width {13}

  # build widget .helpWindow.mFrame.topicFrame.frame0.frame2.frame6
  frame .helpWindow.mFrame.topicFrame.frame0.frame2.frame6 \
    -borderwidth {2}

  # build widget .helpWindow.mFrame.topicFrame.frame0.frame2.frame6.frame11
  frame .helpWindow.mFrame.topicFrame.frame0.frame2.frame6.frame11 \
    -borderwidth {2} \
    -height {13} \
    -width {16}

  # build widget .helpWindow.mFrame.textFrame
  frame .helpWindow.mFrame.textFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .helpWindow.mFrame.textFrame.label6
  label .helpWindow.mFrame.textFrame.label6 \
    -text {Help Text}

  # build widget .helpWindow.mFrame.textFrame.frame
  frame .helpWindow.mFrame.textFrame.frame \
    -relief {raised}

  # build widget .helpWindow.mFrame.textFrame.frame.scrollbar1
  scrollbar .helpWindow.mFrame.textFrame.frame.scrollbar1 \
    -command {.helpWindow.mFrame.textFrame.frame.text2 yview}

  # build widget .helpWindow.mFrame.textFrame.frame.text2
  text .helpWindow.mFrame.textFrame.frame.text2 \
    -wrap {word} \
    -yscrollcommand {.helpWindow.mFrame.textFrame.frame.scrollbar1 set} \
    -exportselection 0
  # bindings
  bind .helpWindow.mFrame.textFrame.frame.text2 <Key> {break}
  bind .helpWindow.mFrame.textFrame.frame.text2 <n> {hl_NextTopic;break}
  bind .helpWindow.mFrame.textFrame.frame.text2 <N> {hl_NextTopic;break}
  bind .helpWindow.mFrame.textFrame.frame.text2 <Next> {hl_NextTopic;break}
  bind .helpWindow.mFrame.textFrame.frame.text2 <Right> {hl_NextTopic;break}
  bind .helpWindow.mFrame.textFrame.frame.text2 <p> {hl_PrevTopic;break}
  bind .helpWindow.mFrame.textFrame.frame.text2 <P> {hl_PrevTopic;break}
  bind .helpWindow.mFrame.textFrame.frame.text2 <Prior> {hl_PrevTopic;break}
  bind .helpWindow.mFrame.textFrame.frame.text2 <Left> {hl_PrevTopic;break}
  bind .helpWindow.mFrame.textFrame.frame.text2 <q> {.helpWindow.buttons.button8 invoke;break}
  bind .helpWindow.mFrame.textFrame.frame.text2 <Escape> {.helpWindow.buttons.button8 invoke;break}
  bind .helpWindow.mFrame.textFrame.frame.text2 <End> {.helpWindow.buttons.button8 invoke;break}
  

  # build widget .helpWindow.buttons
  frame .helpWindow.buttons \
    -borderwidth {2}

  # build widget .helpWindow.buttons.button7
  button .helpWindow.buttons.button7 \
    -padx {9} \
    -pady {3} \
    -text {Select Topic} \
    -command {
	set cs [.helpWindow.mFrame.topicFrame.frame0.frame1.frame3.listbox8 curselection]
	if {[llength $cs] > 0} {
	  hl_help1 "[.helpWindow.mFrame.topicFrame.frame0.frame1.frame3.listbox8 get $cs]"
	}
    }

  # build widget .helpWindow.buttons.button8
  button .helpWindow.buttons.button8 \
    -padx {9} \
    -pady {3} \
    -text {Dismiss} \
    -command {
	  if {"[info procs XFEdit]" != ""} {
	    catch "XFDestroy .helpWindow"
	  } {
	    catch "destroy .helpWindow"
	  }
    }

  # build widget .helpWindow.buttons.button9
  button .helpWindow.buttons.button9 \
    -padx {9} \
    -pady {3} \
    -text {Help} \
    -command {hl_help1 Help}

  # pack master .helpWindow.top
  pack configure .helpWindow.top.label2 \
    -fill y \
    -side left
  pack configure .helpWindow.top.label3 \
    -expand 1 \
    -fill x \
    -side right

  # pack master .helpWindow.mFrame
  pack configure .helpWindow.mFrame.topicFrame \
    -expand 1 \
    -fill y \
    -side left
  pack configure .helpWindow.mFrame.textFrame \
    -expand 1 \
    -fill x \
    -side right

  # pack master .helpWindow.mFrame.topicFrame
  pack configure .helpWindow.mFrame.topicFrame.label5
  pack configure .helpWindow.mFrame.topicFrame.frame0 \
    -expand 1 \
    -fill both

  # pack master .helpWindow.mFrame.topicFrame.frame0
  pack configure .helpWindow.mFrame.topicFrame.frame0.frame1 \
    -expand 1 \
    -fill both
  pack configure .helpWindow.mFrame.topicFrame.frame0.frame2 \
    -fill x \
    -side bottom

  # pack master .helpWindow.mFrame.topicFrame.frame0.frame1
  pack configure .helpWindow.mFrame.topicFrame.frame0.frame1.frame3 \
    -expand 1 \
    -fill both \
    -side left
  pack configure .helpWindow.mFrame.topicFrame.frame0.frame1.frame4 \
    -fill y \
    -side right

  # pack master .helpWindow.mFrame.topicFrame.frame0.frame1.frame3
  pack configure .helpWindow.mFrame.topicFrame.frame0.frame1.frame3.listbox8 \
    -expand 1 \
    -fill both \
    -side left

  # pack master .helpWindow.mFrame.topicFrame.frame0.frame1.frame4
  pack configure .helpWindow.mFrame.topicFrame.frame0.frame1.frame4.scrollbar9 \
    -expand 1 \
    -fill y

  # pack master .helpWindow.mFrame.topicFrame.frame0.frame2
  pack configure .helpWindow.mFrame.topicFrame.frame0.frame2.frame5 \
    -expand 1 \
    -fill both \
    -side left
  pack configure .helpWindow.mFrame.topicFrame.frame0.frame2.frame6 \
    -fill y \
    -side right

  # pack master .helpWindow.mFrame.topicFrame.frame0.frame2.frame5
  pack configure .helpWindow.mFrame.topicFrame.frame0.frame2.frame5.scrollbar10 \
    -expand 1 \
    -fill x \
    -side left

  # pack master .helpWindow.mFrame.topicFrame.frame0.frame2.frame6
  pack configure .helpWindow.mFrame.topicFrame.frame0.frame2.frame6.frame11 \
    -expand 1 \
    -fill both

  # pack master .helpWindow.mFrame.textFrame
  pack configure .helpWindow.mFrame.textFrame.label6
  pack configure .helpWindow.mFrame.textFrame.frame \
    -fill both

  # pack master .helpWindow.mFrame.textFrame.frame
  pack configure .helpWindow.mFrame.textFrame.frame.scrollbar1 \
    -fill y \
    -side right
  pack configure .helpWindow.mFrame.textFrame.frame.text2 \
    -expand 1 \
    -fill both

  # pack master .helpWindow.buttons
  pack configure .helpWindow.buttons.button7 \
    -expand 1 \
    -side left
  pack configure .helpWindow.buttons.button8 \
    -expand 1 \
    -side left
  pack configure .helpWindow.buttons.button9 \
    -expand 1 \
    -side right

  # pack master .helpWindow
  pack configure .helpWindow.top \
    -fill x
  pack configure .helpWindow.mFrame \
    -expand 1 \
    -fill x
  pack configure .helpWindow.buttons \
    -fill x

  .helpWindow.mFrame.textFrame.frame.text2 insert end {}

# end of widget tree

# Initialize the topic map and load the topic list.

  global TopicMap
  global TopicMapInit
  if {!$TopicMapInit} {
    LoadTopicMap
  }
  set tl [lsort [array names TopicMap]]
  foreach t $tl {
    .helpWindow.mFrame.topicFrame.frame0.frame1.frame3.listbox8 insert end "$t"
  }

  hl_help1 "$topic"

  set oldFocus [focus]
  set oldGrab [grab current .helpWindow]
  if {$oldGrab != ""} {
    set grabStatus [grab status $oldGrab]
  }
  grab .helpWindow
  focus .helpWindow.mFrame.textFrame.frame.text2
  update idletasks
  tkwait window .helpWindow
  catch {focus $oldFocus}
  if {$oldGrab != ""} {
    if {$grabStatus == "global"} {
      grab -global $oldGrab
    } else {
      grab $oldGrab
    }
  }
}

proc ListBoxSetSelectionToItem {lb text} {
  # Set the selection in the listbox to match the item with the specified 
  # text.
  #
  # Arguments:
  # <in> lb -- the list box to update
  # <in> text -- the text to search for.
  # [index] ListBoxSetSelectionToItem!procedure

  $lb selection clear 0 end
  set icount [$lb size]
  for {set i 0} {$i < $icount} {incr i} {
    if {[string compare "$text" "[$lb get $i]"] == 0} {
      $lb selection set $i
      $lb see $i
      return
    }
  }
}

proc hl_NextTopic {} {
  # Display the next topic, if any.
  # [index] hl\_NextTopic!procedure

  set lb .helpWindow.mFrame.topicFrame.frame0.frame1.frame3.listbox8
  set cs [$lb curselection]
  if {[llength $cs] > 0} {
    incr cs
    if {$cs < [$lb size]} {
      $lb selection clear 0 end
      $lb selection set $cs
      $lb see $cs
      .helpWindow.buttons.button7 invoke
    }
  }
}

proc hl_PrevTopic {} {
  # Display the previous topic, if any.
  # [index] hl\_PrevTopic!procedure

  set lb .helpWindow.mFrame.topicFrame.frame0.frame1.frame3.listbox8
  set cs [$lb curselection]
  if {[llength $cs] > 0} {
    incr cs -1
    if {$cs > 0} {
      $lb selection clear 0 end
      $lb selection set $cs
      $lb see $cs
      .helpWindow.buttons.button7 invoke
    }
  }
}

proc hl_help1 {{topic {}}} {
  # Update the help text.
  #
  # Arguments:
  # <in> (optional) topic -- the topic to display help text for.
  # [index] hl\_help1!procedure
  
  set tt "[GetTopicText $topic]"
  .helpWindow.mFrame.textFrame.frame.text2 delete 1.0 end
  .helpWindow.mFrame.textFrame.frame.text2 insert end "$tt"
  ListBoxSetSelectionToItem .helpWindow.mFrame.topicFrame.frame0.frame1.frame3.listbox8 "$topic"
}


proc LoadTopicMap {} {
  # Load the topic map array.  Each element is the offset into the file
  # For each topic.
  # [index] LoadTopicMap!procedure

  global LibDir
  global HelpFile
  global TopicMap
  global TopicMapInit
  global TopicPattern
  set hf "[file join $LibDir $HelpFile]"
  if {[catch [list open "$hf" r] hfp]} {
    hl_error "Error opening help file: $hfp"
    return
  }
  set TopicMap() [tell $hfp]
  while {[gets $hfp line] >= 0} {
    if {[regexp "$TopicPattern" "$line" whole topic] > 0} {
      set TopicMap($topic) [tell $hfp]
    }
  }
  close $hfp
  set TopicMapInit 1
}

proc GetTopicText {{topic {}}} {
  # Get the text for a topic. The topic map is consulted and the text is read
  # in until the next topic or until EOF.
  #
  # Arguments:
  # <in> (optional) topic -- the topic to get text for.
  # [index] GetTopicText!procedure

  global LibDir
  global HelpFile
  global TopicMap
  global TopicMapInit
  global TopicPattern
  if {!$TopicMapInit} {
    LoadTopicMap
  }
  set hf "[file join $LibDir $HelpFile]"
  if {[catch [list open "$hf" r] hfp]} {
    hl_error "Error opening help file: $hfp"
    return
  }
  if {[catch [list set "TopicMap($topic)"] offset]} {
    close $hfp
    return "Topic ($topic) not found: $offset"
  }
  seek $hfp $offset start
  set result {}
  while {[gets $hfp line] >= 0} {
    if {[regexp "$TopicPattern" "$line" whole topic] > 0} {
       break
    } else {
       append result "$line\n"
    }
  }
  close $hfp
  return "$result"
}

package provide HL20_Help 1.0
