#* 
#* ------------------------------------------------------------------
#* Home Libarian 1.1 by Deepwoods Software
#* ------------------------------------------------------------------
#* HL20_Export.tcl - Export logic.
#* Created by Robert Heller on Sat Sep  6 14:21:33 1997
#* ------------------------------------------------------------------
#* Modification History: 
#* $Log: HL20_Export.tcl,v $
#* Revision 1.4  1998/06/21 19:06:02  heller
#* Small problems with the delimited interface
#*
#* Revision 1.3  1998/05/17 21:14:18  heller
#* Add in indexing
#*
#* Revision 1.2  1998/04/21 18:38:33  heller
#* Final Release...
#*
#* Revision 1.1  1998/01/29 00:07:38  heller
#* Initial revision
#*
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Home Librarian Database -- a program for maintaining a database
#*                                for a home library
#*     Copyright (C) 1991-1997  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

#@Chapter: HL20\_Export.tcl -- Export code
#@Label: HL20Export.tcl
#$Id: HL20_Export.tcl,v 1.4 1998/06/21 19:06:02 heller Rel $

global ExportType
# Export type option menu.
# [index] ExportType!global variable

set ExportType {V1 ASCII}




proc ExportDialog {} {
# Popup an export dialog and prepare to export the current library to ASCII 
# form.
# [index] ExportDialog!procedure

  # build widget .exportDialog
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .exportDialog"
  } {
    catch "destroy .exportDialog"
  }
  toplevel .exportDialog

  # Window manager configurations
  wm maxsize .exportDialog 1265 994
  wm minsize .exportDialog 1 1
  wm title .exportDialog {Export Current Card Catalog}
  wm transient .exportDialog .

  global ExportType
  set ExportType {V1 ASCII}
  global EscapedOrQuoted
  set EscapedOrQuoted Quoted

  # build widget .exportDialog.fileFrame
  frame .exportDialog.fileFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .exportDialog.fileFrame.label4
  label .exportDialog.fileFrame.label4 \
    -text {Filename:}

  # build widget .exportDialog.fileFrame.filename
  entry .exportDialog.fileFrame.filename \
    -exportselection {0} \
    -exportselection 0

  # build widget .exportDialog.fileFrame.button6
  button .exportDialog.fileFrame.button6 \
    -padx {11} \
    -takefocus 0 \
    -pady {4} \
    -takefocus 0 \
    -text {Browse} \
    -command {
	set fname [tk_getSaveFile \
			-defaultextension {.txt} \
			-initialfile "[.exportDialog.fileFrame.filename get]" \
			-title "Select a file to import" \
			-filetypes {{{Text Files} {.txt .text .asc .ascii} TEXT}
				    {{All Text Files} * TEXT}
				   }]
	if {[string length "$fname"] > 0} {
	   .exportDialog.fileFrame.filename delete 0 end
	   .exportDialog.fileFrame.filename insert 0 "$fname"
	}
     }

  # build widget .exportDialog.typeFrame
  frame .exportDialog.typeFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .exportDialog.typeFrame.label7
  label .exportDialog.typeFrame.label7 \
    -text {Export As:}

  tk_optionMenu .exportDialog.typeFrame.exportType \
  	ExportType \
	{V1 ASCII} {V2 ASCII} {Delimited} {Formatted}
  .exportDialog.typeFrame.exportType config  -takefocus 0

  # build widget .exportDialog.delimFrame
  frame .exportDialog.delimFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .exportDialog.delimFrame.label51
  label .exportDialog.delimFrame.label51 \
    -text {Delimiter: }

  # build widget .exportDialog.delimFrame.delim
  entry .exportDialog.delimFrame.delim \
    -width {1} \
    -exportselection 0

  # build widget .exportDialog.delimFrame.radiobutton53
  radiobutton .exportDialog.delimFrame.radiobutton53 \
    -relief {raised} \
    -text {Escaped with:} \
    -takefocus 0 \
    -value {Escape} \
    -variable {EscapedOrQuoted}

  # build widget .exportDialog.delimFrame.radiobutton54
  radiobutton .exportDialog.delimFrame.radiobutton54 \
    -relief {raised} \
    -text {Quoted With:} \
    -takefocus 0 \
    -value {Quoted} \
    -variable {EscapedOrQuoted}

  # build widget .exportDialog.delimFrame.escapeChar
  entry .exportDialog.delimFrame.escapeChar \
    -width {1} \
    -exportselection 0

  # build widget .exportDialog.delimFrame.quoteChar
  entry .exportDialog.delimFrame.quoteChar \
    -width {1} \
    -exportselection 0

  # build widget .exportDialog.buttons
  frame .exportDialog.buttons \
    -borderwidth {2}

  # build widget .exportDialog.buttons.button9
  button .exportDialog.buttons.button9 \
    -padx {11} \
    -takefocus 0 \
    -pady {4} \
    -text {OK} \
    -command {
	global ExportType
	global EscapedOrQuoted
	set ofile "[.exportDialog.fileFrame.filename get]"
	set delim "[.exportDialog.delimFrame.delim get]"
	set escapeChar "[.exportDialog.delimFrame.escapeChar get]"
	set quoteChar "[.exportDialog.delimFrame.quoteChar get]"
	if {"[info procs XFEdit]" != ""} {
	  catch "XFDestroy .exportDialog"
	} {
	  catch "destroy .exportDialog"
	}
	DoExport "$ofile" "$delim" "$escapeChar" "$quoteChar" \
		 "$ExportType" $EscapedOrQuoted
    }

  # build widget .exportDialog.buttons.button10
  button .exportDialog.buttons.button10 \
    -padx {11} \
    -takefocus 0 \
    -pady {4} \
    -text {Cancel} \
    -command {
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .exportDialog"
  } {
    catch "destroy .exportDialog"
  }
    }

  # build widget .exportDialog.buttons.button11
  button .exportDialog.buttons.button11 \
    -padx {11} \
    -pady {4} \
    -takefocus 0 \
    -text {Help} \
    -command {hl_Help {Exporting a Card Catalog database}}

  # pack master .exportDialog.fileFrame
  pack configure .exportDialog.fileFrame.label4 \
    -side left
  pack configure .exportDialog.fileFrame.filename \
    -expand 1 \
    -fill x \
    -side left
  pack configure .exportDialog.fileFrame.button6 \
    -side right

  # pack master .exportDialog.typeFrame
  pack configure .exportDialog.typeFrame.label7 \
    -side left
  pack configure .exportDialog.typeFrame.exportType \
    -expand 1 \
    -fill x \
    -side right

  # pack master .exportDialog.delimFrame
  pack configure .exportDialog.delimFrame.label51 \
    -side left
  pack configure .exportDialog.delimFrame.delim \
    -side left
  pack configure .exportDialog.delimFrame.radiobutton53 \
    -side left
  pack configure .exportDialog.delimFrame.escapeChar \
    -side left
  pack configure .exportDialog.delimFrame.radiobutton54 \
    -side left
  pack configure .exportDialog.delimFrame.quoteChar \
    -side left

  # pack master .exportDialog.buttons
  pack configure .exportDialog.buttons.button9 \
    -expand 1 \
    -side left
  pack configure .exportDialog.buttons.button10 \
    -expand 1 \
    -side left
  pack configure .exportDialog.buttons.button11 \
    -expand 1 \
    -side right

  # pack master .exportDialog
  pack configure .exportDialog.fileFrame \
    -fill x
  pack configure .exportDialog.typeFrame \
    -fill x
  pack configure .exportDialog.delimFrame \
    -fill x
  pack configure .exportDialog.buttons \
    -expand 1 \
    -fill both

  .exportDialog.fileFrame.filename insert end {}
  .exportDialog.delimFrame.delim insert end {,}
  .exportDialog.delimFrame.escapeChar insert end "\\"
  .exportDialog.delimFrame.quoteChar insert end {"}


  wm withdraw .exportDialog
  update idletasks
  set x [expr [winfo screenwidth .exportDialog]/2 - \
	      [winfo reqwidth .exportDialog]/2 - \
	      [winfo vrootx .]]
  set y [expr [winfo screenheight .exportDialog]/2 - \
	      [winfo reqheight .exportDialog]/2 - \
	      [winfo vrooty .]]
  wm geom .exportDialog +$x+$y
  wm deiconify .exportDialog

# end of widget tree

  update idle
  grab .exportDialog
  focus .exportDialog.fileFrame.filename
  tkwait window .exportDialog

}


proc ExportCurrentLibrary {} {
# Export the current library.
# [index] ExportCurrentLibrary!procedure

  global CurrentCardCatalog
  if {[string compare "$CurrentCardCatalog" {}] == 0} {return}
  ExportDialog
}

proc DoExport {ofile delim escape quote exportType EscapedOrQuoted} {
# Perform the export
#
# Arguments:
# <in> ofile -- file to export to
# <in> delim -- delimiter (only used if exportType is Delimited)
# <in> escape -- escape character (only used if exportType is Delimited)
# <in> quote -- quote character (only used if exportType is Delimited)
# <in> exportType  -- import mode, one of {V1 ASCII} {V2 ASCII} {Delimited} {Formatted}
# <in> EscapedOrQuoted -- escape or quoted, either Escape or Quoted
# [index] DoExport!procedure

  switch -exact -- "$exportType" {
    {V1 ASCII} {DoExportV1ASCII "$ofile"}
    {V2 ASCII} {DoExportV2ASCII "$ofile"}
    {Delimited} {
	DoExportDelimited "$ofile" "$delim" "$escape" "$quote" "$EscapedOrQuoted"
    }
    {Formatted} {DoExportFormatted "$ofile"}
    default {
	 hl_error "Unsupported or unknown export type: $exportType"
    }
  }
}

proc DoExportV1ASCII {outfile} {
# Export a Version 1 ASCII file (as typically read by Ascii2Libr)
#
# Arguments:
# <in> outFile -- this is the file to export to
#
# [index] DoExportV1ASCII!procedure

  StartWorking
  global CurrentCardCatalog
  if {[catch [list $CurrentCardCatalog exportv1ascii "$outfile"] error]} {
    EndWorking
    hl_error "$error"
    return
  }
  EndWorking
}

proc DoExportV2ASCII {outfile} {
# Export a Version 2 ASCII file 
#
# Arguments:
# <in> outFile -- this is the file to export to
#
# [index] DoExportV2ASCII!procedure

  StartWorking
  global CurrentCardCatalog
  if {[catch [list $CurrentCardCatalog exportv2ascii "$outfile"] error]} {
    EndWorking
    hl_error "$error"
    return
  }
  EndWorking
}

proc DoExportDelimited {outfile delim escape quote escapeOrQuoted} {
# Export a Delimited ASCII file set
#
# Arguments:
# <in> outFile -- this is the file to export to
# <in> delim   -- delimiter character
# <in> escape  -- escape charscrer
# <in> quote   -- quote character
# <in> escapeOrQuoted   -- escape or quoted flag.
# [index] DoExportDelimited!procedure

  StartWorking
  global CurrentCardCatalog
  if {[string compare "$escapeOrQuoted" {Quoted}] == 0} {
    set escape "$quote"
    set escapeOrQuoted 1
  } else {
    set escapeOrQuoted 0
  }
  if {[catch [list $CurrentCardCatalog exportdelimited "$outfile" "$delim" "$escape" "$escapeOrQuoted"] error]} {
    EndWorking
    hl_error "$error"
    return
  }
  EndWorking
}

proc DoExportFormatted {outfile} {
# Export a Formatted ASCII file
#
# Arguments:
# <in> outFile -- this is the file to export to
#
# [index] DoExportFormatted!procedure

  StartWorking
  global CurrentCardCatalog
  if {[catch [list $CurrentCardCatalog exportformatted "$outfile"] error]} {
    EndWorking
    hl_error "$error"
    return
  }
  EndWorking
}


package provide HL20_Export 1.0
