#!/usr/local/bin/wish4.2 -f
#* 
#* ------------------------------------------------------------------
#* Home Libarian 1.1 by Deepwoods Software
#* ------------------------------------------------------------------
#* HL20.tcl - Main Home Librarian Script
#* Created by Robert Heller on Tue Aug 12 15:04:55 1997
#* ------------------------------------------------------------------
#* Modification History: 
#* $Log: HL20.tcl,v $
#* Revision 2.11  1999/02/23 13:27:59  heller
#* Fixes to deal with 'odd' file names (spaces, etc.)
#*
#* Revision 2.10  1998/05/17 21:14:18  heller
#* Add in indexing
#*
#* Revision 2.9  1998/04/28 00:03:54  heller
#* Fix handling of the help tips on the "Windows" menu
#*
#* Revision 2.8  1998/04/26 18:42:17  heller
#* Add in separator to special menu
#*
#* Revision 2.7  1998/04/25 04:24:53  heller
#* New Images.  Adjust size slightly.
#*
#* Revision 2.6  1998/04/21 18:38:33  heller
#* Final Release...
#*
#* Revision 2.5  1998/01/29 00:05:43  heller
#* Add missing file specs for some image create photos.
#* Add ToplevelsToClean logic
#* Fix quoting in Library copier (V1 => V2)
#*
#* Revision 2.4  1997/09/13 05:37:59  heller
#* Minor changes to the "working" code.
#*
#* Revision 2.3  1997/09/06 18:46:52  heller
#* add more packages.
#*
#* Revision 2.2  1997/09/06 15:31:22  heller
#* Additional documentation
#*
#* Revision 2.1  1997/09/06 13:15:30  heller
#* Finish documentation.  Edit Menu support. Odds and ends.
#*
#* Revision 2.0  1997/08/12 19:57:18  heller
#* Initial script
#*
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Home Librarian Database -- a program for maintaining a database
#*                                for a home library
#*     Copyright (C) 1991-1998  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

#@Chapter: HL20.tcl -- Main Script
#@Label: HL20.tcl
#$Id: HL20.tcl,v 2.11 1999/02/23 13:27:59 heller Rel $


# This is the main script file.  It contains the ``main program'' and
# the code to build the top level window and the main common code.
#
# The file is organized into three parts:
# <globals> System-wide global variables.
# <images>  Images
# <Procs>   Common procedures and the main procedures
#


global LibDir
# This is the path to the script library directory.  It is computed from
# the directory name of the script.
# [index] LibDir!global variable

set LibDir "[file dirname [info script]]"

global Work
# This is the name of the work and status canvas.  This canvas is where the
# working animation happens and where status messages appear once the work
# has been completed.
# [index] Work!global variable

set Work {.topFrame.cf.workCanvas}


global WorkingAfterId
# this is the AfterId used during the work idle process.
# [index] WorkingAfterId!global variable

set WorkingAfterId {}

global WorkingIndex
# This is the current working animation index.
# [index] WorkingIndex!global variable

set WorkingIndex -1

global ReverseWorkIndex
# Reverse access index array.  This array is used to map to previous indexes
# to move, remove, or replace images.
# [index] ReverseWorkIndex!global variable

set ReverseWorkIndex(36) 1
set ReverseWorkIndex(35) 2
set ReverseWorkIndex(34) 3
set ReverseWorkIndex(33) 4
set ReverseWorkIndex(32) 5
set ReverseWorkIndex(31) 6
set ReverseWorkIndex(30) 7
set ReverseWorkIndex(29) 8
set ReverseWorkIndex(28) 9
set ReverseWorkIndex(27) 10
set ReverseWorkIndex(26) 11
set ReverseWorkIndex(25) 12
set ReverseWorkIndex(24) 13
set ReverseWorkIndex(23) 14
set ReverseWorkIndex(22) 15
set ReverseWorkIndex(21) 16
set ReverseWorkIndex(20) 17
set ReverseWorkIndex(19) 18

set ReverseWorkIndex(38) 36
set ReverseWorkIndex(39) 35
set ReverseWorkIndex(40) 34
set ReverseWorkIndex(41) 33
set ReverseWorkIndex(42) 32
set ReverseWorkIndex(43) 31
set ReverseWorkIndex(44) 30
set ReverseWorkIndex(45) 29
set ReverseWorkIndex(46) 28
set ReverseWorkIndex(47) 27
set ReverseWorkIndex(48) 26
set ReverseWorkIndex(49) 25
set ReverseWorkIndex(50) 24
set ReverseWorkIndex(51) 23
set ReverseWorkIndex(52) 22
set ReverseWorkIndex(53) 21
set ReverseWorkIndex(54) 20


global HLTypes
# Home Librarian File types.  For tk_getOpenFile and tk_getSaveFile.
# [index] HLTypes!global variable

set HLTypes {
   {{Home Libraian} {.libr} {HL1X HL2X}}
}

global CurrentCardCatalog
# Currently open Card Catalog vBTree instance.  Used through the program
# whenever it is necessary to access the currently open file.
# [index] CurrentCardCatalog!global variable

set CurrentCardCatalog {}

global ToplevelsToClean
# List of toplevel widgets to be flushed on library close
# [index] ToplevelsToClean!global variable

set ToplevelsToClean {}


global CopyBuffer
# Buffer for selection copying.
# [index] CopyBuffer!global variable

set CopyBuffer {}

image create photo cabEnd -file [file join $LibDir base.gif]
# Cabinate end image.  This is where the drawer comes out of the cabinate.
# [index] cabEnd!image

image create photo cardsMiddle -file [file join $LibDir finger.gif]
# Card middle image.  This is the middle, where the cards change their ``lean''
# from left to right and where the librarian's finger is.
# [index] cardsMiddle!image

image create photo handleEnd -file [file join $LibDir handle.gif]
# Drawer handle.  This is the handle end of the drawer.
# [index] handleEnd!image

image create photo cardsLeft -file [file join $LibDir left.gif]
# Cards leaning to the left.
# [index] cardsLeft!image

image create photo cardsRight -file [file join $LibDir right.gif]
# Cards leaning to the right.
# [index] cardsRight!image

image create photo DeepwoodsBanner -file [file join $LibDir DeepwoodsBanner.gif]
# Deepwoods banner image.  Used in the splash screen.
# [index] DeepwoodsBanner!image

image create photo LargeFace -file [file join $LibDir ffront.gif]
# Large size librarian face image.  Used on the main GUI when things are 
# ``idle''.
# [index] LargeFace!image

image create photo LargeProfile -file [file join $LibDir fside.gif]
# Large size librarian profile image.  Used on the main GUI when things are
# ``working''.
# [index] LargeProfile!image

image create photo SmallFace -file [file join $LibDir ffrontSmall.gif]
# Small size librarian face image.  Used on dialog boxes.
# [index] SmallFace!image

image create photo SmallProfile -file [file join $LibDir fsideSmall.gif]
# Small size librarian profile image.  Available for special dialog boxes.
# [index] SmallProfile!image

package require printer

package require hllibr

package require balloon

package require HL20_dialogs

package require HL20_editForm

package require HL20_Export

package require HL20_Import

package require HL20_PrintLibr

package require HL20_searchFrame

package require HL20_Registration

package require HL20_Help

package require HL20_PrLayout

# procedure to show window .
proc TopWindow {} {
  # This function creates the main toplevel window, which is where the main
  # GUI lives.  This window has three parts:
  # <Top Frame> Contains the librarian face (idle) or profile (working) and the
  #             current status message (idle) or working animation (working).
  # <Main Frame> Contains one of three GUIs. The ``Open Frame'' -- buttons
  #              to search, edit, or create a database file and a button to
  #              exit. The ``Search Frame'' -- used to search a database.  And
  #              the ``Edit Frame'' -- used to edit a database file.
  # <Aux Frame> Contains the name of the currently open file, if any.
  # [index] TopWindow!procedure

  global help_tips

  # Window manager configurations
  wm title . {Home Librarian V2.0}
  wm geometry . "510x500"
  wm protocol . WM_DELETE_WINDOW DoExit
  wm protocol . WM_SAVE_YOURSELF CloseCurrentLibrary

  bind . <Help> {AboutHomeLibrarian}

  global tk_version
  if {$tk_version >= 8.0} {
    menu .menuBar -tearoff 0
  } else {
  # build widget .menuBar
  frame .menuBar \
    -borderwidth {2} \
    -relief {raised}
  }

  if {$tk_version >= 8.0} {
    .menuBar add cascade \
       -label {File} -underline {0} -menu .menuBar.file
    set help_tips(.menuBar,0) {General File menu}
    set fm {.menuBar.file}
  } else {
  # build widget .menuBar.fileButton
  menubutton .menuBar.fileButton \
    -menu {.menuBar.fileButton.m} \
    -padx {4} \
    -pady {3} \
    -text {File} \
    -underline {0}
  set fm {.menuBar.fileButton.m}
  set help_tips(.menuBar.fileButton) {General File menu}
  }

  # build widget $fm
  menu $fm \
    -tearoff {0}
  $fm add command \
    -label {New...} \
    -command {CreateNewLibrary} \
    -underline {0}
  set help_tips($fm,0) {Create a new library to edit}
  $fm add command \
    -label {Open...} \
    -command {OpenOldLibrary} \
    -underline {0}
  set help_tips($fm,1) {Open an existing Library to edit}
  $fm add command \
    -label {Import...} \
    -command {ImportLibrary}
  set help_tips($fm,2) \
		{Import a Library from a external format to edit}
  $fm add command \
    -label {Search...} \
    -command {SearchOldLibrary}
  set help_tips($fm,3) {Search an exiting library}
  $fm add command \
    -label {Close} \
    -command {CloseCurrentLibrary} \
    -state {disabled} \
    -underline {0}
  set help_tips($fm,4) {Close the currently opened library}
  $fm add command \
    -label {Print...} \
    -command {PrintCurrentLibrary} \
    -state {disabled} \
    -underline {0}
  set help_tips($fm,5) {Print the current library}
  $fm add command \
    -label {Export...} \
    -command {ExportCurrentLibrary} \
    -state {disabled}
  set help_tips($fm,6) \
	{Export the current library to an external format}
  $fm add command \
    -label {Exit} \
    -command {DoExit} \
    -underline {1}
  set help_tips($fm,7) {Exit from the program}

  if {$tk_version >= 8.0} {
    .menuBar add cascade \
       -label {Edit} -underline {0} -menu .menuBar.edit
    set em {.menuBar.edit}
    set help_tips(.menuBar,1) {General Edit menu}
  } else {
  # build widget .menuBar.editButton
  menubutton .menuBar.editButton \
    -menu {.menuBar.editButton.m} \
    -padx {4} \
    -pady {3} \
    -text {Edit} \
    -underline {0}
  set help_tips(.menuBar.editButton) {General Edit menu}
  set em {.menuBar.editButton.m}
  }

  # build widget $em
  menu $em \
    -tearoff {0}
  $em add command \
    -label {Can't Undo} \
    -state {disabled} \
    -underline {0}
  set help_tips($em,0) {Undo not implemented}
  $em add separator
  $em add command \
    -label {Paste} \
    -state {disabled} \
    -underline {0} \
    -command {EditPaste}
  set help_tips($em,2) {Paste from clipboard}
  $em add command \
    -label {Copy} \
    -state {disabled} \
    -underline {0} \
    -command {EditCopy}
  set help_tips($em,3) {Copy to clipboard}
  $em add command \
    -label {Cut} \
    -state {disabled} \
    -underline {0} \
    -command {EditCut}
  set help_tips($em,4) {Cut to clipboard}
  $em add command \
    -label {Delete} \
    -state {disabled} \
    -underline {0} \
    -command {EditDelete}
  set help_tips($em,5) {Cut}
  $em add separator
  $em add command \
    -label {Select All} \
    -command {EditSelectAll}
  set help_tips($em,7) {Select all}
  $em add command \
    -label {Deselect All} \
    -state {disabled} \
    -command {EditDeselectAll}
  set help_tips($em,8) {Select none}

  if {$tk_version >= 8.0} {
    .menuBar add cascade \
      -label {View} -underline {0} -menu .menuBar.view
    set vm {.menuBar.view}
    set help_tips(.menuBar,2) {View parameter menu}
  } else {
  # build widget .menuBar.viewButton
  menubutton .menuBar.viewButton \
    -menu {.menuBar.viewButton.m} \
    -padx {4} \
    -pady {3} \
    -text {View} \
    -underline {0}
  set help_tips(.menuBar.viewButton) {View parameter menu}
  set vm {.menuBar.viewButton.m}
  }

  # build widget $vm
  menu $vm \
    -tearoff {0}
  $vm add command \
    -label {Show Registration} \
    -command {hl_DisplayRegistration}
  set help_tips($vm,0) {Show the current registration information}
  $vm add command \
    -label {Register Home Librarian} \
    -command {hl_Register}
  set help_tips($vm,1) {Enter registration information}

  if {$tk_version >= 8.0} {
    .menuBar add cascade \
      -label {Special} -underline {0} -menu .menuBar.special
    set sm {.menuBar.special}
    set help_tips(.menuBar,3) {Special functions menu}
  } else {
  # build widget .menuBar.specialButton
  menubutton .menuBar.specialButton \
    -menu {.menuBar.specialButton.m} \
    -padx {4} \
    -pady {3} \
    -text {Special} \
    -underline {0}
  set help_tips(.menuBar.specialButton) {Special functions menu}
  set sm {.menuBar.specialButton.m}
  }

  # build widget $sm
  menu $sm \
    -tearoff {0}
  $sm add command \
    -label {Convert a V1 library to V2} \
    -command {ConvertV1ToV2}
  set help_tips($sm,0) {Convert a V1 library to a V2 library}
  $sm add separator
  $sm add command \
    -label {Edit or Create a Print Layout file} \
    -command {hl_printLayout}
  set help_tips($sm,2) {Edit or Create a Print Layout file}
  $sm add separator
  $sm add command \
    -label {Define a new Card Type} \
    -command {DefineNewCardType} \
    -state {disabled}
  set help_tips($sm,4) {Define a new user-defined card type}
  $sm add command \
    -label {Define a new Location Type} \
    -command {DefineNewLocationType} \
    -state {disabled}
  set help_tips($sm,5) {Define a new user-defined location type}
  $sm add command \
    -label {Define a new Category} \
    -command {DefineNewCategory} \
    -state {disabled}
  set help_tips($sm,6) {Define a new user-defined caregory}
  $sm add separator
  $sm add command \
    -label {Create a template Card} \
    -command {CreateTemplateCard} \
    -state {disabled}
  set help_tips($sm,8) {Create a template Card}
  $sm add command \
    -label {Edit a template Card} \
    -command {EditTemplateCard} \
    -state {disabled}
  set help_tips($sm,9) {Edit a template Card}
  $sm add command \
    -label {Remove a template Card} \
    -command {RemoveTemplateCard} \
    -state {disabled}
  set help_tips($sm,10) {Remove a template Card}
  $sm add separator
  $sm add command \
    -label {Save Card template} \
    -command {SaveCardTemplate} \
    -state {disabled}
  set help_tips($sm,12) {Save a card template}
  $sm add command \
    -label {Load Card templates} \
    -command {LoadCardTemplates} \
    -state {disabled}
  set help_tips($sm,13) {Load card templates}
  
  if {$tk_version >= 8.0} {
    .menuBar add cascade \
       -label {Windows} -underline {0} -menu .menuBar.windows
    set wm {.menuBar.windows}
    set help_tips(.menuBar,4) {Select window to be the topmost}
  } else {
  # build widget .menuBar.windowsButton
  menubutton .menuBar.windowsButton \
     -menu {.menuBar.windowsButton.m} \
     -padx {4} \
     -pady {3} \
     -text {Windows} \
     -underline {0}
  set help_tips(.menuBar.windowsButton) {Select window to be the topmost}
  set wm {.menuBar.windowsButton.m}
  }

  # build widget $wm
  menu $wm \
     -tearoff {0}
  $wm add command \
     -label "[wm title .]" \
     -command {
	wm deiconify .
	raise .
     }
  set help_tips($wm,0) \
	"Select [wm title .] window to be topmost"

  if {$tk_version >= 8.0} {
    .menuBar add cascade \
      -label {Help} -underline {0} -menu .menuBar.help
    set hm {.menuBar.help}
    set help_tips(.menuBar,5) {Help menu}
  } else {
  # build widget .menuBar.helpButton
  menubutton .menuBar.helpButton \
    -menu {.menuBar.helpButton.m} \
    -padx {4} \
    -pady {3} \
    -text {Help} \
    -underline {0}
  set help_tips(.menuBar.helpButton) {Help menu}
  set hm {.menuBar.helpButton.m}
  }

  # build widget $hm
  menu $hm \
    -tearoff {0}
  $hm add checkbutton \
    -label {Show Help Tips} \
    -offvalue 0 \
    -onvalue 1 \
    -variable use_balloons  
  set help_tips($hm,0) {Enable and disable help tips}
  $hm add separator
  $hm add command \
    -label {About...} \
    -underline {0} \
    -command {AboutHomeLibrarian}
  set help_tips($hm,2) {About Home Librarian}
  $hm add command \
    -label {Version...} \
    -underline {0} \
    -command {HomeLibrarianVersion}
  set help_tips($hm,3) {Home Librarian Version}
  $hm add separator
  $hm add command \
    -label {Copying...} \
    -command {HomeLibrarianCopying}
  set help_tips($hm,5) {Home Librarian Copyright information}
  $hm add command \
    -label {Warranty...} \
    -command {HomeLibrarianWarranty}
  set help_tips($hm,6) {Home Librarian Warranty information}
  $hm add command \
    -label {Registering...} \
    -command {HomeLibrarianRegistering}
  set help_tips($hm,6) {Home Librarian Registration information}

  # build widget .topFrame
  frame .topFrame \
    -highlightthickness 0 \
    -borderwidth 0 

  # build widget .topFrame.face
  label .topFrame.face \
    -borderwidth {4} \
    -height {100} \
    -relief {ridge} \
    -highlightthickness 0 \
    -image {LargeFace} \
    -width {100}

  # build widget .topFrame.cf
  frame .topFrame.cf \
    -borderwidth {4} \
    -relief {ridge} \
    -highlightthickness 0

  # build widget .topFrame.cf.workCanvas
  canvas .topFrame.cf.workCanvas \
    -borderwidth {0} \
    -height {100} \
    -relief {flat} \
    -highlightthickness 0 \
    -selectborderwidth 0 \
    -width {400} \
    -background white
  enable_balloon .topFrame.cf.workCanvas
  set help_tips(.topFrame.cf.workCanvas) {This is the work / status area}

  label .topFrame.cf.fill \
  	-relief flat \
	-background yellow \
	-highlightthickness 0 \
	-text {}

  # build widget .mainFrame
  frame .mainFrame \
    -borderwidth {4} \
    -height {300} \
    -relief {ridge} \
    -width {500}

  # build widget .auxFrame
  frame .auxFrame \
    -borderwidth {4} \
    -height {75} \
    -relief {ridge} \
    -width {500}

  # build widget .auxFrame.messages
  message .auxFrame.messages \
    -aspect {1500} \
    -padx {5} \
    -pady {2} \
    -relief {raised}
  enable_balloon .auxFrame.messages
  set help_tips(.auxFrame.messages) {Shows the currently opened library and its open status}

  if {$tk_version < 8.0} {
  # pack master .menuBar
  pack configure .menuBar.fileButton \
    -side left
  pack configure .menuBar.editButton \
    -side left
  pack configure .menuBar.viewButton \
    -side left
  pack configure .menuBar.specialButton \
    -side left
  pack configure .menuBar.windowsButton \
    -side left
  pack configure .menuBar.helpButton \
    -side right
  }

  # pack master .topFrame.cf
  pack configure .topFrame.cf.workCanvas \
    -side left
  pack configure .topFrame.cf.fill \
    -side right \
    -expand 1 \
    -fill both

  # pack master .topFrame
  pack configure .topFrame.face \
    -side left
  pack configure .topFrame.cf \
    -side right \
    -expand 1 \
    -fill both

  # pack master .auxFrame
  pack configure .auxFrame.messages \
    -expand 1 \
    -fill both

  # pack master .
  if {$tk_version >= 8.0} {
    . configure -menu .menuBar
  } else {
  pack configure .menuBar \
    -fill x
  }
  pack configure .topFrame \
    -fill x
  pack configure .mainFrame \
    -expand 1 \
    -fill both
  pack configure .auxFrame \
    -fill both

}

proc AddTopLevel {w} {
  # Add w to the list of selectable toplevel windows under the ``Windows''
  # menu.
  # <in> w -- toplevel window to add
  # [index] AddTopLevel!procedure

  global help_tips
  global tk_version
  if {$tk_version >= 8.0} {
    set wm {.menuBar.windows}
  } else {
    set wm {.menuBar.windowsButton.m}
  }
  $wm add command \
      -label "[wm title $w]" \
      -command "wm deiconify $w;raise $w"
# Skip the help tips -- this becomes problematical when windows are deleted
# out of order.
#  set help_tips($wm,[$wm index "[wm title $w]"]) \
#	"Select [wm title $w] window to be topmost"
  global ToplevelsToClean
  lappend ToplevelsToClean $w
}

proc RemoveTopLevel {w} {
  # Remove w from the list of selectable toplevel windows under the 
  # ``Windows'' menu.  Destroy the window while we are at it.
  # <in> w -- toplevel window to remove
  # [index] RemoveTopLevel!procedure

  global help_tips
  global tk_version
  if {$tk_version >= 8.0} {
    set wm {.menuBar.windows}
  } else {
    set wm {.menuBar.windowsButton.m}
  }
# Skip the help tips -- this becomes problematical when windows are deleted
# out of order.
#  unset help_tips($wm,[$wm index "[wm title $w]"])
  catch [list $wm delete "[wm title $w]"]
  catch "destroy $w"
  global ToplevelsToClean
  set elt [lsearch -exact "$ToplevelsToClean" $w]
  set ToplevelsToClean "[lreplace $ToplevelsToClean $elt $elt]"
}

proc openFrame {} {
  # Create the startup GUI (open a file).
  #
  # This frame has four buttons.  All four duplicate functions available
  # from the File menu.
  # <Search An Old Library> Open an old database file read-only and load the 
  #                         search frame.
  # <Create a New Library> Create a new database file and open it read-write
  #                        and load the edit frame.
  # <Edit An Old Librarry> Open an old database file read-write and load the 
  #                        edit frame.
  # <Can you show me where the Exit is?> Exit the program.  A confirmation
  #			   dialog box is popped up to confirm the exit.
  # [index] openFrame!procedure

  global help_tips

  # build widget .mainFrame.openFrame
  frame .mainFrame.openFrame \
    -borderwidth {2} \
    -height {296} \
    -relief {raised} \
    -width {496}

  # build widget .mainFrame.openFrame.button2
  button .mainFrame.openFrame.button2 \
    -background {yellow} \
    -activeforeground {yellow} \
    -font {-Adobe-Helvetica-Bold-R-Normal-*-34-*-*-*-*-*-*-*} \
    -foreground {brown} \
    -activebackground {brown} \
    -command {SearchOldLibrary} \
    -text {Search An Old Library}
  set help_tips(.mainFrame.openFrame.button2) {Search an exiting library}

  # build widget .mainFrame.openFrame.button3
  button .mainFrame.openFrame.button3 \
    -background {yellow} \
    -activeforeground {yellow} \
    -font {-Adobe-Helvetica-Bold-R-Normal--34-*-*-*-*-*-*-*} \
    -foreground {brown} \
    -activebackground {brown} \
    -command {CreateNewLibrary} \
    -text {Create a New Library}
  set help_tips(.mainFrame.openFrame.button3) {Create a new library to edit}

  # build widget .mainFrame.openFrame.button4
  button .mainFrame.openFrame.button4 \
    -background {yellow} \
    -activeforeground {yellow} \
    -font {-Adobe-Helvetica-Bold-R-Normal--34-*-*-*-*-*-*-*} \
    -foreground {Brown} \
    -activebackground {brown} \
    -command {OpenOldLibrary} \
    -text {Edit An Old Librarry}
  set help_tips(.mainFrame.openFrame.button4) {Open an existing Library to edit}

  # build widget .mainFrame.openFrame.button5
  button .mainFrame.openFrame.button5 \
    -background {yellow} \
    -activeforeground {yellow} \
    -command {DoExit} \
    -font {-Adobe-Helvetica-Bold-R-Normal--34-*-*-*-*-*-*-*} \
    -foreground {Red} \
    -activebackground {red} \
    -text "Can you show me\nwhere the Exit is?"
  set help_tips(.mainFrame.openFrame.button5) {Exit from the program}


  # pack master .mainFrame.openFrame
  pack configure .mainFrame.openFrame.button2 \
    -expand 1
  pack configure .mainFrame.openFrame.button3 \
    -expand 1
  pack configure .mainFrame.openFrame.button4 \
    -expand 1
  pack configure .mainFrame.openFrame.button5 \
    -expand 1



}

proc SplashScreen {} {
  # Build the ``Splash Screen'' -- A popup window that tells the user what 
  # we are all about.  It gives the version and brief copyright information.
  #
  # The upper part of the spash screen gives the brief information, with
  # directions on how to get detailed information.  The lower part contains
  # an image banner for Deepwoods Software.
  # [index] SplashScreen!procedure

  global help_tips
  # build widget .hlSpash
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .hlSpash"
  } {
    catch "destroy .hlSpash"
  }
  toplevel .hlSpash 

  # Window manager configurations
  wm positionfrom .hlSpash program
  wm sizefrom .hlSpash program
  wm resizable .hlSpash 0 0
  wm geometry .hlSpash "+[expr ([winfo screenwidth .] / 2) - 254]+[expr ([winfo screenheight .] / 2) - 92]"
  wm title .hlSpash {Home Librarian 2.0}
  wm transient .hlSpash .

  bind .hlSpash <1> {
      if {"[info procs XFEdit]" != ""} {
        catch "XFDestroy .hlSpash"
      } {
        catch "destroy .hlSpash"
      }
    }
  enable_balloon .hlSpash
  set help_tips(.hlSpash) {Click anywhere to dismis splash window.}

  # build widget .hlSpash.frame1
  frame .hlSpash.frame1 \
    -background {#2ba2bf}

  # build widget .hlSpash.frame1.label4
  label .hlSpash.frame1.label4 \
    -background {#2ba2bf} \
    -image SmallFace

  # build widget .hlSpash.frame1.message5
  message .hlSpash.frame1.message5 \
    -background {#2ba2bf} \
    -foreground {white} \
    -aspect {1500} \
    -font {-adobe-times-medium-r-*-*-*-100-*-*-*-*-*-*} \
    -padx {5} \
    -pady {2} \
    -text {Home Librarian Version 2.0, Copyright (C) 1992-1998 Robert Heller D/B/A Deepwoods Software
Home Librarian comes with ABSOLUTELY NO WARRENTY; for details select 'Warrenty...' under
the Help menu.  This is free software, and you are welcom to redistribute it under certain
conditions; select 'Copying...' under the Help menu.  You can get technical support for a
$25 shareware fee; for details select 'Registering...' under the Help menu.}

  # build widget .hlSpash.frame2
  frame .hlSpash.frame2 \
    -background {#2ba2bf}

  # build widget .hlSpash.frame2.label3
  label .hlSpash.frame2.label3 \
    -background {#2ba2bf} \
    -image {DeepwoodsBanner}

  # pack master .hlSpash.frame1
  pack configure .hlSpash.frame1.label4 \
    -expand 1 \
    -side left
  pack configure .hlSpash.frame1.message5 \
    -fill x \
    -side right

  # pack master .hlSpash.frame2
  pack configure .hlSpash.frame2.label3

  # pack master .hlSpash
  pack configure .hlSpash.frame1 \
    -expand 1 \
    -fill both
  pack configure .hlSpash.frame2 \
    -fill x
# end of widget tree


}


proc CenterText {W Size Color Text {tag Message}} {
  # Put a centered chunk of text in the specified canvas window.  Used to
  # display status information.
  #
  # Arguments are:
  # <in> W -- canvas widget
  # <in> Size -- point size to use
  # <in> Color -- the color for the text
  # <in> Text -- the text to display
  # <in> tag -- the tag to assign the text
  # [index] CenterText!procedure

  set font "-*-new century schoolbook-bold-i-*-*-$Size-*-*-*-*-*-*-*"
  set CX [expr [$W cget -width] / 2.0]
  set CY [expr [$W cget -height] / 2.0]
  set x [$W create text $CX $CY -anchor center -font "$font" -fill "$Color" -text "$Text" -tag $tag]
  return $x
}


proc DoExit {} {
  # Do a ``careful'' exit.  Check for an open and writable library -- confirm
  # a save of this file.  Otherwise confirm the exit itself.
  # [index] DoExit!procedure

  global CurrentCardCatalog
  set dirty 0
  if {[string compare "$CurrentCardCatalog" {}] != 0} {
    if {[$CurrentCardCatalog writable]} {
      set dirty 1
    }
  }
  if {$dirty} {
    set answer [hl_dialog .exitbox "Really Exit?" \
"You have an open writable library, do you want to save it and exit exit?" \
	questhead 2 {Yes, don't save} {Yes, save current library} {No}]
    if {$answer == 0} {
	exit
    } elseif {$answer == 1} {
	$CurrentCardCatalog delete
	exit
    }
  } else {
    set answer [hl_dialog .exitbox "Really Exit?" "Do you really want to exit?" \
 	        questhead 1 {Yes} {No}]
    if {$answer == 0} {exit}
  }
}

proc IsIntegerGTZero {x} {
  # Check to see if its argument is in fact an integer greater than zero.
  #
  # Arguments:
  # <in> x -- the possible integer string.
  # [index] IsIntegerGTZero!procedure

  if {[catch "expr int($x)" xInt]} {
    return 0
  } else {
    if {$xInt != $x} {
      return 0
    } elseif {$xInt <= 0} {
      return 0
    } else {
      return 1
    }
  }
}

proc CloseCurrentLibrary {} {
  # Close the current library and restore the openFrame.
  # [index] CloseCurrentLibrary!procedure

  global CurrentCardCatalog
  if {[string compare "$CurrentCardCatalog" {}] == 0} {return}
  global ToplevelsToClean
  foreach w $ToplevelsToClean {catch "RemoveTopLevel $w"}
  $CurrentCardCatalog delete
  set CurrentCardCatalog {}
  foreach f [winfo children .mainFrame] {
    pack forget $f
  }
  pack configure .mainFrame.openFrame -expand 1 -fill both
  .auxFrame.messages configure -text {}
  global tk_version
  if {$tk_version >= 8.0} {
    set fm {.menuBar.file}
  } else {
    set fm {.menuBar.fileButton.m}
  }
  $fm entryconfigure {New...} -state normal
  $fm entryconfigure {Open...} -state normal
  $fm entryconfigure {Import...} -state normal
  $fm entryconfigure {Search...} -state normal
  $fm entryconfigure {Close} -state disabled
  $fm entryconfigure {Print...} -state disabled
  $fm entryconfigure {Export...} -state disabled
  if {$tk_version >= 8.0} {
    set sm {.menuBar.special}
  } else {
    set sm {.menuBar.specialButton.m}
  }
  $sm entryconfigure {Define a new Card Type} -state disabled
  $sm entryconfigure {Define a new Location Type} -state disabled
  $sm entryconfigure {Define a new Category} -state disabled
  $sm entryconfigure {Create a template Card} -state disabled
  $sm entryconfigure {Edit a template Card} -state disabled
  $sm entryconfigure {Remove a template Card} -state disabled
  $sm entryconfigure {Save Card template} -state disabled
  $sm entryconfigure {Load Card templates} -state disabled
  global Work
  $Work delete Message
  CenterText $Work 34 brown "How May I Help You?" 
}

proc Working {{worktime 10}} {
  # Run the working busy wait animation.  This proc is called from a timed
  # after event.  Each time it is called, it uses WorkingIndex to select its
  # function.  After performing its function, it increments WorkingIndex and
  # submits a fresh timed after event.
  # [index] Working!procedure

  global Work
  global WorkingIndex  
  global WorkingAfterId
  global ReverseWorkIndex
  set width [$Work cget -width]
  switch -exact $WorkingIndex {
    0 {
	# start up index.  Clear out the canvas and then display a closed
	# drawer.
	$Work delete all
	$Work create image [expr $width - 20] 0 -image cabEnd -anchor nw -tag CabEnd
	$Work create image [expr $width - 40] 0 -image handleEnd -anchor nw -tag Handle
      }
    1 -
    2 -
    3 -
    4 -
    5 -
    6 -
    7 -
    8 -
    9 -
   10 -
   11 -
   12 -
   13 -
   14 -
   15 -
   16 -
   17 -
   18 {
	# Phase one: open the drawer, full of cards leaning to the right.
	$Work move Handle -20 0
	set offset [expr $width - (($WorkingIndex * 20) + 20)]
	$Work create image $offset 0 -image cardsRight -anchor nw -tag "CardsRight Batch$WorkingIndex"
      }
   19 -
   20 -
   21 -
   22 -
   23 -
   24 -
   25 -
   26 -
   27 -
   28 -
   29 -
   30 -
   31 -
   32 -
   33 -
   34 -
   35 -
   36 {
	# Phase two: flip the cards to the left, one by one.
	set x $ReverseWorkIndex($WorkingIndex)
	set index "[$Work find withtag CardsMiddle]"
	if {[llength "$index"] > 0} {
	  $Work itemconfigure $index -image cardsLeft -tags "CardsLeft Batch$WorkingIndex"
	}
	set index [$Work find withtag "Batch$x"]
	$Work itemconfigure $index -image cardsMiddle -tags CardsMiddle
      }
    37 {
	# Phase three: delete the middle card and start closing the drawer.
	$Work delete CardsMiddle
	$Work move CardsLeft +20 0
	$Work move Handle +20 0
       } 
    38 -
    39 -
    40 -
    41 -
    42 -
    43 -
    44 -
    45 -
    46 -
    47 -
    48 -
    49 -
    50 -
    51 -
    52 -
    53 -
    54 {
	# Phase four: close the drawer.
	$Work delete Batch$ReverseWorkIndex($WorkingIndex)
	$Work move CardsLeft +20 0
	$Work move Handle +20 0
       }
  }
  incr WorkingIndex
  if {$WorkingIndex > 54} {set WorkingIndex 1}
  if {$worktime > 0} {
    set WorkingAfterId [after $worktime "Working $worktime"]
  } else {
    update
  }
}

proc SetWatchCursor {w} {
  # Set the cursor to be the ``busy' cursor for the specified widget and all 
  # of its children.
  #
  # Arguments:
  # <in> w -- top of widget tree to traverse.
  # [index] SetWatchCursor!procedure

  global tcl_version
  global tcl_platform
  set cur watch

  set cc "[$w cget -cursor]"
  if {[string compare "$cc" {}] != 0 &&
      [string compare "$cc" $cur] != 0} {
    $w configure -cursor $cur
  }
  foreach c [pack slaves $w] {SetWatchCursor $c}
}

proc ResetCursor {w} {
  # Reset the cursor for the specified widget and all of its 
  # children.
  #
  # Arguments:
  # <in> w -- top of widget tree to traverse.
  # [index] ResetCursor!procedure

  global tcl_version
  global tcl_platform
  set cur watch

  set cc "[$w cget -cursor]"
  if {[string compare "$cc" $cur] == 0} {
     $w configure -cursor "[lindex [$w configure -cursor] 3]"
  }
  foreach c [pack slaves $w] {ResetCursor $c}
}

proc StartWorking {{worktime 10}} {
  # Start the working animation.  While busy, disable the whole GUI without
  # fading anything.  This is done by putting a grab on the canvas window,
  # which has no binding (other than for balloon help).
  # [index] StartWorking!procedure

  global Work
  global WorkingIndex
  global WorkingAfterId
  set WorkingIndex 0
  global tcl_version
  global tcl_platform
  . configure -cursor watch

  SetWatchCursor .
  grab set $Work
  .topFrame.face configure -image {LargeProfile}
  Working $worktime
}

proc EndWorking {{message {How May I Help You?}}} {
  # End the working animation. The animation timed event is canceled, the
  # status window is restored, complete with a current status message.  The 
  # cursor is restored and the grab released.
  # 
  # <in> message -- the message to display in the status window.
  # [index] EndWorking!procedure

  global Work
  global WorkingAfterId
  catch "after cancel $WorkingAfterId"
  set WorkingAfterId {}
  $Work delete all
  $Work create rectangle 0 0 \
	[$Work cget -width] [$Work cget -height] \
	-fill yellow -outline {}
  CenterText $Work 34 brown "$message"
  .topFrame.face configure -image {LargeFace}
  set cg "[grab current]"
  foreach gw $cg {
    grab release $gw
  }
  ResetCursor .
}


proc ConvertV1ToV2 {} {
  # Convert a V1 library to a V2 library.  This is done by traversing the old
  # database's trees and inserting the records in the new tree.
  # [index] ConvertV1ToV2!procedure

  global HLTypes
  set infile [tk_getOpenFile -defaultextension {.libr} \
			     -title "Select an old library file name" \
			     -filetypes $HLTypes]
  if {[string length "$infile"] == 0} {return}
  if {[catch [list vBTree "$infile" ReadOnly] oldTree]} {
    hl_error $oldTree
    return
  }
  set outfile [tk_getSaveFile -defaultextension {.libr} -initialfile new.libr \
			      -title "Select a new library name" \
			      -filetypes $HLTypes]
  if {[string length "$outfile"] == 0} {return}
  set numberOfPages [$oldTree countpages]
  if {[catch [list vBTree "$outfile" {Create|ReadWrite} $numberOfPages] newTree]} {
    $oldTree delete
    hl_error $newTree
    return
  }
  StartWorking
  $oldTree traverseid "Copy1Card {%k} %i $newTree"
  $oldTree traverseauthor "Copy1List {%k} %i insertauthor $newTree"
  $oldTree traversetitle "Copy1List {%k} %i inserttitle $newTree"
  $oldTree traversesubj "Copy1List {%k} %i insertsubject $newTree"
  $oldTree delete
  $newTree delete
  EndWorking
}

proc Copy1Card {idkey card newtree} {
  # Copy a card from one vBTree file to another.
  #
  # Arguments:
  # <in> idkey -- the card's id key.
  # <in> card -- the card record.
  # <in> newtree -- the output tree.
  # [index] Copy1Card!procedure

  $newtree insertid "$idkey" $card
}

proc Copy1List {key list ifunc newtree} {
  # Copy a list from one vBTree file to another.
  #
  # Arguments:
  # <in> idkey -- the list's id key.
  # <in> list -- the list record.
  # <in> ifunc -- the insert function.
  # <in> newtree -- the output tree.
  # [index] Copy1List!procedure

  $newtree $ifunc "$key" "$list"
}

proc CompareAuthors {a b} {
  # Compare two author strings.  Author strings are of three forms:
  # ``First Last'', ``Last, First'', ``First Last, more...''.  Authors
  # are always sorted by last name then by first.
  #
  # Auguments:
  # <in> a -- first author.
  # <in> b -- second author.
  # [index] CompareAuthors!procedure

  if {[string first {,} "$a"] < 0} {
    set lastA [lindex "$a" 1]
    set firstA [lindex "$a" 0]
  } else {
    set aa "[split $a {,}]"
    set lastA [string trim [lindex "$aa" 0]]
    if {[llength "$lastA"] > 1} {
      set a1 "$lastA"
      set lastA [lindex "$a1" 1]
      set firstA [lindex "$a1" 0]
    } else {
      set firstA [string trim [lindex "$aa" 1]]
    }
  }
  if {[string first {,} "$b"] < 0} {
    set lastB [lindex "$b" 1]
    set firstB [lindex "$b" 0]
  } else {
    set bb "[split $b {,}]"
    set lastB [string trim [lindex "$bb" 0]]
    if {[llength "$lastB"] > 1} {
      set b1 "$lastB"
      set lastB [lindex "$b1" 1]
      set firstB [lindex "$b1" 0]
    } else {
      set firstB [string trim [lindex "$bb" 1]]
    }
  }
  set comp [string compare $lastA $lastB]
  if {$comp == 0} {
    set comp [string compare $firstA $firstB]
  }
  return $comp
}

proc ComareCLPairs1 {a b} {
  # Compare elements for the results of Expand... functions.  The list
  # elements are also lists, the first element is an id key, the second element
  # is the author, and the third element is the title.
  #
  # Arguments:
  # <in> a -- first element
  # <in> b -- second element
  # [index] ComareCLPairs1!procedure

  set comp [CompareAuthors "[string tolower [lindex $a 1]]" \
  			   "[string tolower [lindex $b 1]]"]
  if {$comp != 0} {return $comp}
  set comp [string compare "[string tolower [lindex $a 2]]" \
  			   "[string tolower [lindex $b 2]]"]
  if {$comp != 0} {return $comp}
  if {[llength "$a"] < 4} {return $comp}
  set comp [string compare "[string tolower [lindex $a 3]]" \
  			   "[string tolower [lindex $b 3]]"]
  return $comp
}

proc ComareCLPairs2 {a b} {
  # Compare elements for the results of Expand... functions.  The list
  # elements are also lists, the first element is an id key, the second element
  # is the title, and the third element is the author.
  #
  # Arguments:
  # <in> a -- first element
  # <in> b -- second element
  # [index] ComareCLPairs2!procedure

  set comp [string compare "[string tolower [lindex $a 1]]" \
  			   "[string tolower [lindex $b 1]]"]
  if {$comp != 0} {return $comp}
  set comp [CompareAuthors "[string tolower [lindex $a 2]]" \
  			   "[string tolower [lindex $b 2]]"]
  if {$comp != 0} {return $comp}
  if {[llength "$a"] < 4} {return $comp}
  set comp [string compare "[string tolower [lindex $a 3]]" \
  			   "[string tolower [lindex $b 3]]"]
  return $comp
}

proc SortCardList {cardList {authorIndex 1}} {
  # Sort a list of cards elements.
  #
  # Arguments:
  # <in> cardList -- the card list
  # <in> authorIndex (default = 1) -- the index of the author element.
  # [index] SortCardList!procedure

  return "[lsort -command ComareCLPairs$authorIndex $cardList]"
}

proc regQuote {s} {
  # Quote a string for use in a regular expression.
  #
  # Arguments:
  # <in> s -- the string to be quoted.
  # [index] regQuote!procedure

  if {[regsub -all {[][^$.+*?|()\-]} "$s" {\\&} ss] > 0} {
    return "$ss"
  } else {
    return "$s"
  }
}

proc ExpandAuthors {authorKeys} {
  # Expand a list of author keys to a list of cards.
  #
  # Arguments:
  # <in> authorKeys -- the author keys to expand.
  # [index] ExpandAuthors!procedure

  global CurrentCardCatalog
  set results {}
  foreach a $authorKeys {
    set aids "[$CurrentCardCatalog readauthorlist $a]"
    foreach aid $aids {
      if {[lsearch -regexp $results "^[regQuote $aid] "] < 0} {
	set card "[$CurrentCardCatalog readid $aid]"
	lappend results "[list $aid [$card author] [$card title]]"
	$card delete
      }
    }      
  }
  return "[SortCardList $results 1]"
}
  
proc ExpandTitles {titleKeys} {
  # Expand a list of title keys to a list of cards.
  #
  # Arguments:
  # <in> titleKeys -- the title keys to expand.
  # [index] ExpandTitles!procedure

  global CurrentCardCatalog
  set results {}
  foreach a $titleKeys {
    set aids "[$CurrentCardCatalog readtitlelist $a]"
    foreach aid $aids {
      if {[lsearch -regexp $results "^[regQuote $aid] "] < 0} {
	set card "[$CurrentCardCatalog readid $aid]"
	lappend results "[list $aid [$card title] [$card author]]"
	$card delete
      }
    }      
  }
  return "[SortCardList $results 2]"
}

proc ExpandSubjects {subjectKeys} {
  # Expand a list of subject keys to a list of cards.
  #
  # Arguments:
  # <in> subjectKeys -- the subject keys to expand.
  # [index] ExpandSubjects!procedure

  global CurrentCardCatalog
  set results {}
  foreach a $subjectKeys {
    set aids "[$CurrentCardCatalog readsubjectlist $a]"
    foreach aid $aids {
      if {[lsearch -regexp $results "^[regQuote $aid] "] < 0} {
	set card "[$CurrentCardCatalog readid $aid]"
	lappend results "[list $aid $a [$card author] [$card title]]"
	$card delete
      }
    }      
  }
  return "[SortCardList $results 1]"
}

proc EditPaste {} {
  # Implement the "Paste" Edit Menu item.
  # [index] EditPaste!procedure

  set focus "[focus]"
  if {[string length "$focus"] > 0} {
    catch "event generate $focus <<Paste>>"
  }
}

proc EditCopy {} {
  # Implement the "Copy" Edit Menu item.
  # [index] EditCopy!procedure

  set focus "[focus]"
  if {[string length "$focus"] > 0} {
    catch "event generate $focus <<Copy>>"
  }
}

proc EditCut {} {
  # Implement the "Cut" Edit Menu item.
  # [index] EditCut!procedure

  set focus "[focus]"
  if {[string length "$focus"] > 0} {
    catch "event generate $focus <<Cut>>"
  }
}

proc EditDelete {} {
  # Implement the "Delete" Edit Menu item.
  # [index] EditDelete!procedure

  set focus "[focus]"
  if {[string length "$focus"] > 0} {
    catch "event generate $focus <<Clear>>"
  }
}

proc EditClear {} {
  # Implement the "Clear" Edit Menu item.
  # [index] EditClear!procedure

  set focus "[focus]"
  if {[string length "$focus"] > 0} {
    catch "event generate $focus <<Clear>>"
  }
}

proc EditSelectAll {} {
  # Implement the "Select All" Edit Menu item.
  # [index] EditSelectAll!procedure

  set focus "[focus]"
  if {[string length "$focus"] > 0} {
    catch "event generate $focus <<SelectAll>>"
  }
}

proc EditDeselectAll {} {
  # Implement the "Deselect All" Edit Menu item.
  # [index] EditDeselectAll!procedure

  set focus "[focus]"
  if {[string length "$focus"] > 0} {
    catch "event generate $focus <<DeselectAll>>"
  }
}

proc Main {} {
  # Main program:  pop up the splash screen, then build the main GUI.
  # Get eventhing ready and pop up the main GUI.
  # [index] Main!procedure

  global Work
  SplashScreen
  wm withdraw .
  update idletasks
  TopWindow

  $Work create rectangle 0 0 \
	[$Work cget -width] [$Work cget -height] \
	-fill yellow -outline {}
  CenterText $Work 34 brown "How May I Help You?"

  if {![winfo exists .mainFrame.openFrame]} {openFrame}

  pack configure .mainFrame.openFrame \
    -expand 1 \
    -fill both

  init_balloons

  enable_balloon Radiobutton

  global use_balloons
  set use_balloons 0

  global tcl_platform
  global tk_version
  if {$tcl_platform(platform) == {unix}} {
    event add <<Copy>> <Control-Key-Insert>
    event add <<DeselectAll>> <Control-Key-backslash>
    event add <<SelectAll>> <Control-Key-slash>
    event add <<Cut>> <Shift-Key-BackSpace>
    event add <<Cut>> <Shift-Key-Delete>
    event add <<Paste>> <Shift-Key-Insert>
    event add <<Paste>> <2>
    event add <<Copy>> <ButtonRelease-1>
    if {$tk_version >= 8.0} {
      bind all <FocusIn> {CheckSelection .menuBar.edit}
    } else {
      bind all <FocusIn> {CheckSelection .menuBar.editButton.m}
    }
  }

  bind Text <<DeselectAll>> {%W tag remove sel 1.0 end}
  bind Text <<SelectAll>> {%W tag add sel 1.0 end-1char}
  bind Entry <<DeselectAll>> {%W selection clear}
  bind Entry <<SelectAll>> {%W selection range 0 end}
  bind Listbox <<DeselectAll>> {%W selection clear 0 end}  
#  bind Text <<Cut>> {HL20_textCut %W}
#  bind Text <<Copy>> {HL20_textCopy %W}
#  bind Text <<Paste>> {HL20_textPaste %W}
#  bind Entry <<Cut>> {HL20_entryCut %W}
#  bind Entry <<Copy>> {HL20_entryCopy %W}
#  bind Entry <<Paste>> {HL20_entryPaste %W}
#  bind Listbox <<Copy>> {HL20_listboxCopy %W}

  wm deiconify .
}


proc HL20_textCopy w {
# HL20_textCopy --
# This procedure copies the selection from a text widget into the
# clipboard.
#
# Arguments:
# w -		Name of a text widget.
# [index] HL20\_textCopy!procedure

  set selRange "[$w tag ranges sel]"
  if {[llength $selRange] == 0} {return 0}
  global CopyBuffer
  set CopyBuffer "[eval $w get $selRange]"
  selection  handle $w {HL20_HandleSelection}
  selection  own -command "HL20_TextDisOwnSelection $w" $w
  return 1
}


proc HL20_textCut w {
# HL20_textCut --
# This procedure copies the selection from a text widget into the
# clipboard, then deletes the selection (if it exists in the given
# widget).
#
# Arguments:
# w -		Name of a text widget.
# [index] HL20\_textCut!procedure

  if {[HL20_textCopy $w]} {
     event generate $w <<Clear>>
  }
}


proc HL20_textPaste w {
# HL20_textPaste --
# This procedure pastes the contents of the clipboard to the insertion
# point in a text widget.
#
# Arguments:
# w -		Name of a text widget.
# [index] HL20\_textPaste!procedure

    catch {
	$w insert insert [selection get -displayof $w]
    }
}

proc HL20_entryCopy w {
# HL20_entryCopy --
# This procedure copies the selection from a text widget into the
# clipboard.
#
# Arguments:
# w -		Name of a text widget.
# [index] HL20\_entryCopy!procedure

  if {![$w selection present]} {return 0}
  global CopyBuffer
  set CopyBuffer "[string range [$w get] [$w index sel.first] [expr [$w index sel.last] - 1]]"
  selection  handle $w {HL20_HandleSelection}
  selection  own -command "HL20_EntryDisOwnSelection $w" $w
  return 1
}


proc HL20_entryCut w {
# HL20_entryCut --
# This procedure copies the selection from a text widget into the
# clipboard, then deletes the selection (if it exists in the given
# widget).
#
# Arguments:
# w -		Name of a text widget.
# [index] HL20\_entryCut!procedure

  if {[HL20_entryCopy $w]} {
     event generate $w <<Clear>>
  }
}


proc HL20_entryPaste w {
# HL20_textPaste --
# This procedure pastes the contents of the clipboard to the insertion
# point in a text widget.
#
# Arguments:
# w -		Name of a text widget.
# [index] HL20\_entryPaste!procedure

    catch {
	$w insert insert [selection get -displayof $w]
    }
}

proc HL20_HandleSelection {offset maxBytes} {
  # Handle selection requests.
  #
  # Arguments:
  # <in> offset -- offset into the selection to begin
  # <in> maxBytes -- maximum number of bytes to return.
  # [index] HL20\_HandleSelection!procedure

  global CopyBuffer
  set remainder [expr [string length $CopyBuffer] - $offset]
  if {$remainder < $maxBytes} {
    set maxBytes $remainder
  }
  set result "[string range $CopyBuffer $offset [expr $offset + $maxBytes]]"
  return $result
}

proc HL20_TextDisOwnSelection {w} {
  # Handler for a text widget losing the selestion.
  #
  # Arguments:
  # <in> w -- the text widget.
  # [index] HL20\_TextDisOwnSelection!procedure

  global CopyBuffer
  set CopyBuffer {}
  selection  handle $w {}
  $w tag remove sel 1.0 end
  selection clear
}

proc HL20_EntryDisOwnSelection {w} {
  # Handler for a entry widget losing the selestion.
  #
  # Arguments:
  # <in> w -- the entry widget.
  # [index] HL20\_EntryDisOwnSelection!procedure

  global CopyBuffer
  set CopyBuffer {}
  selection  handle $w {}
  $w selection clear
  selection clear
}

proc HL20_listboxCopy w {
# HL20_listboxCopy --
# This procedure copies the selection from a text widget into the
# clipboard.
#
# Arguments:
# <in> w -		Name of a text widget.
# [index] HL20\_listboxCopy!procedure

  set cs "[$w curselection]"
  if {[llength "$cs"] < 1} {return 0}
  global CopyBuffer
  set CopyBuffer "[$w get $cs]"
  selection  handle $w {HL20_HandleSelection}
  selection  own -command "HL20_ListboxDisOwnSelection $w" $w
  return 1
}

proc HL20_ListboxDisOwnSelection {w} {
  # Handler for a listbox widget losing the selestion.
  #
  # Arguments:
  # <in> w -- the listbox widget.
  # [index] HL20\_ListboxDisOwnSelection!procedure

  global CopyBuffer
  set CopyBuffer {}
  selection  handle $w {}
  $w selection clear 0 end
  selection clear
}

proc CheckSelection {editMenu} {
  # Function to check if there is a selection.  This function manages the
  # state of the various Edit Menu items.
  # [index] CheckSelection!procedure

  if {[catch "selection get -displayof . -selection CLIPBOARD"]} {
    $editMenu entryconfigure Paste -state disabled
  } else {
    $editMenu entryconfigure Paste -state normal
  }
  set owner "[selection own]"
  if {[string length "$owner"] != 0} {
    $editMenu entryconfigure Cut -state normal
    $editMenu entryconfigure Copy -state normal
    $editMenu entryconfigure Delete -state normal
    $editMenu entryconfigure {Deselect All} -state normal
  } else {
    $editMenu entryconfigure Cut -state disabled
    $editMenu entryconfigure Copy -state disabled
    $editMenu entryconfigure Delete -state disabled
    $editMenu entryconfigure {Deselect All} -state disabled
  }
}

Main

# eof
#

