/*
 * ------------------------------------------------------------------
 * Home Libarian 1.0B by Deepwoods Software
 * ------------------------------------------------------------------
 * TkvBTree.cc - Tcl/Tk Interface for the vBTree class
 * Created by Robert Heller on Mon Apr 17 14:03:20 1995
 * ------------------------------------------------------------------
 * Modification History: 
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Home Librarian Database -- a program for maintaining a database
 *                                for a home library
 *     Copyright (C) 1991-1995  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

#include <TkvBTree.h>
#include <TkCardRecord.h>
#include <ListRecord.h>

void_pt TkvBTree::Handles = NULL;

TkvBTree::TkvBTree(char *filename,OpenMode mode,int nfree)
{
	(void) Tree.open(filename,mode,nfree);
	FileName = filename;
	_mode = (OpenMode) (mode & ModeMask);
}

TkvBTree::~TkvBTree()
{
}

static Key subjkey;
static Tcl_Interp *subjinterp = NULL;

static void ExamineSubj(CoreItem* item,int level)
{
	if (subjinterp == NULL) return;
	if (item->data.size <= 0) return;
	ListRecord rec(&item->data);
	int icount = rec.ElementCount();
	for (int i = 0; i < icount; i++) {
		if (strcasecmp(subjkey,rec[i]) == 0) {
			Tcl_AppendElement(subjinterp,item->key);
			return;
		}
	}
}

int TkvBTree::TclFunction(Tcl_Interp *interp,int argc, char *argv[])
{
	static char **newelements = NULL;
	static int numnewelements = 0;
	if (argc == 1)
	{
		// no option, echo slots
		Tcl_DString result;
		Tcl_DStringInit(&result);
		Tcl_DStringAppendElement(&result,"vBTree");

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"FileName");
		Tcl_DStringAppendElement(&result,(char*)FileName);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Mode");
		switch (_mode)
		{
			case ReadOnly: Tcl_DStringAppendElement(&result,"ReadOnly");
				       break;
			case ReadWrite: Tcl_DStringAppendElement(&result,"ReadWrite");
				       break;
		}
		Tcl_DStringEndSublist(&result);			

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"OpenStat");
		switch (Tree.OpenStat())
		{
			case failure: Tcl_DStringAppendElement(&result,"failure");
				      break;
			case openold: Tcl_DStringAppendElement(&result,"openold");
				      break;
			case opennew: Tcl_DStringAppendElement(&result,"opennew");
				      break;
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringResult(interp,&result);
		return TCL_OK;
	}
	if (argc < 2)
	{
		Tcl_AppendResult(interp, "wrong # args: should be \"",
				 argv[0], " option ?arg arg ...?\"",
				 (char *) NULL);
		return TCL_ERROR;
	}
	if (strcmp(argv[1], "type") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],(char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp, "vBTree", (char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "openstat") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		switch (Tree.OpenStat())
		{
			case failure: Tcl_AppendElement(interp, "failure"); break;
			case openold: Tcl_AppendElement(interp, "openold"); break;
			case opennew: Tcl_AppendElement(interp, "opennew"); break;
		}
		return TCL_OK;
	} else if (strcmp(argv[1], "mode") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		switch (_mode)
		{
			case ReadOnly: Tcl_AppendElement(interp, "ReadOnly"); break;
			case ReadWrite:Tcl_AppendElement(interp, "ReadWrite"); break;
		}
		return TCL_OK;
	} else if (strcmp(argv[1], "filename") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendElement(interp,(char*)FileName);
		return TCL_OK;
	} else if (strcmp(argv[1], "searchids") == 0)
	{
		Key searchkey;
		if (argc == 2) searchkey[0] = '\0';
		else if (argc == 3)
		{
			strncpy(searchkey,argv[2],KeySize-1);
			searchkey[KeySize-1] = '\0';
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?key?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		CoreItem item;
		if (Tree.SearchId(searchkey,&item))
		{
			do {
				Tcl_AppendElement(interp,(char*)item.key);
			} while (Tree.SearchIdAgain(&item));
		}
		return TCL_OK;
	} else if (strcmp(argv[1], "readid") == 0)
	{
		Key searchkey;
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," key\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		CoreItem item;
		strncpy(searchkey,argv[2],KeySize-1);
		searchkey[KeySize-1] = '\0';
		if (Tree.SearchId(searchkey,&item) &&
		    strlen(searchkey) == strlen(item.key))
		{
			return createTkCardRecord(interp,&item);
		} else
		{
			return TCL_OK;
		}
	} else if (strcmp(argv[1], "searchtitles") == 0)
	{
		Key searchkey;
		if (argc == 2) searchkey[0] = '\0';
		else if (argc == 3)
		{
			strncpy(searchkey,argv[2],KeySize-1);
			searchkey[KeySize-1] = '\0';
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?key?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		CoreItem item;
		if (Tree.SearchTitle(searchkey,&item))
		{
			do {
				Tcl_AppendElement(interp,(char*)item.key);
			} while (Tree.SearchTitleAgain(&item));
		}
		return TCL_OK;
	} else if (strcmp(argv[1], "readtitlelist") == 0)
	{
		Key searchkey;
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," key\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		CoreItem item;
		strncpy(searchkey,argv[2],KeySize-1);
		searchkey[KeySize-1] = '\0';
		if (Tree.SearchTitle(searchkey,&item) &&
		    strlen(searchkey) == strlen(item.key))
		{
			ListRecord rec(&item.data);
			int elc = rec.ElementCount();
			for (int i = 0;i < elc;i++)
			{
				Tcl_AppendElement(interp,rec[i]);
			}
			return  TCL_OK;
		} else
		{
			return TCL_OK;
		}
	} else if (strcmp(argv[1], "searchauthors") == 0)
	{
		Key searchkey;
		if (argc == 2) searchkey[0] = '\0';
		else if (argc == 3)
		{
			strncpy(searchkey,argv[2],KeySize-1);
			searchkey[KeySize-1] = '\0';
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?key?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		CoreItem item;
		if (Tree.SearchAuthor(searchkey,&item))
		{
			do {
				Tcl_AppendElement(interp,(char*)item.key);
			} while (Tree.SearchAuthorAgain(&item));
		}
		return TCL_OK;
	} else if (strcmp(argv[1], "readauthorlist") == 0)
	{
		Key searchkey;
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," key\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		CoreItem item;
		strncpy(searchkey,argv[2],KeySize-1);
		searchkey[KeySize-1] = '\0';
		if (Tree.SearchAuthor(searchkey,&item) &&
		    strlen(searchkey) == strlen(item.key))
		{
			ListRecord rec(&item.data);
			int elc = rec.ElementCount();
			for (int i = 0;i < elc;i++)
			{
				Tcl_AppendElement(interp,rec[i]);
			}
			return  TCL_OK;
		} else
		{
			return TCL_OK;
		}
	} else if (strcmp(argv[1], "searchsubjects") == 0)
	{
		Key searchkey;
		if (argc == 2) searchkey[0] = '\0';
		else if (argc == 3)
		{
			strncpy(searchkey,argv[2],KeySize-1);
			searchkey[KeySize-1] = '\0';
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?key?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		CoreItem item;
		if (Tree.SearchSubj(searchkey,&item))
		{
			do {
				Tcl_AppendElement(interp,(char*)item.key);
			} while (Tree.SearchSubjAgain(&item));
		}
		return TCL_OK;
	} else if (strcmp(argv[1], "readsubjectlist") == 0)
	{
		Key searchkey;
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," key\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		CoreItem item;
		strncpy(searchkey,argv[2],KeySize-1);
		searchkey[KeySize-1] = '\0';
		if (Tree.SearchSubj(searchkey,&item) &&
		    strlen(searchkey) == strlen(item.key))
		{
			ListRecord rec(&item.data);
			int elc = rec.ElementCount();
			for (int i = 0;i < elc;i++)
			{
				Tcl_AppendElement(interp,rec[i]);
			}
			return  TCL_OK;
		} else
		{
			return TCL_OK;
		}
	} else if (strcmp(argv[1], "fetchsubjs") == 0)
	{
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," idkey\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		strncpy(subjkey,argv[2],KeySize-1);
		subjkey[KeySize-1] = '\0';
		subjinterp = interp;
		Tree.TraverseSubj(ExamineSubj);
		subjinterp = NULL;
		return TCL_OK;
	} else if (strcmp(argv[1], "updatesubjs") == 0)
	{
		Key key;
		int subjc,osubjc,is1,is2;
		char **subjv,**osubjv;

		if (_mode != ReadWrite)
		{
			Tcl_AppendResult(interp, "ReadOnly file!",(char *) NULL);
			return TCL_ERROR;
		}
		if (argc != 5)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],
					 " subjs osubjs idkey\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		strncpy(key,argv[4],KeySize-1);
		key[KeySize-1] = '\0';
		if (Tcl_SplitList(interp, argv[2], &subjc, &subjv) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_SplitList(interp, argv[3], &osubjc, &osubjv) != TCL_OK)
			return TCL_ERROR;
		for (is1 = 0; is1 < osubjc;is1++)
		{
			Boolean retain = false;
			for (is2 = 0; is2 < subjc;is2++)
			{
				if (strncasecmp(osubjv[is1],
						subjv[is2],
						KeySize-1) == 0)
				{
					retain = true;
					break;
				}
			}
			if (!retain)
			{
				CoreItem temp;
				Key skey;
				strncpy(skey,osubjv[is1],KeySize-1);
				skey[KeySize-1] = '\0';
				if (Tree.SearchSubj(skey,&temp) &&
				    strlen(skey) == strlen(temp.key))
				{
					ListRecord rec(&temp.data);
					int nitems = rec.ElementCount();
					int outitems = 0;
					if (nitems > numnewelements)
					{
						if (newelements != NULL)
							delete newelements;
						int numnewelements = (nitems+511) & ~(0x03ffL);
						newelements = new char*[numnewelements];
					}
					for (int i = 0; i < nitems; i++)
					{
						if (strcasecmp(rec[i],key) != 0)
						{
							newelements[outitems++] = rec[i];
						}
					}
					if (outitems == 0)
					{
						Tree.DeleteSubj(skey);
					} else
					{
						ListRecord newrec(outitems,newelements);
						Record rawrec = newrec;
						Tree.InsertSubj(skey,&rawrec);
					}
				}
			}
		}
		for (is1 = 0; is1 < subjc;is1++)
		{
			Boolean addnew = true;
			for (is2 = 0; is2 < osubjc;is2++)
			{
				if (strncasecmp(subjv[is1],
						osubjv[is2],
						KeySize-1) == 0)
				{
					addnew = false;
					break;
				}
			}
			if (addnew)
			{
				CoreItem temp;
				Key skey;
				strncpy(skey,subjv[is1],KeySize-1);
				skey[KeySize-1] = '\0';
				if (Tree.SearchSubj(skey,&temp) &&
				    strlen(skey) == strlen(temp.key))
				{
					ListRecord rec(&temp.data);
					int nitems = rec.ElementCount();
					int outitems = 0;
					if ((nitems+1) > numnewelements)
					{
						if (newelements != NULL)
							delete newelements;
						int numnewelements = (nitems+512) & ~(0x03ffL);
						newelements = new char*[numnewelements];
					}
					for (int i = 0; i < nitems; i++)
					{
						if (strcasecmp(rec[i],key) != 0)
						{
							newelements[outitems++] = rec[i];
						}
					}
					newelements[outitems++] = (char*)key;
					ListRecord newrec(outitems,newelements);
					Record rawrec = newrec;
					Tree.InsertSubj(skey,&rawrec);
				} else
				{
					if (1 > numnewelements)
					{
						if (newelements != NULL)
							delete newelements;
						int numnewelements = 512;
						newelements = new char*[numnewelements];
					}
					newelements[0] = (char*)key;
					ListRecord newrec(1,newelements);
					Record rawrec = newrec;
					Tree.InsertSubj(skey,&rawrec);
				}
			}
		}
		return TCL_OK;
	} else if (strcmp(argv[1], "updateauthor") == 0)
	{
		Key key, authkey, oauthkey;
		if (_mode != ReadWrite)
		{
			Tcl_AppendResult(interp, "ReadOnly file!",(char *) NULL);
			return TCL_ERROR;
		}
		if (argc != 5)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],
					 " newauthor oldauthor idkey\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		strncpy(authkey,argv[2],KeySize-1);
		authkey[KeySize-1] = '\0';
		strncpy(oauthkey,argv[3],KeySize-1);
		oauthkey[KeySize-1] = '\0';
		strncpy(key,argv[4],KeySize-1);
		key[KeySize-1] = '\0';
		if (strcasecmp(authkey,oauthkey) != 0)
		{
			CoreItem temp;
			if (Tree.SearchAuthor(oauthkey,&temp) &&
			    strlen(oauthkey) == strlen(temp.key))
			{
				ListRecord rec(&temp.data);
				int nitems = rec.ElementCount();
				int outitems = 0;
				if (nitems > numnewelements)
				{
					if (newelements != NULL)
							delete newelements;
						int numnewelements = (nitems+511) & ~(0x03ffL);
						newelements = new char*[numnewelements];
				}
				for (int i = 0; i < nitems; i++)
				{
					if (strcasecmp(rec[i],key) != 0)
					{
						newelements[outitems++] = rec[i];
					}
				}
				if (outitems == 0)
				{
					Tree.DeleteAuthor(oauthkey);
				} else
				{
					ListRecord newrec(outitems,newelements);
					Record rawrec = newrec;
					Tree.InsertAuthor(oauthkey,&rawrec);
				}
			}
			if (Tree.SearchAuthor(authkey,&temp) &&
			    strlen(authkey) == strlen(temp.key))
			{
				ListRecord rec(&temp.data);
				int nitems = rec.ElementCount();
				int outitems = 0;
				if (nitems > numnewelements)
				{
					if (newelements != NULL)
							delete newelements;
						int numnewelements = (nitems+511) & ~(0x03ffL);
						newelements = new char*[numnewelements];
				}
				for (int i = 0; i < nitems; i++)
				{
					if (strcasecmp(rec[i],key) != 0)
					{
						newelements[outitems++] = rec[i];
					}
				}
				newelements[outitems++] = (char*) key;
				ListRecord newrec(outitems,newelements);
				Record rawrec = newrec;
				Tree.InsertAuthor(authkey,&rawrec);
			} else if (authkey[0] != 0)
			{
				if (1 > numnewelements)
				{
					if (newelements != NULL)
						delete newelements;
					int numnewelements = 512;
					newelements = new char*[numnewelements];
				}
				newelements[0] = (char*) key;
				ListRecord newrec(1,newelements);
				Record rawrec = newrec;
				Tree.InsertAuthor(authkey,&rawrec);
			}
		}
		return TCL_OK;
	} else if (strcmp(argv[1], "updatetitle") == 0)
	{
		Key key, titlekey, otitlekey;
		if (_mode != ReadWrite)
		{
			Tcl_AppendResult(interp, "ReadOnly file!",(char *) NULL);
			return TCL_ERROR;
		}
		if (argc != 5)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],
					 " newtitle oldtitle idkey\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		strncpy(titlekey,argv[2],KeySize-1);
		titlekey[KeySize-1] = '\0';
		strncpy(otitlekey,argv[3],KeySize-1);
		otitlekey[KeySize-1] = '\0';
		strncpy(key,argv[4],KeySize-1);
		key[KeySize-1] = '\0';
		if (strcasecmp(titlekey,otitlekey) != 0)
		{
			CoreItem temp;
			if (Tree.SearchTitle(otitlekey,&temp) &&
			    strlen(otitlekey) == strlen(temp.key))
			{
				ListRecord rec(&temp.data);
				int nitems = rec.ElementCount();
				int outitems = 0;
				if (nitems > numnewelements)
				{
					if (newelements != NULL)
							delete newelements;
						int numnewelements = (nitems+511) & ~(0x03ffL);
						newelements = new char*[numnewelements];
				}
				for (int i = 0; i < nitems; i++)
				{
					if (strcasecmp(rec[i],key) != 0)
					{
						newelements[outitems++] = rec[i];
					}
				}
				if (outitems == 0)
				{
					Tree.DeleteTitle(otitlekey);
				} else
				{
					ListRecord newrec(outitems,newelements);
					Record rawrec = newrec;
					Tree.InsertTitle(otitlekey,&rawrec);
				}
			}
			if (Tree.SearchTitle(titlekey,&temp) &&
			    strlen(titlekey) == strlen(temp.key))
			{
				ListRecord rec(&temp.data);
				int nitems = rec.ElementCount();
				int outitems = 0;
				if (nitems > numnewelements)
				{
					if (newelements != NULL)
							delete newelements;
						int numnewelements = (nitems+511) & ~(0x03ffL);
						newelements = new char*[numnewelements];
				}
				for (int i = 0; i < nitems; i++)
				{
					if (strcasecmp(rec[i],key) != 0)
					{
						newelements[outitems++] = rec[i];
					}
				}
				newelements[outitems++] = (char*) key;
				ListRecord newrec(outitems,newelements);
				Record rawrec = newrec;
				Tree.InsertTitle(titlekey,&rawrec);
			} else if (titlekey[0] != 0)
			{
				if (1 > numnewelements)
				{
					if (newelements != NULL)
						delete newelements;
					int numnewelements = 512;
					newelements = new char*[numnewelements];
				}
				newelements[0] = (char*) key;
				ListRecord newrec(1,newelements);
				Record rawrec = newrec;
				Tree.InsertTitle(titlekey,&rawrec);
			}
		}
		return TCL_OK;
	} else if (strcmp(argv[1], "insertid") == 0)
	{
		Key key;
		TkCardRecord *rec;
		if (_mode != ReadWrite)
		{
			Tcl_AppendResult(interp, "ReadOnly file!",(char *) NULL);
			return TCL_ERROR;
		}
		if (argc != 4)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],
					 " idkey cardhandle\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		strncpy(key,argv[2],KeySize-1);
		key[KeySize-1] = '\0';
		if (argv[3][0] == '\0')
		{
			Tcl_AppendResult(interp, "bad (empty) cardhandle", (char *) NULL);
			return TCL_ERROR;
		}
		rec = FindCardByHandle(interp,argv[3]);
		if (rec == NULL) return TCL_ERROR;
		Record rawrec = *(rec->CardRec);
		Tree.InsertId(key,&rawrec);
		return TCL_OK;
	} else if (strcmp(argv[1], "deleteid") == 0)
	{
		Key key;
		if (_mode != ReadWrite)
		{
			Tcl_AppendResult(interp, "ReadOnly file!",(char *) NULL);
			return TCL_ERROR;
		}
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],
					 " idkey\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		strncpy(key,argv[2],KeySize-1);
		key[KeySize-1] = '\0';
		CoreItem temp;
		if (Tree.SearchId(key,&temp) &&
		    strlen(key) == strlen(temp.key))
		{
			Tree.DeleteId(key);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "No such key: ",argv[2],(char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "delete") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		void_pt header = Tcl_HandleXlate (interp,Handles,argv[0]);
		if (header == NULL) return TCL_ERROR;
		Tcl_HandleFree (Handles,header);
		return Tcl_DeleteCommand(interp,argv[0]);
	} else
	{
		Tcl_AppendResult(interp, "Bad option: ",argv[1],(char *) NULL);
		return TCL_ERROR;
	}
}


static void deleteTkvBTree(ClientData clientData)
{
	register TkvBTree *tkvbtree = (TkvBTree *)clientData;
	delete tkvbtree;
}

static int tkvBTreeCommand(ClientData clientData, Tcl_Interp *interp,
			   int argc, char *argv[])
{
	register TkvBTree *tkvbtree = (TkvBTree *)clientData;
	return tkvbtree->TclFunction(interp,argc,argv);
}

static OpenMode ModeFromString(String m)
{
	if (m == "ReadWrite") return (ReadWrite);
	else if (m == "ReadOnly") return (ReadOnly);
	else if (m == "ReadWrite|Create") return((OpenMode)(ReadWrite|Create));
	else if (m == "Create|ReadWrite") return((OpenMode)(ReadWrite|Create));
	else return(ReadOnly);
}

static int tkvBTreeCreate(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	register TkvBTree *tkvbtree;
	OpenMode mode;
	int nfree;
	if (argc < 2 || argc > 4)
	{
		Tcl_AppendResult(interp, "Wrong # args: should be \"",
				 argv[0]," filename ?mode nfree?\"",
				 (char*) NULL);
		return TCL_ERROR;
	}
	switch (argc)
	{
		case 2: tkvbtree = new TkvBTree(argv[1]); break;
		case 3: mode = ModeFromString(argv[2]);
			tkvbtree = new TkvBTree(argv[1],mode);
			break;
		case 4: mode = ModeFromString(argv[2]);
			if (Tcl_GetInt(interp,argv[3],&nfree) != TCL_OK) return(TCL_ERROR);
			tkvbtree = new TkvBTree(argv[1],mode,nfree);
			break;
		default:
		Tcl_AppendResult(interp, "Wrong # args: should be \"",
				 argv[0]," filename ?mode nfree\"",
				 (char*) NULL);
		return TCL_ERROR;
	}
	char handle[32];
	TkvBTree ** h = (TkvBTree **) Tcl_HandleAlloc (TkvBTree::Handles,handle);
	*h = tkvbtree;
	Tcl_CreateCommand(interp,handle,(Tcl_CmdProc*)tkvBTreeCommand,
			  (ClientData)tkvbtree,
			  (Tcl_CmdDeleteProc*)deleteTkvBTree);
	Tcl_AppendResult(interp,handle,(char *) NULL);
	return TCL_OK;
}

int TkvBTree_Init(Tcl_Interp *interp)
{
	TkvBTree::Handles = Tcl_HandleTblInit("TkvBTree",sizeof(TkvBTree*),64);
	Tcl_CreateCommand(interp, "TkvBTree", (Tcl_CmdProc*)tkvBTreeCreate,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	return TCL_OK;
}
