/*
 * ------------------------------------------------------------------
 * Home Libarian 1.0B by Deepwoods Software
 * ------------------------------------------------------------------
 * TkCardRecord.cc - Tcl/Tk Interface for CardRecord class
 * Created by Robert Heller on Mon Apr 17 14:00:46 1995
 * ------------------------------------------------------------------
 * Modification History: 
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Home Librarian Database -- a program for maintaining a database
 *                                for a home library
 *     Copyright (C) 1991-1995  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

#include <TkCardRecord.h>

void_pt TkCardRecord::Handles = NULL;

int TkCardRecord::TclFunction(Tcl_Interp *interp,int argc, char *argv[])
{
	if (argc == 1)
	{
		Card *c = &(*CardRec);
		// no option, echo slots
		Tcl_DString result;
		Tcl_DStringInit(&result);
		Tcl_DStringAppendElement(&result,"CardRecord");

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"type");
		Tcl_DStringAppendElement(&result,TypeName(c->type));
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"author");
		Tcl_DStringAppendElement(&result,c->author);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"title");
		Tcl_DStringAppendElement(&result,c->title);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"publisher");
		Tcl_DStringAppendElement(&result,c->publisher);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"city");
		Tcl_DStringAppendElement(&result,c->city);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"description");
		Tcl_DStringAppendElement(&result,c->description);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"vol");
		{
			ostrstream stream;
			stream << c->vol;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);
		
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"year");
		{
			ostrstream stream;
			stream << c->year;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringResult(interp,&result);
		return TCL_OK;
	}
	if (argc < 2)
	{
		Tcl_AppendResult(interp, "wrong # args: should be \"",
				 argv[0], " option ?arg arg ...?\"",
				 (char *) NULL);
		return TCL_ERROR;
	}
	if (strcmp(argv[1], "type") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],(char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp, "CardRecord", (char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "cardtype") == 0)
	{
		if (argc == 3)
		{
			if (!CardTypeNameP(argv[2]))
			{
				Tcl_AppendResult(interp, "Bad card type: ",
						 argv[2]," should be one of {",
						 "book magazine cd ",
						 "audiocassette album ",
						 "laserdisk vhsvideo betavideo ",
						 "eightmm eighttrack dat other}",
						 (char *) NULL);
				return TCL_ERROR;
			}
			(*CardRec)->type = NameType(argv[2]);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp, TypeName((*CardRec)->type), (char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "author") == 0)
	{
		if (argc == 3)
		{
			Author = argv[2];
			(*CardRec)->author = (char*) Author;
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp, (*CardRec)->author, (char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "title") == 0)
	{
		if (argc == 3)
		{
			Title = argv[2];
			(*CardRec)->title = (char*) Title;
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp, (*CardRec)->title, (char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "publisher") == 0)
	{
		if (argc == 3)
		{
			Publisher = argv[2];
			(*CardRec)->publisher = (char*) Publisher;
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp, (*CardRec)->publisher, (char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "city") == 0)
	{
		if (argc == 3)
		{
			City = argv[2];
			(*CardRec)->city = (char*) City;
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp, (*CardRec)->city, (char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "description") == 0)
	{
		if (argc == 3)
		{
			Description = argv[2];
			(*CardRec)->description = (char*) Description;
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp, (*CardRec)->description, (char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "vol") == 0)
	{
		if (argc == 3)
		{
			if (Tcl_GetInt(interp, argv[2], &((*CardRec)->vol)) != TCL_OK)
				return TCL_ERROR;
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		{
			ostrstream stream;
			stream << (*CardRec)->vol;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			stream.freeze(0);
		}
		return TCL_OK;
	} else if (strcmp(argv[1], "year") == 0)
	{
		if (argc == 3)
		{
			if (Tcl_GetInt(interp, argv[2], &((*CardRec)->year)) != TCL_OK)
				return TCL_ERROR;
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		{
			ostrstream stream;
			stream << (*CardRec)->year;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			stream.freeze(0);
		}
		return TCL_OK;
	} else if (strcmp(argv[1], "delete") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		void_pt header = Tcl_HandleXlate (interp,Handles,argv[0]);
		if (header == NULL) return TCL_ERROR;
		Tcl_HandleFree (Handles,header);
		return Tcl_DeleteCommand(interp,argv[0]);
	} else
	{
		Tcl_AppendResult(interp, "Bad option: ",argv[1],(char *) NULL);
		return TCL_ERROR;
	}
}


static void deleteTkCardRecord(ClientData clientData)
{
	register TkCardRecord *tkCardRecord = (TkCardRecord *)clientData;
	delete tkCardRecord;
}

static int tkCardRecordCommand(ClientData clientData, Tcl_Interp *interp,
			   int argc, char *argv[])
{
	register TkCardRecord *tkCardRecord = (TkCardRecord *)clientData;
	return tkCardRecord->TclFunction(interp,argc,argv);
}

static int tkCardRecordCreate(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	register TkCardRecord *tkCardRecord;
	Card *incard;

	if (argc != 1 && argc != 9)
	{
		Tcl_AppendResult(interp, "Wrong # args: should be \"",
				 argv[0]," ?type author title ",
				 "publisher city description vol year?\"",
				 (char*) NULL);
		return TCL_ERROR;
	}
	if (argc == 1) incard = new Card(Book,"","","","","",0,0);
	else
	{
		CardType type;
		int vol,year;
		if (!CardTypeNameP(argv[1]))
		{
			Tcl_AppendResult(interp, "Bad card type: ",
					 argv[1]," should be one of {",
					 "book magazine cd ",
					 "audiocassette album ",
					 "laserdisk vhsvideo betavideo ",
					 "eightmm eighttrack dat other}",
					 (char *) NULL);
			return TCL_ERROR;
		}
		type = NameType(argv[1]);
		// argv[2] : author
		// argv[3] : title
		// argv[4] : publisher
		// argv[5] : city
		// argv[6] : description
		if (Tcl_GetInt(interp, argv[7], &vol) != TCL_OK) return TCL_ERROR;
		if (Tcl_GetInt(interp, argv[8], &year) != TCL_OK) return TCL_ERROR;
		incard = new Card(type,argv[2],argv[3],argv[4],argv[5],argv[6],vol,year);
	}
	tkCardRecord = new TkCardRecord(incard);
	delete incard;	
	char handle[32];
	TkCardRecord ** h = (TkCardRecord **) Tcl_HandleAlloc (TkCardRecord::Handles,handle);
	*h = tkCardRecord;
	Tcl_CreateCommand(interp,handle,(Tcl_CmdProc*)tkCardRecordCommand,
			  (ClientData)tkCardRecord,
			  (Tcl_CmdDeleteProc*)deleteTkCardRecord);
	Tcl_AppendResult(interp,handle,(char *) NULL);
	return TCL_OK;
}

int TkCardRecord_Init(Tcl_Interp *interp)
{
	TkCardRecord::Handles = Tcl_HandleTblInit("TkCardRecord",sizeof(TkCardRecord*),64);
	Tcl_CreateCommand(interp, "TkCardRecord", (Tcl_CmdProc*)tkCardRecordCreate,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	return TCL_OK;
}

int createTkCardRecord(Tcl_Interp *interp,Record* record)
{
	if (TkCardRecord::Handles == NULL)
	{
		Tcl_AppendResult(interp,"TkCardRecords not Init'ed",
					(char*) NULL);
		return TCL_ERROR;
	}
	TkCardRecord *tkCardRecord = new TkCardRecord(record);
	char handle[32];
	TkCardRecord ** h = (TkCardRecord **) Tcl_HandleAlloc (TkCardRecord::Handles,handle);
	*h = tkCardRecord;
	Tcl_CreateCommand(interp,handle,(Tcl_CmdProc*)tkCardRecordCommand,
			  (ClientData)tkCardRecord,
			  (Tcl_CmdDeleteProc*)deleteTkCardRecord);
	Tcl_AppendResult(interp,handle,(char *) NULL);
	return TCL_OK;
}

int createTkCardRecord(Tcl_Interp *interp,CoreItem* coreitem)
{
	if (TkCardRecord::Handles == NULL)
	{
		Tcl_AppendResult(interp,"TkCardRecords not Init'ed",(char*) NULL);
		return TCL_ERROR;
	}
	TkCardRecord *tkCardRecord = new TkCardRecord(coreitem);
	char handle[32];
	TkCardRecord ** h = (TkCardRecord **) Tcl_HandleAlloc (TkCardRecord::Handles,handle);
	*h = tkCardRecord;
	Tcl_CreateCommand(interp,handle,(Tcl_CmdProc*)tkCardRecordCommand,
			  (ClientData)tkCardRecord,
			  (Tcl_CmdDeleteProc*)deleteTkCardRecord);
	Tcl_AppendResult(interp,handle,(char *) NULL);
	return TCL_OK;
}

int createTkCardRecord(Tcl_Interp *interp,Card* card)
{
	if (TkCardRecord::Handles == NULL)
	{
		Tcl_AppendResult(interp,"TkCardRecords not Init'ed",(char*) NULL);
		return TCL_ERROR;
	}
	TkCardRecord *tkCardRecord = new TkCardRecord(card);
	char handle[32];
	TkCardRecord ** h = (TkCardRecord **) Tcl_HandleAlloc (TkCardRecord::Handles,handle);
	*h = tkCardRecord;
	Tcl_CreateCommand(interp,handle,(Tcl_CmdProc*)tkCardRecordCommand,
			  (ClientData)tkCardRecord,
			  (Tcl_CmdDeleteProc*)deleteTkCardRecord);
	Tcl_AppendResult(interp,handle,(char *) NULL);
	return TCL_OK;
}

int createTkCardRecord(Tcl_Interp *interp,CardRecord& cardrecord)
{
	if (TkCardRecord::Handles == NULL)
	{
		Tcl_AppendResult(interp,"TkCardRecords not Init'ed",(char*) NULL);
		return TCL_ERROR;
	}
	TkCardRecord *tkCardRecord = new TkCardRecord(cardrecord);
	char handle[32];
	TkCardRecord ** h = (TkCardRecord **) Tcl_HandleAlloc (TkCardRecord::Handles,handle);
	*h = tkCardRecord;
	Tcl_CreateCommand(interp,handle,(Tcl_CmdProc*)tkCardRecordCommand,
			  (ClientData)tkCardRecord,
			  (Tcl_CmdDeleteProc*)deleteTkCardRecord);
	Tcl_AppendResult(interp,handle,(char *) NULL);
	return TCL_OK;
}

TkCardRecord* FindCardByHandle(Tcl_Interp *interp,char* handle)
{
	void_pt ptr = Tcl_HandleXlate(interp,TkCardRecord::Handles,handle);
	if (ptr == NULL) return NULL;
	return (*((TkCardRecord**)ptr));
}
