/* -*- Mode: C -*- */
/* PrintLabels.cc - Main program
 * Created by Robert Heller on Sat Feb 29 16:24:09 1992
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Label printing program
 * ------------------------------------------------------------------
 * Modification History:
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 * 
 * Copyright (c) 1991,1992 by Robert heller (D/B/A Deepwoods Software)
 *        All Rights Reserved
 * 
 */

#include <stream.h>
#include <vBTree.h>
#include <ctype.h>
#include <fstream.h>
#ifdef MESSYDOS
#include <CardRec.h>
#include <ListRec.h>
#else
#include <CardRecord.h>
#include <ListRecord.h>
#endif
#include <PTree.h>
#define VERSION "V1.0Beta"
#ifdef MESSYDOS
#include "PrtLabls.h"
#else
#include "PrintLabels.h"
#endif

extern Tree* ParseOnly(char*);
extern Boolean EvalExpr(Card*, Tree*);
static vBTree *lTree;
static Tree* onlyexpr = 0;
static ifstream tfile;
static char *tfilename;

enum PrintFields {PrintType, PrintAuthor, PrintTitle, PrintPublisher,
		  PrintCity, PrintVolume, PrintYear, PrintIdent,
		  PrintDescription, IllField };

static const struct {
	const char* n;
	PrintFields f;
} FieldNames[] = {
	{ "TYPE", PrintType },
	{ "AUTHOR", PrintAuthor },
	{ "TITLE", PrintTitle },
	{ "PUBLISHER", PrintPublisher },
	{ "CITY", PrintCity },
	{ "VOLUME", PrintVolume },
	{ "YEAR", PrintYear },
	{ "ID", PrintIdent },
	{ "DESCRIPTION", PrintDescription }
};

const NumFields = sizeof(FieldNames) / sizeof(FieldNames[0]);

void PrintCardRecord(CoreItem* item,int level)
{
	if (item->data.size <= 0) return;
	CardRecord rec(&item->data);
	register Card* c = &rec;
	if (onlyexpr != 0) {
		if (!EvalExpr(c,onlyexpr)) return;
	}
	tfile.open(tfilename,ios::in);
	if (!tfile.is_open()) {
		int error = errno;
		perror("PrintLabels: template file open");
		cerr << "PrintLabels: could not open " << tfilename << "\n";
		exit(errno);
	}

	//cerr << "*** card: " << item->key << "\n";
	//cerr << "*** tfile.eof() = " << tfile.eof() <<
	//	", tfile.fail() = " << tfile.fail() << "\n";
	while (!tfile.eof() && !tfile.fail()) {
		char ch;
		tfile.get(ch);
		//cerr << "*** ch = " << ((int) ch) << "\n";
		if (ch == EOF) break;
		else if (ch != '%') cout << ch;
		else {
			tfile.get(ch);
			if (ch == '%') cout << ch;
			else if (ch == EOF) break;
			else if (isalpha(ch)) {
				static char word[256];
				register char* p = word;
				register PrintFields field = IllField;
				do {
					if (islower(ch)) ch = toupper(ch);
					*p++ = ch;
					tfile.get(ch);
				} while (isalpha(ch));
				if (ch != EOF) tfile.putback(ch);
				*p = 0;
				for (int i = 0; i < NumFields; i++) {
					if (strcmp(word,FieldNames[i].n) == 0) {
						field = FieldNames[i].f;
						break;
					}
				}
				if (field == IllField) cerr << "Bad field name " << word << " ignored.\n";
				else {
					switch (field) {
						case PrintType:
							cout << TypeName(c->type);
							break;
						case PrintAuthor:
							cout << c->author;
							break;
						case PrintTitle:
							cout << c->title;
							break;
						case PrintPublisher:
							cout << c->publisher;
							break;
						case PrintCity:
							cout << c->city;
							break;
						case PrintVolume:
							cout << c->vol;
							break;
						case PrintYear:
							cout << c->year;
							break;
						case PrintIdent:
							cout << item->key;
							break;
						case PrintDescription:
							cout << c->description;
							break;
					}
				}
			} else {
				cerr << "Bad field name char " << ch << " ignored.\n";
			}
		}
	}
	tfile.close();
}

static Boolean strequ(char* a,char* b)
{
	Boolean eqp;
	char aa, bb;
	do {
		aa = *a++;
		bb = *b++;
		if (islower(aa)) aa = toupper(aa);
		if (islower(bb)) bb = toupper(bb);
		eqp = aa == bb;
	} while (eqp && aa != 0 && bb != 0);
	return(eqp);
}

void PrintListRecord(CoreItem *item,int level)
{
	if (item->data.size > 0) {
		ListRecord rec(&item->data);
		int numitems = rec.ElementCount();
#ifdef ILLEGAL_INSTR
		static CoreItem temp;
		for (int i = 0;i < numitems; i++) {
			if (lTree->SearchId(rec[i],&temp) &&
			    strlen(rec[i]) == strlen(temp.key)) 
			    	PrintCardRecord(&temp,level);
		}
#else
		CoreItem* temp = new CoreItem;
		for (int i = 0;i < numitems; i++) {
			if (lTree->SearchId(rec[i],temp) &&
			    strlen(rec[i]) == strlen(temp->key)) 
			    	PrintCardRecord(temp,level);
		}
		delete temp;
#endif
	}
}

static void ErrorHandler(ErrKind err,char* msg)
{
	if (err == sysErr) {
		int error = errno;
		cerr << form("Error: System:%d %s %s\n",error,strerror(error),
				msg);
	} else {
		cerr << form("Error: %s %s\n",
			(err == termErr ? "Terminal" : "Memory"),
			msg);
	}
}
	
int main(int argc,char **argv)
{
	PrintLabels args(argc,argv);
	vBTree vtree(args.infile,(OpenMode)(ReadOnly));
	if (vtree.OpenStat() == failure) {
		int error = errno;
		cerr << "Could not open " << args.infile
		     << ": " << strerror(error) << "\n";
		exit(error);
	}
	vtree.ErrorFun() = ErrorHandler;
	lTree = &vtree;
	
	if (args.only_passed) {
		onlyexpr = ParseOnly(args.only);
		if (onlyexpr == 0) exit(1);
	}
			
	tfilename = args.templatefile;

	if (args.by_passed) {
		if (strequ(args.by,"ID")) vtree.TraverseId(PrintCardRecord);
		else if (strequ(args.by,"TITLE")) vtree.TraverseTitle(PrintListRecord);
		else if (strequ(args.by,"AUTHOR")) vtree.TraverseAuthor(PrintListRecord);
		else if (strequ(args.by,"SUBJECT")) vtree.TraverseSubj(PrintListRecord);
		else {
			cout << "Bad -by value: " << args.by << "\n";
			args.Usage();
			exit(1);
		}
	} else vtree.TraverseId(PrintCardRecord);
}


