/* -*- Mode: C -*- */
/* Libr2Ascii.cc - Spit out a libr file as an ASCII text file.
 * Created by Robert Heller on Sat Dec  7 23:09:11 1991
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Library file to ASCII text file
 * ------------------------------------------------------------------
 * Modification History:
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 * 
 * Copyright (c) 1991,1992 by Robert heller (D/B/A Deepwoods Software)
 *        All Rights Reserved
 * 
 */

#include <stream.h>
#include <vBTree.h>
#include <ctype.h>
#ifdef MESSYDOS
#include <CardRec.h>
#include <ListRec.h>
#else
#include <CardRecord.h>
#include <ListRecord.h>
#endif
#define VERSION "V1.0Beta"
#ifdef MESSYDOS
#include "Libr2Asc.h"
#else
#include "Libr2Ascii.h"
#endif
#ifdef unix
#include <stdio.h>
#endif

void QuoteStringBuffer(char* buffer,char* string)
{
	*buffer++ = '"';
	while (*string != 0) {
		if (*string == '"') *buffer++ = '\\';
		*buffer++ = *string++;
	}
	*buffer++ = '"';
	*buffer = 0;
}

void QuoteStringStream(ostream& out,char* string)
{
	out << '"';
	while (*string != 0) {
		if (*string == '"') out << '\\';
		out << *string++;
	}
	out << '"';
}

static char buffer[2048];

void PrintCardRecord(CoreItem* item,int level)
{
	int indent = 0;
	int column = 0;
	QuoteStringBuffer(buffer,item->key);
	cout << buffer << " ";
	indent += strlen(buffer) + 1;
	if (item->data.size <= 0) {
		cout << "#C()\n";
	} else {
		cout << "#C("; indent += 3;
		column = indent;
		CardRecord rec(&item->data);
		register Card *c = &rec;
		char* tn = TypeName(c->type);
		cout << form(":TYPE %s ",tn); column += 7 + strlen(tn);
		QuoteStringBuffer(buffer,c->author);
		if ((column + 9 + strlen(buffer))> 75) {
			cout << "\n";
			for (int cc = 0; cc < indent; cc++) cout << " ";
			column = indent;
		}
		cout << form(":AUTHOR %s ", buffer);
		column += 9 + strlen(buffer);
		QuoteStringBuffer(buffer,c->title);
		if ((column + 8 + strlen(buffer))> 75) {
			cout << "\n";
			for (int cc = 0; cc < indent; cc++) cout << " ";
			column = indent;
		}
		cout << form(":TITLE %s ", buffer);
		column += 8 + strlen(buffer);
		QuoteStringBuffer(buffer,c->publisher);
		if ((column + 12 + strlen(buffer))> 75) {
			cout << "\n";
			for (int cc = 0; cc < indent; cc++) cout << " ";
			column = indent;
		}
		cout << form(":PUBLISHER %s ", buffer);
		column += 12 + strlen(buffer);
		QuoteStringBuffer(buffer,c->city);
		if ((column + 7 + strlen(buffer))> 75) {
			cout << "\n";
			for (int cc = 0; cc < indent; cc++) cout << " ";
			column = indent;
		}
		cout << form(":CITY %s ", buffer);
		column += 7 + strlen(buffer);
		sprintf(buffer,":VOLUME %d ",c->vol);
		if ((column + strlen(buffer))> 75) {
			cout << "\n";
			for (int cc = 0; cc < indent; cc++) cout << " ";
			column = indent;
		}
		cout << buffer; column += strlen(buffer);
		sprintf(buffer,":YEAR %d ",c->year);
		if ((column + strlen(buffer))> 75) {
			cout << "\n";
			for (int cc = 0; cc < indent; cc++) cout << " ";
			column = indent;
		}
		cout << buffer; column += strlen(buffer);
		if ((column + 12)> 75) {
			cout << "\n";
			for (int cc = 0; cc < indent; cc++) cout << " ";
			column = indent;
		}
		cout << ":DESCRIPTION\n";
		QuoteStringStream(cout,c->description);
		cout << ")\n";
	}
}

void PrintListRecord(CoreItem* item,int level)
{
	int indent = 0;
	int column = 0;
	QuoteStringBuffer(buffer,item->key);
	cout << buffer << " ";
	indent += strlen(buffer) + 1;
	if (item->data.size <= 0) {
		cout << "#()\n";
	} else {
		cout << "#("; indent += 2;
		column = indent;
		ListRecord rec(&item->data);
		int numitems = rec.ElementCount();
		for (int i = 0;i < numitems; i++) {
			QuoteStringBuffer(buffer,rec[i]);
			if ((column + 2 + strlen(buffer))> 75) {
				cout << "\n";
				for (int c = 0; c < indent;c++)
				    cout << " ";
				column = indent;
			}
			cout << buffer; column += strlen(buffer);
			if ((i+1) < numitems) {
				cout << ", "; column += 2;
			}
		}
		cout << ")\n";
	}
}

static void ErrorHandler(ErrKind err,char* msg)
{
	if (err == sysErr) {
		int error = errno;
		cerr << form("Error: System:%d %s %s\n",error,strerror(error),
				msg);
	} else {
		cerr << form("Error: %s %s\n",
			(err == termErr ? "Terminal" : "Memory"),
			msg);
	}
}
	
static int ikeys;
void CountRecord(CoreItem* item,int level)
{
	ikeys++;
}

int main(int argc,char **argv)
{
	Libr2Ascii args(argc,argv);
	vBTree vtree(args.infile,(OpenMode)(ReadOnly));
	if (vtree.OpenStat() == failure) {
		int error = errno;
		cerr << "Could not open " << args.infile
		     << ": " << strerror(error) << "\n";
		exit(error);
	}
	vtree.ErrorFun() = ErrorHandler;
	
	cout << vtree.CountPages() << "\n";
	ikeys = 0;
	vtree.TraverseId(CountRecord);
	cout << ikeys << "\n";
	vtree.TraverseId(PrintCardRecord);
	ikeys = 0;
	vtree.TraverseTitle(CountRecord);
	cout << ikeys << "\n";
	vtree.TraverseTitle(PrintListRecord);
	ikeys = 0;
	vtree.TraverseAuthor(CountRecord);
	cout << ikeys << "\n";
	vtree.TraverseAuthor(PrintListRecord);
	ikeys = 0;
	vtree.TraverseSubj(CountRecord);
	cout << ikeys << "\n";
	vtree.TraverseSubj(PrintListRecord);
}

	

