/* -*- Mode: C -*- */
/* EditForm.h - EditForm class - a form for editing
 * Created by Robert Heller on Thu Dec 12 19:11:03 1991
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Common Header Files
 * ------------------------------------------------------------------
 * Modification History:
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 * 
 * Copyright (c) 1991,1992 by Robert heller (D/B/A Deepwoods Software)
 *        All Rights Reserved
 * 
 */

#ifndef _EDITFORM_
#define _EDITFORM_
#include <stream.h>
#include <common.h>
#include <ctype.h>
#include <Terminal.h>

#ifdef OSK
#define DEFAULTEDITOR "umacs"
#endif
#ifdef MESSYDOS
#define DEFAULTEDITOR "edit"
#endif
#ifdef unix
#define DEFAULTEDITOR "vi"
#endif

typedef char* (*FieldToString)(void*);
typedef void  (*StringToField)(char*,void*);

enum FieldType {Literal, String, EditorString,
		Int, Float, Special };

struct Field {
	void *fieldp;
	FieldType type;
	FieldToString ftos;
	StringToField stof;
	int row;
	int col;
	int width;
	int height;
	int buffersize;
};

typedef void (*KeyFun)(EditForm&);

struct KeyBinding {
	KeyFun fun;
	char *docstring;
	short int keycode;	
};

class EditForm {
	static char EditorCommand[48];
	static Boolean EditorCmdInit;
	char  Title[80];
	Field *fields;
	int   nFields;
	KeyBinding *bindings;
	int   nBinds;
	int   currentField;
	void HiliteField(int fieldno,Boolean hilite);
public:
	Boolean IsModified;
		EditForm(char* title,int fieldcount,Field *infields,
			 int bindcount,KeyBinding *inbinds);
	       ~EditForm();
	Boolean RunForm();
	void RePaint();
	void ResetField() {
		currentField = 0;
		for (int i = 0;i < nFields;i++) {
			if (fields[i].type != Literal) {
				currentField = i+1;
				break;
			}
		}
	}
	int CurField() { return(currentField); }
	friend class Terminal;
};

#endif


