//-< TESTBLOB.CXX >--------------------------------------------------*--------*
// GOODS                     Version 1.0         (c) 1997  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
//                                                                   *  /  \  *
//                          Created:     17-Nov-97    K.A. Knizhnik  * / [] \ *
//                          Last update: 17-Nov-97    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Test program for binary large objects. This program can be used as
// exmaple for creating your own multimedia objects.
//-------------------------------------------------------------------*--------*

#include "goods.h"
#include "dbscls.h"

class text : public Blob { 
  public: 
    static FILE* output;
    static ref<text> create(FILE* f);
    virtual boolean handle() const;

    METACLASS_DECLARATIONS(text, Blob);
    
    static ref<text> create(void* buf, size_t buf_size) { 
	return new (self_class, buf_size) text(buf, buf_size);
    }
  protected: 
    text(void* buf, size_t buf_size) 
    : Blob(buf, buf_size, self_class) {}
};

#define HASH_SIZE 113

class directory : public hash_table { 
  public: 
    void initialize() const { 
	if (is_abstract_root()) { 
	    ref<directory> root = this;
	    modify(root)->become(new (self_class, HASH_SIZE) 
				 directory(HASH_SIZE));
	} 
    }
    void insert(const char* name);
    void remove(const char* name);
    void type(const char* name) const;
    void list() const;

    METACLASS_DECLARATIONS(directory, hash_table);    

    directory(size_t hash_table_size) 
    : hash_table(hash_table_size, self_class) {} 
};

FILE* text::output;

boolean text::handle() const
{
    return fwrite(data, 1, get_size(), output) == get_size();
}

field_descriptor& text::describe_components()
{
    return NO_FIELDS; 
}

REGISTER(text, Blob, optimistic_scheme);


void directory::insert(const char* name)
{
    char buf[1024];
    FILE* f = fopen(name, "r");
    size_t size;

    if (f == NULL) {
	console::output("Failed to open file '%s'\n", name);
	return;
    }
    if ((size = fread(buf, 1, sizeof buf, f)) > 0) { 
	ref<text> tp = text::create(buf, size);
	while ((size = fread(buf, 1, sizeof buf, f)) > 0) { 
	    modify(tp)->append(text::create(buf, size));
	} 
	put(name, tp);
    } else { 
	console::output("Failed to extract data from file '%s'\n", name);
    }
    fclose(f);
}

void directory::remove(const char* name)
{
    if (!del(name)) {
	console::output("File '%s' not found\n", name);
    }
}

void directory::type(const char* name) const
{
    ref<text> tp = get(name);
    if (tp.is_nil()) { 
	console::output("File '%s' not found\n", name);
    } else { 
	tp->play();
    }
}

boolean print_entry_name(const char* name, ref<object>)
{
    console::output("\t%s\n", name);
    return False;
}

void directory::list() const
{
    apply(print_entry_name);
    console::output("Total %lu entries\n", n_elems);
}

field_descriptor& directory::describe_components()
{
    return NO_FIELDS; 
}

REGISTER(directory, hash_table, pessimistic_repeatable_read_scheme);



main() 
{ 
    const int buf_size = 256;
    char buf[buf_size];
    char cmd[buf_size]; 
    char input_file[buf_size]; 
    char output_file[buf_size];

    task::initialize(task::normal_stack);
    database db;

    if (db.open("blob.cfg")) { 
	ref<directory> dir;
	db.get_root(dir);
	dir->initialize();
	
	console::output(">");
	while (console::input(buf, sizeof buf)) { 
	    *input_file = '\0';
	    *output_file = '\0';
	    if (sscanf(buf, "%s%s%s", cmd, input_file, output_file) >= 1) {
		if (stricmp(cmd, "put") == 0) { 
		    if (!*input_file) { 
			console::output("Input file was not specified\n");
		    } else { 
			modify(dir)->insert(input_file);
		    }
		} else if (stricmp(cmd, "del") == 0) { 
		    if (!*input_file) { 
			console::output("File name was not specified\n");
		    } else { 
			modify(dir)->remove(input_file);
		    }
		} else if (stricmp(cmd, "get") == 0) { 
		    if (!*input_file) { 
			console::output("Input file was not specified\n");
		    } else { 
			if (*output_file) { 
			    FILE* out = fopen(output_file, "w");
			    if (out == NULL) { 
				console::output("Failed to open output file "
						"'%s'\n", output_file);
			    } else { 
				text::output = out;
				dir->type(input_file);
				fclose(out);
			    }
			} else { 
			    text::output = stdout;
			    dir->type(input_file);
			}
		    }
		} else if (stricmp(cmd, "dir") == 0) {
		    dir->list();
		} else if (stricmp(cmd, "exit") == 0) {
		    break;
		} else { 
		    console::output("Commands:\n"
				    "  exit\n"
				    "  dir\n"
				    "  del file_name\n"
				    "  put input_file_name\n"
				    "  get input_file_name [output_file_name]\n");
		}
	    }
	    console::output(">");
	}
	db.close();
	console::output("Database session finished\n");
	return EXIT_SUCCESS;
    } else { 
	console::output("Failed to open database\n");
	return EXIT_FAILURE;
    }
}
