#include "goods.h"

class my_class : public object {
  public: 
    ...
    /* for example:
       int  x;
       int  y;
       char s[8];
    */  	
    METACLASS_DECLARATIONS(my_class, object);
  
    my_class() : object(self_class) 
    {
	...
    }
};

class my_root : public object {
  public: 
    ...
    METACLASS_DECLARATIONS(my_root, object);
  
    my_root() : object(self_class) 
    {
	...
    }
    void initialize() const { 
	if (is_abstract_root()) { 
	    ref<my_root> root = this;
	    modify(root)->become(new my_root);
	} 
    }
};
	
field_descriptor& my_class::describe_components()
{
    return ...;
    /* for example: return FIELD(x), FIELD(y), ARRAY(s); */
}

field_descriptor& my_root::describe_components()
{
    return ...;
}

REGISTER(my_class,                       // class name 
	object,                          // base class
	optimistic_scheme/*for example*/ // metaobject
);

REGISTER(my_root, // class name 
	object,    // base class
	pessimistic_repeatable_read_scheme // metaobject
);



int main(int argc, char* argv[]) 
{
    task::initialize(task::huge_stack);
    database db;

    char* cfg_name = new char[strlen(argv[1])+5];
    sprintf(cfg_name, "%s.cfg", argv[1]);

    if (db.open(cfg_name)) { 
	ref<my_root> root;
	db.get_root(root);
	root->initialize();
	
	... // do something with database 
	
	db.close();
	return EXIT_SUCCESS;
    } else { 
	console::error("Database not found\n");
	return EXIT_FAILURE;
    }
}

