//-< SPAWN.CXX >-----------------------------------------------------*--------*
// GOODS                     Version 1.0         (c) 1997  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
//                                                                   *  /  \  *
//                          Created:      7-Jun-97    K.A. Knizhnik  * / [] \ *
//                          Last update: 17-Oct-97    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Test program to simulate paralell client processes
//-------------------------------------------------------------------*--------*

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#ifndef _WIN32
#include <unistd.h>
#include <sys/wait.h>
#endif

char* process_name;

#ifdef _WIN32
#include <windows.h>
#include <process.h>
HANDLE proc_sem;


void error_msg(char* text)
{
    char buf[256];
    FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, 
    	          NULL, GetLastError(), 0, 
    	          buf, sizeof buf, NULL);
    fprintf(stderr, "%s: %s\n", text, buf);
}


void __cdecl run_process(void* arg) { 
    char id[16];
    sprintf(id, "%d", (int)arg);

    int rc = _spawnlp(_P_WAIT, process_name, process_name, id, NULL);
    if (rc < 0) { 
	perror("spawnlp");
    } else if (rc != 0) { 
	fprintf(stderr, "Child terminated with code %d\n", rc);
    }
    ReleaseSemaphore(proc_sem, 1, NULL);
}

inline int wait(int* status) {
    *status = 0;
    return WaitForSingleObject(proc_sem, INFINITE) == WAIT_OBJECT_0 
	? 0 : -1;
}

#define	WEXITSTATUS(status) (status)

#endif


void run(int n) 
{
#ifndef _WIN32
    int rc = fork();
    if (rc < 0) { 
	perror("fork");
	exit(1);
    }
    if (rc == 0) { 
	char id[16];
	sprintf(id, "%d", n);
	if (execlp (process_name, process_name, id, NULL) < 0) { 
	    perror("execlp");
	}
    }
#elif defined(_WIN32)
    _beginthread(run_process, 0, (void*)n);
#endif
}

main(int argc, char* argv[]) 
{
    int i, n_iter, n_par;
    time_t start_time = time(NULL);

    if (argc != 4) { 
	fputs("Parallel execution initiator.\n"
	      "Usage: start <number-of-iterations> "
	      "<number-of-concurrent-processes> <command>", stderr);
	return 1;
    }
    n_iter = atoi(argv[1]);    
    n_par = atoi(argv[2]);
    process_name = argv[3];

#ifdef _WIN32
    proc_sem = CreateSemaphore(NULL, 0, n_par, NULL);
#endif

    if (n_par > n_iter) { 
	n_par = n_iter;
    }
    for (i = 0; i < n_par; i++) { 
	run(i);
    }
    while (n_iter > 0) { 
	int status;
	int pid;
	if ((pid = wait(&status)) < 0) { 
	    perror("wait");
	    return 1;
	}
	if (WEXITSTATUS(status) != 0) { 
	    fprintf(stderr, "Child terminated with code %d\n", 
		    WEXITSTATUS(status));
	    return 1;
	}
	if (--n_iter >= n_par) { 
	    run(i++);
	}
    }
    fprintf(stderr, "Elapsed time %d\n", (int)(time(NULL) - start_time));
    return 0;
}

